/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.transform;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.regnosys.rosetta.common.transform.TransformType;
import java.util.Objects;

public class PipelineModel {
    private final String id;
    private final String name;
    private final Transform transform;
    private final String upstreamPipelineId;
    private final Serialisation outputSerialisation;

    @JsonCreator
    public PipelineModel(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="transform") Transform transform, @JsonProperty(value="upstreamPipelineId") String upstreamPipelineId, @JsonProperty(value="outputSerialisation") Serialisation outputSerialisation) {
        this.id = id;
        this.name = name;
        this.transform = transform;
        this.upstreamPipelineId = upstreamPipelineId;
        this.outputSerialisation = outputSerialisation;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Transform getTransform() {
        return this.transform;
    }

    public String getUpstreamPipelineId() {
        return this.upstreamPipelineId;
    }

    public Serialisation getOutputSerialisation() {
        return this.outputSerialisation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PipelineModel)) {
            return false;
        }
        PipelineModel that = (PipelineModel)o;
        return Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getTransform(), that.getTransform()) && Objects.equals(this.getUpstreamPipelineId(), that.getUpstreamPipelineId()) && Objects.equals(this.getOutputSerialisation(), that.getOutputSerialisation());
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getName(), this.getTransform(), this.getUpstreamPipelineId(), this.getOutputSerialisation());
    }

    public String toString() {
        return "PipelineModel{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", transform=" + this.transform + ", upstreamPipelineId='" + this.upstreamPipelineId + '\'' + ", outputSerialisation=" + this.outputSerialisation + '}';
    }

    public static class Transform {
        private final TransformType type;
        private final String function;
        private final String inputType;
        private final String outputType;

        @JsonCreator
        public Transform(@JsonProperty(value="type") TransformType type, @JsonProperty(value="function") String function, @JsonProperty(value="inputType") String inputType, @JsonProperty(value="outputType") String outputType) {
            this.type = type;
            this.function = function;
            this.inputType = inputType;
            this.outputType = outputType;
        }

        public TransformType getType() {
            return this.type;
        }

        public String getFunction() {
            return this.function;
        }

        public String getInputType() {
            return this.inputType;
        }

        public String getOutputType() {
            return this.outputType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Transform)) {
                return false;
            }
            Transform transform = (Transform)o;
            return this.getType() == transform.getType() && Objects.equals(this.getFunction(), transform.getFunction()) && Objects.equals(this.getInputType(), transform.getInputType()) && Objects.equals(this.getOutputType(), transform.getOutputType());
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.getType(), this.getFunction(), this.getInputType(), this.getOutputType()});
        }

        public String toString() {
            return "Transform{type=" + (Object)((Object)this.type) + ", function='" + this.function + '\'' + ", inputType='" + this.inputType + '\'' + ", outputType='" + this.outputType + '\'' + '}';
        }
    }

    public static class Serialisation {
        private final Format format;
        private final String configPath;

        @JsonCreator
        public Serialisation(@JsonProperty(value="format") Format format, @JsonProperty(value="configPath") String configPath) {
            this.format = format;
            this.configPath = configPath;
        }

        public Format getFormat() {
            return this.format;
        }

        public String getConfigPath() {
            return this.configPath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Serialisation)) {
                return false;
            }
            Serialisation that = (Serialisation)o;
            return this.getFormat() == that.getFormat() && Objects.equals(this.getConfigPath(), that.getConfigPath());
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.getFormat(), this.getConfigPath()});
        }

        public String toString() {
            return "Serialisation{format=" + (Object)((Object)this.format) + ", configPath='" + this.configPath + '\'' + '}';
        }

        public static enum Format {
            JSON,
            XML;

        }
    }
}

