/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.transform;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import com.regnosys.rosetta.common.serialisation.RosettaObjectMapperCreator;
import com.regnosys.rosetta.common.transform.PipelineModel;
import com.regnosys.rosetta.common.transform.TestPackModel;
import com.regnosys.rosetta.common.transform.TransformType;
import com.regnosys.rosetta.common.util.ClassPathUtils;
import com.regnosys.rosetta.common.util.UrlUtils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class TestPackUtils {
    public static final Path PROJECTION_PATH = Paths.get(TransformType.PROJECTION.getResourcePath(), new String[0]);
    public static final Path PROJECTION_ISO20022_PATH = PROJECTION_PATH.resolve("iso-20022");
    public static final Path PROJECTION_OUTPUT_PATH = PROJECTION_ISO20022_PATH.resolve("output");
    public static final Path PROJECTION_CONFIG_PATH = PROJECTION_ISO20022_PATH.resolve("config");
    public static final Path REPORT_CONFIG_PATH = Paths.get(TransformType.REPORT.getResourcePath(), new String[0]).resolve("config");

    public static TestPackModel createTestPack(String testPackName, TransformType transformType, String formattedFunctionName, List<TestPackModel.SampleModel> sampleModels) {
        return new TestPackModel(TestPackUtils.createTestPackId(transformType, formattedFunctionName, testPackName), TestPackUtils.createPipelineId(transformType, formattedFunctionName), testPackName, sampleModels);
    }

    private static String createTestPackId(TransformType transformType, String formattedFunctionName, String testPackName) {
        return String.format("test-pack-%s-%s-%s", transformType.name().toLowerCase(), formattedFunctionName, testPackName.replace(" ", "-").toLowerCase());
    }

    private static String createPipelineId(TransformType transformType, String formattedFunctionName) {
        return String.format("pipeline-%s-%s", transformType.name().toLowerCase(), formattedFunctionName);
    }

    public static PipelineModel createPipeline(TransformType transformType, String functionQualifiedName, String displayName, String formattedFunctionName, String inputType, String outputType, String upstreamPipelineId, PipelineModel.Serialisation outputSerialisation) {
        return new PipelineModel(TestPackUtils.createPipelineId(transformType, formattedFunctionName), displayName, new PipelineModel.Transform(transformType, functionQualifiedName, inputType, outputType), upstreamPipelineId, outputSerialisation);
    }

    public static List<PipelineModel> getPipelineModels(Path resourcePath, ClassLoader classLoader, ObjectMapper jsonObjectMapper) {
        List<URL> pipelineFiles = TestPackUtils.findPaths(resourcePath, classLoader, "pipeline-.*\\.json");
        List<PipelineModel> pipelineModels = pipelineFiles.stream().map(url -> TestPackUtils.readFile(url, jsonObjectMapper, PipelineModel.class)).collect(Collectors.toList());
        return pipelineModels;
    }

    public static PipelineModel getPipelineModel(List<PipelineModel> pipelineModels, String functionName) {
        return pipelineModels.stream().filter(p -> p.getTransform().getFunction().equals(functionName)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("No PipelineModel found with function name %s", functionName)));
    }

    public static List<TestPackModel> getTestPackModels(Path resourcePath, ClassLoader classLoader, ObjectMapper jsonObjectMapper) {
        List<URL> testPackUrls = TestPackUtils.findPaths(resourcePath, classLoader, "test-pack-.*\\.json");
        return testPackUrls.stream().map(url -> TestPackUtils.readFile(url, jsonObjectMapper, TestPackModel.class)).collect(Collectors.toList());
    }

    public static List<TestPackModel> getTestPackModels(List<TestPackModel> testPackModels, String pipelineId) {
        return testPackModels.stream().filter(testPackModel -> testPackModel.getPipelineId() != null).filter(testPackModel -> testPackModel.getPipelineId().equals(pipelineId)).collect(Collectors.toList());
    }

    public static Optional<ObjectWriter> getObjectWriter(PipelineModel.Serialisation outputSerialisation) {
        if (outputSerialisation != null && outputSerialisation.getFormat() == PipelineModel.Serialisation.Format.XML) {
            URL xmlConfigPath = Resources.getResource((String)outputSerialisation.getConfigPath());
            try {
                return Optional.of(RosettaObjectMapperCreator.forXML(xmlConfigPath.openStream()).create().writerWithDefaultPrettyPrinter());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return Optional.empty();
    }

    public static String getProjectionTestPackName(String reportId) {
        return "test-pack-projection-" + reportId + "-report-to-iso20022.*\\.json";
    }

    public static String getReportTestPackName(String reportId) {
        return "test-pack-report-" + reportId + ".*\\.json";
    }

    public static List<URL> findPaths(Path basePath, ClassLoader classLoader, String fileName) {
        List expectations = ClassPathUtils.findPathsFromClassPath(Arrays.asList(UrlUtils.toPortableString(basePath)), fileName, Optional.empty(), classLoader).stream().map(UrlUtils::toUrl).collect(Collectors.toList());
        return ImmutableList.copyOf(expectations);
    }

    public static <T> T readFile(URL u, ObjectMapper mapper, Class<T> clazz) {
        try {
            return (T)mapper.readValue(UrlUtils.openURL(u), clazz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

