/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.transform;

import java.util.function.Function;

public enum TransformType {
    TRANSLATE("translate", "TBD"),
    PROJECTION("projection", "projections.%sProjectionTabulator"),
    REPORT("regulatory-reporting", "reports.%sReportTabulator", TransformType.stripReportFunctionName()),
    ENRICH("enrich", null);

    private final String resourcePath;
    private final String tabulatorName;
    private final Function<String, String> transformFunctionName;

    private TransformType(String resourcePath, String tabulatorName) {
        this.resourcePath = resourcePath;
        this.tabulatorName = tabulatorName;
        this.transformFunctionName = Function.identity();
    }

    private TransformType(String resourcePath, String tabulatorName, Function<String, String> transformFunctionName) {
        this.resourcePath = resourcePath;
        this.tabulatorName = tabulatorName;
        this.transformFunctionName = transformFunctionName;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public String getTabulatorName(String functionName) {
        return String.format(this.tabulatorName, this.transformFunctionName.apply(functionName));
    }

    private static Function<String, String> stripReportFunctionName() {
        return functionName -> functionName.replaceAll("ReportFunction$", "");
    }
}

