/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.util;

import com.regnosys.rosetta.common.util.SimpleProcessor;
import com.rosetta.lib.postprocess.PostProcessorReport;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.PostProcessStep;
import com.rosetta.model.lib.process.Processor;
import java.util.ArrayList;
import java.util.List;

public class RosettaObjectCollectorProcessStep<B extends RosettaModelObject>
implements PostProcessStep {
    private final Class<B> collectRosettaType;

    public RosettaObjectCollectorProcessStep(Class<B> collectRosettaType) {
        this.collectRosettaType = collectRosettaType;
    }

    public Integer getPriority() {
        return 3;
    }

    public String getName() {
        return "RosettaObjectCollector postProcessor";
    }

    public <T extends RosettaModelObject> RosettaObjectCollectorProcessReport<B> runProcessStep(Class<? extends T> topClass, T instance) {
        ArrayList collectedObjects = new ArrayList();
        RosettaObjectCollectorProcess<B> process = new RosettaObjectCollectorProcess<B>(this.collectRosettaType, collectedObjects);
        RosettaPath path = RosettaPath.valueOf((String)topClass.getSimpleName());
        process.processRosetta(path, topClass, instance, null, new AttributeMeta[0]);
        instance.process(path, process);
        return new RosettaObjectCollectorProcessReport(instance, collectedObjects);
    }

    private static class RosettaObjectCollectorProcess<X extends RosettaModelObject>
    extends SimpleProcessor {
        private final Class<X> collectObjectType;
        private final List<X> collectedObjects;

        RosettaObjectCollectorProcess(Class<X> collectObjectType, List<X> collectedObjects) {
            this.collectObjectType = collectObjectType;
            this.collectedObjects = collectedObjects;
        }

        public <R extends RosettaModelObject> boolean processRosetta(RosettaPath path, Class<? extends R> rosettaType, R instance, RosettaModelObject parent, AttributeMeta ... metas) {
            if (instance == null) {
                return false;
            }
            if (this.collectObjectType.isInstance(instance)) {
                this.collectedObjects.add((RosettaModelObject)this.collectObjectType.cast(instance));
            }
            return true;
        }

        public Processor.Report report() {
            return null;
        }
    }

    public static class RosettaObjectCollectorProcessReport<C extends RosettaModelObject>
    implements PostProcessorReport,
    Processor.Report {
        private final RosettaModelObject topClass;
        private final List<C> collectedObjects;

        RosettaObjectCollectorProcessReport(RosettaModelObject topClass, List<C> collectedObjects) {
            this.topClass = topClass;
            this.collectedObjects = collectedObjects;
        }

        public RosettaModelObject getResultObject() {
            return this.topClass;
        }

        public List<C> getCollectedObjects() {
            return this.collectedObjects;
        }
    }
}

