/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.model.lib.meta;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.meta.BasicRosettaMetaData;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;

@RosettaDataType(value="Reference", builder=ReferenceBuilderImpl.class)
public interface Reference
extends RosettaModelObject {
    public static final RosettaMetaData<Reference> meta = new BasicRosettaMetaData<Reference>();

    @Override
    public Reference build();

    @Override
    public ReferenceBuilder toBuilder();

    public String getScope();

    public String getPointsTo();

    public String getReference();

    @Override
    default public RosettaMetaData<? extends RosettaModelObject> metaData() {
        return meta;
    }

    public static ReferenceBuilderImpl builder() {
        return new ReferenceBuilderImpl();
    }

    default public Class<Reference> getType() {
        return Reference.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
    }

    public static class ReferenceBuilderImpl
    implements ReferenceBuilder {
        private String scope;
        private String pointsTo;
        private String reference;

        @Override
        @RosettaAttribute(value="scope")
        public String getScope() {
            return this.scope;
        }

        @Override
        public String getPointsTo() {
            return this.pointsTo;
        }

        @Override
        @RosettaAttribute(value="value")
        public String getReference() {
            return this.reference;
        }

        @Override
        public Reference build() {
            return new ReferenceImpl(this.scope, this.pointsTo, this.reference);
        }

        @Override
        @RosettaAttribute(value="value")
        public ReferenceBuilder setReference(String reference) {
            this.reference = reference;
            return this;
        }

        @Override
        public ReferenceBuilder setPointsTo(String pointsTo) {
            this.pointsTo = pointsTo;
            return this;
        }

        @Override
        @RosettaAttribute(value="scope")
        public ReferenceBuilder setScope(String scope) {
            this.scope = scope;
            return this;
        }

        public ReferenceBuilder prune() {
            return this;
        }

        public ReferenceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ReferenceBuilder o = (ReferenceBuilder)other;
            merger.mergeBasic(this.getScope(), o.getScope(), this::setScope, new AttributeMeta[0]);
            merger.mergeBasic(this.getPointsTo(), o.getPointsTo(), this::setPointsTo, new AttributeMeta[0]);
            merger.mergeBasic(this.getReference(), o.getReference(), this::setReference, new AttributeMeta[0]);
            return this;
        }

        @Override
        public ReferenceBuilder toBuilder() {
            return this;
        }

        @Override
        public boolean hasData() {
            return this.getReference() != null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.pointsTo == null ? 0 : this.pointsTo.hashCode());
            result = 31 * result + (this.reference == null ? 0 : this.reference.hashCode());
            result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ReferenceBuilder other = (ReferenceBuilder)obj;
            if (this.pointsTo == null ? other.getPointsTo() != null : !this.pointsTo.equals(other.getPointsTo())) {
                return false;
            }
            if (this.reference == null ? other.getReference() != null : !this.reference.equals(other.getReference())) {
                return false;
            }
            return !(this.scope == null ? other.getScope() != null : !this.scope.equals(other.getScope()));
        }
    }

    public static interface ReferenceBuilder
    extends Reference,
    RosettaModelObjectBuilder {
        public ReferenceBuilder setScope(String var1);

        public ReferenceBuilder setPointsTo(String var1);

        public ReferenceBuilder setReference(String var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
        }
    }

    public static class ReferenceImpl
    implements Reference {
        private final String scope;
        private final String pointsTo;
        private final String reference;

        public ReferenceImpl(String scope, String pointsTo, String reference) {
            this.scope = scope;
            this.pointsTo = pointsTo;
            this.reference = reference;
        }

        @Override
        @RosettaAttribute(value="scope")
        public String getScope() {
            return this.scope;
        }

        @Override
        public String getPointsTo() {
            return this.pointsTo;
        }

        @Override
        @RosettaAttribute(value="value")
        public String getReference() {
            return this.reference;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.pointsTo == null ? 0 : this.pointsTo.hashCode());
            result = 31 * result + (this.reference == null ? 0 : this.reference.hashCode());
            result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Reference other = (Reference)obj;
            if (this.pointsTo == null ? other.getPointsTo() != null : !this.pointsTo.equals(other.getPointsTo())) {
                return false;
            }
            if (this.reference == null ? other.getReference() != null : !this.reference.equals(other.getReference())) {
                return false;
            }
            return !(this.scope == null ? other.getScope() != null : !this.scope.equals(other.getScope()));
        }

        @Override
        public ReferenceBuilder toBuilder() {
            return new ReferenceBuilderImpl().setScope(this.scope).setPointsTo(this.pointsTo).setReference(this.reference);
        }

        @Override
        public void process(RosettaPath path, Processor processor) {
        }

        @Override
        public Reference build() {
            return this;
        }
    }
}

