/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.model.lib.reports;

import com.rosetta.model.lib.ModelSymbolId;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;

public interface Tabulator<T> {
    public List<Field> getFields();

    public List<FieldValue> tabulate(T var1);

    public static class MultiNestedFieldValueImpl
    implements MultiNestedFieldValue {
        private Field field;
        private Optional<? extends List<? extends List<? extends FieldValue>>> value;

        public MultiNestedFieldValueImpl(Field field, Optional<? extends List<? extends List<? extends FieldValue>>> value) {
            Objects.requireNonNull(field);
            Objects.requireNonNull(value);
            value.ifPresent(vs -> {
                Validate.noNullElements((Iterable)vs);
                vs.forEach(v -> Validate.noNullElements((Iterable)v));
            });
            this.field = field;
            this.value = value;
        }

        @Override
        public Field getField() {
            return this.field;
        }

        @Override
        public Optional<? extends List<? extends List<? extends FieldValue>>> getValue() {
            return this.value;
        }

        public String toString() {
            String valueRepr = this.value.map(vs -> vs.stream().map(v -> v.stream().map(Object::toString).collect(Collectors.joining(", ", "{", "}"))).collect(Collectors.joining(", ", "[", "]"))).orElse("<empty>");
            return "<" + this.field.getName() + ", " + valueRepr + ">";
        }

        public int hashCode() {
            return Objects.hash(this.field, this.value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MultiNestedFieldValueImpl other = (MultiNestedFieldValueImpl)obj;
            return Objects.equals(this.field, other.field) && Objects.equals(this.value, other.value);
        }
    }

    public static class NestedFieldValueImpl
    implements NestedFieldValue {
        private Field field;
        private Optional<? extends List<? extends FieldValue>> value;

        public NestedFieldValueImpl(Field field, Optional<? extends List<? extends FieldValue>> value) {
            Objects.requireNonNull(field);
            Objects.requireNonNull(value);
            value.ifPresent(vs -> Validate.noNullElements((Iterable)vs));
            this.field = field;
            this.value = value;
        }

        @Override
        public Field getField() {
            return this.field;
        }

        @Override
        public Optional<? extends List<? extends FieldValue>> getValue() {
            return this.value;
        }

        public String toString() {
            String valueRepr = this.value.map(vs -> vs.stream().map(Object::toString).collect(Collectors.joining(", ", "{", "}"))).orElse("<empty>");
            return "<" + this.field.getName() + ", " + valueRepr + ">";
        }

        public int hashCode() {
            return Objects.hash(this.field, this.value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NestedFieldValueImpl other = (NestedFieldValueImpl)obj;
            return Objects.equals(this.field, other.field) && Objects.equals(this.value, other.value);
        }
    }

    public static class FieldValueImpl
    implements FieldValue {
        private Field field;
        private Optional<? extends Object> value;

        public FieldValueImpl(Field field, Optional<? extends Object> value) {
            Objects.requireNonNull(field);
            Objects.requireNonNull(value);
            this.field = field;
            this.value = value;
        }

        @Override
        public Field getField() {
            return this.field;
        }

        @Override
        public Optional<? extends Object> getValue() {
            return this.value;
        }

        public String toString() {
            return "<" + this.field.getName() + ", " + this.value.map(Object::toString).orElse("<empty>") + ">";
        }

        public int hashCode() {
            return Objects.hash(this.field, this.value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FieldValueImpl other = (FieldValueImpl)obj;
            return Objects.equals(this.field, other.field) && Objects.equals(this.value, other.value);
        }
    }

    public static class FieldImpl
    implements Field {
        private String attributeName;
        private boolean isMulti;
        private Optional<ModelSymbolId> ruleId;
        private Optional<String> identifier;
        private List<Field> children;

        public FieldImpl(String attributeName, boolean isMulti, Optional<ModelSymbolId> ruleId, Optional<String> identifier, List<Field> children) {
            Objects.requireNonNull(ruleId);
            Objects.requireNonNull(attributeName);
            Objects.requireNonNull(identifier);
            Validate.noNullElements(children);
            this.ruleId = ruleId;
            this.attributeName = attributeName;
            this.isMulti = isMulti;
            this.identifier = identifier;
            this.children = children;
        }

        @Override
        public String getName() {
            return this.identifier.orElse(this.attributeName);
        }

        @Override
        public String getAttributeName() {
            return this.attributeName;
        }

        @Override
        public boolean isMulti() {
            return this.isMulti;
        }

        public Optional<ModelSymbolId> getRuleId() {
            return this.ruleId;
        }

        @Override
        public List<Field> getChildren() {
            return this.children;
        }

        public int hashCode() {
            return Objects.hash(this.attributeName, this.children, this.identifier, this.isMulti, this.ruleId);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FieldImpl other = (FieldImpl)obj;
            return Objects.equals(this.attributeName, other.attributeName) && Objects.equals(this.children, other.children) && Objects.equals(this.identifier, other.identifier) && this.isMulti == other.isMulti && Objects.equals(this.ruleId, other.ruleId);
        }
    }

    public static interface FieldValueVisitor<C> {
        public void visitSingle(FieldValue var1, C var2);

        public void visitNested(NestedFieldValue var1, C var2);

        public void visitMultiNested(MultiNestedFieldValue var1, C var2);
    }

    public static interface MultiNestedFieldValue
    extends FieldValue {
        public Optional<? extends List<? extends List<? extends FieldValue>>> getValue();

        @Override
        default public <C> void accept(FieldValueVisitor<C> visitor, C context) {
            visitor.visitMultiNested(this, context);
        }
    }

    public static interface NestedFieldValue
    extends FieldValue {
        public Optional<? extends List<? extends FieldValue>> getValue();

        @Override
        default public <C> void accept(FieldValueVisitor<C> visitor, C context) {
            visitor.visitNested(this, context);
        }
    }

    public static interface FieldValue {
        public Field getField();

        public Optional<? extends Object> getValue();

        default public boolean isPresent() {
            return this.getValue().isPresent();
        }

        default public <C> void accept(FieldValueVisitor<C> visitor, C context) {
            visitor.visitSingle(this, context);
        }
    }

    public static interface Field {
        public String getName();

        public String getAttributeName();

        public List<Field> getChildren();

        public boolean isMulti();
    }
}

