/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.util.serialisation;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.rosetta.model.lib.ModelSymbolId;
import com.rosetta.util.serialisation.TypeXMLConfiguration;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;

public class RosettaXMLConfiguration {
    @JsonAnyGetter
    private final SortedMap<ModelSymbolId, TypeXMLConfiguration> typeConfigMap;

    public RosettaXMLConfiguration(Map<ModelSymbolId, TypeXMLConfiguration> typeConfigMap) {
        this.typeConfigMap = new TreeMap<ModelSymbolId, TypeXMLConfiguration>(typeConfigMap);
    }

    public Optional<TypeXMLConfiguration> getConfigurationForType(ModelSymbolId symbolId) {
        return Optional.ofNullable((TypeXMLConfiguration)this.typeConfigMap.get(symbolId));
    }

    public int hashCode() {
        return Objects.hash(this.typeConfigMap);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RosettaXMLConfiguration other = (RosettaXMLConfiguration)obj;
        return Objects.equals(this.typeConfigMap, other.typeConfigMap);
    }

    @JsonCreator
    private RosettaXMLConfiguration() {
        this(Collections.emptyMap());
    }

    @JsonAnySetter
    private void add(String qualifiedName, TypeXMLConfiguration config) {
        this.typeConfigMap.put(ModelSymbolId.fromQualifiedName(qualifiedName), config);
    }
}

