/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.util.types;

import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.JavaReferenceType;
import com.rosetta.util.types.JavaType;
import com.rosetta.util.types.JavaTypeVariable;
import com.rosetta.util.types.JavaTypeVisitor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import java.util.Objects;

public class JavaArrayType
implements JavaReferenceType {
    private final JavaType baseType;

    public JavaArrayType(JavaType baseType) {
        Objects.requireNonNull(baseType);
        this.baseType = baseType;
    }

    public static JavaArrayType from(Type t, Map<TypeVariable<?>, JavaTypeVariable> context) {
        if (t instanceof Class) {
            Class c = (Class)t;
            if (!c.isArray()) {
                return null;
            }
            return new JavaArrayType(JavaType.from(c.getComponentType(), context));
        }
        if (t instanceof GenericArrayType) {
            GenericArrayType at = (GenericArrayType)t;
            return new JavaArrayType(JavaType.from(at.getGenericComponentType(), context));
        }
        return null;
    }

    public JavaType getBaseType() {
        return this.baseType;
    }

    public String toString() {
        return this.baseType.toString() + "[]";
    }

    @Override
    public String getSimpleName() {
        return this.baseType.getSimpleName();
    }

    @Override
    public boolean isSubtypeOf(JavaType other) {
        JavaType otherBaseType;
        if (other.equals(JavaClass.OBJECT) || other.equals(JavaClass.CLONEABLE) || other.equals(JavaClass.SERIALIZABLE)) {
            return true;
        }
        if (other instanceof JavaArrayType && this.baseType instanceof JavaReferenceType && (otherBaseType = ((JavaArrayType)other).getBaseType()) instanceof JavaReferenceType) {
            return this.baseType.isSubtypeOf(otherBaseType);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.baseType);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JavaArrayType other = (JavaArrayType)object;
        return Objects.equals(this.baseType, other.baseType);
    }

    @Override
    public void accept(JavaTypeVisitor visitor) {
        visitor.visitType(this);
    }
}

