/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.util.types;

import com.fasterxml.jackson.core.type.TypeReference;
import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.JavaParameterizedType;
import com.rosetta.util.types.JavaTypeArgument;
import com.rosetta.util.types.JavaTypeDeclaration;
import com.rosetta.util.types.JavaTypeVariable;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public abstract class JavaGenericTypeDeclaration<T>
implements JavaTypeDeclaration<T> {
    public static <T> JavaGenericTypeDeclaration<T> from(Class<T> c) {
        return new JavaGenericTypeDeclarationImpl<T>(c);
    }

    public static <T> JavaGenericTypeDeclaration<T> from(TypeReference<T> typeRef) {
        return JavaGenericTypeDeclaration.from(JavaParameterizedType.extractRawClass(typeRef.getType()));
    }

    public abstract JavaClass<T> getBaseType();

    public abstract List<JavaTypeVariable> getParameters();

    public abstract JavaClass<? super T> getSuperclass();

    public abstract List<JavaClass<?>> getInterfaces();

    @Override
    public JavaParameterizedType<T> applySubstitution(Map<JavaTypeVariable, JavaTypeArgument> substitution) {
        return JavaParameterizedType.from(this, this.getParameters().stream().map(p -> {
            if (!substitution.containsKey(p)) {
                throw new IllegalArgumentException("Substitution must contain a key for " + p + ".");
            }
            return (JavaTypeArgument)substitution.get(p);
        }).collect(Collectors.toList()));
    }

    public String toString() {
        return this.getBaseType().toString() + "<" + this.getParameters().stream().map(Object::toString).collect(Collectors.joining(", ")) + ">";
    }

    public int hashCode() {
        return Objects.hash(this.getBaseType(), this.getParameters());
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JavaGenericTypeDeclaration other = (JavaGenericTypeDeclaration)object;
        return Objects.equals(this.getBaseType(), other.getBaseType()) && Objects.equals(this.getParameters(), other.getParameters());
    }

    protected static class JavaGenericTypeDeclarationImpl<T>
    extends JavaGenericTypeDeclaration<T> {
        private final Class<T> backingClass;
        private final JavaClass<T> baseType;
        private final List<JavaTypeVariable> parameters;
        private final Map<TypeVariable<?>, JavaTypeVariable> parameterMap;

        public JavaGenericTypeDeclarationImpl(Class<T> backingClass) {
            this.backingClass = backingClass;
            this.baseType = JavaClass.from(backingClass);
            this.parameters = new ArrayList<JavaTypeVariable>();
            this.parameterMap = new HashMap();
            for (TypeVariable<Class<T>> tp : backingClass.getTypeParameters()) {
                JavaTypeVariable result = JavaTypeVariable.from(this, tp, this.parameterMap);
                this.parameters.add(result);
                this.parameterMap.put(tp, result);
            }
        }

        public Class<T> getBackingClass() {
            return this.backingClass;
        }

        @Override
        public JavaClass<T> getBaseType() {
            return this.baseType;
        }

        @Override
        public List<JavaTypeVariable> getParameters() {
            return this.parameters;
        }

        @Override
        public JavaTypeDeclaration<? super T> getSuperclassDeclaration() {
            Class<T> superclass = this.backingClass.getSuperclass();
            if (superclass == null) {
                return JavaClass.OBJECT;
            }
            return JavaTypeDeclaration.from(superclass);
        }

        @Override
        public JavaClass<? super T> getSuperclass() {
            JavaTypeDeclaration<T> superDeclaration = this.getSuperclassDeclaration();
            if (superDeclaration == null) {
                return null;
            }
            if (superDeclaration instanceof JavaClass) {
                return (JavaClass)superDeclaration;
            }
            return JavaClass.from(this.backingClass.getSuperclass(), this.backingClass.getGenericSuperclass(), this.parameterMap);
        }

        @Override
        public List<JavaTypeDeclaration<?>> getInterfaceDeclarations() {
            return Arrays.stream(this.backingClass.getInterfaces()).map(i -> JavaTypeDeclaration.from(i)).collect(Collectors.toList());
        }

        @Override
        public List<JavaClass<?>> getInterfaces() {
            ArrayList result = new ArrayList();
            Class<?>[] interfaces = this.backingClass.getInterfaces();
            Type[] genericInterfaces = this.backingClass.getGenericInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                JavaTypeDeclaration<?> decl = JavaTypeDeclaration.from(interfaces[i]);
                if (decl instanceof JavaClass) {
                    result.add((JavaClass)decl);
                    continue;
                }
                result.add(JavaClass.from(interfaces[i], genericInterfaces[i], this.parameterMap));
            }
            return result;
        }

        @Override
        public boolean extendsDeclaration(JavaTypeDeclaration<?> other) {
            if (other.equals(JavaClass.OBJECT)) {
                return true;
            }
            if (other instanceof JavaGenericTypeDeclarationImpl) {
                return ((JavaGenericTypeDeclarationImpl)other).getBackingClass().isAssignableFrom(this.backingClass);
            }
            if (other instanceof JavaClass.JavaClassImpl) {
                return ((JavaClass.JavaClassImpl)other).getBackingClass().isAssignableFrom(this.backingClass);
            }
            if (other instanceof JavaParameterizedType) {
                return this.extendsDeclaration(((JavaParameterizedType)other).getGenericTypeDeclaration());
            }
            return false;
        }

        @Override
        public Class<T> loadClass(ClassLoader classLoader) throws ClassNotFoundException {
            return this.backingClass;
        }

        @Override
        public boolean isFinal() {
            return Modifier.isFinal(this.backingClass.getModifiers()) || this.backingClass.isEnum();
        }
    }
}

