/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.model.lib.records;

import com.rosetta.model.lib.records.Date;
import java.time.LocalDate;

public class DateImpl
implements Date {
    private final int day;
    private final int month;
    private final int year;

    protected DateImpl(int year, int month, int day) {
        this.year = year;
        this.month = month;
        this.day = day;
    }

    public DateImpl(LocalDate localDate) {
        this.year = localDate.getYear();
        this.month = localDate.getMonthValue();
        this.day = localDate.getDayOfMonth();
    }

    @Override
    public int getDay() {
        return this.day;
    }

    @Override
    public int getMonth() {
        return this.month;
    }

    @Override
    public int getYear() {
        return this.year;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.day;
        result = 31 * result + this.month;
        result = 31 * result + this.year;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DateImpl other = (DateImpl)obj;
        if (this.day != other.day) {
            return false;
        }
        if (this.month != other.month) {
            return false;
        }
        return this.year == other.year;
    }

    public String toString() {
        return this.toLocalDate().toString();
    }

    @Override
    public LocalDate toLocalDate() {
        return LocalDate.of(this.year, this.month, this.day);
    }

    @Override
    public int compareTo(Date o) {
        return this.toLocalDate().compareTo(o.toLocalDate());
    }

    public static Date of(int year, int month, int dayOfMonth) {
        return new DateImpl(year, month, dayOfMonth);
    }
}

