/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.util.types;

import com.rosetta.util.types.JavaArrayType;
import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.JavaParameterizedType;
import com.rosetta.util.types.JavaPrimitiveType;
import com.rosetta.util.types.JavaReferenceType;
import com.rosetta.util.types.JavaTypeVariable;
import com.rosetta.util.types.JavaTypeVisitor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.Map;

public interface JavaType {
    public static <T> JavaType from(Type t) {
        return JavaType.from(t, Collections.emptyMap());
    }

    public static <T> JavaType from(Type t, Map<TypeVariable<?>, JavaTypeVariable> context) {
        if (t instanceof Class) {
            Class c = (Class)t;
            if (c.isArray()) {
                return JavaArrayType.from(c, context);
            }
            if (c.isPrimitive()) {
                return JavaPrimitiveType.from(c);
            }
            return JavaClass.from(c);
        }
        if (t instanceof GenericArrayType) {
            return JavaArrayType.from(t, context);
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            return JavaParameterizedType.from((Class)pt.getRawType(), pt, Collections.emptyMap());
        }
        if (t instanceof TypeVariable) {
            return JavaTypeVariable.from((TypeVariable)t, Collections.emptyMap());
        }
        return null;
    }

    public static JavaType from(Object obj) {
        return JavaType.from(obj, Collections.emptyMap());
    }

    public static JavaType from(Object obj, Map<TypeVariable<?>, JavaTypeVariable> context) {
        if (obj instanceof JavaType) {
            return (JavaType)obj;
        }
        if (obj instanceof Type) {
            return JavaType.from((Type)obj, context);
        }
        return null;
    }

    public boolean isSubtypeOf(JavaType var1);

    public JavaReferenceType toReferenceType();

    public String getSimpleName();

    public void accept(JavaTypeVisitor var1);

    default public JavaType getTypeErasure() {
        return this;
    }
}

