package com.regnosys.rosetta;

import com.google.common.base.CaseFormat;
import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.regnosys.rosetta.generator.object.ExpandedAttribute;
import com.regnosys.rosetta.generator.util.RosettaAttributeExtensions;
import com.regnosys.rosetta.rosetta.RosettaEnumValue;
import com.regnosys.rosetta.rosetta.RosettaEnumeration;
import com.regnosys.rosetta.rosetta.RosettaExternalRuleSource;
import com.regnosys.rosetta.rosetta.RosettaFeature;
import com.regnosys.rosetta.rosetta.RosettaRecordType;
import com.regnosys.rosetta.rosetta.RosettaReport;
import com.regnosys.rosetta.rosetta.RosettaRule;
import com.regnosys.rosetta.rosetta.RosettaSynonym;
import com.regnosys.rosetta.rosetta.RosettaType;
import com.regnosys.rosetta.rosetta.expression.ChoiceOperation;
import com.regnosys.rosetta.rosetta.expression.OneOfOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaBinaryOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaConditionalExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaExpression;
import com.regnosys.rosetta.rosetta.simple.Annotated;
import com.regnosys.rosetta.rosetta.simple.Annotation;
import com.regnosys.rosetta.rosetta.simple.AnnotationRef;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Condition;
import com.regnosys.rosetta.rosetta.simple.Function;
import com.regnosys.rosetta.rosetta.simple.RosettaRuleReference;
import com.regnosys.rosetta.types.RAttribute;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.REnumType;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.builtin.RBuiltinTypeService;
import com.regnosys.rosetta.types.builtin.RRecordType;
import com.regnosys.rosetta.utils.ExternalAnnotationUtil;
import com.rosetta.model.lib.path.RosettaPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@SuppressWarnings("all")
public class RosettaExtensions {
  @Data
  public static class PathAttribute {
    private final RosettaPath path;

    private final Attribute attr;

    public PathAttribute(final RosettaPath path, final Attribute attr) {
      super();
      this.path = path;
      this.attr = attr;
    }

    @Override
    @Pure
    public int hashCode() {
      final int prime = 31;
      int result = 1;
      result = prime * result + ((this.path== null) ? 0 : this.path.hashCode());
      return prime * result + ((this.attr== null) ? 0 : this.attr.hashCode());
    }

    @Override
    @Pure
    public boolean equals(final Object obj) {
      if (this == obj)
        return true;
      if (obj == null)
        return false;
      if (getClass() != obj.getClass())
        return false;
      RosettaExtensions.PathAttribute other = (RosettaExtensions.PathAttribute) obj;
      if (this.path == null) {
        if (other.path != null)
          return false;
      } else if (!this.path.equals(other.path))
        return false;
      if (this.attr == null) {
        if (other.attr != null)
          return false;
      } else if (!this.attr.equals(other.attr))
        return false;
      return true;
    }

    @Override
    @Pure
    public String toString() {
      ToStringBuilder b = new ToStringBuilder(this);
      b.add("path", this.path);
      b.add("attr", this.attr);
      return b.toString();
    }

    @Pure
    public RosettaPath getPath() {
      return this.path;
    }

    @Pure
    public Attribute getAttr() {
      return this.attr;
    }
  }

  @Inject
  private ExternalAnnotationUtil externalAnn;

  @Inject
  private RBuiltinTypeService builtins;

  public boolean isResolved(final EObject obj) {
    return ((obj != null) && (!obj.eIsProxy()));
  }

  public Iterable<? extends RosettaFeature> allFeatures(final RType t, final EObject context) {
    Resource _eResource = null;
    if (context!=null) {
      _eResource=context.eResource();
    }
    ResourceSet _resourceSet = null;
    if (_eResource!=null) {
      _resourceSet=_eResource.getResourceSet();
    }
    return this.allFeatures(t, _resourceSet);
  }

  public Iterable<? extends RosettaFeature> allFeatures(final RType t, final ResourceSet resourceSet) {
    Iterable<? extends RosettaFeature> _switchResult = null;
    boolean _matched = false;
    if (t instanceof RDataType) {
      _matched=true;
      _switchResult = this.getAllAttributes(((RDataType)t).getData());
    }
    if (!_matched) {
      if (t instanceof REnumType) {
        _matched=true;
        _switchResult = this.getAllEnumValues(((REnumType)t).getEnumeration());
      }
    }
    if (!_matched) {
      if (t instanceof RRecordType) {
        _matched=true;
        List<? extends RosettaFeature> _xifexpression = null;
        if ((resourceSet != null)) {
          _xifexpression = this.builtins.<RosettaRecordType>toRosettaType(t, RosettaRecordType.class, resourceSet).getFeatures();
        } else {
          _xifexpression = Collections.<RosettaFeature>unmodifiableList(CollectionLiterals.<RosettaFeature>newArrayList());
        }
        _switchResult = _xifexpression;
      }
    }
    if (!_matched) {
      _switchResult = Collections.<RosettaFeature>unmodifiableList(CollectionLiterals.<RosettaFeature>newArrayList());
    }
    return _switchResult;
  }

  public Set<com.regnosys.rosetta.rosetta.simple.Data> getAllSuperTypes(final com.regnosys.rosetta.rosetta.simple.Data clazz) {
    return this.doGetSuperTypes(clazz, CollectionLiterals.<com.regnosys.rosetta.rosetta.simple.Data>newLinkedHashSet());
  }

  private Set<com.regnosys.rosetta.rosetta.simple.Data> doGetSuperTypes(final com.regnosys.rosetta.rosetta.simple.Data clazz, final Set<com.regnosys.rosetta.rosetta.simple.Data> seenClasses) {
    if (((clazz != null) && seenClasses.add(clazz))) {
      this.doGetSuperTypes(clazz.getSuperType(), seenClasses);
    }
    return seenClasses;
  }

  public Iterable<Attribute> getAllAttributes(final com.regnosys.rosetta.rosetta.simple.Data clazz) {
    final Function1<com.regnosys.rosetta.rosetta.simple.Data, EList<Attribute>> _function = (com.regnosys.rosetta.rosetta.simple.Data it) -> {
      return it.getAttributes();
    };
    return Iterables.<Attribute>concat(IterableExtensions.<com.regnosys.rosetta.rosetta.simple.Data, EList<Attribute>>map(this.getAllSuperTypes(clazz), _function));
  }

  public Set<RosettaEnumeration> getAllSuperEnumerations(final RosettaEnumeration e) {
    return this.doGetSuperEnumerations(e, CollectionLiterals.<RosettaEnumeration>newLinkedHashSet());
  }

  public List<Attribute> allNonOverridesAttributes(final com.regnosys.rosetta.rosetta.simple.Data data) {
    final ArrayList<Attribute> atts = CollectionLiterals.<Attribute>newArrayList();
    atts.addAll(data.getAttributes());
    boolean _hasSuperType = data.hasSuperType();
    if (_hasSuperType) {
      final List<Attribute> attsWithSuper = this.allNonOverridesAttributes(data.getSuperType());
      final ArrayList<Attribute> result = CollectionLiterals.<Attribute>newArrayList();
      final Consumer<Attribute> _function = (Attribute it) -> {
        final Function1<Attribute, Boolean> _function_1 = (Attribute att) -> {
          String _name = att.getName();
          String _name_1 = it.getName();
          return Boolean.valueOf(Objects.equal(_name, _name_1));
        };
        final Attribute overridenAtt = IterableExtensions.<Attribute>findFirst(atts, _function_1);
        if ((overridenAtt != null)) {
          result.add(overridenAtt);
        } else {
          result.add(it);
        }
      };
      attsWithSuper.forEach(_function);
      final Function1<Attribute, Boolean> _function_1 = (Attribute att) -> {
        boolean _contains = result.contains(att);
        return Boolean.valueOf((!_contains));
      };
      result.addAll(IterableExtensions.<Attribute>toList(IterableExtensions.<Attribute>filter(atts, _function_1)));
      return result;
    }
    return atts;
  }

  private Set<RosettaEnumeration> doGetSuperEnumerations(final RosettaEnumeration e, final Set<RosettaEnumeration> seenEnums) {
    if (((e != null) && seenEnums.add(e))) {
      this.doGetSuperEnumerations(e.getSuperType(), seenEnums);
    }
    return seenEnums;
  }

  public Iterable<RosettaEnumValue> getAllEnumValues(final RosettaEnumeration e) {
    final Function1<RosettaEnumeration, EList<RosettaEnumValue>> _function = (RosettaEnumeration it) -> {
      return it.getEnumValues();
    };
    return Iterables.<RosettaEnumValue>concat(IterableExtensions.<RosettaEnumeration, EList<RosettaEnumValue>>map(this.getAllSuperEnumerations(e), _function));
  }

  public Set<RosettaSynonym> getAllSynonyms(final RosettaSynonym s) {
    return this.doGetSynonyms(s, CollectionLiterals.<RosettaSynonym>newLinkedHashSet());
  }

  private Set<RosettaSynonym> doGetSynonyms(final RosettaSynonym s, final Set<RosettaSynonym> seenSynonyms) {
    if (((s != null) && seenSynonyms.add(s))) {
      this.doGetSynonyms(s, seenSynonyms);
    }
    return seenSynonyms;
  }

  /**
   * Collect all expressions
   */
  public void collectExpressions(final RosettaExpression expr, final Procedure1<? super RosettaExpression> visitor) {
    if ((expr instanceof RosettaBinaryOperation)) {
      if ((((RosettaBinaryOperation)expr).getOperator().equals("or") || ((RosettaBinaryOperation)expr).getOperator().equals("and"))) {
        this.collectExpressions(((RosettaBinaryOperation)expr).getLeft(), visitor);
        this.collectExpressions(((RosettaBinaryOperation)expr).getRight(), visitor);
      } else {
        visitor.apply(expr);
      }
    }
    if ((expr instanceof RosettaConditionalExpression)) {
      this.collectExpressions(((RosettaConditionalExpression)expr).getIfthen(), visitor);
      this.collectExpressions(((RosettaConditionalExpression)expr).getElsethen(), visitor);
    } else {
      visitor.apply(expr);
    }
  }

  public boolean isProjectLocal(final URI platformResourceURI, final URI candidateUri) {
    boolean _isPlatformResource = platformResourceURI.isPlatformResource();
    boolean _not = (!_isPlatformResource);
    if (_not) {
      return true;
    }
    final String projectName = platformResourceURI.segment(1);
    boolean _isPlatformResource_1 = candidateUri.isPlatformResource();
    if (_isPlatformResource_1) {
      String _segment = candidateUri.segment(1);
      return Objects.equal(projectName, _segment);
    }
    return false;
  }

  public Iterable<AnnotationRef> metaAnnotations(final Annotated it) {
    final Function1<AnnotationRef, Boolean> _function = (AnnotationRef it_1) -> {
      Annotation _annotation = it_1.getAnnotation();
      String _name = null;
      if (_annotation!=null) {
        _name=_annotation.getName();
      }
      return Boolean.valueOf(Objects.equal(_name, "metadata"));
    };
    return IterableExtensions.<AnnotationRef>filter(this.allAnnotations(it), _function);
  }

  public boolean hasKeyedAnnotation(final Annotated it) {
    final Function1<AnnotationRef, Boolean> _function = (AnnotationRef it_1) -> {
      Attribute _attribute = it_1.getAttribute();
      String _name = null;
      if (_attribute!=null) {
        _name=_attribute.getName();
      }
      return Boolean.valueOf(Objects.equal(_name, "key"));
    };
    return IterableExtensions.<AnnotationRef>exists(this.metaAnnotations(it), _function);
  }

  public boolean hasTemplateAnnotation(final Annotated it) {
    final Function1<AnnotationRef, Boolean> _function = (AnnotationRef it_1) -> {
      Attribute _attribute = it_1.getAttribute();
      String _name = null;
      if (_attribute!=null) {
        _name=_attribute.getName();
      }
      return Boolean.valueOf(Objects.equal(_name, "template"));
    };
    return IterableExtensions.<AnnotationRef>exists(this.metaAnnotations(it), _function);
  }

  public boolean hasMetaDataAnnotations(final RAttribute attribute) {
    final Function1<RAttribute, Boolean> _function = (RAttribute it) -> {
      return Boolean.valueOf((((Objects.equal(it.getName(), "reference") || Objects.equal(it.getName(), "location")) || Objects.equal(it.getName(), "scheme")) || Objects.equal(it.getName(), "id")));
    };
    return IterableExtensions.<RAttribute>exists(attribute.getMetaAnnotations(), _function);
  }

  public boolean hasMetaDataAnnotations(final Annotated it) {
    final Function1<AnnotationRef, Boolean> _function = (AnnotationRef it_1) -> {
      boolean _or = false;
      boolean _or_1 = false;
      boolean _or_2 = false;
      Attribute _attribute = it_1.getAttribute();
      String _name = null;
      if (_attribute!=null) {
        _name=_attribute.getName();
      }
      boolean _equals = Objects.equal(_name, "reference");
      if (_equals) {
        _or_2 = true;
      } else {
        Attribute _attribute_1 = it_1.getAttribute();
        String _name_1 = null;
        if (_attribute_1!=null) {
          _name_1=_attribute_1.getName();
        }
        boolean _equals_1 = Objects.equal(_name_1, "location");
        _or_2 = _equals_1;
      }
      if (_or_2) {
        _or_1 = true;
      } else {
        Attribute _attribute_2 = it_1.getAttribute();
        String _name_2 = null;
        if (_attribute_2!=null) {
          _name_2=_attribute_2.getName();
        }
        boolean _equals_2 = Objects.equal(_name_2, "scheme");
        _or_1 = _equals_2;
      }
      if (_or_1) {
        _or = true;
      } else {
        Attribute _attribute_3 = it_1.getAttribute();
        String _name_3 = null;
        if (_attribute_3!=null) {
          _name_3=_attribute_3.getName();
        }
        boolean _equals_3 = Objects.equal(_name_3, "id");
        _or = _equals_3;
      }
      return Boolean.valueOf(_or);
    };
    return IterableExtensions.<AnnotationRef>exists(this.metaAnnotations(it), _function);
  }

  public boolean hasMetaFieldAnnotations(final Annotated it) {
    final Function1<AnnotationRef, Boolean> _function = (AnnotationRef it_1) -> {
      boolean _and = false;
      Attribute _attribute = it_1.getAttribute();
      String _name = null;
      if (_attribute!=null) {
        _name=_attribute.getName();
      }
      boolean _notEquals = (!Objects.equal(_name, "reference"));
      if (!_notEquals) {
        _and = false;
      } else {
        Attribute _attribute_1 = it_1.getAttribute();
        String _name_1 = null;
        if (_attribute_1!=null) {
          _name_1=_attribute_1.getName();
        }
        boolean _notEquals_1 = (!Objects.equal(_name_1, "address"));
        _and = _notEquals_1;
      }
      return Boolean.valueOf(_and);
    };
    return IterableExtensions.<AnnotationRef>exists(this.metaAnnotations(it), _function);
  }

  public boolean hasMetaDataAddress(final RAttribute attribute) {
    final Function1<RAttribute, Boolean> _function = (RAttribute it) -> {
      String _name = it.getName();
      return Boolean.valueOf(Objects.equal(_name, "address"));
    };
    return IterableExtensions.<RAttribute>exists(attribute.getMetaAnnotations(), _function);
  }

  public boolean hasMetaDataAddress(final Annotated it) {
    final Function1<AnnotationRef, Boolean> _function = (AnnotationRef it_1) -> {
      Attribute _attribute = it_1.getAttribute();
      String _name = null;
      if (_attribute!=null) {
        _name=_attribute.getName();
      }
      return Boolean.valueOf(Objects.equal(_name, "address"));
    };
    return IterableExtensions.<AnnotationRef>exists(this.metaAnnotations(it), _function);
  }

  public boolean hasIdAnnotation(final Annotated it) {
    final Function1<AnnotationRef, Boolean> _function = (AnnotationRef it_1) -> {
      Attribute _attribute = it_1.getAttribute();
      String _name = null;
      if (_attribute!=null) {
        _name=_attribute.getName();
      }
      return Boolean.valueOf(Objects.equal(_name, "id"));
    };
    return IterableExtensions.<AnnotationRef>exists(this.metaAnnotations(it), _function);
  }

  public boolean hasReferenceAnnotation(final Annotated it) {
    final Function1<AnnotationRef, Boolean> _function = (AnnotationRef it_1) -> {
      Attribute _attribute = it_1.getAttribute();
      String _name = null;
      if (_attribute!=null) {
        _name=_attribute.getName();
      }
      return Boolean.valueOf(Objects.equal(_name, "reference"));
    };
    return IterableExtensions.<AnnotationRef>exists(this.metaAnnotations(it), _function);
  }

  public boolean hasCalculationAnnotation(final Annotated it) {
    final Function1<AnnotationRef, Boolean> _function = (AnnotationRef it_1) -> {
      Annotation _annotation = it_1.getAnnotation();
      String _name = null;
      if (_annotation!=null) {
        _name=_annotation.getName();
      }
      return Boolean.valueOf(Objects.equal(_name, "calculation"));
    };
    return IterableExtensions.<AnnotationRef>exists(this.allAnnotations(it), _function);
  }

  public boolean isReference(final Attribute attribute) {
    return (this.hasMetaDataAnnotations(attribute) || this.hasMetaDataAddress(attribute));
  }

  public boolean isReference(final RAttribute attribute) {
    return (this.hasMetaDataAnnotations(attribute) || this.hasMetaDataAddress(attribute));
  }

  private Iterable<AnnotationRef> allAnnotations(final Annotated withAnnotations) {
    EList<AnnotationRef> _annotations = null;
    if (withAnnotations!=null) {
      _annotations=withAnnotations.getAnnotations();
    }
    Iterable<AnnotationRef> _filter = null;
    if (_annotations!=null) {
      final Function1<AnnotationRef, Boolean> _function = (AnnotationRef it) -> {
        return Boolean.valueOf(this.isResolved(it.getAnnotation()));
      };
      _filter=IterableExtensions.<AnnotationRef>filter(_annotations, _function);
    }
    return _filter;
  }

  public String conditionName(final Condition cond, final com.regnosys.rosetta.rosetta.simple.Data data) {
    return this.conditionName(cond, data.getName(), data.getConditions());
  }

  public String conditionName(final Condition cond, final Function func) {
    return this.conditionName(cond, func.getName(), func.getConditions());
  }

  public boolean isConstraintCondition(final Condition cond) {
    return (this.isOneOf(cond) || this.isChoice(cond));
  }

  private boolean isOneOf(final Condition cond) {
    RosettaExpression _expression = cond.getExpression();
    return (_expression instanceof OneOfOperation);
  }

  private boolean isChoice(final Condition cond) {
    RosettaExpression _expression = cond.getExpression();
    return (_expression instanceof ChoiceOperation);
  }

  private String conditionName(final Condition cond, final String containerName, final Collection<Condition> conditions) {
    String _xifexpression = null;
    boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(cond.getName());
    boolean _not = (!_isNullOrEmpty);
    if (_not) {
      _xifexpression = cond.getName();
    } else {
      String _xblockexpression = null;
      {
        final Function1<Condition, Boolean> _function = (Condition it) -> {
          return Boolean.valueOf(StringExtensions.isNullOrEmpty(it.getName()));
        };
        final int idx = IterableExtensions.<Condition>toList(IterableExtensions.<Condition>filter(conditions, _function)).indexOf(cond);
        String _xifexpression_1 = null;
        boolean _isOneOf = this.isOneOf(cond);
        if (_isOneOf) {
          _xifexpression_1 = "OneOf";
        } else {
          String _xifexpression_2 = null;
          boolean _isChoice = this.isChoice(cond);
          if (_isChoice) {
            _xifexpression_2 = "Choice";
          } else {
            _xifexpression_2 = "DataRule";
          }
          _xifexpression_1 = _xifexpression_2;
        }
        final String type = _xifexpression_1;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(type);
        _builder.append(idx);
        _xblockexpression = _builder.toString();
      }
      _xifexpression = _xblockexpression;
    }
    final String name = _xifexpression;
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(containerName);
    _builder.append(name);
    return _builder.toString();
  }

  public String toConditionJavaType(final String conditionName) {
    final String allUnderscore = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, conditionName);
    final String camel = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, allUnderscore);
    return camel;
  }

  /**
   * Get all reporting rules for a report
   */
  public HashMap<RosettaExtensions.PathAttribute, RosettaRule> getAllReportingRules(final RosettaReport report) {
    return this.getAllReportingRules(report.getReportType(), Optional.<RosettaExternalRuleSource>ofNullable(report.getRuleSource()));
  }

  public HashMap<RosettaExtensions.PathAttribute, RosettaRule> getAllReportingRules(final com.regnosys.rosetta.rosetta.simple.Data type, final Optional<RosettaExternalRuleSource> ruleSource) {
    HashMap<RosettaExtensions.PathAttribute, RosettaRule> _xblockexpression = null;
    {
      final HashMap<RosettaExtensions.PathAttribute, RosettaRule> rules = CollectionLiterals.<RosettaExtensions.PathAttribute, RosettaRule>newHashMap();
      final RosettaPath path = RosettaPath.valueOf(type.getName());
      this.collectReportingRules(type, path, ruleSource, rules, CollectionLiterals.<com.regnosys.rosetta.rosetta.simple.Data>newHashSet());
      _xblockexpression = rules;
    }
    return _xblockexpression;
  }

  /**
   * Recursively collects all reporting rules for all attributes
   */
  private void collectReportingRules(final com.regnosys.rosetta.rosetta.simple.Data dataType, final RosettaPath path, final Optional<RosettaExternalRuleSource> ruleSource, final Map<RosettaExtensions.PathAttribute, RosettaRule> visitor, final Set<com.regnosys.rosetta.rosetta.simple.Data> collectedTypes) {
    final Map<RosettaFeature, RosettaRuleReference> attrRules = this.externalAnn.getAllRuleReferencesForType(ruleSource, dataType);
    final Consumer<Attribute> _function = (Attribute attr) -> {
      final RosettaType attrType = attr.getTypeCall().getType();
      final ExpandedAttribute attrEx = RosettaAttributeExtensions.toExpandedAttribute(attr);
      final RosettaRuleReference rule = attrRules.get(attr);
      if ((attrEx.builtInType() || attrEx.isEnum())) {
        if ((rule != null)) {
          RosettaExtensions.PathAttribute _pathAttribute = new RosettaExtensions.PathAttribute(path, attr);
          visitor.put(_pathAttribute, rule.getReportingRule());
        }
      } else {
        if ((attrType instanceof com.regnosys.rosetta.rosetta.simple.Data)) {
          if ((rule != null)) {
            RosettaExtensions.PathAttribute _pathAttribute_1 = new RosettaExtensions.PathAttribute(path, attr);
            visitor.put(_pathAttribute_1, rule.getReportingRule());
          }
          boolean _add = collectedTypes.add(((com.regnosys.rosetta.rosetta.simple.Data)attrType));
          if (_add) {
            RosettaPath _xifexpression = null;
            boolean _isMultiple = attrEx.isMultiple();
            if (_isMultiple) {
              _xifexpression = path.newSubPath(attr.getName(), 0);
            } else {
              _xifexpression = path.newSubPath(attr.getName());
            }
            final RosettaPath subPath = _xifexpression;
            this.collectReportingRules(((com.regnosys.rosetta.rosetta.simple.Data)attrType), subPath, ruleSource, visitor, collectedTypes);
          }
        } else {
          throw new IllegalArgumentException(("Did not collect reporting rules from type " + attrType));
        }
      }
    };
    this.allNonOverridesAttributes(dataType).forEach(_function);
  }
}
