package com.regnosys.rosetta.generator.java.enums;

import com.google.common.collect.Iterables;
import com.regnosys.rosetta.generator.java.JavaScope;
import com.regnosys.rosetta.generator.java.RosettaJavaPackages;
import com.regnosys.rosetta.generator.java.util.ImportManagerExtension;
import com.regnosys.rosetta.generator.java.util.ModelGeneratorUtil;
import com.regnosys.rosetta.rosetta.RosettaEnumSynonym;
import com.regnosys.rosetta.rosetta.RosettaEnumValue;
import com.regnosys.rosetta.rosetta.RosettaEnumeration;
import com.regnosys.rosetta.rosetta.RosettaRootElement;
import com.regnosys.rosetta.rosetta.RosettaSynonymSource;
import com.rosetta.model.lib.annotations.RosettaEnum;
import com.rosetta.model.lib.annotations.RosettaSynonym;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.xbase.lib.Extension;

@SuppressWarnings("all")
public class EnumGenerator {
  @Inject
  @Extension
  private ImportManagerExtension _importManagerExtension;

  public void generate(final RosettaJavaPackages.RootPackage root, final IFileSystemAccess2 fsa, final List<RosettaRootElement> elements, final String version) {
    final Consumer<RosettaEnumeration> _function = (RosettaEnumeration it) -> {
      String _withForwardSlashes = root.withForwardSlashes();
      String _plus = (_withForwardSlashes + "/");
      String _name = it.getName();
      String _plus_1 = (_plus + _name);
      String _plus_2 = (_plus_1 + ".java");
      fsa.generateFile(_plus_2, this.toJava(it, root, version));
    };
    Iterables.<RosettaEnumeration>filter(elements, RosettaEnumeration.class).forEach(_function);
  }

  private ArrayList<RosettaEnumValue> allEnumsValues(final RosettaEnumeration enumeration) {
    final ArrayList<RosettaEnumValue> enumValues = new ArrayList<RosettaEnumValue>();
    RosettaEnumeration e = enumeration;
    while ((e != null)) {
      {
        final Consumer<RosettaEnumValue> _function = (RosettaEnumValue it) -> {
          enumValues.add(it);
        };
        e.getEnumValues().forEach(_function);
        e = e.getSuperType();
      }
    }
    return enumValues;
  }

  private String toJava(final RosettaEnumeration e, final RosettaJavaPackages.RootPackage root, final String version) {
    String _xblockexpression = null;
    {
      final JavaScope scope = new JavaScope(root);
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          String _javadoc = ModelGeneratorUtil.javadoc(e, version);
          _builder.append(_javadoc);
          _builder.newLineIfNotEmpty();
          _builder.append("@");
          _builder.append(RosettaEnum.class);
          _builder.append("(\"");
          String _name = e.getName();
          _builder.append(_name);
          _builder.append("\")");
          _builder.newLineIfNotEmpty();
          _builder.append("public enum ");
          String _name_1 = e.getName();
          _builder.append(_name_1);
          _builder.append(" {");
          _builder.newLineIfNotEmpty();
          _builder.newLine();
          {
            ArrayList<RosettaEnumValue> _allEnumsValues = EnumGenerator.this.allEnumsValues(e);
            boolean _hasElements = false;
            for(final RosettaEnumValue value : _allEnumsValues) {
              if (!_hasElements) {
                _hasElements = true;
              } else {
                _builder.appendImmediate(",\n", "\t");
              }
              _builder.append("\t");
              CharSequence _javadoc_1 = ModelGeneratorUtil.javadoc(value);
              _builder.append(_javadoc_1, "\t");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              StringConcatenationClient _contributeAnnotations = EnumGenerator.this.contributeAnnotations(value);
              _builder.append(_contributeAnnotations, "\t");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("@");
              _builder.append(com.rosetta.model.lib.annotations.RosettaEnumValue.class, "\t");
              _builder.append("(value = \"");
              String _name_2 = value.getName();
              _builder.append(_name_2, "\t");
              _builder.append("\"");
              {
                String _display = value.getDisplay();
                boolean _tripleNotEquals = (_display != null);
                if (_tripleNotEquals) {
                  _builder.append(", displayName = \"");
                  String _display_1 = value.getDisplay();
                  _builder.append(_display_1, "\t");
                  _builder.append("\"");
                }
              }
              _builder.append(") ");
              String _convertValuesWithDisplay = EnumHelper.convertValuesWithDisplay(value);
              _builder.append(_convertValuesWithDisplay, "\t");
              _builder.newLineIfNotEmpty();
            }
            if (_hasElements) {
              _builder.append(";", "\t");
            }
          }
          _builder.newLine();
          _builder.append("\t");
          _builder.append("private static ");
          _builder.append(Map.class, "\t");
          _builder.append("<");
          _builder.append(String.class, "\t");
          _builder.append(", ");
          String _name_3 = e.getName();
          _builder.append(_name_3, "\t");
          _builder.append("> values;");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("static {");
          _builder.newLine();
          _builder.append("        ");
          _builder.append(Map.class, "        ");
          _builder.append("<");
          _builder.append(String.class, "        ");
          _builder.append(", ");
          String _name_4 = e.getName();
          _builder.append(_name_4, "        ");
          _builder.append("> map = new ");
          _builder.append(ConcurrentHashMap.class, "        ");
          _builder.append("<>();");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          _builder.append("for (");
          String _name_5 = e.getName();
          _builder.append(_name_5, "\t\t");
          _builder.append(" instance : ");
          String _name_6 = e.getName();
          _builder.append(_name_6, "\t\t");
          _builder.append(".values()) {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t\t");
          _builder.append("map.put(instance.toDisplayString(), instance);");
          _builder.newLine();
          _builder.append("\t\t");
          _builder.append("}");
          _builder.newLine();
          _builder.append("\t\t");
          _builder.append("values = ");
          _builder.append(Collections.class, "\t\t");
          _builder.append(".unmodifiableMap(map);");
          _builder.newLineIfNotEmpty();
          _builder.append("    ");
          _builder.append("}");
          _builder.newLine();
          _builder.newLine();
          _builder.append("\t");
          _builder.append("private final ");
          _builder.append(String.class, "\t");
          _builder.append(" rosettaName;");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("private final ");
          _builder.append(String.class, "\t");
          _builder.append(" displayName;");
          _builder.newLineIfNotEmpty();
          _builder.newLine();
          _builder.append("\t");
          String _name_7 = e.getName();
          _builder.append(_name_7, "\t");
          _builder.append("(");
          _builder.append(String.class, "\t");
          _builder.append(" rosettaName) {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          _builder.append("this(rosettaName, null);");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.newLine();
          _builder.append("\t");
          String _name_8 = e.getName();
          _builder.append(_name_8, "\t");
          _builder.append("(");
          _builder.append(String.class, "\t");
          _builder.append(" rosettaName, ");
          _builder.append(String.class, "\t");
          _builder.append(" displayName) {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          _builder.append("this.rosettaName = rosettaName;");
          _builder.newLine();
          _builder.append("\t\t");
          _builder.append("this.displayName = displayName;");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.newLine();
          _builder.append("\t");
          _builder.append("public static ");
          String _name_9 = e.getName();
          _builder.append(_name_9, "\t");
          _builder.append(" fromDisplayName(String name) {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          String _name_10 = e.getName();
          _builder.append(_name_10, "\t\t");
          _builder.append(" value = values.get(name);");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          _builder.append("if (value == null) {");
          _builder.newLine();
          _builder.append("\t\t\t");
          _builder.append("throw new ");
          _builder.append(IllegalArgumentException.class, "\t\t\t");
          _builder.append("(\"No enum constant with display name \\\"\" + name + \"\\\".\");");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          _builder.append("}");
          _builder.newLine();
          _builder.append("\t\t");
          _builder.append("return value;");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.newLine();
          _builder.append("\t");
          _builder.append("@Override");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("public ");
          _builder.append(String.class, "\t");
          _builder.append(" toString() {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          _builder.append("return toDisplayString();");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.newLine();
          _builder.append("\t");
          _builder.append("public ");
          _builder.append(String.class, "\t");
          _builder.append(" toDisplayString() {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          _builder.append("return displayName != null ?  displayName : rosettaName;");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.append("}");
          _builder.newLine();
        }
      };
      final StringConcatenationClient classBody = _client;
      _xblockexpression = this._importManagerExtension.buildClass(root, classBody, scope);
    }
    return _xblockexpression;
  }

  private StringConcatenationClient contributeAnnotations(final RosettaEnumValue e) {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        {
          EList<RosettaEnumSynonym> _enumSynonyms = e.getEnumSynonyms();
          for(final RosettaEnumSynonym synonym : _enumSynonyms) {
            {
              EList<RosettaSynonymSource> _sources = synonym.getSources();
              for(final RosettaSynonymSource source : _sources) {
                _builder.append("@");
                _builder.append(RosettaSynonym.class);
                _builder.append("(value = \"");
                String _synonymValue = synonym.getSynonymValue();
                _builder.append(_synonymValue);
                _builder.append("\", source = \"");
                String _name = source.getName();
                _builder.append(_name);
                _builder.append("\")");
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
      }
    };
    return _client;
  }
}
