package com.regnosys.rosetta.generator.java.expression;

import com.regnosys.rosetta.RosettaExtensions;
import com.regnosys.rosetta.generator.GeneratedIdentifier;
import com.regnosys.rosetta.generator.java.JavaIdentifierRepresentationService;
import com.regnosys.rosetta.generator.java.JavaScope;
import com.regnosys.rosetta.generator.java.statement.JavaStatement;
import com.regnosys.rosetta.generator.java.statement.builder.JavaExpression;
import com.regnosys.rosetta.generator.java.statement.builder.JavaIfThenElseBuilder;
import com.regnosys.rosetta.generator.java.statement.builder.JavaStatementBuilder;
import com.regnosys.rosetta.generator.java.statement.builder.JavaVariable;
import com.regnosys.rosetta.generator.java.types.JavaTypeTranslator;
import com.regnosys.rosetta.generator.java.types.JavaTypeUtil;
import com.regnosys.rosetta.generator.java.util.ImportManagerExtension;
import com.regnosys.rosetta.generator.util.RosettaAttributeExtensions;
import com.regnosys.rosetta.rosetta.expression.ExistsModifier;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.RosettaTypeProvider;
import com.regnosys.rosetta.utils.DeepFeatureCallUtil;
import com.rosetta.util.DottedPath;
import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.JavaPrimitiveType;
import com.rosetta.util.types.JavaReferenceType;
import com.rosetta.util.types.JavaType;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.inject.Inject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class DeepPathUtilGenerator {
  @Inject
  @Extension
  private ImportManagerExtension _importManagerExtension;

  @Inject
  @Extension
  private JavaTypeTranslator _javaTypeTranslator;

  @Inject
  @Extension
  private DeepFeatureCallUtil _deepFeatureCallUtil;

  @Inject
  @Extension
  private RosettaExtensions _rosettaExtensions;

  @Inject
  @Extension
  private ExpressionGenerator _expressionGenerator;

  @Inject
  @Extension
  private RosettaTypeProvider _rosettaTypeProvider;

  @Inject
  @Extension
  private TypeCoercionService _typeCoercionService;

  @Inject
  @Extension
  private JavaIdentifierRepresentationService _javaIdentifierRepresentationService;

  @Inject
  private JavaTypeUtil typeUtil;

  public void generate(final IFileSystemAccess2 fsa, final Data choiceType, final String version) {
    final JavaClass<?> javaClass = this._javaTypeTranslator.toDeepPathUtilJavaClass(choiceType);
    String _withForwardSlashes = javaClass.getCanonicalName().withForwardSlashes();
    final String fileName = (_withForwardSlashes + ".java");
    DottedPath _packageName = javaClass.getPackageName();
    final JavaScope topScope = new JavaScope(_packageName);
    final String content = this._importManagerExtension.buildClass(javaClass.getPackageName(), this.classBody(choiceType, javaClass, topScope), topScope);
    fsa.generateFile(fileName, content);
  }

  private StringConcatenationClient classBody(final Data choiceType, final JavaClass<?> javaClass, final JavaScope topScope) {
    StringConcatenationClient _xblockexpression = null;
    {
      final JavaScope classScope = topScope.classScope(javaClass.getSimpleName());
      final Collection<Attribute> deepFeatures = this._deepFeatureCallUtil.findDeepFeatures(new RDataType(choiceType));
      final HashSet<JavaClass<?>> dependencies = new HashSet<JavaClass<?>>();
      final Function1<Attribute, Attribute> _function = (Attribute it) -> {
        return it;
      };
      final Function1<Attribute, Map<Attribute, Boolean>> _function_1 = (Attribute it) -> {
        Map<Attribute, Boolean> _xblockexpression_1 = null;
        {
          final RType attrType = this._rosettaTypeProvider.getRTypeOfFeature(it);
          final Function1<Attribute, Attribute> _function_2 = (Attribute it_1) -> {
            return it_1;
          };
          final Function1<Attribute, Boolean> _function_3 = (Attribute it_1) -> {
            if ((attrType instanceof RDataType)) {
              boolean _containsKey = this._deepFeatureCallUtil.findDeepFeatureMap(((RDataType)attrType)).containsKey(it_1.getName());
              if (_containsKey) {
                dependencies.add(this._javaTypeTranslator.toDeepPathUtilJavaClass(((RDataType)attrType).getData()));
                return Boolean.valueOf(true);
              }
            }
            return Boolean.valueOf(false);
          };
          _xblockexpression_1 = IterableExtensions.<Attribute, Attribute, Boolean>toMap(deepFeatures, _function_2, _function_3);
        }
        return _xblockexpression_1;
      };
      final Map<Attribute, Map<Attribute, Boolean>> recursiveDeepFeaturesMap = IterableExtensions.<Attribute, Attribute, Map<Attribute, Boolean>>toMap(this._rosettaExtensions.allNonOverridesAttributes(choiceType), _function, _function_1);
      final Consumer<JavaClass<?>> _function_2 = (JavaClass<?> it) -> {
        classScope.createIdentifier(this._javaIdentifierRepresentationService.toDependencyInstance(it), StringExtensions.toFirstLower(it.getSimpleName()));
      };
      dependencies.forEach(_function_2);
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          _builder.append("public class ");
          _builder.append(javaClass);
          _builder.append(" {");
          _builder.newLineIfNotEmpty();
          {
            boolean _isEmpty = dependencies.isEmpty();
            boolean _not = (!_isEmpty);
            if (_not) {
              {
                for(final JavaClass<?> dependency : dependencies) {
                  _builder.append("\t");
                  _builder.append("private final ");
                  _builder.append(dependency, "\t");
                  _builder.append(" ");
                  GeneratedIdentifier _identifierOrThrow = classScope.getIdentifierOrThrow(DeepPathUtilGenerator.this._javaIdentifierRepresentationService.toDependencyInstance(dependency));
                  _builder.append(_identifierOrThrow, "\t");
                  _builder.append(";");
                  _builder.newLineIfNotEmpty();
                }
              }
              _builder.append("\t");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("@");
              _builder.append(Inject.class, "\t");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("public ");
              _builder.append(javaClass, "\t");
              _builder.append("(");
              {
                boolean _hasElements = false;
                for(final JavaClass<?> dependency_1 : dependencies) {
                  if (!_hasElements) {
                    _hasElements = true;
                  } else {
                    _builder.appendImmediate(", ", "\t");
                  }
                  _builder.append(dependency_1, "\t");
                  _builder.append(" ");
                  GeneratedIdentifier _identifierOrThrow_1 = classScope.getIdentifierOrThrow(DeepPathUtilGenerator.this._javaIdentifierRepresentationService.toDependencyInstance(dependency_1));
                  _builder.append(_identifierOrThrow_1, "\t");
                }
              }
              _builder.append(") {");
              _builder.newLineIfNotEmpty();
              {
                for(final JavaClass<?> dependency_2 : dependencies) {
                  _builder.append("\t");
                  _builder.append("\t");
                  _builder.append("this.");
                  GeneratedIdentifier _identifierOrThrow_2 = classScope.getIdentifierOrThrow(DeepPathUtilGenerator.this._javaIdentifierRepresentationService.toDependencyInstance(dependency_2));
                  _builder.append(_identifierOrThrow_2, "\t\t");
                  _builder.append(" = ");
                  GeneratedIdentifier _identifierOrThrow_3 = classScope.getIdentifierOrThrow(DeepPathUtilGenerator.this._javaIdentifierRepresentationService.toDependencyInstance(dependency_2));
                  _builder.append(_identifierOrThrow_3, "\t\t");
                  _builder.append(";");
                  _builder.newLineIfNotEmpty();
                }
              }
              _builder.append("\t");
              _builder.append("}");
              _builder.newLine();
              _builder.append("\t");
              _builder.newLine();
            }
          }
          {
            for(final Attribute deepFeature : deepFeatures) {
              _builder.append("\t");
              StringConcatenation _builder_1 = new StringConcatenation();
              _builder_1.append("choose");
              String _firstUpper = StringExtensions.toFirstUpper(deepFeature.getName());
              _builder_1.append(_firstUpper);
              final String methodName = _builder_1.toString();
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              final JavaScope deepFeatureScope = classScope.methodScope(methodName);
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              GeneratedIdentifier _createUniqueIdentifier = deepFeatureScope.createUniqueIdentifier(StringExtensions.toFirstLower(choiceType.getName()));
              JavaReferenceType _javaReferenceType = DeepPathUtilGenerator.this._javaTypeTranslator.toJavaReferenceType(new RDataType(choiceType));
              final JavaVariable inputParameter = new JavaVariable(_createUniqueIdentifier, _javaReferenceType);
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              final JavaStatementBuilder methodBody = DeepPathUtilGenerator.this.deepFeatureToStatement(choiceType, inputParameter, deepFeature, recursiveDeepFeaturesMap, deepFeatureScope);
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("public ");
              JavaType _expressionType = methodBody.getExpressionType();
              _builder.append(_expressionType, "\t");
              _builder.append(" ");
              _builder.append(methodName, "\t");
              _builder.append("(");
              JavaType _expressionType_1 = inputParameter.getExpressionType();
              _builder.append(_expressionType_1, "\t");
              _builder.append(" ");
              _builder.append(inputParameter, "\t");
              _builder.append(") ");
              JavaStatement _completeAsReturn = methodBody.completeAsReturn();
              _builder.append(_completeAsReturn, "\t");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.newLine();
            }
          }
          _builder.append("}");
          _builder.newLine();
        }
      };
      _xblockexpression = _client;
    }
    return _xblockexpression;
  }

  private JavaStatementBuilder deepFeatureToStatement(final Data choiceType, final JavaVariable inputParameter, final Attribute deepFeature, final Map<Attribute, Map<Attribute, Boolean>> recursiveDeepFeaturesMap, final JavaScope scope) {
    JavaStatementBuilder _xblockexpression = null;
    {
      final List<Attribute> attrs = this._rosettaExtensions.allNonOverridesAttributes(choiceType);
      final RDataType receiverType = new RDataType(choiceType);
      JavaStatementBuilder acc = JavaExpression.NULL;
      List<Attribute> _reverseView = ListExtensions.<Attribute>reverseView(attrs);
      for (final Attribute a : _reverseView) {
        {
          final JavaStatementBuilder currAcc = acc;
          final Function<JavaExpression, JavaStatementBuilder> _function = (JavaExpression attrVar) -> {
            final Function<JavaExpression, JavaStatementBuilder> _function_1 = (JavaExpression it) -> {
              JavaIfThenElseBuilder _xblockexpression_1 = null;
              {
                JavaStatementBuilder _xifexpression = null;
                boolean _match = this._deepFeatureCallUtil.match(deepFeature, a);
                if (_match) {
                  _xifexpression = attrVar;
                } else {
                  JavaStatementBuilder _xblockexpression_2 = null;
                  {
                    final RType attrType = this._rosettaTypeProvider.getRTypeOfFeature(a);
                    final Boolean needsToGoDownDeeper = recursiveDeepFeaturesMap.get(a).get(deepFeature);
                    Attribute _xifexpression_1 = null;
                    if (((needsToGoDownDeeper).booleanValue() || (!(attrType instanceof RDataType)))) {
                      _xifexpression_1 = deepFeature;
                    } else {
                      final Function1<Attribute, Boolean> _function_2 = (Attribute it_1) -> {
                        return Boolean.valueOf(it_1.getName().equals(deepFeature.getName()));
                      };
                      _xifexpression_1 = IterableExtensions.<Attribute>findFirst(this._rosettaExtensions.allNonOverridesAttributes(((RDataType) attrType).getData()), _function_2);
                    }
                    final Attribute actualFeature = _xifexpression_1;
                    _xblockexpression_2 = this._expressionGenerator.featureCall(attrVar, attrType, actualFeature, (needsToGoDownDeeper).booleanValue(), scope, true);
                  }
                  _xifexpression = _xblockexpression_2;
                }
                final JavaStatementBuilder deepFeatureExpr = _xifexpression;
                _xblockexpression_1 = new JavaIfThenElseBuilder(it, deepFeatureExpr, currAcc, this.typeUtil);
              }
              return _xblockexpression_1;
            };
            return this._typeCoercionService.addCoercions(this._expressionGenerator.exists(attrVar, ExistsModifier.NONE, scope).collapseToSingleExpression(scope), JavaPrimitiveType.BOOLEAN, scope).mapExpression(_function_1);
          };
          acc = this._expressionGenerator.featureCall(inputParameter, receiverType, a, false, scope, true).declareAsVariable(true, StringExtensions.toFirstLower(a.getName()), scope).mapExpression(_function);
        }
      }
      final JavaReferenceType resultType = this._javaTypeTranslator.toMultiRegularJavaType(RosettaAttributeExtensions.toExpandedAttribute(deepFeature));
      _xblockexpression = this._typeCoercionService.addCoercions(acc, resultType, scope);
    }
    return _xblockexpression;
  }
}
