package com.regnosys.rosetta.generator.java.expression;

import com.google.common.collect.Iterables;
import com.regnosys.rosetta.generator.java.types.JavaTypeTranslator;
import com.regnosys.rosetta.rosetta.RosettaRule;
import com.regnosys.rosetta.rosetta.RosettaSymbol;
import com.regnosys.rosetta.rosetta.expression.RosettaDeepFeatureCall;
import com.regnosys.rosetta.rosetta.expression.RosettaExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaSymbolReference;
import com.regnosys.rosetta.rosetta.simple.Function;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.RObjectFactory;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.RosettaTypeProvider;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.util.types.JavaClass;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

/**
 * A class that helps determine which RosettaFunctions a Rosetta object refers to
 */
@SuppressWarnings("all")
public class JavaDependencyProvider {
  @Inject
  private RObjectFactory rTypeBuilderFactory;

  @Inject
  private RosettaTypeProvider typeProvider;

  @Inject
  @Extension
  private JavaTypeTranslator _javaTypeTranslator;

  public List<JavaClass<?>> javaDependencies(final RosettaExpression expression) {
    List<JavaClass<?>> _xblockexpression = null;
    {
      final Function1<RosettaSymbolReference, RosettaSymbol> _function = (RosettaSymbolReference it) -> {
        return it.getSymbol();
      };
      final List<RosettaSymbol> rosettaSymbols = ListExtensions.<RosettaSymbolReference, RosettaSymbol>map(EcoreUtil2.<RosettaSymbolReference>eAllOfType(expression, RosettaSymbolReference.class), _function);
      final List<RosettaDeepFeatureCall> deepFeatureCalls = EcoreUtil2.<RosettaDeepFeatureCall>eAllOfType(expression, RosettaDeepFeatureCall.class);
      final Function1<Function, JavaClass<? extends RosettaFunction>> _function_1 = (Function it) -> {
        return this._javaTypeTranslator.toFunctionJavaClass(this.rTypeBuilderFactory.buildRFunction(it));
      };
      Iterable<JavaClass<? extends RosettaFunction>> _map = IterableExtensions.<Function, JavaClass<? extends RosettaFunction>>map(Iterables.<Function>filter(rosettaSymbols, Function.class), _function_1);
      final Function1<RosettaRule, JavaClass<? extends RosettaFunction>> _function_2 = (RosettaRule it) -> {
        return this._javaTypeTranslator.toFunctionJavaClass(this.rTypeBuilderFactory.buildRFunction(it));
      };
      Iterable<JavaClass<? extends RosettaFunction>> _map_1 = IterableExtensions.<RosettaRule, JavaClass<? extends RosettaFunction>>map(Iterables.<RosettaRule>filter(rosettaSymbols, RosettaRule.class), _function_2);
      Iterable<JavaClass<? extends RosettaFunction>> _plus = Iterables.<JavaClass<? extends RosettaFunction>>concat(_map, _map_1);
      final Function1<RosettaDeepFeatureCall, RType> _function_3 = (RosettaDeepFeatureCall it) -> {
        return this.typeProvider.getRType(it.getReceiver());
      };
      final Function1<RDataType, JavaClass<?>> _function_4 = (RDataType it) -> {
        return this._javaTypeTranslator.toDeepPathUtilJavaClass(it.getData());
      };
      Iterable<JavaClass<?>> _map_2 = IterableExtensions.<RDataType, JavaClass<?>>map(Iterables.<RDataType>filter(ListExtensions.<RosettaDeepFeatureCall, RType>map(deepFeatureCalls, _function_3), RDataType.class), _function_4);
      final Function1<JavaClass<?>, String> _function_5 = (JavaClass<?> it) -> {
        return it.getSimpleName();
      };
      _xblockexpression = IterableExtensions.<JavaClass<?>, String>sortBy(IterableExtensions.<JavaClass<?>>toSet(Iterables.<JavaClass<?>>concat(_plus, _map_2)), _function_5);
    }
    return _xblockexpression;
  }

  public List<JavaClass<?>> javaDependencies(final Iterable<? extends RosettaExpression> expressions) {
    final Function1<RosettaExpression, List<JavaClass<?>>> _function = (RosettaExpression it) -> {
      return this.javaDependencies(it);
    };
    final Function1<JavaClass<?>, String> _function_1 = (JavaClass<?> it) -> {
      return it.getSimpleName();
    };
    return IterableExtensions.<JavaClass<?>, String>sortBy(IterableExtensions.<JavaClass<?>>toSet(IterableExtensions.flatMap(expressions, _function)), _function_1);
  }
}
