package com.regnosys.rosetta.generator.java.function;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.ImplementedBy;
import com.regnosys.rosetta.RosettaExtensions;
import com.regnosys.rosetta.generator.GeneratedIdentifier;
import com.regnosys.rosetta.generator.ImplicitVariableRepresentation;
import com.regnosys.rosetta.generator.java.JavaIdentifierRepresentationService;
import com.regnosys.rosetta.generator.java.JavaScope;
import com.regnosys.rosetta.generator.java.RosettaJavaPackages;
import com.regnosys.rosetta.generator.java.enums.EnumHelper;
import com.regnosys.rosetta.generator.java.expression.ExpressionGenerator;
import com.regnosys.rosetta.generator.java.expression.JavaDependencyProvider;
import com.regnosys.rosetta.generator.java.expression.TypeCoercionService;
import com.regnosys.rosetta.generator.java.statement.JavaBlock;
import com.regnosys.rosetta.generator.java.statement.JavaLambdaBody;
import com.regnosys.rosetta.generator.java.statement.JavaStatement;
import com.regnosys.rosetta.generator.java.statement.JavaStatementList;
import com.regnosys.rosetta.generator.java.statement.builder.JavaExpression;
import com.regnosys.rosetta.generator.java.statement.builder.JavaStatementBuilder;
import com.regnosys.rosetta.generator.java.types.JavaTypeTranslator;
import com.regnosys.rosetta.generator.java.types.JavaTypeUtil;
import com.regnosys.rosetta.generator.java.util.ImportManagerExtension;
import com.regnosys.rosetta.generator.java.util.ModelGeneratorUtil;
import com.regnosys.rosetta.generator.util.RosettaFunctionExtensions;
import com.regnosys.rosetta.rosetta.RosettaCallableWithArgs;
import com.regnosys.rosetta.rosetta.RosettaEnumeration;
import com.regnosys.rosetta.rosetta.RosettaFeature;
import com.regnosys.rosetta.rosetta.RosettaSymbol;
import com.regnosys.rosetta.rosetta.RosettaType;
import com.regnosys.rosetta.rosetta.expression.AsKeyOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaFeatureCall;
import com.regnosys.rosetta.rosetta.expression.RosettaSymbolReference;
import com.regnosys.rosetta.rosetta.expression.RosettaUnaryOperation;
import com.regnosys.rosetta.rosetta.simple.AnnotationRef;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Condition;
import com.regnosys.rosetta.rosetta.simple.Function;
import com.regnosys.rosetta.rosetta.simple.FunctionDispatch;
import com.regnosys.rosetta.rosetta.simple.Operation;
import com.regnosys.rosetta.rosetta.simple.ShortcutDeclaration;
import com.regnosys.rosetta.types.CardinalityProvider;
import com.regnosys.rosetta.types.RAssignedRoot;
import com.regnosys.rosetta.types.RAttribute;
import com.regnosys.rosetta.types.RFunction;
import com.regnosys.rosetta.types.RFunctionOrigin;
import com.regnosys.rosetta.types.RObjectFactory;
import com.regnosys.rosetta.types.ROperation;
import com.regnosys.rosetta.types.ROperationType;
import com.regnosys.rosetta.types.RShortcut;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.RosettaTypeProvider;
import com.regnosys.rosetta.utils.ExpressionHelper;
import com.regnosys.rosetta.utils.ImplicitVariableUtil;
import com.rosetta.model.lib.ModelSymbolId;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.IQualifyFunctionExtension;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.util.DottedPath;
import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.JavaGenericTypeDeclaration;
import com.rosetta.util.types.JavaParameterizedType;
import com.rosetta.util.types.JavaPrimitiveType;
import com.rosetta.util.types.JavaReferenceType;
import com.rosetta.util.types.JavaType;
import com.rosetta.util.types.generated.GeneratedJavaClass;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class FunctionGenerator {
  @Inject
  private ExpressionGenerator expressionGenerator;

  @Inject
  private JavaDependencyProvider dependencyProvider;

  @Inject
  private RosettaTypeProvider typeProvider;

  @Inject
  @Extension
  private RosettaFunctionExtensions _rosettaFunctionExtensions;

  @Inject
  @Extension
  private RosettaExtensions _rosettaExtensions;

  @Inject
  private ExpressionHelper exprHelper;

  @Inject
  @Extension
  private ImportManagerExtension _importManagerExtension;

  @Inject
  private CardinalityProvider cardinality;

  @Inject
  @Extension
  private JavaIdentifierRepresentationService _javaIdentifierRepresentationService;

  @Inject
  @Extension
  private JavaTypeTranslator _javaTypeTranslator;

  @Inject
  private RObjectFactory rTypeBuilderFactory;

  @Inject
  private ImplicitVariableUtil implicitVariableUtil;

  @Inject
  @Extension
  private JavaTypeUtil _javaTypeUtil;

  @Inject
  private TypeCoercionService coercionService;

  public void generate(final RosettaJavaPackages.RootPackage root, final IFileSystemAccess2 fsa, final Function func, final String version) {
    String _withForwardSlashes = root.functions().withForwardSlashes();
    String _plus = (_withForwardSlashes + "/");
    String _name = func.getName();
    String _plus_1 = (_plus + _name);
    final String fileName = (_plus_1 + ".java");
    DottedPath _functions = root.functions();
    final JavaScope topScope = new JavaScope(_functions);
    StringConcatenationClient _xifexpression = null;
    Boolean _handleAsEnumFunction = this._rosettaFunctionExtensions.handleAsEnumFunction(func);
    if ((_handleAsEnumFunction).booleanValue()) {
      StringConcatenationClient _xblockexpression = null;
      {
        final List<JavaClass<?>> dependencies = this.collectFunctionDependencies(func);
        topScope.createIdentifier(func);
        _xblockexpression = this.dispatchClassBody(func, topScope, dependencies, version, root);
      }
      _xifexpression = _xblockexpression;
    } else {
      StringConcatenationClient _xblockexpression_1 = null;
      {
        final RFunction rFunction = this.rTypeBuilderFactory.buildRFunction(func);
        boolean overridesEvaluate = false;
        final List<JavaType> functionInterfaces = CollectionLiterals.<JavaType>newArrayList(JavaClass.<RosettaFunction>from(RosettaFunction.class));
        boolean _isQualifierFunction = this._rosettaFunctionExtensions.isQualifierFunction(rFunction);
        if (_isQualifierFunction) {
          overridesEvaluate = true;
          functionInterfaces.add(this.getQualifyingFunctionInterface(rFunction.getInputs()));
        }
        _xblockexpression_1 = this.rBuildClass(rFunction, false, functionInterfaces, CollectionLiterals.<Class<?>, String>emptyMap(), overridesEvaluate, topScope);
      }
      _xifexpression = _xblockexpression_1;
    }
    final StringConcatenationClient classBody = _xifexpression;
    final String content = this._importManagerExtension.buildClass(root.functions(), classBody, topScope);
    fsa.generateFile(fileName, content);
  }

  public StringConcatenationClient rBuildClass(final RFunction rFunction, final boolean isStatic, final List<JavaType> functionInterfaces, final Map<Class<?>, String> annotations, final boolean overridesEvaluate, final JavaScope topScope) {
    StringConcatenationClient _xblockexpression = null;
    {
      final List<JavaClass<?>> dependencies = this.collectFunctionDependencies(rFunction);
      _xblockexpression = this.classBody(rFunction, isStatic, overridesEvaluate, dependencies, functionInterfaces, annotations, topScope);
    }
    return _xblockexpression;
  }

  private JavaParameterizedType<IQualifyFunctionExtension<?>> getQualifyingFunctionInterface(final List<RAttribute> inputs) {
    JavaParameterizedType<IQualifyFunctionExtension<?>> _xblockexpression = null;
    {
      final JavaReferenceType parameterVariable = this._javaTypeTranslator.toListOrSingleJavaType(IterableExtensions.<RAttribute>head(inputs).getRType(), IterableExtensions.<RAttribute>head(inputs).isMulti());
      _xblockexpression = JavaParameterizedType.<IQualifyFunctionExtension<?>>from(new TypeReference<IQualifyFunctionExtension<?>>() {
      }, parameterVariable);
    }
    return _xblockexpression;
  }

  private List<JavaClass<?>> collectFunctionDependencies(final Function func) {
    final Function1<ShortcutDeclaration, RosettaExpression> _function = (ShortcutDeclaration it) -> {
      return it.getExpression();
    };
    List<RosettaExpression> _map = ListExtensions.<ShortcutDeclaration, RosettaExpression>map(func.getShortcuts(), _function);
    final Function1<Operation, RosettaExpression> _function_1 = (Operation it) -> {
      return it.getExpression();
    };
    List<RosettaExpression> _map_1 = ListExtensions.<Operation, RosettaExpression>map(func.getOperations(), _function_1);
    Iterable<RosettaExpression> _plus = Iterables.<RosettaExpression>concat(_map, _map_1);
    EList<Condition> _conditions = func.getConditions();
    EList<Condition> _postConditions = func.getPostConditions();
    final Function1<Condition, RosettaExpression> _function_2 = (Condition it) -> {
      return it.getExpression();
    };
    Iterable<RosettaExpression> _map_2 = IterableExtensions.<Condition, RosettaExpression>map(Iterables.<Condition>concat(_conditions, _postConditions), _function_2);
    final Iterable<RosettaExpression> expressions = Iterables.<RosettaExpression>concat(_plus, _map_2);
    return this.dependencyProvider.javaDependencies(expressions);
  }

  private List<JavaClass<?>> collectFunctionDependencies(final RFunction func) {
    final Function1<Condition, RosettaExpression> _function = (Condition it) -> {
      return it.getExpression();
    };
    List<RosettaExpression> _map = ListExtensions.<Condition, RosettaExpression>map(func.getPreConditions(), _function);
    final Function1<Condition, RosettaExpression> _function_1 = (Condition it) -> {
      return it.getExpression();
    };
    List<RosettaExpression> _map_1 = ListExtensions.<Condition, RosettaExpression>map(func.getPostConditions(), _function_1);
    Iterable<RosettaExpression> _plus = Iterables.<RosettaExpression>concat(_map, _map_1);
    final Function1<ROperation, RosettaExpression> _function_2 = (ROperation it) -> {
      return it.getExpression();
    };
    List<RosettaExpression> _map_2 = ListExtensions.<ROperation, RosettaExpression>map(func.getOperations(), _function_2);
    Iterable<RosettaExpression> _plus_1 = Iterables.<RosettaExpression>concat(_plus, _map_2);
    final Function1<RShortcut, RosettaExpression> _function_3 = (RShortcut it) -> {
      return it.getExpression();
    };
    List<RosettaExpression> _map_3 = ListExtensions.<RShortcut, RosettaExpression>map(func.getShortcuts(), _function_3);
    final Iterable<RosettaExpression> expressions = Iterables.<RosettaExpression>concat(_plus_1, _map_3);
    return this.dependencyProvider.javaDependencies(expressions);
  }

  private StringConcatenationClient classBody(final RFunction function, final boolean isStatic, final boolean overridesEvaluate, final List<JavaClass<?>> dependencies, final List<JavaType> functionInterfaces, final Map<Class<?>, String> annotations, final JavaScope scope) {
    StringConcatenationClient _xblockexpression = null;
    {
      final GeneratedIdentifier className = scope.createIdentifier(function, this._javaTypeTranslator.toFunctionJavaClass(function).getSimpleName());
      final List<RAttribute> inputs = function.getInputs();
      final RAttribute output = function.getOutput();
      final List<RShortcut> shortcuts = function.getShortcuts();
      final List<ROperation> operations = function.getOperations();
      final List<Condition> preConditions = function.getPreConditions();
      final List<Condition> postConditions = function.getPostConditions();
      final JavaScope classScope = scope.classScope(className.getDesiredName());
      final Consumer<JavaClass<?>> _function = (JavaClass<?> it) -> {
        classScope.createIdentifier(this._javaIdentifierRepresentationService.toDependencyInstance(it), StringExtensions.toFirstLower(it.getSimpleName()));
      };
      dependencies.forEach(_function);
      String _desiredName = className.getDesiredName();
      String _plus = (_desiredName + "Default");
      final JavaScope defaultClassScope = classScope.classScope(_plus);
      String _desiredName_1 = className.getDesiredName();
      String _plus_1 = (_desiredName_1 + "Default");
      final GeneratedIdentifier defaultClassName = defaultClassScope.createUniqueIdentifier(_plus_1);
      final JavaReferenceType outputType = this._javaTypeTranslator.attributeToJavaType(output);
      final Function1<RShortcut, RShortcut> _function_1 = (RShortcut it) -> {
        return it;
      };
      final Function1<RShortcut, Boolean> _function_2 = (RShortcut it) -> {
        return Boolean.valueOf(this.exprHelper.usesOutputParameter(it.getExpression()));
      };
      final Map<RShortcut, Boolean> aliasOut = IterableExtensions.<RShortcut, RShortcut, Boolean>toMap(shortcuts, _function_1, _function_2);
      final GeneratedIdentifier conditionValidatorId = classScope.createUniqueIdentifier("conditionValidator");
      final GeneratedIdentifier objectValidatorId = classScope.createUniqueIdentifier("objectValidator");
      final JavaScope evaluateScope = classScope.methodScope("evaluate");
      final Consumer<RAttribute> _function_3 = (RAttribute it) -> {
        evaluateScope.createIdentifier(it, it.getName());
      };
      inputs.forEach(_function_3);
      evaluateScope.createIdentifier(output, output.getName());
      GeneratedIdentifier _xifexpression = null;
      boolean _needsBuilder = this._rosettaFunctionExtensions.needsBuilder(output);
      if (_needsBuilder) {
        String _name = output.getName();
        String _plus_2 = (_name + "Builder");
        _xifexpression = evaluateScope.createUniqueIdentifier(_plus_2);
      }
      final GeneratedIdentifier outputBuilderId = _xifexpression;
      final JavaScope doEvaluateScope = defaultClassScope.methodScope("doEvaluate");
      final Consumer<RAttribute> _function_4 = (RAttribute it) -> {
        doEvaluateScope.createIdentifier(it, it.getName());
      };
      inputs.forEach(_function_4);
      doEvaluateScope.createIdentifier(output, output.getName());
      final JavaScope assignOutputScope = defaultClassScope.methodScope("assignOutput");
      final Consumer<RAttribute> _function_5 = (RAttribute it) -> {
        assignOutputScope.createIdentifier(it, it.getName());
      };
      inputs.forEach(_function_5);
      assignOutputScope.createIdentifier(output, output.getName());
      final Function1<ROperation, RosettaExpression> _function_6 = (ROperation it) -> {
        return it.getExpression();
      };
      final Function1<RosettaExpression, Boolean> _function_7 = (RosettaExpression it) -> {
        return Boolean.valueOf(this.implicitVariableUtil.implicitVariableExistsInContext(it));
      };
      final Function1<RosettaExpression, ImplicitVariableRepresentation> _function_8 = (RosettaExpression it) -> {
        return this._javaIdentifierRepresentationService.getImplicitVarInContext(it);
      };
      final Consumer<ImplicitVariableRepresentation> _function_9 = (ImplicitVariableRepresentation it) -> {
        assignOutputScope.createKeySynonym(it, IterableExtensions.<RAttribute>head(inputs));
      };
      IterableExtensions.<ImplicitVariableRepresentation>toSet(IterableExtensions.<RosettaExpression, ImplicitVariableRepresentation>map(IterableExtensions.<RosettaExpression>filter(ListExtensions.<ROperation, RosettaExpression>map(function.getOperations(), _function_6), _function_7), _function_8)).forEach(_function_9);
      final HashMap<RShortcut, JavaScope> aliasScopes = CollectionLiterals.<RShortcut, JavaScope>newHashMap();
      final Consumer<RShortcut> _function_10 = (RShortcut it) -> {
        classScope.createIdentifier(it, it.getName());
        final JavaScope aliasScope = defaultClassScope.methodScope(it.getName());
        final Consumer<RAttribute> _function_11 = (RAttribute it_1) -> {
          aliasScope.createIdentifier(it_1, it_1.getName());
        };
        inputs.forEach(_function_11);
        Boolean _get = aliasOut.get(it);
        if ((_get).booleanValue()) {
          aliasScope.createIdentifier(output, output.getName());
        }
        aliasScopes.put(it, aliasScope);
      };
      shortcuts.forEach(_function_10);
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          {
            Set<Map.Entry<Class<?>, String>> _entrySet = annotations.entrySet();
            for(final Map.Entry<Class<?>, String> entry : _entrySet) {
              _builder.append("@");
              Class<?> _key = entry.getKey();
              _builder.append(_key);
              _builder.append("(");
              String _value = entry.getValue();
              _builder.append(_value);
              _builder.append(")");
              _builder.newLineIfNotEmpty();
            }
          }
          _builder.append("@");
          _builder.append(ImplementedBy.class);
          _builder.append("(");
          _builder.append(className);
          _builder.append(".");
          _builder.append(defaultClassName);
          _builder.append(".class)");
          _builder.newLineIfNotEmpty();
          _builder.append("public ");
          {
            if (isStatic) {
              _builder.append("static ");
            }
          }
          _builder.append("abstract class ");
          _builder.append(className);
          _builder.append(" implements ");
          {
            boolean _hasElements = false;
            for(final JavaType fInterface : functionInterfaces) {
              if (!_hasElements) {
                _hasElements = true;
              } else {
                _builder.appendImmediate(",", "");
              }
              _builder.append(fInterface);
            }
          }
          _builder.append(" {");
          _builder.newLineIfNotEmpty();
          {
            if (((!preConditions.isEmpty()) || (!postConditions.isEmpty()))) {
              _builder.append("\t");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("@");
              _builder.append(Inject.class, "\t");
              _builder.append(" protected ");
              _builder.append(ConditionValidator.class, "\t");
              _builder.append(" ");
              _builder.append(conditionValidatorId, "\t");
              _builder.append(";");
              _builder.newLineIfNotEmpty();
            }
          }
          {
            boolean _needsBuilder = FunctionGenerator.this._rosettaFunctionExtensions.needsBuilder(output);
            if (_needsBuilder) {
              _builder.append("\t");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("@");
              _builder.append(Inject.class, "\t");
              _builder.append(" protected ");
              _builder.append(ModelObjectValidator.class, "\t");
              _builder.append(" ");
              _builder.append(objectValidatorId, "\t");
              _builder.append(";");
              _builder.newLineIfNotEmpty();
            }
          }
          {
            boolean _isEmpty = dependencies.isEmpty();
            boolean _not = (!_isEmpty);
            if (_not) {
              _builder.append("\t");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("// RosettaFunction dependencies");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("//");
              _builder.newLine();
            }
          }
          {
            for(final JavaClass<?> dep : dependencies) {
              _builder.append("\t");
              _builder.append("@");
              _builder.append(Inject.class, "\t");
              _builder.append(" protected ");
              _builder.append(dep, "\t");
              _builder.append(" ");
              GeneratedIdentifier _identifierOrThrow = classScope.getIdentifierOrThrow(FunctionGenerator.this._javaIdentifierRepresentationService.toDependencyInstance(dep));
              _builder.append(_identifierOrThrow, "\t");
              _builder.append(";");
              _builder.newLineIfNotEmpty();
            }
          }
          _builder.newLine();
          _builder.append("\t");
          _builder.append("/**");
          _builder.newLine();
          {
            for(final RAttribute input : inputs) {
              _builder.append("\t");
              _builder.append("* @param ");
              GeneratedIdentifier _identifierOrThrow_1 = evaluateScope.getIdentifierOrThrow(input);
              _builder.append(_identifierOrThrow_1, "\t");
              _builder.append(" ");
              CharSequence _escape = ModelGeneratorUtil.escape(input.getDefinition());
              _builder.append(_escape, "\t");
              _builder.newLineIfNotEmpty();
            }
          }
          _builder.append("\t");
          _builder.append("* @return ");
          GeneratedIdentifier _identifierOrThrow_2 = evaluateScope.getIdentifierOrThrow(output);
          _builder.append(_identifierOrThrow_2, "\t");
          _builder.append(" ");
          CharSequence _escape_1 = ModelGeneratorUtil.escape(output.getDefinition());
          _builder.append(_escape_1, "\t");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("*/");
          _builder.newLine();
          {
            if (overridesEvaluate) {
              _builder.append("\t");
              _builder.append("@Override");
              _builder.newLine();
            }
          }
          _builder.append("\t");
          _builder.append("public ");
          _builder.append(outputType, "\t");
          _builder.append(" evaluate(");
          StringConcatenationClient _inputsAsParameters = FunctionGenerator.this.inputsAsParameters(inputs, evaluateScope);
          _builder.append(_inputsAsParameters, "\t");
          _builder.append(") {");
          _builder.newLineIfNotEmpty();
          {
            boolean _isEmpty_1 = preConditions.isEmpty();
            boolean _not_1 = (!_isEmpty_1);
            if (_not_1) {
              _builder.append("\t\t");
              _builder.append("// pre-conditions");
              _builder.newLine();
              {
                for(final Condition cond : preConditions) {
                  _builder.append("\t\t");
                  StringConcatenationClient _contributeCondition = FunctionGenerator.this.contributeCondition(cond, conditionValidatorId, evaluateScope);
                  _builder.append(_contributeCondition, "\t\t");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t\t");
                  _builder.newLine();
                }
              }
            }
          }
          _builder.append("\t\t");
          JavaType _builderType = FunctionGenerator.this.toBuilderType(output);
          _builder.append(_builderType, "\t\t");
          _builder.append(" ");
          {
            boolean _needsBuilder_1 = FunctionGenerator.this._rosettaFunctionExtensions.needsBuilder(output);
            if (_needsBuilder_1) {
              _builder.append(outputBuilderId, "\t\t");
            } else {
              GeneratedIdentifier _identifierOrThrow_3 = evaluateScope.getIdentifierOrThrow(output);
              _builder.append(_identifierOrThrow_3, "\t\t");
            }
          }
          _builder.append(" = doEvaluate(");
          StringConcatenationClient _inputsAsArguments = FunctionGenerator.this.inputsAsArguments(inputs, evaluateScope);
          _builder.append(_inputsAsArguments, "\t\t");
          _builder.append(");");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          _builder.newLine();
          {
            boolean _needsBuilder_2 = FunctionGenerator.this._rosettaFunctionExtensions.needsBuilder(output);
            if (_needsBuilder_2) {
              _builder.append("\t\t");
              _builder.append("final ");
              _builder.append(outputType, "\t\t");
              _builder.append(" ");
              GeneratedIdentifier _identifierOrThrow_4 = evaluateScope.getIdentifierOrThrow(output);
              _builder.append(_identifierOrThrow_4, "\t\t");
              _builder.append(";");
              _builder.newLineIfNotEmpty();
              _builder.append("\t\t");
              _builder.append("if (");
              _builder.append(outputBuilderId, "\t\t");
              _builder.append(" == null) {");
              _builder.newLineIfNotEmpty();
              _builder.append("\t\t");
              _builder.append("\t");
              GeneratedIdentifier _identifierOrThrow_5 = evaluateScope.getIdentifierOrThrow(output);
              _builder.append(_identifierOrThrow_5, "\t\t\t");
              _builder.append(" = null;");
              _builder.newLineIfNotEmpty();
              _builder.append("\t\t");
              _builder.append("} else {");
              _builder.newLine();
              _builder.append("\t\t");
              _builder.append("\t");
              GeneratedIdentifier _identifierOrThrow_6 = evaluateScope.getIdentifierOrThrow(output);
              _builder.append(_identifierOrThrow_6, "\t\t\t");
              _builder.append(" = ");
              _builder.append(outputBuilderId, "\t\t\t");
              {
                boolean _isMulti = output.isMulti();
                if (_isMulti) {
                  _builder.append(".stream().map(");
                  JavaReferenceType _javaReferenceType = FunctionGenerator.this._javaTypeTranslator.toJavaReferenceType(output.getRType());
                  _builder.append(_javaReferenceType, "\t\t\t");
                  _builder.append("::build).collect(");
                  _builder.append(Collectors.class, "\t\t\t");
                  _builder.append(".toList())");
                } else {
                  _builder.append(".build()");
                }
              }
              _builder.append(";");
              _builder.newLineIfNotEmpty();
              _builder.append("\t\t");
              _builder.append("\t");
              _builder.append(objectValidatorId, "\t\t\t");
              _builder.append(".validate(");
              JavaReferenceType _javaReferenceType_1 = FunctionGenerator.this._javaTypeTranslator.toJavaReferenceType(output.getRType());
              _builder.append(_javaReferenceType_1, "\t\t\t");
              _builder.append(".class, ");
              GeneratedIdentifier _identifierOrThrow_7 = evaluateScope.getIdentifierOrThrow(output);
              _builder.append(_identifierOrThrow_7, "\t\t\t");
              _builder.append(");");
              _builder.newLineIfNotEmpty();
              _builder.append("\t\t");
              _builder.append("}");
              _builder.newLine();
              _builder.append("\t\t");
              _builder.newLine();
            }
          }
          {
            boolean _isEmpty_2 = postConditions.isEmpty();
            boolean _not_2 = (!_isEmpty_2);
            if (_not_2) {
              _builder.append("\t\t");
              _builder.append("// post-conditions");
              _builder.newLine();
              {
                for(final Condition cond_1 : postConditions) {
                  _builder.append("\t\t");
                  StringConcatenationClient _contributeCondition_1 = FunctionGenerator.this.contributeCondition(cond_1, conditionValidatorId, evaluateScope);
                  _builder.append(_contributeCondition_1, "\t\t");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t\t");
                  _builder.newLine();
                }
              }
            }
          }
          _builder.append("\t\t");
          _builder.append("return ");
          GeneratedIdentifier _identifierOrThrow_8 = evaluateScope.getIdentifierOrThrow(output);
          _builder.append(_identifierOrThrow_8, "\t\t");
          _builder.append(";");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.newLine();
          _builder.append("\t");
          _builder.append("protected abstract ");
          JavaType _builderType_1 = FunctionGenerator.this.toBuilderType(output);
          _builder.append(_builderType_1, "\t");
          _builder.append(" doEvaluate(");
          StringConcatenationClient _inputsAsParameters_1 = FunctionGenerator.this.inputsAsParameters(inputs, doEvaluateScope);
          _builder.append(_inputsAsParameters_1, "\t");
          _builder.append(");");
          _builder.newLineIfNotEmpty();
          {
            for(final RShortcut alias : shortcuts) {
              final JavaScope aliasScope = aliasScopes.get(alias);
              _builder.newLineIfNotEmpty();
              {
                Boolean _get = aliasOut.get(alias);
                if ((_get).booleanValue()) {
                  final boolean multi = FunctionGenerator.this.cardinality.isMulti(alias.getExpression());
                  _builder.newLineIfNotEmpty();
                  final JavaReferenceType returnType = FunctionGenerator.this.shortcutJavaType(alias);
                  _builder.newLineIfNotEmpty();
                  _builder.newLine();
                  _builder.append("\t");
                  _builder.append("protected abstract ");
                  {
                    if (multi) {
                      _builder.append(List.class, "\t");
                      _builder.append("<");
                      _builder.append(returnType, "\t");
                      _builder.append(">");
                    } else {
                      _builder.append(returnType, "\t");
                    }
                  }
                  _builder.append(" ");
                  GeneratedIdentifier _identifierOrThrow_9 = classScope.getIdentifierOrThrow(alias);
                  _builder.append(_identifierOrThrow_9, "\t");
                  _builder.append("(");
                  JavaType _builderType_2 = FunctionGenerator.this.toBuilderType(output);
                  _builder.append(_builderType_2, "\t");
                  _builder.append(" ");
                  GeneratedIdentifier _identifierOrThrow_10 = aliasScope.getIdentifierOrThrow(output);
                  _builder.append(_identifierOrThrow_10, "\t");
                  _builder.append(", ");
                  {
                    boolean _isEmpty_3 = inputs.isEmpty();
                    boolean _not_3 = (!_isEmpty_3);
                    if (_not_3) {
                      StringConcatenationClient _inputsAsParameters_2 = FunctionGenerator.this.inputsAsParameters(inputs, aliasScope);
                      _builder.append(_inputsAsParameters_2, "\t");
                    }
                  }
                  _builder.append(");");
                  _builder.newLineIfNotEmpty();
                } else {
                  final boolean multi_1 = FunctionGenerator.this.cardinality.isMulti(alias.getExpression());
                  _builder.newLineIfNotEmpty();
                  JavaGenericTypeDeclaration<?> _xifexpression = null;
                  if (multi_1) {
                    _xifexpression = ((JavaGenericTypeDeclaration<?>) FunctionGenerator.this._javaTypeUtil.MAPPER_C);
                  } else {
                    _xifexpression = FunctionGenerator.this._javaTypeUtil.MAPPER_S;
                  }
                  final JavaParameterizedType<?> returnType_1 = FunctionGenerator.this._javaTypeUtil.wrapExtendsIfNotFinal(_xifexpression, alias.getExpression());
                  _builder.newLineIfNotEmpty();
                  _builder.newLine();
                  _builder.append("\t");
                  _builder.append("protected abstract ");
                  _builder.append(returnType_1, "\t");
                  _builder.append(" ");
                  GeneratedIdentifier _identifierOrThrow_11 = classScope.getIdentifierOrThrow(alias);
                  _builder.append(_identifierOrThrow_11, "\t");
                  _builder.append("(");
                  StringConcatenationClient _inputsAsParameters_3 = FunctionGenerator.this.inputsAsParameters(inputs, aliasScope);
                  _builder.append(_inputsAsParameters_3, "\t");
                  _builder.append(");");
                  _builder.newLineIfNotEmpty();
                }
              }
            }
          }
          _builder.newLine();
          _builder.append("\t");
          _builder.append("public static class ");
          _builder.append(defaultClassName, "\t");
          _builder.append(" extends ");
          _builder.append(className, "\t");
          _builder.append(" {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          _builder.append("@Override");
          _builder.newLine();
          _builder.append("\t\t");
          _builder.append("protected ");
          JavaType _builderType_3 = FunctionGenerator.this.toBuilderType(output);
          _builder.append(_builderType_3, "\t\t");
          _builder.append(" doEvaluate(");
          StringConcatenationClient _inputsAsParameters_4 = FunctionGenerator.this.inputsAsParameters(inputs, doEvaluateScope);
          _builder.append(_inputsAsParameters_4, "\t\t");
          _builder.append(") {");
          _builder.newLineIfNotEmpty();
          {
            final Function1<RAttribute, Boolean> _function = (RAttribute it) -> {
              return Boolean.valueOf(it.isMulti());
            };
            Iterable<RAttribute> _filter = IterableExtensions.<RAttribute>filter(inputs, _function);
            for(final RAttribute input_1 : _filter) {
              _builder.append("\t\t\t");
              _builder.append("if (");
              GeneratedIdentifier _identifierOrThrow_12 = doEvaluateScope.getIdentifierOrThrow(input_1);
              _builder.append(_identifierOrThrow_12, "\t\t\t");
              _builder.append(" == null) {");
              _builder.newLineIfNotEmpty();
              _builder.append("\t\t\t");
              _builder.append("\t");
              GeneratedIdentifier _identifierOrThrow_13 = doEvaluateScope.getIdentifierOrThrow(input_1);
              _builder.append(_identifierOrThrow_13, "\t\t\t\t");
              _builder.append(" = ");
              _builder.append(Collections.class, "\t\t\t\t");
              _builder.append(".emptyList();");
              _builder.newLineIfNotEmpty();
              _builder.append("\t\t\t");
              _builder.append("}");
              _builder.newLine();
            }
          }
          _builder.append("\t\t\t");
          JavaType _builderType_4 = FunctionGenerator.this.toBuilderType(output);
          _builder.append(_builderType_4, "\t\t\t");
          _builder.append(" ");
          GeneratedIdentifier _identifierOrThrow_14 = doEvaluateScope.getIdentifierOrThrow(output);
          _builder.append(_identifierOrThrow_14, "\t\t\t");
          _builder.append(" = ");
          {
            boolean _isMulti_1 = output.isMulti();
            if (_isMulti_1) {
              _builder.append("new ");
              _builder.append(ArrayList.class, "\t\t\t");
              _builder.append("<>()");
            } else {
              boolean _needsBuilder_3 = FunctionGenerator.this._rosettaFunctionExtensions.needsBuilder(output);
              if (_needsBuilder_3) {
                JavaReferenceType _listOrSingleJavaType = FunctionGenerator.this._javaTypeTranslator.toListOrSingleJavaType(output.getRType(), output.isMulti());
                _builder.append(_listOrSingleJavaType, "\t\t\t");
                _builder.append(".builder()");
              } else {
                _builder.append("null");
              }
            }
          }
          _builder.append(";");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t\t");
          _builder.append("return assignOutput(");
          GeneratedIdentifier _identifierOrThrow_15 = doEvaluateScope.getIdentifierOrThrow(output);
          _builder.append(_identifierOrThrow_15, "\t\t\t");
          {
            boolean _isEmpty_4 = inputs.isEmpty();
            boolean _not_4 = (!_isEmpty_4);
            if (_not_4) {
              _builder.append(", ");
            }
          }
          StringConcatenationClient _inputsAsArguments_1 = FunctionGenerator.this.inputsAsArguments(inputs, doEvaluateScope);
          _builder.append(_inputsAsArguments_1, "\t\t\t");
          _builder.append(");");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          _builder.append("}");
          _builder.newLine();
          _builder.append("\t\t");
          _builder.newLine();
          _builder.append("\t\t");
          _builder.append("protected ");
          JavaType _builderType_5 = FunctionGenerator.this.toBuilderType(output);
          _builder.append(_builderType_5, "\t\t");
          _builder.append(" assignOutput(");
          JavaType _builderType_6 = FunctionGenerator.this.toBuilderType(output);
          _builder.append(_builderType_6, "\t\t");
          _builder.append(" ");
          GeneratedIdentifier _identifierOrThrow_16 = assignOutputScope.getIdentifierOrThrow(output);
          _builder.append(_identifierOrThrow_16, "\t\t");
          {
            boolean _isEmpty_5 = inputs.isEmpty();
            boolean _not_5 = (!_isEmpty_5);
            if (_not_5) {
              _builder.append(", ");
            }
          }
          StringConcatenationClient _inputsAsParameters_5 = FunctionGenerator.this.inputsAsParameters(inputs, assignOutputScope);
          _builder.append(_inputsAsParameters_5, "\t\t");
          _builder.append(") {");
          _builder.newLineIfNotEmpty();
          {
            for(final ROperation operation : operations) {
              _builder.append("\t\t\t");
              JavaStatementList _asStatementList = FunctionGenerator.this.assign(assignOutputScope, operation, function, aliasOut, output).asStatementList();
              _builder.append(_asStatementList, "\t\t\t");
              _builder.newLineIfNotEmpty();
              _builder.append("\t\t\t");
              _builder.newLine();
            }
          }
          _builder.append("\t\t\t");
          _builder.append("return ");
          {
            boolean _needsBuilder_4 = FunctionGenerator.this._rosettaFunctionExtensions.needsBuilder(output);
            boolean _not_6 = (!_needsBuilder_4);
            if (_not_6) {
              GeneratedIdentifier _identifierOrThrow_17 = assignOutputScope.getIdentifierOrThrow(output);
              _builder.append(_identifierOrThrow_17, "\t\t\t");
            } else {
              _builder.append(Optional.class, "\t\t\t");
              _builder.append(".ofNullable(");
              GeneratedIdentifier _identifierOrThrow_18 = assignOutputScope.getIdentifierOrThrow(output);
              _builder.append(_identifierOrThrow_18, "\t\t\t");
              _builder.append(")");
              _builder.newLineIfNotEmpty();
              _builder.append("\t\t\t");
              _builder.append("\t");
              _builder.append(".map(");
              {
                boolean _isMulti_2 = output.isMulti();
                if (_isMulti_2) {
                  _builder.append("o -> o.stream().map(i -> i.prune()).collect(");
                  _builder.append(Collectors.class, "\t\t\t\t");
                  _builder.append(".toList())");
                } else {
                  _builder.append("o -> o.prune()");
                }
              }
              _builder.append(")");
              _builder.newLineIfNotEmpty();
              _builder.append("\t\t\t");
              _builder.append("\t");
              _builder.append(".orElse(null)");
            }
          }
          _builder.append(";");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          _builder.append("}");
          _builder.newLine();
          {
            for(final RShortcut alias_1 : shortcuts) {
              _builder.append("\t\t");
              final JavaScope aliasScope_1 = aliasScopes.get(alias_1);
              _builder.newLineIfNotEmpty();
              {
                Boolean _get_1 = aliasOut.get(alias_1);
                if ((_get_1).booleanValue()) {
                  _builder.append("\t\t");
                  final boolean multi_2 = FunctionGenerator.this.cardinality.isMulti(alias_1.getExpression());
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t\t");
                  final JavaReferenceType itemReturnType = FunctionGenerator.this.shortcutJavaType(alias_1);
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t\t");
                  JavaReferenceType _xifexpression_1 = null;
                  if (multi_2) {
                    _xifexpression_1 = FunctionGenerator.this._javaTypeUtil.<List<?>>wrap(FunctionGenerator.this._javaTypeUtil.LIST, itemReturnType);
                  } else {
                    _xifexpression_1 = itemReturnType;
                  }
                  final JavaReferenceType returnType_2 = _xifexpression_1;
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t\t");
                  final java.util.function.Function<JavaExpression, JavaStatementBuilder> _function_1 = (JavaExpression it) -> {
                    StringConcatenationClient _client = new StringConcatenationClient() {
                      @Override
                      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append("toBuilder(");
                        _builder.append(it);
                        _builder.append(")");
                      }
                    };
                    return JavaExpression.from(_client, returnType_2);
                  };
                  final JavaStatementBuilder body = FunctionGenerator.this.expressionGenerator.javaCode(alias_1.getExpression(), FunctionGenerator.this.shortcutExpressionJavaType(alias_1), aliasScope_1).mapExpressionIfNotNull(_function_1);
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t\t");
                  _builder.newLine();
                  _builder.append("\t\t");
                  _builder.append("@Override");
                  _builder.newLine();
                  _builder.append("\t\t");
                  _builder.append("protected ");
                  _builder.append(returnType_2, "\t\t");
                  _builder.append(" ");
                  GeneratedIdentifier _identifierOrThrow_19 = classScope.getIdentifierOrThrow(alias_1);
                  _builder.append(_identifierOrThrow_19, "\t\t");
                  _builder.append("(");
                  JavaType _builderType_7 = FunctionGenerator.this.toBuilderType(output);
                  _builder.append(_builderType_7, "\t\t");
                  _builder.append(" ");
                  GeneratedIdentifier _identifierOrThrow_20 = aliasScope_1.getIdentifierOrThrow(output);
                  _builder.append(_identifierOrThrow_20, "\t\t");
                  _builder.append(", ");
                  {
                    boolean _isEmpty_6 = inputs.isEmpty();
                    boolean _not_7 = (!_isEmpty_6);
                    if (_not_7) {
                      StringConcatenationClient _inputsAsParameters_6 = FunctionGenerator.this.inputsAsParameters(inputs, aliasScope_1);
                      _builder.append(_inputsAsParameters_6, "\t\t");
                    }
                  }
                  _builder.append(") ");
                  JavaBlock _block = body.completeAsReturn().toBlock();
                  _builder.append(_block, "\t\t");
                  _builder.newLineIfNotEmpty();
                } else {
                  _builder.append("\t\t");
                  final boolean multi_3 = FunctionGenerator.this.cardinality.isMulti(alias_1.getExpression());
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t\t");
                  JavaGenericTypeDeclaration<?> _xifexpression_2 = null;
                  if (multi_3) {
                    _xifexpression_2 = ((JavaGenericTypeDeclaration<?>) FunctionGenerator.this._javaTypeUtil.MAPPER_C);
                  } else {
                    _xifexpression_2 = FunctionGenerator.this._javaTypeUtil.MAPPER_S;
                  }
                  final JavaParameterizedType<?> returnType_3 = FunctionGenerator.this._javaTypeUtil.wrapExtendsIfNotFinal(_xifexpression_2, alias_1.getExpression());
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t\t");
                  _builder.newLine();
                  _builder.append("\t\t");
                  _builder.append("@Override");
                  _builder.newLine();
                  _builder.append("\t\t");
                  _builder.append("protected ");
                  _builder.append(returnType_3, "\t\t");
                  _builder.append(" ");
                  GeneratedIdentifier _identifierOrThrow_21 = classScope.getIdentifierOrThrow(alias_1);
                  _builder.append(_identifierOrThrow_21, "\t\t");
                  _builder.append("(");
                  StringConcatenationClient _inputsAsParameters_7 = FunctionGenerator.this.inputsAsParameters(inputs, aliasScope_1);
                  _builder.append(_inputsAsParameters_7, "\t\t");
                  _builder.append(") ");
                  JavaBlock _block_1 = FunctionGenerator.this.expressionGenerator.javaCode(alias_1.getExpression(), returnType_3, aliasScope_1).completeAsReturn().toBlock();
                  _builder.append(_block_1, "\t\t");
                  _builder.newLineIfNotEmpty();
                }
              }
            }
          }
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          {
            boolean _isQualifierFunction = FunctionGenerator.this._rosettaFunctionExtensions.isQualifierFunction(function);
            if (_isQualifierFunction) {
              _builder.append("\t\t");
              _builder.newLine();
              _builder.append("\t\t");
              _builder.append("@Override");
              _builder.newLine();
              _builder.append("\t\t");
              _builder.append("public String getNamePrefix() {");
              _builder.newLine();
              _builder.append("\t\t");
              _builder.append("\t");
              _builder.append("return \"");
              String _prefix = IterableExtensions.<AnnotationRef>head(FunctionGenerator.this._rosettaFunctionExtensions.getQualifierAnnotations(function.getAnnotations())).getAnnotation().getPrefix();
              _builder.append(_prefix, "\t\t\t");
              _builder.append("\";");
              _builder.newLineIfNotEmpty();
              _builder.append("\t\t");
              _builder.append("}");
              _builder.newLine();
            }
          }
          _builder.append("}");
          _builder.newLine();
        }
      };
      _xblockexpression = _client;
    }
    return _xblockexpression;
  }

  private StringConcatenationClient dispatchClassBody(final Function function, final JavaScope topScope, final List<JavaClass<?>> dependencies, final String version, final RosettaJavaPackages.RootPackage root) {
    StringConcatenationClient _xblockexpression = null;
    {
      final Function1<FunctionDispatch, String> _function = (FunctionDispatch it) -> {
        return it.getName();
      };
      final List<FunctionDispatch> dispatchingFuncs = IterableExtensions.<FunctionDispatch>toList(IterableExtensions.<FunctionDispatch, String>sortBy(this._rosettaFunctionExtensions.getDispatchingFunctions(function), _function));
      final Function1<Attribute, Boolean> _function_1 = (Attribute it) -> {
        RosettaType _type = it.getTypeCall().getType();
        return Boolean.valueOf((_type instanceof RosettaEnumeration));
      };
      final String enumParam = IterableExtensions.<Attribute>head(IterableExtensions.<Attribute>filter(function.getInputs(), _function_1)).getName();
      final JavaType outputType = this.outputTypeOrVoid(function);
      final GeneratedIdentifier className = topScope.getIdentifierOrThrow(function);
      final JavaScope classScope = topScope.classScope(className.getDesiredName());
      final Consumer<FunctionDispatch> _function_2 = (FunctionDispatch it) -> {
        String _name = function.getName();
        String _firstUpper = StringExtensions.toFirstUpper(it.getValue().getValue().getName());
        classScope.createIdentifier(it, StringExtensions.toFirstLower((_name + _firstUpper)));
      };
      dispatchingFuncs.forEach(_function_2);
      final JavaScope evaluateScope = classScope.methodScope("evaluate");
      final Consumer<Attribute> _function_3 = (Attribute it) -> {
        evaluateScope.createIdentifier(it);
      };
      function.getInputs().forEach(_function_3);
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          String _javadoc = ModelGeneratorUtil.javadoc(function, version);
          _builder.append(_javadoc);
          _builder.newLineIfNotEmpty();
          _builder.append("public class ");
          _builder.append(className);
          _builder.append(" implements ");
          _builder.append(RosettaFunction.class);
          _builder.append(" {");
          _builder.newLineIfNotEmpty();
          {
            for(final JavaClass<?> dep : dependencies) {
              _builder.append("\t");
              _builder.append("@");
              _builder.append(Inject.class, "\t");
              _builder.append(" protected ");
              _builder.append(dep, "\t");
              _builder.append(" ");
              String _firstLower = StringExtensions.toFirstLower(dep.getSimpleName());
              _builder.append(_firstLower, "\t");
              _builder.append(";");
              _builder.newLineIfNotEmpty();
            }
          }
          _builder.append("\t");
          _builder.newLine();
          {
            for(final FunctionDispatch enumFunc : dispatchingFuncs) {
              _builder.append("\t");
              _builder.append("@");
              _builder.append(Inject.class, "\t");
              _builder.append(" protected ");
              JavaClass<?> _dispatchClass = FunctionGenerator.this.toDispatchClass(enumFunc);
              _builder.append(_dispatchClass, "\t");
              _builder.append(" ");
              GeneratedIdentifier _identifierOrThrow = classScope.getIdentifierOrThrow(enumFunc);
              _builder.append(_identifierOrThrow, "\t");
              _builder.append(";");
              _builder.newLineIfNotEmpty();
            }
          }
          _builder.append("\t");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("public ");
          _builder.append(outputType, "\t");
          _builder.append(" evaluate(");
          StringConcatenationClient _inputsAsParameters = FunctionGenerator.this.inputsAsParameters(function, evaluateScope);
          _builder.append(_inputsAsParameters, "\t");
          _builder.append(") {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          _builder.append("switch (");
          _builder.append(enumParam, "\t\t");
          _builder.append(") {");
          _builder.newLineIfNotEmpty();
          {
            for(final FunctionDispatch enumFunc_1 : dispatchingFuncs) {
              _builder.append("\t\t\t");
              _builder.append("case ");
              String _formatEnumName = EnumHelper.formatEnumName(enumFunc_1.getValue().getValue().getName());
              _builder.append(_formatEnumName, "\t\t\t");
              _builder.append(":");
              _builder.newLineIfNotEmpty();
              _builder.append("\t\t\t");
              _builder.append("\t");
              _builder.append("return ");
              GeneratedIdentifier _identifierOrThrow_1 = classScope.getIdentifierOrThrow(enumFunc_1);
              _builder.append(_identifierOrThrow_1, "\t\t\t\t");
              _builder.append(".evaluate(");
              StringConcatenationClient _inputsAsArguments = FunctionGenerator.this.inputsAsArguments(function, evaluateScope);
              _builder.append(_inputsAsArguments, "\t\t\t\t");
              _builder.append(");");
              _builder.newLineIfNotEmpty();
            }
          }
          _builder.append("\t\t\t");
          _builder.append("default:");
          _builder.newLine();
          _builder.append("\t\t\t\t");
          _builder.append("throw new IllegalArgumentException(\"Enum value not implemented: \" + ");
          _builder.append(enumParam, "\t\t\t\t");
          _builder.append(");");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          _builder.append("}");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.append("\t");
          _builder.newLine();
          {
            for(final FunctionDispatch enumFunc_2 : dispatchingFuncs) {
              _builder.append("\t");
              DottedPath _splitOnDots = DottedPath.splitOnDots(function.getModel().getName());
              String _name = function.getName();
              String _formatEnumName_1 = EnumHelper.formatEnumName(enumFunc_2.getValue().getValue().getName());
              String _plus = (_name + _formatEnumName_1);
              ModelSymbolId _modelSymbolId = new ModelSymbolId(_splitOnDots, _plus);
              String _definition = enumFunc_2.getDefinition();
              final Function1<Attribute, RAttribute> _function = (Attribute it) -> {
                return FunctionGenerator.this.rTypeBuilderFactory.buildRAttribute(it);
              };
              List<RAttribute> _map = ListExtensions.<Attribute, RAttribute>map(function.getInputs(), _function);
              RAttribute _buildRAttribute = FunctionGenerator.this.rTypeBuilderFactory.buildRAttribute(function.getOutput());
              EList<Condition> _conditions = enumFunc_2.getConditions();
              EList<Condition> _postConditions = enumFunc_2.getPostConditions();
              EList<ShortcutDeclaration> _shortcuts = function.getShortcuts();
              EList<ShortcutDeclaration> _shortcuts_1 = enumFunc_2.getShortcuts();
              final Function1<ShortcutDeclaration, RShortcut> _function_1 = (ShortcutDeclaration it) -> {
                return FunctionGenerator.this.rTypeBuilderFactory.buildRShortcut(it);
              };
              List<RShortcut> _map_1 = ListExtensions.<ShortcutDeclaration, RShortcut>map(IterableExtensions.<ShortcutDeclaration>toList(Iterables.<ShortcutDeclaration>concat(_shortcuts, _shortcuts_1)), _function_1);
              final Function1<Operation, ROperation> _function_2 = (Operation it) -> {
                return FunctionGenerator.this.rTypeBuilderFactory.buildROperation(it);
              };
              List<ROperation> _map_2 = ListExtensions.<Operation, ROperation>map(enumFunc_2.getOperations(), _function_2);
              EList<AnnotationRef> _annotations = enumFunc_2.getAnnotations();
              final RFunction rFunction = new RFunction(_modelSymbolId, _definition, _map, _buildRAttribute, 
                RFunctionOrigin.FUNCTION, _conditions, _postConditions, _map_1, _map_2, _annotations);
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              JavaClass<RosettaFunction> _from = JavaClass.<RosettaFunction>from(RosettaFunction.class);
              StringConcatenationClient _rBuildClass = FunctionGenerator.this.rBuildClass(rFunction, true, Collections.<JavaType>unmodifiableList(CollectionLiterals.<JavaType>newArrayList(_from)), CollectionLiterals.<Class<?>, String>emptyMap(), false, classScope);
              _builder.append(_rBuildClass, "\t");
              _builder.newLineIfNotEmpty();
            }
          }
          _builder.append("}");
        }
      };
      _xblockexpression = _client;
    }
    return _xblockexpression;
  }

  private JavaClass<?> toDispatchClass(final FunctionDispatch ele) {
    DottedPath _child = DottedPath.splitOnDots(ele.getModel().getName()).child("functions");
    String _name = ele.getName();
    String _plus = (_name + ".");
    String _name_1 = ele.getName();
    String _plus_1 = (_plus + _name_1);
    String _formatEnumName = EnumHelper.formatEnumName(ele.getValue().getValue().getName());
    String _plus_2 = (_plus_1 + _formatEnumName);
    return new GeneratedJavaClass<Object>(_child, _plus_2, Object.class);
  }

  private boolean assignAsKey(final ROperation op) {
    RosettaExpression _expression = op.getExpression();
    return (_expression instanceof AsKeyOperation);
  }

  private JavaStatement assign(final JavaScope scope, final ROperation op, final RFunction function, final Map<RShortcut, Boolean> outs, final RAttribute attribute) {
    JavaStatement _xifexpression = null;
    boolean _isEmpty = op.getPathTail().isEmpty();
    if (_isEmpty) {
      JavaStatement _xblockexpression = null;
      {
        final JavaReferenceType expressionType = this._javaTypeTranslator.attributeToJavaType(attribute);
        JavaStatementBuilder javaExpr = this.expressionGenerator.javaCode(op.getExpression(), expressionType, scope);
        final JavaType effectiveExprType = javaExpr.getExpressionType();
        boolean _needsBuilder = this._rosettaFunctionExtensions.needsBuilder(attribute);
        if (_needsBuilder) {
          final java.util.function.Function<JavaExpression, JavaStatementBuilder> _function = (JavaExpression it) -> {
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("toBuilder(");
                _builder.append(it);
                _builder.append(")");
              }
            };
            return JavaExpression.from(_client, this.toBuilderType(attribute));
          };
          javaExpr = javaExpr.mapExpressionIfNotNull(_function);
        } else {
          final boolean needsToCopy = ((Objects.equal(op.getROperationType(), ROperationType.SET) && this._javaTypeUtil.isList(effectiveExprType)) && IterableExtensions.<ROperation>exists(function.getOperations(), ((Function1<ROperation, Boolean>) (ROperation o) -> {
            ROperationType _rOperationType = o.getROperationType();
            return Boolean.valueOf(Objects.equal(_rOperationType, ROperationType.ADD));
          })));
          if (needsToCopy) {
            final java.util.function.Function<JavaExpression, JavaStatementBuilder> _function_1 = (JavaExpression it) -> {
              StringConcatenationClient _client = new StringConcatenationClient() {
                @Override
                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                  _builder.append("new ");
                  _builder.append(ArrayList.class);
                  _builder.append("<>(");
                  _builder.append(it);
                  _builder.append(")");
                }
              };
              return JavaExpression.from(_client, this._javaTypeUtil.<List<?>>wrap(this._javaTypeUtil.LIST, this._javaTypeUtil.getItemType(effectiveExprType)));
            };
            javaExpr = javaExpr.mapExpressionIfNotNull(_function_1);
          }
        }
        JavaStatement _switchResult = null;
        ROperationType _rOperationType = op.getROperationType();
        if (_rOperationType != null) {
          switch (_rOperationType) {
            case ADD:
              JavaStatement _xblockexpression_1 = null;
              {
                JavaType _xifexpression_1 = null;
                boolean _isMulti = attribute.isMulti();
                if (_isMulti) {
                  _xifexpression_1 = this._javaTypeUtil.<List<?>>wrapExtends(this._javaTypeUtil.LIST, this.toBuilderItemType(attribute));
                } else {
                  _xifexpression_1 = this.toBuilderItemType(attribute);
                }
                javaExpr = this.coercionService.addCoercions(javaExpr, _xifexpression_1, scope);
                final java.util.function.Function<JavaExpression, JavaStatementBuilder> _function_2 = (JavaExpression it) -> {
                  StringConcatenationClient _client = new StringConcatenationClient() {
                    @Override
                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                      StringConcatenationClient _assignTarget = FunctionGenerator.this.assignTarget(op, function, outs, scope);
                      _builder.append(_assignTarget);
                      _builder.append(".addAll(");
                      _builder.append(it);
                      _builder.append(")");
                    }
                  };
                  return JavaExpression.from(_client, 
                    JavaPrimitiveType.VOID);
                };
                _xblockexpression_1 = javaExpr.mapExpression(_function_2).completeAsExpressionStatement();
              }
              _switchResult = _xblockexpression_1;
              break;
            case SET:
              JavaStatement _xblockexpression_2 = null;
              {
                javaExpr = this.coercionService.addCoercions(javaExpr, this.toBuilderType(attribute), scope);
                final java.util.function.Function<JavaExpression, JavaStatementBuilder> _function_2 = (JavaExpression it) -> {
                  StringConcatenationClient _client = new StringConcatenationClient() {
                    @Override
                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                      StringConcatenationClient _assignTarget = FunctionGenerator.this.assignTarget(op, function, outs, scope);
                      _builder.append(_assignTarget);
                      _builder.append(" = ");
                      _builder.append(it);
                    }
                  };
                  return JavaExpression.from(_client, 
                    JavaPrimitiveType.VOID);
                };
                _xblockexpression_2 = javaExpr.mapExpression(_function_2).completeAsExpressionStatement();
              }
              _switchResult = _xblockexpression_2;
              break;
            default:
              break;
          }
        }
        _xblockexpression = _switchResult;
      }
      _xifexpression = _xblockexpression;
    } else {
      final java.util.function.Function<JavaExpression, JavaStatementBuilder> _function = (JavaExpression it) -> {
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            StringConcatenationClient _assignTarget = FunctionGenerator.this.assignTarget(op, function, outs, scope);
            _builder.append(_assignTarget);
            _builder.newLineIfNotEmpty();
            {
              Iterable<Pair<Integer, RAttribute>> _indexed = IterableExtensions.<RAttribute>indexed(op.getPathTail());
              for(final Pair<Integer, RAttribute> seg : _indexed) {
                {
                  Integer _key = seg.getKey();
                  int _size = op.getPathTail().size();
                  int _minus = (_size - 1);
                  boolean _lessThan = ((_key).intValue() < _minus);
                  if (_lessThan) {
                    _builder.append("\t");
                    _builder.append(".getOrCreate");
                    String _firstUpper = StringExtensions.toFirstUpper(seg.getValue().getName());
                    _builder.append(_firstUpper, "\t");
                    _builder.append("(");
                    {
                      boolean _isMulti = seg.getValue().isMulti();
                      if (_isMulti) {
                        _builder.append("0");
                      }
                    }
                    _builder.append(")");
                    {
                      boolean _isReference = FunctionGenerator.this._rosettaExtensions.isReference(seg.getValue());
                      if (_isReference) {
                        _builder.append(".getOrCreateValue()");
                      }
                    }
                    _builder.newLineIfNotEmpty();
                  } else {
                    _builder.append("\t");
                    _builder.append(".");
                    {
                      ROperationType _rOperationType = op.getROperationType();
                      boolean _equals = Objects.equal(_rOperationType, ROperationType.ADD);
                      if (_equals) {
                        _builder.append("add");
                      } else {
                        _builder.append("set");
                      }
                    }
                    String _firstUpper_1 = StringExtensions.toFirstUpper(seg.getValue().getName());
                    _builder.append(_firstUpper_1, "\t");
                    {
                      if ((FunctionGenerator.this._rosettaExtensions.isReference(seg.getValue()) && (!FunctionGenerator.this.assignAsKey(op)))) {
                        _builder.append("Value");
                      }
                    }
                    _builder.append("(");
                    _builder.append(it, "\t");
                    _builder.append(")");
                  }
                }
              }
            }
          }
        };
        return JavaExpression.from(_client, 
          JavaPrimitiveType.VOID);
      };
      _xifexpression = this.assignValue(scope, op, this.assignAsKey(op), IterableExtensions.<RAttribute>last(op.getPathTail()).isMulti()).collapseToSingleExpression(scope).mapExpression(_function).completeAsExpressionStatement();
    }
    return _xifexpression;
  }

  private JavaStatementBuilder assignValue(final JavaScope scope, final ROperation op, final boolean assignAsKey, final boolean isAssigneeMulti) {
    JavaStatementBuilder _xifexpression = null;
    if (assignAsKey) {
      JavaStatementBuilder _xblockexpression = null;
      {
        final JavaClass<?> metaClass = this._javaTypeTranslator.operationToReferenceWithMetaType(op);
        JavaStatementBuilder _xifexpression_1 = null;
        boolean _isMulti = this.cardinality.isMulti(op.getExpression());
        if (_isMulti) {
          JavaStatementBuilder _xblockexpression_1 = null;
          {
            final JavaScope lambdaScope = scope.lambdaScope();
            final GeneratedIdentifier item = lambdaScope.createUniqueIdentifier("item");
            final java.util.function.Function<JavaExpression, JavaStatementBuilder> _function = (JavaExpression it) -> {
              StringConcatenationClient _client = new StringConcatenationClient() {
                @Override
                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                  _builder.append(it);
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  _builder.append(".getItems()");
                  _builder.newLine();
                  _builder.append("\t");
                  _builder.append(".map(");
                  _builder.append(item, "\t");
                  _builder.append(" -> ");
                  _builder.append(metaClass, "\t");
                  _builder.append(".builder()");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t\t");
                  _builder.append(".setExternalReference(");
                  _builder.append(item, "\t\t");
                  _builder.append(".getMappedObject().getMeta().getExternalKey())");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t\t");
                  _builder.append(".setGlobalReference(");
                  _builder.append(item, "\t\t");
                  _builder.append(".getMappedObject().getMeta().getGlobalKey())");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t\t");
                  _builder.append(".build())");
                  _builder.newLine();
                  _builder.append("\t");
                  _builder.append(".collect(");
                  _builder.append(Collectors.class, "\t");
                  _builder.append(".toList())");
                  _builder.newLineIfNotEmpty();
                }
              };
              return JavaExpression.from(_client, 
                this._javaTypeUtil.<List<?>>wrap(this._javaTypeUtil.LIST, metaClass));
            };
            _xblockexpression_1 = this.expressionGenerator.javaCode(op.getExpression(), this._javaTypeUtil.<MapperC<?>>wrap(this._javaTypeUtil.MAPPER_C, op.getExpression()), scope).collapseToSingleExpression(scope).mapExpression(_function);
          }
          _xifexpression_1 = _xblockexpression_1;
        } else {
          JavaStatementBuilder _xblockexpression_2 = null;
          {
            final JavaScope lambdaScope = scope.lambdaScope();
            final GeneratedIdentifier r = lambdaScope.createUniqueIdentifier("r");
            final GeneratedIdentifier m = lambdaScope.createUniqueIdentifier("m");
            JavaStatementBuilder _javaCode = this.expressionGenerator.javaCode(op.getExpression(), this._javaTypeTranslator.toJavaReferenceType(this.typeProvider.getRType(op.getExpression())), scope);
            String _name = op.getPathHead().getName();
            final Function1<RAttribute, String> _function = (RAttribute it) -> {
              return StringExtensions.toFirstUpper(it.getName());
            };
            String _join = IterableExtensions.join(ListExtensions.<RAttribute, String>map(op.getPathTail(), _function));
            String _plus = (_name + _join);
            final java.util.function.Function<JavaExpression, JavaStatementBuilder> _function_1 = (JavaExpression it) -> {
              StringConcatenationClient _client = new StringConcatenationClient() {
                @Override
                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                  _builder.append(metaClass);
                  _builder.append(".builder()");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  _builder.append(".setGlobalReference(");
                  _builder.append(Optional.class, "\t");
                  _builder.append(".ofNullable(");
                  _builder.append(it, "\t");
                  _builder.append(")");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t\t");
                  _builder.append(".map(");
                  _builder.append(r, "\t\t");
                  _builder.append(" -> ");
                  _builder.append(r, "\t\t");
                  _builder.append(".getMeta())");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t\t");
                  _builder.append(".map(");
                  _builder.append(m, "\t\t");
                  _builder.append(" -> ");
                  _builder.append(m, "\t\t");
                  _builder.append(".getGlobalKey())");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t\t");
                  _builder.append(".orElse(null))");
                  _builder.newLine();
                  _builder.append("\t");
                  _builder.append(".setExternalReference(");
                  _builder.append(Optional.class, "\t");
                  _builder.append(".ofNullable(");
                  _builder.append(it, "\t");
                  _builder.append(")");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t\t");
                  _builder.append(".map(");
                  _builder.append(r, "\t\t");
                  _builder.append(" -> ");
                  _builder.append(r, "\t\t");
                  _builder.append(".getMeta())");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t\t");
                  _builder.append(".map(");
                  _builder.append(m, "\t\t");
                  _builder.append(" -> ");
                  _builder.append(m, "\t\t");
                  _builder.append(".getExternalKey())");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t\t");
                  _builder.append(".orElse(null))");
                  _builder.newLine();
                  _builder.append("\t");
                  _builder.append(".build()");
                  _builder.newLine();
                }
              };
              return JavaExpression.from(_client, metaClass);
            };
            _xblockexpression_2 = _javaCode.declareAsVariable(true, _plus, scope).mapExpression(_function_1);
          }
          _xifexpression_1 = _xblockexpression_2;
        }
        _xblockexpression = _xifexpression_1;
      }
      _xifexpression = _xblockexpression;
    } else {
      _xifexpression = this.expressionGenerator.javaCode(op.getExpression(), this._javaTypeTranslator.operationToJavaType(op), scope);
    }
    return _xifexpression;
  }

  private StringConcatenationClient assignTarget(final ROperation operation, final RFunction function, final Map<RShortcut, Boolean> outs, final JavaScope scope) {
    StringConcatenationClient _xblockexpression = null;
    {
      final RAssignedRoot root = operation.getPathHead();
      StringConcatenationClient _switchResult = null;
      boolean _matched = false;
      if (root instanceof RAttribute) {
        _matched=true;
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            GeneratedIdentifier _identifierOrThrow = scope.getIdentifierOrThrow(root);
            _builder.append(_identifierOrThrow);
          }
        };
        _switchResult = _client;
      }
      if (!_matched) {
        if (root instanceof RShortcut) {
          _matched=true;
          _switchResult = this.unfoldLHSShortcut(((RShortcut)root), function, scope);
        }
      }
      _xblockexpression = _switchResult;
    }
    return _xblockexpression;
  }

  private StringConcatenationClient unfoldLHSShortcut(final RShortcut shortcut, final RFunction function, final JavaScope scope) {
    final RosettaExpression e = shortcut.getExpression();
    if ((e instanceof RosettaSymbolReference)) {
      RosettaSymbol _symbol = ((RosettaSymbolReference)e).getSymbol();
      if ((_symbol instanceof RosettaCallableWithArgs)) {
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            GeneratedIdentifier _identifierOrThrow = scope.getIdentifierOrThrow(shortcut);
            _builder.append(_identifierOrThrow);
            _builder.append("(");
            StringConcatenationClient _aliasCallArgs = FunctionGenerator.this.expressionGenerator.aliasCallArgs(shortcut, function, scope);
            _builder.append(_aliasCallArgs);
            _builder.append(")");
          }
        };
        return _client;
      }
    }
    StringConcatenationClient _client_1 = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        StringConcatenationClient _lhsExpand = FunctionGenerator.this.lhsExpand(e, scope);
        _builder.append(_lhsExpand);
      }
    };
    return _client_1;
  }

  private StringConcatenationClient _lhsExpand(final RosettaExpression f, final JavaScope scope) {
    Class<? extends RosettaExpression> _class = f.getClass();
    String _plus = ("No implementation for lhsExpand for " + _class);
    throw new IllegalStateException(_plus);
  }

  private StringConcatenationClient _lhsExpand(final RosettaFeatureCall f, final JavaScope scope) {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        StringConcatenationClient _lhsExpand = FunctionGenerator.this.lhsExpand(f.getReceiver(), scope);
        _builder.append(_lhsExpand);
        _builder.append(".");
        StringConcatenationClient _lhsFeature = FunctionGenerator.this.lhsFeature(f.getFeature());
        _builder.append(_lhsFeature);
      }
    };
    return _client;
  }

  private StringConcatenationClient _lhsExpand(final RosettaSymbolReference f, final JavaScope scope) {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        StringConcatenationClient _lhsExpand = FunctionGenerator.this.lhsExpand(f.getSymbol(), scope);
        _builder.append(_lhsExpand);
      }
    };
    return _client;
  }

  private StringConcatenationClient _lhsExpand(final ShortcutDeclaration f, final JavaScope scope) {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        StringConcatenationClient _lhsExpand = FunctionGenerator.this.lhsExpand(f.getExpression(), scope);
        _builder.append(_lhsExpand);
      }
    };
    return _client;
  }

  private StringConcatenationClient _lhsExpand(final RosettaUnaryOperation f, final JavaScope scope) {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        StringConcatenationClient _lhsExpand = FunctionGenerator.this.lhsExpand(f.getArgument(), scope);
        _builder.append(_lhsExpand);
      }
    };
    return _client;
  }

  private StringConcatenationClient _lhsFeature(final RosettaFeature f) {
    Class<? extends RosettaFeature> _class = f.getClass();
    String _plus = ("No implementation for lhsFeature for " + _class);
    throw new IllegalStateException(_plus);
  }

  private StringConcatenationClient _lhsFeature(final Attribute f) {
    StringConcatenationClient _xblockexpression = null;
    {
      final RAttribute rAttribute = this.rTypeBuilderFactory.buildRAttribute(f);
      StringConcatenationClient _xifexpression = null;
      boolean _isMulti = rAttribute.isMulti();
      if (_isMulti) {
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("getOrCreate");
            String _firstUpper = StringExtensions.toFirstUpper(rAttribute.getName());
            _builder.append(_firstUpper);
            _builder.append("(0)");
          }
        };
        _xifexpression = _client;
      } else {
        StringConcatenationClient _client_1 = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("getOrCreate");
            String _firstUpper = StringExtensions.toFirstUpper(rAttribute.getName());
            _builder.append(_firstUpper);
            _builder.append("()");
          }
        };
        _xifexpression = _client_1;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }

  private StringConcatenationClient _lhsExpand(final RosettaSymbol c, final JavaScope scope) {
    Class<? extends RosettaSymbol> _class = c.getClass();
    String _plus = ("No implementation for lhsExpand for " + _class);
    throw new IllegalStateException(_plus);
  }

  private StringConcatenationClient _lhsExpand(final Attribute c, final JavaScope scope) {
    StringConcatenationClient _xblockexpression = null;
    {
      final RAttribute rAttribute = this.rTypeBuilderFactory.buildRAttribute(c);
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          GeneratedIdentifier _identifierOrThrow = scope.getIdentifierOrThrow(rAttribute);
          _builder.append(_identifierOrThrow);
        }
      };
      _xblockexpression = _client;
    }
    return _xblockexpression;
  }

  private StringConcatenationClient contributeCondition(final Condition condition, final GeneratedIdentifier conditionValidator, final JavaScope scope) {
    StringConcatenationClient _xblockexpression = null;
    {
      final JavaLambdaBody conditionBody = this.expressionGenerator.javaCode(condition.getExpression(), this._javaTypeUtil.COMPARISON_RESULT, scope.lambdaScope()).toLambdaBody();
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          _builder.append(conditionValidator);
          _builder.append(".validate(() -> ");
          _builder.append(conditionBody);
          _builder.append(",");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("\"");
          String _definition = condition.getDefinition();
          _builder.append(_definition, "\t");
          _builder.append("\");");
          _builder.newLineIfNotEmpty();
        }
      };
      _xblockexpression = _client;
    }
    return _xblockexpression;
  }

  private JavaType outputTypeOrVoid(final Function function) {
    JavaType _xblockexpression = null;
    {
      final Attribute out = this._rosettaFunctionExtensions.getOutput(function);
      JavaType _xifexpression = null;
      if ((out == null)) {
        _xifexpression = JavaPrimitiveType.VOID;
      } else {
        JavaReferenceType _xifexpression_1 = null;
        boolean _needsBuilder = this._rosettaFunctionExtensions.needsBuilder(out.getTypeCall().getType());
        if (_needsBuilder) {
          _xifexpression_1 = this._javaTypeTranslator.toPolymorphicListOrSingleJavaType(this.typeProvider.getRTypeOfSymbol(out), out.getCard().isIsMany());
        } else {
          _xifexpression_1 = this._javaTypeTranslator.toListOrSingleJavaType(this.typeProvider.getRTypeOfSymbol(out), out.getCard().isIsMany());
        }
        _xifexpression = _xifexpression_1;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }

  private StringConcatenationClient inputsAsArguments(@Extension final Function function, final JavaScope scope) {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        {
          List<Attribute> _inputs = FunctionGenerator.this._rosettaFunctionExtensions.getInputs(function);
          boolean _hasElements = false;
          for(final Attribute input : _inputs) {
            if (!_hasElements) {
              _hasElements = true;
            } else {
              _builder.appendImmediate(", ", "");
            }
            GeneratedIdentifier _identifierOrThrow = scope.getIdentifierOrThrow(input);
            _builder.append(_identifierOrThrow);
          }
        }
      }
    };
    return _client;
  }

  private StringConcatenationClient inputsAsArguments(final List<RAttribute> inputs, final JavaScope scope) {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        {
          boolean _hasElements = false;
          for(final RAttribute input : inputs) {
            if (!_hasElements) {
              _hasElements = true;
            } else {
              _builder.appendImmediate(", ", "");
            }
            GeneratedIdentifier _identifierOrThrow = scope.getIdentifierOrThrow(input);
            _builder.append(_identifierOrThrow);
          }
        }
      }
    };
    return _client;
  }

  private StringConcatenationClient inputsAsParameters(@Extension final Function function, final JavaScope scope) {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        {
          List<Attribute> _inputs = FunctionGenerator.this._rosettaFunctionExtensions.getInputs(function);
          boolean _hasElements = false;
          for(final Attribute input : _inputs) {
            if (!_hasElements) {
              _hasElements = true;
            } else {
              _builder.appendImmediate(", ", "");
            }
            {
              boolean _needsBuilder = FunctionGenerator.this._rosettaFunctionExtensions.needsBuilder(input.getTypeCall().getType());
              if (_needsBuilder) {
                JavaReferenceType _polymorphicListOrSingleJavaType = FunctionGenerator.this._javaTypeTranslator.toPolymorphicListOrSingleJavaType(FunctionGenerator.this.typeProvider.getRTypeOfSymbol(input), input.getCard().isIsMany());
                _builder.append(_polymorphicListOrSingleJavaType);
              } else {
                JavaReferenceType _listOrSingleJavaType = FunctionGenerator.this._javaTypeTranslator.toListOrSingleJavaType(FunctionGenerator.this.typeProvider.getRTypeOfSymbol(input), input.getCard().isIsMany());
                _builder.append(_listOrSingleJavaType);
              }
            }
            _builder.append(" ");
            GeneratedIdentifier _identifierOrThrow = scope.getIdentifierOrThrow(input);
            _builder.append(_identifierOrThrow);
          }
        }
      }
    };
    return _client;
  }

  private StringConcatenationClient inputsAsParameters(final List<RAttribute> inputs, final JavaScope scope) {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        {
          boolean _hasElements = false;
          for(final RAttribute input : inputs) {
            if (!_hasElements) {
              _hasElements = true;
            } else {
              _builder.appendImmediate(", ", "");
            }
            JavaReferenceType _attributeToJavaType = FunctionGenerator.this._javaTypeTranslator.attributeToJavaType(input);
            _builder.append(_attributeToJavaType);
            _builder.append(" ");
            GeneratedIdentifier _identifierOrThrow = scope.getIdentifierOrThrow(input);
            _builder.append(_identifierOrThrow);
          }
        }
      }
    };
    return _client;
  }

  private JavaReferenceType shortcutJavaType(final RShortcut feature) {
    JavaReferenceType _xblockexpression = null;
    {
      final JavaReferenceType javaType = this.shortcutExpressionJavaType(feature);
      JavaReferenceType _xifexpression = null;
      boolean _needsBuilder = this._rosettaFunctionExtensions.needsBuilder(feature);
      if (_needsBuilder) {
        _xifexpression = this._javaTypeTranslator.toBuilderType(((JavaClass<?>) javaType));
      } else {
        _xifexpression = javaType;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }

  private JavaReferenceType shortcutExpressionJavaType(final RShortcut feature) {
    JavaReferenceType _xblockexpression = null;
    {
      final RType rType = this.typeProvider.getRType(feature.getExpression());
      _xblockexpression = this._javaTypeTranslator.toJavaReferenceType(rType);
    }
    return _xblockexpression;
  }

  private JavaType toBuilderItemType(final RAttribute rAttribute) {
    JavaClass<?> _xblockexpression = null;
    {
      JavaReferenceType _javaReferenceType = this._javaTypeTranslator.toJavaReferenceType(rAttribute.getRType());
      JavaClass<?> javaType = ((JavaClass<?>) _javaReferenceType);
      boolean _needsBuilder = this._rosettaFunctionExtensions.needsBuilder(rAttribute);
      if (_needsBuilder) {
        javaType = this._javaTypeTranslator.toBuilderType(javaType);
      }
      _xblockexpression = javaType;
    }
    return _xblockexpression;
  }

  private JavaType toBuilderType(final RAttribute rAttribute) {
    final JavaType javaType = this.toBuilderItemType(rAttribute);
    boolean _isMulti = rAttribute.isMulti();
    if (_isMulti) {
      return this._javaTypeUtil.<List<?>>wrap(this._javaTypeUtil.LIST, javaType);
    } else {
      return javaType;
    }
  }

  private StringConcatenationClient lhsExpand(final EObject c, final JavaScope scope) {
    if (c instanceof Attribute) {
      return _lhsExpand((Attribute)c, scope);
    } else if (c instanceof ShortcutDeclaration) {
      return _lhsExpand((ShortcutDeclaration)c, scope);
    } else if (c instanceof RosettaSymbolReference) {
      return _lhsExpand((RosettaSymbolReference)c, scope);
    } else if (c instanceof RosettaUnaryOperation) {
      return _lhsExpand((RosettaUnaryOperation)c, scope);
    } else if (c instanceof RosettaSymbol) {
      return _lhsExpand((RosettaSymbol)c, scope);
    } else if (c instanceof RosettaFeatureCall) {
      return _lhsExpand((RosettaFeatureCall)c, scope);
    } else if (c instanceof RosettaExpression) {
      return _lhsExpand((RosettaExpression)c, scope);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(c, scope).toString());
    }
  }

  private StringConcatenationClient lhsFeature(final RosettaFeature f) {
    if (f instanceof Attribute) {
      return _lhsFeature((Attribute)f);
    } else if (f != null) {
      return _lhsFeature(f);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(f).toString());
    }
  }
}
