package com.regnosys.rosetta.generator.java.object;

import com.google.common.collect.LinkedHashMultimap;
import com.regnosys.rosetta.rosetta.RosettaModel;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class JavaPackageInfoGenerator {
  public LinkedHashMultimap<String, String> namespaceToDescriptionMap(final List<RosettaModel> elements) {
    LinkedHashMultimap<String, String> _xblockexpression = null;
    {
      final LinkedHashMultimap<String, String> namespaceToDescription = LinkedHashMultimap.<String, String>create();
      final Function1<RosettaModel, Boolean> _function = (RosettaModel it) -> {
        String _definition = it.getDefinition();
        return Boolean.valueOf((_definition != null));
      };
      final Consumer<RosettaModel> _function_1 = (RosettaModel model) -> {
        namespaceToDescription.put(model.getName(), model.getDefinition());
      };
      IterableExtensions.<RosettaModel>filter(elements, _function).forEach(_function_1);
      _xblockexpression = namespaceToDescription;
    }
    return _xblockexpression;
  }

  public void generatePackageInfoClasses(final IFileSystemAccess2 fsa, final List<RosettaModel> elements) {
    final Map<String, Collection<String>> modelDescriptionMap = this.namespaceToDescriptionMap(elements).asMap();
    final BiConsumer<String, Collection<String>> _function = (String packageName, Collection<String> descriptions) -> {
      if ((descriptions != null)) {
        StringConcatenation _builder = new StringConcatenation();
        String _replace = packageName.replace(".", "/");
        _builder.append(_replace);
        _builder.append("/package-info.java");
        fsa.generateFile(_builder.toString(), this.generatePackageInfo(packageName, descriptions));
      }
    };
    modelDescriptionMap.forEach(_function);
  }

  private String generatePackageInfo(final String packageName, final Collection<String> descriptions) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/**");
    _builder.newLine();
    _builder.append("*\t");
    {
      for(final String desc : descriptions) {
        _builder.newLineIfNotEmpty();
        _builder.append("*\t");
        _builder.append(desc);
        _builder.newLineIfNotEmpty();
        _builder.append("*\t<p>");
        _builder.newLine();
        _builder.append("*\t");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("*");
    _builder.newLine();
    _builder.append("*/");
    _builder.newLine();
    _builder.newLine();
    _builder.append("package ");
    _builder.append(packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    return _builder.toString();
  }
}
