package com.regnosys.rosetta.generator.java.object;

import com.google.common.collect.Iterables;
import com.regnosys.rosetta.RosettaExtensions;
import com.regnosys.rosetta.generator.java.JavaScope;
import com.regnosys.rosetta.generator.java.RosettaJavaPackages;
import com.regnosys.rosetta.generator.java.types.JavaTypeTranslator;
import com.regnosys.rosetta.generator.java.util.ImportManagerExtension;
import com.regnosys.rosetta.generator.java.util.ModelGeneratorUtil;
import com.regnosys.rosetta.generator.util.RosettaFunctionExtensions;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.regnosys.rosetta.rosetta.RosettaNamed;
import com.regnosys.rosetta.rosetta.RosettaRootElement;
import com.regnosys.rosetta.rosetta.simple.Condition;
import com.regnosys.rosetta.rosetta.simple.Function;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.utils.RosettaConfigExtension;
import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import com.rosetta.util.DottedPath;
import com.rosetta.util.types.JavaClass;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@SuppressWarnings("all")
public class ModelMetaGenerator {
  @Data
  public static class ClassRule {
    private final String className;

    private final String ruleName;

    private final RosettaJavaPackages.RootPackage containingClassNamespace;

    public ClassRule(final String className, final String ruleName, final RosettaJavaPackages.RootPackage containingClassNamespace) {
      super();
      this.className = className;
      this.ruleName = ruleName;
      this.containingClassNamespace = containingClassNamespace;
    }

    @Override
    @Pure
    public int hashCode() {
      final int prime = 31;
      int result = 1;
      result = prime * result + ((this.className== null) ? 0 : this.className.hashCode());
      result = prime * result + ((this.ruleName== null) ? 0 : this.ruleName.hashCode());
      return prime * result + ((this.containingClassNamespace== null) ? 0 : this.containingClassNamespace.hashCode());
    }

    @Override
    @Pure
    public boolean equals(final Object obj) {
      if (this == obj)
        return true;
      if (obj == null)
        return false;
      if (getClass() != obj.getClass())
        return false;
      ModelMetaGenerator.ClassRule other = (ModelMetaGenerator.ClassRule) obj;
      if (this.className == null) {
        if (other.className != null)
          return false;
      } else if (!this.className.equals(other.className))
        return false;
      if (this.ruleName == null) {
        if (other.ruleName != null)
          return false;
      } else if (!this.ruleName.equals(other.ruleName))
        return false;
      if (this.containingClassNamespace == null) {
        if (other.containingClassNamespace != null)
          return false;
      } else if (!this.containingClassNamespace.equals(other.containingClassNamespace))
        return false;
      return true;
    }

    @Override
    @Pure
    public String toString() {
      ToStringBuilder b = new ToStringBuilder(this);
      b.add("className", this.className);
      b.add("ruleName", this.ruleName);
      b.add("containingClassNamespace", this.containingClassNamespace);
      return b.toString();
    }

    @Pure
    public String getClassName() {
      return this.className;
    }

    @Pure
    public String getRuleName() {
      return this.ruleName;
    }

    @Pure
    public RosettaJavaPackages.RootPackage getContainingClassNamespace() {
      return this.containingClassNamespace;
    }
  }

  @Inject
  @Extension
  private ImportManagerExtension _importManagerExtension;

  @Inject
  @Extension
  private RosettaExtensions _rosettaExtensions;

  @Inject
  private RosettaConfigExtension confExt;

  @Inject
  private RosettaFunctionExtensions funcExt;

  @Inject
  @Extension
  private JavaTypeTranslator _javaTypeTranslator;

  public void generate(final RosettaJavaPackages.RootPackage root, final IFileSystemAccess2 fsa, final com.regnosys.rosetta.rosetta.simple.Data data, final String version) {
    StringConcatenation _builder = new StringConcatenation();
    String _name = data.getName();
    _builder.append(_name);
    _builder.append("Meta");
    final String className = _builder.toString();
    DottedPath _meta = root.meta();
    final JavaScope scope = new JavaScope(_meta);
    final StringConcatenationClient classBody = this.metaClassBody(data, root, className, version);
    final String javaFileContents = this._importManagerExtension.buildClass(root.meta(), classBody, scope);
    StringConcatenation _builder_1 = new StringConcatenation();
    String _withForwardSlashes = root.meta().withForwardSlashes();
    _builder_1.append(_withForwardSlashes);
    _builder_1.append("/");
    _builder_1.append(className);
    _builder_1.append(".java");
    fsa.generateFile(_builder_1.toString(), javaFileContents);
  }

  private StringConcatenationClient metaClassBody(final com.regnosys.rosetta.rosetta.simple.Data c, final RosettaJavaPackages.RootPackage root, final String className, final String version) {
    StringConcatenationClient _xblockexpression = null;
    {
      final RDataType t = new RDataType(c);
      final JavaClass<?> dataClass = this._javaTypeTranslator.toJavaType(t);
      final JavaClass<?> validator = this._javaTypeTranslator.toValidatorClass(t);
      final JavaClass<?> typeFormatValidator = this._javaTypeTranslator.toTypeFormatValidatorClass(t);
      final JavaClass<?> onlyExistsValidator = this._javaTypeTranslator.toOnlyExistsValidatorClass(t);
      final ResourceSet context = c.eResource().getResourceSet();
      final Function1<Resource, RosettaModel> _function = (Resource it) -> {
        EObject _head = IterableExtensions.<EObject>head(it.getContents());
        return ((RosettaModel) _head);
      };
      final Set<Function> qualifierFuncs = this.qualifyFuncs(c, IterableExtensions.<RosettaModel>toSet(ListExtensions.<Resource, RosettaModel>map(context.getResources(), _function)));
      final Function1<com.regnosys.rosetta.rosetta.simple.Data, List<ModelMetaGenerator.ClassRule>> _function_1 = (com.regnosys.rosetta.rosetta.simple.Data it) -> {
        return this.conditionRules(it, it.getConditions());
      };
      final Iterable<ModelMetaGenerator.ClassRule> conditions = Iterables.<ModelMetaGenerator.ClassRule>concat(IterableExtensions.<com.regnosys.rosetta.rosetta.simple.Data, List<ModelMetaGenerator.ClassRule>>map(this._rosettaExtensions.getAllSuperTypes(c), _function_1));
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          CharSequence _emptyJavadocWithVersion = ModelGeneratorUtil.emptyJavadocWithVersion(version);
          _builder.append(_emptyJavadocWithVersion);
          _builder.newLineIfNotEmpty();
          _builder.append("@");
          _builder.append(RosettaMeta.class);
          _builder.append("(model=");
          _builder.append(dataClass);
          _builder.append(".class)");
          _builder.newLineIfNotEmpty();
          _builder.append("public class ");
          _builder.append(className);
          _builder.append(" implements ");
          _builder.append(RosettaMetaData.class);
          _builder.append("<");
          _builder.append(dataClass);
          _builder.append("> {");
          _builder.newLineIfNotEmpty();
          _builder.newLine();
          _builder.append("\t");
          _builder.append("@Override");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("public ");
          _builder.append(List.class, "\t");
          _builder.append("<");
          _builder.append(Validator.class, "\t");
          _builder.append("<? super ");
          _builder.append(dataClass, "\t");
          _builder.append(">> dataRules(");
          _builder.append(ValidatorFactory.class, "\t");
          _builder.append(" factory) {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          _builder.append("return ");
          _builder.append(Arrays.class, "\t\t");
          _builder.append(".asList(");
          _builder.newLineIfNotEmpty();
          {
            boolean _hasElements = false;
            for(final ModelMetaGenerator.ClassRule r : conditions) {
              if (!_hasElements) {
                _hasElements = true;
              } else {
                _builder.appendImmediate(",", "\t\t\t");
              }
              _builder.append("\t\t\t");
              String _plus = (r.containingClassNamespace + ".");
              final String containingClassName = (_plus + r.className);
              _builder.newLineIfNotEmpty();
              _builder.append("\t\t\t");
              DottedPath _condition = r.containingClassNamespace.condition();
              String _plus_1 = (_condition + ".");
              String _conditionJavaType = ModelMetaGenerator.this._rosettaExtensions.toConditionJavaType(r.ruleName);
              final String conditionClassName = (_plus_1 + _conditionJavaType);
              _builder.newLineIfNotEmpty();
              _builder.append("\t\t\t");
              _builder.append("factory.<");
              _builder.append(containingClassName, "\t\t\t");
              _builder.append(">create(");
              _builder.append(conditionClassName, "\t\t\t");
              _builder.append(".class)");
              _builder.newLineIfNotEmpty();
            }
          }
          _builder.append("\t\t");
          _builder.append(");");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.append("\t");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("@Override");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("public ");
          _builder.append(List.class, "\t");
          _builder.append("<");
          _builder.append(java.util.function.Function.class, "\t");
          _builder.append("<? super ");
          _builder.append(dataClass, "\t");
          _builder.append(", ");
          _builder.append(QualifyResult.class, "\t");
          _builder.append(">> getQualifyFunctions(");
          _builder.append(QualifyFunctionFactory.class, "\t");
          _builder.append(" factory) {");
          _builder.newLineIfNotEmpty();
          {
            boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(qualifierFuncs);
            boolean _not = (!_isNullOrEmpty);
            if (_not) {
              _builder.append("\t\t");
              _builder.append("return Arrays.asList(");
              _builder.newLine();
              {
                boolean _hasElements_1 = false;
                for(final Function qf : qualifierFuncs) {
                  if (!_hasElements_1) {
                    _hasElements_1 = true;
                  } else {
                    _builder.appendImmediate(",", "\t\t\t");
                  }
                  _builder.append("\t\t");
                  _builder.append("\t");
                  _builder.append("factory.<");
                  _builder.append(dataClass, "\t\t\t");
                  _builder.append(">create(");
                  JavaClass<RosettaFunction> _functionJavaClass = ModelMetaGenerator.this._javaTypeTranslator.toFunctionJavaClass(qf);
                  _builder.append(_functionJavaClass, "\t\t\t");
                  _builder.append(".class)");
                  _builder.newLineIfNotEmpty();
                }
              }
              _builder.append("\t\t");
              _builder.append(");");
              _builder.newLine();
            } else {
              _builder.append("\t\t");
              _builder.append("return ");
              _builder.append(Collections.class, "\t\t");
              _builder.append(".emptyList();");
              _builder.newLineIfNotEmpty();
            }
          }
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.newLine();
          _builder.append("\t");
          _builder.append("@Override");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("public ");
          _builder.append(Validator.class, "\t");
          _builder.append("<? super ");
          _builder.append(dataClass, "\t");
          _builder.append("> validator() {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          _builder.append("return new ");
          _builder.append(validator, "\t\t");
          _builder.append("();");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.newLine();
          _builder.append("\t");
          _builder.append("@Override");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("public ");
          _builder.append(Validator.class, "\t");
          _builder.append("<? super ");
          _builder.append(dataClass, "\t");
          _builder.append("> typeFormatValidator() {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          _builder.append("return new ");
          _builder.append(typeFormatValidator, "\t\t");
          _builder.append("();");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.append("\t");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("@Override");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("public ");
          _builder.append(ValidatorWithArg.class, "\t");
          _builder.append("<? super ");
          _builder.append(dataClass, "\t");
          _builder.append(", ");
          _builder.append(Set.class, "\t");
          _builder.append("<String>> onlyExistsValidator() {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          _builder.append("return new ");
          _builder.append(onlyExistsValidator, "\t\t");
          _builder.append("();");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.append("}");
          _builder.newLine();
        }
      };
      _xblockexpression = _client;
    }
    return _xblockexpression;
  }

  private Set<Function> qualifyFuncs(final com.regnosys.rosetta.rosetta.simple.Data type, final Set<RosettaModel> models) {
    boolean _isRootEventOrProduct = this.confExt.isRootEventOrProduct(type);
    boolean _not = (!_isRootEventOrProduct);
    if (_not) {
      return CollectionLiterals.<Function>emptySet();
    }
    final Function1<RosettaModel, EList<RosettaRootElement>> _function = (RosettaModel it) -> {
      return it.getElements();
    };
    final Set<Function> funcs = IterableExtensions.<Function>toSet(Iterables.<Function>filter(IterableExtensions.<RosettaModel, RosettaRootElement>flatMap(models, _function), Function.class));
    final Function1<Function, Boolean> _function_1 = (Function it) -> {
      return Boolean.valueOf(this.funcExt.isQualifierFunctionFor(it, type));
    };
    return IterableExtensions.<Function>toSet(IterableExtensions.<Function>filter(funcs, _function_1));
  }

  private List<ModelMetaGenerator.ClassRule> conditionRules(final com.regnosys.rosetta.rosetta.simple.Data d, final List<Condition> elements) {
    RosettaModel _model = d.getModel();
    final RosettaJavaPackages.RootPackage dataNamespace = new RosettaJavaPackages.RootPackage(_model);
    final Function1<Condition, ModelMetaGenerator.ClassRule> _function = (Condition it) -> {
      EObject _eContainer = it.eContainer();
      String _name = ((RosettaNamed) _eContainer).getName();
      String _conditionName = this._rosettaExtensions.conditionName(it, d);
      return new ModelMetaGenerator.ClassRule(_name, _conditionName, dataNamespace);
    };
    return IterableExtensions.<ModelMetaGenerator.ClassRule>toList(ListExtensions.<Condition, ModelMetaGenerator.ClassRule>map(elements, _function));
  }
}
