package com.regnosys.rosetta.generator.java.object;

import com.google.common.base.Objects;
import com.regnosys.rosetta.RosettaExtensions;
import com.regnosys.rosetta.generator.GeneratedIdentifier;
import com.regnosys.rosetta.generator.java.JavaScope;
import com.regnosys.rosetta.generator.java.types.JavaTypeTranslator;
import com.regnosys.rosetta.generator.object.ExpandedAttribute;
import com.regnosys.rosetta.generator.util.RosettaAttributeExtensions;
import com.regnosys.rosetta.rosetta.RosettaType;
import com.regnosys.rosetta.rosetta.simple.Annotated;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.TypeSystem;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.meta.Key;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.JavaReferenceType;
import com.rosetta.util.types.JavaType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class ModelObjectBuilderGenerator {
  @Inject
  @Extension
  private ModelObjectBoilerPlate _modelObjectBoilerPlate;

  @Inject
  @Extension
  private RosettaExtensions _rosettaExtensions;

  @Inject
  @Extension
  private JavaTypeTranslator _javaTypeTranslator;

  @Inject
  @Extension
  private TypeSystem _typeSystem;

  public StringConcatenationClient builderClass(final Data c, final JavaScope scope) {
    StringConcatenationClient _xblockexpression = null;
    {
      final JavaClass<?> javaType = this._javaTypeTranslator.toJavaType(new RDataType(c));
      StringConcatenation _builder = new StringConcatenation();
      _builder.append(javaType);
      _builder.append("BuilderImpl");
      final JavaScope builderScope = scope.classScope(_builder.toString());
      final Consumer<ExpandedAttribute> _function = (ExpandedAttribute it) -> {
        builderScope.createIdentifier(it, StringExtensions.toFirstLower(it.getName()));
      };
      RosettaAttributeExtensions.expandedAttributesPlus(c).forEach(_function);
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          _builder.append("class ");
          _builder.append(javaType);
          _builder.append("BuilderImpl");
          {
            boolean _hasSuperType = c.hasSuperType();
            if (_hasSuperType) {
              _builder.append(" extends ");
              Data _superType = c.getSuperType();
              JavaClass<?> _builderImplType = ModelObjectBuilderGenerator.this._javaTypeTranslator.toBuilderImplType(ModelObjectBuilderGenerator.this._javaTypeTranslator.toJavaType(new RDataType(_superType)));
              _builder.append(_builderImplType);
              _builder.append(" ");
            }
          }
          _builder.append(" implements ");
          JavaClass<?> _builderType = ModelObjectBuilderGenerator.this._javaTypeTranslator.toBuilderType(javaType);
          _builder.append(_builderType);
          StringConcatenationClient _implementsClauseBuilder = ModelObjectBuilderGenerator.this._modelObjectBoilerPlate.implementsClauseBuilder(c);
          _builder.append(_implementsClauseBuilder);
          _builder.append(" {");
          _builder.newLineIfNotEmpty();
          _builder.newLine();
          {
            List<ExpandedAttribute> _expandedAttributes = RosettaAttributeExtensions.getExpandedAttributes(c);
            for(final ExpandedAttribute attribute : _expandedAttributes) {
              _builder.append("\t");
              _builder.append("protected ");
              StringConcatenationClient _builderType_1 = ModelObjectBuilderGenerator.this.toBuilderType(attribute);
              _builder.append(_builderType_1, "\t");
              _builder.append(" ");
              GeneratedIdentifier _identifierOrThrow = builderScope.getIdentifierOrThrow(attribute);
              _builder.append(_identifierOrThrow, "\t");
              {
                boolean _isMultiple = attribute.isMultiple();
                if (_isMultiple) {
                  _builder.append(" = new ");
                  _builder.append(ArrayList.class, "\t");
                  _builder.append("<>()");
                }
              }
              _builder.append(";");
              _builder.newLineIfNotEmpty();
            }
          }
          _builder.newLine();
          _builder.append("\t");
          _builder.append("public ");
          _builder.append(javaType, "\t");
          _builder.append("BuilderImpl() {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.newLine();
          _builder.append("\t");
          StringConcatenationClient _builderGetters = ModelObjectBuilderGenerator.this.builderGetters(RosettaAttributeExtensions.getExpandedAttributes(c), builderScope);
          _builder.append(_builderGetters, "\t");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          StringConcatenationClient _setters = ModelObjectBuilderGenerator.this.setters(c, builderScope);
          _builder.append(_setters, "\t");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("@Override");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("public ");
          String _name = c.getName();
          _builder.append(_name, "\t");
          _builder.append(" build() {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          _builder.append("return new ");
          JavaClass<?> _implType = ModelObjectBuilderGenerator.this._javaTypeTranslator.toImplType(javaType);
          _builder.append(_implType, "\t\t");
          _builder.append("(this);");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.append("\t");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("@Override");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("public ");
          JavaClass<?> _builderType_2 = ModelObjectBuilderGenerator.this._javaTypeTranslator.toBuilderType(javaType);
          _builder.append(_builderType_2, "\t");
          _builder.append(" toBuilder() {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          _builder.append("return this;");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.newLine();
          _builder.append("\t");
          _builder.append("@SuppressWarnings(\"unchecked\")");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("@Override");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("public ");
          JavaClass<?> _builderType_3 = ModelObjectBuilderGenerator.this._javaTypeTranslator.toBuilderType(javaType);
          _builder.append(_builderType_3, "\t");
          _builder.append(" prune() {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          {
            boolean _hasSuperType_1 = c.hasSuperType();
            if (_hasSuperType_1) {
              _builder.append("super.prune();");
            }
          }
          _builder.newLineIfNotEmpty();
          {
            List<ExpandedAttribute> _expandedAttributes_1 = RosettaAttributeExtensions.getExpandedAttributes(c);
            for(final ExpandedAttribute attribute_1 : _expandedAttributes_1) {
              {
                if (((!attribute_1.isMultiple()) && (attribute_1.isDataType() || attribute_1.hasMetas()))) {
                  _builder.append("\t\t");
                  _builder.append("if (");
                  GeneratedIdentifier _identifierOrThrow_1 = builderScope.getIdentifierOrThrow(attribute_1);
                  _builder.append(_identifierOrThrow_1, "\t\t");
                  _builder.append("!=null && !");
                  GeneratedIdentifier _identifierOrThrow_2 = builderScope.getIdentifierOrThrow(attribute_1);
                  _builder.append(_identifierOrThrow_2, "\t\t");
                  _builder.append(".prune().hasData()) ");
                  GeneratedIdentifier _identifierOrThrow_3 = builderScope.getIdentifierOrThrow(attribute_1);
                  _builder.append(_identifierOrThrow_3, "\t\t");
                  _builder.append(" = null;");
                  _builder.newLineIfNotEmpty();
                } else {
                  if (((attribute_1.isMultiple() && attribute_1.isDataType()) || attribute_1.hasMetas())) {
                    _builder.append("\t\t");
                    GeneratedIdentifier _identifierOrThrow_4 = builderScope.getIdentifierOrThrow(attribute_1);
                    _builder.append(_identifierOrThrow_4, "\t\t");
                    _builder.append(" = ");
                    GeneratedIdentifier _identifierOrThrow_5 = builderScope.getIdentifierOrThrow(attribute_1);
                    _builder.append(_identifierOrThrow_5, "\t\t");
                    _builder.append(".stream().filter(b->b!=null).<");
                    StringConcatenationClient _builderTypeSingle = ModelObjectBuilderGenerator.this.toBuilderTypeSingle(attribute_1);
                    _builder.append(_builderTypeSingle, "\t\t");
                    _builder.append(">map(b->b.prune()).filter(b->b.hasData()).collect(");
                    _builder.append(Collectors.class, "\t\t");
                    _builder.append(".toList());");
                    _builder.newLineIfNotEmpty();
                  }
                }
              }
            }
          }
          _builder.append("\t\t");
          _builder.append("return this;");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.append("\t");
          _builder.newLine();
          _builder.append("\t");
          final Function1<ExpandedAttribute, Boolean> _function = (ExpandedAttribute it) -> {
            boolean _isOverriding = it.isOverriding();
            return Boolean.valueOf((!_isOverriding));
          };
          CharSequence _hasData = ModelObjectBuilderGenerator.this.hasData(IterableExtensions.<ExpandedAttribute>filter(RosettaAttributeExtensions.getExpandedAttributes(c), _function), c.hasSuperType());
          _builder.append(_hasData, "\t");
          _builder.newLineIfNotEmpty();
          _builder.newLine();
          _builder.append("\t");
          final Function1<ExpandedAttribute, Boolean> _function_1 = (ExpandedAttribute it) -> {
            boolean _isOverriding = it.isOverriding();
            return Boolean.valueOf((!_isOverriding));
          };
          Iterable<ExpandedAttribute> _filter = IterableExtensions.<ExpandedAttribute>filter(RosettaAttributeExtensions.getExpandedAttributes(c), _function_1);
          RDataType _rDataType = new RDataType(c);
          StringConcatenationClient _merge = ModelObjectBuilderGenerator.this.merge(_filter, _rDataType, c.hasSuperType());
          _builder.append(_merge, "\t");
          _builder.newLineIfNotEmpty();
          _builder.newLine();
          _builder.append("\t");
          StringConcatenationClient _builderBoilerPlate = ModelObjectBuilderGenerator.this._modelObjectBoilerPlate.builderBoilerPlate(c, builderScope);
          _builder.append(_builderBoilerPlate, "\t");
          _builder.newLineIfNotEmpty();
          _builder.append("}");
          _builder.newLine();
        }
      };
      _xblockexpression = _client;
    }
    return _xblockexpression;
  }

  private StringConcatenationClient merge(final Iterable<ExpandedAttribute> attributes, final RDataType type, final boolean hasSuperType) {
    StringConcatenationClient _xblockexpression = null;
    {
      final JavaClass<?> builderName = this._javaTypeTranslator.toBuilderType(this._javaTypeTranslator.toJavaType(type));
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          _builder.append("@SuppressWarnings(\"unchecked\")");
          _builder.newLine();
          _builder.append("@Override");
          _builder.newLine();
          _builder.append("public ");
          _builder.append(builderName);
          _builder.append(" merge(");
          _builder.append(RosettaModelObjectBuilder.class);
          _builder.append(" other, ");
          _builder.append(BuilderMerger.class);
          _builder.append(" merger) {");
          _builder.newLineIfNotEmpty();
          {
            if (hasSuperType) {
              _builder.append("\t");
              _builder.append("super.merge(other, merger);");
              _builder.newLine();
              _builder.append("\t");
              _builder.newLine();
            }
          }
          _builder.append("\t");
          _builder.append(builderName, "\t");
          _builder.append(" o = (");
          _builder.append(builderName, "\t");
          _builder.append(") other;");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.newLine();
          {
            final Function1<ExpandedAttribute, Boolean> _function = (ExpandedAttribute it) -> {
              return Boolean.valueOf((it.isDataType() || it.hasMetas()));
            };
            Iterable<ExpandedAttribute> _filter = IterableExtensions.<ExpandedAttribute>filter(attributes, _function);
            for(final ExpandedAttribute a : _filter) {
              _builder.append("\t");
              final String attributeName = StringExtensions.toFirstUpper(a.getName());
              _builder.newLineIfNotEmpty();
              {
                boolean _isMultiple = a.isMultiple();
                if (_isMultiple) {
                  _builder.append("\t");
                  _builder.append("merger.mergeRosetta(get");
                  _builder.append(attributeName, "\t");
                  _builder.append("(), o.get");
                  _builder.append(attributeName, "\t");
                  _builder.append("(), this::getOrCreate");
                  _builder.append(attributeName, "\t");
                  _builder.append(");");
                  _builder.newLineIfNotEmpty();
                } else {
                  _builder.append("\t");
                  _builder.append("merger.mergeRosetta(get");
                  _builder.append(attributeName, "\t");
                  _builder.append("(), o.get");
                  _builder.append(attributeName, "\t");
                  _builder.append("(), this::set");
                  _builder.append(attributeName, "\t");
                  _builder.append(");");
                  _builder.newLineIfNotEmpty();
                }
              }
            }
          }
          _builder.append("\t");
          _builder.newLine();
          {
            final Function1<ExpandedAttribute, Boolean> _function_1 = (ExpandedAttribute it) -> {
              return Boolean.valueOf(((!it.isDataType()) && (!it.hasMetas())));
            };
            Iterable<ExpandedAttribute> _filter_1 = IterableExtensions.<ExpandedAttribute>filter(attributes, _function_1);
            for(final ExpandedAttribute a_1 : _filter_1) {
              _builder.append("\t");
              final String attributeName_1 = StringExtensions.toFirstUpper(a_1.getName());
              _builder.newLineIfNotEmpty();
              {
                boolean _isMultiple_1 = a_1.isMultiple();
                if (_isMultiple_1) {
                  _builder.append("\t");
                  _builder.append("merger.mergeBasic(get");
                  _builder.append(attributeName_1, "\t");
                  _builder.append("(), o.get");
                  _builder.append(attributeName_1, "\t");
                  _builder.append("(), (");
                  _builder.append(Consumer.class, "\t");
                  _builder.append("<");
                  JavaReferenceType _javaReferenceType = ModelObjectBuilderGenerator.this._javaTypeTranslator.toJavaReferenceType(ModelObjectBuilderGenerator.this._typeSystem.typeCallToRType(a_1.getRosettaType()));
                  _builder.append(_javaReferenceType, "\t");
                  _builder.append(">) this::add");
                  _builder.append(attributeName_1, "\t");
                  _builder.append(");");
                  _builder.newLineIfNotEmpty();
                } else {
                  _builder.append("\t");
                  _builder.append("merger.mergeBasic(get");
                  _builder.append(attributeName_1, "\t");
                  _builder.append("(), o.get");
                  _builder.append(attributeName_1, "\t");
                  _builder.append("(), this::set");
                  _builder.append(attributeName_1, "\t");
                  _builder.append(");");
                  _builder.newLineIfNotEmpty();
                }
              }
            }
          }
          _builder.append("\t");
          _builder.append("return this;");
          _builder.newLine();
          _builder.append("}");
          _builder.newLine();
        }
      };
      _xblockexpression = _client;
    }
    return _xblockexpression;
  }

  private StringConcatenationClient builderGetters(final Iterable<ExpandedAttribute> attributes, final JavaScope scope) {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        {
          for(final ExpandedAttribute attribute : attributes) {
            _builder.append("@Override");
            _builder.newLine();
            _builder.append("@");
            _builder.append(RosettaAttribute.class);
            _builder.append("(\"");
            String _javaAnnotation = attribute.javaAnnotation();
            _builder.append(_javaAnnotation);
            _builder.append("\")");
            _builder.newLineIfNotEmpty();
            _builder.append("public ");
            StringConcatenationClient _builderTypeExt = ModelObjectBuilderGenerator.this.toBuilderTypeExt(attribute);
            _builder.append(_builderTypeExt);
            _builder.append(" get");
            String _firstUpper = StringExtensions.toFirstUpper(attribute.getName());
            _builder.append(_firstUpper);
            _builder.append("() {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("return ");
            GeneratedIdentifier _identifierOrThrow = scope.getIdentifierOrThrow(attribute);
            _builder.append(_identifierOrThrow, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            {
              if ((attribute.isDataType() || attribute.hasMetas())) {
                {
                  boolean _cardinalityIsListValue = RosettaAttributeExtensions.cardinalityIsListValue(attribute);
                  boolean _not = (!_cardinalityIsListValue);
                  if (_not) {
                    _builder.append("@Override");
                    _builder.newLine();
                    _builder.append("public ");
                    StringConcatenationClient _builderTypeSingle = ModelObjectBuilderGenerator.this.toBuilderTypeSingle(attribute);
                    _builder.append(_builderTypeSingle);
                    _builder.append(" getOrCreate");
                    String _firstUpper_1 = StringExtensions.toFirstUpper(attribute.getName());
                    _builder.append(_firstUpper_1);
                    _builder.append("() {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    StringConcatenationClient _builderTypeSingle_1 = ModelObjectBuilderGenerator.this.toBuilderTypeSingle(attribute);
                    _builder.append(_builderTypeSingle_1, "\t");
                    _builder.append(" result;");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("if (");
                    GeneratedIdentifier _identifierOrThrow_1 = scope.getIdentifierOrThrow(attribute);
                    _builder.append(_identifierOrThrow_1, "\t");
                    _builder.append("!=null) {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("result = ");
                    GeneratedIdentifier _identifierOrThrow_2 = scope.getIdentifierOrThrow(attribute);
                    _builder.append(_identifierOrThrow_2, "\t\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("else {");
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append("result = ");
                    GeneratedIdentifier _identifierOrThrow_3 = scope.getIdentifierOrThrow(attribute);
                    _builder.append(_identifierOrThrow_3, "\t\t");
                    _builder.append(" = ");
                    JavaReferenceType _metaOrRegularJavaType = ModelObjectBuilderGenerator.this._javaTypeTranslator.toMetaOrRegularJavaType(attribute);
                    _builder.append(_metaOrRegularJavaType, "\t\t");
                    _builder.append(".builder();");
                    _builder.newLineIfNotEmpty();
                    {
                      final Function1<ExpandedAttribute, Boolean> _function = (ExpandedAttribute m) -> {
                        String _name = m.getName();
                        return Boolean.valueOf(Objects.equal(_name, "location"));
                      };
                      boolean _isEmpty = IterableExtensions.isEmpty(IterableExtensions.<ExpandedAttribute>filter(attribute.getMetas(), _function));
                      boolean _not_1 = (!_isEmpty);
                      if (_not_1) {
                        _builder.append("\t\t");
                        _builder.append("result.getOrCreateMeta().toBuilder().addKey(");
                        _builder.append(Key.class, "\t\t");
                        _builder.append(".builder().setScope(\"DOCUMENT\"));");
                        _builder.newLineIfNotEmpty();
                      }
                    }
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("return result;");
                    _builder.newLine();
                    _builder.append("}");
                    _builder.newLine();
                    _builder.newLine();
                  } else {
                    _builder.append("public ");
                    StringConcatenationClient _builderTypeSingle_2 = ModelObjectBuilderGenerator.this.toBuilderTypeSingle(attribute);
                    _builder.append(_builderTypeSingle_2);
                    _builder.append(" getOrCreate");
                    String _firstUpper_2 = StringExtensions.toFirstUpper(attribute.getName());
                    _builder.append(_firstUpper_2);
                    _builder.append("(int _index) {");
                    _builder.newLineIfNotEmpty();
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("if (");
                    GeneratedIdentifier _identifierOrThrow_4 = scope.getIdentifierOrThrow(attribute);
                    _builder.append(_identifierOrThrow_4, "\t");
                    _builder.append("==null) {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("this.");
                    GeneratedIdentifier _identifierOrThrow_5 = scope.getIdentifierOrThrow(attribute);
                    _builder.append(_identifierOrThrow_5, "\t\t");
                    _builder.append(" = new ");
                    _builder.append(ArrayList.class, "\t\t");
                    _builder.append("<>();");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                    _builder.append("\t");
                    StringConcatenationClient _builderTypeSingle_3 = ModelObjectBuilderGenerator.this.toBuilderTypeSingle(attribute);
                    _builder.append(_builderTypeSingle_3, "\t");
                    _builder.append(" result;");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("return getIndex(");
                    GeneratedIdentifier _identifierOrThrow_6 = scope.getIdentifierOrThrow(attribute);
                    _builder.append(_identifierOrThrow_6, "\t");
                    _builder.append(", _index, () -> {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t\t\t");
                    StringConcatenationClient _builderTypeSingle_4 = ModelObjectBuilderGenerator.this.toBuilderTypeSingle(attribute);
                    _builder.append(_builderTypeSingle_4, "\t\t\t\t");
                    _builder.append(" new");
                    String _firstUpper_3 = StringExtensions.toFirstUpper(attribute.getName());
                    _builder.append(_firstUpper_3, "\t\t\t\t");
                    _builder.append(" = ");
                    JavaReferenceType _metaOrRegularJavaType_1 = ModelObjectBuilderGenerator.this._javaTypeTranslator.toMetaOrRegularJavaType(attribute);
                    _builder.append(_metaOrRegularJavaType_1, "\t\t\t\t");
                    _builder.append(".builder();");
                    _builder.newLineIfNotEmpty();
                    {
                      final Function1<ExpandedAttribute, Boolean> _function_1 = (ExpandedAttribute m) -> {
                        String _name = m.getName();
                        return Boolean.valueOf(Objects.equal(_name, "location"));
                      };
                      boolean _isEmpty_1 = IterableExtensions.isEmpty(IterableExtensions.<ExpandedAttribute>filter(attribute.getMetas(), _function_1));
                      boolean _not_2 = (!_isEmpty_1);
                      if (_not_2) {
                        _builder.append("\t\t\t\t");
                        _builder.append("new");
                        String _firstUpper_4 = StringExtensions.toFirstUpper(attribute.getName());
                        _builder.append(_firstUpper_4, "\t\t\t\t");
                        _builder.append(".getOrCreateMeta().addKey(");
                        _builder.append(Key.class, "\t\t\t\t");
                        _builder.append(".builder().setScope(\"DOCUMENT\"));");
                        _builder.newLineIfNotEmpty();
                      }
                    }
                    _builder.append("\t\t\t\t");
                    _builder.append("return new");
                    String _firstUpper_5 = StringExtensions.toFirstUpper(attribute.getName());
                    _builder.append(_firstUpper_5, "\t\t\t\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t\t");
                    _builder.append("});");
                    _builder.newLine();
                    _builder.append("}");
                    _builder.newLine();
                    _builder.newLine();
                  }
                }
              }
            }
          }
        }
      }
    };
    return _client;
  }

  private StringConcatenationClient setters(final Data thisClass, final JavaScope scope) {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        {
          List<ExpandedAttribute> _expandedAttributesPlus = RosettaAttributeExtensions.expandedAttributesPlus(thisClass);
          for(final ExpandedAttribute attribute : _expandedAttributesPlus) {
            StringConcatenationClient _doSetter = ModelObjectBuilderGenerator.this.doSetter(thisClass, attribute, scope);
            _builder.append(_doSetter);
            _builder.newLineIfNotEmpty();
          }
        }
      }
    };
    return _client;
  }

  private StringConcatenationClient doSetter(final Data thisClass, final ExpandedAttribute attribute, final JavaScope scope) {
    StringConcatenationClient _xblockexpression = null;
    {
      final JavaClass<?> thisName = this._javaTypeTranslator.toBuilderType(this._javaTypeTranslator.toJavaType(new RDataType(thisClass)));
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          {
            boolean _cardinalityIsListValue = RosettaAttributeExtensions.cardinalityIsListValue(attribute);
            if (_cardinalityIsListValue) {
              _builder.append("@Override");
              _builder.newLine();
              _builder.append("public ");
              _builder.append(thisName);
              _builder.append(" add");
              String _firstUpper = StringExtensions.toFirstUpper(attribute.getName());
              _builder.append(_firstUpper);
              _builder.append("(");
              JavaReferenceType _metaOrRegularJavaType = ModelObjectBuilderGenerator.this._javaTypeTranslator.toMetaOrRegularJavaType(attribute);
              _builder.append(_metaOrRegularJavaType);
              _builder.append(" ");
              GeneratedIdentifier _identifierOrThrow = scope.getIdentifierOrThrow(attribute);
              _builder.append(_identifierOrThrow);
              _builder.append(") {");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("if (");
              GeneratedIdentifier _identifierOrThrow_1 = scope.getIdentifierOrThrow(attribute);
              _builder.append(_identifierOrThrow_1, "\t");
              _builder.append("!=null) this.");
              GeneratedIdentifier _identifierOrThrow_2 = scope.getIdentifierOrThrow(attribute);
              _builder.append(_identifierOrThrow_2, "\t");
              _builder.append(".add(");
              StringConcatenationClient _builder_1 = ModelObjectBuilderGenerator.this.toBuilder(attribute, scope);
              _builder.append(_builder_1, "\t");
              _builder.append(");");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("return this;");
              _builder.newLine();
              _builder.append("}");
              _builder.newLine();
              _builder.newLine();
              _builder.append("@Override");
              _builder.newLine();
              _builder.append("public ");
              _builder.append(thisName);
              _builder.append(" add");
              String _firstUpper_1 = StringExtensions.toFirstUpper(attribute.getName());
              _builder.append(_firstUpper_1);
              _builder.append("(");
              JavaReferenceType _metaOrRegularJavaType_1 = ModelObjectBuilderGenerator.this._javaTypeTranslator.toMetaOrRegularJavaType(attribute);
              _builder.append(_metaOrRegularJavaType_1);
              _builder.append(" ");
              GeneratedIdentifier _identifierOrThrow_3 = scope.getIdentifierOrThrow(attribute);
              _builder.append(_identifierOrThrow_3);
              _builder.append(", int _idx) {");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("getIndex(this.");
              GeneratedIdentifier _identifierOrThrow_4 = scope.getIdentifierOrThrow(attribute);
              _builder.append(_identifierOrThrow_4, "\t");
              _builder.append(", _idx, () -> ");
              StringConcatenationClient _builder_2 = ModelObjectBuilderGenerator.this.toBuilder(attribute, scope);
              _builder.append(_builder_2, "\t");
              _builder.append(");");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("return this;");
              _builder.newLine();
              _builder.append("}");
              _builder.newLine();
              {
                boolean _hasMetas = attribute.hasMetas();
                if (_hasMetas) {
                  _builder.newLine();
                  _builder.append("@Override");
                  _builder.newLine();
                  _builder.append("public ");
                  _builder.append(thisName);
                  _builder.append(" add");
                  String _firstUpper_2 = StringExtensions.toFirstUpper(attribute.getName());
                  _builder.append(_firstUpper_2);
                  _builder.append("Value(");
                  JavaReferenceType _javaReferenceType = ModelObjectBuilderGenerator.this._javaTypeTranslator.toJavaReferenceType(ModelObjectBuilderGenerator.this._typeSystem.typeCallToRType(attribute.getRosettaType()));
                  _builder.append(_javaReferenceType);
                  _builder.append(" ");
                  GeneratedIdentifier _identifierOrThrow_5 = scope.getIdentifierOrThrow(attribute);
                  _builder.append(_identifierOrThrow_5);
                  _builder.append(") {");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  _builder.append("this.getOrCreate");
                  String _firstUpper_3 = StringExtensions.toFirstUpper(attribute.getName());
                  _builder.append(_firstUpper_3, "\t");
                  _builder.append("(-1).setValue(");
                  GeneratedIdentifier _identifierOrThrow_6 = scope.getIdentifierOrThrow(attribute);
                  _builder.append(_identifierOrThrow_6, "\t");
                  {
                    boolean _isDataType = attribute.isDataType();
                    if (_isDataType) {
                      _builder.append(".toBuilder()");
                    }
                  }
                  _builder.append(");");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  _builder.append("return this;");
                  _builder.newLine();
                  _builder.append("}");
                  _builder.newLine();
                  _builder.newLine();
                  _builder.append("@Override");
                  _builder.newLine();
                  _builder.append("public ");
                  _builder.append(thisName);
                  _builder.append(" add");
                  String _firstUpper_4 = StringExtensions.toFirstUpper(attribute.getName());
                  _builder.append(_firstUpper_4);
                  _builder.append("Value(");
                  JavaReferenceType _javaReferenceType_1 = ModelObjectBuilderGenerator.this._javaTypeTranslator.toJavaReferenceType(ModelObjectBuilderGenerator.this._typeSystem.typeCallToRType(attribute.getRosettaType()));
                  _builder.append(_javaReferenceType_1);
                  _builder.append(" ");
                  GeneratedIdentifier _identifierOrThrow_7 = scope.getIdentifierOrThrow(attribute);
                  _builder.append(_identifierOrThrow_7);
                  _builder.append(", int _idx) {");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  _builder.append("this.getOrCreate");
                  String _firstUpper_5 = StringExtensions.toFirstUpper(attribute.getName());
                  _builder.append(_firstUpper_5, "\t");
                  _builder.append("(_idx).setValue(");
                  GeneratedIdentifier _identifierOrThrow_8 = scope.getIdentifierOrThrow(attribute);
                  _builder.append(_identifierOrThrow_8, "\t");
                  {
                    boolean _isDataType_1 = attribute.isDataType();
                    if (_isDataType_1) {
                      _builder.append(".toBuilder()");
                    }
                  }
                  _builder.append(");");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  _builder.append("return this;");
                  _builder.newLine();
                  _builder.append("}");
                  _builder.newLine();
                }
              }
              {
                boolean _isOverriding = attribute.isOverriding();
                boolean _not = (!_isOverriding);
                if (_not) {
                  _builder.append("@Override ");
                  _builder.newLine();
                  _builder.append("public ");
                  _builder.append(thisName);
                  _builder.append(" add");
                  String _firstUpper_6 = StringExtensions.toFirstUpper(attribute.getName());
                  _builder.append(_firstUpper_6);
                  _builder.append("(");
                  _builder.append(List.class);
                  _builder.append("<? extends ");
                  JavaReferenceType _metaOrRegularJavaType_2 = ModelObjectBuilderGenerator.this._javaTypeTranslator.toMetaOrRegularJavaType(attribute);
                  _builder.append(_metaOrRegularJavaType_2);
                  _builder.append("> ");
                  GeneratedIdentifier _identifierOrThrow_9 = scope.getIdentifierOrThrow(attribute);
                  _builder.append(_identifierOrThrow_9);
                  _builder.append("s) {");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  _builder.append("if (");
                  GeneratedIdentifier _identifierOrThrow_10 = scope.getIdentifierOrThrow(attribute);
                  _builder.append(_identifierOrThrow_10, "\t");
                  _builder.append("s != null) {");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t\t");
                  _builder.append("for (");
                  JavaReferenceType _metaOrRegularJavaType_3 = ModelObjectBuilderGenerator.this._javaTypeTranslator.toMetaOrRegularJavaType(attribute);
                  _builder.append(_metaOrRegularJavaType_3, "\t\t");
                  _builder.append(" toAdd : ");
                  GeneratedIdentifier _identifierOrThrow_11 = scope.getIdentifierOrThrow(attribute);
                  _builder.append(_identifierOrThrow_11, "\t\t");
                  _builder.append("s) {");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t\t\t");
                  _builder.append("this.");
                  GeneratedIdentifier _identifierOrThrow_12 = scope.getIdentifierOrThrow(attribute);
                  _builder.append(_identifierOrThrow_12, "\t\t\t");
                  _builder.append(".add(toAdd");
                  {
                    boolean _needsBuilder = ModelObjectBuilderGenerator.this._modelObjectBoilerPlate.needsBuilder(attribute);
                    if (_needsBuilder) {
                      _builder.append(".toBuilder()");
                    }
                  }
                  _builder.append(");");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t\t");
                  _builder.append("}");
                  _builder.newLine();
                  _builder.append("\t");
                  _builder.append("}");
                  _builder.newLine();
                  _builder.append("\t");
                  _builder.append("return this;");
                  _builder.newLine();
                  _builder.append("}");
                  _builder.newLine();
                  _builder.newLine();
                  _builder.append("@Override ");
                  _builder.newLine();
                  _builder.append("@");
                  _builder.append(RosettaAttribute.class);
                  _builder.append("(\"");
                  String _javaAnnotation = attribute.javaAnnotation();
                  _builder.append(_javaAnnotation);
                  _builder.append("\")");
                  _builder.newLineIfNotEmpty();
                  _builder.append("public ");
                  _builder.append(thisName);
                  _builder.append(" set");
                  String _firstUpper_7 = StringExtensions.toFirstUpper(attribute.getName());
                  _builder.append(_firstUpper_7);
                  _builder.append("(");
                  _builder.append(List.class);
                  _builder.append("<? extends ");
                  JavaReferenceType _metaOrRegularJavaType_4 = ModelObjectBuilderGenerator.this._javaTypeTranslator.toMetaOrRegularJavaType(attribute);
                  _builder.append(_metaOrRegularJavaType_4);
                  _builder.append("> ");
                  GeneratedIdentifier _identifierOrThrow_13 = scope.getIdentifierOrThrow(attribute);
                  _builder.append(_identifierOrThrow_13);
                  _builder.append("s) {");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  _builder.append("if (");
                  GeneratedIdentifier _identifierOrThrow_14 = scope.getIdentifierOrThrow(attribute);
                  _builder.append(_identifierOrThrow_14, "\t");
                  _builder.append("s == null)  {");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t\t");
                  _builder.append("this.");
                  GeneratedIdentifier _identifierOrThrow_15 = scope.getIdentifierOrThrow(attribute);
                  _builder.append(_identifierOrThrow_15, "\t\t");
                  _builder.append(" = new ");
                  _builder.append(ArrayList.class, "\t\t");
                  _builder.append("<>();");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  _builder.append("}");
                  _builder.newLine();
                  _builder.append("\t");
                  _builder.append("else {");
                  _builder.newLine();
                  _builder.append("\t\t");
                  _builder.append("this.");
                  GeneratedIdentifier _identifierOrThrow_16 = scope.getIdentifierOrThrow(attribute);
                  _builder.append(_identifierOrThrow_16, "\t\t");
                  _builder.append(" = ");
                  GeneratedIdentifier _identifierOrThrow_17 = scope.getIdentifierOrThrow(attribute);
                  _builder.append(_identifierOrThrow_17, "\t\t");
                  _builder.append("s.stream()");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t\t\t");
                  {
                    boolean _needsBuilder_1 = ModelObjectBuilderGenerator.this._modelObjectBoilerPlate.needsBuilder(attribute);
                    if (_needsBuilder_1) {
                      _builder.append(".map(_a->_a.toBuilder())");
                    }
                  }
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t\t\t");
                  _builder.append(".collect(");
                  _builder.append(Collectors.class, "\t\t\t");
                  _builder.append(".toCollection(()->new ArrayList<>()));");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  _builder.append("}");
                  _builder.newLine();
                  _builder.append("\t");
                  _builder.append("return this;");
                  _builder.newLine();
                  _builder.append("}");
                  _builder.newLine();
                  {
                    boolean _hasMetas_1 = attribute.hasMetas();
                    if (_hasMetas_1) {
                      _builder.newLine();
                      _builder.append("@Override");
                      _builder.newLine();
                      _builder.append("public ");
                      _builder.append(thisName);
                      _builder.append(" add");
                      String _firstUpper_8 = StringExtensions.toFirstUpper(attribute.getName());
                      _builder.append(_firstUpper_8);
                      _builder.append("Value(");
                      _builder.append(List.class);
                      _builder.append("<? extends ");
                      JavaReferenceType _javaReferenceType_2 = ModelObjectBuilderGenerator.this._javaTypeTranslator.toJavaReferenceType(ModelObjectBuilderGenerator.this._typeSystem.typeCallToRType(attribute.getRosettaType()));
                      _builder.append(_javaReferenceType_2);
                      _builder.append("> ");
                      GeneratedIdentifier _identifierOrThrow_18 = scope.getIdentifierOrThrow(attribute);
                      _builder.append(_identifierOrThrow_18);
                      _builder.append("s) {");
                      _builder.newLineIfNotEmpty();
                      _builder.append("\t");
                      _builder.append("if (");
                      GeneratedIdentifier _identifierOrThrow_19 = scope.getIdentifierOrThrow(attribute);
                      _builder.append(_identifierOrThrow_19, "\t");
                      _builder.append("s != null) {");
                      _builder.newLineIfNotEmpty();
                      _builder.append("\t\t");
                      _builder.append("for (");
                      JavaReferenceType _javaReferenceType_3 = ModelObjectBuilderGenerator.this._javaTypeTranslator.toJavaReferenceType(ModelObjectBuilderGenerator.this._typeSystem.typeCallToRType(attribute.getRosettaType()));
                      _builder.append(_javaReferenceType_3, "\t\t");
                      _builder.append(" toAdd : ");
                      GeneratedIdentifier _identifierOrThrow_20 = scope.getIdentifierOrThrow(attribute);
                      _builder.append(_identifierOrThrow_20, "\t\t");
                      _builder.append("s) {");
                      _builder.newLineIfNotEmpty();
                      _builder.append("\t\t\t");
                      _builder.append("this.add");
                      String _firstUpper_9 = StringExtensions.toFirstUpper(attribute.getName());
                      _builder.append(_firstUpper_9, "\t\t\t");
                      _builder.append("Value(toAdd);");
                      _builder.newLineIfNotEmpty();
                      _builder.append("\t\t");
                      _builder.append("}");
                      _builder.newLine();
                      _builder.append("\t");
                      _builder.append("}");
                      _builder.newLine();
                      _builder.append("\t");
                      _builder.append("return this;");
                      _builder.newLine();
                      _builder.append("}");
                      _builder.newLine();
                      _builder.newLine();
                      _builder.append("@Override");
                      _builder.newLine();
                      _builder.append("public ");
                      _builder.append(thisName);
                      _builder.append(" set");
                      String _firstUpper_10 = StringExtensions.toFirstUpper(attribute.getName());
                      _builder.append(_firstUpper_10);
                      _builder.append("Value(");
                      _builder.append(List.class);
                      _builder.append("<? extends ");
                      JavaReferenceType _javaReferenceType_4 = ModelObjectBuilderGenerator.this._javaTypeTranslator.toJavaReferenceType(ModelObjectBuilderGenerator.this._typeSystem.typeCallToRType(attribute.getRosettaType()));
                      _builder.append(_javaReferenceType_4);
                      _builder.append("> ");
                      GeneratedIdentifier _identifierOrThrow_21 = scope.getIdentifierOrThrow(attribute);
                      _builder.append(_identifierOrThrow_21);
                      _builder.append("s) {");
                      _builder.newLineIfNotEmpty();
                      _builder.append("\t");
                      _builder.append("this.");
                      GeneratedIdentifier _identifierOrThrow_22 = scope.getIdentifierOrThrow(attribute);
                      _builder.append(_identifierOrThrow_22, "\t");
                      _builder.append(".clear();");
                      _builder.newLineIfNotEmpty();
                      _builder.append("\t");
                      _builder.append("if (");
                      GeneratedIdentifier _identifierOrThrow_23 = scope.getIdentifierOrThrow(attribute);
                      _builder.append(_identifierOrThrow_23, "\t");
                      _builder.append("s!=null) {");
                      _builder.newLineIfNotEmpty();
                      _builder.append("\t\t");
                      GeneratedIdentifier _identifierOrThrow_24 = scope.getIdentifierOrThrow(attribute);
                      _builder.append(_identifierOrThrow_24, "\t\t");
                      _builder.append("s.forEach(this::add");
                      String _firstUpper_11 = StringExtensions.toFirstUpper(attribute.getName());
                      _builder.append(_firstUpper_11, "\t\t");
                      _builder.append("Value);");
                      _builder.newLineIfNotEmpty();
                      _builder.append("\t");
                      _builder.append("}");
                      _builder.newLine();
                      _builder.append("\t");
                      _builder.append("return this;");
                      _builder.newLine();
                      _builder.append("}");
                      _builder.newLine();
                    }
                  }
                }
              }
              _builder.newLine();
            } else {
              _builder.append("@Override");
              _builder.newLine();
              _builder.append("@");
              _builder.append(RosettaAttribute.class);
              _builder.append("(\"");
              String _javaAnnotation_1 = attribute.javaAnnotation();
              _builder.append(_javaAnnotation_1);
              _builder.append("\")");
              _builder.newLineIfNotEmpty();
              _builder.append("public ");
              _builder.append(thisName);
              _builder.append(" set");
              String _firstUpper_12 = StringExtensions.toFirstUpper(attribute.getName());
              _builder.append(_firstUpper_12);
              _builder.append("(");
              JavaType _listOrSingleMetaType = ModelObjectBuilderGenerator.this._modelObjectBoilerPlate.toListOrSingleMetaType(attribute);
              _builder.append(_listOrSingleMetaType);
              _builder.append(" ");
              GeneratedIdentifier _identifierOrThrow_25 = scope.getIdentifierOrThrow(attribute);
              _builder.append(_identifierOrThrow_25);
              _builder.append(") {");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("this.");
              GeneratedIdentifier _identifierOrThrow_26 = scope.getIdentifierOrThrow(attribute);
              _builder.append(_identifierOrThrow_26, "\t");
              _builder.append(" = ");
              GeneratedIdentifier _identifierOrThrow_27 = scope.getIdentifierOrThrow(attribute);
              _builder.append(_identifierOrThrow_27, "\t");
              _builder.append("==null?null:");
              StringConcatenationClient _builder_3 = ModelObjectBuilderGenerator.this.toBuilder(attribute, scope);
              _builder.append(_builder_3, "\t");
              _builder.append(";");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("return this;");
              _builder.newLine();
              _builder.append("}");
              _builder.newLine();
              {
                boolean _hasMetas_2 = attribute.hasMetas();
                if (_hasMetas_2) {
                  _builder.append("@Override");
                  _builder.newLine();
                  _builder.append("public ");
                  _builder.append(thisName);
                  _builder.append(" set");
                  String _firstUpper_13 = StringExtensions.toFirstUpper(attribute.getName());
                  _builder.append(_firstUpper_13);
                  _builder.append("Value(");
                  JavaReferenceType _polymorphicListOrSingleJavaType = ModelObjectBuilderGenerator.this._javaTypeTranslator.toPolymorphicListOrSingleJavaType(ModelObjectBuilderGenerator.this._typeSystem.typeCallToRType(attribute.getRosettaType()), RosettaAttributeExtensions.cardinalityIsListValue(attribute));
                  _builder.append(_polymorphicListOrSingleJavaType);
                  _builder.append(" ");
                  GeneratedIdentifier _identifierOrThrow_28 = scope.getIdentifierOrThrow(attribute);
                  _builder.append(_identifierOrThrow_28);
                  _builder.append(") {");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  _builder.append("this.getOrCreate");
                  String _firstUpper_14 = StringExtensions.toFirstUpper(attribute.getName());
                  _builder.append(_firstUpper_14, "\t");
                  _builder.append("().setValue(");
                  GeneratedIdentifier _identifierOrThrow_29 = scope.getIdentifierOrThrow(attribute);
                  _builder.append(_identifierOrThrow_29, "\t");
                  {
                    boolean _isDataType_2 = attribute.isDataType();
                    if (_isDataType_2) {
                    }
                  }
                  _builder.append(");");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  _builder.append("return this;");
                  _builder.newLine();
                  _builder.append("}");
                  _builder.newLine();
                }
              }
            }
          }
        }
      };
      _xblockexpression = _client;
    }
    return _xblockexpression;
  }

  public boolean globalKey(final RosettaType type) {
    boolean _switchResult = false;
    boolean _matched = false;
    if (type instanceof Data) {
      _matched=true;
      _switchResult = this._rosettaExtensions.hasKeyedAnnotation(((Annotated)type));
    }
    if (!_matched) {
      _switchResult = false;
    }
    return _switchResult;
  }

  private CharSequence hasData(final Iterable<ExpandedAttribute> attributes, final boolean hasSuperType) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("public boolean hasData() {");
    _builder.newLine();
    _builder.append("\t");
    {
      if (hasSuperType) {
        _builder.append("if (super.hasData()) return true;");
      }
    }
    _builder.newLineIfNotEmpty();
    {
      final Function1<ExpandedAttribute, Boolean> _function = (ExpandedAttribute it) -> {
        String _name = it.getName();
        return Boolean.valueOf((!Objects.equal(_name, "meta")));
      };
      Iterable<ExpandedAttribute> _filter = IterableExtensions.<ExpandedAttribute>filter(attributes, _function);
      for(final ExpandedAttribute attribute : _filter) {
        {
          boolean _cardinalityIsListValue = RosettaAttributeExtensions.cardinalityIsListValue(attribute);
          if (_cardinalityIsListValue) {
            {
              boolean _isDataType = attribute.isDataType();
              if (_isDataType) {
                _builder.append("\t");
                _builder.append("if (get");
                String _firstUpper = StringExtensions.toFirstUpper(attribute.getName());
                _builder.append(_firstUpper, "\t");
                _builder.append("()!=null && get");
                String _firstUpper_1 = StringExtensions.toFirstUpper(attribute.getName());
                _builder.append(_firstUpper_1, "\t");
                _builder.append("().stream().filter(Objects::nonNull).anyMatch(a->a.hasData())) return true;");
                _builder.newLineIfNotEmpty();
              } else {
                _builder.append("\t");
                _builder.append("if (get");
                String _firstUpper_2 = StringExtensions.toFirstUpper(attribute.getName());
                _builder.append(_firstUpper_2, "\t");
                _builder.append("()!=null && !get");
                String _firstUpper_3 = StringExtensions.toFirstUpper(attribute.getName());
                _builder.append(_firstUpper_3, "\t");
                _builder.append("().isEmpty()) return true;");
                _builder.newLineIfNotEmpty();
              }
            }
          } else {
            boolean _isDataType_1 = attribute.isDataType();
            if (_isDataType_1) {
              _builder.append("\t");
              _builder.append("if (get");
              String _firstUpper_4 = StringExtensions.toFirstUpper(attribute.getName());
              _builder.append(_firstUpper_4, "\t");
              _builder.append("()!=null && get");
              String _firstUpper_5 = StringExtensions.toFirstUpper(attribute.getName());
              _builder.append(_firstUpper_5, "\t");
              _builder.append("().hasData()) return true;");
              _builder.newLineIfNotEmpty();
            } else {
              _builder.append("\t");
              _builder.append("if (get");
              String _firstUpper_6 = StringExtensions.toFirstUpper(attribute.getName());
              _builder.append(_firstUpper_6, "\t");
              _builder.append("()!=null) return true;");
              _builder.newLineIfNotEmpty();
            }
          }
        }
      }
    }
    _builder.append("\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  private StringConcatenationClient toBuilderType(final ExpandedAttribute attribute) {
    StringConcatenationClient _xifexpression = null;
    boolean _isMultiple = attribute.isMultiple();
    if (_isMultiple) {
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          _builder.append("List<");
          StringConcatenationClient _builderTypeSingle = ModelObjectBuilderGenerator.this.toBuilderTypeSingle(attribute);
          _builder.append(_builderTypeSingle);
          _builder.append(">");
        }
      };
      _xifexpression = _client;
    } else {
      StringConcatenationClient _client_1 = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          StringConcatenationClient _builderTypeSingle = ModelObjectBuilderGenerator.this.toBuilderTypeSingle(attribute);
          _builder.append(_builderTypeSingle);
        }
      };
      _xifexpression = _client_1;
    }
    return _xifexpression;
  }

  private StringConcatenationClient toBuilderTypeExt(final ExpandedAttribute attribute) {
    StringConcatenationClient _xifexpression = null;
    boolean _isMultiple = attribute.isMultiple();
    if (_isMultiple) {
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          _builder.append("List<");
          {
            if ((attribute.isDataType() || attribute.hasMetas())) {
              _builder.append("? extends ");
            }
          }
          StringConcatenationClient _builderTypeSingle = ModelObjectBuilderGenerator.this.toBuilderTypeSingle(attribute);
          _builder.append(_builderTypeSingle);
          _builder.append(">");
        }
      };
      _xifexpression = _client;
    } else {
      StringConcatenationClient _client_1 = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          StringConcatenationClient _builderTypeSingle = ModelObjectBuilderGenerator.this.toBuilderTypeSingle(attribute);
          _builder.append(_builderTypeSingle);
        }
      };
      _xifexpression = _client_1;
    }
    return _xifexpression;
  }

  public StringConcatenationClient toBuilderTypeSingle(final ExpandedAttribute attribute) {
    StringConcatenationClient _xifexpression = null;
    boolean _hasMetas = attribute.hasMetas();
    if (_hasMetas) {
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          JavaClass<?> _builderType = ModelObjectBuilderGenerator.this._javaTypeTranslator.toBuilderType(ModelObjectBuilderGenerator.this._javaTypeTranslator.toMetaJavaType(attribute));
          _builder.append(_builderType);
        }
      };
      _xifexpression = _client;
    } else {
      StringConcatenationClient _client_1 = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          StringConcatenationClient _builderTypeUnderlying = ModelObjectBuilderGenerator.this.toBuilderTypeUnderlying(attribute);
          _builder.append(_builderTypeUnderlying);
        }
      };
      _xifexpression = _client_1;
    }
    return _xifexpression;
  }

  private StringConcatenationClient toBuilderTypeUnderlying(final ExpandedAttribute attribute) {
    StringConcatenationClient _xifexpression = null;
    boolean _isDataType = attribute.isDataType();
    if (_isDataType) {
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          String _name = attribute.getType().getName();
          _builder.append(_name);
          _builder.append(".");
          String _name_1 = attribute.getType().getName();
          _builder.append(_name_1);
          _builder.append("Builder");
        }
      };
      _xifexpression = _client;
    } else {
      StringConcatenationClient _client_1 = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          JavaReferenceType _javaReferenceType = ModelObjectBuilderGenerator.this._javaTypeTranslator.toJavaReferenceType(ModelObjectBuilderGenerator.this._typeSystem.typeCallToRType(attribute.getRosettaType()));
          _builder.append(_javaReferenceType);
        }
      };
      _xifexpression = _client_1;
    }
    return _xifexpression;
  }

  private StringConcatenationClient toBuilder(final ExpandedAttribute attribute, final JavaScope scope) {
    StringConcatenationClient _xifexpression = null;
    boolean _needsBuilder = this._modelObjectBoilerPlate.needsBuilder(attribute);
    if (_needsBuilder) {
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          GeneratedIdentifier _identifierOrThrow = scope.getIdentifierOrThrow(attribute);
          _builder.append(_identifierOrThrow);
          _builder.append(".toBuilder()");
        }
      };
      _xifexpression = _client;
    } else {
      StringConcatenationClient _client_1 = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          GeneratedIdentifier _identifierOrThrow = scope.getIdentifierOrThrow(attribute);
          _builder.append(_identifierOrThrow);
        }
      };
      _xifexpression = _client_1;
    }
    return _xifexpression;
  }
}
