package com.regnosys.rosetta.generator.java.object;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.regnosys.rosetta.generator.GeneratedIdentifier;
import com.regnosys.rosetta.generator.java.JavaScope;
import com.regnosys.rosetta.generator.java.RosettaJavaPackages;
import com.regnosys.rosetta.generator.java.types.JavaTypeTranslator;
import com.regnosys.rosetta.generator.java.util.ImportManagerExtension;
import com.regnosys.rosetta.generator.java.util.ModelGeneratorUtil;
import com.regnosys.rosetta.generator.object.ExpandedAttribute;
import com.regnosys.rosetta.generator.util.RosettaAttributeExtensions;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.TypeSystem;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.util.DottedPath;
import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.JavaParameterizedType;
import com.rosetta.util.types.JavaReferenceType;
import com.rosetta.util.types.JavaType;
import com.rosetta.util.types.generated.GeneratedJavaClass;
import com.rosetta.util.types.generated.GeneratedJavaGenericTypeDeclaration;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class ModelObjectGenerator {
  @Inject
  @Extension
  private ModelObjectBoilerPlate _modelObjectBoilerPlate;

  @Inject
  @Extension
  private ModelObjectBuilderGenerator _modelObjectBuilderGenerator;

  @Inject
  @Extension
  private ImportManagerExtension _importManagerExtension;

  @Inject
  @Extension
  private JavaTypeTranslator _javaTypeTranslator;

  @Inject
  @Extension
  private TypeSystem _typeSystem;

  public void generate(final RosettaJavaPackages.RootPackage root, final IFileSystemAccess2 fsa, final Data data, final String version) {
    String _name = data.getName();
    String _plus = (_name + ".java");
    fsa.generateFile(root.child(_plus).withForwardSlashes(), 
      this.generateRosettaClass(root, data, version));
  }

  private String generateRosettaClass(final RosettaJavaPackages.RootPackage root, final Data d, final String version) {
    String _xblockexpression = null;
    {
      final JavaScope scope = new JavaScope(root);
      DottedPath _meta = root.meta();
      String _name = d.getName();
      String _plus = (_name + "Meta");
      GeneratedJavaClass<Object> _generatedJavaClass = new GeneratedJavaClass<Object>(_meta, _plus, Object.class);
      _xblockexpression = this._importManagerExtension.buildClass(root, this.classBody(d, scope, _generatedJavaClass, version), scope);
    }
    return _xblockexpression;
  }

  public StringConcatenationClient classBody(final Data d, final JavaScope scope, final JavaClass<?> metaType, final String version) {
    return this.classBody(d, scope, metaType, version, Collections.<Object>emptyList());
  }

  public StringConcatenationClient classBody(final Data d, final JavaScope scope, final JavaClass<?> metaType, final String version, final Collection<Object> interfaces) {
    StringConcatenationClient _xblockexpression = null;
    {
      final JavaClass<?> javaType = this._javaTypeTranslator.toJavaType(new RDataType(d));
      final JavaScope interfaceScope = scope.classScope(javaType.toString());
      final GeneratedIdentifier metaDataIdentifier = interfaceScope.createUniqueIdentifier("metaData");
      StringConcatenation _builder = new StringConcatenation();
      _builder.append(javaType);
      _builder.append("Builder");
      final JavaScope builderScope = interfaceScope.classScope(_builder.toString());
      StringConcatenation _builder_1 = new StringConcatenation();
      _builder_1.append(javaType);
      _builder_1.append("Impl");
      final JavaScope implScope = interfaceScope.classScope(_builder_1.toString());
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          String _javadoc = ModelGeneratorUtil.javadoc(d, version);
          _builder.append(_javadoc);
          _builder.newLineIfNotEmpty();
          _builder.append("@");
          _builder.append(RosettaDataType.class);
          _builder.append("(value=\"");
          String _name = d.getName();
          _builder.append(_name);
          _builder.append("\", builder=");
          JavaClass<?> _builderImplType = ModelObjectGenerator.this._javaTypeTranslator.toBuilderImplType(javaType);
          _builder.append(_builderImplType);
          _builder.append(".class, version=\"");
          String _version = d.getModel().getVersion();
          _builder.append(_version);
          _builder.append("\")");
          _builder.newLineIfNotEmpty();
          _builder.append("public interface ");
          _builder.append(javaType);
          _builder.append(" extends ");
          {
            boolean _hasSuperType = d.hasSuperType();
            if (_hasSuperType) {
              Data _superType = d.getSuperType();
              JavaClass<?> _javaType = ModelObjectGenerator.this._javaTypeTranslator.toJavaType(new RDataType(_superType));
              _builder.append(_javaType);
            } else {
              _builder.append(RosettaModelObject.class);
            }
          }
          StringConcatenationClient _implementsClause = ModelObjectGenerator.this._modelObjectBoilerPlate.implementsClause(d, interfaces);
          _builder.append(_implementsClause);
          _builder.append(" {");
          _builder.newLineIfNotEmpty();
          _builder.newLine();
          _builder.append("\t");
          _builder.append(metaType, "\t");
          _builder.append(" ");
          _builder.append(metaDataIdentifier, "\t");
          _builder.append(" = new ");
          _builder.append(metaType, "\t");
          _builder.append("();");
          _builder.newLineIfNotEmpty();
          _builder.newLine();
          _builder.append("\t");
          StringConcatenationClient _startComment = ModelObjectGenerator.this.startComment("Getter Methods");
          _builder.append(_startComment, "\t");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          StringConcatenationClient _pojoInterfaceGetterMethods = ModelObjectGenerator.this.pojoInterfaceGetterMethods(javaType, metaType, metaDataIdentifier, d);
          _builder.append(_pojoInterfaceGetterMethods, "\t");
          _builder.newLineIfNotEmpty();
          _builder.newLine();
          _builder.append("\t");
          StringConcatenationClient _startComment_1 = ModelObjectGenerator.this.startComment("Build Methods");
          _builder.append(_startComment_1, "\t");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          StringConcatenationClient _pojoInterfaceBuilderMethods = ModelObjectGenerator.this.pojoInterfaceBuilderMethods(javaType, d);
          _builder.append(_pojoInterfaceBuilderMethods, "\t");
          _builder.newLineIfNotEmpty();
          _builder.newLine();
          _builder.append("\t");
          StringConcatenationClient _startComment_2 = ModelObjectGenerator.this.startComment("Utility Methods");
          _builder.append(_startComment_2, "\t");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          StringConcatenationClient _pojoInterfaceDefaultOverridenMethods = ModelObjectGenerator.this.pojoInterfaceDefaultOverridenMethods(javaType, metaDataIdentifier, interfaces, d);
          _builder.append(_pojoInterfaceDefaultOverridenMethods, "\t");
          _builder.newLineIfNotEmpty();
          _builder.newLine();
          _builder.append("\t");
          StringConcatenationClient _startComment_3 = ModelObjectGenerator.this.startComment("Builder Interface");
          _builder.append(_startComment_3, "\t");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("interface ");
          _builder.append(javaType, "\t");
          _builder.append("Builder extends ");
          String _name_1 = d.getName();
          _builder.append(_name_1, "\t");
          _builder.append(", ");
          {
            boolean _hasSuperType_1 = d.hasSuperType();
            if (_hasSuperType_1) {
              Data _superType_1 = d.getSuperType();
              JavaClass<?> _builderType = ModelObjectGenerator.this._javaTypeTranslator.toBuilderType(ModelObjectGenerator.this._javaTypeTranslator.toJavaType(new RDataType(_superType_1)));
              _builder.append(_builderType, "\t");
              _builder.append(", ");
            }
          }
          _builder.append(RosettaModelObjectBuilder.class, "\t");
          {
            boolean _hasElements = false;
            for(final Object inter : interfaces) {
              if (!_hasElements) {
                _hasElements = true;
                _builder.append(", ", "\t");
              } else {
                _builder.appendImmediate(", ", "\t");
              }
              JavaClass<Object> _buildify = ModelObjectGenerator.this.buildify(inter);
              _builder.append(_buildify, "\t");
            }
          }
          _builder.append(" {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          StringConcatenationClient _pojoBuilderInterfaceGetterMethods = ModelObjectGenerator.this.pojoBuilderInterfaceGetterMethods(d, javaType, builderScope);
          _builder.append(_pojoBuilderInterfaceGetterMethods, "\t\t");
          _builder.newLineIfNotEmpty();
          _builder.newLine();
          _builder.append("\t\t");
          StringConcatenationClient _builderProcessMethod = ModelObjectGenerator.this._modelObjectBoilerPlate.builderProcessMethod(d);
          _builder.append(_builderProcessMethod, "\t\t");
          _builder.newLineIfNotEmpty();
          _builder.newLine();
          _builder.append("\t\t");
          JavaClass<?> _builderType_1 = ModelObjectGenerator.this._javaTypeTranslator.toBuilderType(javaType);
          _builder.append(_builderType_1, "\t\t");
          _builder.append(" prune();");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.newLine();
          _builder.append("\t");
          StringConcatenation _builder_1 = new StringConcatenation();
          _builder_1.append("Immutable Implementation of ");
          String _name_2 = d.getName();
          _builder_1.append(_name_2);
          StringConcatenationClient _startComment_4 = ModelObjectGenerator.this.startComment(_builder_1.toString());
          _builder.append(_startComment_4, "\t");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("class ");
          _builder.append(javaType, "\t");
          _builder.append("Impl ");
          {
            boolean _hasSuperType_2 = d.hasSuperType();
            if (_hasSuperType_2) {
              _builder.append("extends ");
              Data _superType_2 = d.getSuperType();
              JavaClass<?> _implType = ModelObjectGenerator.this._javaTypeTranslator.toImplType(ModelObjectGenerator.this._javaTypeTranslator.toJavaType(new RDataType(_superType_2)));
              _builder.append(_implType, "\t");
              _builder.append(" ");
            }
          }
          _builder.append("implements ");
          String _name_3 = d.getName();
          _builder.append(_name_3, "\t");
          _builder.append(" {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          StringConcatenationClient _rosettaClass = ModelObjectGenerator.this.rosettaClass(d, implScope);
          _builder.append(_rosettaClass, "\t\t");
          _builder.newLineIfNotEmpty();
          _builder.newLine();
          _builder.append("\t\t");
          StringConcatenationClient _boilerPlate = ModelObjectGenerator.this._modelObjectBoilerPlate.boilerPlate(d, implScope);
          _builder.append(_boilerPlate, "\t\t");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.newLine();
          _builder.append("\t");
          StringConcatenation _builder_2 = new StringConcatenation();
          _builder_2.append("Builder Implementation of ");
          String _name_4 = d.getName();
          _builder_2.append(_name_4);
          StringConcatenationClient _startComment_5 = ModelObjectGenerator.this.startComment(_builder_2.toString());
          _builder.append(_startComment_5, "\t");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          StringConcatenationClient _builderClass = ModelObjectGenerator.this._modelObjectBuilderGenerator.builderClass(d, interfaceScope);
          _builder.append(_builderClass, "\t");
          _builder.newLineIfNotEmpty();
          _builder.append("}");
          _builder.newLine();
        }
      };
      _xblockexpression = _client;
    }
    return _xblockexpression;
  }

  protected StringConcatenationClient pojoBuilderInterfaceGetterMethods(final Data d, final JavaClass<?> javaType, final JavaScope builderScope) {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        {
          List<ExpandedAttribute> _expandedAttributes = RosettaAttributeExtensions.getExpandedAttributes(d);
          for(final ExpandedAttribute attribute : _expandedAttributes) {
            {
              if ((attribute.isDataType() || attribute.hasMetas())) {
                {
                  boolean _cardinalityIsSingleValue = RosettaAttributeExtensions.cardinalityIsSingleValue(attribute);
                  if (_cardinalityIsSingleValue) {
                    StringConcatenationClient _builderTypeSingle = ModelObjectGenerator.this._modelObjectBuilderGenerator.toBuilderTypeSingle(attribute);
                    _builder.append(_builderTypeSingle);
                    _builder.append(" getOrCreate");
                    String _firstUpper = StringExtensions.toFirstUpper(attribute.getName());
                    _builder.append(_firstUpper);
                    _builder.append("();");
                    _builder.newLineIfNotEmpty();
                    StringConcatenationClient _builderTypeSingle_1 = ModelObjectGenerator.this._modelObjectBuilderGenerator.toBuilderTypeSingle(attribute);
                    _builder.append(_builderTypeSingle_1);
                    _builder.append(" get");
                    String _firstUpper_1 = StringExtensions.toFirstUpper(attribute.getName());
                    _builder.append(_firstUpper_1);
                    _builder.append("();");
                    _builder.newLineIfNotEmpty();
                  } else {
                    StringConcatenationClient _builderTypeSingle_2 = ModelObjectGenerator.this._modelObjectBuilderGenerator.toBuilderTypeSingle(attribute);
                    _builder.append(_builderTypeSingle_2);
                    _builder.append(" getOrCreate");
                    String _firstUpper_2 = StringExtensions.toFirstUpper(attribute.getName());
                    _builder.append(_firstUpper_2);
                    _builder.append("(int _index);");
                    _builder.newLineIfNotEmpty();
                    _builder.append(List.class);
                    _builder.append("<? extends ");
                    StringConcatenationClient _builderTypeSingle_3 = ModelObjectGenerator.this._modelObjectBuilderGenerator.toBuilderTypeSingle(attribute);
                    _builder.append(_builderTypeSingle_3);
                    _builder.append("> get");
                    String _firstUpper_3 = StringExtensions.toFirstUpper(attribute.getName());
                    _builder.append(_firstUpper_3);
                    _builder.append("();");
                    _builder.newLineIfNotEmpty();
                  }
                }
              }
            }
          }
        }
        {
          List<ExpandedAttribute> _expandedAttributesPlus = RosettaAttributeExtensions.expandedAttributesPlus(d);
          for(final ExpandedAttribute attribute_1 : _expandedAttributesPlus) {
            {
              boolean _cardinalityIsSingleValue_1 = RosettaAttributeExtensions.cardinalityIsSingleValue(attribute_1);
              if (_cardinalityIsSingleValue_1) {
                JavaClass<?> _builderType = ModelObjectGenerator.this._javaTypeTranslator.toBuilderType(javaType);
                _builder.append(_builderType);
                _builder.append(" set");
                String _firstUpper_4 = StringExtensions.toFirstUpper(attribute_1.getName());
                _builder.append(_firstUpper_4);
                _builder.append("(");
                JavaType _listOrSingleMetaType = ModelObjectGenerator.this._modelObjectBoilerPlate.toListOrSingleMetaType(attribute_1);
                _builder.append(_listOrSingleMetaType);
                _builder.append(" ");
                GeneratedIdentifier _createUniqueIdentifier = builderScope.createUniqueIdentifier(attribute_1.getName());
                _builder.append(_createUniqueIdentifier);
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                {
                  boolean _hasMetas = attribute_1.hasMetas();
                  if (_hasMetas) {
                    JavaClass<?> _builderType_1 = ModelObjectGenerator.this._javaTypeTranslator.toBuilderType(javaType);
                    _builder.append(_builderType_1);
                    _builder.append(" set");
                    String _firstUpper_5 = StringExtensions.toFirstUpper(attribute_1.getName());
                    _builder.append(_firstUpper_5);
                    _builder.append("Value(");
                    JavaReferenceType _javaReferenceType = ModelObjectGenerator.this._javaTypeTranslator.toJavaReferenceType(ModelObjectGenerator.this._typeSystem.typeCallToRType(attribute_1.getRosettaType()));
                    _builder.append(_javaReferenceType);
                    _builder.append(" ");
                    GeneratedIdentifier _createUniqueIdentifier_1 = builderScope.createUniqueIdentifier(attribute_1.getName());
                    _builder.append(_createUniqueIdentifier_1);
                    _builder.append(");");
                  }
                }
                _builder.newLineIfNotEmpty();
              } else {
                JavaClass<?> _builderType_2 = ModelObjectGenerator.this._javaTypeTranslator.toBuilderType(javaType);
                _builder.append(_builderType_2);
                _builder.append(" add");
                String _firstUpper_6 = StringExtensions.toFirstUpper(attribute_1.getName());
                _builder.append(_firstUpper_6);
                _builder.append("(");
                JavaReferenceType _metaOrRegularJavaType = ModelObjectGenerator.this._javaTypeTranslator.toMetaOrRegularJavaType(attribute_1);
                _builder.append(_metaOrRegularJavaType);
                _builder.append(" ");
                GeneratedIdentifier _createUniqueIdentifier_2 = builderScope.createUniqueIdentifier(attribute_1.getName());
                _builder.append(_createUniqueIdentifier_2);
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                JavaClass<?> _builderType_3 = ModelObjectGenerator.this._javaTypeTranslator.toBuilderType(javaType);
                _builder.append(_builderType_3);
                _builder.append(" add");
                String _firstUpper_7 = StringExtensions.toFirstUpper(attribute_1.getName());
                _builder.append(_firstUpper_7);
                _builder.append("(");
                JavaReferenceType _metaOrRegularJavaType_1 = ModelObjectGenerator.this._javaTypeTranslator.toMetaOrRegularJavaType(attribute_1);
                _builder.append(_metaOrRegularJavaType_1);
                _builder.append(" ");
                GeneratedIdentifier _createUniqueIdentifier_3 = builderScope.createUniqueIdentifier(attribute_1.getName());
                _builder.append(_createUniqueIdentifier_3);
                _builder.append(", int _idx);");
                _builder.newLineIfNotEmpty();
                {
                  boolean _hasMetas_1 = attribute_1.hasMetas();
                  if (_hasMetas_1) {
                    JavaClass<?> _builderType_4 = ModelObjectGenerator.this._javaTypeTranslator.toBuilderType(javaType);
                    _builder.append(_builderType_4);
                    _builder.append(" add");
                    String _firstUpper_8 = StringExtensions.toFirstUpper(attribute_1.getName());
                    _builder.append(_firstUpper_8);
                    _builder.append("Value(");
                    JavaReferenceType _javaReferenceType_1 = ModelObjectGenerator.this._javaTypeTranslator.toJavaReferenceType(ModelObjectGenerator.this._typeSystem.typeCallToRType(attribute_1.getRosettaType()));
                    _builder.append(_javaReferenceType_1);
                    _builder.append(" ");
                    GeneratedIdentifier _createUniqueIdentifier_4 = builderScope.createUniqueIdentifier(attribute_1.getName());
                    _builder.append(_createUniqueIdentifier_4);
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                    JavaClass<?> _builderType_5 = ModelObjectGenerator.this._javaTypeTranslator.toBuilderType(javaType);
                    _builder.append(_builderType_5);
                    _builder.append(" add");
                    String _firstUpper_9 = StringExtensions.toFirstUpper(attribute_1.getName());
                    _builder.append(_firstUpper_9);
                    _builder.append("Value(");
                    JavaReferenceType _javaReferenceType_2 = ModelObjectGenerator.this._javaTypeTranslator.toJavaReferenceType(ModelObjectGenerator.this._typeSystem.typeCallToRType(attribute_1.getRosettaType()));
                    _builder.append(_javaReferenceType_2);
                    _builder.append(" ");
                    GeneratedIdentifier _createUniqueIdentifier_5 = builderScope.createUniqueIdentifier(attribute_1.getName());
                    _builder.append(_createUniqueIdentifier_5);
                    _builder.append(", int _idx);");
                  }
                }
                _builder.newLineIfNotEmpty();
                {
                  boolean _isOverriding = attribute_1.isOverriding();
                  boolean _not = (!_isOverriding);
                  if (_not) {
                    JavaClass<?> _builderType_6 = ModelObjectGenerator.this._javaTypeTranslator.toBuilderType(javaType);
                    _builder.append(_builderType_6);
                    _builder.append(" add");
                    String _firstUpper_10 = StringExtensions.toFirstUpper(attribute_1.getName());
                    _builder.append(_firstUpper_10);
                    _builder.append("(");
                    JavaType _listOrSingleMetaType_1 = ModelObjectGenerator.this._modelObjectBoilerPlate.toListOrSingleMetaType(attribute_1);
                    _builder.append(_listOrSingleMetaType_1);
                    _builder.append(" ");
                    GeneratedIdentifier _createUniqueIdentifier_6 = builderScope.createUniqueIdentifier(attribute_1.getName());
                    _builder.append(_createUniqueIdentifier_6);
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                    JavaClass<?> _builderType_7 = ModelObjectGenerator.this._javaTypeTranslator.toBuilderType(javaType);
                    _builder.append(_builderType_7);
                    _builder.append(" set");
                    String _firstUpper_11 = StringExtensions.toFirstUpper(attribute_1.getName());
                    _builder.append(_firstUpper_11);
                    _builder.append("(");
                    JavaType _listOrSingleMetaType_2 = ModelObjectGenerator.this._modelObjectBoilerPlate.toListOrSingleMetaType(attribute_1);
                    _builder.append(_listOrSingleMetaType_2);
                    _builder.append(" ");
                    GeneratedIdentifier _createUniqueIdentifier_7 = builderScope.createUniqueIdentifier(attribute_1.getName());
                    _builder.append(_createUniqueIdentifier_7);
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                    {
                      boolean _hasMetas_2 = attribute_1.hasMetas();
                      if (_hasMetas_2) {
                        JavaClass<?> _builderType_8 = ModelObjectGenerator.this._javaTypeTranslator.toBuilderType(javaType);
                        _builder.append(_builderType_8);
                        _builder.append(" add");
                        String _firstUpper_12 = StringExtensions.toFirstUpper(attribute_1.getName());
                        _builder.append(_firstUpper_12);
                        _builder.append("Value(");
                        JavaReferenceType _polymorphicListOrSingleJavaType = ModelObjectGenerator.this._javaTypeTranslator.toPolymorphicListOrSingleJavaType(ModelObjectGenerator.this._typeSystem.typeCallToRType(attribute_1.getRosettaType()), attribute_1.isMultiple());
                        _builder.append(_polymorphicListOrSingleJavaType);
                        _builder.append(" ");
                        GeneratedIdentifier _createUniqueIdentifier_8 = builderScope.createUniqueIdentifier(attribute_1.getName());
                        _builder.append(_createUniqueIdentifier_8);
                        _builder.append(");");
                        _builder.newLineIfNotEmpty();
                        JavaClass<?> _builderType_9 = ModelObjectGenerator.this._javaTypeTranslator.toBuilderType(javaType);
                        _builder.append(_builderType_9);
                        _builder.append(" set");
                        String _firstUpper_13 = StringExtensions.toFirstUpper(attribute_1.getName());
                        _builder.append(_firstUpper_13);
                        _builder.append("Value(");
                        JavaReferenceType _polymorphicListOrSingleJavaType_1 = ModelObjectGenerator.this._javaTypeTranslator.toPolymorphicListOrSingleJavaType(ModelObjectGenerator.this._typeSystem.typeCallToRType(attribute_1.getRosettaType()), attribute_1.isMultiple());
                        _builder.append(_polymorphicListOrSingleJavaType_1);
                        _builder.append(" ");
                        GeneratedIdentifier _createUniqueIdentifier_9 = builderScope.createUniqueIdentifier(attribute_1.getName());
                        _builder.append(_createUniqueIdentifier_9);
                        _builder.append(");");
                      }
                    }
                    _builder.newLineIfNotEmpty();
                  }
                }
              }
            }
          }
        }
      }
    };
    return _client;
  }

  protected StringConcatenationClient pojoInterfaceDefaultOverridenMethods(final JavaClass<?> javaType, final GeneratedIdentifier metaDataIdentifier, final Collection<Object> interfaces, final Data d) {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("default ");
        _builder.append(RosettaMetaData.class);
        _builder.append("<? extends ");
        _builder.append(javaType);
        _builder.append("> metaData() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return ");
        _builder.append(metaDataIdentifier, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("default Class<? extends ");
        _builder.append(javaType);
        _builder.append("> getType() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return ");
        _builder.append(javaType, "\t");
        _builder.append(".class;");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        {
          final Function1<JavaParameterizedType, Boolean> _function = (JavaParameterizedType it) -> {
            return Boolean.valueOf((Objects.equal(it.getSimpleName(), "ReferenceWithMeta") || Objects.equal(it.getSimpleName(), "FieldWithMeta")));
          };
          Iterable<JavaParameterizedType> _filter = IterableExtensions.<JavaParameterizedType>filter(Iterables.<JavaParameterizedType>filter(interfaces, JavaParameterizedType.class), _function);
          for(final JavaParameterizedType pt : _filter) {
            _builder.append("@Override");
            _builder.newLine();
            _builder.append("default Class<");
            Object _head = IterableExtensions.<Object>head(pt.getArguments());
            _builder.append(_head);
            _builder.append("> getValueType() {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("return ");
            Object _head_1 = IterableExtensions.<Object>head(pt.getArguments());
            _builder.append(_head_1, "\t");
            _builder.append(".class;");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
          }
        }
        _builder.newLine();
        StringConcatenationClient _processMethod = ModelObjectGenerator.this._modelObjectBoilerPlate.processMethod(d);
        _builder.append(_processMethod);
        _builder.newLineIfNotEmpty();
      }
    };
    return _client;
  }

  protected StringConcatenationClient pojoInterfaceGetterMethods(final JavaClass<?> javaType, final JavaClass<?> metaType, final GeneratedIdentifier metaDataIdentifier, final Data d) {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        {
          List<ExpandedAttribute> _expandedAttributes = RosettaAttributeExtensions.getExpandedAttributes(d);
          for(final ExpandedAttribute attribute : _expandedAttributes) {
            String _javadoc = ModelGeneratorUtil.javadoc(attribute.getDefinition(), attribute.getDocReferences(), null);
            _builder.append(_javadoc);
            _builder.newLineIfNotEmpty();
            JavaReferenceType _multiMetaOrRegularJavaType = ModelObjectGenerator.this._javaTypeTranslator.toMultiMetaOrRegularJavaType(attribute);
            _builder.append(_multiMetaOrRegularJavaType);
            _builder.append(" get");
            String _firstUpper = StringExtensions.toFirstUpper(attribute.getName());
            _builder.append(_firstUpper);
            _builder.append("();");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    };
    return _client;
  }

  protected StringConcatenationClient pojoInterfaceBuilderMethods(final JavaClass<?> javaType, final Data d) {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        String _name = d.getName();
        _builder.append(_name);
        _builder.append(" build();");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        JavaClass<?> _builderType = ModelObjectGenerator.this._javaTypeTranslator.toBuilderType(javaType);
        _builder.append(_builderType);
        _builder.append(" toBuilder();");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("static ");
        JavaClass<?> _builderType_1 = ModelObjectGenerator.this._javaTypeTranslator.toBuilderType(javaType);
        _builder.append(_builderType_1);
        _builder.append(" builder() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return new ");
        JavaClass<?> _builderImplType = ModelObjectGenerator.this._javaTypeTranslator.toBuilderImplType(javaType);
        _builder.append(_builderImplType, "\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
      }
    };
    return _client;
  }

  protected JavaClass<Object> _buildify(final Object object) {
    throw new UnsupportedOperationException("TODO: auto-generated method stub");
  }

  protected JavaClass<Object> _buildify(final Class<?> clazz) {
    DottedPath _splitOnDots = DottedPath.splitOnDots(clazz.getPackageName());
    String _simpleName = clazz.getSimpleName();
    String _plus = (_simpleName + ".");
    String _simpleName_1 = clazz.getSimpleName();
    String _plus_1 = (_plus + _simpleName_1);
    String _plus_2 = (_plus_1 + "Builder");
    return new GeneratedJavaClass<Object>(_splitOnDots, _plus_2, Object.class);
  }

  protected JavaClass<Object> _buildify(final JavaParameterizedType<?> clazz) {
    JavaParameterizedType<Object> _xblockexpression = null;
    {
      DottedPath _packageName = clazz.getPackageName();
      String _simpleName = clazz.getSimpleName();
      String _plus = (_simpleName + ".");
      String _simpleName_1 = clazz.getSimpleName();
      String _plus_1 = (_plus + _simpleName_1);
      String _plus_2 = (_plus_1 + "Builder");
      final GeneratedJavaClass<Object> builderClass = new GeneratedJavaClass<Object>(_packageName, _plus_2, Object.class);
      final GeneratedJavaGenericTypeDeclaration<Object> builderDeclaration = new GeneratedJavaGenericTypeDeclaration<Object>(builderClass, "T");
      _xblockexpression = JavaParameterizedType.<Object>from(builderDeclaration, clazz.getArguments());
    }
    return _xblockexpression;
  }

  public boolean globalKeyRecursive(final Data class1) {
    return (this._modelObjectBuilderGenerator.globalKey(class1) || ((class1.getSuperType() != null) && this.globalKeyRecursive(class1.getSuperType())));
  }

  private StringConcatenationClient rosettaClass(final Data c, final JavaScope scope) {
    StringConcatenationClient _xblockexpression = null;
    {
      final List<ExpandedAttribute> expandedAttributes = RosettaAttributeExtensions.getExpandedAttributes(c);
      final JavaClass<?> javaType = this._javaTypeTranslator.toJavaType(new RDataType(c));
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          {
            for(final ExpandedAttribute attribute : expandedAttributes) {
              _builder.append("private final ");
              JavaReferenceType _multiMetaOrRegularJavaType = ModelObjectGenerator.this._javaTypeTranslator.toMultiMetaOrRegularJavaType(attribute);
              _builder.append(_multiMetaOrRegularJavaType);
              _builder.append(" ");
              GeneratedIdentifier _createIdentifier = scope.createIdentifier(attribute, StringExtensions.toFirstLower(attribute.getName()));
              _builder.append(_createIdentifier);
              _builder.append(";");
              _builder.newLineIfNotEmpty();
            }
          }
          _builder.newLine();
          _builder.append("protected ");
          _builder.append(javaType);
          _builder.append("Impl(");
          JavaClass<?> _builderType = ModelObjectGenerator.this._javaTypeTranslator.toBuilderType(javaType);
          _builder.append(_builderType);
          _builder.append(" builder) {");
          _builder.newLineIfNotEmpty();
          {
            boolean _hasSuperType = c.hasSuperType();
            if (_hasSuperType) {
              _builder.append("\t");
              _builder.append("super(builder);");
              _builder.newLine();
            }
          }
          {
            for(final ExpandedAttribute attribute_1 : expandedAttributes) {
              _builder.append("\t");
              _builder.append("this.");
              GeneratedIdentifier _identifierOrThrow = scope.getIdentifierOrThrow(attribute_1);
              _builder.append(_identifierOrThrow, "\t");
              _builder.append(" = ");
              StringConcatenationClient _attributeFromBuilder = ModelObjectGenerator.this.attributeFromBuilder(attribute_1);
              _builder.append(_attributeFromBuilder, "\t");
              _builder.append(";");
              _builder.newLineIfNotEmpty();
            }
          }
          _builder.append("}");
          _builder.newLine();
          _builder.newLine();
          {
            for(final ExpandedAttribute attribute_2 : expandedAttributes) {
              _builder.append("@Override");
              _builder.newLine();
              _builder.append("@");
              _builder.append(RosettaAttribute.class);
              _builder.append("(\"");
              String _javaAnnotation = attribute_2.javaAnnotation();
              _builder.append(_javaAnnotation);
              _builder.append("\")");
              _builder.newLineIfNotEmpty();
              _builder.append("public ");
              JavaReferenceType _multiMetaOrRegularJavaType_1 = ModelObjectGenerator.this._javaTypeTranslator.toMultiMetaOrRegularJavaType(attribute_2);
              _builder.append(_multiMetaOrRegularJavaType_1);
              _builder.append(" get");
              String _firstUpper = StringExtensions.toFirstUpper(attribute_2.getName());
              _builder.append(_firstUpper);
              _builder.append("() {");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("return ");
              GeneratedIdentifier _identifierOrThrow_1 = scope.getIdentifierOrThrow(attribute_2);
              _builder.append(_identifierOrThrow_1, "\t");
              _builder.append(";");
              _builder.newLineIfNotEmpty();
              _builder.append("}");
              _builder.newLine();
              _builder.newLine();
            }
          }
          _builder.append("@Override");
          _builder.newLine();
          _builder.append("public ");
          String _name = c.getName();
          _builder.append(_name);
          _builder.append(" build() {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("return this;");
          _builder.newLine();
          _builder.append("}");
          _builder.newLine();
          _builder.newLine();
          _builder.append("@Override");
          _builder.newLine();
          _builder.append("public ");
          JavaClass<?> _builderType_1 = ModelObjectGenerator.this._javaTypeTranslator.toBuilderType(javaType);
          _builder.append(_builderType_1);
          _builder.append(" toBuilder() {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          JavaClass<?> _builderType_2 = ModelObjectGenerator.this._javaTypeTranslator.toBuilderType(javaType);
          _builder.append(_builderType_2, "\t");
          _builder.append(" builder = builder();");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("setBuilderFields(builder);");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("return builder;");
          _builder.newLine();
          _builder.append("}");
          _builder.newLine();
          _builder.newLine();
          _builder.append("protected void setBuilderFields(");
          JavaClass<?> _builderType_3 = ModelObjectGenerator.this._javaTypeTranslator.toBuilderType(javaType);
          _builder.append(_builderType_3);
          _builder.append(" builder) {");
          _builder.newLineIfNotEmpty();
          {
            boolean _hasSuperType_1 = c.hasSuperType();
            if (_hasSuperType_1) {
              _builder.append("\t");
              _builder.append("super.setBuilderFields(builder);");
              _builder.newLine();
            }
          }
          {
            for(final ExpandedAttribute attribute_3 : expandedAttributes) {
              _builder.append("\t");
              Method _method = ModelObjectGenerator.this._importManagerExtension.method(Optional.class, "ofNullable");
              _builder.append(_method, "\t");
              _builder.append("(get");
              String _firstUpper_1 = StringExtensions.toFirstUpper(attribute_3.getName());
              _builder.append(_firstUpper_1, "\t");
              _builder.append("()).ifPresent(builder::set");
              String _firstUpper_2 = StringExtensions.toFirstUpper(attribute_3.getName());
              _builder.append(_firstUpper_2, "\t");
              _builder.append(");");
              _builder.newLineIfNotEmpty();
            }
          }
          _builder.append("}");
          _builder.newLine();
        }
      };
      _xblockexpression = _client;
    }
    return _xblockexpression;
  }

  private StringConcatenationClient attributeFromBuilder(final ExpandedAttribute attribute) {
    StringConcatenationClient _xifexpression = null;
    if ((attribute.isDataType() || attribute.hasMetas())) {
      StringConcatenationClient _xifexpression_1 = null;
      boolean _cardinalityIsListValue = RosettaAttributeExtensions.cardinalityIsListValue(attribute);
      if (_cardinalityIsListValue) {
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("ofNullable(builder.get");
            String _firstUpper = StringExtensions.toFirstUpper(attribute.getName());
            _builder.append(_firstUpper);
            _builder.append("()).filter(_l->!_l.isEmpty()).map(");
            StringConcatenationClient _buildRosettaObject = ModelObjectGenerator.this.buildRosettaObject(attribute);
            _builder.append(_buildRosettaObject);
            _builder.append(").orElse(null)");
          }
        };
        _xifexpression_1 = _client;
      } else {
        StringConcatenationClient _client_1 = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("ofNullable(builder.get");
            String _firstUpper = StringExtensions.toFirstUpper(attribute.getName());
            _builder.append(_firstUpper);
            _builder.append("()).map(");
            StringConcatenationClient _buildRosettaObject = ModelObjectGenerator.this.buildRosettaObject(attribute);
            _builder.append(_buildRosettaObject);
            _builder.append(").orElse(null)");
          }
        };
        _xifexpression_1 = _client_1;
      }
      _xifexpression = _xifexpression_1;
    } else {
      StringConcatenationClient _xifexpression_2 = null;
      boolean _cardinalityIsSingleValue = RosettaAttributeExtensions.cardinalityIsSingleValue(attribute);
      if (_cardinalityIsSingleValue) {
        StringConcatenationClient _client_2 = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("builder.get");
            String _firstUpper = StringExtensions.toFirstUpper(attribute.getName());
            _builder.append(_firstUpper);
            _builder.append("()");
            {
              boolean _needsBuilder = ModelObjectGenerator.this._modelObjectBoilerPlate.needsBuilder(attribute);
              if (_needsBuilder) {
                _builder.append(".build()");
              }
            }
          }
        };
        _xifexpression_2 = _client_2;
      } else {
        StringConcatenationClient _client_3 = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("ofNullable(builder.get");
            String _firstUpper = StringExtensions.toFirstUpper(attribute.getName());
            _builder.append(_firstUpper);
            _builder.append("()).filter(_l->!_l.isEmpty()).map(");
            _builder.append(ImmutableList.class);
            _builder.append("::copyOf).orElse(null)");
          }
        };
        _xifexpression_2 = _client_3;
      }
      _xifexpression = _xifexpression_2;
    }
    return _xifexpression;
  }

  private StringConcatenationClient buildRosettaObject(final ExpandedAttribute attribute) {
    StringConcatenationClient _xifexpression = null;
    boolean _cardinalityIsListValue = RosettaAttributeExtensions.cardinalityIsListValue(attribute);
    if (_cardinalityIsListValue) {
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          _builder.append("list -> list.stream().filter(");
          _builder.append(java.util.Objects.class);
          _builder.append("::nonNull).map(f->f.build()).filter(");
          _builder.append(java.util.Objects.class);
          _builder.append("::nonNull).collect(");
          _builder.append(ImmutableList.class);
          _builder.append(".toImmutableList())");
        }
      };
      _xifexpression = _client;
    } else {
      StringConcatenationClient _client_1 = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          _builder.append("f->f.build()");
        }
      };
      _xifexpression = _client_1;
    }
    return _xifexpression;
  }

  private StringConcatenationClient startComment(final String msg) {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        _builder.append("/*********************** ");
        _builder.append(msg);
        _builder.append("  ***********************/");
      }
    };
    return _client;
  }

  public JavaClass<Object> buildify(final Object clazz) {
    if (clazz instanceof JavaParameterizedType) {
      return _buildify((JavaParameterizedType<?>)clazz);
    } else if (clazz instanceof Class) {
      return _buildify((Class<?>)clazz);
    } else if (clazz != null) {
      return _buildify(clazz);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(clazz).toString());
    }
  }
}
