package com.regnosys.rosetta.generator.java.reports;

import com.fasterxml.jackson.core.type.TypeReference;
import com.regnosys.rosetta.generator.java.JavaScope;
import com.regnosys.rosetta.generator.java.RosettaJavaPackages;
import com.regnosys.rosetta.generator.java.function.FunctionGenerator;
import com.regnosys.rosetta.generator.java.types.JavaTypeTranslator;
import com.regnosys.rosetta.generator.java.util.ImportManagerExtension;
import com.regnosys.rosetta.rosetta.RosettaRule;
import com.regnosys.rosetta.types.RAttribute;
import com.regnosys.rosetta.types.RFunction;
import com.regnosys.rosetta.types.RObjectFactory;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.util.DottedPath;
import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.JavaParameterizedType;
import com.rosetta.util.types.JavaType;
import java.util.Collections;
import javax.inject.Inject;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class RuleGenerator {
  @Inject
  @Extension
  private JavaTypeTranslator _javaTypeTranslator;

  @Inject
  @Extension
  private RObjectFactory _rObjectFactory;

  @Inject
  @Extension
  private ImportManagerExtension _importManagerExtension;

  @Inject
  private FunctionGenerator functionGenerator;

  public void generate(final RosettaJavaPackages.RootPackage root, final IFileSystemAccess2 fsa, final RosettaRule rule, final String version) {
    final RFunction rFunctionRule = this._rObjectFactory.buildRFunction(rule);
    final JavaClass<? extends RosettaFunction> clazz = this._javaTypeTranslator.toFunctionJavaClass(rFunctionRule);
    final JavaParameterizedType<ReportFunction<?, ?>> baseInterface = JavaParameterizedType.<ReportFunction<?, ?>>from(new TypeReference<ReportFunction<?, ?>>() {
    }, this._javaTypeTranslator.attributeToJavaType(IterableExtensions.<RAttribute>head(rFunctionRule.getInputs())), this._javaTypeTranslator.attributeToJavaType(rFunctionRule.getOutput()));
    DottedPath _packageName = clazz.getPackageName();
    final JavaScope topScope = new JavaScope(_packageName);
    final StringConcatenationClient classBody = this.functionGenerator.rBuildClass(rFunctionRule, false, Collections.<JavaType>unmodifiableList(CollectionLiterals.<JavaType>newArrayList(baseInterface)), CollectionLiterals.<Class<?>, String>emptyMap(), true, topScope);
    final String content = this._importManagerExtension.buildClass(clazz.getPackageName(), classBody, topScope);
    String _withForwardSlashes = clazz.getCanonicalName().withForwardSlashes();
    String _plus = (_withForwardSlashes + ".java");
    fsa.generateFile(_plus, content);
  }
}
