package com.regnosys.rosetta.generator.java.reports;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.regnosys.rosetta.RosettaExtensions;
import com.regnosys.rosetta.generator.GeneratedIdentifier;
import com.regnosys.rosetta.generator.java.JavaScope;
import com.regnosys.rosetta.generator.java.types.JavaTypeTranslator;
import com.regnosys.rosetta.generator.java.types.JavaTypeUtil;
import com.regnosys.rosetta.generator.java.util.ImportManagerExtension;
import com.regnosys.rosetta.rosetta.RosettaExternalRuleSource;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.regnosys.rosetta.rosetta.RosettaReport;
import com.regnosys.rosetta.rosetta.RosettaRule;
import com.regnosys.rosetta.rosetta.RosettaType;
import com.regnosys.rosetta.rosetta.simple.AnnotationRef;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.rosetta.simple.Function;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.RosettaTypeProvider;
import com.rosetta.model.lib.ModelSymbolId;
import com.rosetta.model.lib.reports.Tabulator;
import com.rosetta.util.DottedPath;
import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.JavaParameterizedType;
import com.rosetta.util.types.JavaReferenceType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@SuppressWarnings("all")
public class TabulatorGenerator {
  private interface TabulatorContext {
    boolean needsTabulator(final Data type);

    boolean isTabulated(final Attribute attr);

    JavaClass<Tabulator<?>> toTabulatorJavaClass(final Data type);

    Optional<RosettaRule> getRule(final Attribute attr);
  }

  @org.eclipse.xtend.lib.annotations.Data
  private static class ReportTabulatorContext implements TabulatorGenerator.TabulatorContext {
    @Extension
    private final RosettaExtensions _rosettaExtensions;

    @Extension
    private final JavaTypeTranslator _javaTypeTranslator;

    private final Map<Attribute, RosettaRule> ruleMap;

    private final Optional<RosettaExternalRuleSource> ruleSource;

    @Override
    public boolean needsTabulator(final Data type) {
      return this.needsTabulator(type, CollectionLiterals.<Data>newHashSet());
    }

    private boolean needsTabulator(final Data type, final Set<Data> visited) {
      boolean _xifexpression = false;
      boolean _add = visited.add(type);
      if (_add) {
        final Function1<Attribute, Boolean> _function = (Attribute it) -> {
          return Boolean.valueOf(this.isTabulated(it, visited));
        };
        _xifexpression = IterableExtensions.<Attribute>exists(this._rosettaExtensions.getAllAttributes(type), _function);
      } else {
        _xifexpression = false;
      }
      return _xifexpression;
    }

    @Override
    public boolean isTabulated(final Attribute attr) {
      return this.isTabulated(attr, CollectionLiterals.<Data>newHashSet());
    }

    private boolean isTabulated(final Attribute attr, final Set<Data> visited) {
      boolean _xblockexpression = false;
      {
        final RosettaType attrType = attr.getTypeCall().getType();
        boolean _xifexpression = false;
        if ((attrType instanceof Data)) {
          _xifexpression = this.needsTabulator(((Data)attrType), visited);
        } else {
          _xifexpression = this.ruleMap.containsKey(attr);
        }
        _xblockexpression = _xifexpression;
      }
      return _xblockexpression;
    }

    @Override
    public JavaClass<Tabulator<?>> toTabulatorJavaClass(final Data type) {
      return this._javaTypeTranslator.toTabulatorJavaClass(type, this.ruleSource);
    }

    @Override
    public Optional<RosettaRule> getRule(final Attribute attr) {
      return Optional.<RosettaRule>ofNullable(this.ruleMap.get(attr));
    }

    public ReportTabulatorContext(final RosettaExtensions _rosettaExtensions, final JavaTypeTranslator _javaTypeTranslator, final Map<Attribute, RosettaRule> ruleMap, final Optional<RosettaExternalRuleSource> ruleSource) {
      super();
      this._rosettaExtensions = _rosettaExtensions;
      this._javaTypeTranslator = _javaTypeTranslator;
      this.ruleMap = ruleMap;
      this.ruleSource = ruleSource;
    }

    @Override
    @Pure
    public int hashCode() {
      final int prime = 31;
      int result = 1;
      result = prime * result + ((this._rosettaExtensions== null) ? 0 : this._rosettaExtensions.hashCode());
      result = prime * result + ((this._javaTypeTranslator== null) ? 0 : this._javaTypeTranslator.hashCode());
      result = prime * result + ((this.ruleMap== null) ? 0 : this.ruleMap.hashCode());
      return prime * result + ((this.ruleSource== null) ? 0 : this.ruleSource.hashCode());
    }

    @Override
    @Pure
    public boolean equals(final Object obj) {
      if (this == obj)
        return true;
      if (obj == null)
        return false;
      if (getClass() != obj.getClass())
        return false;
      TabulatorGenerator.ReportTabulatorContext other = (TabulatorGenerator.ReportTabulatorContext) obj;
      if (this._rosettaExtensions == null) {
        if (other._rosettaExtensions != null)
          return false;
      } else if (!this._rosettaExtensions.equals(other._rosettaExtensions))
        return false;
      if (this._javaTypeTranslator == null) {
        if (other._javaTypeTranslator != null)
          return false;
      } else if (!this._javaTypeTranslator.equals(other._javaTypeTranslator))
        return false;
      if (this.ruleMap == null) {
        if (other.ruleMap != null)
          return false;
      } else if (!this.ruleMap.equals(other.ruleMap))
        return false;
      if (this.ruleSource == null) {
        if (other.ruleSource != null)
          return false;
      } else if (!this.ruleSource.equals(other.ruleSource))
        return false;
      return true;
    }

    @Override
    @Pure
    public String toString() {
      ToStringBuilder b = new ToStringBuilder(this);
      b.add("_rosettaExtensions", this._rosettaExtensions);
      b.add("_javaTypeTranslator", this._javaTypeTranslator);
      b.add("ruleMap", this.ruleMap);
      b.add("ruleSource", this.ruleSource);
      return b.toString();
    }

    @Pure
    public RosettaExtensions get_rosettaExtensions() {
      return this._rosettaExtensions;
    }

    @Pure
    public JavaTypeTranslator get_javaTypeTranslator() {
      return this._javaTypeTranslator;
    }

    @Pure
    public Map<Attribute, RosettaRule> getRuleMap() {
      return this.ruleMap;
    }

    @Pure
    public Optional<RosettaExternalRuleSource> getRuleSource() {
      return this.ruleSource;
    }
  }

  @org.eclipse.xtend.lib.annotations.Data
  private static class ProjectionTabulatorContext implements TabulatorGenerator.TabulatorContext {
    @Extension
    private final JavaTypeTranslator _javaTypeTranslator;

    private final Function projection;

    @Override
    public boolean needsTabulator(final Data type) {
      return true;
    }

    @Override
    public boolean isTabulated(final Attribute attr) {
      return true;
    }

    @Override
    public JavaClass<Tabulator<?>> toTabulatorJavaClass(final Data type) {
      return this._javaTypeTranslator.toTabulatorJavaClass(type, this.projection);
    }

    @Override
    public Optional<RosettaRule> getRule(final Attribute attr) {
      return Optional.<RosettaRule>empty();
    }

    public ProjectionTabulatorContext(final JavaTypeTranslator _javaTypeTranslator, final Function projection) {
      super();
      this._javaTypeTranslator = _javaTypeTranslator;
      this.projection = projection;
    }

    @Override
    @Pure
    public int hashCode() {
      final int prime = 31;
      int result = 1;
      result = prime * result + ((this._javaTypeTranslator== null) ? 0 : this._javaTypeTranslator.hashCode());
      return prime * result + ((this.projection== null) ? 0 : this.projection.hashCode());
    }

    @Override
    @Pure
    public boolean equals(final Object obj) {
      if (this == obj)
        return true;
      if (obj == null)
        return false;
      if (getClass() != obj.getClass())
        return false;
      TabulatorGenerator.ProjectionTabulatorContext other = (TabulatorGenerator.ProjectionTabulatorContext) obj;
      if (this._javaTypeTranslator == null) {
        if (other._javaTypeTranslator != null)
          return false;
      } else if (!this._javaTypeTranslator.equals(other._javaTypeTranslator))
        return false;
      if (this.projection == null) {
        if (other.projection != null)
          return false;
      } else if (!this.projection.equals(other.projection))
        return false;
      return true;
    }

    @Override
    @Pure
    public String toString() {
      ToStringBuilder b = new ToStringBuilder(this);
      b.add("_javaTypeTranslator", this._javaTypeTranslator);
      b.add("projection", this.projection);
      return b.toString();
    }

    @Pure
    public JavaTypeTranslator get_javaTypeTranslator() {
      return this._javaTypeTranslator;
    }

    @Pure
    public Function getProjection() {
      return this.projection;
    }
  }

  @org.eclipse.xtend.lib.annotations.Data
  private static class NestedTabulatorInstance {
    private final Data type;

    public NestedTabulatorInstance(final Data type) {
      super();
      this.type = type;
    }

    @Override
    @Pure
    public int hashCode() {
      return 31 * 1 + ((this.type== null) ? 0 : this.type.hashCode());
    }

    @Override
    @Pure
    public boolean equals(final Object obj) {
      if (this == obj)
        return true;
      if (obj == null)
        return false;
      if (getClass() != obj.getClass())
        return false;
      TabulatorGenerator.NestedTabulatorInstance other = (TabulatorGenerator.NestedTabulatorInstance) obj;
      if (this.type == null) {
        if (other.type != null)
          return false;
      } else if (!this.type.equals(other.type))
        return false;
      return true;
    }

    @Override
    @Pure
    public String toString() {
      ToStringBuilder b = new ToStringBuilder(this);
      b.add("type", this.type);
      return b.toString();
    }

    @Pure
    public Data getType() {
      return this.type;
    }
  }

  @org.eclipse.xtend.lib.annotations.Data
  private static class ComputedField {
    private final Attribute attribute;

    public ComputedField(final Attribute attribute) {
      super();
      this.attribute = attribute;
    }

    @Override
    @Pure
    public int hashCode() {
      return 31 * 1 + ((this.attribute== null) ? 0 : this.attribute.hashCode());
    }

    @Override
    @Pure
    public boolean equals(final Object obj) {
      if (this == obj)
        return true;
      if (obj == null)
        return false;
      if (getClass() != obj.getClass())
        return false;
      TabulatorGenerator.ComputedField other = (TabulatorGenerator.ComputedField) obj;
      if (this.attribute == null) {
        if (other.attribute != null)
          return false;
      } else if (!this.attribute.equals(other.attribute))
        return false;
      return true;
    }

    @Override
    @Pure
    public String toString() {
      ToStringBuilder b = new ToStringBuilder(this);
      b.add("attribute", this.attribute);
      return b.toString();
    }

    @Pure
    public Attribute getAttribute() {
      return this.attribute;
    }
  }

  @Inject
  private RosettaTypeProvider typeProvider;

  @Inject
  @Extension
  private JavaTypeTranslator typeTranslator;

  @Inject
  @Extension
  private ImportManagerExtension _importManagerExtension;

  @Inject
  @Extension
  private RosettaExtensions extensions;

  @Inject
  @Extension
  private JavaTypeUtil _javaTypeUtil;

  public void generate(final IFileSystemAccess2 fsa, final RosettaReport report) {
    final JavaClass<Tabulator<?>> tabulatorClass = this.typeTranslator.toReportTabulatorJavaClass(report);
    DottedPath _packageName = tabulatorClass.getPackageName();
    final JavaScope topScope = new JavaScope(_packageName);
    final TabulatorGenerator.ReportTabulatorContext context = this.getContext(report.getReportType(), Optional.<RosettaExternalRuleSource>ofNullable(report.getRuleSource()));
    final StringConcatenationClient classBody = this.mainTabulatorClassBody(report.getReportType(), context, topScope, tabulatorClass);
    final String content = this._importManagerExtension.buildClass(tabulatorClass.getPackageName(), classBody, topScope);
    String _withForwardSlashes = tabulatorClass.getCanonicalName().withForwardSlashes();
    String _plus = (_withForwardSlashes + ".java");
    fsa.generateFile(_plus, content);
  }

  public void generate(final IFileSystemAccess2 fsa, final Data type, final Optional<RosettaExternalRuleSource> ruleSource) {
    final TabulatorGenerator.ReportTabulatorContext context = this.getContext(type, ruleSource);
    boolean _needsTabulator = context.needsTabulator(type);
    if (_needsTabulator) {
      final JavaClass<Tabulator<?>> tabulatorClass = this.typeTranslator.toTabulatorJavaClass(type, ruleSource);
      DottedPath _packageName = tabulatorClass.getPackageName();
      final JavaScope topScope = new JavaScope(_packageName);
      final StringConcatenationClient classBody = this.tabulatorClassBody(type, context, topScope, tabulatorClass);
      final String content = this._importManagerExtension.buildClass(tabulatorClass.getPackageName(), classBody, topScope);
      String _withForwardSlashes = tabulatorClass.getCanonicalName().withForwardSlashes();
      String _plus = (_withForwardSlashes + ".java");
      fsa.generateFile(_plus, content);
    }
  }

  public void generate(final IFileSystemAccess2 fsa, final Function func) {
    boolean _isProjection = this.isProjection(func);
    if (_isProjection) {
      final JavaClass<Tabulator<?>> tabulatorClass = this.typeTranslator.toProjectionTabulatorJavaClass(func);
      DottedPath _packageName = tabulatorClass.getPackageName();
      final JavaScope topScope = new JavaScope(_packageName);
      final RType projectionType = this.typeProvider.getRTypeOfSymbol(func.getOutput());
      if ((projectionType instanceof RDataType)) {
        final TabulatorGenerator.ProjectionTabulatorContext context = new TabulatorGenerator.ProjectionTabulatorContext(this.typeTranslator, func);
        final StringConcatenationClient classBody = this.mainTabulatorClassBody(((RDataType)projectionType).getData(), context, topScope, tabulatorClass);
        final String content = this._importManagerExtension.buildClass(tabulatorClass.getPackageName(), classBody, topScope);
        String _withForwardSlashes = tabulatorClass.getCanonicalName().withForwardSlashes();
        String _plus = (_withForwardSlashes + ".java");
        fsa.generateFile(_plus, content);
        this.recursivelyGenerateProjectionTypeTabulators(fsa, ((RDataType)projectionType).getData(), context, CollectionLiterals.<Data>newHashSet());
      }
    }
  }

  private void recursivelyGenerateProjectionTypeTabulators(final IFileSystemAccess2 fsa, final Data type, final TabulatorGenerator.ProjectionTabulatorContext context, final Set<Data> visited) {
    boolean _add = visited.add(type);
    if (_add) {
      final JavaClass<Tabulator<?>> tabulatorClass = this.typeTranslator.toTabulatorJavaClass(type, context.projection);
      DottedPath _packageName = tabulatorClass.getPackageName();
      final JavaScope topScope = new JavaScope(_packageName);
      final StringConcatenationClient classBody = this.tabulatorClassBody(type, context, topScope, tabulatorClass);
      final String content = this._importManagerExtension.buildClass(tabulatorClass.getPackageName(), classBody, topScope);
      String _withForwardSlashes = tabulatorClass.getCanonicalName().withForwardSlashes();
      String _plus = (_withForwardSlashes + ".java");
      fsa.generateFile(_plus, content);
      final Function1<Attribute, RType> _function = (Attribute it) -> {
        return this.typeProvider.getRTypeOfSymbol(it);
      };
      final Consumer<RDataType> _function_1 = (RDataType it) -> {
        this.recursivelyGenerateProjectionTypeTabulators(fsa, it.getData(), context, visited);
      };
      Iterables.<RDataType>filter(ListExtensions.<Attribute, RType>map(this.extensions.allNonOverridesAttributes(type), _function), RDataType.class).forEach(_function_1);
    }
  }

  private TabulatorGenerator.ReportTabulatorContext getContext(final Data type, final Optional<RosettaExternalRuleSource> ruleSource) {
    TabulatorGenerator.ReportTabulatorContext _xblockexpression = null;
    {
      final HashMap<Attribute, RosettaRule> ruleMap = CollectionLiterals.<Attribute, RosettaRule>newHashMap();
      final BiConsumer<RosettaExtensions.PathAttribute, RosettaRule> _function = (RosettaExtensions.PathAttribute key, RosettaRule rule) -> {
        ruleMap.put(key.getAttr(), rule);
      };
      this.extensions.getAllReportingRules(type, ruleSource).forEach(_function);
      _xblockexpression = new TabulatorGenerator.ReportTabulatorContext(this.extensions, this.typeTranslator, ruleMap, ruleSource);
    }
    return _xblockexpression;
  }

  private boolean isProjection(final Function func) {
    final Function1<AnnotationRef, Boolean> _function = (AnnotationRef it) -> {
      String _name = it.getAnnotation().getName();
      return Boolean.valueOf(Objects.equal(_name, "projection"));
    };
    AnnotationRef _findFirst = IterableExtensions.<AnnotationRef>findFirst(func.getAnnotations(), _function);
    return (_findFirst != null);
  }

  private StringConcatenationClient mainTabulatorClassBody(final Data inputType, final TabulatorGenerator.TabulatorContext context, final JavaScope topScope, final JavaClass<Tabulator<?>> tabulatorClass) {
    StringConcatenationClient _xblockexpression = null;
    {
      final JavaReferenceType inputClass = this.typeTranslator.toJavaReferenceType(new RDataType(inputType));
      final JavaScope classScope = topScope.classScope(tabulatorClass.getSimpleName());
      final JavaScope tabulateScope = classScope.methodScope("tabulate");
      final GeneratedIdentifier inputParam = tabulateScope.createUniqueIdentifier("input");
      StringConcatenationClient _xifexpression = null;
      boolean _needsTabulator = context.needsTabulator(inputType);
      if (_needsTabulator) {
        StringConcatenationClient _xblockexpression_1 = null;
        {
          final JavaClass<Tabulator<?>> innerTabulatorClass = context.toTabulatorJavaClass(inputType);
          final GeneratedIdentifier innerTabulatorInstance = classScope.createUniqueIdentifier("tabulator");
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("public class ");
              _builder.append(tabulatorClass);
              _builder.append(" implements ");
              _builder.append(Tabulator.class);
              _builder.append("<");
              _builder.append(inputClass);
              _builder.append("> {");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("private final ");
              _builder.append(innerTabulatorClass, "\t");
              _builder.append(" ");
              _builder.append(innerTabulatorInstance, "\t");
              _builder.append(";");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("@");
              _builder.append(Inject.class, "\t");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("public ");
              _builder.append(tabulatorClass, "\t");
              _builder.append("(");
              _builder.append(innerTabulatorClass, "\t");
              _builder.append(" ");
              _builder.append(innerTabulatorInstance, "\t");
              _builder.append(") {");
              _builder.newLineIfNotEmpty();
              _builder.append("\t\t");
              _builder.append("this.");
              _builder.append(innerTabulatorInstance, "\t\t");
              _builder.append(" = ");
              _builder.append(innerTabulatorInstance, "\t\t");
              _builder.append(";");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("}");
              _builder.newLine();
              _builder.append("\t");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("@Override");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("public ");
              _builder.append(List.class, "\t");
              _builder.append("<");
              _builder.append(Tabulator.Field.class, "\t");
              _builder.append("> getFields() {");
              _builder.newLineIfNotEmpty();
              _builder.append("\t\t");
              _builder.append("return ");
              _builder.append(innerTabulatorInstance, "\t\t");
              _builder.append(".getFields();");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("}");
              _builder.newLine();
              _builder.append("\t");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("@Override");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("public ");
              _builder.append(List.class, "\t");
              _builder.append("<");
              _builder.append(Tabulator.FieldValue.class, "\t");
              _builder.append("> tabulate(");
              _builder.append(inputClass, "\t");
              _builder.append(" ");
              _builder.append(inputParam, "\t");
              _builder.append(") {");
              _builder.newLineIfNotEmpty();
              _builder.append("\t\t");
              _builder.append("return ");
              _builder.append(innerTabulatorInstance, "\t\t");
              _builder.append(".tabulate(");
              _builder.append(inputParam, "\t\t");
              _builder.append(");");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("}");
              _builder.newLine();
              _builder.append("}");
              _builder.newLine();
            }
          };
          _xblockexpression_1 = _client;
        }
        _xifexpression = _xblockexpression_1;
      } else {
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("public class ");
            _builder.append(tabulatorClass);
            _builder.append(" implements ");
            _builder.append(Tabulator.class);
            _builder.append("<");
            _builder.append(inputClass);
            _builder.append("> {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("@Override");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("public ");
            _builder.append(List.class, "\t");
            _builder.append("<");
            _builder.append(Tabulator.Field.class, "\t");
            _builder.append("> getFields() {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("return ");
            _builder.append(Arrays.class, "\t\t");
            _builder.append(".asList();");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("@Override");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("public ");
            _builder.append(List.class, "\t");
            _builder.append("<");
            _builder.append(Tabulator.FieldValue.class, "\t");
            _builder.append("> tabulate(");
            _builder.append(inputClass, "\t");
            _builder.append(" ");
            _builder.append(inputParam, "\t");
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("return ");
            _builder.append(Arrays.class, "\t\t");
            _builder.append(".asList();");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
          }
        };
        _xifexpression = _client;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }

  private StringConcatenationClient tabulatorClassBody(final Data inputType, final TabulatorGenerator.TabulatorContext context, final JavaScope topScope, final JavaClass<Tabulator<?>> tabulatorClass) {
    StringConcatenationClient _xblockexpression = null;
    {
      final JavaReferenceType inputClass = this.typeTranslator.toJavaReferenceType(new RDataType(inputType));
      final JavaScope classScope = topScope.classScope(tabulatorClass.getSimpleName());
      final List<Attribute> tabulatedFields = this.findTabulatedFieldsAndCreateIdentifiers(inputType, context, classScope);
      final Set<TabulatorGenerator.NestedTabulatorInstance> nestedTabulatorInstances = this.findNestedTabulatorsAndCreateIdentifiers(inputType, context, classScope);
      final JavaScope tabulateScope = classScope.methodScope("tabulate");
      final GeneratedIdentifier inputParam = tabulateScope.createUniqueIdentifier("input");
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          _builder.append("public class ");
          _builder.append(tabulatorClass);
          _builder.append(" implements ");
          _builder.append(Tabulator.class);
          _builder.append("<");
          _builder.append(inputClass);
          _builder.append("> {");
          _builder.newLineIfNotEmpty();
          {
            List<Attribute> _allNonOverridesAttributes = TabulatorGenerator.this.extensions.allNonOverridesAttributes(inputType);
            for(final Attribute attr : _allNonOverridesAttributes) {
              {
                boolean _isTabulated = context.isTabulated(attr);
                if (_isTabulated) {
                  _builder.append("\t");
                  final GeneratedIdentifier fieldId = classScope.getIdentifierOrThrow(attr);
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  _builder.append("private final ");
                  _builder.append(Tabulator.Field.class, "\t");
                  _builder.append(" ");
                  _builder.append(fieldId, "\t");
                  _builder.append(";");
                  _builder.newLineIfNotEmpty();
                }
              }
            }
          }
          {
            boolean _isEmpty = nestedTabulatorInstances.isEmpty();
            boolean _not = (!_isEmpty);
            if (_not) {
              _builder.append("\t");
              _builder.newLine();
              {
                for(final TabulatorGenerator.NestedTabulatorInstance tabInst : nestedTabulatorInstances) {
                  _builder.append("\t");
                  _builder.append("private final ");
                  JavaClass<Tabulator<?>> _tabulatorJavaClass = context.toTabulatorJavaClass(tabInst.type);
                  _builder.append(_tabulatorJavaClass, "\t");
                  _builder.append(" ");
                  GeneratedIdentifier _identifierOrThrow = classScope.getIdentifierOrThrow(tabInst);
                  _builder.append(_identifierOrThrow, "\t");
                  _builder.append(";");
                  _builder.newLineIfNotEmpty();
                }
              }
            }
          }
          _builder.append("\t");
          _builder.newLine();
          _builder.append("\t");
          {
            boolean _isEmpty_1 = nestedTabulatorInstances.isEmpty();
            boolean _not_1 = (!_isEmpty_1);
            if (_not_1) {
              _builder.append("@");
              _builder.append(Inject.class, "\t");
            }
          }
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("public ");
          _builder.append(tabulatorClass, "\t");
          _builder.append("(");
          {
            boolean _hasElements = false;
            for(final TabulatorGenerator.NestedTabulatorInstance tabInst_1 : nestedTabulatorInstances) {
              if (!_hasElements) {
                _hasElements = true;
              } else {
                _builder.appendImmediate(", ", "\t");
              }
              JavaClass<Tabulator<?>> _tabulatorJavaClass_1 = context.toTabulatorJavaClass(tabInst_1.type);
              _builder.append(_tabulatorJavaClass_1, "\t");
              _builder.append(" ");
              GeneratedIdentifier _identifierOrThrow_1 = classScope.getIdentifierOrThrow(tabInst_1);
              _builder.append(_identifierOrThrow_1, "\t");
            }
          }
          _builder.append(") {");
          _builder.newLineIfNotEmpty();
          {
            for(final TabulatorGenerator.NestedTabulatorInstance tabInst_2 : nestedTabulatorInstances) {
              _builder.append("\t\t");
              _builder.append("this.");
              GeneratedIdentifier _identifierOrThrow_2 = classScope.getIdentifierOrThrow(tabInst_2);
              _builder.append(_identifierOrThrow_2, "\t\t");
              _builder.append(" = ");
              GeneratedIdentifier _identifierOrThrow_3 = classScope.getIdentifierOrThrow(tabInst_2);
              _builder.append(_identifierOrThrow_3, "\t\t");
              _builder.append(";");
              _builder.newLineIfNotEmpty();
            }
          }
          _builder.append("\t\t");
          StringConcatenationClient _initializeFields = TabulatorGenerator.this.initializeFields(inputType, context, classScope);
          _builder.append(_initializeFields, "\t\t");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.append("\t");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("@Override");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("public ");
          _builder.append(List.class, "\t");
          _builder.append("<");
          _builder.append(Tabulator.Field.class, "\t");
          _builder.append("> getFields() {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          _builder.append("return ");
          _builder.append(Arrays.class, "\t\t");
          _builder.append(".asList(");
          {
            boolean _hasElements_1 = false;
            for(final Attribute field : tabulatedFields) {
              if (!_hasElements_1) {
                _hasElements_1 = true;
              } else {
                _builder.appendImmediate(", ", "\t\t");
              }
              GeneratedIdentifier _identifierOrThrow_4 = classScope.getIdentifierOrThrow(field);
              _builder.append(_identifierOrThrow_4, "\t\t");
            }
          }
          _builder.append(");");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.append("\t");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("@Override");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("public ");
          _builder.append(List.class, "\t");
          _builder.append("<");
          _builder.append(Tabulator.FieldValue.class, "\t");
          _builder.append("> tabulate(");
          _builder.append(inputClass, "\t");
          _builder.append(" ");
          _builder.append(inputParam, "\t");
          _builder.append(") {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          StringConcatenationClient _computeFieldValues = TabulatorGenerator.this.computeFieldValues(inputType, inputParam, context, tabulateScope);
          _builder.append(_computeFieldValues, "\t\t");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          _builder.append("return ");
          StringConcatenationClient _fieldValuesAsList = TabulatorGenerator.this.fieldValuesAsList(inputType, context, tabulateScope);
          _builder.append(_fieldValuesAsList, "\t\t");
          _builder.append(";");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.append("}");
          _builder.newLine();
        }
      };
      _xblockexpression = _client;
    }
    return _xblockexpression;
  }

  private List<Attribute> findTabulatedFieldsAndCreateIdentifiers(final Data type, final TabulatorGenerator.TabulatorContext context, final JavaScope scope) {
    final Function1<Attribute, Boolean> _function = (Attribute it) -> {
      return Boolean.valueOf(context.isTabulated(it));
    };
    final Function1<Attribute, Attribute> _function_1 = (Attribute it) -> {
      Attribute _xblockexpression = null;
      {
        String _name = it.getName();
        String _plus = (_name + "Field");
        scope.createIdentifier(it, _plus);
        _xblockexpression = it;
      }
      return _xblockexpression;
    };
    return IterableExtensions.<Attribute>toList(IterableExtensions.<Attribute, Attribute>map(IterableExtensions.<Attribute>filter(this.extensions.allNonOverridesAttributes(type), _function), _function_1));
  }

  private StringConcatenationClient initializeFields(final Data type, final TabulatorGenerator.TabulatorContext context, final JavaScope scope) {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        {
          List<Attribute> _allNonOverridesAttributes = TabulatorGenerator.this.extensions.allNonOverridesAttributes(type);
          for(final Attribute attr : _allNonOverridesAttributes) {
            {
              boolean _isTabulated = context.isTabulated(attr);
              if (_isTabulated) {
                final GeneratedIdentifier fieldId = scope.getIdentifierOrThrow(attr);
                _builder.newLineIfNotEmpty();
                final Optional<RosettaRule> rule = context.getRule(attr);
                _builder.newLineIfNotEmpty();
                final RosettaType attrType = attr.getTypeCall().getType();
                _builder.newLineIfNotEmpty();
                _builder.append("this.");
                _builder.append(fieldId);
                _builder.append(" = new ");
                _builder.append(Tabulator.FieldImpl.class);
                _builder.append("(");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\"");
                String _escapeJava = StringEscapeUtils.escapeJava(attr.getName());
                _builder.append(_escapeJava, "\t");
                _builder.append("\",");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                boolean _isIsMany = attr.getCard().isIsMany();
                _builder.append(_isIsMany, "\t");
                _builder.append(",");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                final java.util.function.Function<RosettaRule, RosettaModel> _function = (RosettaRule it) -> {
                  return it.getModel();
                };
                final java.util.function.Function<RosettaModel, String> _function_1 = (RosettaModel it) -> {
                  return it.getName();
                };
                final java.util.function.Function<String, StringConcatenationClient> _function_2 = (String it) -> {
                  DottedPath _splitOnDots = DottedPath.splitOnDots(it);
                  String _name = rule.get().getName();
                  return TabulatorGenerator.this.toModelSymbolCode(new ModelSymbolId(_splitOnDots, _name));
                };
                StringConcatenationClient _optionalCode = TabulatorGenerator.this.toOptionalCode(rule.<RosettaModel>map(_function).<String>map(_function_1).<StringConcatenationClient>map(_function_2));
                _builder.append(_optionalCode, "\t");
                _builder.append(",");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                final java.util.function.Function<RosettaRule, String> _function_3 = (RosettaRule it) -> {
                  return it.getIdentifier();
                };
                final java.util.function.Function<String, String> _function_4 = (String it) -> {
                  return (("\"" + it) + "\"");
                };
                StringConcatenationClient _optionalCode_1 = TabulatorGenerator.this.toOptionalCode(rule.<String>map(_function_3).<String>map(_function_4));
                _builder.append(_optionalCode_1, "\t");
                _builder.append(",");
                _builder.newLineIfNotEmpty();
                {
                  if ((attrType instanceof Data)) {
                    _builder.append("\t");
                    GeneratedIdentifier _identifierOrThrow = scope.getIdentifierOrThrow(TabulatorGenerator.this.toNestedTabulatorInstance(((Data)attrType)));
                    _builder.append(_identifierOrThrow, "\t");
                    _builder.append(".getFields()");
                    _builder.newLineIfNotEmpty();
                  } else {
                    _builder.append("\t");
                    _builder.append(Arrays.class, "\t");
                    _builder.append(".asList()");
                    _builder.newLineIfNotEmpty();
                  }
                }
                _builder.append(");");
                _builder.newLine();
              }
            }
          }
        }
      }
    };
    return _client;
  }

  private Set<TabulatorGenerator.NestedTabulatorInstance> findNestedTabulatorsAndCreateIdentifiers(final Data type, final TabulatorGenerator.TabulatorContext context, final JavaScope scope) {
    Set<TabulatorGenerator.NestedTabulatorInstance> _xblockexpression = null;
    {
      final Function1<Attribute, Boolean> _function = (Attribute it) -> {
        return Boolean.valueOf(context.isTabulated(it));
      };
      final Function1<Attribute, RosettaType> _function_1 = (Attribute it) -> {
        return it.getTypeCall().getType();
      };
      final Function1<Data, TabulatorGenerator.NestedTabulatorInstance> _function_2 = (Data it) -> {
        return this.toNestedTabulatorInstance(it);
      };
      final Set<TabulatorGenerator.NestedTabulatorInstance> result = IterableExtensions.<TabulatorGenerator.NestedTabulatorInstance>toSet(IterableExtensions.<Data, TabulatorGenerator.NestedTabulatorInstance>map(Iterables.<Data>filter(IterableExtensions.<Attribute, RosettaType>map(IterableExtensions.<Attribute>filter(this.extensions.allNonOverridesAttributes(type), _function), _function_1), Data.class), _function_2));
      final Consumer<TabulatorGenerator.NestedTabulatorInstance> _function_3 = (TabulatorGenerator.NestedTabulatorInstance it) -> {
        scope.createIdentifier(it, StringExtensions.toFirstLower(context.toTabulatorJavaClass(it.type).getSimpleName()));
      };
      result.forEach(_function_3);
      _xblockexpression = result;
    }
    return _xblockexpression;
  }

  private StringConcatenationClient computeFieldValues(final Data type, final GeneratedIdentifier inputParam, final TabulatorGenerator.TabulatorContext context, final JavaScope scope) {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        {
          List<Attribute> _allNonOverridesAttributes = TabulatorGenerator.this.extensions.allNonOverridesAttributes(type);
          for(final Attribute attr : _allNonOverridesAttributes) {
            {
              boolean _isTabulated = context.isTabulated(attr);
              if (_isTabulated) {
                StringConcatenationClient _fieldValue = TabulatorGenerator.this.fieldValue(attr, inputParam, scope);
                _builder.append(_fieldValue);
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
      }
    };
    return _client;
  }

  private StringConcatenationClient fieldValue(final Attribute attr, final GeneratedIdentifier inputParam, final JavaScope scope) {
    StringConcatenationClient _xblockexpression = null;
    {
      final RType rType = this.typeProvider.getRTypeOfSymbol(attr);
      final GeneratedIdentifier resultId = scope.createIdentifier(this.toComputedField(attr), attr.getName());
      final JavaScope lambdaScope = scope.lambdaScope();
      final GeneratedIdentifier lambdaParam = lambdaScope.createUniqueIdentifier("x");
      final JavaScope nestedLambdaScope = lambdaScope.lambdaScope();
      final GeneratedIdentifier nestedLambdaParam = nestedLambdaScope.createUniqueIdentifier("x");
      StringConcatenationClient _xifexpression = null;
      if ((rType instanceof RDataType)) {
        StringConcatenationClient _xblockexpression_1 = null;
        {
          JavaParameterizedType<List<?>> _xifexpression_1 = null;
          boolean _isIsMany = attr.getCard().isIsMany();
          if (_isIsMany) {
            _xifexpression_1 = this._javaTypeUtil.<List<?>>wrap(this._javaTypeUtil.LIST, this._javaTypeUtil.<List<?>>wrap(this._javaTypeUtil.LIST, JavaClass.<Tabulator.FieldValue>from(Tabulator.FieldValue.class)));
          } else {
            _xifexpression_1 = this._javaTypeUtil.<List<?>>wrap(this._javaTypeUtil.LIST, JavaClass.<Tabulator.FieldValue>from(Tabulator.FieldValue.class));
          }
          final JavaParameterizedType<List<?>> resultType = _xifexpression_1;
          this.typeTranslator.toPolymorphicListOrSingleJavaType(rType, attr.getCard().isIsMany());
          final Data attrType = ((RDataType)rType).getData();
          final GeneratedIdentifier nestedTabulator = scope.getIdentifierOrThrow(this.toNestedTabulatorInstance(attrType));
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append(Optional.class);
              _builder.append("<");
              _builder.append(resultType);
              _builder.append("> ");
              _builder.append(resultId);
              _builder.append(" = ");
              _builder.append(Optional.class);
              _builder.append(".ofNullable(");
              _builder.append(inputParam);
              _builder.append(".get");
              String _firstUpper = StringExtensions.toFirstUpper(attr.getName());
              _builder.append(_firstUpper);
              _builder.append("())");
              _builder.newLineIfNotEmpty();
              {
                boolean _isIsMany = attr.getCard().isIsMany();
                if (_isIsMany) {
                  _builder.append("\t");
                  _builder.append(".map(");
                  _builder.append(lambdaParam, "\t");
                  _builder.append(" -> ");
                  _builder.append(lambdaParam, "\t");
                  _builder.append(".stream()");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  _builder.append("\t");
                  _builder.append(".map(");
                  _builder.append(nestedLambdaParam, "\t\t");
                  _builder.append(" -> ");
                  _builder.append(nestedTabulator, "\t\t");
                  _builder.append(".tabulate(");
                  _builder.append(nestedLambdaParam, "\t\t");
                  {
                    boolean _isEmpty = IterableExtensions.isEmpty(TabulatorGenerator.this.extensions.metaAnnotations(attr));
                    boolean _not = (!_isEmpty);
                    if (_not) {
                      _builder.append(".getValue()");
                    }
                  }
                  _builder.append("))");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  _builder.append("\t");
                  _builder.append(".collect(");
                  _builder.append(Collectors.class, "\t\t");
                  _builder.append(".toList()));");
                  _builder.newLineIfNotEmpty();
                } else {
                  _builder.append("\t");
                  _builder.append(".map(");
                  _builder.append(lambdaParam, "\t");
                  _builder.append(" -> ");
                  _builder.append(nestedTabulator, "\t");
                  _builder.append(".tabulate(");
                  _builder.append(lambdaParam, "\t");
                  {
                    boolean _isEmpty_1 = IterableExtensions.isEmpty(TabulatorGenerator.this.extensions.metaAnnotations(attr));
                    boolean _not_1 = (!_isEmpty_1);
                    if (_not_1) {
                      _builder.append(".getValue()");
                    }
                  }
                  _builder.append("));");
                  _builder.newLineIfNotEmpty();
                }
              }
            }
          };
          _xblockexpression_1 = _client;
        }
        _xifexpression = _xblockexpression_1;
      } else {
        StringConcatenationClient _xblockexpression_2 = null;
        {
          final JavaReferenceType resultType = this.typeTranslator.toPolymorphicListOrSingleJavaType(rType, attr.getCard().isIsMany());
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              {
                boolean _isEmpty = IterableExtensions.isEmpty(TabulatorGenerator.this.extensions.metaAnnotations(attr));
                if (_isEmpty) {
                  _builder.append(Optional.class);
                  _builder.append("<");
                  _builder.append(resultType);
                  _builder.append("> ");
                  _builder.append(resultId);
                  _builder.append(" = ");
                  _builder.append(Optional.class);
                  _builder.append(".ofNullable(");
                  _builder.append(inputParam);
                  _builder.append(".get");
                  String _firstUpper = StringExtensions.toFirstUpper(attr.getName());
                  _builder.append(_firstUpper);
                  _builder.append("());");
                  _builder.newLineIfNotEmpty();
                } else {
                  boolean _isIsMany = attr.getCard().isIsMany();
                  if (_isIsMany) {
                    _builder.append(Optional.class);
                    _builder.append("<");
                    _builder.append(resultType);
                    _builder.append("> ");
                    _builder.append(resultId);
                    _builder.append(" = ");
                    _builder.append(Optional.class);
                    _builder.append(".ofNullable(");
                    _builder.append(inputParam);
                    _builder.append(".get");
                    String _firstUpper_1 = StringExtensions.toFirstUpper(attr.getName());
                    _builder.append(_firstUpper_1);
                    _builder.append("())");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append(".map(");
                    _builder.append(lambdaParam, "\t");
                    _builder.append(" -> ");
                    _builder.append(lambdaParam, "\t");
                    _builder.append(".stream()");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append(".map(");
                    _builder.append(nestedLambdaParam, "\t\t");
                    _builder.append(" -> ");
                    _builder.append(nestedLambdaParam, "\t\t");
                    _builder.append(".getValue())");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append(".collect(");
                    _builder.append(Collectors.class, "\t\t");
                    _builder.append(".toList()));");
                    _builder.newLineIfNotEmpty();
                  } else {
                    _builder.append(Optional.class);
                    _builder.append("<");
                    _builder.append(resultType);
                    _builder.append("> ");
                    _builder.append(resultId);
                    _builder.append(" = ");
                    _builder.append(Optional.class);
                    _builder.append(".ofNullable(");
                    _builder.append(inputParam);
                    _builder.append(".get");
                    String _firstUpper_2 = StringExtensions.toFirstUpper(attr.getName());
                    _builder.append(_firstUpper_2);
                    _builder.append("())");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append(".map(");
                    _builder.append(lambdaParam, "\t");
                    _builder.append(" -> ");
                    _builder.append(lambdaParam, "\t");
                    _builder.append(".getValue());");
                    _builder.newLineIfNotEmpty();
                  }
                }
              }
            }
          };
          _xblockexpression_2 = _client;
        }
        _xifexpression = _xblockexpression_2;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }

  private StringConcatenationClient fieldValuesAsList(final Data type, final TabulatorGenerator.TabulatorContext context, final JavaScope scope) {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        _builder.append(Arrays.class);
        _builder.append(".asList(");
        _builder.newLineIfNotEmpty();
        {
          final Function1<Attribute, Boolean> _function = (Attribute it) -> {
            return Boolean.valueOf(context.isTabulated(it));
          };
          Iterable<Attribute> _filter = IterableExtensions.<Attribute>filter(TabulatorGenerator.this.extensions.allNonOverridesAttributes(type), _function);
          boolean _hasElements = false;
          for(final Attribute attr : _filter) {
            if (!_hasElements) {
              _hasElements = true;
            } else {
              _builder.appendImmediate(",", "\t");
            }
            _builder.append("\t");
            final RosettaType attrType = attr.getTypeCall().getType();
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            Class<? extends Tabulator.FieldValue> _xifexpression = null;
            if ((attrType instanceof Data)) {
              Class<? extends Tabulator.FieldValue> _xifexpression_1 = null;
              boolean _isIsMany = attr.getCard().isIsMany();
              if (_isIsMany) {
                _xifexpression_1 = Tabulator.MultiNestedFieldValueImpl.class;
              } else {
                _xifexpression_1 = Tabulator.NestedFieldValueImpl.class;
              }
              _xifexpression = _xifexpression_1;
            } else {
              _xifexpression = Tabulator.FieldValueImpl.class;
            }
            final Class<? extends Tabulator.FieldValue> valueClass = _xifexpression;
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("new ");
            _builder.append(valueClass, "\t");
            _builder.append("(");
            GeneratedIdentifier _identifierOrThrow = scope.getIdentifierOrThrow(attr);
            _builder.append(_identifierOrThrow, "\t");
            _builder.append(", ");
            GeneratedIdentifier _identifierOrThrow_1 = scope.getIdentifierOrThrow(TabulatorGenerator.this.toComputedField(attr));
            _builder.append(_identifierOrThrow_1, "\t");
            _builder.append(")");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append(")");
      }
    };
    return _client;
  }

  private StringConcatenationClient toOptionalCode(final Optional<?> object) {
    StringConcatenationClient _xifexpression = null;
    boolean _isPresent = object.isPresent();
    if (_isPresent) {
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          _builder.append(Optional.class);
          _builder.append(".of(");
          Object _get = object.get();
          _builder.append(_get);
          _builder.append(")");
        }
      };
      _xifexpression = _client;
    } else {
      StringConcatenationClient _client_1 = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          _builder.append(Optional.class);
          _builder.append(".empty()");
        }
      };
      _xifexpression = _client_1;
    }
    return _xifexpression;
  }

  private StringConcatenationClient toDottedPathCode(final DottedPath path) {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        _builder.append(DottedPath.class);
        _builder.append(".of(\"");
        String _withSeparator = path.withSeparator("\", \"");
        _builder.append(_withSeparator);
        _builder.append("\")");
      }
    };
    return _client;
  }

  private StringConcatenationClient toModelSymbolCode(final ModelSymbolId symbolId) {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        _builder.append("new ");
        _builder.append(ModelSymbolId.class);
        _builder.append("(");
        StringConcatenationClient _dottedPathCode = TabulatorGenerator.this.toDottedPathCode(symbolId.getNamespace());
        _builder.append(_dottedPathCode);
        _builder.append(", \"");
        String _name = symbolId.getName();
        _builder.append(_name);
        _builder.append("\")");
      }
    };
    return _client;
  }

  private TabulatorGenerator.NestedTabulatorInstance toNestedTabulatorInstance(final Data type) {
    return new TabulatorGenerator.NestedTabulatorInstance(type);
  }

  private TabulatorGenerator.ComputedField toComputedField(final Attribute attr) {
    return new TabulatorGenerator.ComputedField(attr);
  }
}
