package com.regnosys.rosetta.generator.java.util;

import com.google.common.base.Objects;
import com.regnosys.rosetta.generator.java.JavaScope;
import com.rosetta.util.DottedPath;
import com.rosetta.util.types.JavaClass;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class ImportManagerExtension {
  public Method method(final Class<?> clazz, final String methodName) {
    final Function1<Method, Boolean> _function = (Method it) -> {
      String _name = it.getName();
      return Boolean.valueOf(Objects.equal(_name, methodName));
    };
    return IterableExtensions.<Method>findFirst(((Iterable<Method>)Conversions.doWrapArray(clazz.getMethods())), _function);
  }

  public PreferWildcardImportClass importWildcard(final Class<?> clazz) {
    return this.importWildcard(JavaClass.from(clazz));
  }

  public PreferWildcardImportClass importWildcard(final JavaClass<?> t) {
    return new PreferWildcardImportClass(t);
  }

  public PreferWildcardImportMethod importWildcard(final Method method) {
    return new PreferWildcardImportMethod(method);
  }

  /**
   * Given the body of a Java class represented as a StringConcatenationClient,
   * generate a full Java class file by adding imports and resolving identifiers.
   */
  public String buildClass(final DottedPath packageName, final StringConcatenationClient classCode, final JavaScope topScope) {
    String _xblockexpression = null;
    {
      boolean _isClosed = topScope.isClosed();
      if (_isClosed) {
        throw new IllegalStateException("The top scope may not be closed, as imports will be added to it.");
      }
      final ImportingStringConcatenation isc = new ImportingStringConcatenation(topScope);
      final StringConcatenationClient resolvedCode = isc.preprocess(classCode);
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          _builder.append("package ");
          _builder.append(packageName);
          _builder.append(";");
          _builder.newLineIfNotEmpty();
          _builder.newLine();
          {
            List<DottedPath> _imports = isc.getImports();
            for(final DottedPath imp : _imports) {
              _builder.append("import ");
              _builder.append(imp);
              _builder.append(";");
              _builder.newLineIfNotEmpty();
            }
          }
          _builder.newLine();
          {
            List<DottedPath> _staticImports = isc.getStaticImports();
            for(final DottedPath imp_1 : _staticImports) {
              _builder.append("import static ");
              _builder.append(imp_1);
              _builder.append(";");
              _builder.newLineIfNotEmpty();
            }
          }
          _builder.newLine();
          _builder.append(resolvedCode);
          _builder.newLineIfNotEmpty();
        }
      };
      final StringConcatenationClient fullClass = _client;
      isc.append(fullClass);
      _xblockexpression = isc.toString();
    }
    return _xblockexpression;
  }
}
