package com.regnosys.rosetta.generator.java.util;

import com.google.common.html.HtmlEscapers;
import com.regnosys.rosetta.rosetta.RosettaCorpus;
import com.regnosys.rosetta.rosetta.RosettaDefinable;
import com.regnosys.rosetta.rosetta.RosettaDocReference;
import com.regnosys.rosetta.rosetta.RosettaNamed;
import com.regnosys.rosetta.rosetta.RosettaSegmentRef;
import com.regnosys.rosetta.rosetta.simple.References;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

@SuppressWarnings("all")
public class ModelGeneratorUtil {
  public static CharSequence javadoc(final RosettaNamed named) {
    StringConcatenation _builder = new StringConcatenation();
    String _javadoc = ModelGeneratorUtil.javadoc(named, null);
    _builder.append(_javadoc);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public static String javadoc(final RosettaNamed named, final String version) {
    String _xblockexpression = null;
    {
      String _xifexpression = null;
      if ((named instanceof RosettaDefinable)) {
        _xifexpression = ((RosettaDefinable)named).getDefinition();
      } else {
        _xifexpression = "";
      }
      final String definition = _xifexpression;
      List<RosettaDocReference> _xifexpression_1 = null;
      if ((named instanceof References)) {
        _xifexpression_1 = ((References)named).getReferences();
      } else {
        _xifexpression_1 = CollectionLiterals.<RosettaDocReference>emptyList();
      }
      final List<RosettaDocReference> docRef = _xifexpression_1;
      _xblockexpression = ModelGeneratorUtil.javadoc(definition, docRef, version);
    }
    return _xblockexpression;
  }

  public static String javadoc(final String definition, final List<RosettaDocReference> docRef, final String version) {
    String _xifexpression = null;
    if ((((definition == null) && docRef.isEmpty()) && (version == null))) {
      _xifexpression = "";
    } else {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("/**");
      _builder.newLine();
      CharSequence _javadocDefinition = ModelGeneratorUtil.javadocDefinition(definition);
      _builder.append(_javadocDefinition);
      _builder.newLineIfNotEmpty();
      CharSequence _javadocVersion = ModelGeneratorUtil.javadocVersion(version);
      _builder.append(_javadocVersion);
      _builder.newLineIfNotEmpty();
      CharSequence _javadocDocRef = ModelGeneratorUtil.javadocDocRef(docRef);
      _builder.append(_javadocDocRef);
      _builder.newLineIfNotEmpty();
      _builder.append(" ");
      _builder.append("*/");
      _builder.newLine();
      _xifexpression = _builder.toString();
    }
    return _xifexpression;
  }

  public static CharSequence emptyJavadocWithVersion(final String version) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* @version ");
    _builder.append(version, " ");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    return _builder;
  }

  public static CharSequence escape(final String definition) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if (((definition != null) && (!definition.isEmpty()))) {
        String _escape = HtmlEscapers.htmlEscaper().escape(definition);
        _builder.append(_escape);
      }
    }
    return _builder;
  }

  private static CharSequence javadocDefinition(final String definition) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if (((definition != null) && (!definition.isEmpty()))) {
        _builder.append(" * ");
        String _escape = HtmlEscapers.htmlEscaper().escape(definition);
        _builder.append(_escape);
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  private static CharSequence javadocVersion(final String version) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if (((version != null) && (!version.isEmpty()))) {
        _builder.append(" * @version ");
        _builder.append(version);
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  private static CharSequence javadocDocRef(final List<RosettaDocReference> references) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if (((references != null) && (!references.isEmpty()))) {
        {
          for(final RosettaDocReference reference : references) {
            _builder.append(" ");
            _builder.append("*");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* Body ");
            String _name = reference.getDocReference().getBody().getName();
            _builder.append(_name, " ");
            _builder.newLineIfNotEmpty();
            {
              EList<RosettaCorpus> _corpusList = reference.getDocReference().getCorpusList();
              for(final RosettaCorpus mandate : _corpusList) {
                _builder.append(" * Corpus ");
                String _corpusType = mandate.getCorpusType();
                _builder.append(_corpusType);
                _builder.append(" ");
                String _name_1 = mandate.getName();
                _builder.append(_name_1);
                _builder.append(" ");
                {
                  String _displayName = mandate.getDisplayName();
                  boolean _tripleNotEquals = (_displayName != null);
                  if (_tripleNotEquals) {
                    String _escape = HtmlEscapers.htmlEscaper().escape(mandate.getDisplayName());
                    _builder.append(_escape);
                  }
                }
                _builder.append(" ");
                {
                  String _definition = mandate.getDefinition();
                  boolean _tripleNotEquals_1 = (_definition != null);
                  if (_tripleNotEquals_1) {
                    _builder.append("\"");
                    String _escape_1 = HtmlEscapers.htmlEscaper().escape(mandate.getDefinition());
                    _builder.append(_escape_1);
                    _builder.append("\"");
                  }
                }
                _builder.append(" ");
              }
            }
            _builder.newLineIfNotEmpty();
            {
              EList<RosettaSegmentRef> _segments = reference.getDocReference().getSegments();
              for(final RosettaSegmentRef segment : _segments) {
                _builder.append(" * ");
                String _name_2 = segment.getSegment().getName();
                _builder.append(_name_2);
                _builder.append(" \"");
                String _escape_2 = HtmlEscapers.htmlEscaper().escape(segment.getSegmentRef());
                _builder.append(_escape_2);
                _builder.append("\"");
              }
            }
            _builder.newLineIfNotEmpty();
            _builder.append(" ");
            _builder.append("*");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* Provision ");
            String _provision = reference.getProvision();
            _builder.append(_provision, " ");
            _builder.newLineIfNotEmpty();
            _builder.append(" ");
            _builder.append("*");
            _builder.newLine();
          }
        }
      }
    }
    return _builder;
  }
}
