package com.regnosys.rosetta.generator.java.util;

import com.regnosys.rosetta.generator.GeneratedIdentifier;
import com.regnosys.rosetta.generator.java.JavaScope;
import com.regnosys.rosetta.generator.java.statement.builder.JavaConditionalExpression;
import com.regnosys.rosetta.generator.java.statement.builder.JavaExpression;
import com.regnosys.rosetta.generator.java.statement.builder.JavaStatementBuilder;
import com.regnosys.rosetta.generator.java.types.JavaTypeUtil;
import com.regnosys.rosetta.rosetta.RosettaRecordFeature;
import com.regnosys.rosetta.types.builtin.RDateTimeType;
import com.regnosys.rosetta.types.builtin.RDateType;
import com.regnosys.rosetta.types.builtin.RRecordType;
import com.regnosys.rosetta.types.builtin.RZonedDateTimeType;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.types.JavaPrimitiveType;
import com.rosetta.util.types.JavaType;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.inject.Inject;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@SuppressWarnings("all")
public class RecordJavaUtil {
  @Inject
  private JavaTypeUtil typeUtil;

  protected StringConcatenationClient _recordFeatureToLambda(final RDateType recordType, final RosettaRecordFeature feature, final JavaScope scope) {
    StringConcatenationClient _switchResult = null;
    String _name = feature.getName();
    if (_name != null) {
      switch (_name) {
        case "day":
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append(Date.class);
              _builder.append("::getDay");
            }
          };
          _switchResult = _client;
          break;
        case "month":
          StringConcatenationClient _client_1 = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append(Date.class);
              _builder.append("::getMonth");
            }
          };
          _switchResult = _client_1;
          break;
        case "year":
          StringConcatenationClient _client_2 = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append(Date.class);
              _builder.append("::getYear");
            }
          };
          _switchResult = _client_2;
          break;
        default:
          String _name_1 = feature.getName();
          String _plus = ("Unsupported record feature named " + _name_1);
          throw new UnsupportedOperationException(_plus);
      }
    } else {
      String _name_1 = feature.getName();
      String _plus = ("Unsupported record feature named " + _name_1);
      throw new UnsupportedOperationException(_plus);
    }
    return _switchResult;
  }

  protected StringConcatenationClient _recordFeatureToLambda(final RDateTimeType recordType, final RosettaRecordFeature feature, final JavaScope scope) {
    StringConcatenationClient _switchResult = null;
    String _name = feature.getName();
    if (_name != null) {
      switch (_name) {
        case "date":
          StringConcatenationClient _xblockexpression = null;
          {
            final JavaScope lambdaScope = scope.lambdaScope();
            final GeneratedIdentifier dt = lambdaScope.createUniqueIdentifier("dt");
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append(dt);
                _builder.append(" -> ");
                _builder.append(Date.class);
                _builder.append(".of(");
                _builder.append(dt);
                _builder.append(".toLocalDate())");
              }
            };
            _xblockexpression = _client;
          }
          _switchResult = _xblockexpression;
          break;
        case "time":
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append(LocalDateTime.class);
              _builder.append("::toLocalTime");
            }
          };
          _switchResult = _client;
          break;
        default:
          String _name_1 = feature.getName();
          String _plus = ("Unsupported record feature named " + _name_1);
          throw new UnsupportedOperationException(_plus);
      }
    } else {
      String _name_1 = feature.getName();
      String _plus = ("Unsupported record feature named " + _name_1);
      throw new UnsupportedOperationException(_plus);
    }
    return _switchResult;
  }

  protected StringConcatenationClient _recordFeatureToLambda(final RZonedDateTimeType recordType, final RosettaRecordFeature feature, final JavaScope scope) {
    StringConcatenationClient _switchResult = null;
    String _name = feature.getName();
    if (_name != null) {
      switch (_name) {
        case "date":
          StringConcatenationClient _xblockexpression = null;
          {
            final JavaScope lambdaScope = scope.lambdaScope();
            final GeneratedIdentifier zdt = lambdaScope.createUniqueIdentifier("zdt");
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append(zdt);
                _builder.append(" -> ");
                _builder.append(Date.class);
                _builder.append(".of(");
                _builder.append(zdt);
                _builder.append(".toLocalDate())");
              }
            };
            _xblockexpression = _client;
          }
          _switchResult = _xblockexpression;
          break;
        case "time":
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append(ZonedDateTime.class);
              _builder.append("::toLocalTime");
            }
          };
          _switchResult = _client;
          break;
        case "timezone":
          StringConcatenationClient _xblockexpression_1 = null;
          {
            final JavaScope lambdaScope = scope.lambdaScope();
            final GeneratedIdentifier zdt = lambdaScope.createUniqueIdentifier("zdt");
            StringConcatenationClient _client_1 = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append(zdt);
                _builder.append(" -> ");
                _builder.append(zdt);
                _builder.append(".getZone().getId()");
              }
            };
            _xblockexpression_1 = _client_1;
          }
          _switchResult = _xblockexpression_1;
          break;
        default:
          String _name_1 = feature.getName();
          String _plus = ("Unsupported record feature named " + _name_1);
          throw new UnsupportedOperationException(_plus);
      }
    } else {
      String _name_1 = feature.getName();
      String _plus = ("Unsupported record feature named " + _name_1);
      throw new UnsupportedOperationException(_plus);
    }
    return _switchResult;
  }

  protected JavaStatementBuilder _recordConstructor(final RDateType recordType, final Map<String, JavaStatementBuilder> features, final JavaScope scope) {
    final Function1<List<JavaStatementBuilder>, JavaStatementBuilder> _function = (List<JavaStatementBuilder> args) -> {
      final BiFunction<JavaExpression, JavaExpression, JavaStatementBuilder> _function_1 = (JavaExpression list, JavaExpression item) -> {
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append(list);
            _builder.append(", ");
            _builder.append(item);
          }
        };
        return JavaExpression.from(_client, null);
      };
      final BiFunction<JavaExpression, JavaExpression, JavaStatementBuilder> _function_2 = (JavaExpression list, JavaExpression item) -> {
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append(list);
            _builder.append(", ");
            _builder.append(item);
          }
        };
        return JavaExpression.from(_client, null);
      };
      final Function<JavaExpression, JavaStatementBuilder> _function_3 = (JavaExpression it) -> {
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append(Date.class);
            _builder.append(".of(");
            _builder.append(it);
            _builder.append(")");
          }
        };
        return JavaExpression.from(_client, this.typeUtil.DATE);
      };
      return args.get(0).then(
        args.get(1), _function_1, scope).then(
        args.get(2), _function_2, scope).mapExpression(_function_3);
    };
    return this.ifAllNotNull(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList("year", "month", "day")), features, _function, scope);
  }

  protected JavaStatementBuilder _recordConstructor(final RDateTimeType recordType, final Map<String, JavaStatementBuilder> features, final JavaScope scope) {
    final Function1<List<JavaStatementBuilder>, JavaStatementBuilder> _function = (List<JavaStatementBuilder> args) -> {
      final BiFunction<JavaExpression, JavaExpression, JavaStatementBuilder> _function_1 = (JavaExpression list, JavaExpression item) -> {
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append(list);
            _builder.append(".toLocalDate(), ");
            _builder.append(item);
          }
        };
        return JavaExpression.from(_client, null);
      };
      final Function<JavaExpression, JavaStatementBuilder> _function_2 = (JavaExpression it) -> {
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append(LocalDateTime.class);
            _builder.append(".of(");
            _builder.append(it);
            _builder.append(")");
          }
        };
        return JavaExpression.from(_client, this.typeUtil.LOCAL_DATE_TIME);
      };
      return args.get(0).then(
        args.get(1), _function_1, scope).mapExpression(_function_2);
    };
    return this.ifAllNotNull(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList("date", "time")), features, _function, scope);
  }

  protected JavaStatementBuilder _recordConstructor(final RZonedDateTimeType recordType, final Map<String, JavaStatementBuilder> features, final JavaScope scope) {
    final Function1<List<JavaStatementBuilder>, JavaStatementBuilder> _function = (List<JavaStatementBuilder> args) -> {
      final BiFunction<JavaExpression, JavaExpression, JavaStatementBuilder> _function_1 = (JavaExpression list, JavaExpression item) -> {
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append(list);
            _builder.append(".toLocalDate(), ");
            _builder.append(item);
          }
        };
        return JavaExpression.from(_client, null);
      };
      final BiFunction<JavaExpression, JavaExpression, JavaStatementBuilder> _function_2 = (JavaExpression list, JavaExpression item) -> {
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append(list);
            _builder.append(", ");
            _builder.append(ZoneId.class);
            _builder.append(".of(");
            _builder.append(item);
            _builder.append(")");
          }
        };
        return JavaExpression.from(_client, null);
      };
      final Function<JavaExpression, JavaStatementBuilder> _function_3 = (JavaExpression it) -> {
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append(ZonedDateTime.class);
            _builder.append(".of(");
            _builder.append(it);
            _builder.append(")");
          }
        };
        return JavaExpression.from(_client, this.typeUtil.ZONED_DATE_TIME);
      };
      return args.get(0).then(
        args.get(1), _function_1, scope).then(
        args.get(2), _function_2, scope).mapExpression(_function_3);
    };
    return this.ifAllNotNull(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList("date", "time", "timezone")), features, _function, scope);
  }

  private JavaStatementBuilder ifAllNotNull(final List<String> featureList, final Map<String, JavaStatementBuilder> allFeatures, final Function1<? super List<JavaStatementBuilder>, ? extends JavaStatementBuilder> conversion, final JavaScope scope) {
    final Function1<String, JavaStatementBuilder> _function = (String it) -> {
      return allFeatures.get(it);
    };
    final Function1<JavaStatementBuilder, Boolean> _function_1 = (JavaStatementBuilder it) -> {
      JavaType _expressionType = it.getExpressionType();
      return Boolean.valueOf((_expressionType instanceof JavaPrimitiveType));
    };
    boolean _forall = IterableExtensions.<JavaStatementBuilder>forall(ListExtensions.<String, JavaStatementBuilder>map(featureList, _function), _function_1);
    if (_forall) {
      final Function1<String, JavaStatementBuilder> _function_2 = (String it) -> {
        return allFeatures.get(it);
      };
      return conversion.apply(ListExtensions.<String, JavaStatementBuilder>map(featureList, _function_2));
    }
    final ArrayList<GeneratedIdentifier> nullableArgs = CollectionLiterals.<GeneratedIdentifier>newArrayList();
    final Function1<String, JavaStatementBuilder> _function_3 = (String it) -> {
      final JavaStatementBuilder feature = allFeatures.get(it);
      JavaType _expressionType = feature.getExpressionType();
      if ((_expressionType instanceof JavaPrimitiveType)) {
        return feature;
      } else {
        final JavaStatementBuilder res = feature.declareAsVariable(true, it, scope);
        nullableArgs.add(scope.getIdentifierOrThrow(feature));
        return res;
      }
    };
    final Function<JavaExpression, JavaStatementBuilder> _function_4 = (JavaExpression it) -> {
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          {
            boolean _hasElements = false;
            for(final GeneratedIdentifier arg : nullableArgs) {
              if (!_hasElements) {
                _hasElements = true;
              } else {
                _builder.appendImmediate(" && ", "");
              }
              _builder.append(arg);
              _builder.append(" != null");
            }
          }
        }
      };
      JavaExpression _from = JavaExpression.from(_client, JavaPrimitiveType.BOOLEAN);
      return new JavaConditionalExpression(_from, it, 
        JavaExpression.NULL, 
        this.typeUtil);
    };
    return conversion.apply(
      ListExtensions.<String, JavaStatementBuilder>map(featureList, _function_3)).mapExpression(_function_4);
  }

  public StringConcatenationClient recordFeatureToLambda(final RRecordType recordType, final RosettaRecordFeature feature, final JavaScope scope) {
    if (recordType instanceof RDateTimeType) {
      return _recordFeatureToLambda((RDateTimeType)recordType, feature, scope);
    } else if (recordType instanceof RDateType) {
      return _recordFeatureToLambda((RDateType)recordType, feature, scope);
    } else if (recordType instanceof RZonedDateTimeType) {
      return _recordFeatureToLambda((RZonedDateTimeType)recordType, feature, scope);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(recordType, feature, scope).toString());
    }
  }

  public JavaStatementBuilder recordConstructor(final RRecordType recordType, final Map<String, JavaStatementBuilder> features, final JavaScope scope) {
    if (recordType instanceof RDateTimeType) {
      return _recordConstructor((RDateTimeType)recordType, features, scope);
    } else if (recordType instanceof RDateType) {
      return _recordConstructor((RDateType)recordType, features, scope);
    } else if (recordType instanceof RZonedDateTimeType) {
      return _recordConstructor((RZonedDateTimeType)recordType, features, scope);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(recordType, features, scope).toString());
    }
  }
}
