package com.regnosys.rosetta.generator.java.util;

import com.google.common.base.Strings;
import com.regnosys.rosetta.rosetta.RosettaFeature;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@SuppressWarnings("all")
public class RosettaGrammarUtil {
  public static String quote(final String text) {
    String _replace = text.trim().replace("\"", "\\\"").replace("\r\n", "\n").replace("\n\n", "\n").replace("\n", "\\n\" + \n\t\"");
    String _plus = ("\"" + _replace);
    return (_plus + "\"");
  }

  public static String grammarText(final EObject expr) {
    final ICompositeNode node = NodeModelUtils.getNode(expr);
    if ((node == null)) {
      return "";
    } else {
      if ((node instanceof ILeafNode)) {
        return node.getText();
      } else {
        final Function1<ILeafNode, String> _function = (ILeafNode it) -> {
          return Strings.nullToEmpty(it.getText());
        };
        return IterableExtensions.join(IterableExtensions.<ILeafNode, String>map(node.getLeafNodes(), _function));
      }
    }
  }

  public static String grammarWhenThen(final EObject when, final EObject then) {
    String _trim = RosettaGrammarUtil.grammarText(when).trim();
    String _plus = ("when " + _trim);
    String _plus_1 = (_plus + "\nthen ");
    String _trim_1 = RosettaGrammarUtil.grammarText(then).trim();
    return (_plus_1 + _trim_1);
  }

  public static String extractNodeText(final EObject rosettaFeature, final EStructuralFeature feature) {
    final Function1<INode, String> _function = (INode it) -> {
      return NodeModelUtils.getTokenText(it);
    };
    return IterableExtensions.join(ListExtensions.<INode, String>map(NodeModelUtils.findNodesForFeature(rosettaFeature, feature), _function));
  }

  public static String extractGrammarText(final RosettaFeature rosettaFeature) {
    final ICompositeNode node = NodeModelUtils.getNode(rosettaFeature);
    if ((node == null)) {
      return null;
    }
    if ((node instanceof ILeafNode)) {
      return node.getText();
    } else {
      int _max = Math.max(node.getTotalLength(), 1);
      final StringBuilder builder = new StringBuilder(_max);
      Iterable<ILeafNode> _leafNodes = node.getLeafNodes();
      for (final ILeafNode leaf : _leafNodes) {
        builder.append(leaf.getText());
      }
      return builder.toString().trim().replace("\n", "\\n").replace("\r", "");
    }
  }
}
