/*
 * Copyright (c) REGnosys 2018 (www.regnosys.com) 
 * generated by Xtext 2.35.0
 */
grammar DebugInternalRosetta;

// Rule RosettaModel
ruleRosettaModel:
	'override'
	?
	'namespace'
	(
		ruleQualifiedName
		    |RULE_STRING
	)
	(
		':'
		ruleRosettaDefinable
	)?
	(
		'version'
		RULE_STRING
	)?
	ruleImport
	*
	ruleRosettaQualifiableConfiguration
	*
	(
		ruleRosettaRootElement
		    |ruleRootElement
	)*
;

// Rule QualifiedName
ruleQualifiedName:
	ruleValidID
	(
		'.'
		ruleValidID
	)*
;

// Rule Import
ruleImport:
	'import'
	ruleQualifiedNameWithWildcard
;

// Rule QualifiedNameWithWildcard
ruleQualifiedNameWithWildcard:
	ruleQualifiedName
	(
		'.'
		'*'
	)?
;

// Rule RootElement
ruleRootElement:
	(
		ruleAnnotation
		    |
		ruleData
		    |
		ruleChoice
		    |
		ruleFunction
	)
;

// Rule Annotation
ruleAnnotation:
	'annotation'
	ruleRosettaNamed
	':'
	ruleRosettaDefinable?
	(
		'['
		'prefix'
		ruleValidID
		']'
	)?
	ruleAttribute
	*
;

// Rule Annotations
ruleAnnotations:
	ruleAnnotationRef
;

// Rule Synonyms
ruleSynonyms:
	ruleRosettaSynonym
;

// Rule ClassSynonyms
ruleClassSynonyms:
	ruleRosettaClassSynonym
;

// Rule References
ruleReferences:
	ruleRosettaDocReference
;

// Rule RuleReference
ruleRuleReference:
	ruleRosettaRuleReference
;

// Rule AnnotationRef
ruleAnnotationRef:
	'['
	ruleValidID
	(
		ruleValidID
		ruleAnnotationQualifier
		*
	)?
	']'
;

// Rule AnnotationQualifier
ruleAnnotationQualifier:
	RULE_STRING
	'='
	(
		RULE_STRING
		    |
		ruleRosettaAttributeReference
	)
;

// Rule Data
ruleData:
	'type'
	ruleRosettaNamed
	(
		'extends'
		ruleQualifiedName
	)?
	':'
	ruleRosettaDefinable?
	(
		ruleReferences
		    |
		ruleAnnotations
		    |
		ruleClassSynonyms
	)*
	ruleAttribute
	*
	ruleCondition
	*
;

// Rule Choice
ruleChoice:
	'choice'
	ruleRosettaNamed
	':'
	ruleRosettaDefinable?
	(
		ruleAnnotations
		    |
		ruleClassSynonyms
	)*
	ruleChoiceOption
	*
;

// Rule ChoiceOption
ruleChoiceOption:
	ruleRosettaTyped
	ruleRosettaDefinable?
;

// Rule Attribute
ruleAttribute:
	'override'
	?
	ruleRosettaNamed
	ruleRosettaTyped
	ruleRosettaCardinality
	ruleRosettaDefinable?
	(
		ruleReferences
		    |
		ruleAnnotations
		    |
		ruleSynonyms
	)*
	ruleRuleReference?
;

// Rule Enumeration
ruleEnumeration:
	'enum'
	ruleRosettaNamed
	(
		'extends'
		ruleQualifiedName
	)?
	':'
	ruleRosettaDefinable?
	ruleReferences*
	ruleRosettaSynonym
	*
	ruleRosettaEnumValue
	*
;

// Rule Function
ruleFunction:
	'func'
	(
		ruleRosettaNamed
		    |
		ruleRosettaNamed
		'('
		ruleValidID
		':'
		ruleEnumValueReference
		')'
	)
	':'
	(
		(ruleRosettaDefinable)=>
		ruleRosettaDefinable
	)?
	(
		ruleReferences
		    |
		ruleAnnotations
	)*
	(
		'inputs'
		':'
		ruleAttribute
		+
	)?
	(
		'output'
		':'
		ruleAttribute
	)?
	ruleShortcutDeclaration
	*
	ruleCondition
	*
	ruleOperation
	*
	rulePostCondition
	*
;

// Rule ShortcutDeclaration
ruleShortcutDeclaration:
	'alias'
	ruleRosettaNamed
	':'
	(
		(ruleRosettaDefinable)=>
		ruleRosettaDefinable
	)?
	ruleRosettaCalcExpression
;

// Rule Condition
ruleCondition:
	'condition'
	ruleRosettaNamed?
	':'
	(
		(ruleRosettaDefinable)=>
		ruleRosettaDefinable
	)?
	(
		((
			ruleReferences
			    |
			ruleAnnotations
		)
		)=>
		(
			ruleReferences
			    |
			ruleAnnotations
		)
	)*
	ruleRosettaCalcExpression
;

// Rule PostCondition
rulePostCondition:
	'post-condition'
	ruleRosettaNamed?
	':'
	(
		(ruleRosettaDefinable)=>
		ruleRosettaDefinable
	)?
	ruleRosettaCalcExpression
;

// Rule Operation
ruleOperation:
	(
		'set'
		    |
		'add'
	)
	ruleValidID
	ruleSegment
	?
	':'
	(
		(ruleRosettaDefinable)=>
		ruleRosettaDefinable
	)?
	ruleRosettaCalcExpressionWithAsKey
;

// Rule Segment
ruleSegment:
	'->'
	ruleValidID
	ruleSegment
	?
;

// Rule EnumValueReference
ruleEnumValueReference:
	ruleQualifiedName
	'->'
	ruleValidID
;

// Rule EmptyLiteral
ruleEmptyLiteral:
	'empty'
;

// Rule ListLiteral
ruleListLiteral:
	'['
	(
		ruleRosettaCalcExpression
		(
			','
			ruleRosettaCalcExpression
		)*
	)?
	']'
;

// Rule RosettaRootElement
ruleRosettaRootElement:
	(
		ruleEnumeration
		    |
		ruleRosettaBody
		    |
		ruleRosettaCorpus
		    |
		ruleRosettaSegment
		    |
		ruleRosettaBasicType
		    |
		ruleRosettaRecordType
		    |
		ruleRosettaLibraryFunction
		    |
		ruleRosettaSynonymSource
		    |
		ruleRosettaRule
		    |
		ruleRosettaMetaType
		    |
		ruleRosettaExternalSynonymSource
		    |
		ruleRosettaExternalRuleSource
		    |
		ruleRosettaReport
		    |
		ruleRosettaTypeAlias
		    |
		ruleRosettaQualifiedType
		    |
		ruleRosettaCalculationType
	)
;

// Rule RosettaDefinable
ruleRosettaDefinable:
	'<'
	RULE_STRING
	'>'
;

// Rule RosettaNamed
ruleRosettaNamed:
	ruleValidID
;

// Rule RosettaTyped
ruleRosettaTyped:
	ruleTypeCall
;

// Rule TypeCall
ruleTypeCall:
	ruleQualifiedName
	(
		'('
		ruleTypeCallArgument
		(
			','
			ruleTypeCallArgument
		)*
		')'
	)?
;

// Rule TypeCallArgument
ruleTypeCallArgument:
	ruleTypeParameterValidID
	':'
	ruleTypeCallArgumentExpression
;

// Rule TypeCallArgumentExpression
ruleTypeCallArgumentExpression:
	(
		ruleTypeParameterReference
		    |
		ruleRosettaLiteral
	)
;

// Rule TypeParameterReference
ruleTypeParameterReference:
	ruleTypeParameterValidID
;

// Rule TypeParameterValidID
ruleTypeParameterValidID:
	(
		ruleValidID
		    |
		'min'
		    |
		'max'
	)
;

// Rule ValidID
ruleValidID:
	(
		RULE_ID
		    |
		'condition'
		    |
		'source'
		    |
		'value'
		    |
		'version'
		    |
		'pattern'
	)
;

// Rule RosettaBasicType
ruleRosettaBasicType:
	'basicType'
	ruleRosettaNamed
	ruleTypeParameters?
	ruleRosettaDefinable?
;

// Rule TypeParameters
ruleTypeParameters:
	'('
	ruleTypeParameter
	(
		','
		ruleTypeParameter
	)*
	','?
	')'
;

// Rule TypeParameter
ruleTypeParameter:
	ruleTypeParameterValidID
	ruleRosettaTyped
	ruleRosettaDefinable?
;

// Rule RosettaSynonymSource
ruleRosettaSynonymSource:
	'synonym'
	'source'
	ruleRosettaNamed
;

// Rule RosettaRecordType
ruleRosettaRecordType:
	'recordType'
	ruleRosettaNamed
	'{'
	ruleRosettaDefinable?
	ruleRosettaRecordFeature
	*
	'}'
;

// Rule RosettaRecordFeature
ruleRosettaRecordFeature:
	ruleRosettaNamed
	ruleRosettaTyped
;

// Rule RosettaParameter
ruleRosettaParameter:
	ruleRosettaNamed
	ruleRosettaTyped
	(
		'['
		']'
	)?
;

// Rule RosettaLibraryFunction
ruleRosettaLibraryFunction:
	'library'
	'function'
	ruleRosettaNamed
	'('
	(
		ruleRosettaParameter
		(
			','
			ruleRosettaParameter
		)*
	)?
	')'
	ruleRosettaTyped
	ruleRosettaDefinable?
;

// Rule RosettaQualifiedType
ruleRosettaQualifiedType:
	'qualifiedType'
	ruleRosettaNamed
	'{'
	'}'
;

// Rule RosettaCalculationType
ruleRosettaCalculationType:
	'calculationType'
	ruleRosettaNamed
	'{'
	'}'
;

// Rule RosettaTypeAlias
ruleRosettaTypeAlias:
	'typeAlias'
	ruleRosettaNamed
	ruleTypeParameters?
	':'
	ruleRosettaDefinable?
	ruleRosettaTyped
;

// Rule RosettaMetaType
ruleRosettaMetaType:
	'metaType'
	ruleRosettaNamed
	ruleRosettaTyped
;

// Rule RosettaEnumValue
ruleRosettaEnumValue:
	ruleRosettaNamed
	(
		'displayName'
		RULE_STRING
	)?
	ruleRosettaDefinable?
	ruleReferences*
	ruleRosettaEnumSynonym
	*
;

// Rule RosettaCardinality
ruleRosettaCardinality:
	'('
	(
		RULE_INT
		'..'
		RULE_INT
		    |
		RULE_INT
		'..'
		'*'
	)
	')'
;

// Rule RosettaClassSynonym
ruleRosettaClassSynonym:
	'['
	'synonym'
	ruleQualifiedName
	(
		','
		ruleQualifiedName
	)*
	(
		'value'
		ruleRosettaClassSynonymValue
	)?
	(
		'meta'
		ruleRosettaMetaSynonymValue
	)?
	']'
;

// Rule RosettaClassSynonymValue
ruleRosettaClassSynonymValue:
	RULE_STRING
	(
		ruleRosettaSynonymRef
		RULE_INT
	)?
	(
		'path'
		RULE_STRING
	)?
;

// Rule RosettaSynonym
ruleRosettaSynonym:
	'['
	'synonym'
	ruleQualifiedName
	(
		','
		ruleQualifiedName
	)*
	ruleRosettaSynonymBody
	']'
;

// Rule RosettaSynonymBody
ruleRosettaSynonymBody:
	(
		'value'
		(
			ruleRosettaSynonymValue
			','
		)*
		ruleRosettaSynonymValue
		ruleRosettaMapping
		?
		(
			'meta'
			(
				RULE_STRING
				','
			)*
			RULE_STRING
		)?
		    |
		'hint'
		(
			RULE_STRING
			','
		)*
		RULE_STRING
		    |
		'merge'
		ruleRosettaMergeSynonymValue
		    |
		ruleRosettaMappingSetTo
		    |
		'meta'
		(
			RULE_STRING
			','
		)*
		RULE_STRING
	)
	(
		'dateFormat'
		RULE_STRING
	)?
	(
		'pattern'
		RULE_STRING
		RULE_STRING
	)?
	'removeHtml'
	?
	(
		'mapper'
		RULE_STRING
	)?
;

// Rule RosettaSynonymValue
ruleRosettaSynonymValue:
	RULE_STRING
	(
		ruleRosettaSynonymRef
		RULE_INT
	)?
	(
		'path'
		RULE_STRING
	)?
	(
		'maps'
		RULE_INT
	)?
;

// Rule RosettaMetaSynonymValue
ruleRosettaMetaSynonymValue:
	RULE_STRING
	(
		ruleRosettaSynonymRef
		RULE_INT
	)?
	(
		'path'
		RULE_STRING
	)?
	(
		'maps'
		RULE_INT
	)?
;

// Rule RosettaMergeSynonymValue
ruleRosettaMergeSynonymValue:
	RULE_STRING
	(
		'when'
		'path'
		'<>'
		RULE_STRING
	)?
;

// Rule RosettaEnumSynonym
ruleRosettaEnumSynonym:
	'['
	'synonym'
	ruleQualifiedName
	(
		','
		ruleQualifiedName
	)*
	'value'
	RULE_STRING
	(
		'definition'
		RULE_STRING
	)?
	(
		'pattern'
		RULE_STRING
		RULE_STRING
	)?
	'removeHtml'
	?
	']'
;

// Rule RosettaMapping
ruleRosettaMapping:
	ruleRosettaMappingInstance
	(
		','
		ruleRosettaMappingInstance
	)*
;

// Rule RosettaMappingInstance
ruleRosettaMappingInstance:
	(
		'set'
		'when'
		ruleRosettaMappingPathTests
		    |
		'default'
		'to'
		ruleRosettaMapPrimaryExpression
	)
;

// Rule RosettaMappingSetTo
ruleRosettaMappingSetTo:
	ruleRosettaMappingSetToInstance
	(
		','
		ruleRosettaMappingSetToInstance
	)*
;

// Rule RosettaMappingSetToInstance
ruleRosettaMappingSetToInstance:
	'set'
	'to'
	ruleRosettaMapPrimaryExpression
	(
		'when'
		ruleRosettaMappingPathTests
	)?
;

// Rule RosettaMappingPathTests
ruleRosettaMappingPathTests:
	ruleRosettaMapTest
	(
		'and'
		ruleRosettaMapTest
	)*
;

// Rule RosettaMapTest
ruleRosettaMapTest:
	(
		ruleRosettaMapPath
		    |
		ruleRosettaMapRosettaPath
		    |
		ruleRosettaMapTestExpression
		    |
		ruleRosettaMapTestFunc
	)
;

// Rule RosettaMapPath
ruleRosettaMapPath:
	'path'
	'='
	ruleRosettaMapPathValue
;

// Rule RosettaMapRosettaPath
ruleRosettaMapRosettaPath:
	'rosettaPath'
	'='
	ruleRosettaAttributeReference
;

// Rule RosettaDataReference
ruleRosettaDataReference:
	ruleQualifiedName
;

// Rule RosettaAttributeReference
ruleRosettaAttributeReference:
	ruleRosettaDataReference
	(
		'->'
		ruleValidID
	)+
;

// Rule RosettaMapTestExpression
ruleRosettaMapTestExpression:
	ruleRosettaMapPathValue
	(
		'exists'
		    |
		'is'
		'absent'
		    |
		(
			'='
			    |
			'<>'
		)
		ruleRosettaMapPrimaryExpression
	)
;

// Rule RosettaMapPrimaryExpression
ruleRosettaMapPrimaryExpression:
	(
		ruleEnumValueReference
		    |
		ruleRosettaStringLiteral
		    |
		ruleRosettaBooleanLiteral
		    |
		ruleRosettaIntLiteral
		    |
		ruleRosettaNumberLiteral
	)
;

// Rule RosettaMapPathValue
ruleRosettaMapPathValue:
	RULE_STRING
;

// Rule RosettaMapTestFunc
ruleRosettaMapTestFunc:
	'condition-func'
	ruleQualifiedName
	(
		'condition-path'
		ruleRosettaMapPathValue
	)?
;

// Rule RosettaDocReference
ruleRosettaDocReference:
	'['
	(
		'regulatoryReference'
		    |
		'docReference'
	)
	ruleRegulatoryDocumentReference
	ruleDocumentRationale
	*
	ruleRosettaSegmentRef
	*
	(
		'structured_provision'
		RULE_STRING
	)?
	(
		'provision'
		RULE_STRING
	)?
	'reportedField'
	?
	']'
;

// Rule DocumentRationale
ruleDocumentRationale:
	(
		'rationale'
		RULE_STRING
		(
			(
				('rationale_author')=>
				'rationale_author'
			)
			RULE_STRING
		)?
		    |
		'rationale_author'
		RULE_STRING
		(
			(
				('rationale')=>
				'rationale'
			)
			RULE_STRING
		)?
	)
;

// Rule RosettaBody
ruleRosettaBody:
	'body'
	RULE_ID
	ruleRosettaNamed
	ruleRosettaDefinable?
;

// Rule RosettaCorpus
ruleRosettaCorpus:
	'corpus'
	RULE_ID
	ruleQualifiedName
	?
	RULE_STRING
	?
	ruleRosettaNamed
	ruleRosettaDefinable?
;

// Rule RosettaSegment
ruleRosettaSegment:
	'segment'
	(
		ruleValidID
		    |'rationale'
		    |
		'rationale_author'
		    |
		'structured_provision'
	)
;

// Rule RosettaReferenceOrFunctionCall
ruleRosettaReferenceOrFunctionCall:
	(
		ruleValidID
		(
			'('
			(
				ruleRosettaCalcExpression
				(
					','
					ruleRosettaCalcExpression
				)*
			)?
			')'
		)?
		    |
		(
			'item'
			    |
			'it'
		)
	)
;

// Rule RosettaLiteral
ruleRosettaLiteral:
	(
		ruleRosettaBooleanLiteral
		    |
		ruleRosettaStringLiteral
		    |
		ruleRosettaNumberLiteral
		    |
		ruleRosettaIntLiteral
	)
;

// Rule RosettaBooleanLiteral
ruleRosettaBooleanLiteral:
	(
		'True'
		    |
		'False'
	)
;

// Rule RosettaStringLiteral
ruleRosettaStringLiteral:
	RULE_STRING
;

// Rule RosettaNumberLiteral
ruleRosettaNumberLiteral:
	ruleBigDecimal
;

// Rule RosettaIntLiteral
ruleRosettaIntLiteral:
	ruleInteger
;

// Rule BigDecimal
ruleBigDecimal:
	(
		'+'
		    |
		'-'
	)?
	(
		'.'
		RULE_INT
		    |
		RULE_INT
		'.'
		    |
		RULE_INT
		'.'
		RULE_INT
	)
	(
		(
			'e'
			    |
			'E'
		)
		(
			'+'
			    |
			'-'
		)
		RULE_INT
		    |
		RULE_ID
	)?
;

// Rule Integer
ruleInteger:
	(
		'+'
		    |
		'-'
	)?
	RULE_INT
;

// Rule RosettaQualifiableConfiguration
ruleRosettaQualifiableConfiguration:
	ruleRosettaQualifiableType
	'root'
	ruleQualifiedName
	';'
;

// Rule ClosureParameter
ruleClosureParameter:
	RULE_ID
;

// Rule InlineFunction
ruleInlineFunction:
	(
		((
			ruleClosureParameter
			(
				','
				ruleClosureParameter
			)*
		)?
		'['
		)=>
		(
			ruleClosureParameter
			(
				','
				ruleClosureParameter
			)*
		)?
		'['
	)
	ruleRosettaCalcExpression
	']'
;

// Rule ImplicitInlineFunction
ruleImplicitInlineFunction:
	ruleRosettaCalcOr
;

// Rule RosettaCalcExpressionWithAsKey
ruleRosettaCalcExpressionWithAsKey:
	ruleRosettaCalcExpression
	(
		('as-key'
		)=>
		'as-key'
	)?
;

// Rule RosettaCalcExpression
ruleRosettaCalcExpression:
	ruleThenOperation
;

// Rule ThenOperation
ruleThenOperation:
	ruleRosettaCalcOr
	(
		(
			('then'
			)=>
			'then'
		)
		(
			(
				((
					ruleClosureParameter
					(
						','
						ruleClosureParameter
					)*
				)?
				'['
				)=>
				ruleInlineFunction
			)
			    |
			(
				(ruleImplicitInlineFunction
				)=>
				ruleImplicitInlineFunction
			)
		)?
	)*
;

// Rule RosettaCalcOr
ruleRosettaCalcOr:
	(
		ruleRosettaCalcAnd
		(
			(
				('or'
				)=>
				'or'
			)
			ruleRosettaCalcAnd
		)*
		    |
		(
			('or')=>
			'or'
			ruleRosettaCalcAnd
		)
		(
			(
				('or'
				)=>
				'or'
			)
			ruleRosettaCalcAnd
		)*
	)
;

// Rule RosettaCalcAnd
ruleRosettaCalcAnd:
	(
		ruleRosettaCalcEquality
		(
			(
				('and'
				)=>
				'and'
			)
			ruleRosettaCalcEquality
		)*
		    |
		(
			('and')=>
			'and'
			ruleRosettaCalcEquality
		)
		(
			(
				('and'
				)=>
				'and'
			)
			ruleRosettaCalcEquality
		)*
	)
;

// Rule RosettaCalcEquality
ruleRosettaCalcEquality:
	(
		ruleRosettaCalcComparison
		(
			(
				(ruleCardinalityModifier
				?
				(
					'='
					    |
					'<>'
				)
				)=>
				ruleCardinalityModifier
				?
				(
					'='
					    |
					'<>'
				)
			)
			ruleRosettaCalcComparison
		)*
		    |
		(
			('any' | 'all' | '=' | '<>')=>
			ruleCardinalityModifier
			?
			(
				'='
				    |
				'<>'
			)
			ruleRosettaCalcComparison
		)
		(
			(
				(ruleCardinalityModifier
				?
				(
					'='
					    |
					'<>'
				)
				)=>
				ruleCardinalityModifier
				?
				(
					'='
					    |
					'<>'
				)
			)
			ruleRosettaCalcComparison
		)*
	)
;

// Rule RosettaCalcComparison
ruleRosettaCalcComparison:
	(
		ruleRosettaCalcAdditive
		(
			(
				(ruleCardinalityModifier
				?
				(
					'>='
					    |
					'<='
					    |
					'>'
					    |
					'<'
				)
				)=>
				ruleCardinalityModifier
				?
				(
					'>='
					    |
					'<='
					    |
					'>'
					    |
					'<'
				)
			)
			ruleRosettaCalcAdditive
		)*
		    |
		(
			('any' | 'all' | '>=' | '<=' | '>' | '<')=>
			ruleCardinalityModifier
			?
			(
				'>='
				    |
				'<='
				    |
				'>'
				    |
				'<'
			)
			ruleRosettaCalcAdditive
		)
		(
			(
				(ruleCardinalityModifier
				?
				(
					'>='
					    |
					'<='
					    |
					'>'
					    |
					'<'
				)
				)=>
				ruleCardinalityModifier
				?
				(
					'>='
					    |
					'<='
					    |
					'>'
					    |
					'<'
				)
			)
			ruleRosettaCalcAdditive
		)*
	)
;

// Rule RosettaCalcAdditive
ruleRosettaCalcAdditive:
	ruleRosettaCalcMultiplicative
	(
		(
			((
				'+'
				    |
				'-'
			)
			)=>
			(
				'+'
				    |
				'-'
			)
		)
		ruleRosettaCalcMultiplicative
	)*
;

// Rule RosettaCalcMultiplicative
ruleRosettaCalcMultiplicative:
	(
		ruleRosettaCalcBinary
		(
			(
				((
					'*'
					    |
					'/'
				)
				)=>
				(
					'*'
					    |
					'/'
				)
			)
			ruleRosettaCalcBinary
		)*
		    |
		(
			('*' | '/')=>
			(
				'*'
				    |
				'/'
			)
			ruleRosettaCalcBinary
		)
		(
			(
				((
					'*'
					    |
					'/'
				)
				)=>
				(
					'*'
					    |
					'/'
				)
			)
			ruleRosettaCalcBinary
		)*
	)
;

// Rule RosettaCalcBinary
ruleRosettaCalcBinary:
	(
		ruleListOperation
		(
			((
				'contains'
				ruleListOperation
				    |
				'disjoint'
				ruleListOperation
				    |
				'default'
				ruleListOperation
				    |
				'join'
				(
					(ruleListOperation
					)=>
					ruleListOperation
				)?
			)
			)=>
			(
				'contains'
				ruleListOperation
				    |
				'disjoint'
				ruleListOperation
				    |
				'default'
				ruleListOperation
				    |
				'join'
				(
					(ruleListOperation
					)=>
					ruleListOperation
				)?
			)
		)?
		    |
		(
			('contains' | 'disjoint' | 'default' | 'join')=>
			(
				'contains'
				ruleListOperation
				    |
				'disjoint'
				ruleListOperation
				    |
				'default'
				ruleListOperation
				    |
				'join'
				(
					(ruleListOperation
					)=>
					ruleListOperation
				)?
			)
		)
		(
			((
				'contains'
				ruleListOperation
				    |
				'disjoint'
				ruleListOperation
				    |
				'default'
				ruleListOperation
				    |
				'join'
				(
					(ruleListOperation
					)=>
					ruleListOperation
				)?
			)
			)=>
			(
				'contains'
				ruleListOperation
				    |
				'disjoint'
				ruleListOperation
				    |
				'default'
				ruleListOperation
				    |
				'join'
				(
					(ruleListOperation
					)=>
					ruleListOperation
				)?
			)
		)?
	)
;

// Rule ListOperation
ruleListOperation:
	(
		ruleRosettaCalcPrimary
		(
			(
				((
					'->'
					(
						(ruleValidID
						)=>
						ruleValidID
					)?
					    |
					'->>'
					(
						(ruleValidID
						)=>
						ruleValidID
					)?
					    |
					ruleExistsModifier
					?
					'exists'
					    |
					'is'
					'absent'
					    |
					'only-element'
					    |
					'count'
					    |
					'flatten'
					    |
					'distinct'
					    |
					'reverse'
					    |
					'first'
					    |
					'last'
					    |
					'sum'
					    |
					'one-of'
					    |
					ruleNecessity
					'choice'
					ruleValidID
					(
						(','
						ruleValidID
						)=>
						','
						ruleValidID
					)*
					    |
					'to-string'
					    |
					'to-number'
					    |
					'to-int'
					    |
					'to-time'
					    |
					'to-enum'
					ruleQualifiedName
					    |
					'to-date'
					    |
					'to-date-time'
					    |
					'to-zoned-date-time'
				)
				)=>
				(
					'->'
					(
						(ruleValidID
						)=>
						ruleValidID
					)?
					    |
					'->>'
					(
						(ruleValidID
						)=>
						ruleValidID
					)?
					    |
					ruleExistsModifier
					?
					'exists'
					    |
					'is'
					'absent'
					    |
					'only-element'
					    |
					'count'
					    |
					'flatten'
					    |
					'distinct'
					    |
					'reverse'
					    |
					'first'
					    |
					'last'
					    |
					'sum'
					    |
					'one-of'
					    |
					ruleNecessity
					'choice'
					ruleValidID
					(
						(','
						ruleValidID
						)=>
						','
						ruleValidID
					)*
					    |
					'to-string'
					    |
					'to-number'
					    |
					'to-int'
					    |
					'to-time'
					    |
					'to-enum'
					ruleQualifiedName
					    |
					'to-date'
					    |
					'to-date-time'
					    |
					'to-zoned-date-time'
				)
			)
			    |
			(
				((
					'sort'
					    |
					'min'
					    |
					'max'
				)
				)=>
				(
					'sort'
					    |
					'min'
					    |
					'max'
				)
			)
			(
				((
					ruleClosureParameter
					(
						','
						ruleClosureParameter
					)*
				)?
				'['
				)=>
				ruleInlineFunction
			)?
			    |
			(
				((
					'reduce'
					    |
					'filter'
					    |
					(
						'map'
						    |
						'extract'
					)
				)
				)=>
				(
					'reduce'
					    |
					'filter'
					    |
					(
						'map'
						    |
						'extract'
					)
				)
			)
			(
				(
					((
						ruleClosureParameter
						(
							','
							ruleClosureParameter
						)*
					)?
					'['
					)=>
					ruleInlineFunction
				)
				    |
				(
					(ruleImplicitInlineFunction
					)=>
					ruleImplicitInlineFunction
				)
			)?
		)*
		    |
		(
			(
				ruleExistsModifier
				?
				'exists'
				    |
				'is'
				'absent'
				    |
				'only-element'
				    |
				'count'
				    |
				'flatten'
				    |
				'distinct'
				    |
				'reverse'
				    |
				'first'
				    |
				'last'
				    |
				'sum'
				    |
				'one-of'
				    |
				ruleNecessity
				'choice'
				ruleValidID
				(
					(','
					ruleValidID
					)=>
					','
					ruleValidID
				)*
				    |
				'to-string'
				    |
				'to-number'
				    |
				'to-int'
				    |
				'to-time'
				    |
				'to-enum'
				ruleQualifiedName
				    |
				'to-date'
				    |
				'to-date-time'
				    |
				'to-zoned-date-time'
			)
			    |
			(
				'sort'
				    |
				'min'
				    |
				'max'
			)
			(
				((
					ruleClosureParameter
					(
						','
						ruleClosureParameter
					)*
				)?
				'['
				)=>
				ruleInlineFunction
			)?
			    |
			(
				'reduce'
				    |
				'filter'
				    |
				(
					'map'
					    |
					'extract'
				)
			)
			(
				(
					((
						ruleClosureParameter
						(
							','
							ruleClosureParameter
						)*
					)?
					'['
					)=>
					ruleInlineFunction
				)
				    |
				(
					(ruleImplicitInlineFunction
					)=>
					ruleImplicitInlineFunction
				)
			)?
		)
		(
			(
				((
					'->'
					(
						(ruleValidID
						)=>
						ruleValidID
					)?
					    |
					'->>'
					(
						(ruleValidID
						)=>
						ruleValidID
					)?
					    |
					ruleExistsModifier
					?
					'exists'
					    |
					'is'
					'absent'
					    |
					'only-element'
					    |
					'count'
					    |
					'flatten'
					    |
					'distinct'
					    |
					'reverse'
					    |
					'first'
					    |
					'last'
					    |
					'sum'
					    |
					'one-of'
					    |
					ruleNecessity
					'choice'
					ruleValidID
					(
						(','
						ruleValidID
						)=>
						','
						ruleValidID
					)*
					    |
					'to-string'
					    |
					'to-number'
					    |
					'to-int'
					    |
					'to-time'
					    |
					'to-enum'
					ruleQualifiedName
					    |
					'to-date'
					    |
					'to-date-time'
					    |
					'to-zoned-date-time'
				)
				)=>
				(
					'->'
					(
						(ruleValidID
						)=>
						ruleValidID
					)?
					    |
					'->>'
					(
						(ruleValidID
						)=>
						ruleValidID
					)?
					    |
					ruleExistsModifier
					?
					'exists'
					    |
					'is'
					'absent'
					    |
					'only-element'
					    |
					'count'
					    |
					'flatten'
					    |
					'distinct'
					    |
					'reverse'
					    |
					'first'
					    |
					'last'
					    |
					'sum'
					    |
					'one-of'
					    |
					ruleNecessity
					'choice'
					ruleValidID
					(
						(','
						ruleValidID
						)=>
						','
						ruleValidID
					)*
					    |
					'to-string'
					    |
					'to-number'
					    |
					'to-int'
					    |
					'to-time'
					    |
					'to-enum'
					ruleQualifiedName
					    |
					'to-date'
					    |
					'to-date-time'
					    |
					'to-zoned-date-time'
				)
			)
			    |
			(
				((
					'sort'
					    |
					'min'
					    |
					'max'
				)
				)=>
				(
					'sort'
					    |
					'min'
					    |
					'max'
				)
			)
			(
				((
					ruleClosureParameter
					(
						','
						ruleClosureParameter
					)*
				)?
				'['
				)=>
				ruleInlineFunction
			)?
			    |
			(
				((
					'reduce'
					    |
					'filter'
					    |
					(
						'map'
						    |
						'extract'
					)
				)
				)=>
				(
					'reduce'
					    |
					'filter'
					    |
					(
						'map'
						    |
						'extract'
					)
				)
			)
			(
				(
					((
						ruleClosureParameter
						(
							','
							ruleClosureParameter
						)*
					)?
					'['
					)=>
					ruleInlineFunction
				)
				    |
				(
					(ruleImplicitInlineFunction
					)=>
					ruleImplicitInlineFunction
				)
			)?
		)*
	)
;

// Rule RosettaCalcPrimary
ruleRosettaCalcPrimary:
	(
		ruleRosettaCalcConstructorExpression
		    |
		ruleRosettaCalcConditionalExpression
		    |
		ruleRosettaCalcOnlyExists
		    |
		ruleRosettaReferenceOrFunctionCall
		    |
		ruleRosettaLiteral
		    |
		ruleEmptyLiteral
		    |
		ruleListLiteral
		    |
		'('
		ruleRosettaCalcExpression
		')'
	)
;

// Rule RosettaCalcConstructorExpression
ruleRosettaCalcConstructorExpression:
	ruleTypeCall
	'{'
	(
		ruleConstructorKeyValuePair
		(
			','
			ruleConstructorKeyValuePair
		)*
		(
			','
			    |
			','
			'...'
		)?
		    |
		'...'
	)?
	'}'
;

// Rule ConstructorKeyValuePair
ruleConstructorKeyValuePair:
	ruleValidID
	':'
	ruleRosettaCalcExpressionWithAsKey
;

// Rule RosettaCalcConditionalExpression
ruleRosettaCalcConditionalExpression:
	'if'
	ruleRosettaCalcOr
	'then'
	ruleRosettaCalcOr
	(
		(
			('else'
			)=>
			'else'
		)
		ruleRosettaCalcOr
	)?
;

// Rule RosettaCalcOnlyExists
ruleRosettaCalcOnlyExists:
	(
		ruleRosettaOnlyExistsElement
		    |
		'('
		ruleRosettaOnlyExistsElement
		(
			','
			ruleRosettaOnlyExistsElement
		)*
		')'
	)
	'only'
	'exists'
;

// Rule RosettaOnlyExistsElement
ruleRosettaOnlyExistsElement:
	ruleRosettaOnlyExistsElementRoot
	(
		'->'
		ruleValidID
	)*
;

// Rule RosettaOnlyExistsElementRoot
ruleRosettaOnlyExistsElementRoot:
	(
		ruleQualifiedName
		    |
		(
			'item'
			    |
			'it'
		)
	)
;

// Rule ExternalAnnotationSource
ruleExternalAnnotationSource:
	'{'
	ruleRosettaExternalClass
	*
	(
		'enums'
		ruleRosettaExternalEnum
		*
	)?
	'}'
;

// Rule RosettaExternalSynonymSource
ruleRosettaExternalSynonymSource:
	'synonym'
	'source'
	ruleRosettaNamed
	(
		'extends'
		ruleQualifiedName
		(
			','
			ruleQualifiedName
		)*
	)?
	ruleExternalAnnotationSource
;

// Rule RosettaExternalRuleSource
ruleRosettaExternalRuleSource:
	'rule'
	'source'
	ruleRosettaNamed
	(
		'extends'
		ruleQualifiedName
		(
			','
			ruleQualifiedName
		)*
	)?
	ruleExternalAnnotationSource
;

// Rule RosettaExternalClass
ruleRosettaExternalClass:
	ruleQualifiedName
	':'
	ruleRosettaExternalClassSynonym
	*
	ruleRosettaExternalRegularAttribute
	*
;

// Rule RosettaExternalEnum
ruleRosettaExternalEnum:
	ruleQualifiedName
	':'
	ruleRosettaExternalEnumValue
	*
;

// Rule RosettaExternalRegularAttribute
ruleRosettaExternalRegularAttribute:
	ruleExternalValueOperator
	ruleValidID
	ruleRosettaExternalSynonym
	*
	ruleRosettaRuleReference
	?
;

// Rule RosettaExternalEnumValue
ruleRosettaExternalEnumValue:
	ruleExternalValueOperator
	ruleValidID
	ruleRosettaExternalEnumSynonym
	*
;

// Rule RosettaExternalClassSynonym
ruleRosettaExternalClassSynonym:
	'['
	(
		'value'
		ruleRosettaClassSynonymValue
	)?
	'meta'
	ruleRosettaMetaSynonymValue
	']'
;

// Rule RosettaExternalSynonym
ruleRosettaExternalSynonym:
	'['
	ruleRosettaSynonymBody
	']'
;

// Rule RosettaExternalEnumSynonym
ruleRosettaExternalEnumSynonym:
	'['
	'value'
	RULE_STRING
	(
		'definition'
		RULE_STRING
	)?
	(
		'pattern'
		RULE_STRING
		RULE_STRING
	)?
	']'
;

// Rule RegulatoryDocumentReference
ruleRegulatoryDocumentReference:
	ruleQualifiedName
	ruleQualifiedName
	+
	(
		(ruleRosettaSegmentRef
		)=>
		ruleRosettaSegmentRef
	)*
;

// Rule RosettaSegmentRef
ruleRosettaSegmentRef:
	ruleQualifiedName
	RULE_STRING
;

// Rule RosettaReport
ruleRosettaReport:
	'report'
	ruleRegulatoryDocumentReference
	'in'
	(
		'real-time'
		    |
		'T+1'
		    |
		'T+2'
		    |
		'T+3'
		    |
		'T+4'
		    |
		'T+5'
		    |
		'ASATP'
	)
	'from'
	ruleTypeCall
	'when'
	ruleQualifiedName
	(
		'and'
		ruleQualifiedName
	)*
	(
		'using'
		'standard'
		ruleQualifiedName
	)?
	'with'
	'type'
	ruleQualifiedName
	(
		'with'
		'source'
		ruleQualifiedName
	)?
;

// Rule RosettaRuleReference
ruleRosettaRuleReference:
	'['
	'ruleReference'
	ruleQualifiedName
	']'
;

// Rule RosettaRule
ruleRosettaRule:
	(
		'reporting'
		    |
		'eligibility'
	)
	'rule'
	ruleRosettaNamed
	(
		'from'
		ruleTypeCall
	)?
	':'
	(
		(ruleRosettaDefinable)=>
		ruleRosettaDefinable
	)?
	ruleReferences*
	ruleRosettaCalcExpression
	(
		'as'
		RULE_STRING
	)?
;

// Rule Necessity
ruleNecessity:
	(
		'optional'
		    |
		'required'
	)
;

// Rule RosettaSynonymRef
ruleRosettaSynonymRef:
	(
		'tag'
		    |
		'componentID'
	)
;

// Rule RosettaQualifiableType
ruleRosettaQualifiableType:
	(
		'isEvent'
		    |
		'isProduct'
	)
;

// Rule CardinalityModifier
ruleCardinalityModifier:
	(
		'any'
		    |
		'all'
	)
;

// Rule ExistsModifier
ruleExistsModifier:
	(
		'single'
		    |
		'multiple'
	)
;

// Rule ExternalValueOperator
ruleExternalValueOperator:
	(
		'+'
		    |
		'-'
	)
;

RULE_ID : '^'? ('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'_'|'0'..'9')*;

RULE_INT : ('0'..'9')+;

RULE_STRING : ('"' ('\\' .|~(('\\'|'"')))* '"'|'\'' ('\\' .|~(('\\'|'\'')))* '\'');

RULE_ML_COMMENT : '/*' ( options {greedy=false;} : . )*'*/' {skip();};

RULE_SL_COMMENT : '//' ~(('\n'|'\r'))* ('\r'? '\n')? {skip();};

RULE_WS : (' '|'\t'|'\r'|'\n')+ {skip();};

RULE_ANY_OTHER : .;
