package com.regnosys.rosetta.resource;

import java.io.IOException;
import java.util.Collection;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.resource.DerivedStateAwareResource;
import org.eclipse.xtext.resource.DerivedStateAwareResourceDescriptionManager;
import org.eclipse.xtext.resource.IDefaultResourceDescriptionStrategy;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.util.RuntimeIOException;
import org.eclipse.xtext.xbase.lib.Exceptions;

@SuppressWarnings("all")
public class RosettaResourceDescriptionManager extends DerivedStateAwareResourceDescriptionManager {
  /**
   * Need to re-validate all the resources with isEvent or isProduct when the root class configuration 'isEvent root' or 'isProduct root' changes
   */
  @Override
  public boolean isAffected(final Collection<IResourceDescription.Delta> deltas, final IResourceDescription candidate, final IResourceDescriptions context) {
    return super.isAffected(deltas, candidate, context);
  }

  /**
   * This is the same implementation as in `DerivedStateAwareResourceDescriptionManager`,
   * EXCEPT that this implementation does not remove derived state once installed.
   */
  @Override
  public IResourceDescription internalGetResourceDescription(final Resource resource, final IDefaultResourceDescriptionStrategy strategy) {
    if ((resource instanceof DerivedStateAwareResource)) {
      boolean _isLoaded = ((DerivedStateAwareResource)resource).isLoaded();
      boolean _not = (!_isLoaded);
      if (_not) {
        try {
          ((DerivedStateAwareResource)resource).load(((DerivedStateAwareResource)resource).getResourceSet().getLoadOptions());
        } catch (final Throwable _t) {
          if (_t instanceof IOException) {
            final IOException e = (IOException)_t;
            throw new RuntimeIOException(e);
          } else {
            throw Exceptions.sneakyThrow(_t);
          }
        }
      }
      final boolean isInitialized = (((DerivedStateAwareResource)resource).isFullyInitialized() || ((DerivedStateAwareResource)resource).isInitializing());
      try {
        if ((!isInitialized)) {
          ((DerivedStateAwareResource)resource).eSetDeliver(false);
          ((DerivedStateAwareResource)resource).installDerivedState(true);
        }
        final IResourceDescription description = this.createResourceDescription(resource, strategy);
        if ((!isInitialized)) {
          Iterable<IEObjectDescription> _exportedObjects = description.getExportedObjects();
          for (final IEObjectDescription desc : _exportedObjects) {
            desc.getEObjectURI();
          }
        }
        return description;
      } finally {
        if ((!isInitialized)) {
          ((DerivedStateAwareResource)resource).eSetDeliver(true);
        }
      }
    } else {
      return super.internalGetResourceDescription(resource, strategy);
    }
  }
}
