/**
 * Copyright (c) REGnosys 2017 (www.regnosys.com)
 */
package com.regnosys.rosetta.rosetta;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see com.regnosys.rosetta.rosetta.RosettaFactory
 * @model kind="package"
 * @generated
 */
public interface RosettaPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "rosetta";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.rosetta-model.com/Rosetta";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "rosetta";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	RosettaPackage eINSTANCE = com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl.init();

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.RosettaDefinable <em>Definable</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.RosettaDefinable
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaDefinable()
	 * @generated
	 */
	int ROSETTA_DEFINABLE = 2;

	/**
	 * The feature id for the '<em><b>Definition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_DEFINABLE__DEFINITION = 0;

	/**
	 * The number of structural features of the '<em>Definable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_DEFINABLE_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaModelImpl <em>Model</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaModelImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaModel()
	 * @generated
	 */
	int ROSETTA_MODEL = 0;

	/**
	 * The feature id for the '<em><b>Definition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_MODEL__DEFINITION = ROSETTA_DEFINABLE__DEFINITION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_MODEL__NAME = ROSETTA_DEFINABLE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_MODEL__VERSION = ROSETTA_DEFINABLE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Overridden</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_MODEL__OVERRIDDEN = ROSETTA_DEFINABLE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Imports</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_MODEL__IMPORTS = ROSETTA_DEFINABLE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Configurations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_MODEL__CONFIGURATIONS = ROSETTA_DEFINABLE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Elements</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_MODEL__ELEMENTS = ROSETTA_DEFINABLE_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_MODEL_FEATURE_COUNT = ROSETTA_DEFINABLE_FEATURE_COUNT + 6;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.ImportImpl <em>Import</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.ImportImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getImport()
	 * @generated
	 */
	int IMPORT = 1;

	/**
	 * The feature id for the '<em><b>Imported Namespace</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMPORT__IMPORTED_NAMESPACE = 0;

	/**
	 * The number of structural features of the '<em>Import</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMPORT_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.RosettaNamed <em>Named</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.RosettaNamed
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaNamed()
	 * @generated
	 */
	int ROSETTA_NAMED = 3;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_NAMED__NAME = 0;

	/**
	 * The number of structural features of the '<em>Named</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_NAMED_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.RosettaTyped <em>Typed</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.RosettaTyped
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaTyped()
	 * @generated
	 */
	int ROSETTA_TYPED = 4;

	/**
	 * The feature id for the '<em><b>Type Call</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_TYPED__TYPE_CALL = 0;

	/**
	 * The feature id for the '<em><b>Is Type Inferred</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_TYPED__IS_TYPE_INFERRED = 1;

	/**
	 * The number of structural features of the '<em>Typed</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_TYPED_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaFeatureImpl <em>Feature</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaFeatureImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaFeature()
	 * @generated
	 */
	int ROSETTA_FEATURE = 5;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_FEATURE__NAME = ROSETTA_NAMED__NAME;

	/**
	 * The feature id for the '<em><b>Get Name Or Default</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_FEATURE__GET_NAME_OR_DEFAULT = ROSETTA_NAMED_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Feature</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_FEATURE_FEATURE_COUNT = ROSETTA_NAMED_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaTypedFeatureImpl <em>Typed Feature</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaTypedFeatureImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaTypedFeature()
	 * @generated
	 */
	int ROSETTA_TYPED_FEATURE = 6;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_TYPED_FEATURE__NAME = ROSETTA_FEATURE__NAME;

	/**
	 * The feature id for the '<em><b>Get Name Or Default</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_TYPED_FEATURE__GET_NAME_OR_DEFAULT = ROSETTA_FEATURE__GET_NAME_OR_DEFAULT;

	/**
	 * The feature id for the '<em><b>Type Call</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_TYPED_FEATURE__TYPE_CALL = ROSETTA_FEATURE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Is Type Inferred</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_TYPED_FEATURE__IS_TYPE_INFERRED = ROSETTA_FEATURE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Typed Feature</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_TYPED_FEATURE_FEATURE_COUNT = ROSETTA_FEATURE_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.RosettaSymbol <em>Symbol</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.RosettaSymbol
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaSymbol()
	 * @generated
	 */
	int ROSETTA_SYMBOL = 7;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_SYMBOL__NAME = ROSETTA_NAMED__NAME;

	/**
	 * The number of structural features of the '<em>Symbol</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_SYMBOL_FEATURE_COUNT = ROSETTA_NAMED_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.RosettaCallableWithArgs <em>Callable With Args</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.RosettaCallableWithArgs
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaCallableWithArgs()
	 * @generated
	 */
	int ROSETTA_CALLABLE_WITH_ARGS = 8;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_CALLABLE_WITH_ARGS__NAME = ROSETTA_SYMBOL__NAME;

	/**
	 * The number of structural features of the '<em>Callable With Args</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_CALLABLE_WITH_ARGS_FEATURE_COUNT = ROSETTA_SYMBOL_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.RosettaRootElement <em>Root Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.RosettaRootElement
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaRootElement()
	 * @generated
	 */
	int ROSETTA_ROOT_ELEMENT = 9;

	/**
	 * The feature id for the '<em><b>Model</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_ROOT_ELEMENT__MODEL = 0;

	/**
	 * The number of structural features of the '<em>Root Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_ROOT_ELEMENT_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaFeatureOwnerImpl <em>Feature Owner</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaFeatureOwnerImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaFeatureOwner()
	 * @generated
	 */
	int ROSETTA_FEATURE_OWNER = 10;

	/**
	 * The feature id for the '<em><b>Definition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_FEATURE_OWNER__DEFINITION = ROSETTA_DEFINABLE__DEFINITION;

	/**
	 * The feature id for the '<em><b>Features</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_FEATURE_OWNER__FEATURES = ROSETTA_DEFINABLE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Feature Owner</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_FEATURE_OWNER_FEATURE_COUNT = ROSETTA_DEFINABLE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaTypeImpl <em>Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaTypeImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaType()
	 * @generated
	 */
	int ROSETTA_TYPE = 11;

	/**
	 * The feature id for the '<em><b>Model</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_TYPE__MODEL = ROSETTA_ROOT_ELEMENT__MODEL;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_TYPE__NAME = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_TYPE_FEATURE_COUNT = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.ParametrizedRosettaType <em>Parametrized Rosetta Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.ParametrizedRosettaType
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getParametrizedRosettaType()
	 * @generated
	 */
	int PARAMETRIZED_ROSETTA_TYPE = 12;

	/**
	 * The feature id for the '<em><b>Parameters</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETRIZED_ROSETTA_TYPE__PARAMETERS = 0;

	/**
	 * The number of structural features of the '<em>Parametrized Rosetta Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETRIZED_ROSETTA_TYPE_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.TypeCallImpl <em>Type Call</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.TypeCallImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getTypeCall()
	 * @generated
	 */
	int TYPE_CALL = 13;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_CALL__TYPE = 0;

	/**
	 * The feature id for the '<em><b>Arguments</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_CALL__ARGUMENTS = 1;

	/**
	 * The number of structural features of the '<em>Type Call</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_CALL_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.TypeCallArgumentImpl <em>Type Call Argument</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.TypeCallArgumentImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getTypeCallArgument()
	 * @generated
	 */
	int TYPE_CALL_ARGUMENT = 14;

	/**
	 * The feature id for the '<em><b>Parameter</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_CALL_ARGUMENT__PARAMETER = 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_CALL_ARGUMENT__VALUE = 1;

	/**
	 * The number of structural features of the '<em>Type Call Argument</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_CALL_ARGUMENT_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaBuiltinTypeImpl <em>Builtin Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaBuiltinTypeImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaBuiltinType()
	 * @generated
	 */
	int ROSETTA_BUILTIN_TYPE = 15;

	/**
	 * The feature id for the '<em><b>Model</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_BUILTIN_TYPE__MODEL = ROSETTA_TYPE__MODEL;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_BUILTIN_TYPE__NAME = ROSETTA_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Definition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_BUILTIN_TYPE__DEFINITION = ROSETTA_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Builtin Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_BUILTIN_TYPE_FEATURE_COUNT = ROSETTA_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaBasicTypeImpl <em>Basic Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaBasicTypeImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaBasicType()
	 * @generated
	 */
	int ROSETTA_BASIC_TYPE = 16;

	/**
	 * The feature id for the '<em><b>Model</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_BASIC_TYPE__MODEL = ROSETTA_ROOT_ELEMENT__MODEL;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_BASIC_TYPE__NAME = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Definition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_BASIC_TYPE__DEFINITION = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Parameters</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_BASIC_TYPE__PARAMETERS = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Basic Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_BASIC_TYPE_FEATURE_COUNT = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.TypeParameterImpl <em>Type Parameter</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.TypeParameterImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getTypeParameter()
	 * @generated
	 */
	int TYPE_PARAMETER = 17;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER__NAME = ROSETTA_SYMBOL__NAME;

	/**
	 * The feature id for the '<em><b>Type Call</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER__TYPE_CALL = ROSETTA_SYMBOL_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Is Type Inferred</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER__IS_TYPE_INFERRED = ROSETTA_SYMBOL_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Definition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER__DEFINITION = ROSETTA_SYMBOL_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Type Parameter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER_FEATURE_COUNT = ROSETTA_SYMBOL_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaSynonymSourceImpl <em>Synonym Source</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaSynonymSourceImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaSynonymSource()
	 * @generated
	 */
	int ROSETTA_SYNONYM_SOURCE = 18;

	/**
	 * The feature id for the '<em><b>Model</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_SYNONYM_SOURCE__MODEL = ROSETTA_ROOT_ELEMENT__MODEL;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_SYNONYM_SOURCE__NAME = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Synonym Source</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_SYNONYM_SOURCE_FEATURE_COUNT = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaRecordTypeImpl <em>Record Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaRecordTypeImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaRecordType()
	 * @generated
	 */
	int ROSETTA_RECORD_TYPE = 19;

	/**
	 * The feature id for the '<em><b>Model</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_RECORD_TYPE__MODEL = ROSETTA_ROOT_ELEMENT__MODEL;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_RECORD_TYPE__NAME = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Definition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_RECORD_TYPE__DEFINITION = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Features</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_RECORD_TYPE__FEATURES = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Record Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_RECORD_TYPE_FEATURE_COUNT = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaRecordFeatureImpl <em>Record Feature</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaRecordFeatureImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaRecordFeature()
	 * @generated
	 */
	int ROSETTA_RECORD_FEATURE = 20;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_RECORD_FEATURE__NAME = ROSETTA_TYPED_FEATURE__NAME;

	/**
	 * The feature id for the '<em><b>Get Name Or Default</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_RECORD_FEATURE__GET_NAME_OR_DEFAULT = ROSETTA_TYPED_FEATURE__GET_NAME_OR_DEFAULT;

	/**
	 * The feature id for the '<em><b>Type Call</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_RECORD_FEATURE__TYPE_CALL = ROSETTA_TYPED_FEATURE__TYPE_CALL;

	/**
	 * The feature id for the '<em><b>Is Type Inferred</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_RECORD_FEATURE__IS_TYPE_INFERRED = ROSETTA_TYPED_FEATURE__IS_TYPE_INFERRED;

	/**
	 * The number of structural features of the '<em>Record Feature</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_RECORD_FEATURE_FEATURE_COUNT = ROSETTA_TYPED_FEATURE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaExternalFunctionImpl <em>External Function</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaExternalFunctionImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaExternalFunction()
	 * @generated
	 */
	int ROSETTA_EXTERNAL_FUNCTION = 21;

	/**
	 * The feature id for the '<em><b>Model</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXTERNAL_FUNCTION__MODEL = ROSETTA_ROOT_ELEMENT__MODEL;

	/**
	 * The feature id for the '<em><b>Type Call</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXTERNAL_FUNCTION__TYPE_CALL = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Is Type Inferred</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXTERNAL_FUNCTION__IS_TYPE_INFERRED = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXTERNAL_FUNCTION__NAME = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Definition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXTERNAL_FUNCTION__DEFINITION = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Parameters</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXTERNAL_FUNCTION__PARAMETERS = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>External Function</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXTERNAL_FUNCTION_FEATURE_COUNT = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaParameterImpl <em>Parameter</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaParameterImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaParameter()
	 * @generated
	 */
	int ROSETTA_PARAMETER = 22;

	/**
	 * The feature id for the '<em><b>Type Call</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_PARAMETER__TYPE_CALL = ROSETTA_TYPED__TYPE_CALL;

	/**
	 * The feature id for the '<em><b>Is Type Inferred</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_PARAMETER__IS_TYPE_INFERRED = ROSETTA_TYPED__IS_TYPE_INFERRED;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_PARAMETER__NAME = ROSETTA_TYPED_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Is Array</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_PARAMETER__IS_ARRAY = ROSETTA_TYPED_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Parameter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_PARAMETER_FEATURE_COUNT = ROSETTA_TYPED_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaTypeAliasImpl <em>Type Alias</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaTypeAliasImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaTypeAlias()
	 * @generated
	 */
	int ROSETTA_TYPE_ALIAS = 23;

	/**
	 * The feature id for the '<em><b>Model</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_TYPE_ALIAS__MODEL = ROSETTA_ROOT_ELEMENT__MODEL;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_TYPE_ALIAS__NAME = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Type Call</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_TYPE_ALIAS__TYPE_CALL = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Is Type Inferred</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_TYPE_ALIAS__IS_TYPE_INFERRED = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Definition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_TYPE_ALIAS__DEFINITION = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Parameters</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_TYPE_ALIAS__PARAMETERS = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Type Alias</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_TYPE_ALIAS_FEATURE_COUNT = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaMetaTypeImpl <em>Meta Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaMetaTypeImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaMetaType()
	 * @generated
	 */
	int ROSETTA_META_TYPE = 24;

	/**
	 * The feature id for the '<em><b>Model</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_META_TYPE__MODEL = ROSETTA_ROOT_ELEMENT__MODEL;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_META_TYPE__NAME = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Get Name Or Default</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_META_TYPE__GET_NAME_OR_DEFAULT = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Type Call</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_META_TYPE__TYPE_CALL = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Is Type Inferred</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_META_TYPE__IS_TYPE_INFERRED = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Meta Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_META_TYPE_FEATURE_COUNT = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaEnumerationImpl <em>Enumeration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaEnumerationImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaEnumeration()
	 * @generated
	 */
	int ROSETTA_ENUMERATION = 25;

	/**
	 * The feature id for the '<em><b>Model</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_ENUMERATION__MODEL = ROSETTA_ROOT_ELEMENT__MODEL;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_ENUMERATION__NAME = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Definition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_ENUMERATION__DEFINITION = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>References</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_ENUMERATION__REFERENCES = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Super Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_ENUMERATION__SUPER_TYPE = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Synonyms</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_ENUMERATION__SYNONYMS = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Enum Values</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_ENUMERATION__ENUM_VALUES = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Enumeration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_ENUMERATION_FEATURE_COUNT = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaEnumValueImpl <em>Enum Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaEnumValueImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaEnumValue()
	 * @generated
	 */
	int ROSETTA_ENUM_VALUE = 26;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_ENUM_VALUE__NAME = ROSETTA_NAMED__NAME;

	/**
	 * The feature id for the '<em><b>Definition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_ENUM_VALUE__DEFINITION = ROSETTA_NAMED_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Get Name Or Default</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_ENUM_VALUE__GET_NAME_OR_DEFAULT = ROSETTA_NAMED_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>References</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_ENUM_VALUE__REFERENCES = ROSETTA_NAMED_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Display</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_ENUM_VALUE__DISPLAY = ROSETTA_NAMED_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Enum Synonyms</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_ENUM_VALUE__ENUM_SYNONYMS = ROSETTA_NAMED_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Enumeration</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_ENUM_VALUE__ENUMERATION = ROSETTA_NAMED_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Enum Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_ENUM_VALUE_FEATURE_COUNT = ROSETTA_NAMED_FEATURE_COUNT + 6;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.RosettaMapTest <em>Map Test</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.RosettaMapTest
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaMapTest()
	 * @generated
	 */
	int ROSETTA_MAP_TEST = 43;

	/**
	 * The number of structural features of the '<em>Map Test</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_MAP_TEST_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.RosettaMapTestExpression <em>Map Test Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.RosettaMapTestExpression
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaMapTestExpression()
	 * @generated
	 */
	int ROSETTA_MAP_TEST_EXPRESSION = 44;

	/**
	 * The number of structural features of the '<em>Map Test Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_MAP_TEST_EXPRESSION_FEATURE_COUNT = ROSETTA_MAP_TEST_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaEnumValueReferenceImpl <em>Enum Value Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaEnumValueReferenceImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaEnumValueReference()
	 * @generated
	 */
	int ROSETTA_ENUM_VALUE_REFERENCE = 27;

	/**
	 * The feature id for the '<em><b>Enumeration</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_ENUM_VALUE_REFERENCE__ENUMERATION = ROSETTA_MAP_TEST_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_ENUM_VALUE_REFERENCE__VALUE = ROSETTA_MAP_TEST_EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Enum Value Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_ENUM_VALUE_REFERENCE_FEATURE_COUNT = ROSETTA_MAP_TEST_EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaCardinalityImpl <em>Cardinality</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaCardinalityImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaCardinality()
	 * @generated
	 */
	int ROSETTA_CARDINALITY = 28;

	/**
	 * The feature id for the '<em><b>Inf</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_CARDINALITY__INF = 0;

	/**
	 * The feature id for the '<em><b>Sup</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_CARDINALITY__SUP = 1;

	/**
	 * The feature id for the '<em><b>Unbounded</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_CARDINALITY__UNBOUNDED = 2;

	/**
	 * The feature id for the '<em><b>Is Many</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_CARDINALITY__IS_MANY = 3;

	/**
	 * The feature id for the '<em><b>Empty</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_CARDINALITY__EMPTY = 4;

	/**
	 * The feature id for the '<em><b>Optional</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_CARDINALITY__OPTIONAL = 5;

	/**
	 * The feature id for the '<em><b>Singular</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_CARDINALITY__SINGULAR = 6;

	/**
	 * The feature id for the '<em><b>Plural</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_CARDINALITY__PLURAL = 7;

	/**
	 * The number of structural features of the '<em>Cardinality</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_CARDINALITY_FEATURE_COUNT = 8;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaSynonymBaseImpl <em>Synonym Base</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaSynonymBaseImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaSynonymBase()
	 * @generated
	 */
	int ROSETTA_SYNONYM_BASE = 29;

	/**
	 * The feature id for the '<em><b>Sources</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_SYNONYM_BASE__SOURCES = 0;

	/**
	 * The number of structural features of the '<em>Synonym Base</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_SYNONYM_BASE_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaSynonymValueBaseImpl <em>Synonym Value Base</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaSynonymValueBaseImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaSynonymValueBase()
	 * @generated
	 */
	int ROSETTA_SYNONYM_VALUE_BASE = 30;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_SYNONYM_VALUE_BASE__NAME = 0;

	/**
	 * The feature id for the '<em><b>Ref Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_SYNONYM_VALUE_BASE__REF_TYPE = 1;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_SYNONYM_VALUE_BASE__VALUE = 2;

	/**
	 * The feature id for the '<em><b>Path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_SYNONYM_VALUE_BASE__PATH = 3;

	/**
	 * The feature id for the '<em><b>Maps</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_SYNONYM_VALUE_BASE__MAPS = 4;

	/**
	 * The number of structural features of the '<em>Synonym Value Base</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_SYNONYM_VALUE_BASE_FEATURE_COUNT = 5;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaClassSynonymImpl <em>Class Synonym</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaClassSynonymImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaClassSynonym()
	 * @generated
	 */
	int ROSETTA_CLASS_SYNONYM = 31;

	/**
	 * The feature id for the '<em><b>Sources</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_CLASS_SYNONYM__SOURCES = ROSETTA_SYNONYM_BASE__SOURCES;

	/**
	 * The feature id for the '<em><b>Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_CLASS_SYNONYM__VALUE = ROSETTA_SYNONYM_BASE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Meta Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_CLASS_SYNONYM__META_VALUE = ROSETTA_SYNONYM_BASE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Class Synonym</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_CLASS_SYNONYM_FEATURE_COUNT = ROSETTA_SYNONYM_BASE_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaSynonymImpl <em>Synonym</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaSynonymImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaSynonym()
	 * @generated
	 */
	int ROSETTA_SYNONYM = 32;

	/**
	 * The feature id for the '<em><b>Sources</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_SYNONYM__SOURCES = ROSETTA_SYNONYM_BASE__SOURCES;

	/**
	 * The feature id for the '<em><b>Body</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_SYNONYM__BODY = ROSETTA_SYNONYM_BASE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Synonym</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_SYNONYM_FEATURE_COUNT = ROSETTA_SYNONYM_BASE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaSynonymBodyImpl <em>Synonym Body</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaSynonymBodyImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaSynonymBody()
	 * @generated
	 */
	int ROSETTA_SYNONYM_BODY = 33;

	/**
	 * The feature id for the '<em><b>Values</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_SYNONYM_BODY__VALUES = 0;

	/**
	 * The feature id for the '<em><b>Mapping Logic</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_SYNONYM_BODY__MAPPING_LOGIC = 1;

	/**
	 * The feature id for the '<em><b>Hints</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_SYNONYM_BODY__HINTS = 2;

	/**
	 * The feature id for the '<em><b>Merge</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_SYNONYM_BODY__MERGE = 3;

	/**
	 * The feature id for the '<em><b>Meta Values</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_SYNONYM_BODY__META_VALUES = 4;

	/**
	 * The feature id for the '<em><b>Mapper</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_SYNONYM_BODY__MAPPER = 5;

	/**
	 * The feature id for the '<em><b>Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_SYNONYM_BODY__FORMAT = 6;

	/**
	 * The feature id for the '<em><b>Pattern Match</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_SYNONYM_BODY__PATTERN_MATCH = 7;

	/**
	 * The feature id for the '<em><b>Pattern Replace</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_SYNONYM_BODY__PATTERN_REPLACE = 8;

	/**
	 * The feature id for the '<em><b>Remove Html</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_SYNONYM_BODY__REMOVE_HTML = 9;

	/**
	 * The number of structural features of the '<em>Synonym Body</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_SYNONYM_BODY_FEATURE_COUNT = 10;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaMergeSynonymValueImpl <em>Merge Synonym Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaMergeSynonymValueImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaMergeSynonymValue()
	 * @generated
	 */
	int ROSETTA_MERGE_SYNONYM_VALUE = 34;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_MERGE_SYNONYM_VALUE__NAME = 0;

	/**
	 * The feature id for the '<em><b>Exclude Path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_MERGE_SYNONYM_VALUE__EXCLUDE_PATH = 1;

	/**
	 * The number of structural features of the '<em>Merge Synonym Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_MERGE_SYNONYM_VALUE_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaEnumSynonymImpl <em>Enum Synonym</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaEnumSynonymImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaEnumSynonym()
	 * @generated
	 */
	int ROSETTA_ENUM_SYNONYM = 35;

	/**
	 * The feature id for the '<em><b>Sources</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_ENUM_SYNONYM__SOURCES = ROSETTA_SYNONYM_BASE__SOURCES;

	/**
	 * The feature id for the '<em><b>Definition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_ENUM_SYNONYM__DEFINITION = ROSETTA_SYNONYM_BASE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Synonym Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_ENUM_SYNONYM__SYNONYM_VALUE = ROSETTA_SYNONYM_BASE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Pattern Match</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_ENUM_SYNONYM__PATTERN_MATCH = ROSETTA_SYNONYM_BASE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Pattern Replace</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_ENUM_SYNONYM__PATTERN_REPLACE = ROSETTA_SYNONYM_BASE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Remove Html</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_ENUM_SYNONYM__REMOVE_HTML = ROSETTA_SYNONYM_BASE_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Enum Synonym</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_ENUM_SYNONYM_FEATURE_COUNT = ROSETTA_SYNONYM_BASE_FEATURE_COUNT + 5;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaDocReferenceImpl <em>Doc Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaDocReferenceImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaDocReference()
	 * @generated
	 */
	int ROSETTA_DOC_REFERENCE = 36;

	/**
	 * The feature id for the '<em><b>Doc Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_DOC_REFERENCE__DOC_REFERENCE = 0;

	/**
	 * The feature id for the '<em><b>Rationales</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_DOC_REFERENCE__RATIONALES = 1;

	/**
	 * The feature id for the '<em><b>Structured Provision</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_DOC_REFERENCE__STRUCTURED_PROVISION = 2;

	/**
	 * The feature id for the '<em><b>Provision</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_DOC_REFERENCE__PROVISION = 3;

	/**
	 * The feature id for the '<em><b>Reported Field</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_DOC_REFERENCE__REPORTED_FIELD = 4;

	/**
	 * The feature id for the '<em><b>Extraneous Segments</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_DOC_REFERENCE__EXTRANEOUS_SEGMENTS = 5;

	/**
	 * The number of structural features of the '<em>Doc Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_DOC_REFERENCE_FEATURE_COUNT = 6;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RegulatoryDocumentReferenceImpl <em>Regulatory Document Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RegulatoryDocumentReferenceImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRegulatoryDocumentReference()
	 * @generated
	 */
	int REGULATORY_DOCUMENT_REFERENCE = 37;

	/**
	 * The feature id for the '<em><b>Body</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REGULATORY_DOCUMENT_REFERENCE__BODY = 0;

	/**
	 * The feature id for the '<em><b>Corpus List</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REGULATORY_DOCUMENT_REFERENCE__CORPUS_LIST = 1;

	/**
	 * The feature id for the '<em><b>Segments</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REGULATORY_DOCUMENT_REFERENCE__SEGMENTS = 2;

	/**
	 * The number of structural features of the '<em>Regulatory Document Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REGULATORY_DOCUMENT_REFERENCE_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaSegmentRefImpl <em>Segment Ref</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaSegmentRefImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaSegmentRef()
	 * @generated
	 */
	int ROSETTA_SEGMENT_REF = 38;

	/**
	 * The feature id for the '<em><b>Segment</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_SEGMENT_REF__SEGMENT = 0;

	/**
	 * The feature id for the '<em><b>Segment Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_SEGMENT_REF__SEGMENT_REF = 1;

	/**
	 * The number of structural features of the '<em>Segment Ref</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_SEGMENT_REF_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.DocumentRationaleImpl <em>Document Rationale</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.DocumentRationaleImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getDocumentRationale()
	 * @generated
	 */
	int DOCUMENT_RATIONALE = 39;

	/**
	 * The feature id for the '<em><b>Rationale</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_RATIONALE__RATIONALE = 0;

	/**
	 * The feature id for the '<em><b>Rationale Author</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_RATIONALE__RATIONALE_AUTHOR = 1;

	/**
	 * The number of structural features of the '<em>Document Rationale</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_RATIONALE_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaBodyImpl <em>Body</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaBodyImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaBody()
	 * @generated
	 */
	int ROSETTA_BODY = 40;

	/**
	 * The feature id for the '<em><b>Model</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_BODY__MODEL = ROSETTA_ROOT_ELEMENT__MODEL;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_BODY__NAME = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Definition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_BODY__DEFINITION = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Body Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_BODY__BODY_TYPE = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Body</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_BODY_FEATURE_COUNT = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaCorpusImpl <em>Corpus</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaCorpusImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaCorpus()
	 * @generated
	 */
	int ROSETTA_CORPUS = 41;

	/**
	 * The feature id for the '<em><b>Model</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_CORPUS__MODEL = ROSETTA_ROOT_ELEMENT__MODEL;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_CORPUS__NAME = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Definition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_CORPUS__DEFINITION = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Corpus Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_CORPUS__CORPUS_TYPE = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_CORPUS__DISPLAY_NAME = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Body</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_CORPUS__BODY = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Corpus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_CORPUS_FEATURE_COUNT = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaSegmentImpl <em>Segment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaSegmentImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaSegment()
	 * @generated
	 */
	int ROSETTA_SEGMENT = 42;

	/**
	 * The feature id for the '<em><b>Model</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_SEGMENT__MODEL = ROSETTA_ROOT_ELEMENT__MODEL;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_SEGMENT__NAME = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Segment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_SEGMENT_FEATURE_COUNT = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaMapPathValueImpl <em>Map Path Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaMapPathValueImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaMapPathValue()
	 * @generated
	 */
	int ROSETTA_MAP_PATH_VALUE = 45;

	/**
	 * The feature id for the '<em><b>Path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_MAP_PATH_VALUE__PATH = ROSETTA_MAP_TEST_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Map Path Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_MAP_PATH_VALUE_FEATURE_COUNT = ROSETTA_MAP_TEST_EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaMapTestExistsExpressionImpl <em>Map Test Exists Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaMapTestExistsExpressionImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaMapTestExistsExpression()
	 * @generated
	 */
	int ROSETTA_MAP_TEST_EXISTS_EXPRESSION = 46;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_MAP_TEST_EXISTS_EXPRESSION__ARGUMENT = ROSETTA_MAP_TEST_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Map Test Exists Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_MAP_TEST_EXISTS_EXPRESSION_FEATURE_COUNT = ROSETTA_MAP_TEST_EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaMapTestAbsentExpressionImpl <em>Map Test Absent Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaMapTestAbsentExpressionImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaMapTestAbsentExpression()
	 * @generated
	 */
	int ROSETTA_MAP_TEST_ABSENT_EXPRESSION = 47;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_MAP_TEST_ABSENT_EXPRESSION__ARGUMENT = ROSETTA_MAP_TEST_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Map Test Absent Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_MAP_TEST_ABSENT_EXPRESSION_FEATURE_COUNT = ROSETTA_MAP_TEST_EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaMapTestEqualityOperationImpl <em>Map Test Equality Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaMapTestEqualityOperationImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaMapTestEqualityOperation()
	 * @generated
	 */
	int ROSETTA_MAP_TEST_EQUALITY_OPERATION = 48;

	/**
	 * The feature id for the '<em><b>Left</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_MAP_TEST_EQUALITY_OPERATION__LEFT = ROSETTA_MAP_TEST_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Right</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_MAP_TEST_EQUALITY_OPERATION__RIGHT = ROSETTA_MAP_TEST_EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_MAP_TEST_EQUALITY_OPERATION__OPERATOR = ROSETTA_MAP_TEST_EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Map Test Equality Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_MAP_TEST_EQUALITY_OPERATION_FEATURE_COUNT = ROSETTA_MAP_TEST_EXPRESSION_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaMapTestFuncImpl <em>Map Test Func</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaMapTestFuncImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaMapTestFunc()
	 * @generated
	 */
	int ROSETTA_MAP_TEST_FUNC = 49;

	/**
	 * The feature id for the '<em><b>Func</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_MAP_TEST_FUNC__FUNC = ROSETTA_MAP_TEST_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Predicate Path</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_MAP_TEST_FUNC__PREDICATE_PATH = ROSETTA_MAP_TEST_EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Map Test Func</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_MAP_TEST_FUNC_FEATURE_COUNT = ROSETTA_MAP_TEST_EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.RosettaAttributeReferenceSegment <em>Attribute Reference Segment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.RosettaAttributeReferenceSegment
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaAttributeReferenceSegment()
	 * @generated
	 */
	int ROSETTA_ATTRIBUTE_REFERENCE_SEGMENT = 50;

	/**
	 * The number of structural features of the '<em>Attribute Reference Segment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_ATTRIBUTE_REFERENCE_SEGMENT_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaDataReferenceImpl <em>Data Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaDataReferenceImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaDataReference()
	 * @generated
	 */
	int ROSETTA_DATA_REFERENCE = 51;

	/**
	 * The feature id for the '<em><b>Data</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_DATA_REFERENCE__DATA = ROSETTA_ATTRIBUTE_REFERENCE_SEGMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Data Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_DATA_REFERENCE_FEATURE_COUNT = ROSETTA_ATTRIBUTE_REFERENCE_SEGMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaAttributeReferenceImpl <em>Attribute Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaAttributeReferenceImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaAttributeReference()
	 * @generated
	 */
	int ROSETTA_ATTRIBUTE_REFERENCE = 52;

	/**
	 * The feature id for the '<em><b>Receiver</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_ATTRIBUTE_REFERENCE__RECEIVER = ROSETTA_ATTRIBUTE_REFERENCE_SEGMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Attribute</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_ATTRIBUTE_REFERENCE__ATTRIBUTE = ROSETTA_ATTRIBUTE_REFERENCE_SEGMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Attribute Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_ATTRIBUTE_REFERENCE_FEATURE_COUNT = ROSETTA_ATTRIBUTE_REFERENCE_SEGMENT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaMappingImpl <em>Mapping</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaMappingImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaMapping()
	 * @generated
	 */
	int ROSETTA_MAPPING = 53;

	/**
	 * The feature id for the '<em><b>Instances</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_MAPPING__INSTANCES = 0;

	/**
	 * The number of structural features of the '<em>Mapping</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_MAPPING_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaMappingInstanceImpl <em>Mapping Instance</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaMappingInstanceImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaMappingInstance()
	 * @generated
	 */
	int ROSETTA_MAPPING_INSTANCE = 54;

	/**
	 * The feature id for the '<em><b>Set</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_MAPPING_INSTANCE__SET = 0;

	/**
	 * The feature id for the '<em><b>When</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_MAPPING_INSTANCE__WHEN = 1;

	/**
	 * The feature id for the '<em><b>Default</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_MAPPING_INSTANCE__DEFAULT = 2;

	/**
	 * The number of structural features of the '<em>Mapping Instance</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_MAPPING_INSTANCE_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaMappingPathTestsImpl <em>Mapping Path Tests</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaMappingPathTestsImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaMappingPathTests()
	 * @generated
	 */
	int ROSETTA_MAPPING_PATH_TESTS = 55;

	/**
	 * The feature id for the '<em><b>Tests</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_MAPPING_PATH_TESTS__TESTS = 0;

	/**
	 * The number of structural features of the '<em>Mapping Path Tests</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_MAPPING_PATH_TESTS_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaMapPathImpl <em>Map Path</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaMapPathImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaMapPath()
	 * @generated
	 */
	int ROSETTA_MAP_PATH = 56;

	/**
	 * The feature id for the '<em><b>Path</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_MAP_PATH__PATH = ROSETTA_MAP_TEST_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Map Path</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_MAP_PATH_FEATURE_COUNT = ROSETTA_MAP_TEST_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaMapRosettaPathImpl <em>Map Rosetta Path</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaMapRosettaPathImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaMapRosettaPath()
	 * @generated
	 */
	int ROSETTA_MAP_ROSETTA_PATH = 57;

	/**
	 * The feature id for the '<em><b>Path</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_MAP_ROSETTA_PATH__PATH = ROSETTA_MAP_TEST_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Map Rosetta Path</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_MAP_ROSETTA_PATH_FEATURE_COUNT = ROSETTA_MAP_TEST_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaQualifiableConfigurationImpl <em>Qualifiable Configuration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaQualifiableConfigurationImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaQualifiableConfiguration()
	 * @generated
	 */
	int ROSETTA_QUALIFIABLE_CONFIGURATION = 58;

	/**
	 * The feature id for the '<em><b>QType</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_QUALIFIABLE_CONFIGURATION__QTYPE = 0;

	/**
	 * The feature id for the '<em><b>Model</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_QUALIFIABLE_CONFIGURATION__MODEL = 1;

	/**
	 * The feature id for the '<em><b>Rosetta Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_QUALIFIABLE_CONFIGURATION__ROSETTA_CLASS = 2;

	/**
	 * The number of structural features of the '<em>Qualifiable Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_QUALIFIABLE_CONFIGURATION_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.ExternalAnnotationSourceImpl <em>External Annotation Source</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.ExternalAnnotationSourceImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getExternalAnnotationSource()
	 * @generated
	 */
	int EXTERNAL_ANNOTATION_SOURCE = 59;

	/**
	 * The feature id for the '<em><b>Model</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ANNOTATION_SOURCE__MODEL = ROSETTA_ROOT_ELEMENT__MODEL;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ANNOTATION_SOURCE__NAME = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>External Classes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ANNOTATION_SOURCE__EXTERNAL_CLASSES = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>External Enums</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ANNOTATION_SOURCE__EXTERNAL_ENUMS = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>External Annotation Source</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ANNOTATION_SOURCE_FEATURE_COUNT = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaExternalRefImpl <em>External Ref</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaExternalRefImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaExternalRef()
	 * @generated
	 */
	int ROSETTA_EXTERNAL_REF = 60;

	/**
	 * The number of structural features of the '<em>External Ref</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXTERNAL_REF_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaExternalClassImpl <em>External Class</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaExternalClassImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaExternalClass()
	 * @generated
	 */
	int ROSETTA_EXTERNAL_CLASS = 61;

	/**
	 * The feature id for the '<em><b>Data</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXTERNAL_CLASS__DATA = ROSETTA_EXTERNAL_REF_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>External Class Synonyms</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXTERNAL_CLASS__EXTERNAL_CLASS_SYNONYMS = ROSETTA_EXTERNAL_REF_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Regular Attributes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXTERNAL_CLASS__REGULAR_ATTRIBUTES = ROSETTA_EXTERNAL_REF_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>External Class</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXTERNAL_CLASS_FEATURE_COUNT = ROSETTA_EXTERNAL_REF_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaExternalEnumImpl <em>External Enum</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaExternalEnumImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaExternalEnum()
	 * @generated
	 */
	int ROSETTA_EXTERNAL_ENUM = 62;

	/**
	 * The feature id for the '<em><b>Enumeration</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXTERNAL_ENUM__ENUMERATION = ROSETTA_EXTERNAL_REF_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Regular Values</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXTERNAL_ENUM__REGULAR_VALUES = ROSETTA_EXTERNAL_REF_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>External Enum</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXTERNAL_ENUM_FEATURE_COUNT = ROSETTA_EXTERNAL_REF_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaExternalRegularAttributeImpl <em>External Regular Attribute</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaExternalRegularAttributeImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaExternalRegularAttribute()
	 * @generated
	 */
	int ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE = 63;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE__OPERATOR = 0;

	/**
	 * The feature id for the '<em><b>Attribute Ref</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE__ATTRIBUTE_REF = 1;

	/**
	 * The feature id for the '<em><b>External Synonyms</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE__EXTERNAL_SYNONYMS = 2;

	/**
	 * The feature id for the '<em><b>External Rule Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE__EXTERNAL_RULE_REFERENCE = 3;

	/**
	 * The number of structural features of the '<em>External Regular Attribute</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE_FEATURE_COUNT = 4;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaExternalEnumValueImpl <em>External Enum Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaExternalEnumValueImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaExternalEnumValue()
	 * @generated
	 */
	int ROSETTA_EXTERNAL_ENUM_VALUE = 64;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXTERNAL_ENUM_VALUE__OPERATOR = 0;

	/**
	 * The feature id for the '<em><b>Enum Ref</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXTERNAL_ENUM_VALUE__ENUM_REF = 1;

	/**
	 * The feature id for the '<em><b>External Enum Synonyms</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXTERNAL_ENUM_VALUE__EXTERNAL_ENUM_SYNONYMS = 2;

	/**
	 * The number of structural features of the '<em>External Enum Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXTERNAL_ENUM_VALUE_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaExternalClassSynonymImpl <em>External Class Synonym</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaExternalClassSynonymImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaExternalClassSynonym()
	 * @generated
	 */
	int ROSETTA_EXTERNAL_CLASS_SYNONYM = 65;

	/**
	 * The feature id for the '<em><b>Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXTERNAL_CLASS_SYNONYM__VALUE = 0;

	/**
	 * The feature id for the '<em><b>Meta Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXTERNAL_CLASS_SYNONYM__META_VALUE = 1;

	/**
	 * The number of structural features of the '<em>External Class Synonym</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXTERNAL_CLASS_SYNONYM_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaExternalSynonymImpl <em>External Synonym</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaExternalSynonymImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaExternalSynonym()
	 * @generated
	 */
	int ROSETTA_EXTERNAL_SYNONYM = 66;

	/**
	 * The feature id for the '<em><b>Body</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXTERNAL_SYNONYM__BODY = 0;

	/**
	 * The number of structural features of the '<em>External Synonym</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXTERNAL_SYNONYM_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaExternalSynonymSourceImpl <em>External Synonym Source</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaExternalSynonymSourceImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaExternalSynonymSource()
	 * @generated
	 */
	int ROSETTA_EXTERNAL_SYNONYM_SOURCE = 67;

	/**
	 * The feature id for the '<em><b>Model</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXTERNAL_SYNONYM_SOURCE__MODEL = EXTERNAL_ANNOTATION_SOURCE__MODEL;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXTERNAL_SYNONYM_SOURCE__NAME = EXTERNAL_ANNOTATION_SOURCE__NAME;

	/**
	 * The feature id for the '<em><b>External Classes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXTERNAL_SYNONYM_SOURCE__EXTERNAL_CLASSES = EXTERNAL_ANNOTATION_SOURCE__EXTERNAL_CLASSES;

	/**
	 * The feature id for the '<em><b>External Enums</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXTERNAL_SYNONYM_SOURCE__EXTERNAL_ENUMS = EXTERNAL_ANNOTATION_SOURCE__EXTERNAL_ENUMS;

	/**
	 * The feature id for the '<em><b>Super Sources</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXTERNAL_SYNONYM_SOURCE__SUPER_SOURCES = EXTERNAL_ANNOTATION_SOURCE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>External Synonym Source</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXTERNAL_SYNONYM_SOURCE_FEATURE_COUNT = EXTERNAL_ANNOTATION_SOURCE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaExternalRuleSourceImpl <em>External Rule Source</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaExternalRuleSourceImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaExternalRuleSource()
	 * @generated
	 */
	int ROSETTA_EXTERNAL_RULE_SOURCE = 68;

	/**
	 * The feature id for the '<em><b>Model</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXTERNAL_RULE_SOURCE__MODEL = EXTERNAL_ANNOTATION_SOURCE__MODEL;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXTERNAL_RULE_SOURCE__NAME = EXTERNAL_ANNOTATION_SOURCE__NAME;

	/**
	 * The feature id for the '<em><b>External Classes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXTERNAL_RULE_SOURCE__EXTERNAL_CLASSES = EXTERNAL_ANNOTATION_SOURCE__EXTERNAL_CLASSES;

	/**
	 * The feature id for the '<em><b>External Enums</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXTERNAL_RULE_SOURCE__EXTERNAL_ENUMS = EXTERNAL_ANNOTATION_SOURCE__EXTERNAL_ENUMS;

	/**
	 * The feature id for the '<em><b>Super Sources</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXTERNAL_RULE_SOURCE__SUPER_SOURCES = EXTERNAL_ANNOTATION_SOURCE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>External Rule Source</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXTERNAL_RULE_SOURCE_FEATURE_COUNT = EXTERNAL_ANNOTATION_SOURCE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaReportImpl <em>Report</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaReportImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaReport()
	 * @generated
	 */
	int ROSETTA_REPORT = 69;

	/**
	 * The feature id for the '<em><b>Model</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_REPORT__MODEL = ROSETTA_ROOT_ELEMENT__MODEL;

	/**
	 * The feature id for the '<em><b>Regulatory Body</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_REPORT__REGULATORY_BODY = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Eligibility Rules</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_REPORT__ELIGIBILITY_RULES = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Reporting Standard</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_REPORT__REPORTING_STANDARD = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Input Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_REPORT__INPUT_TYPE = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Report Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_REPORT__REPORT_TYPE = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Rule Source</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_REPORT__RULE_SOURCE = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Report</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_REPORT_FEATURE_COUNT = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaRuleImpl <em>Rule</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaRuleImpl
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaRule()
	 * @generated
	 */
	int ROSETTA_RULE = 70;

	/**
	 * The feature id for the '<em><b>Model</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_RULE__MODEL = ROSETTA_ROOT_ELEMENT__MODEL;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_RULE__NAME = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Definition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_RULE__DEFINITION = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>References</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_RULE__REFERENCES = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Eligibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_RULE__ELIGIBILITY = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_RULE__EXPRESSION = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_RULE__IDENTIFIER = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Input</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_RULE__INPUT = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the '<em>Rule</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_RULE_FEATURE_COUNT = ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.RosettaSynonymRef <em>Synonym Ref</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.RosettaSynonymRef
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaSynonymRef()
	 * @generated
	 */
	int ROSETTA_SYNONYM_REF = 71;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.RosettaQualifiableType <em>Qualifiable Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.RosettaQualifiableType
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaQualifiableType()
	 * @generated
	 */
	int ROSETTA_QUALIFIABLE_TYPE = 72;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.ExternalValueOperator <em>External Value Operator</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.ExternalValueOperator
	 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getExternalValueOperator()
	 * @generated
	 */
	int EXTERNAL_VALUE_OPERATOR = 73;


	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaModel <em>Model</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Model</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaModel
	 * @generated
	 */
	EClass getRosettaModel();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaModel#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaModel#getName()
	 * @see #getRosettaModel()
	 * @generated
	 */
	EAttribute getRosettaModel_Name();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaModel#getVersion <em>Version</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Version</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaModel#getVersion()
	 * @see #getRosettaModel()
	 * @generated
	 */
	EAttribute getRosettaModel_Version();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaModel#isOverridden <em>Overridden</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Overridden</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaModel#isOverridden()
	 * @see #getRosettaModel()
	 * @generated
	 */
	EAttribute getRosettaModel_Overridden();

	/**
	 * Returns the meta object for the containment reference list '{@link com.regnosys.rosetta.rosetta.RosettaModel#getImports <em>Imports</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Imports</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaModel#getImports()
	 * @see #getRosettaModel()
	 * @generated
	 */
	EReference getRosettaModel_Imports();

	/**
	 * Returns the meta object for the containment reference list '{@link com.regnosys.rosetta.rosetta.RosettaModel#getConfigurations <em>Configurations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Configurations</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaModel#getConfigurations()
	 * @see #getRosettaModel()
	 * @generated
	 */
	EReference getRosettaModel_Configurations();

	/**
	 * Returns the meta object for the containment reference list '{@link com.regnosys.rosetta.rosetta.RosettaModel#getElements <em>Elements</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Elements</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaModel#getElements()
	 * @see #getRosettaModel()
	 * @generated
	 */
	EReference getRosettaModel_Elements();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.Import <em>Import</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Import</em>'.
	 * @see com.regnosys.rosetta.rosetta.Import
	 * @generated
	 */
	EClass getImport();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.Import#getImportedNamespace <em>Imported Namespace</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Imported Namespace</em>'.
	 * @see com.regnosys.rosetta.rosetta.Import#getImportedNamespace()
	 * @see #getImport()
	 * @generated
	 */
	EAttribute getImport_ImportedNamespace();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaDefinable <em>Definable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Definable</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaDefinable
	 * @generated
	 */
	EClass getRosettaDefinable();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaDefinable#getDefinition <em>Definition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Definition</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaDefinable#getDefinition()
	 * @see #getRosettaDefinable()
	 * @generated
	 */
	EAttribute getRosettaDefinable_Definition();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaNamed <em>Named</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Named</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaNamed
	 * @generated
	 */
	EClass getRosettaNamed();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaNamed#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaNamed#getName()
	 * @see #getRosettaNamed()
	 * @generated
	 */
	EAttribute getRosettaNamed_Name();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaTyped <em>Typed</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Typed</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaTyped
	 * @generated
	 */
	EClass getRosettaTyped();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.RosettaTyped#getTypeCall <em>Type Call</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Type Call</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaTyped#getTypeCall()
	 * @see #getRosettaTyped()
	 * @generated
	 */
	EReference getRosettaTyped_TypeCall();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaTyped#isIsTypeInferred <em>Is Type Inferred</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Is Type Inferred</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaTyped#isIsTypeInferred()
	 * @see #getRosettaTyped()
	 * @generated
	 */
	EAttribute getRosettaTyped_IsTypeInferred();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaFeature <em>Feature</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Feature</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaFeature
	 * @generated
	 */
	EClass getRosettaFeature();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaFeature#getGetNameOrDefault <em>Get Name Or Default</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Get Name Or Default</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaFeature#getGetNameOrDefault()
	 * @see #getRosettaFeature()
	 * @generated
	 */
	EAttribute getRosettaFeature_GetNameOrDefault();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaTypedFeature <em>Typed Feature</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Typed Feature</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaTypedFeature
	 * @generated
	 */
	EClass getRosettaTypedFeature();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaSymbol <em>Symbol</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Symbol</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaSymbol
	 * @generated
	 */
	EClass getRosettaSymbol();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaCallableWithArgs <em>Callable With Args</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Callable With Args</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaCallableWithArgs
	 * @generated
	 */
	EClass getRosettaCallableWithArgs();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaRootElement <em>Root Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Root Element</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaRootElement
	 * @generated
	 */
	EClass getRosettaRootElement();

	/**
	 * Returns the meta object for the container reference '{@link com.regnosys.rosetta.rosetta.RosettaRootElement#getModel <em>Model</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Model</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaRootElement#getModel()
	 * @see #getRosettaRootElement()
	 * @generated
	 */
	EReference getRosettaRootElement_Model();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaFeatureOwner <em>Feature Owner</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Feature Owner</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaFeatureOwner
	 * @generated
	 */
	EClass getRosettaFeatureOwner();

	/**
	 * Returns the meta object for the containment reference list '{@link com.regnosys.rosetta.rosetta.RosettaFeatureOwner#getFeatures <em>Features</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Features</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaFeatureOwner#getFeatures()
	 * @see #getRosettaFeatureOwner()
	 * @generated
	 */
	EReference getRosettaFeatureOwner_Features();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Type</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaType
	 * @generated
	 */
	EClass getRosettaType();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.ParametrizedRosettaType <em>Parametrized Rosetta Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Parametrized Rosetta Type</em>'.
	 * @see com.regnosys.rosetta.rosetta.ParametrizedRosettaType
	 * @generated
	 */
	EClass getParametrizedRosettaType();

	/**
	 * Returns the meta object for the containment reference list '{@link com.regnosys.rosetta.rosetta.ParametrizedRosettaType#getParameters <em>Parameters</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Parameters</em>'.
	 * @see com.regnosys.rosetta.rosetta.ParametrizedRosettaType#getParameters()
	 * @see #getParametrizedRosettaType()
	 * @generated
	 */
	EReference getParametrizedRosettaType_Parameters();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.TypeCall <em>Type Call</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Type Call</em>'.
	 * @see com.regnosys.rosetta.rosetta.TypeCall
	 * @generated
	 */
	EClass getTypeCall();

	/**
	 * Returns the meta object for the reference '{@link com.regnosys.rosetta.rosetta.TypeCall#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Type</em>'.
	 * @see com.regnosys.rosetta.rosetta.TypeCall#getType()
	 * @see #getTypeCall()
	 * @generated
	 */
	EReference getTypeCall_Type();

	/**
	 * Returns the meta object for the containment reference list '{@link com.regnosys.rosetta.rosetta.TypeCall#getArguments <em>Arguments</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Arguments</em>'.
	 * @see com.regnosys.rosetta.rosetta.TypeCall#getArguments()
	 * @see #getTypeCall()
	 * @generated
	 */
	EReference getTypeCall_Arguments();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.TypeCallArgument <em>Type Call Argument</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Type Call Argument</em>'.
	 * @see com.regnosys.rosetta.rosetta.TypeCallArgument
	 * @generated
	 */
	EClass getTypeCallArgument();

	/**
	 * Returns the meta object for the reference '{@link com.regnosys.rosetta.rosetta.TypeCallArgument#getParameter <em>Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Parameter</em>'.
	 * @see com.regnosys.rosetta.rosetta.TypeCallArgument#getParameter()
	 * @see #getTypeCallArgument()
	 * @generated
	 */
	EReference getTypeCallArgument_Parameter();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.TypeCallArgument#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Value</em>'.
	 * @see com.regnosys.rosetta.rosetta.TypeCallArgument#getValue()
	 * @see #getTypeCallArgument()
	 * @generated
	 */
	EReference getTypeCallArgument_Value();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaBuiltinType <em>Builtin Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Builtin Type</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaBuiltinType
	 * @generated
	 */
	EClass getRosettaBuiltinType();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaBasicType <em>Basic Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Basic Type</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaBasicType
	 * @generated
	 */
	EClass getRosettaBasicType();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.TypeParameter <em>Type Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Type Parameter</em>'.
	 * @see com.regnosys.rosetta.rosetta.TypeParameter
	 * @generated
	 */
	EClass getTypeParameter();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaSynonymSource <em>Synonym Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Synonym Source</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaSynonymSource
	 * @generated
	 */
	EClass getRosettaSynonymSource();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaRecordType <em>Record Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Record Type</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaRecordType
	 * @generated
	 */
	EClass getRosettaRecordType();

	/**
	 * Returns the meta object for the containment reference list '{@link com.regnosys.rosetta.rosetta.RosettaRecordType#getFeatures <em>Features</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Features</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaRecordType#getFeatures()
	 * @see #getRosettaRecordType()
	 * @generated
	 */
	EReference getRosettaRecordType_Features();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaRecordFeature <em>Record Feature</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Record Feature</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaRecordFeature
	 * @generated
	 */
	EClass getRosettaRecordFeature();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaExternalFunction <em>External Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>External Function</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaExternalFunction
	 * @generated
	 */
	EClass getRosettaExternalFunction();

	/**
	 * Returns the meta object for the containment reference list '{@link com.regnosys.rosetta.rosetta.RosettaExternalFunction#getParameters <em>Parameters</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Parameters</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaExternalFunction#getParameters()
	 * @see #getRosettaExternalFunction()
	 * @generated
	 */
	EReference getRosettaExternalFunction_Parameters();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaParameter <em>Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Parameter</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaParameter
	 * @generated
	 */
	EClass getRosettaParameter();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaParameter#isIsArray <em>Is Array</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Is Array</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaParameter#isIsArray()
	 * @see #getRosettaParameter()
	 * @generated
	 */
	EAttribute getRosettaParameter_IsArray();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaTypeAlias <em>Type Alias</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Type Alias</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaTypeAlias
	 * @generated
	 */
	EClass getRosettaTypeAlias();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaMetaType <em>Meta Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Meta Type</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaMetaType
	 * @generated
	 */
	EClass getRosettaMetaType();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaEnumeration <em>Enumeration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Enumeration</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaEnumeration
	 * @generated
	 */
	EClass getRosettaEnumeration();

	/**
	 * Returns the meta object for the reference '{@link com.regnosys.rosetta.rosetta.RosettaEnumeration#getSuperType <em>Super Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Super Type</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaEnumeration#getSuperType()
	 * @see #getRosettaEnumeration()
	 * @generated
	 */
	EReference getRosettaEnumeration_SuperType();

	/**
	 * Returns the meta object for the containment reference list '{@link com.regnosys.rosetta.rosetta.RosettaEnumeration#getSynonyms <em>Synonyms</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Synonyms</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaEnumeration#getSynonyms()
	 * @see #getRosettaEnumeration()
	 * @generated
	 */
	EReference getRosettaEnumeration_Synonyms();

	/**
	 * Returns the meta object for the containment reference list '{@link com.regnosys.rosetta.rosetta.RosettaEnumeration#getEnumValues <em>Enum Values</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Enum Values</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaEnumeration#getEnumValues()
	 * @see #getRosettaEnumeration()
	 * @generated
	 */
	EReference getRosettaEnumeration_EnumValues();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaEnumValue <em>Enum Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Enum Value</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaEnumValue
	 * @generated
	 */
	EClass getRosettaEnumValue();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaEnumValue#getDisplay <em>Display</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Display</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaEnumValue#getDisplay()
	 * @see #getRosettaEnumValue()
	 * @generated
	 */
	EAttribute getRosettaEnumValue_Display();

	/**
	 * Returns the meta object for the containment reference list '{@link com.regnosys.rosetta.rosetta.RosettaEnumValue#getEnumSynonyms <em>Enum Synonyms</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Enum Synonyms</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaEnumValue#getEnumSynonyms()
	 * @see #getRosettaEnumValue()
	 * @generated
	 */
	EReference getRosettaEnumValue_EnumSynonyms();

	/**
	 * Returns the meta object for the container reference '{@link com.regnosys.rosetta.rosetta.RosettaEnumValue#getEnumeration <em>Enumeration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Enumeration</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaEnumValue#getEnumeration()
	 * @see #getRosettaEnumValue()
	 * @generated
	 */
	EReference getRosettaEnumValue_Enumeration();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaEnumValueReference <em>Enum Value Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Enum Value Reference</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaEnumValueReference
	 * @generated
	 */
	EClass getRosettaEnumValueReference();

	/**
	 * Returns the meta object for the reference '{@link com.regnosys.rosetta.rosetta.RosettaEnumValueReference#getEnumeration <em>Enumeration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Enumeration</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaEnumValueReference#getEnumeration()
	 * @see #getRosettaEnumValueReference()
	 * @generated
	 */
	EReference getRosettaEnumValueReference_Enumeration();

	/**
	 * Returns the meta object for the reference '{@link com.regnosys.rosetta.rosetta.RosettaEnumValueReference#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Value</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaEnumValueReference#getValue()
	 * @see #getRosettaEnumValueReference()
	 * @generated
	 */
	EReference getRosettaEnumValueReference_Value();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaCardinality <em>Cardinality</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Cardinality</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaCardinality
	 * @generated
	 */
	EClass getRosettaCardinality();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaCardinality#getInf <em>Inf</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Inf</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaCardinality#getInf()
	 * @see #getRosettaCardinality()
	 * @generated
	 */
	EAttribute getRosettaCardinality_Inf();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaCardinality#getSup <em>Sup</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Sup</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaCardinality#getSup()
	 * @see #getRosettaCardinality()
	 * @generated
	 */
	EAttribute getRosettaCardinality_Sup();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaCardinality#isUnbounded <em>Unbounded</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Unbounded</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaCardinality#isUnbounded()
	 * @see #getRosettaCardinality()
	 * @generated
	 */
	EAttribute getRosettaCardinality_Unbounded();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaCardinality#isIsMany <em>Is Many</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Is Many</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaCardinality#isIsMany()
	 * @see #getRosettaCardinality()
	 * @generated
	 */
	EAttribute getRosettaCardinality_IsMany();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaCardinality#isEmpty <em>Empty</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Empty</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaCardinality#isEmpty()
	 * @see #getRosettaCardinality()
	 * @generated
	 */
	EAttribute getRosettaCardinality_Empty();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaCardinality#isOptional <em>Optional</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Optional</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaCardinality#isOptional()
	 * @see #getRosettaCardinality()
	 * @generated
	 */
	EAttribute getRosettaCardinality_Optional();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaCardinality#isSingular <em>Singular</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Singular</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaCardinality#isSingular()
	 * @see #getRosettaCardinality()
	 * @generated
	 */
	EAttribute getRosettaCardinality_Singular();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaCardinality#isPlural <em>Plural</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Plural</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaCardinality#isPlural()
	 * @see #getRosettaCardinality()
	 * @generated
	 */
	EAttribute getRosettaCardinality_Plural();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaSynonymBase <em>Synonym Base</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Synonym Base</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaSynonymBase
	 * @generated
	 */
	EClass getRosettaSynonymBase();

	/**
	 * Returns the meta object for the reference list '{@link com.regnosys.rosetta.rosetta.RosettaSynonymBase#getSources <em>Sources</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Sources</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaSynonymBase#getSources()
	 * @see #getRosettaSynonymBase()
	 * @generated
	 */
	EReference getRosettaSynonymBase_Sources();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaSynonymValueBase <em>Synonym Value Base</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Synonym Value Base</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaSynonymValueBase
	 * @generated
	 */
	EClass getRosettaSynonymValueBase();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaSynonymValueBase#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaSynonymValueBase#getName()
	 * @see #getRosettaSynonymValueBase()
	 * @generated
	 */
	EAttribute getRosettaSynonymValueBase_Name();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaSynonymValueBase#getRefType <em>Ref Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Ref Type</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaSynonymValueBase#getRefType()
	 * @see #getRosettaSynonymValueBase()
	 * @generated
	 */
	EAttribute getRosettaSynonymValueBase_RefType();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaSynonymValueBase#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaSynonymValueBase#getValue()
	 * @see #getRosettaSynonymValueBase()
	 * @generated
	 */
	EAttribute getRosettaSynonymValueBase_Value();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaSynonymValueBase#getPath <em>Path</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Path</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaSynonymValueBase#getPath()
	 * @see #getRosettaSynonymValueBase()
	 * @generated
	 */
	EAttribute getRosettaSynonymValueBase_Path();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaSynonymValueBase#getMaps <em>Maps</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Maps</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaSynonymValueBase#getMaps()
	 * @see #getRosettaSynonymValueBase()
	 * @generated
	 */
	EAttribute getRosettaSynonymValueBase_Maps();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaClassSynonym <em>Class Synonym</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Class Synonym</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaClassSynonym
	 * @generated
	 */
	EClass getRosettaClassSynonym();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.RosettaClassSynonym#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Value</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaClassSynonym#getValue()
	 * @see #getRosettaClassSynonym()
	 * @generated
	 */
	EReference getRosettaClassSynonym_Value();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.RosettaClassSynonym#getMetaValue <em>Meta Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Meta Value</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaClassSynonym#getMetaValue()
	 * @see #getRosettaClassSynonym()
	 * @generated
	 */
	EReference getRosettaClassSynonym_MetaValue();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaSynonym <em>Synonym</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Synonym</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaSynonym
	 * @generated
	 */
	EClass getRosettaSynonym();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.RosettaSynonym#getBody <em>Body</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Body</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaSynonym#getBody()
	 * @see #getRosettaSynonym()
	 * @generated
	 */
	EReference getRosettaSynonym_Body();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaSynonymBody <em>Synonym Body</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Synonym Body</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaSynonymBody
	 * @generated
	 */
	EClass getRosettaSynonymBody();

	/**
	 * Returns the meta object for the containment reference list '{@link com.regnosys.rosetta.rosetta.RosettaSynonymBody#getValues <em>Values</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Values</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaSynonymBody#getValues()
	 * @see #getRosettaSynonymBody()
	 * @generated
	 */
	EReference getRosettaSynonymBody_Values();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.RosettaSynonymBody#getMappingLogic <em>Mapping Logic</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Mapping Logic</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaSynonymBody#getMappingLogic()
	 * @see #getRosettaSynonymBody()
	 * @generated
	 */
	EReference getRosettaSynonymBody_MappingLogic();

	/**
	 * Returns the meta object for the attribute list '{@link com.regnosys.rosetta.rosetta.RosettaSynonymBody#getHints <em>Hints</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Hints</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaSynonymBody#getHints()
	 * @see #getRosettaSynonymBody()
	 * @generated
	 */
	EAttribute getRosettaSynonymBody_Hints();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.RosettaSynonymBody#getMerge <em>Merge</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Merge</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaSynonymBody#getMerge()
	 * @see #getRosettaSynonymBody()
	 * @generated
	 */
	EReference getRosettaSynonymBody_Merge();

	/**
	 * Returns the meta object for the attribute list '{@link com.regnosys.rosetta.rosetta.RosettaSynonymBody#getMetaValues <em>Meta Values</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Meta Values</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaSynonymBody#getMetaValues()
	 * @see #getRosettaSynonymBody()
	 * @generated
	 */
	EAttribute getRosettaSynonymBody_MetaValues();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaSynonymBody#getMapper <em>Mapper</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Mapper</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaSynonymBody#getMapper()
	 * @see #getRosettaSynonymBody()
	 * @generated
	 */
	EAttribute getRosettaSynonymBody_Mapper();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaSynonymBody#getFormat <em>Format</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Format</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaSynonymBody#getFormat()
	 * @see #getRosettaSynonymBody()
	 * @generated
	 */
	EAttribute getRosettaSynonymBody_Format();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaSynonymBody#getPatternMatch <em>Pattern Match</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Pattern Match</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaSynonymBody#getPatternMatch()
	 * @see #getRosettaSynonymBody()
	 * @generated
	 */
	EAttribute getRosettaSynonymBody_PatternMatch();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaSynonymBody#getPatternReplace <em>Pattern Replace</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Pattern Replace</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaSynonymBody#getPatternReplace()
	 * @see #getRosettaSynonymBody()
	 * @generated
	 */
	EAttribute getRosettaSynonymBody_PatternReplace();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaSynonymBody#isRemoveHtml <em>Remove Html</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Remove Html</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaSynonymBody#isRemoveHtml()
	 * @see #getRosettaSynonymBody()
	 * @generated
	 */
	EAttribute getRosettaSynonymBody_RemoveHtml();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaMergeSynonymValue <em>Merge Synonym Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Merge Synonym Value</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaMergeSynonymValue
	 * @generated
	 */
	EClass getRosettaMergeSynonymValue();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaMergeSynonymValue#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaMergeSynonymValue#getName()
	 * @see #getRosettaMergeSynonymValue()
	 * @generated
	 */
	EAttribute getRosettaMergeSynonymValue_Name();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaMergeSynonymValue#getExcludePath <em>Exclude Path</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Exclude Path</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaMergeSynonymValue#getExcludePath()
	 * @see #getRosettaMergeSynonymValue()
	 * @generated
	 */
	EAttribute getRosettaMergeSynonymValue_ExcludePath();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaEnumSynonym <em>Enum Synonym</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Enum Synonym</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaEnumSynonym
	 * @generated
	 */
	EClass getRosettaEnumSynonym();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaEnumSynonym#getSynonymValue <em>Synonym Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Synonym Value</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaEnumSynonym#getSynonymValue()
	 * @see #getRosettaEnumSynonym()
	 * @generated
	 */
	EAttribute getRosettaEnumSynonym_SynonymValue();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaEnumSynonym#getPatternMatch <em>Pattern Match</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Pattern Match</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaEnumSynonym#getPatternMatch()
	 * @see #getRosettaEnumSynonym()
	 * @generated
	 */
	EAttribute getRosettaEnumSynonym_PatternMatch();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaEnumSynonym#getPatternReplace <em>Pattern Replace</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Pattern Replace</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaEnumSynonym#getPatternReplace()
	 * @see #getRosettaEnumSynonym()
	 * @generated
	 */
	EAttribute getRosettaEnumSynonym_PatternReplace();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaEnumSynonym#isRemoveHtml <em>Remove Html</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Remove Html</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaEnumSynonym#isRemoveHtml()
	 * @see #getRosettaEnumSynonym()
	 * @generated
	 */
	EAttribute getRosettaEnumSynonym_RemoveHtml();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaDocReference <em>Doc Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Doc Reference</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaDocReference
	 * @generated
	 */
	EClass getRosettaDocReference();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.RosettaDocReference#getDocReference <em>Doc Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Doc Reference</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaDocReference#getDocReference()
	 * @see #getRosettaDocReference()
	 * @generated
	 */
	EReference getRosettaDocReference_DocReference();

	/**
	 * Returns the meta object for the containment reference list '{@link com.regnosys.rosetta.rosetta.RosettaDocReference#getRationales <em>Rationales</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Rationales</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaDocReference#getRationales()
	 * @see #getRosettaDocReference()
	 * @generated
	 */
	EReference getRosettaDocReference_Rationales();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaDocReference#getStructuredProvision <em>Structured Provision</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Structured Provision</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaDocReference#getStructuredProvision()
	 * @see #getRosettaDocReference()
	 * @generated
	 */
	EAttribute getRosettaDocReference_StructuredProvision();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaDocReference#getProvision <em>Provision</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Provision</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaDocReference#getProvision()
	 * @see #getRosettaDocReference()
	 * @generated
	 */
	EAttribute getRosettaDocReference_Provision();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaDocReference#isReportedField <em>Reported Field</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Reported Field</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaDocReference#isReportedField()
	 * @see #getRosettaDocReference()
	 * @generated
	 */
	EAttribute getRosettaDocReference_ReportedField();

	/**
	 * Returns the meta object for the containment reference list '{@link com.regnosys.rosetta.rosetta.RosettaDocReference#getExtraneousSegments <em>Extraneous Segments</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Extraneous Segments</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaDocReference#getExtraneousSegments()
	 * @see #getRosettaDocReference()
	 * @generated
	 */
	EReference getRosettaDocReference_ExtraneousSegments();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RegulatoryDocumentReference <em>Regulatory Document Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Regulatory Document Reference</em>'.
	 * @see com.regnosys.rosetta.rosetta.RegulatoryDocumentReference
	 * @generated
	 */
	EClass getRegulatoryDocumentReference();

	/**
	 * Returns the meta object for the reference '{@link com.regnosys.rosetta.rosetta.RegulatoryDocumentReference#getBody <em>Body</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Body</em>'.
	 * @see com.regnosys.rosetta.rosetta.RegulatoryDocumentReference#getBody()
	 * @see #getRegulatoryDocumentReference()
	 * @generated
	 */
	EReference getRegulatoryDocumentReference_Body();

	/**
	 * Returns the meta object for the reference list '{@link com.regnosys.rosetta.rosetta.RegulatoryDocumentReference#getCorpusList <em>Corpus List</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Corpus List</em>'.
	 * @see com.regnosys.rosetta.rosetta.RegulatoryDocumentReference#getCorpusList()
	 * @see #getRegulatoryDocumentReference()
	 * @generated
	 */
	EReference getRegulatoryDocumentReference_CorpusList();

	/**
	 * Returns the meta object for the containment reference list '{@link com.regnosys.rosetta.rosetta.RegulatoryDocumentReference#getSegments <em>Segments</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Segments</em>'.
	 * @see com.regnosys.rosetta.rosetta.RegulatoryDocumentReference#getSegments()
	 * @see #getRegulatoryDocumentReference()
	 * @generated
	 */
	EReference getRegulatoryDocumentReference_Segments();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaSegmentRef <em>Segment Ref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Segment Ref</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaSegmentRef
	 * @generated
	 */
	EClass getRosettaSegmentRef();

	/**
	 * Returns the meta object for the reference '{@link com.regnosys.rosetta.rosetta.RosettaSegmentRef#getSegment <em>Segment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Segment</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaSegmentRef#getSegment()
	 * @see #getRosettaSegmentRef()
	 * @generated
	 */
	EReference getRosettaSegmentRef_Segment();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaSegmentRef#getSegmentRef <em>Segment Ref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Segment Ref</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaSegmentRef#getSegmentRef()
	 * @see #getRosettaSegmentRef()
	 * @generated
	 */
	EAttribute getRosettaSegmentRef_SegmentRef();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.DocumentRationale <em>Document Rationale</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Document Rationale</em>'.
	 * @see com.regnosys.rosetta.rosetta.DocumentRationale
	 * @generated
	 */
	EClass getDocumentRationale();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.DocumentRationale#getRationale <em>Rationale</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Rationale</em>'.
	 * @see com.regnosys.rosetta.rosetta.DocumentRationale#getRationale()
	 * @see #getDocumentRationale()
	 * @generated
	 */
	EAttribute getDocumentRationale_Rationale();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.DocumentRationale#getRationaleAuthor <em>Rationale Author</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Rationale Author</em>'.
	 * @see com.regnosys.rosetta.rosetta.DocumentRationale#getRationaleAuthor()
	 * @see #getDocumentRationale()
	 * @generated
	 */
	EAttribute getDocumentRationale_RationaleAuthor();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaBody <em>Body</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Body</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaBody
	 * @generated
	 */
	EClass getRosettaBody();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaBody#getBodyType <em>Body Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Body Type</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaBody#getBodyType()
	 * @see #getRosettaBody()
	 * @generated
	 */
	EAttribute getRosettaBody_BodyType();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaCorpus <em>Corpus</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Corpus</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaCorpus
	 * @generated
	 */
	EClass getRosettaCorpus();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaCorpus#getCorpusType <em>Corpus Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Corpus Type</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaCorpus#getCorpusType()
	 * @see #getRosettaCorpus()
	 * @generated
	 */
	EAttribute getRosettaCorpus_CorpusType();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaCorpus#getDisplayName <em>Display Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Display Name</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaCorpus#getDisplayName()
	 * @see #getRosettaCorpus()
	 * @generated
	 */
	EAttribute getRosettaCorpus_DisplayName();

	/**
	 * Returns the meta object for the reference '{@link com.regnosys.rosetta.rosetta.RosettaCorpus#getBody <em>Body</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Body</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaCorpus#getBody()
	 * @see #getRosettaCorpus()
	 * @generated
	 */
	EReference getRosettaCorpus_Body();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaSegment <em>Segment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Segment</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaSegment
	 * @generated
	 */
	EClass getRosettaSegment();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaMapTest <em>Map Test</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Map Test</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaMapTest
	 * @generated
	 */
	EClass getRosettaMapTest();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaMapTestExpression <em>Map Test Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Map Test Expression</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaMapTestExpression
	 * @generated
	 */
	EClass getRosettaMapTestExpression();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaMapPathValue <em>Map Path Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Map Path Value</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaMapPathValue
	 * @generated
	 */
	EClass getRosettaMapPathValue();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaMapPathValue#getPath <em>Path</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Path</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaMapPathValue#getPath()
	 * @see #getRosettaMapPathValue()
	 * @generated
	 */
	EAttribute getRosettaMapPathValue_Path();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaMapTestExistsExpression <em>Map Test Exists Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Map Test Exists Expression</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaMapTestExistsExpression
	 * @generated
	 */
	EClass getRosettaMapTestExistsExpression();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.RosettaMapTestExistsExpression#getArgument <em>Argument</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Argument</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaMapTestExistsExpression#getArgument()
	 * @see #getRosettaMapTestExistsExpression()
	 * @generated
	 */
	EReference getRosettaMapTestExistsExpression_Argument();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaMapTestAbsentExpression <em>Map Test Absent Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Map Test Absent Expression</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaMapTestAbsentExpression
	 * @generated
	 */
	EClass getRosettaMapTestAbsentExpression();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.RosettaMapTestAbsentExpression#getArgument <em>Argument</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Argument</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaMapTestAbsentExpression#getArgument()
	 * @see #getRosettaMapTestAbsentExpression()
	 * @generated
	 */
	EReference getRosettaMapTestAbsentExpression_Argument();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaMapTestEqualityOperation <em>Map Test Equality Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Map Test Equality Operation</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaMapTestEqualityOperation
	 * @generated
	 */
	EClass getRosettaMapTestEqualityOperation();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.RosettaMapTestEqualityOperation#getLeft <em>Left</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Left</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaMapTestEqualityOperation#getLeft()
	 * @see #getRosettaMapTestEqualityOperation()
	 * @generated
	 */
	EReference getRosettaMapTestEqualityOperation_Left();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.RosettaMapTestEqualityOperation#getRight <em>Right</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Right</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaMapTestEqualityOperation#getRight()
	 * @see #getRosettaMapTestEqualityOperation()
	 * @generated
	 */
	EReference getRosettaMapTestEqualityOperation_Right();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaMapTestEqualityOperation#getOperator <em>Operator</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Operator</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaMapTestEqualityOperation#getOperator()
	 * @see #getRosettaMapTestEqualityOperation()
	 * @generated
	 */
	EAttribute getRosettaMapTestEqualityOperation_Operator();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaMapTestFunc <em>Map Test Func</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Map Test Func</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaMapTestFunc
	 * @generated
	 */
	EClass getRosettaMapTestFunc();

	/**
	 * Returns the meta object for the reference '{@link com.regnosys.rosetta.rosetta.RosettaMapTestFunc#getFunc <em>Func</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Func</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaMapTestFunc#getFunc()
	 * @see #getRosettaMapTestFunc()
	 * @generated
	 */
	EReference getRosettaMapTestFunc_Func();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.RosettaMapTestFunc#getPredicatePath <em>Predicate Path</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Predicate Path</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaMapTestFunc#getPredicatePath()
	 * @see #getRosettaMapTestFunc()
	 * @generated
	 */
	EReference getRosettaMapTestFunc_PredicatePath();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaAttributeReferenceSegment <em>Attribute Reference Segment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Attribute Reference Segment</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaAttributeReferenceSegment
	 * @generated
	 */
	EClass getRosettaAttributeReferenceSegment();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaDataReference <em>Data Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Data Reference</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaDataReference
	 * @generated
	 */
	EClass getRosettaDataReference();

	/**
	 * Returns the meta object for the reference '{@link com.regnosys.rosetta.rosetta.RosettaDataReference#getData <em>Data</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Data</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaDataReference#getData()
	 * @see #getRosettaDataReference()
	 * @generated
	 */
	EReference getRosettaDataReference_Data();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaAttributeReference <em>Attribute Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Attribute Reference</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaAttributeReference
	 * @generated
	 */
	EClass getRosettaAttributeReference();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.RosettaAttributeReference#getReceiver <em>Receiver</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Receiver</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaAttributeReference#getReceiver()
	 * @see #getRosettaAttributeReference()
	 * @generated
	 */
	EReference getRosettaAttributeReference_Receiver();

	/**
	 * Returns the meta object for the reference '{@link com.regnosys.rosetta.rosetta.RosettaAttributeReference#getAttribute <em>Attribute</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Attribute</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaAttributeReference#getAttribute()
	 * @see #getRosettaAttributeReference()
	 * @generated
	 */
	EReference getRosettaAttributeReference_Attribute();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaMapping <em>Mapping</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Mapping</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaMapping
	 * @generated
	 */
	EClass getRosettaMapping();

	/**
	 * Returns the meta object for the containment reference list '{@link com.regnosys.rosetta.rosetta.RosettaMapping#getInstances <em>Instances</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Instances</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaMapping#getInstances()
	 * @see #getRosettaMapping()
	 * @generated
	 */
	EReference getRosettaMapping_Instances();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaMappingInstance <em>Mapping Instance</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Mapping Instance</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaMappingInstance
	 * @generated
	 */
	EClass getRosettaMappingInstance();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.RosettaMappingInstance#getSet <em>Set</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Set</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaMappingInstance#getSet()
	 * @see #getRosettaMappingInstance()
	 * @generated
	 */
	EReference getRosettaMappingInstance_Set();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.RosettaMappingInstance#getWhen <em>When</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>When</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaMappingInstance#getWhen()
	 * @see #getRosettaMappingInstance()
	 * @generated
	 */
	EReference getRosettaMappingInstance_When();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaMappingInstance#isDefault <em>Default</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Default</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaMappingInstance#isDefault()
	 * @see #getRosettaMappingInstance()
	 * @generated
	 */
	EAttribute getRosettaMappingInstance_Default();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaMappingPathTests <em>Mapping Path Tests</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Mapping Path Tests</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaMappingPathTests
	 * @generated
	 */
	EClass getRosettaMappingPathTests();

	/**
	 * Returns the meta object for the containment reference list '{@link com.regnosys.rosetta.rosetta.RosettaMappingPathTests#getTests <em>Tests</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Tests</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaMappingPathTests#getTests()
	 * @see #getRosettaMappingPathTests()
	 * @generated
	 */
	EReference getRosettaMappingPathTests_Tests();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaMapPath <em>Map Path</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Map Path</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaMapPath
	 * @generated
	 */
	EClass getRosettaMapPath();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.RosettaMapPath#getPath <em>Path</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Path</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaMapPath#getPath()
	 * @see #getRosettaMapPath()
	 * @generated
	 */
	EReference getRosettaMapPath_Path();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaMapRosettaPath <em>Map Rosetta Path</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Map Rosetta Path</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaMapRosettaPath
	 * @generated
	 */
	EClass getRosettaMapRosettaPath();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.RosettaMapRosettaPath#getPath <em>Path</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Path</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaMapRosettaPath#getPath()
	 * @see #getRosettaMapRosettaPath()
	 * @generated
	 */
	EReference getRosettaMapRosettaPath_Path();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaQualifiableConfiguration <em>Qualifiable Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Qualifiable Configuration</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaQualifiableConfiguration
	 * @generated
	 */
	EClass getRosettaQualifiableConfiguration();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaQualifiableConfiguration#getQType <em>QType</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>QType</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaQualifiableConfiguration#getQType()
	 * @see #getRosettaQualifiableConfiguration()
	 * @generated
	 */
	EAttribute getRosettaQualifiableConfiguration_QType();

	/**
	 * Returns the meta object for the container reference '{@link com.regnosys.rosetta.rosetta.RosettaQualifiableConfiguration#getModel <em>Model</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Model</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaQualifiableConfiguration#getModel()
	 * @see #getRosettaQualifiableConfiguration()
	 * @generated
	 */
	EReference getRosettaQualifiableConfiguration_Model();

	/**
	 * Returns the meta object for the reference '{@link com.regnosys.rosetta.rosetta.RosettaQualifiableConfiguration#getRosettaClass <em>Rosetta Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Rosetta Class</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaQualifiableConfiguration#getRosettaClass()
	 * @see #getRosettaQualifiableConfiguration()
	 * @generated
	 */
	EReference getRosettaQualifiableConfiguration_RosettaClass();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.ExternalAnnotationSource <em>External Annotation Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>External Annotation Source</em>'.
	 * @see com.regnosys.rosetta.rosetta.ExternalAnnotationSource
	 * @generated
	 */
	EClass getExternalAnnotationSource();

	/**
	 * Returns the meta object for the containment reference list '{@link com.regnosys.rosetta.rosetta.ExternalAnnotationSource#getExternalClasses <em>External Classes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>External Classes</em>'.
	 * @see com.regnosys.rosetta.rosetta.ExternalAnnotationSource#getExternalClasses()
	 * @see #getExternalAnnotationSource()
	 * @generated
	 */
	EReference getExternalAnnotationSource_ExternalClasses();

	/**
	 * Returns the meta object for the containment reference list '{@link com.regnosys.rosetta.rosetta.ExternalAnnotationSource#getExternalEnums <em>External Enums</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>External Enums</em>'.
	 * @see com.regnosys.rosetta.rosetta.ExternalAnnotationSource#getExternalEnums()
	 * @see #getExternalAnnotationSource()
	 * @generated
	 */
	EReference getExternalAnnotationSource_ExternalEnums();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaExternalRef <em>External Ref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>External Ref</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaExternalRef
	 * @generated
	 */
	EClass getRosettaExternalRef();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaExternalClass <em>External Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>External Class</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaExternalClass
	 * @generated
	 */
	EClass getRosettaExternalClass();

	/**
	 * Returns the meta object for the reference '{@link com.regnosys.rosetta.rosetta.RosettaExternalClass#getData <em>Data</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Data</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaExternalClass#getData()
	 * @see #getRosettaExternalClass()
	 * @generated
	 */
	EReference getRosettaExternalClass_Data();

	/**
	 * Returns the meta object for the containment reference list '{@link com.regnosys.rosetta.rosetta.RosettaExternalClass#getExternalClassSynonyms <em>External Class Synonyms</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>External Class Synonyms</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaExternalClass#getExternalClassSynonyms()
	 * @see #getRosettaExternalClass()
	 * @generated
	 */
	EReference getRosettaExternalClass_ExternalClassSynonyms();

	/**
	 * Returns the meta object for the containment reference list '{@link com.regnosys.rosetta.rosetta.RosettaExternalClass#getRegularAttributes <em>Regular Attributes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Regular Attributes</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaExternalClass#getRegularAttributes()
	 * @see #getRosettaExternalClass()
	 * @generated
	 */
	EReference getRosettaExternalClass_RegularAttributes();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaExternalEnum <em>External Enum</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>External Enum</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaExternalEnum
	 * @generated
	 */
	EClass getRosettaExternalEnum();

	/**
	 * Returns the meta object for the reference '{@link com.regnosys.rosetta.rosetta.RosettaExternalEnum#getEnumeration <em>Enumeration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Enumeration</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaExternalEnum#getEnumeration()
	 * @see #getRosettaExternalEnum()
	 * @generated
	 */
	EReference getRosettaExternalEnum_Enumeration();

	/**
	 * Returns the meta object for the containment reference list '{@link com.regnosys.rosetta.rosetta.RosettaExternalEnum#getRegularValues <em>Regular Values</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Regular Values</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaExternalEnum#getRegularValues()
	 * @see #getRosettaExternalEnum()
	 * @generated
	 */
	EReference getRosettaExternalEnum_RegularValues();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaExternalRegularAttribute <em>External Regular Attribute</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>External Regular Attribute</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaExternalRegularAttribute
	 * @generated
	 */
	EClass getRosettaExternalRegularAttribute();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaExternalRegularAttribute#getOperator <em>Operator</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Operator</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaExternalRegularAttribute#getOperator()
	 * @see #getRosettaExternalRegularAttribute()
	 * @generated
	 */
	EAttribute getRosettaExternalRegularAttribute_Operator();

	/**
	 * Returns the meta object for the reference '{@link com.regnosys.rosetta.rosetta.RosettaExternalRegularAttribute#getAttributeRef <em>Attribute Ref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Attribute Ref</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaExternalRegularAttribute#getAttributeRef()
	 * @see #getRosettaExternalRegularAttribute()
	 * @generated
	 */
	EReference getRosettaExternalRegularAttribute_AttributeRef();

	/**
	 * Returns the meta object for the containment reference list '{@link com.regnosys.rosetta.rosetta.RosettaExternalRegularAttribute#getExternalSynonyms <em>External Synonyms</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>External Synonyms</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaExternalRegularAttribute#getExternalSynonyms()
	 * @see #getRosettaExternalRegularAttribute()
	 * @generated
	 */
	EReference getRosettaExternalRegularAttribute_ExternalSynonyms();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.RosettaExternalRegularAttribute#getExternalRuleReference <em>External Rule Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>External Rule Reference</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaExternalRegularAttribute#getExternalRuleReference()
	 * @see #getRosettaExternalRegularAttribute()
	 * @generated
	 */
	EReference getRosettaExternalRegularAttribute_ExternalRuleReference();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaExternalEnumValue <em>External Enum Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>External Enum Value</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaExternalEnumValue
	 * @generated
	 */
	EClass getRosettaExternalEnumValue();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaExternalEnumValue#getOperator <em>Operator</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Operator</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaExternalEnumValue#getOperator()
	 * @see #getRosettaExternalEnumValue()
	 * @generated
	 */
	EAttribute getRosettaExternalEnumValue_Operator();

	/**
	 * Returns the meta object for the reference '{@link com.regnosys.rosetta.rosetta.RosettaExternalEnumValue#getEnumRef <em>Enum Ref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Enum Ref</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaExternalEnumValue#getEnumRef()
	 * @see #getRosettaExternalEnumValue()
	 * @generated
	 */
	EReference getRosettaExternalEnumValue_EnumRef();

	/**
	 * Returns the meta object for the containment reference list '{@link com.regnosys.rosetta.rosetta.RosettaExternalEnumValue#getExternalEnumSynonyms <em>External Enum Synonyms</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>External Enum Synonyms</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaExternalEnumValue#getExternalEnumSynonyms()
	 * @see #getRosettaExternalEnumValue()
	 * @generated
	 */
	EReference getRosettaExternalEnumValue_ExternalEnumSynonyms();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaExternalClassSynonym <em>External Class Synonym</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>External Class Synonym</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaExternalClassSynonym
	 * @generated
	 */
	EClass getRosettaExternalClassSynonym();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.RosettaExternalClassSynonym#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Value</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaExternalClassSynonym#getValue()
	 * @see #getRosettaExternalClassSynonym()
	 * @generated
	 */
	EReference getRosettaExternalClassSynonym_Value();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.RosettaExternalClassSynonym#getMetaValue <em>Meta Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Meta Value</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaExternalClassSynonym#getMetaValue()
	 * @see #getRosettaExternalClassSynonym()
	 * @generated
	 */
	EReference getRosettaExternalClassSynonym_MetaValue();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaExternalSynonym <em>External Synonym</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>External Synonym</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaExternalSynonym
	 * @generated
	 */
	EClass getRosettaExternalSynonym();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.RosettaExternalSynonym#getBody <em>Body</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Body</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaExternalSynonym#getBody()
	 * @see #getRosettaExternalSynonym()
	 * @generated
	 */
	EReference getRosettaExternalSynonym_Body();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaExternalSynonymSource <em>External Synonym Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>External Synonym Source</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaExternalSynonymSource
	 * @generated
	 */
	EClass getRosettaExternalSynonymSource();

	/**
	 * Returns the meta object for the reference list '{@link com.regnosys.rosetta.rosetta.RosettaExternalSynonymSource#getSuperSources <em>Super Sources</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Super Sources</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaExternalSynonymSource#getSuperSources()
	 * @see #getRosettaExternalSynonymSource()
	 * @generated
	 */
	EReference getRosettaExternalSynonymSource_SuperSources();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaExternalRuleSource <em>External Rule Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>External Rule Source</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaExternalRuleSource
	 * @generated
	 */
	EClass getRosettaExternalRuleSource();

	/**
	 * Returns the meta object for the reference list '{@link com.regnosys.rosetta.rosetta.RosettaExternalRuleSource#getSuperSources <em>Super Sources</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Super Sources</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaExternalRuleSource#getSuperSources()
	 * @see #getRosettaExternalRuleSource()
	 * @generated
	 */
	EReference getRosettaExternalRuleSource_SuperSources();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaReport <em>Report</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Report</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaReport
	 * @generated
	 */
	EClass getRosettaReport();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.RosettaReport#getRegulatoryBody <em>Regulatory Body</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Regulatory Body</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaReport#getRegulatoryBody()
	 * @see #getRosettaReport()
	 * @generated
	 */
	EReference getRosettaReport_RegulatoryBody();

	/**
	 * Returns the meta object for the reference list '{@link com.regnosys.rosetta.rosetta.RosettaReport#getEligibilityRules <em>Eligibility Rules</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Eligibility Rules</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaReport#getEligibilityRules()
	 * @see #getRosettaReport()
	 * @generated
	 */
	EReference getRosettaReport_EligibilityRules();

	/**
	 * Returns the meta object for the reference '{@link com.regnosys.rosetta.rosetta.RosettaReport#getReportingStandard <em>Reporting Standard</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Reporting Standard</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaReport#getReportingStandard()
	 * @see #getRosettaReport()
	 * @generated
	 */
	EReference getRosettaReport_ReportingStandard();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.RosettaReport#getInputType <em>Input Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Input Type</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaReport#getInputType()
	 * @see #getRosettaReport()
	 * @generated
	 */
	EReference getRosettaReport_InputType();

	/**
	 * Returns the meta object for the reference '{@link com.regnosys.rosetta.rosetta.RosettaReport#getReportType <em>Report Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Report Type</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaReport#getReportType()
	 * @see #getRosettaReport()
	 * @generated
	 */
	EReference getRosettaReport_ReportType();

	/**
	 * Returns the meta object for the reference '{@link com.regnosys.rosetta.rosetta.RosettaReport#getRuleSource <em>Rule Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Rule Source</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaReport#getRuleSource()
	 * @see #getRosettaReport()
	 * @generated
	 */
	EReference getRosettaReport_RuleSource();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.RosettaRule <em>Rule</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Rule</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaRule
	 * @generated
	 */
	EClass getRosettaRule();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaRule#isEligibility <em>Eligibility</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Eligibility</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaRule#isEligibility()
	 * @see #getRosettaRule()
	 * @generated
	 */
	EAttribute getRosettaRule_Eligibility();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.RosettaRule#getExpression <em>Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expression</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaRule#getExpression()
	 * @see #getRosettaRule()
	 * @generated
	 */
	EReference getRosettaRule_Expression();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.RosettaRule#getIdentifier <em>Identifier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Identifier</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaRule#getIdentifier()
	 * @see #getRosettaRule()
	 * @generated
	 */
	EAttribute getRosettaRule_Identifier();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.RosettaRule#getInput <em>Input</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Input</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaRule#getInput()
	 * @see #getRosettaRule()
	 * @generated
	 */
	EReference getRosettaRule_Input();

	/**
	 * Returns the meta object for enum '{@link com.regnosys.rosetta.rosetta.RosettaSynonymRef <em>Synonym Ref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Synonym Ref</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaSynonymRef
	 * @generated
	 */
	EEnum getRosettaSynonymRef();

	/**
	 * Returns the meta object for enum '{@link com.regnosys.rosetta.rosetta.RosettaQualifiableType <em>Qualifiable Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Qualifiable Type</em>'.
	 * @see com.regnosys.rosetta.rosetta.RosettaQualifiableType
	 * @generated
	 */
	EEnum getRosettaQualifiableType();

	/**
	 * Returns the meta object for enum '{@link com.regnosys.rosetta.rosetta.ExternalValueOperator <em>External Value Operator</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>External Value Operator</em>'.
	 * @see com.regnosys.rosetta.rosetta.ExternalValueOperator
	 * @generated
	 */
	EEnum getExternalValueOperator();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	RosettaFactory getRosettaFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaModelImpl <em>Model</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaModelImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaModel()
		 * @generated
		 */
		EClass ROSETTA_MODEL = eINSTANCE.getRosettaModel();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_MODEL__NAME = eINSTANCE.getRosettaModel_Name();

		/**
		 * The meta object literal for the '<em><b>Version</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_MODEL__VERSION = eINSTANCE.getRosettaModel_Version();

		/**
		 * The meta object literal for the '<em><b>Overridden</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_MODEL__OVERRIDDEN = eINSTANCE.getRosettaModel_Overridden();

		/**
		 * The meta object literal for the '<em><b>Imports</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_MODEL__IMPORTS = eINSTANCE.getRosettaModel_Imports();

		/**
		 * The meta object literal for the '<em><b>Configurations</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_MODEL__CONFIGURATIONS = eINSTANCE.getRosettaModel_Configurations();

		/**
		 * The meta object literal for the '<em><b>Elements</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_MODEL__ELEMENTS = eINSTANCE.getRosettaModel_Elements();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.ImportImpl <em>Import</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.ImportImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getImport()
		 * @generated
		 */
		EClass IMPORT = eINSTANCE.getImport();

		/**
		 * The meta object literal for the '<em><b>Imported Namespace</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute IMPORT__IMPORTED_NAMESPACE = eINSTANCE.getImport_ImportedNamespace();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.RosettaDefinable <em>Definable</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.RosettaDefinable
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaDefinable()
		 * @generated
		 */
		EClass ROSETTA_DEFINABLE = eINSTANCE.getRosettaDefinable();

		/**
		 * The meta object literal for the '<em><b>Definition</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_DEFINABLE__DEFINITION = eINSTANCE.getRosettaDefinable_Definition();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.RosettaNamed <em>Named</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.RosettaNamed
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaNamed()
		 * @generated
		 */
		EClass ROSETTA_NAMED = eINSTANCE.getRosettaNamed();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_NAMED__NAME = eINSTANCE.getRosettaNamed_Name();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.RosettaTyped <em>Typed</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.RosettaTyped
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaTyped()
		 * @generated
		 */
		EClass ROSETTA_TYPED = eINSTANCE.getRosettaTyped();

		/**
		 * The meta object literal for the '<em><b>Type Call</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_TYPED__TYPE_CALL = eINSTANCE.getRosettaTyped_TypeCall();

		/**
		 * The meta object literal for the '<em><b>Is Type Inferred</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_TYPED__IS_TYPE_INFERRED = eINSTANCE.getRosettaTyped_IsTypeInferred();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaFeatureImpl <em>Feature</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaFeatureImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaFeature()
		 * @generated
		 */
		EClass ROSETTA_FEATURE = eINSTANCE.getRosettaFeature();

		/**
		 * The meta object literal for the '<em><b>Get Name Or Default</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_FEATURE__GET_NAME_OR_DEFAULT = eINSTANCE.getRosettaFeature_GetNameOrDefault();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaTypedFeatureImpl <em>Typed Feature</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaTypedFeatureImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaTypedFeature()
		 * @generated
		 */
		EClass ROSETTA_TYPED_FEATURE = eINSTANCE.getRosettaTypedFeature();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.RosettaSymbol <em>Symbol</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.RosettaSymbol
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaSymbol()
		 * @generated
		 */
		EClass ROSETTA_SYMBOL = eINSTANCE.getRosettaSymbol();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.RosettaCallableWithArgs <em>Callable With Args</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.RosettaCallableWithArgs
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaCallableWithArgs()
		 * @generated
		 */
		EClass ROSETTA_CALLABLE_WITH_ARGS = eINSTANCE.getRosettaCallableWithArgs();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.RosettaRootElement <em>Root Element</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.RosettaRootElement
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaRootElement()
		 * @generated
		 */
		EClass ROSETTA_ROOT_ELEMENT = eINSTANCE.getRosettaRootElement();

		/**
		 * The meta object literal for the '<em><b>Model</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_ROOT_ELEMENT__MODEL = eINSTANCE.getRosettaRootElement_Model();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaFeatureOwnerImpl <em>Feature Owner</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaFeatureOwnerImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaFeatureOwner()
		 * @generated
		 */
		EClass ROSETTA_FEATURE_OWNER = eINSTANCE.getRosettaFeatureOwner();

		/**
		 * The meta object literal for the '<em><b>Features</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_FEATURE_OWNER__FEATURES = eINSTANCE.getRosettaFeatureOwner_Features();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaTypeImpl <em>Type</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaTypeImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaType()
		 * @generated
		 */
		EClass ROSETTA_TYPE = eINSTANCE.getRosettaType();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.ParametrizedRosettaType <em>Parametrized Rosetta Type</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.ParametrizedRosettaType
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getParametrizedRosettaType()
		 * @generated
		 */
		EClass PARAMETRIZED_ROSETTA_TYPE = eINSTANCE.getParametrizedRosettaType();

		/**
		 * The meta object literal for the '<em><b>Parameters</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PARAMETRIZED_ROSETTA_TYPE__PARAMETERS = eINSTANCE.getParametrizedRosettaType_Parameters();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.TypeCallImpl <em>Type Call</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.TypeCallImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getTypeCall()
		 * @generated
		 */
		EClass TYPE_CALL = eINSTANCE.getTypeCall();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TYPE_CALL__TYPE = eINSTANCE.getTypeCall_Type();

		/**
		 * The meta object literal for the '<em><b>Arguments</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TYPE_CALL__ARGUMENTS = eINSTANCE.getTypeCall_Arguments();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.TypeCallArgumentImpl <em>Type Call Argument</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.TypeCallArgumentImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getTypeCallArgument()
		 * @generated
		 */
		EClass TYPE_CALL_ARGUMENT = eINSTANCE.getTypeCallArgument();

		/**
		 * The meta object literal for the '<em><b>Parameter</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TYPE_CALL_ARGUMENT__PARAMETER = eINSTANCE.getTypeCallArgument_Parameter();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TYPE_CALL_ARGUMENT__VALUE = eINSTANCE.getTypeCallArgument_Value();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaBuiltinTypeImpl <em>Builtin Type</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaBuiltinTypeImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaBuiltinType()
		 * @generated
		 */
		EClass ROSETTA_BUILTIN_TYPE = eINSTANCE.getRosettaBuiltinType();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaBasicTypeImpl <em>Basic Type</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaBasicTypeImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaBasicType()
		 * @generated
		 */
		EClass ROSETTA_BASIC_TYPE = eINSTANCE.getRosettaBasicType();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.TypeParameterImpl <em>Type Parameter</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.TypeParameterImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getTypeParameter()
		 * @generated
		 */
		EClass TYPE_PARAMETER = eINSTANCE.getTypeParameter();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaSynonymSourceImpl <em>Synonym Source</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaSynonymSourceImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaSynonymSource()
		 * @generated
		 */
		EClass ROSETTA_SYNONYM_SOURCE = eINSTANCE.getRosettaSynonymSource();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaRecordTypeImpl <em>Record Type</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaRecordTypeImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaRecordType()
		 * @generated
		 */
		EClass ROSETTA_RECORD_TYPE = eINSTANCE.getRosettaRecordType();

		/**
		 * The meta object literal for the '<em><b>Features</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_RECORD_TYPE__FEATURES = eINSTANCE.getRosettaRecordType_Features();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaRecordFeatureImpl <em>Record Feature</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaRecordFeatureImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaRecordFeature()
		 * @generated
		 */
		EClass ROSETTA_RECORD_FEATURE = eINSTANCE.getRosettaRecordFeature();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaExternalFunctionImpl <em>External Function</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaExternalFunctionImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaExternalFunction()
		 * @generated
		 */
		EClass ROSETTA_EXTERNAL_FUNCTION = eINSTANCE.getRosettaExternalFunction();

		/**
		 * The meta object literal for the '<em><b>Parameters</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_EXTERNAL_FUNCTION__PARAMETERS = eINSTANCE.getRosettaExternalFunction_Parameters();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaParameterImpl <em>Parameter</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaParameterImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaParameter()
		 * @generated
		 */
		EClass ROSETTA_PARAMETER = eINSTANCE.getRosettaParameter();

		/**
		 * The meta object literal for the '<em><b>Is Array</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_PARAMETER__IS_ARRAY = eINSTANCE.getRosettaParameter_IsArray();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaTypeAliasImpl <em>Type Alias</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaTypeAliasImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaTypeAlias()
		 * @generated
		 */
		EClass ROSETTA_TYPE_ALIAS = eINSTANCE.getRosettaTypeAlias();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaMetaTypeImpl <em>Meta Type</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaMetaTypeImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaMetaType()
		 * @generated
		 */
		EClass ROSETTA_META_TYPE = eINSTANCE.getRosettaMetaType();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaEnumerationImpl <em>Enumeration</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaEnumerationImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaEnumeration()
		 * @generated
		 */
		EClass ROSETTA_ENUMERATION = eINSTANCE.getRosettaEnumeration();

		/**
		 * The meta object literal for the '<em><b>Super Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_ENUMERATION__SUPER_TYPE = eINSTANCE.getRosettaEnumeration_SuperType();

		/**
		 * The meta object literal for the '<em><b>Synonyms</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_ENUMERATION__SYNONYMS = eINSTANCE.getRosettaEnumeration_Synonyms();

		/**
		 * The meta object literal for the '<em><b>Enum Values</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_ENUMERATION__ENUM_VALUES = eINSTANCE.getRosettaEnumeration_EnumValues();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaEnumValueImpl <em>Enum Value</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaEnumValueImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaEnumValue()
		 * @generated
		 */
		EClass ROSETTA_ENUM_VALUE = eINSTANCE.getRosettaEnumValue();

		/**
		 * The meta object literal for the '<em><b>Display</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_ENUM_VALUE__DISPLAY = eINSTANCE.getRosettaEnumValue_Display();

		/**
		 * The meta object literal for the '<em><b>Enum Synonyms</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_ENUM_VALUE__ENUM_SYNONYMS = eINSTANCE.getRosettaEnumValue_EnumSynonyms();

		/**
		 * The meta object literal for the '<em><b>Enumeration</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_ENUM_VALUE__ENUMERATION = eINSTANCE.getRosettaEnumValue_Enumeration();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaEnumValueReferenceImpl <em>Enum Value Reference</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaEnumValueReferenceImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaEnumValueReference()
		 * @generated
		 */
		EClass ROSETTA_ENUM_VALUE_REFERENCE = eINSTANCE.getRosettaEnumValueReference();

		/**
		 * The meta object literal for the '<em><b>Enumeration</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_ENUM_VALUE_REFERENCE__ENUMERATION = eINSTANCE.getRosettaEnumValueReference_Enumeration();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_ENUM_VALUE_REFERENCE__VALUE = eINSTANCE.getRosettaEnumValueReference_Value();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaCardinalityImpl <em>Cardinality</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaCardinalityImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaCardinality()
		 * @generated
		 */
		EClass ROSETTA_CARDINALITY = eINSTANCE.getRosettaCardinality();

		/**
		 * The meta object literal for the '<em><b>Inf</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_CARDINALITY__INF = eINSTANCE.getRosettaCardinality_Inf();

		/**
		 * The meta object literal for the '<em><b>Sup</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_CARDINALITY__SUP = eINSTANCE.getRosettaCardinality_Sup();

		/**
		 * The meta object literal for the '<em><b>Unbounded</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_CARDINALITY__UNBOUNDED = eINSTANCE.getRosettaCardinality_Unbounded();

		/**
		 * The meta object literal for the '<em><b>Is Many</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_CARDINALITY__IS_MANY = eINSTANCE.getRosettaCardinality_IsMany();

		/**
		 * The meta object literal for the '<em><b>Empty</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_CARDINALITY__EMPTY = eINSTANCE.getRosettaCardinality_Empty();

		/**
		 * The meta object literal for the '<em><b>Optional</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_CARDINALITY__OPTIONAL = eINSTANCE.getRosettaCardinality_Optional();

		/**
		 * The meta object literal for the '<em><b>Singular</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_CARDINALITY__SINGULAR = eINSTANCE.getRosettaCardinality_Singular();

		/**
		 * The meta object literal for the '<em><b>Plural</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_CARDINALITY__PLURAL = eINSTANCE.getRosettaCardinality_Plural();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaSynonymBaseImpl <em>Synonym Base</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaSynonymBaseImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaSynonymBase()
		 * @generated
		 */
		EClass ROSETTA_SYNONYM_BASE = eINSTANCE.getRosettaSynonymBase();

		/**
		 * The meta object literal for the '<em><b>Sources</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_SYNONYM_BASE__SOURCES = eINSTANCE.getRosettaSynonymBase_Sources();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaSynonymValueBaseImpl <em>Synonym Value Base</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaSynonymValueBaseImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaSynonymValueBase()
		 * @generated
		 */
		EClass ROSETTA_SYNONYM_VALUE_BASE = eINSTANCE.getRosettaSynonymValueBase();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_SYNONYM_VALUE_BASE__NAME = eINSTANCE.getRosettaSynonymValueBase_Name();

		/**
		 * The meta object literal for the '<em><b>Ref Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_SYNONYM_VALUE_BASE__REF_TYPE = eINSTANCE.getRosettaSynonymValueBase_RefType();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_SYNONYM_VALUE_BASE__VALUE = eINSTANCE.getRosettaSynonymValueBase_Value();

		/**
		 * The meta object literal for the '<em><b>Path</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_SYNONYM_VALUE_BASE__PATH = eINSTANCE.getRosettaSynonymValueBase_Path();

		/**
		 * The meta object literal for the '<em><b>Maps</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_SYNONYM_VALUE_BASE__MAPS = eINSTANCE.getRosettaSynonymValueBase_Maps();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaClassSynonymImpl <em>Class Synonym</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaClassSynonymImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaClassSynonym()
		 * @generated
		 */
		EClass ROSETTA_CLASS_SYNONYM = eINSTANCE.getRosettaClassSynonym();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_CLASS_SYNONYM__VALUE = eINSTANCE.getRosettaClassSynonym_Value();

		/**
		 * The meta object literal for the '<em><b>Meta Value</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_CLASS_SYNONYM__META_VALUE = eINSTANCE.getRosettaClassSynonym_MetaValue();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaSynonymImpl <em>Synonym</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaSynonymImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaSynonym()
		 * @generated
		 */
		EClass ROSETTA_SYNONYM = eINSTANCE.getRosettaSynonym();

		/**
		 * The meta object literal for the '<em><b>Body</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_SYNONYM__BODY = eINSTANCE.getRosettaSynonym_Body();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaSynonymBodyImpl <em>Synonym Body</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaSynonymBodyImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaSynonymBody()
		 * @generated
		 */
		EClass ROSETTA_SYNONYM_BODY = eINSTANCE.getRosettaSynonymBody();

		/**
		 * The meta object literal for the '<em><b>Values</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_SYNONYM_BODY__VALUES = eINSTANCE.getRosettaSynonymBody_Values();

		/**
		 * The meta object literal for the '<em><b>Mapping Logic</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_SYNONYM_BODY__MAPPING_LOGIC = eINSTANCE.getRosettaSynonymBody_MappingLogic();

		/**
		 * The meta object literal for the '<em><b>Hints</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_SYNONYM_BODY__HINTS = eINSTANCE.getRosettaSynonymBody_Hints();

		/**
		 * The meta object literal for the '<em><b>Merge</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_SYNONYM_BODY__MERGE = eINSTANCE.getRosettaSynonymBody_Merge();

		/**
		 * The meta object literal for the '<em><b>Meta Values</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_SYNONYM_BODY__META_VALUES = eINSTANCE.getRosettaSynonymBody_MetaValues();

		/**
		 * The meta object literal for the '<em><b>Mapper</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_SYNONYM_BODY__MAPPER = eINSTANCE.getRosettaSynonymBody_Mapper();

		/**
		 * The meta object literal for the '<em><b>Format</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_SYNONYM_BODY__FORMAT = eINSTANCE.getRosettaSynonymBody_Format();

		/**
		 * The meta object literal for the '<em><b>Pattern Match</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_SYNONYM_BODY__PATTERN_MATCH = eINSTANCE.getRosettaSynonymBody_PatternMatch();

		/**
		 * The meta object literal for the '<em><b>Pattern Replace</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_SYNONYM_BODY__PATTERN_REPLACE = eINSTANCE.getRosettaSynonymBody_PatternReplace();

		/**
		 * The meta object literal for the '<em><b>Remove Html</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_SYNONYM_BODY__REMOVE_HTML = eINSTANCE.getRosettaSynonymBody_RemoveHtml();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaMergeSynonymValueImpl <em>Merge Synonym Value</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaMergeSynonymValueImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaMergeSynonymValue()
		 * @generated
		 */
		EClass ROSETTA_MERGE_SYNONYM_VALUE = eINSTANCE.getRosettaMergeSynonymValue();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_MERGE_SYNONYM_VALUE__NAME = eINSTANCE.getRosettaMergeSynonymValue_Name();

		/**
		 * The meta object literal for the '<em><b>Exclude Path</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_MERGE_SYNONYM_VALUE__EXCLUDE_PATH = eINSTANCE.getRosettaMergeSynonymValue_ExcludePath();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaEnumSynonymImpl <em>Enum Synonym</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaEnumSynonymImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaEnumSynonym()
		 * @generated
		 */
		EClass ROSETTA_ENUM_SYNONYM = eINSTANCE.getRosettaEnumSynonym();

		/**
		 * The meta object literal for the '<em><b>Synonym Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_ENUM_SYNONYM__SYNONYM_VALUE = eINSTANCE.getRosettaEnumSynonym_SynonymValue();

		/**
		 * The meta object literal for the '<em><b>Pattern Match</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_ENUM_SYNONYM__PATTERN_MATCH = eINSTANCE.getRosettaEnumSynonym_PatternMatch();

		/**
		 * The meta object literal for the '<em><b>Pattern Replace</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_ENUM_SYNONYM__PATTERN_REPLACE = eINSTANCE.getRosettaEnumSynonym_PatternReplace();

		/**
		 * The meta object literal for the '<em><b>Remove Html</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_ENUM_SYNONYM__REMOVE_HTML = eINSTANCE.getRosettaEnumSynonym_RemoveHtml();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaDocReferenceImpl <em>Doc Reference</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaDocReferenceImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaDocReference()
		 * @generated
		 */
		EClass ROSETTA_DOC_REFERENCE = eINSTANCE.getRosettaDocReference();

		/**
		 * The meta object literal for the '<em><b>Doc Reference</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_DOC_REFERENCE__DOC_REFERENCE = eINSTANCE.getRosettaDocReference_DocReference();

		/**
		 * The meta object literal for the '<em><b>Rationales</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_DOC_REFERENCE__RATIONALES = eINSTANCE.getRosettaDocReference_Rationales();

		/**
		 * The meta object literal for the '<em><b>Structured Provision</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_DOC_REFERENCE__STRUCTURED_PROVISION = eINSTANCE.getRosettaDocReference_StructuredProvision();

		/**
		 * The meta object literal for the '<em><b>Provision</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_DOC_REFERENCE__PROVISION = eINSTANCE.getRosettaDocReference_Provision();

		/**
		 * The meta object literal for the '<em><b>Reported Field</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_DOC_REFERENCE__REPORTED_FIELD = eINSTANCE.getRosettaDocReference_ReportedField();

		/**
		 * The meta object literal for the '<em><b>Extraneous Segments</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_DOC_REFERENCE__EXTRANEOUS_SEGMENTS = eINSTANCE.getRosettaDocReference_ExtraneousSegments();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RegulatoryDocumentReferenceImpl <em>Regulatory Document Reference</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RegulatoryDocumentReferenceImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRegulatoryDocumentReference()
		 * @generated
		 */
		EClass REGULATORY_DOCUMENT_REFERENCE = eINSTANCE.getRegulatoryDocumentReference();

		/**
		 * The meta object literal for the '<em><b>Body</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference REGULATORY_DOCUMENT_REFERENCE__BODY = eINSTANCE.getRegulatoryDocumentReference_Body();

		/**
		 * The meta object literal for the '<em><b>Corpus List</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference REGULATORY_DOCUMENT_REFERENCE__CORPUS_LIST = eINSTANCE.getRegulatoryDocumentReference_CorpusList();

		/**
		 * The meta object literal for the '<em><b>Segments</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference REGULATORY_DOCUMENT_REFERENCE__SEGMENTS = eINSTANCE.getRegulatoryDocumentReference_Segments();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaSegmentRefImpl <em>Segment Ref</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaSegmentRefImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaSegmentRef()
		 * @generated
		 */
		EClass ROSETTA_SEGMENT_REF = eINSTANCE.getRosettaSegmentRef();

		/**
		 * The meta object literal for the '<em><b>Segment</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_SEGMENT_REF__SEGMENT = eINSTANCE.getRosettaSegmentRef_Segment();

		/**
		 * The meta object literal for the '<em><b>Segment Ref</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_SEGMENT_REF__SEGMENT_REF = eINSTANCE.getRosettaSegmentRef_SegmentRef();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.DocumentRationaleImpl <em>Document Rationale</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.DocumentRationaleImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getDocumentRationale()
		 * @generated
		 */
		EClass DOCUMENT_RATIONALE = eINSTANCE.getDocumentRationale();

		/**
		 * The meta object literal for the '<em><b>Rationale</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DOCUMENT_RATIONALE__RATIONALE = eINSTANCE.getDocumentRationale_Rationale();

		/**
		 * The meta object literal for the '<em><b>Rationale Author</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DOCUMENT_RATIONALE__RATIONALE_AUTHOR = eINSTANCE.getDocumentRationale_RationaleAuthor();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaBodyImpl <em>Body</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaBodyImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaBody()
		 * @generated
		 */
		EClass ROSETTA_BODY = eINSTANCE.getRosettaBody();

		/**
		 * The meta object literal for the '<em><b>Body Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_BODY__BODY_TYPE = eINSTANCE.getRosettaBody_BodyType();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaCorpusImpl <em>Corpus</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaCorpusImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaCorpus()
		 * @generated
		 */
		EClass ROSETTA_CORPUS = eINSTANCE.getRosettaCorpus();

		/**
		 * The meta object literal for the '<em><b>Corpus Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_CORPUS__CORPUS_TYPE = eINSTANCE.getRosettaCorpus_CorpusType();

		/**
		 * The meta object literal for the '<em><b>Display Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_CORPUS__DISPLAY_NAME = eINSTANCE.getRosettaCorpus_DisplayName();

		/**
		 * The meta object literal for the '<em><b>Body</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_CORPUS__BODY = eINSTANCE.getRosettaCorpus_Body();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaSegmentImpl <em>Segment</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaSegmentImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaSegment()
		 * @generated
		 */
		EClass ROSETTA_SEGMENT = eINSTANCE.getRosettaSegment();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.RosettaMapTest <em>Map Test</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.RosettaMapTest
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaMapTest()
		 * @generated
		 */
		EClass ROSETTA_MAP_TEST = eINSTANCE.getRosettaMapTest();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.RosettaMapTestExpression <em>Map Test Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.RosettaMapTestExpression
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaMapTestExpression()
		 * @generated
		 */
		EClass ROSETTA_MAP_TEST_EXPRESSION = eINSTANCE.getRosettaMapTestExpression();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaMapPathValueImpl <em>Map Path Value</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaMapPathValueImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaMapPathValue()
		 * @generated
		 */
		EClass ROSETTA_MAP_PATH_VALUE = eINSTANCE.getRosettaMapPathValue();

		/**
		 * The meta object literal for the '<em><b>Path</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_MAP_PATH_VALUE__PATH = eINSTANCE.getRosettaMapPathValue_Path();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaMapTestExistsExpressionImpl <em>Map Test Exists Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaMapTestExistsExpressionImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaMapTestExistsExpression()
		 * @generated
		 */
		EClass ROSETTA_MAP_TEST_EXISTS_EXPRESSION = eINSTANCE.getRosettaMapTestExistsExpression();

		/**
		 * The meta object literal for the '<em><b>Argument</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_MAP_TEST_EXISTS_EXPRESSION__ARGUMENT = eINSTANCE.getRosettaMapTestExistsExpression_Argument();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaMapTestAbsentExpressionImpl <em>Map Test Absent Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaMapTestAbsentExpressionImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaMapTestAbsentExpression()
		 * @generated
		 */
		EClass ROSETTA_MAP_TEST_ABSENT_EXPRESSION = eINSTANCE.getRosettaMapTestAbsentExpression();

		/**
		 * The meta object literal for the '<em><b>Argument</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_MAP_TEST_ABSENT_EXPRESSION__ARGUMENT = eINSTANCE.getRosettaMapTestAbsentExpression_Argument();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaMapTestEqualityOperationImpl <em>Map Test Equality Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaMapTestEqualityOperationImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaMapTestEqualityOperation()
		 * @generated
		 */
		EClass ROSETTA_MAP_TEST_EQUALITY_OPERATION = eINSTANCE.getRosettaMapTestEqualityOperation();

		/**
		 * The meta object literal for the '<em><b>Left</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_MAP_TEST_EQUALITY_OPERATION__LEFT = eINSTANCE.getRosettaMapTestEqualityOperation_Left();

		/**
		 * The meta object literal for the '<em><b>Right</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_MAP_TEST_EQUALITY_OPERATION__RIGHT = eINSTANCE.getRosettaMapTestEqualityOperation_Right();

		/**
		 * The meta object literal for the '<em><b>Operator</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_MAP_TEST_EQUALITY_OPERATION__OPERATOR = eINSTANCE.getRosettaMapTestEqualityOperation_Operator();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaMapTestFuncImpl <em>Map Test Func</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaMapTestFuncImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaMapTestFunc()
		 * @generated
		 */
		EClass ROSETTA_MAP_TEST_FUNC = eINSTANCE.getRosettaMapTestFunc();

		/**
		 * The meta object literal for the '<em><b>Func</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_MAP_TEST_FUNC__FUNC = eINSTANCE.getRosettaMapTestFunc_Func();

		/**
		 * The meta object literal for the '<em><b>Predicate Path</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_MAP_TEST_FUNC__PREDICATE_PATH = eINSTANCE.getRosettaMapTestFunc_PredicatePath();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.RosettaAttributeReferenceSegment <em>Attribute Reference Segment</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.RosettaAttributeReferenceSegment
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaAttributeReferenceSegment()
		 * @generated
		 */
		EClass ROSETTA_ATTRIBUTE_REFERENCE_SEGMENT = eINSTANCE.getRosettaAttributeReferenceSegment();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaDataReferenceImpl <em>Data Reference</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaDataReferenceImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaDataReference()
		 * @generated
		 */
		EClass ROSETTA_DATA_REFERENCE = eINSTANCE.getRosettaDataReference();

		/**
		 * The meta object literal for the '<em><b>Data</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_DATA_REFERENCE__DATA = eINSTANCE.getRosettaDataReference_Data();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaAttributeReferenceImpl <em>Attribute Reference</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaAttributeReferenceImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaAttributeReference()
		 * @generated
		 */
		EClass ROSETTA_ATTRIBUTE_REFERENCE = eINSTANCE.getRosettaAttributeReference();

		/**
		 * The meta object literal for the '<em><b>Receiver</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_ATTRIBUTE_REFERENCE__RECEIVER = eINSTANCE.getRosettaAttributeReference_Receiver();

		/**
		 * The meta object literal for the '<em><b>Attribute</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_ATTRIBUTE_REFERENCE__ATTRIBUTE = eINSTANCE.getRosettaAttributeReference_Attribute();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaMappingImpl <em>Mapping</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaMappingImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaMapping()
		 * @generated
		 */
		EClass ROSETTA_MAPPING = eINSTANCE.getRosettaMapping();

		/**
		 * The meta object literal for the '<em><b>Instances</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_MAPPING__INSTANCES = eINSTANCE.getRosettaMapping_Instances();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaMappingInstanceImpl <em>Mapping Instance</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaMappingInstanceImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaMappingInstance()
		 * @generated
		 */
		EClass ROSETTA_MAPPING_INSTANCE = eINSTANCE.getRosettaMappingInstance();

		/**
		 * The meta object literal for the '<em><b>Set</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_MAPPING_INSTANCE__SET = eINSTANCE.getRosettaMappingInstance_Set();

		/**
		 * The meta object literal for the '<em><b>When</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_MAPPING_INSTANCE__WHEN = eINSTANCE.getRosettaMappingInstance_When();

		/**
		 * The meta object literal for the '<em><b>Default</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_MAPPING_INSTANCE__DEFAULT = eINSTANCE.getRosettaMappingInstance_Default();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaMappingPathTestsImpl <em>Mapping Path Tests</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaMappingPathTestsImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaMappingPathTests()
		 * @generated
		 */
		EClass ROSETTA_MAPPING_PATH_TESTS = eINSTANCE.getRosettaMappingPathTests();

		/**
		 * The meta object literal for the '<em><b>Tests</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_MAPPING_PATH_TESTS__TESTS = eINSTANCE.getRosettaMappingPathTests_Tests();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaMapPathImpl <em>Map Path</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaMapPathImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaMapPath()
		 * @generated
		 */
		EClass ROSETTA_MAP_PATH = eINSTANCE.getRosettaMapPath();

		/**
		 * The meta object literal for the '<em><b>Path</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_MAP_PATH__PATH = eINSTANCE.getRosettaMapPath_Path();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaMapRosettaPathImpl <em>Map Rosetta Path</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaMapRosettaPathImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaMapRosettaPath()
		 * @generated
		 */
		EClass ROSETTA_MAP_ROSETTA_PATH = eINSTANCE.getRosettaMapRosettaPath();

		/**
		 * The meta object literal for the '<em><b>Path</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_MAP_ROSETTA_PATH__PATH = eINSTANCE.getRosettaMapRosettaPath_Path();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaQualifiableConfigurationImpl <em>Qualifiable Configuration</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaQualifiableConfigurationImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaQualifiableConfiguration()
		 * @generated
		 */
		EClass ROSETTA_QUALIFIABLE_CONFIGURATION = eINSTANCE.getRosettaQualifiableConfiguration();

		/**
		 * The meta object literal for the '<em><b>QType</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_QUALIFIABLE_CONFIGURATION__QTYPE = eINSTANCE.getRosettaQualifiableConfiguration_QType();

		/**
		 * The meta object literal for the '<em><b>Model</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_QUALIFIABLE_CONFIGURATION__MODEL = eINSTANCE.getRosettaQualifiableConfiguration_Model();

		/**
		 * The meta object literal for the '<em><b>Rosetta Class</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_QUALIFIABLE_CONFIGURATION__ROSETTA_CLASS = eINSTANCE.getRosettaQualifiableConfiguration_RosettaClass();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.ExternalAnnotationSourceImpl <em>External Annotation Source</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.ExternalAnnotationSourceImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getExternalAnnotationSource()
		 * @generated
		 */
		EClass EXTERNAL_ANNOTATION_SOURCE = eINSTANCE.getExternalAnnotationSource();

		/**
		 * The meta object literal for the '<em><b>External Classes</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference EXTERNAL_ANNOTATION_SOURCE__EXTERNAL_CLASSES = eINSTANCE.getExternalAnnotationSource_ExternalClasses();

		/**
		 * The meta object literal for the '<em><b>External Enums</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference EXTERNAL_ANNOTATION_SOURCE__EXTERNAL_ENUMS = eINSTANCE.getExternalAnnotationSource_ExternalEnums();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaExternalRefImpl <em>External Ref</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaExternalRefImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaExternalRef()
		 * @generated
		 */
		EClass ROSETTA_EXTERNAL_REF = eINSTANCE.getRosettaExternalRef();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaExternalClassImpl <em>External Class</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaExternalClassImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaExternalClass()
		 * @generated
		 */
		EClass ROSETTA_EXTERNAL_CLASS = eINSTANCE.getRosettaExternalClass();

		/**
		 * The meta object literal for the '<em><b>Data</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_EXTERNAL_CLASS__DATA = eINSTANCE.getRosettaExternalClass_Data();

		/**
		 * The meta object literal for the '<em><b>External Class Synonyms</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_EXTERNAL_CLASS__EXTERNAL_CLASS_SYNONYMS = eINSTANCE.getRosettaExternalClass_ExternalClassSynonyms();

		/**
		 * The meta object literal for the '<em><b>Regular Attributes</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_EXTERNAL_CLASS__REGULAR_ATTRIBUTES = eINSTANCE.getRosettaExternalClass_RegularAttributes();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaExternalEnumImpl <em>External Enum</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaExternalEnumImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaExternalEnum()
		 * @generated
		 */
		EClass ROSETTA_EXTERNAL_ENUM = eINSTANCE.getRosettaExternalEnum();

		/**
		 * The meta object literal for the '<em><b>Enumeration</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_EXTERNAL_ENUM__ENUMERATION = eINSTANCE.getRosettaExternalEnum_Enumeration();

		/**
		 * The meta object literal for the '<em><b>Regular Values</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_EXTERNAL_ENUM__REGULAR_VALUES = eINSTANCE.getRosettaExternalEnum_RegularValues();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaExternalRegularAttributeImpl <em>External Regular Attribute</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaExternalRegularAttributeImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaExternalRegularAttribute()
		 * @generated
		 */
		EClass ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE = eINSTANCE.getRosettaExternalRegularAttribute();

		/**
		 * The meta object literal for the '<em><b>Operator</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE__OPERATOR = eINSTANCE.getRosettaExternalRegularAttribute_Operator();

		/**
		 * The meta object literal for the '<em><b>Attribute Ref</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE__ATTRIBUTE_REF = eINSTANCE.getRosettaExternalRegularAttribute_AttributeRef();

		/**
		 * The meta object literal for the '<em><b>External Synonyms</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE__EXTERNAL_SYNONYMS = eINSTANCE.getRosettaExternalRegularAttribute_ExternalSynonyms();

		/**
		 * The meta object literal for the '<em><b>External Rule Reference</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE__EXTERNAL_RULE_REFERENCE = eINSTANCE.getRosettaExternalRegularAttribute_ExternalRuleReference();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaExternalEnumValueImpl <em>External Enum Value</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaExternalEnumValueImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaExternalEnumValue()
		 * @generated
		 */
		EClass ROSETTA_EXTERNAL_ENUM_VALUE = eINSTANCE.getRosettaExternalEnumValue();

		/**
		 * The meta object literal for the '<em><b>Operator</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_EXTERNAL_ENUM_VALUE__OPERATOR = eINSTANCE.getRosettaExternalEnumValue_Operator();

		/**
		 * The meta object literal for the '<em><b>Enum Ref</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_EXTERNAL_ENUM_VALUE__ENUM_REF = eINSTANCE.getRosettaExternalEnumValue_EnumRef();

		/**
		 * The meta object literal for the '<em><b>External Enum Synonyms</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_EXTERNAL_ENUM_VALUE__EXTERNAL_ENUM_SYNONYMS = eINSTANCE.getRosettaExternalEnumValue_ExternalEnumSynonyms();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaExternalClassSynonymImpl <em>External Class Synonym</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaExternalClassSynonymImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaExternalClassSynonym()
		 * @generated
		 */
		EClass ROSETTA_EXTERNAL_CLASS_SYNONYM = eINSTANCE.getRosettaExternalClassSynonym();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_EXTERNAL_CLASS_SYNONYM__VALUE = eINSTANCE.getRosettaExternalClassSynonym_Value();

		/**
		 * The meta object literal for the '<em><b>Meta Value</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_EXTERNAL_CLASS_SYNONYM__META_VALUE = eINSTANCE.getRosettaExternalClassSynonym_MetaValue();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaExternalSynonymImpl <em>External Synonym</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaExternalSynonymImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaExternalSynonym()
		 * @generated
		 */
		EClass ROSETTA_EXTERNAL_SYNONYM = eINSTANCE.getRosettaExternalSynonym();

		/**
		 * The meta object literal for the '<em><b>Body</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_EXTERNAL_SYNONYM__BODY = eINSTANCE.getRosettaExternalSynonym_Body();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaExternalSynonymSourceImpl <em>External Synonym Source</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaExternalSynonymSourceImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaExternalSynonymSource()
		 * @generated
		 */
		EClass ROSETTA_EXTERNAL_SYNONYM_SOURCE = eINSTANCE.getRosettaExternalSynonymSource();

		/**
		 * The meta object literal for the '<em><b>Super Sources</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_EXTERNAL_SYNONYM_SOURCE__SUPER_SOURCES = eINSTANCE.getRosettaExternalSynonymSource_SuperSources();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaExternalRuleSourceImpl <em>External Rule Source</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaExternalRuleSourceImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaExternalRuleSource()
		 * @generated
		 */
		EClass ROSETTA_EXTERNAL_RULE_SOURCE = eINSTANCE.getRosettaExternalRuleSource();

		/**
		 * The meta object literal for the '<em><b>Super Sources</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_EXTERNAL_RULE_SOURCE__SUPER_SOURCES = eINSTANCE.getRosettaExternalRuleSource_SuperSources();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaReportImpl <em>Report</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaReportImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaReport()
		 * @generated
		 */
		EClass ROSETTA_REPORT = eINSTANCE.getRosettaReport();

		/**
		 * The meta object literal for the '<em><b>Regulatory Body</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_REPORT__REGULATORY_BODY = eINSTANCE.getRosettaReport_RegulatoryBody();

		/**
		 * The meta object literal for the '<em><b>Eligibility Rules</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_REPORT__ELIGIBILITY_RULES = eINSTANCE.getRosettaReport_EligibilityRules();

		/**
		 * The meta object literal for the '<em><b>Reporting Standard</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_REPORT__REPORTING_STANDARD = eINSTANCE.getRosettaReport_ReportingStandard();

		/**
		 * The meta object literal for the '<em><b>Input Type</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_REPORT__INPUT_TYPE = eINSTANCE.getRosettaReport_InputType();

		/**
		 * The meta object literal for the '<em><b>Report Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_REPORT__REPORT_TYPE = eINSTANCE.getRosettaReport_ReportType();

		/**
		 * The meta object literal for the '<em><b>Rule Source</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_REPORT__RULE_SOURCE = eINSTANCE.getRosettaReport_RuleSource();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.impl.RosettaRuleImpl <em>Rule</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaRuleImpl
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaRule()
		 * @generated
		 */
		EClass ROSETTA_RULE = eINSTANCE.getRosettaRule();

		/**
		 * The meta object literal for the '<em><b>Eligibility</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_RULE__ELIGIBILITY = eINSTANCE.getRosettaRule_Eligibility();

		/**
		 * The meta object literal for the '<em><b>Expression</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_RULE__EXPRESSION = eINSTANCE.getRosettaRule_Expression();

		/**
		 * The meta object literal for the '<em><b>Identifier</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_RULE__IDENTIFIER = eINSTANCE.getRosettaRule_Identifier();

		/**
		 * The meta object literal for the '<em><b>Input</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_RULE__INPUT = eINSTANCE.getRosettaRule_Input();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.RosettaSynonymRef <em>Synonym Ref</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.RosettaSynonymRef
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaSynonymRef()
		 * @generated
		 */
		EEnum ROSETTA_SYNONYM_REF = eINSTANCE.getRosettaSynonymRef();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.RosettaQualifiableType <em>Qualifiable Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.RosettaQualifiableType
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getRosettaQualifiableType()
		 * @generated
		 */
		EEnum ROSETTA_QUALIFIABLE_TYPE = eINSTANCE.getRosettaQualifiableType();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.ExternalValueOperator <em>External Value Operator</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.ExternalValueOperator
		 * @see com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl#getExternalValueOperator()
		 * @generated
		 */
		EEnum EXTERNAL_VALUE_OPERATOR = eINSTANCE.getExternalValueOperator();

	}

} //RosettaPackage
