/**
 * Copyright (c) REGnosys 2017 (www.regnosys.com)
 */
package com.regnosys.rosetta.rosetta.expression.impl;

import com.regnosys.rosetta.rosetta.expression.ChoiceOperation;
import com.regnosys.rosetta.rosetta.expression.ExpressionPackage;
import com.regnosys.rosetta.rosetta.expression.HasGeneratedInput;
import com.regnosys.rosetta.rosetta.expression.Necessity;
import com.regnosys.rosetta.rosetta.expression.RosettaExpression;

import com.regnosys.rosetta.rosetta.simple.Attribute;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectResolvingEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Choice Operation</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link com.regnosys.rosetta.rosetta.expression.impl.ChoiceOperationImpl#isGenerated <em>Generated</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.expression.impl.ChoiceOperationImpl#getOperator <em>Operator</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.expression.impl.ChoiceOperationImpl#isGeneratedInputWasSet <em>Generated Input Was Set</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.expression.impl.ChoiceOperationImpl#getArgument <em>Argument</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.expression.impl.ChoiceOperationImpl#getNecessity <em>Necessity</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.expression.impl.ChoiceOperationImpl#getAttributes <em>Attributes</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ChoiceOperationImpl extends MinimalEObjectImpl.Container implements ChoiceOperation {
	/**
	 * The default value of the '{@link #isGenerated() <em>Generated</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isGenerated()
	 * @generated
	 * @ordered
	 */
	protected static final boolean GENERATED_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isGenerated() <em>Generated</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isGenerated()
	 * @generated
	 * @ordered
	 */
	protected boolean generated = GENERATED_EDEFAULT;

	/**
	 * The default value of the '{@link #getOperator() <em>Operator</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOperator()
	 * @generated
	 * @ordered
	 */
	protected static final String OPERATOR_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getOperator() <em>Operator</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOperator()
	 * @generated
	 * @ordered
	 */
	protected String operator = OPERATOR_EDEFAULT;

	/**
	 * The default value of the '{@link #isGeneratedInputWasSet() <em>Generated Input Was Set</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isGeneratedInputWasSet()
	 * @generated
	 * @ordered
	 */
	protected static final boolean GENERATED_INPUT_WAS_SET_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isGeneratedInputWasSet() <em>Generated Input Was Set</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isGeneratedInputWasSet()
	 * @generated
	 * @ordered
	 */
	protected boolean generatedInputWasSet = GENERATED_INPUT_WAS_SET_EDEFAULT;

	/**
	 * The cached value of the '{@link #getArgument() <em>Argument</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getArgument()
	 * @generated
	 * @ordered
	 */
	protected RosettaExpression argument;

	/**
	 * The default value of the '{@link #getNecessity() <em>Necessity</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNecessity()
	 * @generated
	 * @ordered
	 */
	protected static final Necessity NECESSITY_EDEFAULT = Necessity.OPTIONAL;

	/**
	 * The cached value of the '{@link #getNecessity() <em>Necessity</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNecessity()
	 * @generated
	 * @ordered
	 */
	protected Necessity necessity = NECESSITY_EDEFAULT;

	/**
	 * The cached value of the '{@link #getAttributes() <em>Attributes</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAttributes()
	 * @generated
	 * @ordered
	 */
	protected EList<Attribute> attributes;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ChoiceOperationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ExpressionPackage.Literals.CHOICE_OPERATION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isGenerated() {
		return generated;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setGenerated(boolean newGenerated) {
		boolean oldGenerated = generated;
		generated = newGenerated;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExpressionPackage.CHOICE_OPERATION__GENERATED, oldGenerated, generated));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getOperator() {
		return operator;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setOperator(String newOperator) {
		String oldOperator = operator;
		operator = newOperator;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExpressionPackage.CHOICE_OPERATION__OPERATOR, oldOperator, operator));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isGeneratedInputWasSet() {
		return generatedInputWasSet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setGeneratedInputWasSet(boolean newGeneratedInputWasSet) {
		boolean oldGeneratedInputWasSet = generatedInputWasSet;
		generatedInputWasSet = newGeneratedInputWasSet;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExpressionPackage.CHOICE_OPERATION__GENERATED_INPUT_WAS_SET, oldGeneratedInputWasSet, generatedInputWasSet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaExpression getArgument() {
		return argument;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetArgument(RosettaExpression newArgument, NotificationChain msgs) {
		RosettaExpression oldArgument = argument;
		argument = newArgument;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ExpressionPackage.CHOICE_OPERATION__ARGUMENT, oldArgument, newArgument);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setArgument(RosettaExpression newArgument) {
		if (newArgument != argument) {
			NotificationChain msgs = null;
			if (argument != null)
				msgs = ((InternalEObject)argument).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ExpressionPackage.CHOICE_OPERATION__ARGUMENT, null, msgs);
			if (newArgument != null)
				msgs = ((InternalEObject)newArgument).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ExpressionPackage.CHOICE_OPERATION__ARGUMENT, null, msgs);
			msgs = basicSetArgument(newArgument, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExpressionPackage.CHOICE_OPERATION__ARGUMENT, newArgument, newArgument));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Necessity getNecessity() {
		return necessity;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setNecessity(Necessity newNecessity) {
		Necessity oldNecessity = necessity;
		necessity = newNecessity == null ? NECESSITY_EDEFAULT : newNecessity;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExpressionPackage.CHOICE_OPERATION__NECESSITY, oldNecessity, necessity));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Attribute> getAttributes() {
		if (attributes == null) {
			attributes = new EObjectResolvingEList<Attribute>(Attribute.class, this, ExpressionPackage.CHOICE_OPERATION__ATTRIBUTES);
		}
		return attributes;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaExpression getInput() {
		return this.getArgument();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setGeneratedInputIfAbsent(final RosettaExpression e) {
		if ((e == null)) {
			boolean _isGeneratedInputWasSet = this.isGeneratedInputWasSet();
			if (_isGeneratedInputWasSet) {
				this.setArgument(null);
				this.setGeneratedInputWasSet(false);
			}
		}
		else {
			boolean _isGeneratedInputWasSet_1 = this.isGeneratedInputWasSet();
			boolean _not = (!_isGeneratedInputWasSet_1);
			if (_not) {
				this.setArgument(e);
				this.setGeneratedInputWasSet(true);
			}
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean needsGeneratedInput() {
		RosettaExpression _argument = this.getArgument();
		return (_argument == null);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ExpressionPackage.CHOICE_OPERATION__ARGUMENT:
				return basicSetArgument(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ExpressionPackage.CHOICE_OPERATION__GENERATED:
				return isGenerated();
			case ExpressionPackage.CHOICE_OPERATION__OPERATOR:
				return getOperator();
			case ExpressionPackage.CHOICE_OPERATION__GENERATED_INPUT_WAS_SET:
				return isGeneratedInputWasSet();
			case ExpressionPackage.CHOICE_OPERATION__ARGUMENT:
				return getArgument();
			case ExpressionPackage.CHOICE_OPERATION__NECESSITY:
				return getNecessity();
			case ExpressionPackage.CHOICE_OPERATION__ATTRIBUTES:
				return getAttributes();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ExpressionPackage.CHOICE_OPERATION__GENERATED:
				setGenerated((Boolean)newValue);
				return;
			case ExpressionPackage.CHOICE_OPERATION__OPERATOR:
				setOperator((String)newValue);
				return;
			case ExpressionPackage.CHOICE_OPERATION__GENERATED_INPUT_WAS_SET:
				setGeneratedInputWasSet((Boolean)newValue);
				return;
			case ExpressionPackage.CHOICE_OPERATION__ARGUMENT:
				setArgument((RosettaExpression)newValue);
				return;
			case ExpressionPackage.CHOICE_OPERATION__NECESSITY:
				setNecessity((Necessity)newValue);
				return;
			case ExpressionPackage.CHOICE_OPERATION__ATTRIBUTES:
				getAttributes().clear();
				getAttributes().addAll((Collection<? extends Attribute>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ExpressionPackage.CHOICE_OPERATION__GENERATED:
				setGenerated(GENERATED_EDEFAULT);
				return;
			case ExpressionPackage.CHOICE_OPERATION__OPERATOR:
				setOperator(OPERATOR_EDEFAULT);
				return;
			case ExpressionPackage.CHOICE_OPERATION__GENERATED_INPUT_WAS_SET:
				setGeneratedInputWasSet(GENERATED_INPUT_WAS_SET_EDEFAULT);
				return;
			case ExpressionPackage.CHOICE_OPERATION__ARGUMENT:
				setArgument((RosettaExpression)null);
				return;
			case ExpressionPackage.CHOICE_OPERATION__NECESSITY:
				setNecessity(NECESSITY_EDEFAULT);
				return;
			case ExpressionPackage.CHOICE_OPERATION__ATTRIBUTES:
				getAttributes().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ExpressionPackage.CHOICE_OPERATION__GENERATED:
				return generated != GENERATED_EDEFAULT;
			case ExpressionPackage.CHOICE_OPERATION__OPERATOR:
				return OPERATOR_EDEFAULT == null ? operator != null : !OPERATOR_EDEFAULT.equals(operator);
			case ExpressionPackage.CHOICE_OPERATION__GENERATED_INPUT_WAS_SET:
				return generatedInputWasSet != GENERATED_INPUT_WAS_SET_EDEFAULT;
			case ExpressionPackage.CHOICE_OPERATION__ARGUMENT:
				return argument != null;
			case ExpressionPackage.CHOICE_OPERATION__NECESSITY:
				return necessity != NECESSITY_EDEFAULT;
			case ExpressionPackage.CHOICE_OPERATION__ATTRIBUTES:
				return attributes != null && !attributes.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == HasGeneratedInput.class) {
			switch (derivedFeatureID) {
				case ExpressionPackage.CHOICE_OPERATION__GENERATED_INPUT_WAS_SET: return ExpressionPackage.HAS_GENERATED_INPUT__GENERATED_INPUT_WAS_SET;
				default: return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == HasGeneratedInput.class) {
			switch (baseFeatureID) {
				case ExpressionPackage.HAS_GENERATED_INPUT__GENERATED_INPUT_WAS_SET: return ExpressionPackage.CHOICE_OPERATION__GENERATED_INPUT_WAS_SET;
				default: return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (generated: ");
		result.append(generated);
		result.append(", operator: ");
		result.append(operator);
		result.append(", generatedInputWasSet: ");
		result.append(generatedInputWasSet);
		result.append(", necessity: ");
		result.append(necessity);
		result.append(')');
		return result.toString();
	}

} //ChoiceOperationImpl
