/**
 * Copyright (c) REGnosys 2017 (www.regnosys.com)
 */
package com.regnosys.rosetta.rosetta.expression.impl;

import com.regnosys.rosetta.rosetta.RosettaPackage;

import com.regnosys.rosetta.rosetta.expression.ArithmeticOperation;
import com.regnosys.rosetta.rosetta.expression.AsKeyOperation;
import com.regnosys.rosetta.rosetta.expression.CanHandleListOfLists;
import com.regnosys.rosetta.rosetta.expression.CardinalityModifier;
import com.regnosys.rosetta.rosetta.expression.ChoiceOperation;
import com.regnosys.rosetta.rosetta.expression.ClosureParameter;
import com.regnosys.rosetta.rosetta.expression.ComparingFunctionalOperation;
import com.regnosys.rosetta.rosetta.expression.ComparisonOperation;
import com.regnosys.rosetta.rosetta.expression.ConstructorKeyValuePair;
import com.regnosys.rosetta.rosetta.expression.DefaultOperation;
import com.regnosys.rosetta.rosetta.expression.DistinctOperation;
import com.regnosys.rosetta.rosetta.expression.EqualityOperation;
import com.regnosys.rosetta.rosetta.expression.ExistsModifier;
import com.regnosys.rosetta.rosetta.expression.ExpressionFactory;
import com.regnosys.rosetta.rosetta.expression.ExpressionPackage;
import com.regnosys.rosetta.rosetta.expression.FilterOperation;
import com.regnosys.rosetta.rosetta.expression.FirstOperation;
import com.regnosys.rosetta.rosetta.expression.FlattenOperation;
import com.regnosys.rosetta.rosetta.expression.HasGeneratedInput;
import com.regnosys.rosetta.rosetta.expression.InlineFunction;
import com.regnosys.rosetta.rosetta.expression.JoinOperation;
import com.regnosys.rosetta.rosetta.expression.LastOperation;
import com.regnosys.rosetta.rosetta.expression.ListLiteral;
import com.regnosys.rosetta.rosetta.expression.ListOperation;
import com.regnosys.rosetta.rosetta.expression.LogicalOperation;
import com.regnosys.rosetta.rosetta.expression.MandatoryFunctionalOperation;
import com.regnosys.rosetta.rosetta.expression.MapOperation;
import com.regnosys.rosetta.rosetta.expression.MaxOperation;
import com.regnosys.rosetta.rosetta.expression.MinOperation;
import com.regnosys.rosetta.rosetta.expression.ModifiableBinaryOperation;
import com.regnosys.rosetta.rosetta.expression.Necessity;
import com.regnosys.rosetta.rosetta.expression.OneOfOperation;
import com.regnosys.rosetta.rosetta.expression.ParseOperation;
import com.regnosys.rosetta.rosetta.expression.ReduceOperation;
import com.regnosys.rosetta.rosetta.expression.ReverseOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaAbsentExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaBinaryOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaBooleanLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaConditionalExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaConstructorExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaContainsExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaCountOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaDeepFeatureCall;
import com.regnosys.rosetta.rosetta.expression.RosettaDisjointExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaExistsExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaFeatureCall;
import com.regnosys.rosetta.rosetta.expression.RosettaFunctionalOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaImplicitVariable;
import com.regnosys.rosetta.rosetta.expression.RosettaIntLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaNumberLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaOnlyElement;
import com.regnosys.rosetta.rosetta.expression.RosettaOnlyExistsExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaPatternLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaReference;
import com.regnosys.rosetta.rosetta.expression.RosettaStringLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaSymbolReference;
import com.regnosys.rosetta.rosetta.expression.RosettaUnaryOperation;
import com.regnosys.rosetta.rosetta.expression.SortOperation;
import com.regnosys.rosetta.rosetta.expression.SumOperation;
import com.regnosys.rosetta.rosetta.expression.ThenOperation;
import com.regnosys.rosetta.rosetta.expression.ToDateOperation;
import com.regnosys.rosetta.rosetta.expression.ToDateTimeOperation;
import com.regnosys.rosetta.rosetta.expression.ToEnumOperation;
import com.regnosys.rosetta.rosetta.expression.ToIntOperation;
import com.regnosys.rosetta.rosetta.expression.ToNumberOperation;
import com.regnosys.rosetta.rosetta.expression.ToStringOperation;
import com.regnosys.rosetta.rosetta.expression.ToTimeOperation;
import com.regnosys.rosetta.rosetta.expression.ToZonedDateTimeOperation;
import com.regnosys.rosetta.rosetta.expression.UnaryFunctionalOperation;

import com.regnosys.rosetta.rosetta.impl.RosettaPackageImpl;

import com.regnosys.rosetta.rosetta.simple.SimplePackage;

import com.regnosys.rosetta.rosetta.simple.impl.SimplePackageImpl;

import java.util.regex.Pattern;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;

import org.eclipse.emf.ecore.impl.EPackageImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class ExpressionPackageImpl extends EPackageImpl implements ExpressionPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass rosettaExpressionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass hasGeneratedInputEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass rosettaLiteralEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass rosettaBooleanLiteralEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass rosettaStringLiteralEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass rosettaNumberLiteralEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass rosettaIntLiteralEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass rosettaPatternLiteralEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass listLiteralEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass rosettaReferenceEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass rosettaSymbolReferenceEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass rosettaImplicitVariableEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass rosettaFeatureCallEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass rosettaDeepFeatureCallEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass rosettaConditionalExpressionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass rosettaConstructorExpressionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass constructorKeyValuePairEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass rosettaOperationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass rosettaBinaryOperationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass arithmeticOperationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass defaultOperationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass logicalOperationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass modifiableBinaryOperationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass equalityOperationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass comparisonOperationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass rosettaContainsExpressionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass rosettaDisjointExpressionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass joinOperationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass rosettaOnlyExistsExpressionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass rosettaUnaryOperationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass listOperationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass canHandleListOfListsEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass rosettaExistsExpressionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass rosettaAbsentExpressionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass rosettaOnlyElementEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass rosettaCountOperationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass flattenOperationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass distinctOperationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass reverseOperationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass firstOperationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass lastOperationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass sumOperationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass asKeyOperationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass oneOfOperationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass choiceOperationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass toStringOperationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass parseOperationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass toNumberOperationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass toIntOperationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass toTimeOperationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass toEnumOperationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass toDateOperationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass toDateTimeOperationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass toZonedDateTimeOperationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass closureParameterEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass inlineFunctionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass rosettaFunctionalOperationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass mandatoryFunctionalOperationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass unaryFunctionalOperationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass reduceOperationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass filterOperationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass mapOperationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass thenOperationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass comparingFunctionalOperationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass sortOperationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass minOperationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass maxOperationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum cardinalityModifierEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum existsModifierEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum necessityEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType patternEDataType = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see com.regnosys.rosetta.rosetta.expression.ExpressionPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private ExpressionPackageImpl() {
		super(eNS_URI, ExpressionFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
	 *
	 * <p>This method is used to initialize {@link ExpressionPackage#eINSTANCE} when that field is accessed.
	 * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static ExpressionPackage init() {
		if (isInited) return (ExpressionPackage)EPackage.Registry.INSTANCE.getEPackage(ExpressionPackage.eNS_URI);

		// Obtain or create and register package
		Object registeredExpressionPackage = EPackage.Registry.INSTANCE.get(eNS_URI);
		ExpressionPackageImpl theExpressionPackage = registeredExpressionPackage instanceof ExpressionPackageImpl ? (ExpressionPackageImpl)registeredExpressionPackage : new ExpressionPackageImpl();

		isInited = true;

		// Initialize simple dependencies
		EcorePackage.eINSTANCE.eClass();

		// Obtain or create and register interdependencies
		Object registeredPackage = EPackage.Registry.INSTANCE.getEPackage(RosettaPackage.eNS_URI);
		RosettaPackageImpl theRosettaPackage = (RosettaPackageImpl)(registeredPackage instanceof RosettaPackageImpl ? registeredPackage : RosettaPackage.eINSTANCE);
		registeredPackage = EPackage.Registry.INSTANCE.getEPackage(SimplePackage.eNS_URI);
		SimplePackageImpl theSimplePackage = (SimplePackageImpl)(registeredPackage instanceof SimplePackageImpl ? registeredPackage : SimplePackage.eINSTANCE);

		// Create package meta-data objects
		theExpressionPackage.createPackageContents();
		theRosettaPackage.createPackageContents();
		theSimplePackage.createPackageContents();

		// Initialize created meta-data
		theExpressionPackage.initializePackageContents();
		theRosettaPackage.initializePackageContents();
		theSimplePackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theExpressionPackage.freeze();

		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(ExpressionPackage.eNS_URI, theExpressionPackage);
		return theExpressionPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getRosettaExpression() {
		return rosettaExpressionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getRosettaExpression_Generated() {
		return (EAttribute)rosettaExpressionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getHasGeneratedInput() {
		return hasGeneratedInputEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getHasGeneratedInput_GeneratedInputWasSet() {
		return (EAttribute)hasGeneratedInputEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getRosettaLiteral() {
		return rosettaLiteralEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getRosettaBooleanLiteral() {
		return rosettaBooleanLiteralEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getRosettaBooleanLiteral_Value() {
		return (EAttribute)rosettaBooleanLiteralEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getRosettaStringLiteral() {
		return rosettaStringLiteralEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getRosettaStringLiteral_Value() {
		return (EAttribute)rosettaStringLiteralEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getRosettaNumberLiteral() {
		return rosettaNumberLiteralEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getRosettaNumberLiteral_Value() {
		return (EAttribute)rosettaNumberLiteralEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getRosettaIntLiteral() {
		return rosettaIntLiteralEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getRosettaIntLiteral_Value() {
		return (EAttribute)rosettaIntLiteralEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getRosettaPatternLiteral() {
		return rosettaPatternLiteralEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getRosettaPatternLiteral_Value() {
		return (EAttribute)rosettaPatternLiteralEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getListLiteral() {
		return listLiteralEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getListLiteral_Elements() {
		return (EReference)listLiteralEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getRosettaReference() {
		return rosettaReferenceEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getRosettaSymbolReference() {
		return rosettaSymbolReferenceEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getRosettaSymbolReference_Symbol() {
		return (EReference)rosettaSymbolReferenceEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getRosettaSymbolReference_ExplicitArguments() {
		return (EAttribute)rosettaSymbolReferenceEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getRosettaSymbolReference_RawArgs() {
		return (EReference)rosettaSymbolReferenceEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getRosettaSymbolReference_ImplicitVariableIsInContext() {
		return (EAttribute)rosettaSymbolReferenceEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getRosettaSymbolReference_ImplicitArgument() {
		return (EReference)rosettaSymbolReferenceEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getRosettaImplicitVariable() {
		return rosettaImplicitVariableEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getRosettaFeatureCall() {
		return rosettaFeatureCallEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getRosettaFeatureCall_Receiver() {
		return (EReference)rosettaFeatureCallEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getRosettaFeatureCall_Feature() {
		return (EReference)rosettaFeatureCallEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getRosettaDeepFeatureCall() {
		return rosettaDeepFeatureCallEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getRosettaDeepFeatureCall_Receiver() {
		return (EReference)rosettaDeepFeatureCallEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getRosettaDeepFeatureCall_Feature() {
		return (EReference)rosettaDeepFeatureCallEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getRosettaConditionalExpression() {
		return rosettaConditionalExpressionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getRosettaConditionalExpression_If() {
		return (EReference)rosettaConditionalExpressionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getRosettaConditionalExpression_Ifthen() {
		return (EReference)rosettaConditionalExpressionEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getRosettaConditionalExpression_Elsethen() {
		return (EReference)rosettaConditionalExpressionEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getRosettaConditionalExpression_Full() {
		return (EAttribute)rosettaConditionalExpressionEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getRosettaConstructorExpression() {
		return rosettaConstructorExpressionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getRosettaConstructorExpression_Values() {
		return (EReference)rosettaConstructorExpressionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getRosettaConstructorExpression_ImplicitEmpty() {
		return (EAttribute)rosettaConstructorExpressionEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getConstructorKeyValuePair() {
		return constructorKeyValuePairEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getConstructorKeyValuePair_Key() {
		return (EReference)constructorKeyValuePairEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getConstructorKeyValuePair_Value() {
		return (EReference)constructorKeyValuePairEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getRosettaOperation() {
		return rosettaOperationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getRosettaOperation_Operator() {
		return (EAttribute)rosettaOperationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getRosettaBinaryOperation() {
		return rosettaBinaryOperationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getRosettaBinaryOperation_Left() {
		return (EReference)rosettaBinaryOperationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getRosettaBinaryOperation_Right() {
		return (EReference)rosettaBinaryOperationEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getArithmeticOperation() {
		return arithmeticOperationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getDefaultOperation() {
		return defaultOperationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getLogicalOperation() {
		return logicalOperationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getModifiableBinaryOperation() {
		return modifiableBinaryOperationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getModifiableBinaryOperation_CardMod() {
		return (EAttribute)modifiableBinaryOperationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getEqualityOperation() {
		return equalityOperationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getComparisonOperation() {
		return comparisonOperationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getRosettaContainsExpression() {
		return rosettaContainsExpressionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getRosettaDisjointExpression() {
		return rosettaDisjointExpressionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getJoinOperation() {
		return joinOperationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getJoinOperation_ExplicitSeparator() {
		return (EAttribute)joinOperationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getRosettaOnlyExistsExpression() {
		return rosettaOnlyExistsExpressionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getRosettaOnlyExistsExpression_Args() {
		return (EReference)rosettaOnlyExistsExpressionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getRosettaUnaryOperation() {
		return rosettaUnaryOperationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getRosettaUnaryOperation_Argument() {
		return (EReference)rosettaUnaryOperationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getListOperation() {
		return listOperationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getCanHandleListOfLists() {
		return canHandleListOfListsEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getRosettaExistsExpression() {
		return rosettaExistsExpressionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getRosettaExistsExpression_Modifier() {
		return (EAttribute)rosettaExistsExpressionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getRosettaAbsentExpression() {
		return rosettaAbsentExpressionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getRosettaOnlyElement() {
		return rosettaOnlyElementEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getRosettaCountOperation() {
		return rosettaCountOperationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getFlattenOperation() {
		return flattenOperationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getDistinctOperation() {
		return distinctOperationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getReverseOperation() {
		return reverseOperationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getFirstOperation() {
		return firstOperationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getLastOperation() {
		return lastOperationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getSumOperation() {
		return sumOperationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getAsKeyOperation() {
		return asKeyOperationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getOneOfOperation() {
		return oneOfOperationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getChoiceOperation() {
		return choiceOperationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getChoiceOperation_Necessity() {
		return (EAttribute)choiceOperationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getChoiceOperation_Attributes() {
		return (EReference)choiceOperationEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getToStringOperation() {
		return toStringOperationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getParseOperation() {
		return parseOperationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getToNumberOperation() {
		return toNumberOperationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getToIntOperation() {
		return toIntOperationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getToTimeOperation() {
		return toTimeOperationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getToEnumOperation() {
		return toEnumOperationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getToEnumOperation_Enumeration() {
		return (EReference)toEnumOperationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getToDateOperation() {
		return toDateOperationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getToDateTimeOperation() {
		return toDateTimeOperationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getToZonedDateTimeOperation() {
		return toZonedDateTimeOperationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getClosureParameter() {
		return closureParameterEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getClosureParameter_Function() {
		return (EReference)closureParameterEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getInlineFunction() {
		return inlineFunctionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getInlineFunction_Parameters() {
		return (EReference)inlineFunctionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getInlineFunction_Body() {
		return (EReference)inlineFunctionEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getRosettaFunctionalOperation() {
		return rosettaFunctionalOperationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getRosettaFunctionalOperation_Function() {
		return (EReference)rosettaFunctionalOperationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getMandatoryFunctionalOperation() {
		return mandatoryFunctionalOperationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getUnaryFunctionalOperation() {
		return unaryFunctionalOperationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getReduceOperation() {
		return reduceOperationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getFilterOperation() {
		return filterOperationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getMapOperation() {
		return mapOperationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getThenOperation() {
		return thenOperationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getComparingFunctionalOperation() {
		return comparingFunctionalOperationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getSortOperation() {
		return sortOperationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getMinOperation() {
		return minOperationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getMaxOperation() {
		return maxOperationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getCardinalityModifier() {
		return cardinalityModifierEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getExistsModifier() {
		return existsModifierEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getNecessity() {
		return necessityEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EDataType getPattern() {
		return patternEDataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ExpressionFactory getExpressionFactory() {
		return (ExpressionFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		rosettaExpressionEClass = createEClass(ROSETTA_EXPRESSION);
		createEAttribute(rosettaExpressionEClass, ROSETTA_EXPRESSION__GENERATED);

		hasGeneratedInputEClass = createEClass(HAS_GENERATED_INPUT);
		createEAttribute(hasGeneratedInputEClass, HAS_GENERATED_INPUT__GENERATED_INPUT_WAS_SET);

		rosettaLiteralEClass = createEClass(ROSETTA_LITERAL);

		rosettaBooleanLiteralEClass = createEClass(ROSETTA_BOOLEAN_LITERAL);
		createEAttribute(rosettaBooleanLiteralEClass, ROSETTA_BOOLEAN_LITERAL__VALUE);

		rosettaStringLiteralEClass = createEClass(ROSETTA_STRING_LITERAL);
		createEAttribute(rosettaStringLiteralEClass, ROSETTA_STRING_LITERAL__VALUE);

		rosettaNumberLiteralEClass = createEClass(ROSETTA_NUMBER_LITERAL);
		createEAttribute(rosettaNumberLiteralEClass, ROSETTA_NUMBER_LITERAL__VALUE);

		rosettaIntLiteralEClass = createEClass(ROSETTA_INT_LITERAL);
		createEAttribute(rosettaIntLiteralEClass, ROSETTA_INT_LITERAL__VALUE);

		rosettaPatternLiteralEClass = createEClass(ROSETTA_PATTERN_LITERAL);
		createEAttribute(rosettaPatternLiteralEClass, ROSETTA_PATTERN_LITERAL__VALUE);

		listLiteralEClass = createEClass(LIST_LITERAL);
		createEReference(listLiteralEClass, LIST_LITERAL__ELEMENTS);

		rosettaReferenceEClass = createEClass(ROSETTA_REFERENCE);

		rosettaSymbolReferenceEClass = createEClass(ROSETTA_SYMBOL_REFERENCE);
		createEReference(rosettaSymbolReferenceEClass, ROSETTA_SYMBOL_REFERENCE__SYMBOL);
		createEAttribute(rosettaSymbolReferenceEClass, ROSETTA_SYMBOL_REFERENCE__EXPLICIT_ARGUMENTS);
		createEReference(rosettaSymbolReferenceEClass, ROSETTA_SYMBOL_REFERENCE__RAW_ARGS);
		createEAttribute(rosettaSymbolReferenceEClass, ROSETTA_SYMBOL_REFERENCE__IMPLICIT_VARIABLE_IS_IN_CONTEXT);
		createEReference(rosettaSymbolReferenceEClass, ROSETTA_SYMBOL_REFERENCE__IMPLICIT_ARGUMENT);

		rosettaImplicitVariableEClass = createEClass(ROSETTA_IMPLICIT_VARIABLE);

		rosettaFeatureCallEClass = createEClass(ROSETTA_FEATURE_CALL);
		createEReference(rosettaFeatureCallEClass, ROSETTA_FEATURE_CALL__RECEIVER);
		createEReference(rosettaFeatureCallEClass, ROSETTA_FEATURE_CALL__FEATURE);

		rosettaDeepFeatureCallEClass = createEClass(ROSETTA_DEEP_FEATURE_CALL);
		createEReference(rosettaDeepFeatureCallEClass, ROSETTA_DEEP_FEATURE_CALL__RECEIVER);
		createEReference(rosettaDeepFeatureCallEClass, ROSETTA_DEEP_FEATURE_CALL__FEATURE);

		rosettaConditionalExpressionEClass = createEClass(ROSETTA_CONDITIONAL_EXPRESSION);
		createEReference(rosettaConditionalExpressionEClass, ROSETTA_CONDITIONAL_EXPRESSION__IF);
		createEReference(rosettaConditionalExpressionEClass, ROSETTA_CONDITIONAL_EXPRESSION__IFTHEN);
		createEReference(rosettaConditionalExpressionEClass, ROSETTA_CONDITIONAL_EXPRESSION__ELSETHEN);
		createEAttribute(rosettaConditionalExpressionEClass, ROSETTA_CONDITIONAL_EXPRESSION__FULL);

		rosettaConstructorExpressionEClass = createEClass(ROSETTA_CONSTRUCTOR_EXPRESSION);
		createEReference(rosettaConstructorExpressionEClass, ROSETTA_CONSTRUCTOR_EXPRESSION__VALUES);
		createEAttribute(rosettaConstructorExpressionEClass, ROSETTA_CONSTRUCTOR_EXPRESSION__IMPLICIT_EMPTY);

		constructorKeyValuePairEClass = createEClass(CONSTRUCTOR_KEY_VALUE_PAIR);
		createEReference(constructorKeyValuePairEClass, CONSTRUCTOR_KEY_VALUE_PAIR__KEY);
		createEReference(constructorKeyValuePairEClass, CONSTRUCTOR_KEY_VALUE_PAIR__VALUE);

		rosettaOperationEClass = createEClass(ROSETTA_OPERATION);
		createEAttribute(rosettaOperationEClass, ROSETTA_OPERATION__OPERATOR);

		rosettaBinaryOperationEClass = createEClass(ROSETTA_BINARY_OPERATION);
		createEReference(rosettaBinaryOperationEClass, ROSETTA_BINARY_OPERATION__LEFT);
		createEReference(rosettaBinaryOperationEClass, ROSETTA_BINARY_OPERATION__RIGHT);

		arithmeticOperationEClass = createEClass(ARITHMETIC_OPERATION);

		defaultOperationEClass = createEClass(DEFAULT_OPERATION);

		logicalOperationEClass = createEClass(LOGICAL_OPERATION);

		modifiableBinaryOperationEClass = createEClass(MODIFIABLE_BINARY_OPERATION);
		createEAttribute(modifiableBinaryOperationEClass, MODIFIABLE_BINARY_OPERATION__CARD_MOD);

		equalityOperationEClass = createEClass(EQUALITY_OPERATION);

		comparisonOperationEClass = createEClass(COMPARISON_OPERATION);

		rosettaContainsExpressionEClass = createEClass(ROSETTA_CONTAINS_EXPRESSION);

		rosettaDisjointExpressionEClass = createEClass(ROSETTA_DISJOINT_EXPRESSION);

		joinOperationEClass = createEClass(JOIN_OPERATION);
		createEAttribute(joinOperationEClass, JOIN_OPERATION__EXPLICIT_SEPARATOR);

		rosettaOnlyExistsExpressionEClass = createEClass(ROSETTA_ONLY_EXISTS_EXPRESSION);
		createEReference(rosettaOnlyExistsExpressionEClass, ROSETTA_ONLY_EXISTS_EXPRESSION__ARGS);

		rosettaUnaryOperationEClass = createEClass(ROSETTA_UNARY_OPERATION);
		createEReference(rosettaUnaryOperationEClass, ROSETTA_UNARY_OPERATION__ARGUMENT);

		listOperationEClass = createEClass(LIST_OPERATION);

		canHandleListOfListsEClass = createEClass(CAN_HANDLE_LIST_OF_LISTS);

		rosettaExistsExpressionEClass = createEClass(ROSETTA_EXISTS_EXPRESSION);
		createEAttribute(rosettaExistsExpressionEClass, ROSETTA_EXISTS_EXPRESSION__MODIFIER);

		rosettaAbsentExpressionEClass = createEClass(ROSETTA_ABSENT_EXPRESSION);

		rosettaOnlyElementEClass = createEClass(ROSETTA_ONLY_ELEMENT);

		rosettaCountOperationEClass = createEClass(ROSETTA_COUNT_OPERATION);

		flattenOperationEClass = createEClass(FLATTEN_OPERATION);

		distinctOperationEClass = createEClass(DISTINCT_OPERATION);

		reverseOperationEClass = createEClass(REVERSE_OPERATION);

		firstOperationEClass = createEClass(FIRST_OPERATION);

		lastOperationEClass = createEClass(LAST_OPERATION);

		sumOperationEClass = createEClass(SUM_OPERATION);

		asKeyOperationEClass = createEClass(AS_KEY_OPERATION);

		oneOfOperationEClass = createEClass(ONE_OF_OPERATION);

		choiceOperationEClass = createEClass(CHOICE_OPERATION);
		createEAttribute(choiceOperationEClass, CHOICE_OPERATION__NECESSITY);
		createEReference(choiceOperationEClass, CHOICE_OPERATION__ATTRIBUTES);

		toStringOperationEClass = createEClass(TO_STRING_OPERATION);

		parseOperationEClass = createEClass(PARSE_OPERATION);

		toNumberOperationEClass = createEClass(TO_NUMBER_OPERATION);

		toIntOperationEClass = createEClass(TO_INT_OPERATION);

		toTimeOperationEClass = createEClass(TO_TIME_OPERATION);

		toEnumOperationEClass = createEClass(TO_ENUM_OPERATION);
		createEReference(toEnumOperationEClass, TO_ENUM_OPERATION__ENUMERATION);

		toDateOperationEClass = createEClass(TO_DATE_OPERATION);

		toDateTimeOperationEClass = createEClass(TO_DATE_TIME_OPERATION);

		toZonedDateTimeOperationEClass = createEClass(TO_ZONED_DATE_TIME_OPERATION);

		closureParameterEClass = createEClass(CLOSURE_PARAMETER);
		createEReference(closureParameterEClass, CLOSURE_PARAMETER__FUNCTION);

		inlineFunctionEClass = createEClass(INLINE_FUNCTION);
		createEReference(inlineFunctionEClass, INLINE_FUNCTION__PARAMETERS);
		createEReference(inlineFunctionEClass, INLINE_FUNCTION__BODY);

		rosettaFunctionalOperationEClass = createEClass(ROSETTA_FUNCTIONAL_OPERATION);
		createEReference(rosettaFunctionalOperationEClass, ROSETTA_FUNCTIONAL_OPERATION__FUNCTION);

		mandatoryFunctionalOperationEClass = createEClass(MANDATORY_FUNCTIONAL_OPERATION);

		unaryFunctionalOperationEClass = createEClass(UNARY_FUNCTIONAL_OPERATION);

		reduceOperationEClass = createEClass(REDUCE_OPERATION);

		filterOperationEClass = createEClass(FILTER_OPERATION);

		mapOperationEClass = createEClass(MAP_OPERATION);

		thenOperationEClass = createEClass(THEN_OPERATION);

		comparingFunctionalOperationEClass = createEClass(COMPARING_FUNCTIONAL_OPERATION);

		sortOperationEClass = createEClass(SORT_OPERATION);

		minOperationEClass = createEClass(MIN_OPERATION);

		maxOperationEClass = createEClass(MAX_OPERATION);

		// Create enums
		cardinalityModifierEEnum = createEEnum(CARDINALITY_MODIFIER);
		existsModifierEEnum = createEEnum(EXISTS_MODIFIER);
		necessityEEnum = createEEnum(NECESSITY);

		// Create data types
		patternEDataType = createEDataType(PATTERN);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		EcorePackage theEcorePackage = (EcorePackage)EPackage.Registry.INSTANCE.getEPackage(EcorePackage.eNS_URI);
		RosettaPackage theRosettaPackage = (RosettaPackage)EPackage.Registry.INSTANCE.getEPackage(RosettaPackage.eNS_URI);
		SimplePackage theSimplePackage = (SimplePackage)EPackage.Registry.INSTANCE.getEPackage(SimplePackage.eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes
		rosettaLiteralEClass.getESuperTypes().add(this.getRosettaExpression());
		rosettaLiteralEClass.getESuperTypes().add(theRosettaPackage.getRosettaMapTestExpression());
		rosettaBooleanLiteralEClass.getESuperTypes().add(this.getRosettaLiteral());
		rosettaStringLiteralEClass.getESuperTypes().add(this.getRosettaLiteral());
		rosettaNumberLiteralEClass.getESuperTypes().add(this.getRosettaLiteral());
		rosettaIntLiteralEClass.getESuperTypes().add(this.getRosettaLiteral());
		rosettaPatternLiteralEClass.getESuperTypes().add(this.getRosettaLiteral());
		listLiteralEClass.getESuperTypes().add(this.getRosettaExpression());
		rosettaReferenceEClass.getESuperTypes().add(this.getRosettaExpression());
		rosettaSymbolReferenceEClass.getESuperTypes().add(this.getRosettaReference());
		rosettaImplicitVariableEClass.getESuperTypes().add(this.getRosettaReference());
		rosettaImplicitVariableEClass.getESuperTypes().add(theRosettaPackage.getRosettaNamed());
		rosettaFeatureCallEClass.getESuperTypes().add(this.getRosettaExpression());
		rosettaDeepFeatureCallEClass.getESuperTypes().add(this.getRosettaExpression());
		rosettaConditionalExpressionEClass.getESuperTypes().add(this.getRosettaExpression());
		rosettaConstructorExpressionEClass.getESuperTypes().add(this.getRosettaExpression());
		rosettaConstructorExpressionEClass.getESuperTypes().add(theRosettaPackage.getRosettaTyped());
		rosettaOperationEClass.getESuperTypes().add(this.getRosettaExpression());
		rosettaBinaryOperationEClass.getESuperTypes().add(this.getRosettaOperation());
		rosettaBinaryOperationEClass.getESuperTypes().add(this.getHasGeneratedInput());
		arithmeticOperationEClass.getESuperTypes().add(this.getRosettaBinaryOperation());
		defaultOperationEClass.getESuperTypes().add(this.getRosettaBinaryOperation());
		logicalOperationEClass.getESuperTypes().add(this.getRosettaBinaryOperation());
		modifiableBinaryOperationEClass.getESuperTypes().add(this.getRosettaBinaryOperation());
		equalityOperationEClass.getESuperTypes().add(this.getModifiableBinaryOperation());
		comparisonOperationEClass.getESuperTypes().add(this.getModifiableBinaryOperation());
		rosettaContainsExpressionEClass.getESuperTypes().add(this.getRosettaBinaryOperation());
		rosettaDisjointExpressionEClass.getESuperTypes().add(this.getRosettaBinaryOperation());
		joinOperationEClass.getESuperTypes().add(this.getRosettaBinaryOperation());
		rosettaOnlyExistsExpressionEClass.getESuperTypes().add(this.getRosettaExpression());
		rosettaUnaryOperationEClass.getESuperTypes().add(this.getRosettaOperation());
		rosettaUnaryOperationEClass.getESuperTypes().add(this.getHasGeneratedInput());
		listOperationEClass.getESuperTypes().add(this.getRosettaUnaryOperation());
		canHandleListOfListsEClass.getESuperTypes().add(this.getRosettaUnaryOperation());
		rosettaExistsExpressionEClass.getESuperTypes().add(this.getRosettaUnaryOperation());
		rosettaAbsentExpressionEClass.getESuperTypes().add(this.getRosettaUnaryOperation());
		rosettaOnlyElementEClass.getESuperTypes().add(this.getListOperation());
		rosettaCountOperationEClass.getESuperTypes().add(this.getRosettaUnaryOperation());
		flattenOperationEClass.getESuperTypes().add(this.getListOperation());
		flattenOperationEClass.getESuperTypes().add(this.getCanHandleListOfLists());
		distinctOperationEClass.getESuperTypes().add(this.getListOperation());
		reverseOperationEClass.getESuperTypes().add(this.getListOperation());
		firstOperationEClass.getESuperTypes().add(this.getListOperation());
		lastOperationEClass.getESuperTypes().add(this.getListOperation());
		sumOperationEClass.getESuperTypes().add(this.getListOperation());
		asKeyOperationEClass.getESuperTypes().add(this.getRosettaUnaryOperation());
		oneOfOperationEClass.getESuperTypes().add(this.getRosettaUnaryOperation());
		choiceOperationEClass.getESuperTypes().add(this.getRosettaUnaryOperation());
		toStringOperationEClass.getESuperTypes().add(this.getRosettaUnaryOperation());
		parseOperationEClass.getESuperTypes().add(this.getRosettaUnaryOperation());
		toNumberOperationEClass.getESuperTypes().add(this.getParseOperation());
		toIntOperationEClass.getESuperTypes().add(this.getParseOperation());
		toTimeOperationEClass.getESuperTypes().add(this.getParseOperation());
		toEnumOperationEClass.getESuperTypes().add(this.getParseOperation());
		toDateOperationEClass.getESuperTypes().add(this.getParseOperation());
		toDateTimeOperationEClass.getESuperTypes().add(this.getParseOperation());
		toZonedDateTimeOperationEClass.getESuperTypes().add(this.getParseOperation());
		closureParameterEClass.getESuperTypes().add(theRosettaPackage.getRosettaSymbol());
		rosettaFunctionalOperationEClass.getESuperTypes().add(this.getRosettaUnaryOperation());
		mandatoryFunctionalOperationEClass.getESuperTypes().add(this.getRosettaFunctionalOperation());
		unaryFunctionalOperationEClass.getESuperTypes().add(this.getRosettaFunctionalOperation());
		reduceOperationEClass.getESuperTypes().add(this.getMandatoryFunctionalOperation());
		reduceOperationEClass.getESuperTypes().add(this.getListOperation());
		filterOperationEClass.getESuperTypes().add(this.getMandatoryFunctionalOperation());
		filterOperationEClass.getESuperTypes().add(this.getUnaryFunctionalOperation());
		filterOperationEClass.getESuperTypes().add(this.getCanHandleListOfLists());
		mapOperationEClass.getESuperTypes().add(this.getMandatoryFunctionalOperation());
		mapOperationEClass.getESuperTypes().add(this.getUnaryFunctionalOperation());
		mapOperationEClass.getESuperTypes().add(this.getCanHandleListOfLists());
		thenOperationEClass.getESuperTypes().add(this.getMandatoryFunctionalOperation());
		thenOperationEClass.getESuperTypes().add(this.getUnaryFunctionalOperation());
		thenOperationEClass.getESuperTypes().add(this.getCanHandleListOfLists());
		comparingFunctionalOperationEClass.getESuperTypes().add(this.getRosettaFunctionalOperation());
		comparingFunctionalOperationEClass.getESuperTypes().add(this.getUnaryFunctionalOperation());
		sortOperationEClass.getESuperTypes().add(this.getComparingFunctionalOperation());
		sortOperationEClass.getESuperTypes().add(this.getListOperation());
		minOperationEClass.getESuperTypes().add(this.getComparingFunctionalOperation());
		minOperationEClass.getESuperTypes().add(this.getListOperation());
		maxOperationEClass.getESuperTypes().add(this.getComparingFunctionalOperation());
		maxOperationEClass.getESuperTypes().add(this.getListOperation());

		// Initialize classes and features; add operations and parameters
		initEClass(rosettaExpressionEClass, RosettaExpression.class, "RosettaExpression", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getRosettaExpression_Generated(), theEcorePackage.getEBoolean(), "generated", null, 0, 1, RosettaExpression.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(hasGeneratedInputEClass, HasGeneratedInput.class, "HasGeneratedInput", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getHasGeneratedInput_GeneratedInputWasSet(), theEcorePackage.getEBoolean(), "generatedInputWasSet", null, 0, 1, HasGeneratedInput.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		addEOperation(hasGeneratedInputEClass, this.getRosettaExpression(), "getInput", 0, 1, !IS_UNIQUE, IS_ORDERED);

		EOperation op = addEOperation(hasGeneratedInputEClass, null, "setGeneratedInputIfAbsent", 0, 1, !IS_UNIQUE, IS_ORDERED);
		addEParameter(op, this.getRosettaExpression(), "e", 0, 1, !IS_UNIQUE, IS_ORDERED);

		addEOperation(hasGeneratedInputEClass, theEcorePackage.getEBoolean(), "needsGeneratedInput", 0, 1, !IS_UNIQUE, IS_ORDERED);

		initEClass(rosettaLiteralEClass, RosettaLiteral.class, "RosettaLiteral", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		addEOperation(rosettaLiteralEClass, theEcorePackage.getEJavaObject(), "containedValue", 0, 1, !IS_UNIQUE, IS_ORDERED);

		addEOperation(rosettaLiteralEClass, theEcorePackage.getEString(), "stringValue", 0, 1, !IS_UNIQUE, IS_ORDERED);

		initEClass(rosettaBooleanLiteralEClass, RosettaBooleanLiteral.class, "RosettaBooleanLiteral", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getRosettaBooleanLiteral_Value(), theEcorePackage.getEBoolean(), "value", null, 0, 1, RosettaBooleanLiteral.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		addEOperation(rosettaBooleanLiteralEClass, theEcorePackage.getEJavaObject(), "containedValue", 0, 1, !IS_UNIQUE, IS_ORDERED);

		addEOperation(rosettaBooleanLiteralEClass, theEcorePackage.getEString(), "stringValue", 0, 1, !IS_UNIQUE, IS_ORDERED);

		initEClass(rosettaStringLiteralEClass, RosettaStringLiteral.class, "RosettaStringLiteral", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getRosettaStringLiteral_Value(), theEcorePackage.getEString(), "value", null, 0, 1, RosettaStringLiteral.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		addEOperation(rosettaStringLiteralEClass, theEcorePackage.getEJavaObject(), "containedValue", 0, 1, !IS_UNIQUE, IS_ORDERED);

		addEOperation(rosettaStringLiteralEClass, theEcorePackage.getEString(), "stringValue", 0, 1, !IS_UNIQUE, IS_ORDERED);

		initEClass(rosettaNumberLiteralEClass, RosettaNumberLiteral.class, "RosettaNumberLiteral", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getRosettaNumberLiteral_Value(), theEcorePackage.getEBigDecimal(), "value", null, 0, 1, RosettaNumberLiteral.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		addEOperation(rosettaNumberLiteralEClass, theEcorePackage.getEJavaObject(), "containedValue", 0, 1, !IS_UNIQUE, IS_ORDERED);

		addEOperation(rosettaNumberLiteralEClass, theEcorePackage.getEString(), "stringValue", 0, 1, !IS_UNIQUE, IS_ORDERED);

		initEClass(rosettaIntLiteralEClass, RosettaIntLiteral.class, "RosettaIntLiteral", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getRosettaIntLiteral_Value(), theEcorePackage.getEBigInteger(), "value", null, 0, 1, RosettaIntLiteral.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		addEOperation(rosettaIntLiteralEClass, theEcorePackage.getEJavaObject(), "containedValue", 0, 1, !IS_UNIQUE, IS_ORDERED);

		addEOperation(rosettaIntLiteralEClass, theEcorePackage.getEString(), "stringValue", 0, 1, !IS_UNIQUE, IS_ORDERED);

		initEClass(rosettaPatternLiteralEClass, RosettaPatternLiteral.class, "RosettaPatternLiteral", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getRosettaPatternLiteral_Value(), this.getPattern(), "value", null, 0, 1, RosettaPatternLiteral.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		addEOperation(rosettaPatternLiteralEClass, theEcorePackage.getEJavaObject(), "containedValue", 0, 1, !IS_UNIQUE, IS_ORDERED);

		addEOperation(rosettaPatternLiteralEClass, theEcorePackage.getEString(), "stringValue", 0, 1, !IS_UNIQUE, IS_ORDERED);

		initEClass(listLiteralEClass, ListLiteral.class, "ListLiteral", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getListLiteral_Elements(), this.getRosettaExpression(), null, "elements", null, 0, -1, ListLiteral.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(rosettaReferenceEClass, RosettaReference.class, "RosettaReference", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(rosettaSymbolReferenceEClass, RosettaSymbolReference.class, "RosettaSymbolReference", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getRosettaSymbolReference_Symbol(), theRosettaPackage.getRosettaSymbol(), null, "symbol", null, 0, 1, RosettaSymbolReference.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getRosettaSymbolReference_ExplicitArguments(), theEcorePackage.getEBoolean(), "explicitArguments", null, 0, 1, RosettaSymbolReference.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getRosettaSymbolReference_RawArgs(), this.getRosettaExpression(), null, "rawArgs", null, 0, -1, RosettaSymbolReference.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getRosettaSymbolReference_ImplicitVariableIsInContext(), theEcorePackage.getEBoolean(), "implicitVariableIsInContext", null, 0, 1, RosettaSymbolReference.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getRosettaSymbolReference_ImplicitArgument(), this.getRosettaExpression(), null, "implicitArgument", null, 0, 1, RosettaSymbolReference.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		addEOperation(rosettaSymbolReferenceEClass, this.getRosettaExpression(), "getArgs", 0, -1, !IS_UNIQUE, IS_ORDERED);

		initEClass(rosettaImplicitVariableEClass, RosettaImplicitVariable.class, "RosettaImplicitVariable", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(rosettaFeatureCallEClass, RosettaFeatureCall.class, "RosettaFeatureCall", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getRosettaFeatureCall_Receiver(), this.getRosettaExpression(), null, "receiver", null, 0, 1, RosettaFeatureCall.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getRosettaFeatureCall_Feature(), theRosettaPackage.getRosettaFeature(), null, "feature", null, 0, 1, RosettaFeatureCall.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(rosettaDeepFeatureCallEClass, RosettaDeepFeatureCall.class, "RosettaDeepFeatureCall", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getRosettaDeepFeatureCall_Receiver(), this.getRosettaExpression(), null, "receiver", null, 0, 1, RosettaDeepFeatureCall.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getRosettaDeepFeatureCall_Feature(), theSimplePackage.getAttribute(), null, "feature", null, 0, 1, RosettaDeepFeatureCall.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(rosettaConditionalExpressionEClass, RosettaConditionalExpression.class, "RosettaConditionalExpression", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getRosettaConditionalExpression_If(), this.getRosettaExpression(), null, "if", null, 0, 1, RosettaConditionalExpression.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getRosettaConditionalExpression_Ifthen(), this.getRosettaExpression(), null, "ifthen", null, 0, 1, RosettaConditionalExpression.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getRosettaConditionalExpression_Elsethen(), this.getRosettaExpression(), null, "elsethen", null, 0, 1, RosettaConditionalExpression.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getRosettaConditionalExpression_Full(), theEcorePackage.getEBoolean(), "full", null, 0, 1, RosettaConditionalExpression.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(rosettaConstructorExpressionEClass, RosettaConstructorExpression.class, "RosettaConstructorExpression", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getRosettaConstructorExpression_Values(), this.getConstructorKeyValuePair(), null, "values", null, 0, -1, RosettaConstructorExpression.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getRosettaConstructorExpression_ImplicitEmpty(), theEcorePackage.getEBoolean(), "implicitEmpty", null, 0, 1, RosettaConstructorExpression.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(constructorKeyValuePairEClass, ConstructorKeyValuePair.class, "ConstructorKeyValuePair", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getConstructorKeyValuePair_Key(), theRosettaPackage.getRosettaFeature(), null, "key", null, 0, 1, ConstructorKeyValuePair.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getConstructorKeyValuePair_Value(), this.getRosettaExpression(), null, "value", null, 0, 1, ConstructorKeyValuePair.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(rosettaOperationEClass, RosettaOperation.class, "RosettaOperation", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getRosettaOperation_Operator(), theEcorePackage.getEString(), "operator", null, 0, 1, RosettaOperation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(rosettaBinaryOperationEClass, RosettaBinaryOperation.class, "RosettaBinaryOperation", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getRosettaBinaryOperation_Left(), this.getRosettaExpression(), null, "left", null, 0, 1, RosettaBinaryOperation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getRosettaBinaryOperation_Right(), this.getRosettaExpression(), null, "right", null, 0, 1, RosettaBinaryOperation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		addEOperation(rosettaBinaryOperationEClass, this.getRosettaExpression(), "getInput", 0, 1, !IS_UNIQUE, IS_ORDERED);

		op = addEOperation(rosettaBinaryOperationEClass, null, "setGeneratedInputIfAbsent", 0, 1, !IS_UNIQUE, IS_ORDERED);
		addEParameter(op, this.getRosettaExpression(), "e", 0, 1, !IS_UNIQUE, IS_ORDERED);

		addEOperation(rosettaBinaryOperationEClass, theEcorePackage.getEBoolean(), "needsGeneratedInput", 0, 1, !IS_UNIQUE, IS_ORDERED);

		initEClass(arithmeticOperationEClass, ArithmeticOperation.class, "ArithmeticOperation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(defaultOperationEClass, DefaultOperation.class, "DefaultOperation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(logicalOperationEClass, LogicalOperation.class, "LogicalOperation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(modifiableBinaryOperationEClass, ModifiableBinaryOperation.class, "ModifiableBinaryOperation", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getModifiableBinaryOperation_CardMod(), this.getCardinalityModifier(), "cardMod", null, 0, 1, ModifiableBinaryOperation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(equalityOperationEClass, EqualityOperation.class, "EqualityOperation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(comparisonOperationEClass, ComparisonOperation.class, "ComparisonOperation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(rosettaContainsExpressionEClass, RosettaContainsExpression.class, "RosettaContainsExpression", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(rosettaDisjointExpressionEClass, RosettaDisjointExpression.class, "RosettaDisjointExpression", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(joinOperationEClass, JoinOperation.class, "JoinOperation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getJoinOperation_ExplicitSeparator(), theEcorePackage.getEBoolean(), "explicitSeparator", null, 0, 1, JoinOperation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(rosettaOnlyExistsExpressionEClass, RosettaOnlyExistsExpression.class, "RosettaOnlyExistsExpression", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getRosettaOnlyExistsExpression_Args(), this.getRosettaExpression(), null, "args", null, 0, -1, RosettaOnlyExistsExpression.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(rosettaUnaryOperationEClass, RosettaUnaryOperation.class, "RosettaUnaryOperation", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getRosettaUnaryOperation_Argument(), this.getRosettaExpression(), null, "argument", null, 0, 1, RosettaUnaryOperation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		addEOperation(rosettaUnaryOperationEClass, this.getRosettaExpression(), "getInput", 0, 1, !IS_UNIQUE, IS_ORDERED);

		op = addEOperation(rosettaUnaryOperationEClass, null, "setGeneratedInputIfAbsent", 0, 1, !IS_UNIQUE, IS_ORDERED);
		addEParameter(op, this.getRosettaExpression(), "e", 0, 1, !IS_UNIQUE, IS_ORDERED);

		addEOperation(rosettaUnaryOperationEClass, theEcorePackage.getEBoolean(), "needsGeneratedInput", 0, 1, !IS_UNIQUE, IS_ORDERED);

		initEClass(listOperationEClass, ListOperation.class, "ListOperation", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(canHandleListOfListsEClass, CanHandleListOfLists.class, "CanHandleListOfLists", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(rosettaExistsExpressionEClass, RosettaExistsExpression.class, "RosettaExistsExpression", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getRosettaExistsExpression_Modifier(), this.getExistsModifier(), "modifier", null, 0, 1, RosettaExistsExpression.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(rosettaAbsentExpressionEClass, RosettaAbsentExpression.class, "RosettaAbsentExpression", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(rosettaOnlyElementEClass, RosettaOnlyElement.class, "RosettaOnlyElement", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(rosettaCountOperationEClass, RosettaCountOperation.class, "RosettaCountOperation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(flattenOperationEClass, FlattenOperation.class, "FlattenOperation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(distinctOperationEClass, DistinctOperation.class, "DistinctOperation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(reverseOperationEClass, ReverseOperation.class, "ReverseOperation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(firstOperationEClass, FirstOperation.class, "FirstOperation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(lastOperationEClass, LastOperation.class, "LastOperation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(sumOperationEClass, SumOperation.class, "SumOperation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(asKeyOperationEClass, AsKeyOperation.class, "AsKeyOperation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(oneOfOperationEClass, OneOfOperation.class, "OneOfOperation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(choiceOperationEClass, ChoiceOperation.class, "ChoiceOperation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getChoiceOperation_Necessity(), this.getNecessity(), "necessity", null, 0, 1, ChoiceOperation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getChoiceOperation_Attributes(), theSimplePackage.getAttribute(), null, "attributes", null, 0, -1, ChoiceOperation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(toStringOperationEClass, ToStringOperation.class, "ToStringOperation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(parseOperationEClass, ParseOperation.class, "ParseOperation", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(toNumberOperationEClass, ToNumberOperation.class, "ToNumberOperation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(toIntOperationEClass, ToIntOperation.class, "ToIntOperation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(toTimeOperationEClass, ToTimeOperation.class, "ToTimeOperation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(toEnumOperationEClass, ToEnumOperation.class, "ToEnumOperation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getToEnumOperation_Enumeration(), theRosettaPackage.getRosettaEnumeration(), null, "enumeration", null, 0, 1, ToEnumOperation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(toDateOperationEClass, ToDateOperation.class, "ToDateOperation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(toDateTimeOperationEClass, ToDateTimeOperation.class, "ToDateTimeOperation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(toZonedDateTimeOperationEClass, ToZonedDateTimeOperation.class, "ToZonedDateTimeOperation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(closureParameterEClass, ClosureParameter.class, "ClosureParameter", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getClosureParameter_Function(), this.getInlineFunction(), this.getInlineFunction_Parameters(), "function", null, 0, 1, ClosureParameter.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(inlineFunctionEClass, InlineFunction.class, "InlineFunction", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getInlineFunction_Parameters(), this.getClosureParameter(), this.getClosureParameter_Function(), "parameters", null, 0, -1, InlineFunction.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getInlineFunction_Body(), this.getRosettaExpression(), null, "body", null, 0, 1, InlineFunction.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(rosettaFunctionalOperationEClass, RosettaFunctionalOperation.class, "RosettaFunctionalOperation", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getRosettaFunctionalOperation_Function(), this.getInlineFunction(), null, "function", null, 0, 1, RosettaFunctionalOperation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(mandatoryFunctionalOperationEClass, MandatoryFunctionalOperation.class, "MandatoryFunctionalOperation", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(unaryFunctionalOperationEClass, UnaryFunctionalOperation.class, "UnaryFunctionalOperation", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(reduceOperationEClass, ReduceOperation.class, "ReduceOperation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(filterOperationEClass, FilterOperation.class, "FilterOperation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(mapOperationEClass, MapOperation.class, "MapOperation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(thenOperationEClass, ThenOperation.class, "ThenOperation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(comparingFunctionalOperationEClass, ComparingFunctionalOperation.class, "ComparingFunctionalOperation", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(sortOperationEClass, SortOperation.class, "SortOperation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(minOperationEClass, MinOperation.class, "MinOperation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(maxOperationEClass, MaxOperation.class, "MaxOperation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		// Initialize enums and add enum literals
		initEEnum(cardinalityModifierEEnum, CardinalityModifier.class, "CardinalityModifier");
		addEEnumLiteral(cardinalityModifierEEnum, CardinalityModifier.NONE);
		addEEnumLiteral(cardinalityModifierEEnum, CardinalityModifier.ALL);
		addEEnumLiteral(cardinalityModifierEEnum, CardinalityModifier.ANY);

		initEEnum(existsModifierEEnum, ExistsModifier.class, "ExistsModifier");
		addEEnumLiteral(existsModifierEEnum, ExistsModifier.NONE);
		addEEnumLiteral(existsModifierEEnum, ExistsModifier.SINGLE);
		addEEnumLiteral(existsModifierEEnum, ExistsModifier.MULTIPLE);

		initEEnum(necessityEEnum, Necessity.class, "Necessity");
		addEEnumLiteral(necessityEEnum, Necessity.OPTIONAL);
		addEEnumLiteral(necessityEEnum, Necessity.REQUIRED);

		// Initialize data types
		initEDataType(patternEDataType, Pattern.class, "Pattern", IS_SERIALIZABLE, !IS_GENERATED_INSTANCE_CLASS);

		// Create resource
		createResource(eNS_URI);
	}

} //ExpressionPackageImpl
