/**
 * Copyright (c) REGnosys 2017 (www.regnosys.com)
 */
package com.regnosys.rosetta.rosetta.expression.impl;

import com.regnosys.rosetta.rosetta.RosettaPackage;
import com.regnosys.rosetta.rosetta.RosettaTyped;
import com.regnosys.rosetta.rosetta.TypeCall;

import com.regnosys.rosetta.rosetta.expression.ConstructorKeyValuePair;
import com.regnosys.rosetta.rosetta.expression.ExpressionPackage;
import com.regnosys.rosetta.rosetta.expression.RosettaConstructorExpression;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Rosetta Constructor Expression</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaConstructorExpressionImpl#isGenerated <em>Generated</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaConstructorExpressionImpl#getTypeCall <em>Type Call</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaConstructorExpressionImpl#isIsTypeInferred <em>Is Type Inferred</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaConstructorExpressionImpl#getValues <em>Values</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaConstructorExpressionImpl#isImplicitEmpty <em>Implicit Empty</em>}</li>
 * </ul>
 *
 * @generated
 */
public class RosettaConstructorExpressionImpl extends MinimalEObjectImpl.Container implements RosettaConstructorExpression {
	/**
	 * The default value of the '{@link #isGenerated() <em>Generated</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isGenerated()
	 * @generated
	 * @ordered
	 */
	protected static final boolean GENERATED_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isGenerated() <em>Generated</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isGenerated()
	 * @generated
	 * @ordered
	 */
	protected boolean generated = GENERATED_EDEFAULT;

	/**
	 * The cached value of the '{@link #getTypeCall() <em>Type Call</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTypeCall()
	 * @generated
	 * @ordered
	 */
	protected TypeCall typeCall;

	/**
	 * The default value of the '{@link #isIsTypeInferred() <em>Is Type Inferred</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsTypeInferred()
	 * @generated
	 * @ordered
	 */
	protected static final boolean IS_TYPE_INFERRED_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #getValues() <em>Values</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getValues()
	 * @generated
	 * @ordered
	 */
	protected EList<ConstructorKeyValuePair> values;

	/**
	 * The default value of the '{@link #isImplicitEmpty() <em>Implicit Empty</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isImplicitEmpty()
	 * @generated
	 * @ordered
	 */
	protected static final boolean IMPLICIT_EMPTY_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isImplicitEmpty() <em>Implicit Empty</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isImplicitEmpty()
	 * @generated
	 * @ordered
	 */
	protected boolean implicitEmpty = IMPLICIT_EMPTY_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RosettaConstructorExpressionImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ExpressionPackage.Literals.ROSETTA_CONSTRUCTOR_EXPRESSION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isGenerated() {
		return generated;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setGenerated(boolean newGenerated) {
		boolean oldGenerated = generated;
		generated = newGenerated;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExpressionPackage.ROSETTA_CONSTRUCTOR_EXPRESSION__GENERATED, oldGenerated, generated));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public TypeCall getTypeCall() {
		return typeCall;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetTypeCall(TypeCall newTypeCall, NotificationChain msgs) {
		TypeCall oldTypeCall = typeCall;
		typeCall = newTypeCall;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ExpressionPackage.ROSETTA_CONSTRUCTOR_EXPRESSION__TYPE_CALL, oldTypeCall, newTypeCall);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setTypeCall(TypeCall newTypeCall) {
		if (newTypeCall != typeCall) {
			NotificationChain msgs = null;
			if (typeCall != null)
				msgs = ((InternalEObject)typeCall).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ExpressionPackage.ROSETTA_CONSTRUCTOR_EXPRESSION__TYPE_CALL, null, msgs);
			if (newTypeCall != null)
				msgs = ((InternalEObject)newTypeCall).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ExpressionPackage.ROSETTA_CONSTRUCTOR_EXPRESSION__TYPE_CALL, null, msgs);
			msgs = basicSetTypeCall(newTypeCall, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExpressionPackage.ROSETTA_CONSTRUCTOR_EXPRESSION__TYPE_CALL, newTypeCall, newTypeCall));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isIsTypeInferred() {
		TypeCall _typeCall = this.getTypeCall();
		return (_typeCall == null);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<ConstructorKeyValuePair> getValues() {
		if (values == null) {
			values = new EObjectContainmentEList<ConstructorKeyValuePair>(ConstructorKeyValuePair.class, this, ExpressionPackage.ROSETTA_CONSTRUCTOR_EXPRESSION__VALUES);
		}
		return values;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isImplicitEmpty() {
		return implicitEmpty;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setImplicitEmpty(boolean newImplicitEmpty) {
		boolean oldImplicitEmpty = implicitEmpty;
		implicitEmpty = newImplicitEmpty;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExpressionPackage.ROSETTA_CONSTRUCTOR_EXPRESSION__IMPLICIT_EMPTY, oldImplicitEmpty, implicitEmpty));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ExpressionPackage.ROSETTA_CONSTRUCTOR_EXPRESSION__TYPE_CALL:
				return basicSetTypeCall(null, msgs);
			case ExpressionPackage.ROSETTA_CONSTRUCTOR_EXPRESSION__VALUES:
				return ((InternalEList<?>)getValues()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ExpressionPackage.ROSETTA_CONSTRUCTOR_EXPRESSION__GENERATED:
				return isGenerated();
			case ExpressionPackage.ROSETTA_CONSTRUCTOR_EXPRESSION__TYPE_CALL:
				return getTypeCall();
			case ExpressionPackage.ROSETTA_CONSTRUCTOR_EXPRESSION__IS_TYPE_INFERRED:
				return isIsTypeInferred();
			case ExpressionPackage.ROSETTA_CONSTRUCTOR_EXPRESSION__VALUES:
				return getValues();
			case ExpressionPackage.ROSETTA_CONSTRUCTOR_EXPRESSION__IMPLICIT_EMPTY:
				return isImplicitEmpty();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ExpressionPackage.ROSETTA_CONSTRUCTOR_EXPRESSION__GENERATED:
				setGenerated((Boolean)newValue);
				return;
			case ExpressionPackage.ROSETTA_CONSTRUCTOR_EXPRESSION__TYPE_CALL:
				setTypeCall((TypeCall)newValue);
				return;
			case ExpressionPackage.ROSETTA_CONSTRUCTOR_EXPRESSION__VALUES:
				getValues().clear();
				getValues().addAll((Collection<? extends ConstructorKeyValuePair>)newValue);
				return;
			case ExpressionPackage.ROSETTA_CONSTRUCTOR_EXPRESSION__IMPLICIT_EMPTY:
				setImplicitEmpty((Boolean)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ExpressionPackage.ROSETTA_CONSTRUCTOR_EXPRESSION__GENERATED:
				setGenerated(GENERATED_EDEFAULT);
				return;
			case ExpressionPackage.ROSETTA_CONSTRUCTOR_EXPRESSION__TYPE_CALL:
				setTypeCall((TypeCall)null);
				return;
			case ExpressionPackage.ROSETTA_CONSTRUCTOR_EXPRESSION__VALUES:
				getValues().clear();
				return;
			case ExpressionPackage.ROSETTA_CONSTRUCTOR_EXPRESSION__IMPLICIT_EMPTY:
				setImplicitEmpty(IMPLICIT_EMPTY_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ExpressionPackage.ROSETTA_CONSTRUCTOR_EXPRESSION__GENERATED:
				return generated != GENERATED_EDEFAULT;
			case ExpressionPackage.ROSETTA_CONSTRUCTOR_EXPRESSION__TYPE_CALL:
				return typeCall != null;
			case ExpressionPackage.ROSETTA_CONSTRUCTOR_EXPRESSION__IS_TYPE_INFERRED:
				return isIsTypeInferred() != IS_TYPE_INFERRED_EDEFAULT;
			case ExpressionPackage.ROSETTA_CONSTRUCTOR_EXPRESSION__VALUES:
				return values != null && !values.isEmpty();
			case ExpressionPackage.ROSETTA_CONSTRUCTOR_EXPRESSION__IMPLICIT_EMPTY:
				return implicitEmpty != IMPLICIT_EMPTY_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == RosettaTyped.class) {
			switch (derivedFeatureID) {
				case ExpressionPackage.ROSETTA_CONSTRUCTOR_EXPRESSION__TYPE_CALL: return RosettaPackage.ROSETTA_TYPED__TYPE_CALL;
				case ExpressionPackage.ROSETTA_CONSTRUCTOR_EXPRESSION__IS_TYPE_INFERRED: return RosettaPackage.ROSETTA_TYPED__IS_TYPE_INFERRED;
				default: return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == RosettaTyped.class) {
			switch (baseFeatureID) {
				case RosettaPackage.ROSETTA_TYPED__TYPE_CALL: return ExpressionPackage.ROSETTA_CONSTRUCTOR_EXPRESSION__TYPE_CALL;
				case RosettaPackage.ROSETTA_TYPED__IS_TYPE_INFERRED: return ExpressionPackage.ROSETTA_CONSTRUCTOR_EXPRESSION__IS_TYPE_INFERRED;
				default: return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (generated: ");
		result.append(generated);
		result.append(", implicitEmpty: ");
		result.append(implicitEmpty);
		result.append(')');
		return result.toString();
	}

} //RosettaConstructorExpressionImpl
