/**
 * Copyright (c) REGnosys 2017 (www.regnosys.com)
 */
package com.regnosys.rosetta.rosetta.impl;

import com.regnosys.rosetta.rosetta.ParametrizedRosettaType;
import com.regnosys.rosetta.rosetta.RosettaBasicType;
import com.regnosys.rosetta.rosetta.RosettaBuiltinType;
import com.regnosys.rosetta.rosetta.RosettaDefinable;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.regnosys.rosetta.rosetta.RosettaNamed;
import com.regnosys.rosetta.rosetta.RosettaPackage;
import com.regnosys.rosetta.rosetta.RosettaType;
import com.regnosys.rosetta.rosetta.TypeParameter;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Basic Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RosettaBasicTypeImpl#getModel <em>Model</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RosettaBasicTypeImpl#getName <em>Name</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RosettaBasicTypeImpl#getDefinition <em>Definition</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RosettaBasicTypeImpl#getParameters <em>Parameters</em>}</li>
 * </ul>
 *
 * @generated
 */
public class RosettaBasicTypeImpl extends MinimalEObjectImpl.Container implements RosettaBasicType {
	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getDefinition() <em>Definition</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDefinition()
	 * @generated
	 * @ordered
	 */
	protected static final String DEFINITION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDefinition() <em>Definition</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDefinition()
	 * @generated
	 * @ordered
	 */
	protected String definition = DEFINITION_EDEFAULT;

	/**
	 * The cached value of the '{@link #getParameters() <em>Parameters</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getParameters()
	 * @generated
	 * @ordered
	 */
	protected EList<TypeParameter> parameters;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RosettaBasicTypeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return RosettaPackage.Literals.ROSETTA_BASIC_TYPE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaModel getModel() {
		if (eContainerFeatureID() != RosettaPackage.ROSETTA_BASIC_TYPE__MODEL) return null;
		return (RosettaModel)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RosettaModel basicGetModel() {
		if (eContainerFeatureID() != RosettaPackage.ROSETTA_BASIC_TYPE__MODEL) return null;
		return (RosettaModel)eInternalContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetModel(RosettaModel newModel, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newModel, RosettaPackage.ROSETTA_BASIC_TYPE__MODEL, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setModel(RosettaModel newModel) {
		if (newModel != eInternalContainer() || (eContainerFeatureID() != RosettaPackage.ROSETTA_BASIC_TYPE__MODEL && newModel != null)) {
			if (EcoreUtil.isAncestor(this, newModel))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newModel != null)
				msgs = ((InternalEObject)newModel).eInverseAdd(this, RosettaPackage.ROSETTA_MODEL__ELEMENTS, RosettaModel.class, msgs);
			msgs = basicSetModel(newModel, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RosettaPackage.ROSETTA_BASIC_TYPE__MODEL, newModel, newModel));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RosettaPackage.ROSETTA_BASIC_TYPE__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getDefinition() {
		return definition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDefinition(String newDefinition) {
		String oldDefinition = definition;
		definition = newDefinition;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RosettaPackage.ROSETTA_BASIC_TYPE__DEFINITION, oldDefinition, definition));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<TypeParameter> getParameters() {
		if (parameters == null) {
			parameters = new EObjectContainmentEList<TypeParameter>(TypeParameter.class, this, RosettaPackage.ROSETTA_BASIC_TYPE__PARAMETERS);
		}
		return parameters;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_BASIC_TYPE__MODEL:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetModel((RosettaModel)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_BASIC_TYPE__MODEL:
				return basicSetModel(null, msgs);
			case RosettaPackage.ROSETTA_BASIC_TYPE__PARAMETERS:
				return ((InternalEList<?>)getParameters()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case RosettaPackage.ROSETTA_BASIC_TYPE__MODEL:
				return eInternalContainer().eInverseRemove(this, RosettaPackage.ROSETTA_MODEL__ELEMENTS, RosettaModel.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_BASIC_TYPE__MODEL:
				if (resolve) return getModel();
				return basicGetModel();
			case RosettaPackage.ROSETTA_BASIC_TYPE__NAME:
				return getName();
			case RosettaPackage.ROSETTA_BASIC_TYPE__DEFINITION:
				return getDefinition();
			case RosettaPackage.ROSETTA_BASIC_TYPE__PARAMETERS:
				return getParameters();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_BASIC_TYPE__MODEL:
				setModel((RosettaModel)newValue);
				return;
			case RosettaPackage.ROSETTA_BASIC_TYPE__NAME:
				setName((String)newValue);
				return;
			case RosettaPackage.ROSETTA_BASIC_TYPE__DEFINITION:
				setDefinition((String)newValue);
				return;
			case RosettaPackage.ROSETTA_BASIC_TYPE__PARAMETERS:
				getParameters().clear();
				getParameters().addAll((Collection<? extends TypeParameter>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_BASIC_TYPE__MODEL:
				setModel((RosettaModel)null);
				return;
			case RosettaPackage.ROSETTA_BASIC_TYPE__NAME:
				setName(NAME_EDEFAULT);
				return;
			case RosettaPackage.ROSETTA_BASIC_TYPE__DEFINITION:
				setDefinition(DEFINITION_EDEFAULT);
				return;
			case RosettaPackage.ROSETTA_BASIC_TYPE__PARAMETERS:
				getParameters().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_BASIC_TYPE__MODEL:
				return basicGetModel() != null;
			case RosettaPackage.ROSETTA_BASIC_TYPE__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case RosettaPackage.ROSETTA_BASIC_TYPE__DEFINITION:
				return DEFINITION_EDEFAULT == null ? definition != null : !DEFINITION_EDEFAULT.equals(definition);
			case RosettaPackage.ROSETTA_BASIC_TYPE__PARAMETERS:
				return parameters != null && !parameters.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == RosettaNamed.class) {
			switch (derivedFeatureID) {
				case RosettaPackage.ROSETTA_BASIC_TYPE__NAME: return RosettaPackage.ROSETTA_NAMED__NAME;
				default: return -1;
			}
		}
		if (baseClass == RosettaType.class) {
			switch (derivedFeatureID) {
				default: return -1;
			}
		}
		if (baseClass == RosettaDefinable.class) {
			switch (derivedFeatureID) {
				case RosettaPackage.ROSETTA_BASIC_TYPE__DEFINITION: return RosettaPackage.ROSETTA_DEFINABLE__DEFINITION;
				default: return -1;
			}
		}
		if (baseClass == RosettaBuiltinType.class) {
			switch (derivedFeatureID) {
				default: return -1;
			}
		}
		if (baseClass == ParametrizedRosettaType.class) {
			switch (derivedFeatureID) {
				case RosettaPackage.ROSETTA_BASIC_TYPE__PARAMETERS: return RosettaPackage.PARAMETRIZED_ROSETTA_TYPE__PARAMETERS;
				default: return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == RosettaNamed.class) {
			switch (baseFeatureID) {
				case RosettaPackage.ROSETTA_NAMED__NAME: return RosettaPackage.ROSETTA_BASIC_TYPE__NAME;
				default: return -1;
			}
		}
		if (baseClass == RosettaType.class) {
			switch (baseFeatureID) {
				default: return -1;
			}
		}
		if (baseClass == RosettaDefinable.class) {
			switch (baseFeatureID) {
				case RosettaPackage.ROSETTA_DEFINABLE__DEFINITION: return RosettaPackage.ROSETTA_BASIC_TYPE__DEFINITION;
				default: return -1;
			}
		}
		if (baseClass == RosettaBuiltinType.class) {
			switch (baseFeatureID) {
				default: return -1;
			}
		}
		if (baseClass == ParametrizedRosettaType.class) {
			switch (baseFeatureID) {
				case RosettaPackage.PARAMETRIZED_ROSETTA_TYPE__PARAMETERS: return RosettaPackage.ROSETTA_BASIC_TYPE__PARAMETERS;
				default: return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (name: ");
		result.append(name);
		result.append(", definition: ");
		result.append(definition);
		result.append(')');
		return result.toString();
	}

} //RosettaBasicTypeImpl
