/**
 * Copyright (c) REGnosys 2017 (www.regnosys.com)
 */
package com.regnosys.rosetta.rosetta.impl;

import com.regnosys.rosetta.rosetta.RosettaCardinality;
import com.regnosys.rosetta.rosetta.RosettaFactory;
import com.regnosys.rosetta.rosetta.RosettaPackage;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Cardinality</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RosettaCardinalityImpl#getInf <em>Inf</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RosettaCardinalityImpl#getSup <em>Sup</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RosettaCardinalityImpl#isUnbounded <em>Unbounded</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RosettaCardinalityImpl#isIsMany <em>Is Many</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RosettaCardinalityImpl#isEmpty <em>Empty</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RosettaCardinalityImpl#isOptional <em>Optional</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RosettaCardinalityImpl#isSingular <em>Singular</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RosettaCardinalityImpl#isPlural <em>Plural</em>}</li>
 * </ul>
 *
 * @generated
 */
public class RosettaCardinalityImpl extends MinimalEObjectImpl.Container implements RosettaCardinality {
	/**
	 * The default value of the '{@link #getInf() <em>Inf</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInf()
	 * @generated
	 * @ordered
	 */
	protected static final int INF_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getInf() <em>Inf</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInf()
	 * @generated
	 * @ordered
	 */
	protected int inf = INF_EDEFAULT;

	/**
	 * The default value of the '{@link #getSup() <em>Sup</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSup()
	 * @generated
	 * @ordered
	 */
	protected static final int SUP_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getSup() <em>Sup</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSup()
	 * @generated
	 * @ordered
	 */
	protected int sup = SUP_EDEFAULT;

	/**
	 * The default value of the '{@link #isUnbounded() <em>Unbounded</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isUnbounded()
	 * @generated
	 * @ordered
	 */
	protected static final boolean UNBOUNDED_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isUnbounded() <em>Unbounded</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isUnbounded()
	 * @generated
	 * @ordered
	 */
	protected boolean unbounded = UNBOUNDED_EDEFAULT;

	/**
	 * The default value of the '{@link #isIsMany() <em>Is Many</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsMany()
	 * @generated
	 * @ordered
	 */
	protected static final boolean IS_MANY_EDEFAULT = false;

	/**
	 * The default value of the '{@link #isEmpty() <em>Empty</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isEmpty()
	 * @generated
	 * @ordered
	 */
	protected static final boolean EMPTY_EDEFAULT = false;

	/**
	 * The default value of the '{@link #isOptional() <em>Optional</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isOptional()
	 * @generated
	 * @ordered
	 */
	protected static final boolean OPTIONAL_EDEFAULT = false;

	/**
	 * The default value of the '{@link #isSingular() <em>Singular</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSingular()
	 * @generated
	 * @ordered
	 */
	protected static final boolean SINGULAR_EDEFAULT = false;

	/**
	 * The default value of the '{@link #isPlural() <em>Plural</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isPlural()
	 * @generated
	 * @ordered
	 */
	protected static final boolean PLURAL_EDEFAULT = false;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RosettaCardinalityImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return RosettaPackage.Literals.ROSETTA_CARDINALITY;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getInf() {
		return inf;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setInf(int newInf) {
		int oldInf = inf;
		inf = newInf;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RosettaPackage.ROSETTA_CARDINALITY__INF, oldInf, inf));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getSup() {
		return sup;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSup(int newSup) {
		int oldSup = sup;
		sup = newSup;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RosettaPackage.ROSETTA_CARDINALITY__SUP, oldSup, sup));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isUnbounded() {
		return unbounded;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setUnbounded(boolean newUnbounded) {
		boolean oldUnbounded = unbounded;
		unbounded = newUnbounded;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RosettaPackage.ROSETTA_CARDINALITY__UNBOUNDED, oldUnbounded, unbounded));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isIsMany() {
		return ((this.isUnbounded() || (this.getSup() > 1)) || (this.getSup() != 1));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isEmpty() {
		return ((!this.isUnbounded()) && (this.getSup() == 0));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isOptional() {
		return (((!this.isUnbounded()) && (this.getInf() == 0)) && (this.getSup() == 1));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isSingular() {
		return (((!this.isUnbounded()) && (this.getInf() == 1)) && (this.getSup() == 1));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isPlural() {
		return (this.isUnbounded() || (this.getSup() > 1));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toConstraintString() {
		boolean _isUnbounded = this.isUnbounded();
		if (_isUnbounded) {
			int _inf = this.getInf();
			String _plus = ("(" + Integer.valueOf(_inf));
			return (_plus + "..*)");
		}
		int _inf_1 = this.getInf();
		String _plus_1 = ("(" + Integer.valueOf(_inf_1));
		String _plus_2 = (_plus_1 + "..");
		int _sup = this.getSup();
		String _plus_3 = (_plus_2 + Integer.valueOf(_sup));
		return (_plus_3 + ")");
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean constraintEquals(final RosettaCardinality other) {
		if ((other == null)) {
			return false;
		}
		boolean _isUnbounded = this.isUnbounded();
		if (_isUnbounded) {
			return (other.isUnbounded() && (this.getInf() == other.getInf()));
		}
		return ((this.getInf() == other.getInf()) && (this.getSup() == other.getSup()));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int constraintHashCode() {
		int hash = 3;
		int _hashCode = Boolean.hashCode(this.isUnbounded());
		int _plus = ((53 * hash) + _hashCode);
		hash = _plus;
		int _hashCode_1 = Integer.hashCode(this.getInf());
		int _plus_1 = ((53 * hash) + _hashCode_1);
		hash = _plus_1;
		boolean _isUnbounded = this.isUnbounded();
		boolean _not = (!_isUnbounded);
		if (_not) {
			int _hashCode_2 = Integer.hashCode(this.getSup());
			int _plus_2 = ((53 * hash) + _hashCode_2);
			hash = _plus_2;
		}
		return hash;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isSubconstraintOf(final RosettaCardinality superConstraint) {
		return ((this.getInf() >= superConstraint.getInf()) && (superConstraint.isUnbounded() || ((!this.isUnbounded()) && (this.getSup() <= superConstraint.getSup()))));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaCardinality add(final RosettaCardinality other) {
		final RosettaCardinality c = RosettaFactory.eINSTANCE.createRosettaCardinality();
		int _inf = this.getInf();
		int _inf_1 = other.getInf();
		int _plus = (_inf + _inf_1);
		c.setInf(_plus);
		if ((this.isUnbounded() || other.isUnbounded())) {
			c.setUnbounded(true);
		}
		else {
			int _sup = this.getSup();
			int _sup_1 = other.getSup();
			int _plus_1 = (_sup + _sup_1);
			c.setSup(_plus_1);
		}
		return c;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaCardinality operator_plus(final RosettaCardinality other) {
		return this.add(other);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaCardinality multiply(final RosettaCardinality other) {
		final RosettaCardinality c = RosettaFactory.eINSTANCE.createRosettaCardinality();
		int _inf = this.getInf();
		int _inf_1 = other.getInf();
		int _multiply = (_inf * _inf_1);
		c.setInf(_multiply);
		if ((((!this.isUnbounded()) && (this.getSup() == 0)) || ((!other.isUnbounded()) && (other.getSup() == 0)))) {
			c.setSup(0);
		}
		else {
			if ((this.isUnbounded() || other.isUnbounded())) {
				c.setUnbounded(true);
			}
			else {
				int _sup = this.getSup();
				int _sup_1 = other.getSup();
				int _multiply_1 = (_sup * _sup_1);
				c.setSup(_multiply_1);
			}
		}
		return c;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaCardinality operator_multiply(final RosettaCardinality other) {
		return this.multiply(other);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_CARDINALITY__INF:
				return getInf();
			case RosettaPackage.ROSETTA_CARDINALITY__SUP:
				return getSup();
			case RosettaPackage.ROSETTA_CARDINALITY__UNBOUNDED:
				return isUnbounded();
			case RosettaPackage.ROSETTA_CARDINALITY__IS_MANY:
				return isIsMany();
			case RosettaPackage.ROSETTA_CARDINALITY__EMPTY:
				return isEmpty();
			case RosettaPackage.ROSETTA_CARDINALITY__OPTIONAL:
				return isOptional();
			case RosettaPackage.ROSETTA_CARDINALITY__SINGULAR:
				return isSingular();
			case RosettaPackage.ROSETTA_CARDINALITY__PLURAL:
				return isPlural();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_CARDINALITY__INF:
				setInf((Integer)newValue);
				return;
			case RosettaPackage.ROSETTA_CARDINALITY__SUP:
				setSup((Integer)newValue);
				return;
			case RosettaPackage.ROSETTA_CARDINALITY__UNBOUNDED:
				setUnbounded((Boolean)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_CARDINALITY__INF:
				setInf(INF_EDEFAULT);
				return;
			case RosettaPackage.ROSETTA_CARDINALITY__SUP:
				setSup(SUP_EDEFAULT);
				return;
			case RosettaPackage.ROSETTA_CARDINALITY__UNBOUNDED:
				setUnbounded(UNBOUNDED_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_CARDINALITY__INF:
				return inf != INF_EDEFAULT;
			case RosettaPackage.ROSETTA_CARDINALITY__SUP:
				return sup != SUP_EDEFAULT;
			case RosettaPackage.ROSETTA_CARDINALITY__UNBOUNDED:
				return unbounded != UNBOUNDED_EDEFAULT;
			case RosettaPackage.ROSETTA_CARDINALITY__IS_MANY:
				return isIsMany() != IS_MANY_EDEFAULT;
			case RosettaPackage.ROSETTA_CARDINALITY__EMPTY:
				return isEmpty() != EMPTY_EDEFAULT;
			case RosettaPackage.ROSETTA_CARDINALITY__OPTIONAL:
				return isOptional() != OPTIONAL_EDEFAULT;
			case RosettaPackage.ROSETTA_CARDINALITY__SINGULAR:
				return isSingular() != SINGULAR_EDEFAULT;
			case RosettaPackage.ROSETTA_CARDINALITY__PLURAL:
				return isPlural() != PLURAL_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (inf: ");
		result.append(inf);
		result.append(", sup: ");
		result.append(sup);
		result.append(", unbounded: ");
		result.append(unbounded);
		result.append(')');
		return result.toString();
	}

} //RosettaCardinalityImpl
