/**
 * Copyright (c) REGnosys 2017 (www.regnosys.com)
 */
package com.regnosys.rosetta.rosetta.impl;

import com.regnosys.rosetta.rosetta.DocumentRationale;
import com.regnosys.rosetta.rosetta.RegulatoryDocumentReference;
import com.regnosys.rosetta.rosetta.RosettaDocReference;
import com.regnosys.rosetta.rosetta.RosettaPackage;
import com.regnosys.rosetta.rosetta.RosettaSegmentRef;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Doc Reference</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RosettaDocReferenceImpl#getDocReference <em>Doc Reference</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RosettaDocReferenceImpl#getRationales <em>Rationales</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RosettaDocReferenceImpl#getStructuredProvision <em>Structured Provision</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RosettaDocReferenceImpl#getProvision <em>Provision</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RosettaDocReferenceImpl#isReportedField <em>Reported Field</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RosettaDocReferenceImpl#getExtraneousSegments <em>Extraneous Segments</em>}</li>
 * </ul>
 *
 * @generated
 */
public class RosettaDocReferenceImpl extends MinimalEObjectImpl.Container implements RosettaDocReference {
	/**
	 * The cached value of the '{@link #getDocReference() <em>Doc Reference</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDocReference()
	 * @generated
	 * @ordered
	 */
	protected RegulatoryDocumentReference docReference;

	/**
	 * The cached value of the '{@link #getRationales() <em>Rationales</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRationales()
	 * @generated
	 * @ordered
	 */
	protected EList<DocumentRationale> rationales;

	/**
	 * The default value of the '{@link #getStructuredProvision() <em>Structured Provision</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStructuredProvision()
	 * @generated
	 * @ordered
	 */
	protected static final String STRUCTURED_PROVISION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getStructuredProvision() <em>Structured Provision</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStructuredProvision()
	 * @generated
	 * @ordered
	 */
	protected String structuredProvision = STRUCTURED_PROVISION_EDEFAULT;

	/**
	 * The default value of the '{@link #getProvision() <em>Provision</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProvision()
	 * @generated
	 * @ordered
	 */
	protected static final String PROVISION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getProvision() <em>Provision</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProvision()
	 * @generated
	 * @ordered
	 */
	protected String provision = PROVISION_EDEFAULT;

	/**
	 * The default value of the '{@link #isReportedField() <em>Reported Field</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isReportedField()
	 * @generated
	 * @ordered
	 */
	protected static final boolean REPORTED_FIELD_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isReportedField() <em>Reported Field</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isReportedField()
	 * @generated
	 * @ordered
	 */
	protected boolean reportedField = REPORTED_FIELD_EDEFAULT;

	/**
	 * The cached value of the '{@link #getExtraneousSegments() <em>Extraneous Segments</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExtraneousSegments()
	 * @generated
	 * @ordered
	 */
	protected EList<RosettaSegmentRef> extraneousSegments;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RosettaDocReferenceImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return RosettaPackage.Literals.ROSETTA_DOC_REFERENCE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RegulatoryDocumentReference getDocReference() {
		return docReference;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetDocReference(RegulatoryDocumentReference newDocReference, NotificationChain msgs) {
		RegulatoryDocumentReference oldDocReference = docReference;
		docReference = newDocReference;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, RosettaPackage.ROSETTA_DOC_REFERENCE__DOC_REFERENCE, oldDocReference, newDocReference);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDocReference(RegulatoryDocumentReference newDocReference) {
		if (newDocReference != docReference) {
			NotificationChain msgs = null;
			if (docReference != null)
				msgs = ((InternalEObject)docReference).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - RosettaPackage.ROSETTA_DOC_REFERENCE__DOC_REFERENCE, null, msgs);
			if (newDocReference != null)
				msgs = ((InternalEObject)newDocReference).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - RosettaPackage.ROSETTA_DOC_REFERENCE__DOC_REFERENCE, null, msgs);
			msgs = basicSetDocReference(newDocReference, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RosettaPackage.ROSETTA_DOC_REFERENCE__DOC_REFERENCE, newDocReference, newDocReference));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<DocumentRationale> getRationales() {
		if (rationales == null) {
			rationales = new EObjectContainmentEList<DocumentRationale>(DocumentRationale.class, this, RosettaPackage.ROSETTA_DOC_REFERENCE__RATIONALES);
		}
		return rationales;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getStructuredProvision() {
		return structuredProvision;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setStructuredProvision(String newStructuredProvision) {
		String oldStructuredProvision = structuredProvision;
		structuredProvision = newStructuredProvision;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RosettaPackage.ROSETTA_DOC_REFERENCE__STRUCTURED_PROVISION, oldStructuredProvision, structuredProvision));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getProvision() {
		return provision;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setProvision(String newProvision) {
		String oldProvision = provision;
		provision = newProvision;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RosettaPackage.ROSETTA_DOC_REFERENCE__PROVISION, oldProvision, provision));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isReportedField() {
		return reportedField;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setReportedField(boolean newReportedField) {
		boolean oldReportedField = reportedField;
		reportedField = newReportedField;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RosettaPackage.ROSETTA_DOC_REFERENCE__REPORTED_FIELD, oldReportedField, reportedField));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<RosettaSegmentRef> getExtraneousSegments() {
		if (extraneousSegments == null) {
			extraneousSegments = new EObjectContainmentEList<RosettaSegmentRef>(RosettaSegmentRef.class, this, RosettaPackage.ROSETTA_DOC_REFERENCE__EXTRANEOUS_SEGMENTS);
		}
		return extraneousSegments;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_DOC_REFERENCE__DOC_REFERENCE:
				return basicSetDocReference(null, msgs);
			case RosettaPackage.ROSETTA_DOC_REFERENCE__RATIONALES:
				return ((InternalEList<?>)getRationales()).basicRemove(otherEnd, msgs);
			case RosettaPackage.ROSETTA_DOC_REFERENCE__EXTRANEOUS_SEGMENTS:
				return ((InternalEList<?>)getExtraneousSegments()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_DOC_REFERENCE__DOC_REFERENCE:
				return getDocReference();
			case RosettaPackage.ROSETTA_DOC_REFERENCE__RATIONALES:
				return getRationales();
			case RosettaPackage.ROSETTA_DOC_REFERENCE__STRUCTURED_PROVISION:
				return getStructuredProvision();
			case RosettaPackage.ROSETTA_DOC_REFERENCE__PROVISION:
				return getProvision();
			case RosettaPackage.ROSETTA_DOC_REFERENCE__REPORTED_FIELD:
				return isReportedField();
			case RosettaPackage.ROSETTA_DOC_REFERENCE__EXTRANEOUS_SEGMENTS:
				return getExtraneousSegments();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_DOC_REFERENCE__DOC_REFERENCE:
				setDocReference((RegulatoryDocumentReference)newValue);
				return;
			case RosettaPackage.ROSETTA_DOC_REFERENCE__RATIONALES:
				getRationales().clear();
				getRationales().addAll((Collection<? extends DocumentRationale>)newValue);
				return;
			case RosettaPackage.ROSETTA_DOC_REFERENCE__STRUCTURED_PROVISION:
				setStructuredProvision((String)newValue);
				return;
			case RosettaPackage.ROSETTA_DOC_REFERENCE__PROVISION:
				setProvision((String)newValue);
				return;
			case RosettaPackage.ROSETTA_DOC_REFERENCE__REPORTED_FIELD:
				setReportedField((Boolean)newValue);
				return;
			case RosettaPackage.ROSETTA_DOC_REFERENCE__EXTRANEOUS_SEGMENTS:
				getExtraneousSegments().clear();
				getExtraneousSegments().addAll((Collection<? extends RosettaSegmentRef>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_DOC_REFERENCE__DOC_REFERENCE:
				setDocReference((RegulatoryDocumentReference)null);
				return;
			case RosettaPackage.ROSETTA_DOC_REFERENCE__RATIONALES:
				getRationales().clear();
				return;
			case RosettaPackage.ROSETTA_DOC_REFERENCE__STRUCTURED_PROVISION:
				setStructuredProvision(STRUCTURED_PROVISION_EDEFAULT);
				return;
			case RosettaPackage.ROSETTA_DOC_REFERENCE__PROVISION:
				setProvision(PROVISION_EDEFAULT);
				return;
			case RosettaPackage.ROSETTA_DOC_REFERENCE__REPORTED_FIELD:
				setReportedField(REPORTED_FIELD_EDEFAULT);
				return;
			case RosettaPackage.ROSETTA_DOC_REFERENCE__EXTRANEOUS_SEGMENTS:
				getExtraneousSegments().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_DOC_REFERENCE__DOC_REFERENCE:
				return docReference != null;
			case RosettaPackage.ROSETTA_DOC_REFERENCE__RATIONALES:
				return rationales != null && !rationales.isEmpty();
			case RosettaPackage.ROSETTA_DOC_REFERENCE__STRUCTURED_PROVISION:
				return STRUCTURED_PROVISION_EDEFAULT == null ? structuredProvision != null : !STRUCTURED_PROVISION_EDEFAULT.equals(structuredProvision);
			case RosettaPackage.ROSETTA_DOC_REFERENCE__PROVISION:
				return PROVISION_EDEFAULT == null ? provision != null : !PROVISION_EDEFAULT.equals(provision);
			case RosettaPackage.ROSETTA_DOC_REFERENCE__REPORTED_FIELD:
				return reportedField != REPORTED_FIELD_EDEFAULT;
			case RosettaPackage.ROSETTA_DOC_REFERENCE__EXTRANEOUS_SEGMENTS:
				return extraneousSegments != null && !extraneousSegments.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (structuredProvision: ");
		result.append(structuredProvision);
		result.append(", provision: ");
		result.append(provision);
		result.append(", reportedField: ");
		result.append(reportedField);
		result.append(')');
		return result.toString();
	}

} //RosettaDocReferenceImpl
