/**
 * Copyright (c) REGnosys 2017 (www.regnosys.com)
 */
package com.regnosys.rosetta.rosetta.impl;

import com.regnosys.rosetta.rosetta.ExternalValueOperator;
import com.regnosys.rosetta.rosetta.RosettaExternalRegularAttribute;
import com.regnosys.rosetta.rosetta.RosettaExternalSynonym;
import com.regnosys.rosetta.rosetta.RosettaFeature;
import com.regnosys.rosetta.rosetta.RosettaPackage;

import com.regnosys.rosetta.rosetta.simple.RosettaRuleReference;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>External Regular Attribute</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RosettaExternalRegularAttributeImpl#getOperator <em>Operator</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RosettaExternalRegularAttributeImpl#getAttributeRef <em>Attribute Ref</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RosettaExternalRegularAttributeImpl#getExternalSynonyms <em>External Synonyms</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RosettaExternalRegularAttributeImpl#getExternalRuleReference <em>External Rule Reference</em>}</li>
 * </ul>
 *
 * @generated
 */
public class RosettaExternalRegularAttributeImpl extends MinimalEObjectImpl.Container implements RosettaExternalRegularAttribute {
	/**
	 * The default value of the '{@link #getOperator() <em>Operator</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOperator()
	 * @generated
	 * @ordered
	 */
	protected static final ExternalValueOperator OPERATOR_EDEFAULT = ExternalValueOperator.PLUS;

	/**
	 * The cached value of the '{@link #getOperator() <em>Operator</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOperator()
	 * @generated
	 * @ordered
	 */
	protected ExternalValueOperator operator = OPERATOR_EDEFAULT;

	/**
	 * The cached value of the '{@link #getAttributeRef() <em>Attribute Ref</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAttributeRef()
	 * @generated
	 * @ordered
	 */
	protected RosettaFeature attributeRef;

	/**
	 * The cached value of the '{@link #getExternalSynonyms() <em>External Synonyms</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExternalSynonyms()
	 * @generated
	 * @ordered
	 */
	protected EList<RosettaExternalSynonym> externalSynonyms;

	/**
	 * The cached value of the '{@link #getExternalRuleReference() <em>External Rule Reference</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExternalRuleReference()
	 * @generated
	 * @ordered
	 */
	protected RosettaRuleReference externalRuleReference;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RosettaExternalRegularAttributeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return RosettaPackage.Literals.ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ExternalValueOperator getOperator() {
		return operator;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setOperator(ExternalValueOperator newOperator) {
		ExternalValueOperator oldOperator = operator;
		operator = newOperator == null ? OPERATOR_EDEFAULT : newOperator;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RosettaPackage.ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE__OPERATOR, oldOperator, operator));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaFeature getAttributeRef() {
		if (attributeRef != null && attributeRef.eIsProxy()) {
			InternalEObject oldAttributeRef = (InternalEObject)attributeRef;
			attributeRef = (RosettaFeature)eResolveProxy(oldAttributeRef);
			if (attributeRef != oldAttributeRef) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, RosettaPackage.ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE__ATTRIBUTE_REF, oldAttributeRef, attributeRef));
			}
		}
		return attributeRef;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RosettaFeature basicGetAttributeRef() {
		return attributeRef;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAttributeRef(RosettaFeature newAttributeRef) {
		RosettaFeature oldAttributeRef = attributeRef;
		attributeRef = newAttributeRef;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RosettaPackage.ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE__ATTRIBUTE_REF, oldAttributeRef, attributeRef));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<RosettaExternalSynonym> getExternalSynonyms() {
		if (externalSynonyms == null) {
			externalSynonyms = new EObjectContainmentEList<RosettaExternalSynonym>(RosettaExternalSynonym.class, this, RosettaPackage.ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE__EXTERNAL_SYNONYMS);
		}
		return externalSynonyms;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaRuleReference getExternalRuleReference() {
		return externalRuleReference;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetExternalRuleReference(RosettaRuleReference newExternalRuleReference, NotificationChain msgs) {
		RosettaRuleReference oldExternalRuleReference = externalRuleReference;
		externalRuleReference = newExternalRuleReference;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, RosettaPackage.ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE__EXTERNAL_RULE_REFERENCE, oldExternalRuleReference, newExternalRuleReference);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setExternalRuleReference(RosettaRuleReference newExternalRuleReference) {
		if (newExternalRuleReference != externalRuleReference) {
			NotificationChain msgs = null;
			if (externalRuleReference != null)
				msgs = ((InternalEObject)externalRuleReference).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - RosettaPackage.ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE__EXTERNAL_RULE_REFERENCE, null, msgs);
			if (newExternalRuleReference != null)
				msgs = ((InternalEObject)newExternalRuleReference).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - RosettaPackage.ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE__EXTERNAL_RULE_REFERENCE, null, msgs);
			msgs = basicSetExternalRuleReference(newExternalRuleReference, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RosettaPackage.ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE__EXTERNAL_RULE_REFERENCE, newExternalRuleReference, newExternalRuleReference));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE__EXTERNAL_SYNONYMS:
				return ((InternalEList<?>)getExternalSynonyms()).basicRemove(otherEnd, msgs);
			case RosettaPackage.ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE__EXTERNAL_RULE_REFERENCE:
				return basicSetExternalRuleReference(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE__OPERATOR:
				return getOperator();
			case RosettaPackage.ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE__ATTRIBUTE_REF:
				if (resolve) return getAttributeRef();
				return basicGetAttributeRef();
			case RosettaPackage.ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE__EXTERNAL_SYNONYMS:
				return getExternalSynonyms();
			case RosettaPackage.ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE__EXTERNAL_RULE_REFERENCE:
				return getExternalRuleReference();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE__OPERATOR:
				setOperator((ExternalValueOperator)newValue);
				return;
			case RosettaPackage.ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE__ATTRIBUTE_REF:
				setAttributeRef((RosettaFeature)newValue);
				return;
			case RosettaPackage.ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE__EXTERNAL_SYNONYMS:
				getExternalSynonyms().clear();
				getExternalSynonyms().addAll((Collection<? extends RosettaExternalSynonym>)newValue);
				return;
			case RosettaPackage.ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE__EXTERNAL_RULE_REFERENCE:
				setExternalRuleReference((RosettaRuleReference)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE__OPERATOR:
				setOperator(OPERATOR_EDEFAULT);
				return;
			case RosettaPackage.ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE__ATTRIBUTE_REF:
				setAttributeRef((RosettaFeature)null);
				return;
			case RosettaPackage.ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE__EXTERNAL_SYNONYMS:
				getExternalSynonyms().clear();
				return;
			case RosettaPackage.ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE__EXTERNAL_RULE_REFERENCE:
				setExternalRuleReference((RosettaRuleReference)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE__OPERATOR:
				return operator != OPERATOR_EDEFAULT;
			case RosettaPackage.ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE__ATTRIBUTE_REF:
				return attributeRef != null;
			case RosettaPackage.ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE__EXTERNAL_SYNONYMS:
				return externalSynonyms != null && !externalSynonyms.isEmpty();
			case RosettaPackage.ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE__EXTERNAL_RULE_REFERENCE:
				return externalRuleReference != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (operator: ");
		result.append(operator);
		result.append(')');
		return result.toString();
	}

} //RosettaExternalRegularAttributeImpl
