/**
 * Copyright (c) REGnosys 2017 (www.regnosys.com)
 */
package com.regnosys.rosetta.rosetta.impl;

import com.regnosys.rosetta.rosetta.RegulatoryDocumentReference;
import com.regnosys.rosetta.rosetta.RosettaCorpus;
import com.regnosys.rosetta.rosetta.RosettaExternalRuleSource;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.regnosys.rosetta.rosetta.RosettaPackage;
import com.regnosys.rosetta.rosetta.RosettaReport;
import com.regnosys.rosetta.rosetta.RosettaRule;
import com.regnosys.rosetta.rosetta.TypeCall;

import com.regnosys.rosetta.rosetta.simple.Data;

import java.util.Collection;

import java.util.function.Function;

import java.util.stream.Collectors;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;

import org.eclipse.xtext.xbase.lib.StringExtensions;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Report</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RosettaReportImpl#getModel <em>Model</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RosettaReportImpl#getRegulatoryBody <em>Regulatory Body</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RosettaReportImpl#getEligibilityRules <em>Eligibility Rules</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RosettaReportImpl#getReportingStandard <em>Reporting Standard</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RosettaReportImpl#getInputType <em>Input Type</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RosettaReportImpl#getReportType <em>Report Type</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RosettaReportImpl#getRuleSource <em>Rule Source</em>}</li>
 * </ul>
 *
 * @generated
 */
public class RosettaReportImpl extends MinimalEObjectImpl.Container implements RosettaReport {
	/**
	 * The cached value of the '{@link #getRegulatoryBody() <em>Regulatory Body</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRegulatoryBody()
	 * @generated
	 * @ordered
	 */
	protected RegulatoryDocumentReference regulatoryBody;

	/**
	 * The cached value of the '{@link #getEligibilityRules() <em>Eligibility Rules</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEligibilityRules()
	 * @generated
	 * @ordered
	 */
	protected EList<RosettaRule> eligibilityRules;

	/**
	 * The cached value of the '{@link #getReportingStandard() <em>Reporting Standard</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReportingStandard()
	 * @generated
	 * @ordered
	 */
	protected RosettaCorpus reportingStandard;

	/**
	 * The cached value of the '{@link #getInputType() <em>Input Type</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInputType()
	 * @generated
	 * @ordered
	 */
	protected TypeCall inputType;

	/**
	 * The cached value of the '{@link #getReportType() <em>Report Type</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReportType()
	 * @generated
	 * @ordered
	 */
	protected Data reportType;

	/**
	 * The cached value of the '{@link #getRuleSource() <em>Rule Source</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRuleSource()
	 * @generated
	 * @ordered
	 */
	protected RosettaExternalRuleSource ruleSource;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RosettaReportImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return RosettaPackage.Literals.ROSETTA_REPORT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaModel getModel() {
		if (eContainerFeatureID() != RosettaPackage.ROSETTA_REPORT__MODEL) return null;
		return (RosettaModel)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RosettaModel basicGetModel() {
		if (eContainerFeatureID() != RosettaPackage.ROSETTA_REPORT__MODEL) return null;
		return (RosettaModel)eInternalContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetModel(RosettaModel newModel, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newModel, RosettaPackage.ROSETTA_REPORT__MODEL, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setModel(RosettaModel newModel) {
		if (newModel != eInternalContainer() || (eContainerFeatureID() != RosettaPackage.ROSETTA_REPORT__MODEL && newModel != null)) {
			if (EcoreUtil.isAncestor(this, newModel))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newModel != null)
				msgs = ((InternalEObject)newModel).eInverseAdd(this, RosettaPackage.ROSETTA_MODEL__ELEMENTS, RosettaModel.class, msgs);
			msgs = basicSetModel(newModel, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RosettaPackage.ROSETTA_REPORT__MODEL, newModel, newModel));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RegulatoryDocumentReference getRegulatoryBody() {
		return regulatoryBody;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetRegulatoryBody(RegulatoryDocumentReference newRegulatoryBody, NotificationChain msgs) {
		RegulatoryDocumentReference oldRegulatoryBody = regulatoryBody;
		regulatoryBody = newRegulatoryBody;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, RosettaPackage.ROSETTA_REPORT__REGULATORY_BODY, oldRegulatoryBody, newRegulatoryBody);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setRegulatoryBody(RegulatoryDocumentReference newRegulatoryBody) {
		if (newRegulatoryBody != regulatoryBody) {
			NotificationChain msgs = null;
			if (regulatoryBody != null)
				msgs = ((InternalEObject)regulatoryBody).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - RosettaPackage.ROSETTA_REPORT__REGULATORY_BODY, null, msgs);
			if (newRegulatoryBody != null)
				msgs = ((InternalEObject)newRegulatoryBody).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - RosettaPackage.ROSETTA_REPORT__REGULATORY_BODY, null, msgs);
			msgs = basicSetRegulatoryBody(newRegulatoryBody, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RosettaPackage.ROSETTA_REPORT__REGULATORY_BODY, newRegulatoryBody, newRegulatoryBody));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<RosettaRule> getEligibilityRules() {
		if (eligibilityRules == null) {
			eligibilityRules = new EObjectResolvingEList<RosettaRule>(RosettaRule.class, this, RosettaPackage.ROSETTA_REPORT__ELIGIBILITY_RULES);
		}
		return eligibilityRules;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaCorpus getReportingStandard() {
		if (reportingStandard != null && reportingStandard.eIsProxy()) {
			InternalEObject oldReportingStandard = (InternalEObject)reportingStandard;
			reportingStandard = (RosettaCorpus)eResolveProxy(oldReportingStandard);
			if (reportingStandard != oldReportingStandard) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, RosettaPackage.ROSETTA_REPORT__REPORTING_STANDARD, oldReportingStandard, reportingStandard));
			}
		}
		return reportingStandard;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RosettaCorpus basicGetReportingStandard() {
		return reportingStandard;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setReportingStandard(RosettaCorpus newReportingStandard) {
		RosettaCorpus oldReportingStandard = reportingStandard;
		reportingStandard = newReportingStandard;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RosettaPackage.ROSETTA_REPORT__REPORTING_STANDARD, oldReportingStandard, reportingStandard));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public TypeCall getInputType() {
		return inputType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetInputType(TypeCall newInputType, NotificationChain msgs) {
		TypeCall oldInputType = inputType;
		inputType = newInputType;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, RosettaPackage.ROSETTA_REPORT__INPUT_TYPE, oldInputType, newInputType);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setInputType(TypeCall newInputType) {
		if (newInputType != inputType) {
			NotificationChain msgs = null;
			if (inputType != null)
				msgs = ((InternalEObject)inputType).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - RosettaPackage.ROSETTA_REPORT__INPUT_TYPE, null, msgs);
			if (newInputType != null)
				msgs = ((InternalEObject)newInputType).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - RosettaPackage.ROSETTA_REPORT__INPUT_TYPE, null, msgs);
			msgs = basicSetInputType(newInputType, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RosettaPackage.ROSETTA_REPORT__INPUT_TYPE, newInputType, newInputType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Data getReportType() {
		if (reportType != null && reportType.eIsProxy()) {
			InternalEObject oldReportType = (InternalEObject)reportType;
			reportType = (Data)eResolveProxy(oldReportType);
			if (reportType != oldReportType) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, RosettaPackage.ROSETTA_REPORT__REPORT_TYPE, oldReportType, reportType));
			}
		}
		return reportType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Data basicGetReportType() {
		return reportType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setReportType(Data newReportType) {
		Data oldReportType = reportType;
		reportType = newReportType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RosettaPackage.ROSETTA_REPORT__REPORT_TYPE, oldReportType, reportType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaExternalRuleSource getRuleSource() {
		if (ruleSource != null && ruleSource.eIsProxy()) {
			InternalEObject oldRuleSource = (InternalEObject)ruleSource;
			ruleSource = (RosettaExternalRuleSource)eResolveProxy(oldRuleSource);
			if (ruleSource != oldRuleSource) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, RosettaPackage.ROSETTA_REPORT__RULE_SOURCE, oldRuleSource, ruleSource));
			}
		}
		return ruleSource;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RosettaExternalRuleSource basicGetRuleSource() {
		return ruleSource;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setRuleSource(RosettaExternalRuleSource newRuleSource) {
		RosettaExternalRuleSource oldRuleSource = ruleSource;
		ruleSource = newRuleSource;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RosettaPackage.ROSETTA_REPORT__RULE_SOURCE, oldRuleSource, ruleSource));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getRegulatoryId() {
		String _firstUpper = StringExtensions.toFirstUpper(this.getRegulatoryBody().getBody().getName());
		final Function<RosettaCorpus, String> _function = new Function<RosettaCorpus, String>() {
			public String apply(final RosettaCorpus man) {
				return StringExtensions.toFirstUpper(man.getName());
			}
		};
		String _collect = this.getRegulatoryBody().getCorpusList().stream().<String>map(_function).collect(Collectors.joining());
		return (_firstUpper + _collect);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_REPORT__MODEL:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetModel((RosettaModel)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_REPORT__MODEL:
				return basicSetModel(null, msgs);
			case RosettaPackage.ROSETTA_REPORT__REGULATORY_BODY:
				return basicSetRegulatoryBody(null, msgs);
			case RosettaPackage.ROSETTA_REPORT__INPUT_TYPE:
				return basicSetInputType(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case RosettaPackage.ROSETTA_REPORT__MODEL:
				return eInternalContainer().eInverseRemove(this, RosettaPackage.ROSETTA_MODEL__ELEMENTS, RosettaModel.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_REPORT__MODEL:
				if (resolve) return getModel();
				return basicGetModel();
			case RosettaPackage.ROSETTA_REPORT__REGULATORY_BODY:
				return getRegulatoryBody();
			case RosettaPackage.ROSETTA_REPORT__ELIGIBILITY_RULES:
				return getEligibilityRules();
			case RosettaPackage.ROSETTA_REPORT__REPORTING_STANDARD:
				if (resolve) return getReportingStandard();
				return basicGetReportingStandard();
			case RosettaPackage.ROSETTA_REPORT__INPUT_TYPE:
				return getInputType();
			case RosettaPackage.ROSETTA_REPORT__REPORT_TYPE:
				if (resolve) return getReportType();
				return basicGetReportType();
			case RosettaPackage.ROSETTA_REPORT__RULE_SOURCE:
				if (resolve) return getRuleSource();
				return basicGetRuleSource();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_REPORT__MODEL:
				setModel((RosettaModel)newValue);
				return;
			case RosettaPackage.ROSETTA_REPORT__REGULATORY_BODY:
				setRegulatoryBody((RegulatoryDocumentReference)newValue);
				return;
			case RosettaPackage.ROSETTA_REPORT__ELIGIBILITY_RULES:
				getEligibilityRules().clear();
				getEligibilityRules().addAll((Collection<? extends RosettaRule>)newValue);
				return;
			case RosettaPackage.ROSETTA_REPORT__REPORTING_STANDARD:
				setReportingStandard((RosettaCorpus)newValue);
				return;
			case RosettaPackage.ROSETTA_REPORT__INPUT_TYPE:
				setInputType((TypeCall)newValue);
				return;
			case RosettaPackage.ROSETTA_REPORT__REPORT_TYPE:
				setReportType((Data)newValue);
				return;
			case RosettaPackage.ROSETTA_REPORT__RULE_SOURCE:
				setRuleSource((RosettaExternalRuleSource)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_REPORT__MODEL:
				setModel((RosettaModel)null);
				return;
			case RosettaPackage.ROSETTA_REPORT__REGULATORY_BODY:
				setRegulatoryBody((RegulatoryDocumentReference)null);
				return;
			case RosettaPackage.ROSETTA_REPORT__ELIGIBILITY_RULES:
				getEligibilityRules().clear();
				return;
			case RosettaPackage.ROSETTA_REPORT__REPORTING_STANDARD:
				setReportingStandard((RosettaCorpus)null);
				return;
			case RosettaPackage.ROSETTA_REPORT__INPUT_TYPE:
				setInputType((TypeCall)null);
				return;
			case RosettaPackage.ROSETTA_REPORT__REPORT_TYPE:
				setReportType((Data)null);
				return;
			case RosettaPackage.ROSETTA_REPORT__RULE_SOURCE:
				setRuleSource((RosettaExternalRuleSource)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_REPORT__MODEL:
				return basicGetModel() != null;
			case RosettaPackage.ROSETTA_REPORT__REGULATORY_BODY:
				return regulatoryBody != null;
			case RosettaPackage.ROSETTA_REPORT__ELIGIBILITY_RULES:
				return eligibilityRules != null && !eligibilityRules.isEmpty();
			case RosettaPackage.ROSETTA_REPORT__REPORTING_STANDARD:
				return reportingStandard != null;
			case RosettaPackage.ROSETTA_REPORT__INPUT_TYPE:
				return inputType != null;
			case RosettaPackage.ROSETTA_REPORT__REPORT_TYPE:
				return reportType != null;
			case RosettaPackage.ROSETTA_REPORT__RULE_SOURCE:
				return ruleSource != null;
		}
		return super.eIsSet(featureID);
	}

} //RosettaReportImpl
