/**
 * Copyright (c) REGnosys 2017 (www.regnosys.com)
 */
package com.regnosys.rosetta.rosetta.impl;

import com.regnosys.rosetta.rosetta.ParametrizedRosettaType;
import com.regnosys.rosetta.rosetta.RosettaDefinable;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.regnosys.rosetta.rosetta.RosettaNamed;
import com.regnosys.rosetta.rosetta.RosettaPackage;
import com.regnosys.rosetta.rosetta.RosettaType;
import com.regnosys.rosetta.rosetta.RosettaTypeAlias;
import com.regnosys.rosetta.rosetta.RosettaTyped;
import com.regnosys.rosetta.rosetta.TypeCall;
import com.regnosys.rosetta.rosetta.TypeParameter;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Type Alias</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RosettaTypeAliasImpl#getModel <em>Model</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RosettaTypeAliasImpl#getName <em>Name</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RosettaTypeAliasImpl#getTypeCall <em>Type Call</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RosettaTypeAliasImpl#isIsTypeInferred <em>Is Type Inferred</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RosettaTypeAliasImpl#getDefinition <em>Definition</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RosettaTypeAliasImpl#getParameters <em>Parameters</em>}</li>
 * </ul>
 *
 * @generated
 */
public class RosettaTypeAliasImpl extends MinimalEObjectImpl.Container implements RosettaTypeAlias {
	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The cached value of the '{@link #getTypeCall() <em>Type Call</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTypeCall()
	 * @generated
	 * @ordered
	 */
	protected TypeCall typeCall;

	/**
	 * The default value of the '{@link #isIsTypeInferred() <em>Is Type Inferred</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsTypeInferred()
	 * @generated
	 * @ordered
	 */
	protected static final boolean IS_TYPE_INFERRED_EDEFAULT = false;

	/**
	 * The default value of the '{@link #getDefinition() <em>Definition</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDefinition()
	 * @generated
	 * @ordered
	 */
	protected static final String DEFINITION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDefinition() <em>Definition</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDefinition()
	 * @generated
	 * @ordered
	 */
	protected String definition = DEFINITION_EDEFAULT;

	/**
	 * The cached value of the '{@link #getParameters() <em>Parameters</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getParameters()
	 * @generated
	 * @ordered
	 */
	protected EList<TypeParameter> parameters;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RosettaTypeAliasImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return RosettaPackage.Literals.ROSETTA_TYPE_ALIAS;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaModel getModel() {
		if (eContainerFeatureID() != RosettaPackage.ROSETTA_TYPE_ALIAS__MODEL) return null;
		return (RosettaModel)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RosettaModel basicGetModel() {
		if (eContainerFeatureID() != RosettaPackage.ROSETTA_TYPE_ALIAS__MODEL) return null;
		return (RosettaModel)eInternalContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetModel(RosettaModel newModel, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newModel, RosettaPackage.ROSETTA_TYPE_ALIAS__MODEL, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setModel(RosettaModel newModel) {
		if (newModel != eInternalContainer() || (eContainerFeatureID() != RosettaPackage.ROSETTA_TYPE_ALIAS__MODEL && newModel != null)) {
			if (EcoreUtil.isAncestor(this, newModel))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newModel != null)
				msgs = ((InternalEObject)newModel).eInverseAdd(this, RosettaPackage.ROSETTA_MODEL__ELEMENTS, RosettaModel.class, msgs);
			msgs = basicSetModel(newModel, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RosettaPackage.ROSETTA_TYPE_ALIAS__MODEL, newModel, newModel));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RosettaPackage.ROSETTA_TYPE_ALIAS__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public TypeCall getTypeCall() {
		return typeCall;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetTypeCall(TypeCall newTypeCall, NotificationChain msgs) {
		TypeCall oldTypeCall = typeCall;
		typeCall = newTypeCall;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, RosettaPackage.ROSETTA_TYPE_ALIAS__TYPE_CALL, oldTypeCall, newTypeCall);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setTypeCall(TypeCall newTypeCall) {
		if (newTypeCall != typeCall) {
			NotificationChain msgs = null;
			if (typeCall != null)
				msgs = ((InternalEObject)typeCall).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - RosettaPackage.ROSETTA_TYPE_ALIAS__TYPE_CALL, null, msgs);
			if (newTypeCall != null)
				msgs = ((InternalEObject)newTypeCall).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - RosettaPackage.ROSETTA_TYPE_ALIAS__TYPE_CALL, null, msgs);
			msgs = basicSetTypeCall(newTypeCall, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RosettaPackage.ROSETTA_TYPE_ALIAS__TYPE_CALL, newTypeCall, newTypeCall));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isIsTypeInferred() {
		TypeCall _typeCall = this.getTypeCall();
		return (_typeCall == null);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getDefinition() {
		return definition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDefinition(String newDefinition) {
		String oldDefinition = definition;
		definition = newDefinition;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RosettaPackage.ROSETTA_TYPE_ALIAS__DEFINITION, oldDefinition, definition));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<TypeParameter> getParameters() {
		if (parameters == null) {
			parameters = new EObjectContainmentEList<TypeParameter>(TypeParameter.class, this, RosettaPackage.ROSETTA_TYPE_ALIAS__PARAMETERS);
		}
		return parameters;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_TYPE_ALIAS__MODEL:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetModel((RosettaModel)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_TYPE_ALIAS__MODEL:
				return basicSetModel(null, msgs);
			case RosettaPackage.ROSETTA_TYPE_ALIAS__TYPE_CALL:
				return basicSetTypeCall(null, msgs);
			case RosettaPackage.ROSETTA_TYPE_ALIAS__PARAMETERS:
				return ((InternalEList<?>)getParameters()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case RosettaPackage.ROSETTA_TYPE_ALIAS__MODEL:
				return eInternalContainer().eInverseRemove(this, RosettaPackage.ROSETTA_MODEL__ELEMENTS, RosettaModel.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_TYPE_ALIAS__MODEL:
				if (resolve) return getModel();
				return basicGetModel();
			case RosettaPackage.ROSETTA_TYPE_ALIAS__NAME:
				return getName();
			case RosettaPackage.ROSETTA_TYPE_ALIAS__TYPE_CALL:
				return getTypeCall();
			case RosettaPackage.ROSETTA_TYPE_ALIAS__IS_TYPE_INFERRED:
				return isIsTypeInferred();
			case RosettaPackage.ROSETTA_TYPE_ALIAS__DEFINITION:
				return getDefinition();
			case RosettaPackage.ROSETTA_TYPE_ALIAS__PARAMETERS:
				return getParameters();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_TYPE_ALIAS__MODEL:
				setModel((RosettaModel)newValue);
				return;
			case RosettaPackage.ROSETTA_TYPE_ALIAS__NAME:
				setName((String)newValue);
				return;
			case RosettaPackage.ROSETTA_TYPE_ALIAS__TYPE_CALL:
				setTypeCall((TypeCall)newValue);
				return;
			case RosettaPackage.ROSETTA_TYPE_ALIAS__DEFINITION:
				setDefinition((String)newValue);
				return;
			case RosettaPackage.ROSETTA_TYPE_ALIAS__PARAMETERS:
				getParameters().clear();
				getParameters().addAll((Collection<? extends TypeParameter>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_TYPE_ALIAS__MODEL:
				setModel((RosettaModel)null);
				return;
			case RosettaPackage.ROSETTA_TYPE_ALIAS__NAME:
				setName(NAME_EDEFAULT);
				return;
			case RosettaPackage.ROSETTA_TYPE_ALIAS__TYPE_CALL:
				setTypeCall((TypeCall)null);
				return;
			case RosettaPackage.ROSETTA_TYPE_ALIAS__DEFINITION:
				setDefinition(DEFINITION_EDEFAULT);
				return;
			case RosettaPackage.ROSETTA_TYPE_ALIAS__PARAMETERS:
				getParameters().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_TYPE_ALIAS__MODEL:
				return basicGetModel() != null;
			case RosettaPackage.ROSETTA_TYPE_ALIAS__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case RosettaPackage.ROSETTA_TYPE_ALIAS__TYPE_CALL:
				return typeCall != null;
			case RosettaPackage.ROSETTA_TYPE_ALIAS__IS_TYPE_INFERRED:
				return isIsTypeInferred() != IS_TYPE_INFERRED_EDEFAULT;
			case RosettaPackage.ROSETTA_TYPE_ALIAS__DEFINITION:
				return DEFINITION_EDEFAULT == null ? definition != null : !DEFINITION_EDEFAULT.equals(definition);
			case RosettaPackage.ROSETTA_TYPE_ALIAS__PARAMETERS:
				return parameters != null && !parameters.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == RosettaNamed.class) {
			switch (derivedFeatureID) {
				case RosettaPackage.ROSETTA_TYPE_ALIAS__NAME: return RosettaPackage.ROSETTA_NAMED__NAME;
				default: return -1;
			}
		}
		if (baseClass == RosettaType.class) {
			switch (derivedFeatureID) {
				default: return -1;
			}
		}
		if (baseClass == RosettaTyped.class) {
			switch (derivedFeatureID) {
				case RosettaPackage.ROSETTA_TYPE_ALIAS__TYPE_CALL: return RosettaPackage.ROSETTA_TYPED__TYPE_CALL;
				case RosettaPackage.ROSETTA_TYPE_ALIAS__IS_TYPE_INFERRED: return RosettaPackage.ROSETTA_TYPED__IS_TYPE_INFERRED;
				default: return -1;
			}
		}
		if (baseClass == RosettaDefinable.class) {
			switch (derivedFeatureID) {
				case RosettaPackage.ROSETTA_TYPE_ALIAS__DEFINITION: return RosettaPackage.ROSETTA_DEFINABLE__DEFINITION;
				default: return -1;
			}
		}
		if (baseClass == ParametrizedRosettaType.class) {
			switch (derivedFeatureID) {
				case RosettaPackage.ROSETTA_TYPE_ALIAS__PARAMETERS: return RosettaPackage.PARAMETRIZED_ROSETTA_TYPE__PARAMETERS;
				default: return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == RosettaNamed.class) {
			switch (baseFeatureID) {
				case RosettaPackage.ROSETTA_NAMED__NAME: return RosettaPackage.ROSETTA_TYPE_ALIAS__NAME;
				default: return -1;
			}
		}
		if (baseClass == RosettaType.class) {
			switch (baseFeatureID) {
				default: return -1;
			}
		}
		if (baseClass == RosettaTyped.class) {
			switch (baseFeatureID) {
				case RosettaPackage.ROSETTA_TYPED__TYPE_CALL: return RosettaPackage.ROSETTA_TYPE_ALIAS__TYPE_CALL;
				case RosettaPackage.ROSETTA_TYPED__IS_TYPE_INFERRED: return RosettaPackage.ROSETTA_TYPE_ALIAS__IS_TYPE_INFERRED;
				default: return -1;
			}
		}
		if (baseClass == RosettaDefinable.class) {
			switch (baseFeatureID) {
				case RosettaPackage.ROSETTA_DEFINABLE__DEFINITION: return RosettaPackage.ROSETTA_TYPE_ALIAS__DEFINITION;
				default: return -1;
			}
		}
		if (baseClass == ParametrizedRosettaType.class) {
			switch (baseFeatureID) {
				case RosettaPackage.PARAMETRIZED_ROSETTA_TYPE__PARAMETERS: return RosettaPackage.ROSETTA_TYPE_ALIAS__PARAMETERS;
				default: return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (name: ");
		result.append(name);
		result.append(", definition: ");
		result.append(definition);
		result.append(')');
		return result.toString();
	}

} //RosettaTypeAliasImpl
