/**
 * Copyright (c) REGnosys 2017 (www.regnosys.com)
 */
package com.regnosys.rosetta.rosetta.simple;

import com.regnosys.rosetta.rosetta.RosettaCallableWithArgs;
import com.regnosys.rosetta.rosetta.RosettaNamed;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Function</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link com.regnosys.rosetta.rosetta.simple.Function#getInputs <em>Inputs</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.simple.Function#getOutput <em>Output</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.simple.Function#getShortcuts <em>Shortcuts</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.simple.Function#getConditions <em>Conditions</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.simple.Function#getOperations <em>Operations</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.simple.Function#getPostConditions <em>Post Conditions</em>}</li>
 * </ul>
 *
 * @see com.regnosys.rosetta.rosetta.simple.SimplePackage#getFunction()
 * @model
 * @generated
 */
public interface Function extends RootElement, RosettaNamed, RosettaCallableWithArgs, References {
	/**
	 * Returns the value of the '<em><b>Inputs</b></em>' containment reference list.
	 * The list contents are of type {@link com.regnosys.rosetta.rosetta.simple.Attribute}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Inputs</em>' containment reference list.
	 * @see com.regnosys.rosetta.rosetta.simple.SimplePackage#getFunction_Inputs()
	 * @model containment="true"
	 * @generated
	 */
	EList<Attribute> getInputs();

	/**
	 * Returns the value of the '<em><b>Output</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Output</em>' containment reference.
	 * @see #setOutput(Attribute)
	 * @see com.regnosys.rosetta.rosetta.simple.SimplePackage#getFunction_Output()
	 * @model containment="true"
	 * @generated
	 */
	Attribute getOutput();

	/**
	 * Sets the value of the '{@link com.regnosys.rosetta.rosetta.simple.Function#getOutput <em>Output</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Output</em>' containment reference.
	 * @see #getOutput()
	 * @generated
	 */
	void setOutput(Attribute value);

	/**
	 * Returns the value of the '<em><b>Shortcuts</b></em>' containment reference list.
	 * The list contents are of type {@link com.regnosys.rosetta.rosetta.simple.ShortcutDeclaration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Shortcuts</em>' containment reference list.
	 * @see com.regnosys.rosetta.rosetta.simple.SimplePackage#getFunction_Shortcuts()
	 * @model containment="true"
	 * @generated
	 */
	EList<ShortcutDeclaration> getShortcuts();

	/**
	 * Returns the value of the '<em><b>Conditions</b></em>' containment reference list.
	 * The list contents are of type {@link com.regnosys.rosetta.rosetta.simple.Condition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Conditions</em>' containment reference list.
	 * @see com.regnosys.rosetta.rosetta.simple.SimplePackage#getFunction_Conditions()
	 * @model containment="true"
	 * @generated
	 */
	EList<Condition> getConditions();

	/**
	 * Returns the value of the '<em><b>Operations</b></em>' containment reference list.
	 * The list contents are of type {@link com.regnosys.rosetta.rosetta.simple.Operation}.
	 * It is bidirectional and its opposite is '{@link com.regnosys.rosetta.rosetta.simple.Operation#getFunction <em>Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Operations</em>' containment reference list.
	 * @see com.regnosys.rosetta.rosetta.simple.SimplePackage#getFunction_Operations()
	 * @see com.regnosys.rosetta.rosetta.simple.Operation#getFunction
	 * @model opposite="function" containment="true"
	 * @generated
	 */
	EList<Operation> getOperations();

	/**
	 * Returns the value of the '<em><b>Post Conditions</b></em>' containment reference list.
	 * The list contents are of type {@link com.regnosys.rosetta.rosetta.simple.Condition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Post Conditions</em>' containment reference list.
	 * @see com.regnosys.rosetta.rosetta.simple.SimplePackage#getFunction_PostConditions()
	 * @model containment="true"
	 * @generated
	 */
	EList<Condition> getPostConditions();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model unique="false"
	 * @generated
	 */
	int numberOfParameters();

} // Function
