/**
 * Copyright (c) REGnosys 2017 (www.regnosys.com)
 */
package com.regnosys.rosetta.rosetta.simple;

import com.regnosys.rosetta.rosetta.RosettaPackage;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see com.regnosys.rosetta.rosetta.simple.SimpleFactory
 * @model kind="package"
 * @generated
 */
public interface SimplePackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "simple";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.rosetta-model.com/RosettaSimple";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "simple";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	SimplePackage eINSTANCE = com.regnosys.rosetta.rosetta.simple.impl.SimplePackageImpl.init();

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.simple.impl.RootElementImpl <em>Root Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.simple.impl.RootElementImpl
	 * @see com.regnosys.rosetta.rosetta.simple.impl.SimplePackageImpl#getRootElement()
	 * @generated
	 */
	int ROOT_ELEMENT = 0;

	/**
	 * The feature id for the '<em><b>Model</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROOT_ELEMENT__MODEL = RosettaPackage.ROSETTA_ROOT_ELEMENT__MODEL;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROOT_ELEMENT__NAME = RosettaPackage.ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Definition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROOT_ELEMENT__DEFINITION = RosettaPackage.ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROOT_ELEMENT__ANNOTATIONS = RosettaPackage.ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Root Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROOT_ELEMENT_FEATURE_COUNT = RosettaPackage.ROSETTA_ROOT_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.simple.impl.AnnotationImpl <em>Annotation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.simple.impl.AnnotationImpl
	 * @see com.regnosys.rosetta.rosetta.simple.impl.SimplePackageImpl#getAnnotation()
	 * @generated
	 */
	int ANNOTATION = 1;

	/**
	 * The feature id for the '<em><b>Model</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION__MODEL = ROOT_ELEMENT__MODEL;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION__NAME = ROOT_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Definition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION__DEFINITION = ROOT_ELEMENT__DEFINITION;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION__ANNOTATIONS = ROOT_ELEMENT__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Prefix</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION__PREFIX = ROOT_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Attributes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION__ATTRIBUTES = ROOT_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Annotation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION_FEATURE_COUNT = ROOT_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.simple.Annotated <em>Annotated</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.simple.Annotated
	 * @see com.regnosys.rosetta.rosetta.simple.impl.SimplePackageImpl#getAnnotated()
	 * @generated
	 */
	int ANNOTATED = 2;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATED__ANNOTATIONS = 0;

	/**
	 * The number of structural features of the '<em>Annotated</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATED_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.simple.impl.AnnotationQualifierImpl <em>Annotation Qualifier</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.simple.impl.AnnotationQualifierImpl
	 * @see com.regnosys.rosetta.rosetta.simple.impl.SimplePackageImpl#getAnnotationQualifier()
	 * @generated
	 */
	int ANNOTATION_QUALIFIER = 3;

	/**
	 * The feature id for the '<em><b>Qual Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION_QUALIFIER__QUAL_NAME = 0;

	/**
	 * The feature id for the '<em><b>Qual Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION_QUALIFIER__QUAL_VALUE = 1;

	/**
	 * The feature id for the '<em><b>Qual Path</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION_QUALIFIER__QUAL_PATH = 2;

	/**
	 * The number of structural features of the '<em>Annotation Qualifier</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION_QUALIFIER_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.simple.impl.AnnotationRefImpl <em>Annotation Ref</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.simple.impl.AnnotationRefImpl
	 * @see com.regnosys.rosetta.rosetta.simple.impl.SimplePackageImpl#getAnnotationRef()
	 * @generated
	 */
	int ANNOTATION_REF = 4;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION_REF__ANNOTATION = 0;

	/**
	 * The feature id for the '<em><b>Attribute</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION_REF__ATTRIBUTE = 1;

	/**
	 * The feature id for the '<em><b>Qualifiers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION_REF__QUALIFIERS = 2;

	/**
	 * The number of structural features of the '<em>Annotation Ref</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION_REF_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.simple.AssignPathRoot <em>Assign Path Root</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.simple.AssignPathRoot
	 * @see com.regnosys.rosetta.rosetta.simple.impl.SimplePackageImpl#getAssignPathRoot()
	 * @generated
	 */
	int ASSIGN_PATH_ROOT = 5;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGN_PATH_ROOT__NAME = RosettaPackage.ROSETTA_SYMBOL__NAME;

	/**
	 * The number of structural features of the '<em>Assign Path Root</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGN_PATH_ROOT_FEATURE_COUNT = RosettaPackage.ROSETTA_SYMBOL_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.simple.impl.AttributeImpl <em>Attribute</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.simple.impl.AttributeImpl
	 * @see com.regnosys.rosetta.rosetta.simple.impl.SimplePackageImpl#getAttribute()
	 * @generated
	 */
	int ATTRIBUTE = 6;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__NAME = RosettaPackage.ROSETTA_TYPED_FEATURE__NAME;

	/**
	 * The feature id for the '<em><b>Get Name Or Default</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__GET_NAME_OR_DEFAULT = RosettaPackage.ROSETTA_TYPED_FEATURE__GET_NAME_OR_DEFAULT;

	/**
	 * The feature id for the '<em><b>Type Call</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__TYPE_CALL = RosettaPackage.ROSETTA_TYPED_FEATURE__TYPE_CALL;

	/**
	 * The feature id for the '<em><b>Is Type Inferred</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__IS_TYPE_INFERRED = RosettaPackage.ROSETTA_TYPED_FEATURE__IS_TYPE_INFERRED;

	/**
	 * The feature id for the '<em><b>Definition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__DEFINITION = RosettaPackage.ROSETTA_TYPED_FEATURE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__ANNOTATIONS = RosettaPackage.ROSETTA_TYPED_FEATURE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>References</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__REFERENCES = RosettaPackage.ROSETTA_TYPED_FEATURE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Override</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__OVERRIDE = RosettaPackage.ROSETTA_TYPED_FEATURE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Card</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__CARD = RosettaPackage.ROSETTA_TYPED_FEATURE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Synonyms</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__SYNONYMS = RosettaPackage.ROSETTA_TYPED_FEATURE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Rule Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__RULE_REFERENCE = RosettaPackage.ROSETTA_TYPED_FEATURE_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the '<em>Attribute</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_FEATURE_COUNT = RosettaPackage.ROSETTA_TYPED_FEATURE_FEATURE_COUNT + 7;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.simple.impl.DataImpl <em>Data</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.simple.impl.DataImpl
	 * @see com.regnosys.rosetta.rosetta.simple.impl.SimplePackageImpl#getData()
	 * @generated
	 */
	int DATA = 7;

	/**
	 * The feature id for the '<em><b>Model</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA__MODEL = RosettaPackage.ROSETTA_TYPE__MODEL;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA__NAME = RosettaPackage.ROSETTA_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Definition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA__DEFINITION = RosettaPackage.ROSETTA_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA__ANNOTATIONS = RosettaPackage.ROSETTA_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>References</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA__REFERENCES = RosettaPackage.ROSETTA_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Super Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA__SUPER_TYPE = RosettaPackage.ROSETTA_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Synonyms</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA__SYNONYMS = RosettaPackage.ROSETTA_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Attributes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA__ATTRIBUTES = RosettaPackage.ROSETTA_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Conditions</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA__CONDITIONS = RosettaPackage.ROSETTA_TYPE_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the '<em>Data</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FEATURE_COUNT = RosettaPackage.ROSETTA_TYPE_FEATURE_COUNT + 7;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.simple.impl.ChoiceImpl <em>Choice</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.simple.impl.ChoiceImpl
	 * @see com.regnosys.rosetta.rosetta.simple.impl.SimplePackageImpl#getChoice()
	 * @generated
	 */
	int CHOICE = 8;

	/**
	 * The feature id for the '<em><b>Model</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE__MODEL = DATA__MODEL;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE__NAME = DATA__NAME;

	/**
	 * The feature id for the '<em><b>Definition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE__DEFINITION = DATA__DEFINITION;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE__ANNOTATIONS = DATA__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>References</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE__REFERENCES = DATA__REFERENCES;

	/**
	 * The feature id for the '<em><b>Super Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE__SUPER_TYPE = DATA__SUPER_TYPE;

	/**
	 * The feature id for the '<em><b>Synonyms</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE__SYNONYMS = DATA__SYNONYMS;

	/**
	 * The feature id for the '<em><b>Attributes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE__ATTRIBUTES = DATA__ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Conditions</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE__CONDITIONS = DATA__CONDITIONS;

	/**
	 * The feature id for the '<em><b>hardcoded Conditions</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE__HARDCODED_CONDITIONS = DATA_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Choice</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE_FEATURE_COUNT = DATA_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.simple.impl.ChoiceOptionImpl <em>Choice Option</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.simple.impl.ChoiceOptionImpl
	 * @see com.regnosys.rosetta.rosetta.simple.impl.SimplePackageImpl#getChoiceOption()
	 * @generated
	 */
	int CHOICE_OPTION = 9;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE_OPTION__NAME = ATTRIBUTE__NAME;

	/**
	 * The feature id for the '<em><b>Get Name Or Default</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE_OPTION__GET_NAME_OR_DEFAULT = ATTRIBUTE__GET_NAME_OR_DEFAULT;

	/**
	 * The feature id for the '<em><b>Type Call</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE_OPTION__TYPE_CALL = ATTRIBUTE__TYPE_CALL;

	/**
	 * The feature id for the '<em><b>Is Type Inferred</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE_OPTION__IS_TYPE_INFERRED = ATTRIBUTE__IS_TYPE_INFERRED;

	/**
	 * The feature id for the '<em><b>Definition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE_OPTION__DEFINITION = ATTRIBUTE__DEFINITION;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE_OPTION__ANNOTATIONS = ATTRIBUTE__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>References</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE_OPTION__REFERENCES = ATTRIBUTE__REFERENCES;

	/**
	 * The feature id for the '<em><b>Override</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE_OPTION__OVERRIDE = ATTRIBUTE__OVERRIDE;

	/**
	 * The feature id for the '<em><b>Card</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE_OPTION__CARD = ATTRIBUTE__CARD;

	/**
	 * The feature id for the '<em><b>Synonyms</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE_OPTION__SYNONYMS = ATTRIBUTE__SYNONYMS;

	/**
	 * The feature id for the '<em><b>Rule Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE_OPTION__RULE_REFERENCE = ATTRIBUTE__RULE_REFERENCE;

	/**
	 * The feature id for the '<em><b>hardcoded Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE_OPTION__HARDCODED_NAME = ATTRIBUTE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>hardcoded Cardinality</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE_OPTION__HARDCODED_CARDINALITY = ATTRIBUTE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Choice Option</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE_OPTION_FEATURE_COUNT = ATTRIBUTE_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.simple.impl.FunctionImpl <em>Function</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.simple.impl.FunctionImpl
	 * @see com.regnosys.rosetta.rosetta.simple.impl.SimplePackageImpl#getFunction()
	 * @generated
	 */
	int FUNCTION = 10;

	/**
	 * The feature id for the '<em><b>Model</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__MODEL = ROOT_ELEMENT__MODEL;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__NAME = ROOT_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Definition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__DEFINITION = ROOT_ELEMENT__DEFINITION;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__ANNOTATIONS = ROOT_ELEMENT__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>References</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__REFERENCES = ROOT_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Inputs</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__INPUTS = ROOT_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Output</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__OUTPUT = ROOT_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Shortcuts</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__SHORTCUTS = ROOT_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Conditions</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__CONDITIONS = ROOT_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Operations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__OPERATIONS = ROOT_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Post Conditions</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__POST_CONDITIONS = ROOT_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the '<em>Function</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_FEATURE_COUNT = ROOT_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.simple.impl.FunctionDispatchImpl <em>Function Dispatch</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.simple.impl.FunctionDispatchImpl
	 * @see com.regnosys.rosetta.rosetta.simple.impl.SimplePackageImpl#getFunctionDispatch()
	 * @generated
	 */
	int FUNCTION_DISPATCH = 11;

	/**
	 * The feature id for the '<em><b>Model</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_DISPATCH__MODEL = FUNCTION__MODEL;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_DISPATCH__NAME = FUNCTION__NAME;

	/**
	 * The feature id for the '<em><b>Definition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_DISPATCH__DEFINITION = FUNCTION__DEFINITION;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_DISPATCH__ANNOTATIONS = FUNCTION__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>References</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_DISPATCH__REFERENCES = FUNCTION__REFERENCES;

	/**
	 * The feature id for the '<em><b>Inputs</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_DISPATCH__INPUTS = FUNCTION__INPUTS;

	/**
	 * The feature id for the '<em><b>Output</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_DISPATCH__OUTPUT = FUNCTION__OUTPUT;

	/**
	 * The feature id for the '<em><b>Shortcuts</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_DISPATCH__SHORTCUTS = FUNCTION__SHORTCUTS;

	/**
	 * The feature id for the '<em><b>Conditions</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_DISPATCH__CONDITIONS = FUNCTION__CONDITIONS;

	/**
	 * The feature id for the '<em><b>Operations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_DISPATCH__OPERATIONS = FUNCTION__OPERATIONS;

	/**
	 * The feature id for the '<em><b>Post Conditions</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_DISPATCH__POST_CONDITIONS = FUNCTION__POST_CONDITIONS;

	/**
	 * The feature id for the '<em><b>Attribute</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_DISPATCH__ATTRIBUTE = FUNCTION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_DISPATCH__VALUE = FUNCTION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Function Dispatch</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_DISPATCH_FEATURE_COUNT = FUNCTION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.simple.impl.ConditionImpl <em>Condition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.simple.impl.ConditionImpl
	 * @see com.regnosys.rosetta.rosetta.simple.impl.SimplePackageImpl#getCondition()
	 * @generated
	 */
	int CONDITION = 12;

	/**
	 * The feature id for the '<em><b>Definition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITION__DEFINITION = RosettaPackage.ROSETTA_DEFINABLE__DEFINITION;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITION__ANNOTATIONS = RosettaPackage.ROSETTA_DEFINABLE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITION__NAME = RosettaPackage.ROSETTA_DEFINABLE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>References</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITION__REFERENCES = RosettaPackage.ROSETTA_DEFINABLE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Post Condition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITION__POST_CONDITION = RosettaPackage.ROSETTA_DEFINABLE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITION__EXPRESSION = RosettaPackage.ROSETTA_DEFINABLE_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Condition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITION_FEATURE_COUNT = RosettaPackage.ROSETTA_DEFINABLE_FEATURE_COUNT + 5;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.simple.impl.OperationImpl <em>Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.simple.impl.OperationImpl
	 * @see com.regnosys.rosetta.rosetta.simple.impl.SimplePackageImpl#getOperation()
	 * @generated
	 */
	int OPERATION = 13;

	/**
	 * The feature id for the '<em><b>Definition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION__DEFINITION = RosettaPackage.ROSETTA_DEFINABLE__DEFINITION;

	/**
	 * The feature id for the '<em><b>Function</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION__FUNCTION = RosettaPackage.ROSETTA_DEFINABLE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Assign Root</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION__ASSIGN_ROOT = RosettaPackage.ROSETTA_DEFINABLE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Path</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION__PATH = RosettaPackage.ROSETTA_DEFINABLE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION__EXPRESSION = RosettaPackage.ROSETTA_DEFINABLE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Add</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION__ADD = RosettaPackage.ROSETTA_DEFINABLE_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_FEATURE_COUNT = RosettaPackage.ROSETTA_DEFINABLE_FEATURE_COUNT + 5;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.simple.impl.SegmentImpl <em>Segment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.simple.impl.SegmentImpl
	 * @see com.regnosys.rosetta.rosetta.simple.impl.SimplePackageImpl#getSegment()
	 * @generated
	 */
	int SEGMENT = 14;

	/**
	 * The feature id for the '<em><b>Attribute</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEGMENT__ATTRIBUTE = 0;

	/**
	 * The feature id for the '<em><b>Next</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEGMENT__NEXT = 1;

	/**
	 * The feature id for the '<em><b>Prev</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEGMENT__PREV = 2;

	/**
	 * The number of structural features of the '<em>Segment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEGMENT_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.simple.impl.ShortcutDeclarationImpl <em>Shortcut Declaration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.simple.impl.ShortcutDeclarationImpl
	 * @see com.regnosys.rosetta.rosetta.simple.impl.SimplePackageImpl#getShortcutDeclaration()
	 * @generated
	 */
	int SHORTCUT_DECLARATION = 15;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHORTCUT_DECLARATION__NAME = RosettaPackage.ROSETTA_NAMED__NAME;

	/**
	 * The feature id for the '<em><b>Definition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHORTCUT_DECLARATION__DEFINITION = RosettaPackage.ROSETTA_NAMED_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHORTCUT_DECLARATION__EXPRESSION = RosettaPackage.ROSETTA_NAMED_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Shortcut Declaration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHORTCUT_DECLARATION_FEATURE_COUNT = RosettaPackage.ROSETTA_NAMED_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.simple.impl.ReferencesImpl <em>References</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.simple.impl.ReferencesImpl
	 * @see com.regnosys.rosetta.rosetta.simple.impl.SimplePackageImpl#getReferences()
	 * @generated
	 */
	int REFERENCES = 16;

	/**
	 * The feature id for the '<em><b>References</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCES__REFERENCES = 0;

	/**
	 * The number of structural features of the '<em>References</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCES_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.simple.impl.RosettaRuleReferenceImpl <em>Rosetta Rule Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.simple.impl.RosettaRuleReferenceImpl
	 * @see com.regnosys.rosetta.rosetta.simple.impl.SimplePackageImpl#getRosettaRuleReference()
	 * @generated
	 */
	int ROSETTA_RULE_REFERENCE = 17;

	/**
	 * The feature id for the '<em><b>Reporting Rule</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_RULE_REFERENCE__REPORTING_RULE = 0;

	/**
	 * The number of structural features of the '<em>Rosetta Rule Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_RULE_REFERENCE_FEATURE_COUNT = 1;


	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.simple.RootElement <em>Root Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Root Element</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.RootElement
	 * @generated
	 */
	EClass getRootElement();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.simple.Annotation <em>Annotation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Annotation</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.Annotation
	 * @generated
	 */
	EClass getAnnotation();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.simple.Annotation#getPrefix <em>Prefix</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Prefix</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.Annotation#getPrefix()
	 * @see #getAnnotation()
	 * @generated
	 */
	EAttribute getAnnotation_Prefix();

	/**
	 * Returns the meta object for the containment reference list '{@link com.regnosys.rosetta.rosetta.simple.Annotation#getAttributes <em>Attributes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Attributes</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.Annotation#getAttributes()
	 * @see #getAnnotation()
	 * @generated
	 */
	EReference getAnnotation_Attributes();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.simple.Annotated <em>Annotated</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Annotated</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.Annotated
	 * @generated
	 */
	EClass getAnnotated();

	/**
	 * Returns the meta object for the containment reference list '{@link com.regnosys.rosetta.rosetta.simple.Annotated#getAnnotations <em>Annotations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Annotations</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.Annotated#getAnnotations()
	 * @see #getAnnotated()
	 * @generated
	 */
	EReference getAnnotated_Annotations();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.simple.AnnotationQualifier <em>Annotation Qualifier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Annotation Qualifier</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.AnnotationQualifier
	 * @generated
	 */
	EClass getAnnotationQualifier();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.simple.AnnotationQualifier#getQualName <em>Qual Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Qual Name</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.AnnotationQualifier#getQualName()
	 * @see #getAnnotationQualifier()
	 * @generated
	 */
	EAttribute getAnnotationQualifier_QualName();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.simple.AnnotationQualifier#getQualValue <em>Qual Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Qual Value</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.AnnotationQualifier#getQualValue()
	 * @see #getAnnotationQualifier()
	 * @generated
	 */
	EAttribute getAnnotationQualifier_QualValue();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.simple.AnnotationQualifier#getQualPath <em>Qual Path</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Qual Path</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.AnnotationQualifier#getQualPath()
	 * @see #getAnnotationQualifier()
	 * @generated
	 */
	EReference getAnnotationQualifier_QualPath();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.simple.AnnotationRef <em>Annotation Ref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Annotation Ref</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.AnnotationRef
	 * @generated
	 */
	EClass getAnnotationRef();

	/**
	 * Returns the meta object for the reference '{@link com.regnosys.rosetta.rosetta.simple.AnnotationRef#getAnnotation <em>Annotation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Annotation</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.AnnotationRef#getAnnotation()
	 * @see #getAnnotationRef()
	 * @generated
	 */
	EReference getAnnotationRef_Annotation();

	/**
	 * Returns the meta object for the reference '{@link com.regnosys.rosetta.rosetta.simple.AnnotationRef#getAttribute <em>Attribute</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Attribute</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.AnnotationRef#getAttribute()
	 * @see #getAnnotationRef()
	 * @generated
	 */
	EReference getAnnotationRef_Attribute();

	/**
	 * Returns the meta object for the containment reference list '{@link com.regnosys.rosetta.rosetta.simple.AnnotationRef#getQualifiers <em>Qualifiers</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Qualifiers</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.AnnotationRef#getQualifiers()
	 * @see #getAnnotationRef()
	 * @generated
	 */
	EReference getAnnotationRef_Qualifiers();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.simple.AssignPathRoot <em>Assign Path Root</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Assign Path Root</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.AssignPathRoot
	 * @generated
	 */
	EClass getAssignPathRoot();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.simple.Attribute <em>Attribute</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Attribute</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.Attribute
	 * @generated
	 */
	EClass getAttribute();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.simple.Attribute#isOverride <em>Override</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Override</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.Attribute#isOverride()
	 * @see #getAttribute()
	 * @generated
	 */
	EAttribute getAttribute_Override();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.simple.Attribute#getCard <em>Card</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Card</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.Attribute#getCard()
	 * @see #getAttribute()
	 * @generated
	 */
	EReference getAttribute_Card();

	/**
	 * Returns the meta object for the containment reference list '{@link com.regnosys.rosetta.rosetta.simple.Attribute#getSynonyms <em>Synonyms</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Synonyms</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.Attribute#getSynonyms()
	 * @see #getAttribute()
	 * @generated
	 */
	EReference getAttribute_Synonyms();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.simple.Attribute#getRuleReference <em>Rule Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Rule Reference</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.Attribute#getRuleReference()
	 * @see #getAttribute()
	 * @generated
	 */
	EReference getAttribute_RuleReference();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.simple.Data <em>Data</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Data</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.Data
	 * @generated
	 */
	EClass getData();

	/**
	 * Returns the meta object for the reference '{@link com.regnosys.rosetta.rosetta.simple.Data#getSuperType <em>Super Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Super Type</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.Data#getSuperType()
	 * @see #getData()
	 * @generated
	 */
	EReference getData_SuperType();

	/**
	 * Returns the meta object for the containment reference list '{@link com.regnosys.rosetta.rosetta.simple.Data#getSynonyms <em>Synonyms</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Synonyms</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.Data#getSynonyms()
	 * @see #getData()
	 * @generated
	 */
	EReference getData_Synonyms();

	/**
	 * Returns the meta object for the containment reference list '{@link com.regnosys.rosetta.rosetta.simple.Data#getAttributes <em>Attributes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Attributes</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.Data#getAttributes()
	 * @see #getData()
	 * @generated
	 */
	EReference getData_Attributes();

	/**
	 * Returns the meta object for the containment reference list '{@link com.regnosys.rosetta.rosetta.simple.Data#getConditions <em>Conditions</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Conditions</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.Data#getConditions()
	 * @see #getData()
	 * @generated
	 */
	EReference getData_Conditions();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.simple.Choice <em>Choice</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Choice</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.Choice
	 * @generated
	 */
	EClass getChoice();

	/**
	 * Returns the meta object for the containment reference list '{@link com.regnosys.rosetta.rosetta.simple.Choice#get_hardcodedConditions <em>hardcoded Conditions</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>hardcoded Conditions</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.Choice#get_hardcodedConditions()
	 * @see #getChoice()
	 * @generated
	 */
	EReference getChoice__hardcodedConditions();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.simple.ChoiceOption <em>Choice Option</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Choice Option</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.ChoiceOption
	 * @generated
	 */
	EClass getChoiceOption();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.simple.ChoiceOption#get_hardcodedName <em>hardcoded Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>hardcoded Name</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.ChoiceOption#get_hardcodedName()
	 * @see #getChoiceOption()
	 * @generated
	 */
	EAttribute getChoiceOption__hardcodedName();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.simple.ChoiceOption#get_hardcodedCardinality <em>hardcoded Cardinality</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>hardcoded Cardinality</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.ChoiceOption#get_hardcodedCardinality()
	 * @see #getChoiceOption()
	 * @generated
	 */
	EReference getChoiceOption__hardcodedCardinality();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.simple.Function <em>Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Function</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.Function
	 * @generated
	 */
	EClass getFunction();

	/**
	 * Returns the meta object for the containment reference list '{@link com.regnosys.rosetta.rosetta.simple.Function#getInputs <em>Inputs</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Inputs</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.Function#getInputs()
	 * @see #getFunction()
	 * @generated
	 */
	EReference getFunction_Inputs();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.simple.Function#getOutput <em>Output</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Output</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.Function#getOutput()
	 * @see #getFunction()
	 * @generated
	 */
	EReference getFunction_Output();

	/**
	 * Returns the meta object for the containment reference list '{@link com.regnosys.rosetta.rosetta.simple.Function#getShortcuts <em>Shortcuts</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Shortcuts</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.Function#getShortcuts()
	 * @see #getFunction()
	 * @generated
	 */
	EReference getFunction_Shortcuts();

	/**
	 * Returns the meta object for the containment reference list '{@link com.regnosys.rosetta.rosetta.simple.Function#getConditions <em>Conditions</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Conditions</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.Function#getConditions()
	 * @see #getFunction()
	 * @generated
	 */
	EReference getFunction_Conditions();

	/**
	 * Returns the meta object for the containment reference list '{@link com.regnosys.rosetta.rosetta.simple.Function#getOperations <em>Operations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Operations</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.Function#getOperations()
	 * @see #getFunction()
	 * @generated
	 */
	EReference getFunction_Operations();

	/**
	 * Returns the meta object for the containment reference list '{@link com.regnosys.rosetta.rosetta.simple.Function#getPostConditions <em>Post Conditions</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Post Conditions</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.Function#getPostConditions()
	 * @see #getFunction()
	 * @generated
	 */
	EReference getFunction_PostConditions();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.simple.FunctionDispatch <em>Function Dispatch</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Function Dispatch</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.FunctionDispatch
	 * @generated
	 */
	EClass getFunctionDispatch();

	/**
	 * Returns the meta object for the reference '{@link com.regnosys.rosetta.rosetta.simple.FunctionDispatch#getAttribute <em>Attribute</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Attribute</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.FunctionDispatch#getAttribute()
	 * @see #getFunctionDispatch()
	 * @generated
	 */
	EReference getFunctionDispatch_Attribute();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.simple.FunctionDispatch#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Value</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.FunctionDispatch#getValue()
	 * @see #getFunctionDispatch()
	 * @generated
	 */
	EReference getFunctionDispatch_Value();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.simple.Condition <em>Condition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Condition</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.Condition
	 * @generated
	 */
	EClass getCondition();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.simple.Condition#isPostCondition <em>Post Condition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Post Condition</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.Condition#isPostCondition()
	 * @see #getCondition()
	 * @generated
	 */
	EAttribute getCondition_PostCondition();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.simple.Condition#getExpression <em>Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expression</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.Condition#getExpression()
	 * @see #getCondition()
	 * @generated
	 */
	EReference getCondition_Expression();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.simple.Operation <em>Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Operation</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.Operation
	 * @generated
	 */
	EClass getOperation();

	/**
	 * Returns the meta object for the container reference '{@link com.regnosys.rosetta.rosetta.simple.Operation#getFunction <em>Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Function</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.Operation#getFunction()
	 * @see #getOperation()
	 * @generated
	 */
	EReference getOperation_Function();

	/**
	 * Returns the meta object for the reference '{@link com.regnosys.rosetta.rosetta.simple.Operation#getAssignRoot <em>Assign Root</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Assign Root</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.Operation#getAssignRoot()
	 * @see #getOperation()
	 * @generated
	 */
	EReference getOperation_AssignRoot();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.simple.Operation#getPath <em>Path</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Path</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.Operation#getPath()
	 * @see #getOperation()
	 * @generated
	 */
	EReference getOperation_Path();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.simple.Operation#getExpression <em>Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expression</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.Operation#getExpression()
	 * @see #getOperation()
	 * @generated
	 */
	EReference getOperation_Expression();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.simple.Operation#isAdd <em>Add</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Add</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.Operation#isAdd()
	 * @see #getOperation()
	 * @generated
	 */
	EAttribute getOperation_Add();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.simple.Segment <em>Segment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Segment</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.Segment
	 * @generated
	 */
	EClass getSegment();

	/**
	 * Returns the meta object for the reference '{@link com.regnosys.rosetta.rosetta.simple.Segment#getAttribute <em>Attribute</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Attribute</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.Segment#getAttribute()
	 * @see #getSegment()
	 * @generated
	 */
	EReference getSegment_Attribute();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.simple.Segment#getNext <em>Next</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Next</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.Segment#getNext()
	 * @see #getSegment()
	 * @generated
	 */
	EReference getSegment_Next();

	/**
	 * Returns the meta object for the container reference '{@link com.regnosys.rosetta.rosetta.simple.Segment#getPrev <em>Prev</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Prev</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.Segment#getPrev()
	 * @see #getSegment()
	 * @generated
	 */
	EReference getSegment_Prev();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.simple.ShortcutDeclaration <em>Shortcut Declaration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Shortcut Declaration</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.ShortcutDeclaration
	 * @generated
	 */
	EClass getShortcutDeclaration();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.simple.ShortcutDeclaration#getExpression <em>Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expression</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.ShortcutDeclaration#getExpression()
	 * @see #getShortcutDeclaration()
	 * @generated
	 */
	EReference getShortcutDeclaration_Expression();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.simple.References <em>References</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>References</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.References
	 * @generated
	 */
	EClass getReferences();

	/**
	 * Returns the meta object for the containment reference list '{@link com.regnosys.rosetta.rosetta.simple.References#getReferences <em>References</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>References</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.References#getReferences()
	 * @see #getReferences()
	 * @generated
	 */
	EReference getReferences_References();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.simple.RosettaRuleReference <em>Rosetta Rule Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Rosetta Rule Reference</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.RosettaRuleReference
	 * @generated
	 */
	EClass getRosettaRuleReference();

	/**
	 * Returns the meta object for the reference '{@link com.regnosys.rosetta.rosetta.simple.RosettaRuleReference#getReportingRule <em>Reporting Rule</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Reporting Rule</em>'.
	 * @see com.regnosys.rosetta.rosetta.simple.RosettaRuleReference#getReportingRule()
	 * @see #getRosettaRuleReference()
	 * @generated
	 */
	EReference getRosettaRuleReference_ReportingRule();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	SimpleFactory getSimpleFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.simple.impl.RootElementImpl <em>Root Element</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.simple.impl.RootElementImpl
		 * @see com.regnosys.rosetta.rosetta.simple.impl.SimplePackageImpl#getRootElement()
		 * @generated
		 */
		EClass ROOT_ELEMENT = eINSTANCE.getRootElement();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.simple.impl.AnnotationImpl <em>Annotation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.simple.impl.AnnotationImpl
		 * @see com.regnosys.rosetta.rosetta.simple.impl.SimplePackageImpl#getAnnotation()
		 * @generated
		 */
		EClass ANNOTATION = eINSTANCE.getAnnotation();

		/**
		 * The meta object literal for the '<em><b>Prefix</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ANNOTATION__PREFIX = eINSTANCE.getAnnotation_Prefix();

		/**
		 * The meta object literal for the '<em><b>Attributes</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ANNOTATION__ATTRIBUTES = eINSTANCE.getAnnotation_Attributes();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.simple.Annotated <em>Annotated</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.simple.Annotated
		 * @see com.regnosys.rosetta.rosetta.simple.impl.SimplePackageImpl#getAnnotated()
		 * @generated
		 */
		EClass ANNOTATED = eINSTANCE.getAnnotated();

		/**
		 * The meta object literal for the '<em><b>Annotations</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ANNOTATED__ANNOTATIONS = eINSTANCE.getAnnotated_Annotations();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.simple.impl.AnnotationQualifierImpl <em>Annotation Qualifier</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.simple.impl.AnnotationQualifierImpl
		 * @see com.regnosys.rosetta.rosetta.simple.impl.SimplePackageImpl#getAnnotationQualifier()
		 * @generated
		 */
		EClass ANNOTATION_QUALIFIER = eINSTANCE.getAnnotationQualifier();

		/**
		 * The meta object literal for the '<em><b>Qual Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ANNOTATION_QUALIFIER__QUAL_NAME = eINSTANCE.getAnnotationQualifier_QualName();

		/**
		 * The meta object literal for the '<em><b>Qual Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ANNOTATION_QUALIFIER__QUAL_VALUE = eINSTANCE.getAnnotationQualifier_QualValue();

		/**
		 * The meta object literal for the '<em><b>Qual Path</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ANNOTATION_QUALIFIER__QUAL_PATH = eINSTANCE.getAnnotationQualifier_QualPath();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.simple.impl.AnnotationRefImpl <em>Annotation Ref</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.simple.impl.AnnotationRefImpl
		 * @see com.regnosys.rosetta.rosetta.simple.impl.SimplePackageImpl#getAnnotationRef()
		 * @generated
		 */
		EClass ANNOTATION_REF = eINSTANCE.getAnnotationRef();

		/**
		 * The meta object literal for the '<em><b>Annotation</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ANNOTATION_REF__ANNOTATION = eINSTANCE.getAnnotationRef_Annotation();

		/**
		 * The meta object literal for the '<em><b>Attribute</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ANNOTATION_REF__ATTRIBUTE = eINSTANCE.getAnnotationRef_Attribute();

		/**
		 * The meta object literal for the '<em><b>Qualifiers</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ANNOTATION_REF__QUALIFIERS = eINSTANCE.getAnnotationRef_Qualifiers();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.simple.AssignPathRoot <em>Assign Path Root</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.simple.AssignPathRoot
		 * @see com.regnosys.rosetta.rosetta.simple.impl.SimplePackageImpl#getAssignPathRoot()
		 * @generated
		 */
		EClass ASSIGN_PATH_ROOT = eINSTANCE.getAssignPathRoot();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.simple.impl.AttributeImpl <em>Attribute</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.simple.impl.AttributeImpl
		 * @see com.regnosys.rosetta.rosetta.simple.impl.SimplePackageImpl#getAttribute()
		 * @generated
		 */
		EClass ATTRIBUTE = eINSTANCE.getAttribute();

		/**
		 * The meta object literal for the '<em><b>Override</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ATTRIBUTE__OVERRIDE = eINSTANCE.getAttribute_Override();

		/**
		 * The meta object literal for the '<em><b>Card</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ATTRIBUTE__CARD = eINSTANCE.getAttribute_Card();

		/**
		 * The meta object literal for the '<em><b>Synonyms</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ATTRIBUTE__SYNONYMS = eINSTANCE.getAttribute_Synonyms();

		/**
		 * The meta object literal for the '<em><b>Rule Reference</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ATTRIBUTE__RULE_REFERENCE = eINSTANCE.getAttribute_RuleReference();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.simple.impl.DataImpl <em>Data</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.simple.impl.DataImpl
		 * @see com.regnosys.rosetta.rosetta.simple.impl.SimplePackageImpl#getData()
		 * @generated
		 */
		EClass DATA = eINSTANCE.getData();

		/**
		 * The meta object literal for the '<em><b>Super Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DATA__SUPER_TYPE = eINSTANCE.getData_SuperType();

		/**
		 * The meta object literal for the '<em><b>Synonyms</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DATA__SYNONYMS = eINSTANCE.getData_Synonyms();

		/**
		 * The meta object literal for the '<em><b>Attributes</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DATA__ATTRIBUTES = eINSTANCE.getData_Attributes();

		/**
		 * The meta object literal for the '<em><b>Conditions</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DATA__CONDITIONS = eINSTANCE.getData_Conditions();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.simple.impl.ChoiceImpl <em>Choice</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.simple.impl.ChoiceImpl
		 * @see com.regnosys.rosetta.rosetta.simple.impl.SimplePackageImpl#getChoice()
		 * @generated
		 */
		EClass CHOICE = eINSTANCE.getChoice();

		/**
		 * The meta object literal for the '<em><b>hardcoded Conditions</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CHOICE__HARDCODED_CONDITIONS = eINSTANCE.getChoice__hardcodedConditions();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.simple.impl.ChoiceOptionImpl <em>Choice Option</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.simple.impl.ChoiceOptionImpl
		 * @see com.regnosys.rosetta.rosetta.simple.impl.SimplePackageImpl#getChoiceOption()
		 * @generated
		 */
		EClass CHOICE_OPTION = eINSTANCE.getChoiceOption();

		/**
		 * The meta object literal for the '<em><b>hardcoded Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CHOICE_OPTION__HARDCODED_NAME = eINSTANCE.getChoiceOption__hardcodedName();

		/**
		 * The meta object literal for the '<em><b>hardcoded Cardinality</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CHOICE_OPTION__HARDCODED_CARDINALITY = eINSTANCE.getChoiceOption__hardcodedCardinality();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.simple.impl.FunctionImpl <em>Function</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.simple.impl.FunctionImpl
		 * @see com.regnosys.rosetta.rosetta.simple.impl.SimplePackageImpl#getFunction()
		 * @generated
		 */
		EClass FUNCTION = eINSTANCE.getFunction();

		/**
		 * The meta object literal for the '<em><b>Inputs</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FUNCTION__INPUTS = eINSTANCE.getFunction_Inputs();

		/**
		 * The meta object literal for the '<em><b>Output</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FUNCTION__OUTPUT = eINSTANCE.getFunction_Output();

		/**
		 * The meta object literal for the '<em><b>Shortcuts</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FUNCTION__SHORTCUTS = eINSTANCE.getFunction_Shortcuts();

		/**
		 * The meta object literal for the '<em><b>Conditions</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FUNCTION__CONDITIONS = eINSTANCE.getFunction_Conditions();

		/**
		 * The meta object literal for the '<em><b>Operations</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FUNCTION__OPERATIONS = eINSTANCE.getFunction_Operations();

		/**
		 * The meta object literal for the '<em><b>Post Conditions</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FUNCTION__POST_CONDITIONS = eINSTANCE.getFunction_PostConditions();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.simple.impl.FunctionDispatchImpl <em>Function Dispatch</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.simple.impl.FunctionDispatchImpl
		 * @see com.regnosys.rosetta.rosetta.simple.impl.SimplePackageImpl#getFunctionDispatch()
		 * @generated
		 */
		EClass FUNCTION_DISPATCH = eINSTANCE.getFunctionDispatch();

		/**
		 * The meta object literal for the '<em><b>Attribute</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FUNCTION_DISPATCH__ATTRIBUTE = eINSTANCE.getFunctionDispatch_Attribute();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FUNCTION_DISPATCH__VALUE = eINSTANCE.getFunctionDispatch_Value();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.simple.impl.ConditionImpl <em>Condition</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.simple.impl.ConditionImpl
		 * @see com.regnosys.rosetta.rosetta.simple.impl.SimplePackageImpl#getCondition()
		 * @generated
		 */
		EClass CONDITION = eINSTANCE.getCondition();

		/**
		 * The meta object literal for the '<em><b>Post Condition</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CONDITION__POST_CONDITION = eINSTANCE.getCondition_PostCondition();

		/**
		 * The meta object literal for the '<em><b>Expression</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CONDITION__EXPRESSION = eINSTANCE.getCondition_Expression();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.simple.impl.OperationImpl <em>Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.simple.impl.OperationImpl
		 * @see com.regnosys.rosetta.rosetta.simple.impl.SimplePackageImpl#getOperation()
		 * @generated
		 */
		EClass OPERATION = eINSTANCE.getOperation();

		/**
		 * The meta object literal for the '<em><b>Function</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference OPERATION__FUNCTION = eINSTANCE.getOperation_Function();

		/**
		 * The meta object literal for the '<em><b>Assign Root</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference OPERATION__ASSIGN_ROOT = eINSTANCE.getOperation_AssignRoot();

		/**
		 * The meta object literal for the '<em><b>Path</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference OPERATION__PATH = eINSTANCE.getOperation_Path();

		/**
		 * The meta object literal for the '<em><b>Expression</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference OPERATION__EXPRESSION = eINSTANCE.getOperation_Expression();

		/**
		 * The meta object literal for the '<em><b>Add</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute OPERATION__ADD = eINSTANCE.getOperation_Add();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.simple.impl.SegmentImpl <em>Segment</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.simple.impl.SegmentImpl
		 * @see com.regnosys.rosetta.rosetta.simple.impl.SimplePackageImpl#getSegment()
		 * @generated
		 */
		EClass SEGMENT = eINSTANCE.getSegment();

		/**
		 * The meta object literal for the '<em><b>Attribute</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SEGMENT__ATTRIBUTE = eINSTANCE.getSegment_Attribute();

		/**
		 * The meta object literal for the '<em><b>Next</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SEGMENT__NEXT = eINSTANCE.getSegment_Next();

		/**
		 * The meta object literal for the '<em><b>Prev</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SEGMENT__PREV = eINSTANCE.getSegment_Prev();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.simple.impl.ShortcutDeclarationImpl <em>Shortcut Declaration</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.simple.impl.ShortcutDeclarationImpl
		 * @see com.regnosys.rosetta.rosetta.simple.impl.SimplePackageImpl#getShortcutDeclaration()
		 * @generated
		 */
		EClass SHORTCUT_DECLARATION = eINSTANCE.getShortcutDeclaration();

		/**
		 * The meta object literal for the '<em><b>Expression</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SHORTCUT_DECLARATION__EXPRESSION = eINSTANCE.getShortcutDeclaration_Expression();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.simple.impl.ReferencesImpl <em>References</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.simple.impl.ReferencesImpl
		 * @see com.regnosys.rosetta.rosetta.simple.impl.SimplePackageImpl#getReferences()
		 * @generated
		 */
		EClass REFERENCES = eINSTANCE.getReferences();

		/**
		 * The meta object literal for the '<em><b>References</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference REFERENCES__REFERENCES = eINSTANCE.getReferences_References();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.simple.impl.RosettaRuleReferenceImpl <em>Rosetta Rule Reference</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.simple.impl.RosettaRuleReferenceImpl
		 * @see com.regnosys.rosetta.rosetta.simple.impl.SimplePackageImpl#getRosettaRuleReference()
		 * @generated
		 */
		EClass ROSETTA_RULE_REFERENCE = eINSTANCE.getRosettaRuleReference();

		/**
		 * The meta object literal for the '<em><b>Reporting Rule</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_RULE_REFERENCE__REPORTING_RULE = eINSTANCE.getRosettaRuleReference_ReportingRule();

	}

} //SimplePackage
