/**
 * Copyright (c) REGnosys 2017 (www.regnosys.com)
 */
package com.regnosys.rosetta.rosetta.simple.impl;

import com.regnosys.rosetta.rosetta.RosettaCardinality;
import com.regnosys.rosetta.rosetta.RosettaDefinable;
import com.regnosys.rosetta.rosetta.RosettaDocReference;
import com.regnosys.rosetta.rosetta.RosettaPackage;
import com.regnosys.rosetta.rosetta.RosettaSymbol;
import com.regnosys.rosetta.rosetta.RosettaSynonym;

import com.regnosys.rosetta.rosetta.impl.RosettaTypedFeatureImpl;

import com.regnosys.rosetta.rosetta.simple.Annotated;
import com.regnosys.rosetta.rosetta.simple.AnnotationRef;
import com.regnosys.rosetta.rosetta.simple.AssignPathRoot;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.References;
import com.regnosys.rosetta.rosetta.simple.RosettaRuleReference;
import com.regnosys.rosetta.rosetta.simple.SimplePackage;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Attribute</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link com.regnosys.rosetta.rosetta.simple.impl.AttributeImpl#getDefinition <em>Definition</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.simple.impl.AttributeImpl#getAnnotations <em>Annotations</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.simple.impl.AttributeImpl#getReferences <em>References</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.simple.impl.AttributeImpl#isOverride <em>Override</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.simple.impl.AttributeImpl#getCard <em>Card</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.simple.impl.AttributeImpl#getSynonyms <em>Synonyms</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.simple.impl.AttributeImpl#getRuleReference <em>Rule Reference</em>}</li>
 * </ul>
 *
 * @generated
 */
public class AttributeImpl extends RosettaTypedFeatureImpl implements Attribute {
	/**
	 * The default value of the '{@link #getDefinition() <em>Definition</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDefinition()
	 * @generated
	 * @ordered
	 */
	protected static final String DEFINITION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDefinition() <em>Definition</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDefinition()
	 * @generated
	 * @ordered
	 */
	protected String definition = DEFINITION_EDEFAULT;

	/**
	 * The cached value of the '{@link #getAnnotations() <em>Annotations</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAnnotations()
	 * @generated
	 * @ordered
	 */
	protected EList<AnnotationRef> annotations;

	/**
	 * The cached value of the '{@link #getReferences() <em>References</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReferences()
	 * @generated
	 * @ordered
	 */
	protected EList<RosettaDocReference> references;

	/**
	 * The default value of the '{@link #isOverride() <em>Override</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isOverride()
	 * @generated
	 * @ordered
	 */
	protected static final boolean OVERRIDE_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isOverride() <em>Override</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isOverride()
	 * @generated
	 * @ordered
	 */
	protected boolean override = OVERRIDE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getCard() <em>Card</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCard()
	 * @generated
	 * @ordered
	 */
	protected RosettaCardinality card;

	/**
	 * The cached value of the '{@link #getSynonyms() <em>Synonyms</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSynonyms()
	 * @generated
	 * @ordered
	 */
	protected EList<RosettaSynonym> synonyms;

	/**
	 * The cached value of the '{@link #getRuleReference() <em>Rule Reference</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRuleReference()
	 * @generated
	 * @ordered
	 */
	protected RosettaRuleReference ruleReference;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AttributeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SimplePackage.Literals.ATTRIBUTE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getDefinition() {
		return definition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDefinition(String newDefinition) {
		String oldDefinition = definition;
		definition = newDefinition;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SimplePackage.ATTRIBUTE__DEFINITION, oldDefinition, definition));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<AnnotationRef> getAnnotations() {
		if (annotations == null) {
			annotations = new EObjectContainmentEList<AnnotationRef>(AnnotationRef.class, this, SimplePackage.ATTRIBUTE__ANNOTATIONS);
		}
		return annotations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<RosettaDocReference> getReferences() {
		if (references == null) {
			references = new EObjectContainmentEList<RosettaDocReference>(RosettaDocReference.class, this, SimplePackage.ATTRIBUTE__REFERENCES);
		}
		return references;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isOverride() {
		return override;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setOverride(boolean newOverride) {
		boolean oldOverride = override;
		override = newOverride;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SimplePackage.ATTRIBUTE__OVERRIDE, oldOverride, override));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaCardinality getCard() {
		return card;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetCard(RosettaCardinality newCard, NotificationChain msgs) {
		RosettaCardinality oldCard = card;
		card = newCard;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SimplePackage.ATTRIBUTE__CARD, oldCard, newCard);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCard(RosettaCardinality newCard) {
		if (newCard != card) {
			NotificationChain msgs = null;
			if (card != null)
				msgs = ((InternalEObject)card).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SimplePackage.ATTRIBUTE__CARD, null, msgs);
			if (newCard != null)
				msgs = ((InternalEObject)newCard).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SimplePackage.ATTRIBUTE__CARD, null, msgs);
			msgs = basicSetCard(newCard, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SimplePackage.ATTRIBUTE__CARD, newCard, newCard));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<RosettaSynonym> getSynonyms() {
		if (synonyms == null) {
			synonyms = new EObjectContainmentEList<RosettaSynonym>(RosettaSynonym.class, this, SimplePackage.ATTRIBUTE__SYNONYMS);
		}
		return synonyms;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaRuleReference getRuleReference() {
		return ruleReference;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetRuleReference(RosettaRuleReference newRuleReference, NotificationChain msgs) {
		RosettaRuleReference oldRuleReference = ruleReference;
		ruleReference = newRuleReference;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SimplePackage.ATTRIBUTE__RULE_REFERENCE, oldRuleReference, newRuleReference);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setRuleReference(RosettaRuleReference newRuleReference) {
		if (newRuleReference != ruleReference) {
			NotificationChain msgs = null;
			if (ruleReference != null)
				msgs = ((InternalEObject)ruleReference).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SimplePackage.ATTRIBUTE__RULE_REFERENCE, null, msgs);
			if (newRuleReference != null)
				msgs = ((InternalEObject)newRuleReference).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SimplePackage.ATTRIBUTE__RULE_REFERENCE, null, msgs);
			msgs = basicSetRuleReference(newRuleReference, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SimplePackage.ATTRIBUTE__RULE_REFERENCE, newRuleReference, newRuleReference));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SimplePackage.ATTRIBUTE__ANNOTATIONS:
				return ((InternalEList<?>)getAnnotations()).basicRemove(otherEnd, msgs);
			case SimplePackage.ATTRIBUTE__REFERENCES:
				return ((InternalEList<?>)getReferences()).basicRemove(otherEnd, msgs);
			case SimplePackage.ATTRIBUTE__CARD:
				return basicSetCard(null, msgs);
			case SimplePackage.ATTRIBUTE__SYNONYMS:
				return ((InternalEList<?>)getSynonyms()).basicRemove(otherEnd, msgs);
			case SimplePackage.ATTRIBUTE__RULE_REFERENCE:
				return basicSetRuleReference(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SimplePackage.ATTRIBUTE__DEFINITION:
				return getDefinition();
			case SimplePackage.ATTRIBUTE__ANNOTATIONS:
				return getAnnotations();
			case SimplePackage.ATTRIBUTE__REFERENCES:
				return getReferences();
			case SimplePackage.ATTRIBUTE__OVERRIDE:
				return isOverride();
			case SimplePackage.ATTRIBUTE__CARD:
				return getCard();
			case SimplePackage.ATTRIBUTE__SYNONYMS:
				return getSynonyms();
			case SimplePackage.ATTRIBUTE__RULE_REFERENCE:
				return getRuleReference();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SimplePackage.ATTRIBUTE__DEFINITION:
				setDefinition((String)newValue);
				return;
			case SimplePackage.ATTRIBUTE__ANNOTATIONS:
				getAnnotations().clear();
				getAnnotations().addAll((Collection<? extends AnnotationRef>)newValue);
				return;
			case SimplePackage.ATTRIBUTE__REFERENCES:
				getReferences().clear();
				getReferences().addAll((Collection<? extends RosettaDocReference>)newValue);
				return;
			case SimplePackage.ATTRIBUTE__OVERRIDE:
				setOverride((Boolean)newValue);
				return;
			case SimplePackage.ATTRIBUTE__CARD:
				setCard((RosettaCardinality)newValue);
				return;
			case SimplePackage.ATTRIBUTE__SYNONYMS:
				getSynonyms().clear();
				getSynonyms().addAll((Collection<? extends RosettaSynonym>)newValue);
				return;
			case SimplePackage.ATTRIBUTE__RULE_REFERENCE:
				setRuleReference((RosettaRuleReference)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SimplePackage.ATTRIBUTE__DEFINITION:
				setDefinition(DEFINITION_EDEFAULT);
				return;
			case SimplePackage.ATTRIBUTE__ANNOTATIONS:
				getAnnotations().clear();
				return;
			case SimplePackage.ATTRIBUTE__REFERENCES:
				getReferences().clear();
				return;
			case SimplePackage.ATTRIBUTE__OVERRIDE:
				setOverride(OVERRIDE_EDEFAULT);
				return;
			case SimplePackage.ATTRIBUTE__CARD:
				setCard((RosettaCardinality)null);
				return;
			case SimplePackage.ATTRIBUTE__SYNONYMS:
				getSynonyms().clear();
				return;
			case SimplePackage.ATTRIBUTE__RULE_REFERENCE:
				setRuleReference((RosettaRuleReference)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SimplePackage.ATTRIBUTE__DEFINITION:
				return DEFINITION_EDEFAULT == null ? definition != null : !DEFINITION_EDEFAULT.equals(definition);
			case SimplePackage.ATTRIBUTE__ANNOTATIONS:
				return annotations != null && !annotations.isEmpty();
			case SimplePackage.ATTRIBUTE__REFERENCES:
				return references != null && !references.isEmpty();
			case SimplePackage.ATTRIBUTE__OVERRIDE:
				return override != OVERRIDE_EDEFAULT;
			case SimplePackage.ATTRIBUTE__CARD:
				return card != null;
			case SimplePackage.ATTRIBUTE__SYNONYMS:
				return synonyms != null && !synonyms.isEmpty();
			case SimplePackage.ATTRIBUTE__RULE_REFERENCE:
				return ruleReference != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == RosettaDefinable.class) {
			switch (derivedFeatureID) {
				case SimplePackage.ATTRIBUTE__DEFINITION: return RosettaPackage.ROSETTA_DEFINABLE__DEFINITION;
				default: return -1;
			}
		}
		if (baseClass == Annotated.class) {
			switch (derivedFeatureID) {
				case SimplePackage.ATTRIBUTE__ANNOTATIONS: return SimplePackage.ANNOTATED__ANNOTATIONS;
				default: return -1;
			}
		}
		if (baseClass == RosettaSymbol.class) {
			switch (derivedFeatureID) {
				default: return -1;
			}
		}
		if (baseClass == AssignPathRoot.class) {
			switch (derivedFeatureID) {
				default: return -1;
			}
		}
		if (baseClass == References.class) {
			switch (derivedFeatureID) {
				case SimplePackage.ATTRIBUTE__REFERENCES: return SimplePackage.REFERENCES__REFERENCES;
				default: return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == RosettaDefinable.class) {
			switch (baseFeatureID) {
				case RosettaPackage.ROSETTA_DEFINABLE__DEFINITION: return SimplePackage.ATTRIBUTE__DEFINITION;
				default: return -1;
			}
		}
		if (baseClass == Annotated.class) {
			switch (baseFeatureID) {
				case SimplePackage.ANNOTATED__ANNOTATIONS: return SimplePackage.ATTRIBUTE__ANNOTATIONS;
				default: return -1;
			}
		}
		if (baseClass == RosettaSymbol.class) {
			switch (baseFeatureID) {
				default: return -1;
			}
		}
		if (baseClass == AssignPathRoot.class) {
			switch (baseFeatureID) {
				default: return -1;
			}
		}
		if (baseClass == References.class) {
			switch (baseFeatureID) {
				case SimplePackage.REFERENCES__REFERENCES: return SimplePackage.ATTRIBUTE__REFERENCES;
				default: return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (definition: ");
		result.append(definition);
		result.append(", override: ");
		result.append(override);
		result.append(')');
		return result.toString();
	}

} //AttributeImpl
