/**
 * Copyright (c) REGnosys 2017 (www.regnosys.com)
 */
package com.regnosys.rosetta.rosetta.simple.impl;

import com.regnosys.rosetta.rosetta.RosettaCallableWithArgs;
import com.regnosys.rosetta.rosetta.RosettaDocReference;
import com.regnosys.rosetta.rosetta.RosettaSymbol;

import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Condition;
import com.regnosys.rosetta.rosetta.simple.Function;
import com.regnosys.rosetta.rosetta.simple.Operation;
import com.regnosys.rosetta.rosetta.simple.References;
import com.regnosys.rosetta.rosetta.simple.ShortcutDeclaration;
import com.regnosys.rosetta.rosetta.simple.SimplePackage;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Function</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link com.regnosys.rosetta.rosetta.simple.impl.FunctionImpl#getReferences <em>References</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.simple.impl.FunctionImpl#getInputs <em>Inputs</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.simple.impl.FunctionImpl#getOutput <em>Output</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.simple.impl.FunctionImpl#getShortcuts <em>Shortcuts</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.simple.impl.FunctionImpl#getConditions <em>Conditions</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.simple.impl.FunctionImpl#getOperations <em>Operations</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.simple.impl.FunctionImpl#getPostConditions <em>Post Conditions</em>}</li>
 * </ul>
 *
 * @generated
 */
public class FunctionImpl extends RootElementImpl implements Function {
	/**
	 * The cached value of the '{@link #getReferences() <em>References</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReferences()
	 * @generated
	 * @ordered
	 */
	protected EList<RosettaDocReference> references;

	/**
	 * The cached value of the '{@link #getInputs() <em>Inputs</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInputs()
	 * @generated
	 * @ordered
	 */
	protected EList<Attribute> inputs;

	/**
	 * The cached value of the '{@link #getOutput() <em>Output</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOutput()
	 * @generated
	 * @ordered
	 */
	protected Attribute output;

	/**
	 * The cached value of the '{@link #getShortcuts() <em>Shortcuts</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getShortcuts()
	 * @generated
	 * @ordered
	 */
	protected EList<ShortcutDeclaration> shortcuts;

	/**
	 * The cached value of the '{@link #getConditions() <em>Conditions</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getConditions()
	 * @generated
	 * @ordered
	 */
	protected EList<Condition> conditions;

	/**
	 * The cached value of the '{@link #getOperations() <em>Operations</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOperations()
	 * @generated
	 * @ordered
	 */
	protected EList<Operation> operations;

	/**
	 * The cached value of the '{@link #getPostConditions() <em>Post Conditions</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPostConditions()
	 * @generated
	 * @ordered
	 */
	protected EList<Condition> postConditions;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FunctionImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SimplePackage.Literals.FUNCTION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<RosettaDocReference> getReferences() {
		if (references == null) {
			references = new EObjectContainmentEList<RosettaDocReference>(RosettaDocReference.class, this, SimplePackage.FUNCTION__REFERENCES);
		}
		return references;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Attribute> getInputs() {
		if (inputs == null) {
			inputs = new EObjectContainmentEList<Attribute>(Attribute.class, this, SimplePackage.FUNCTION__INPUTS);
		}
		return inputs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Attribute getOutput() {
		return output;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetOutput(Attribute newOutput, NotificationChain msgs) {
		Attribute oldOutput = output;
		output = newOutput;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SimplePackage.FUNCTION__OUTPUT, oldOutput, newOutput);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setOutput(Attribute newOutput) {
		if (newOutput != output) {
			NotificationChain msgs = null;
			if (output != null)
				msgs = ((InternalEObject)output).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SimplePackage.FUNCTION__OUTPUT, null, msgs);
			if (newOutput != null)
				msgs = ((InternalEObject)newOutput).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SimplePackage.FUNCTION__OUTPUT, null, msgs);
			msgs = basicSetOutput(newOutput, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SimplePackage.FUNCTION__OUTPUT, newOutput, newOutput));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<ShortcutDeclaration> getShortcuts() {
		if (shortcuts == null) {
			shortcuts = new EObjectContainmentEList<ShortcutDeclaration>(ShortcutDeclaration.class, this, SimplePackage.FUNCTION__SHORTCUTS);
		}
		return shortcuts;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Condition> getConditions() {
		if (conditions == null) {
			conditions = new EObjectContainmentEList<Condition>(Condition.class, this, SimplePackage.FUNCTION__CONDITIONS);
		}
		return conditions;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Operation> getOperations() {
		if (operations == null) {
			operations = new EObjectContainmentWithInverseEList<Operation>(Operation.class, this, SimplePackage.FUNCTION__OPERATIONS, SimplePackage.OPERATION__FUNCTION);
		}
		return operations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Condition> getPostConditions() {
		if (postConditions == null) {
			postConditions = new EObjectContainmentEList<Condition>(Condition.class, this, SimplePackage.FUNCTION__POST_CONDITIONS);
		}
		return postConditions;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int numberOfParameters() {
		return this.getInputs().size();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SimplePackage.FUNCTION__OPERATIONS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getOperations()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SimplePackage.FUNCTION__REFERENCES:
				return ((InternalEList<?>)getReferences()).basicRemove(otherEnd, msgs);
			case SimplePackage.FUNCTION__INPUTS:
				return ((InternalEList<?>)getInputs()).basicRemove(otherEnd, msgs);
			case SimplePackage.FUNCTION__OUTPUT:
				return basicSetOutput(null, msgs);
			case SimplePackage.FUNCTION__SHORTCUTS:
				return ((InternalEList<?>)getShortcuts()).basicRemove(otherEnd, msgs);
			case SimplePackage.FUNCTION__CONDITIONS:
				return ((InternalEList<?>)getConditions()).basicRemove(otherEnd, msgs);
			case SimplePackage.FUNCTION__OPERATIONS:
				return ((InternalEList<?>)getOperations()).basicRemove(otherEnd, msgs);
			case SimplePackage.FUNCTION__POST_CONDITIONS:
				return ((InternalEList<?>)getPostConditions()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SimplePackage.FUNCTION__REFERENCES:
				return getReferences();
			case SimplePackage.FUNCTION__INPUTS:
				return getInputs();
			case SimplePackage.FUNCTION__OUTPUT:
				return getOutput();
			case SimplePackage.FUNCTION__SHORTCUTS:
				return getShortcuts();
			case SimplePackage.FUNCTION__CONDITIONS:
				return getConditions();
			case SimplePackage.FUNCTION__OPERATIONS:
				return getOperations();
			case SimplePackage.FUNCTION__POST_CONDITIONS:
				return getPostConditions();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SimplePackage.FUNCTION__REFERENCES:
				getReferences().clear();
				getReferences().addAll((Collection<? extends RosettaDocReference>)newValue);
				return;
			case SimplePackage.FUNCTION__INPUTS:
				getInputs().clear();
				getInputs().addAll((Collection<? extends Attribute>)newValue);
				return;
			case SimplePackage.FUNCTION__OUTPUT:
				setOutput((Attribute)newValue);
				return;
			case SimplePackage.FUNCTION__SHORTCUTS:
				getShortcuts().clear();
				getShortcuts().addAll((Collection<? extends ShortcutDeclaration>)newValue);
				return;
			case SimplePackage.FUNCTION__CONDITIONS:
				getConditions().clear();
				getConditions().addAll((Collection<? extends Condition>)newValue);
				return;
			case SimplePackage.FUNCTION__OPERATIONS:
				getOperations().clear();
				getOperations().addAll((Collection<? extends Operation>)newValue);
				return;
			case SimplePackage.FUNCTION__POST_CONDITIONS:
				getPostConditions().clear();
				getPostConditions().addAll((Collection<? extends Condition>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SimplePackage.FUNCTION__REFERENCES:
				getReferences().clear();
				return;
			case SimplePackage.FUNCTION__INPUTS:
				getInputs().clear();
				return;
			case SimplePackage.FUNCTION__OUTPUT:
				setOutput((Attribute)null);
				return;
			case SimplePackage.FUNCTION__SHORTCUTS:
				getShortcuts().clear();
				return;
			case SimplePackage.FUNCTION__CONDITIONS:
				getConditions().clear();
				return;
			case SimplePackage.FUNCTION__OPERATIONS:
				getOperations().clear();
				return;
			case SimplePackage.FUNCTION__POST_CONDITIONS:
				getPostConditions().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SimplePackage.FUNCTION__REFERENCES:
				return references != null && !references.isEmpty();
			case SimplePackage.FUNCTION__INPUTS:
				return inputs != null && !inputs.isEmpty();
			case SimplePackage.FUNCTION__OUTPUT:
				return output != null;
			case SimplePackage.FUNCTION__SHORTCUTS:
				return shortcuts != null && !shortcuts.isEmpty();
			case SimplePackage.FUNCTION__CONDITIONS:
				return conditions != null && !conditions.isEmpty();
			case SimplePackage.FUNCTION__OPERATIONS:
				return operations != null && !operations.isEmpty();
			case SimplePackage.FUNCTION__POST_CONDITIONS:
				return postConditions != null && !postConditions.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == RosettaSymbol.class) {
			switch (derivedFeatureID) {
				default: return -1;
			}
		}
		if (baseClass == RosettaCallableWithArgs.class) {
			switch (derivedFeatureID) {
				default: return -1;
			}
		}
		if (baseClass == References.class) {
			switch (derivedFeatureID) {
				case SimplePackage.FUNCTION__REFERENCES: return SimplePackage.REFERENCES__REFERENCES;
				default: return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == RosettaSymbol.class) {
			switch (baseFeatureID) {
				default: return -1;
			}
		}
		if (baseClass == RosettaCallableWithArgs.class) {
			switch (baseFeatureID) {
				default: return -1;
			}
		}
		if (baseClass == References.class) {
			switch (baseFeatureID) {
				case SimplePackage.REFERENCES__REFERENCES: return SimplePackage.FUNCTION__REFERENCES;
				default: return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

} //FunctionImpl
