/**
 * Copyright (c) REGnosys 2017 (www.regnosys.com)
 */
package com.regnosys.rosetta.rosetta.simple.util;

import com.regnosys.rosetta.rosetta.RosettaCallableWithArgs;
import com.regnosys.rosetta.rosetta.RosettaDefinable;
import com.regnosys.rosetta.rosetta.RosettaFeature;
import com.regnosys.rosetta.rosetta.RosettaNamed;
import com.regnosys.rosetta.rosetta.RosettaRootElement;
import com.regnosys.rosetta.rosetta.RosettaSymbol;
import com.regnosys.rosetta.rosetta.RosettaType;
import com.regnosys.rosetta.rosetta.RosettaTyped;
import com.regnosys.rosetta.rosetta.RosettaTypedFeature;

import com.regnosys.rosetta.rosetta.simple.*;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see com.regnosys.rosetta.rosetta.simple.SimplePackage
 * @generated
 */
public class SimpleAdapterFactory extends AdapterFactoryImpl {
	/**
	 * The cached model package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static SimplePackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SimpleAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = SimplePackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc -->
	 * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
	 * <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject)object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch that delegates to the <code>createXXX</code> methods.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SimpleSwitch<Adapter> modelSwitch =
		new SimpleSwitch<Adapter>() {
			@Override
			public Adapter caseRootElement(RootElement object) {
				return createRootElementAdapter();
			}
			@Override
			public Adapter caseAnnotation(Annotation object) {
				return createAnnotationAdapter();
			}
			@Override
			public Adapter caseAnnotated(Annotated object) {
				return createAnnotatedAdapter();
			}
			@Override
			public Adapter caseAnnotationQualifier(AnnotationQualifier object) {
				return createAnnotationQualifierAdapter();
			}
			@Override
			public Adapter caseAnnotationRef(AnnotationRef object) {
				return createAnnotationRefAdapter();
			}
			@Override
			public Adapter caseAssignPathRoot(AssignPathRoot object) {
				return createAssignPathRootAdapter();
			}
			@Override
			public Adapter caseAttribute(Attribute object) {
				return createAttributeAdapter();
			}
			@Override
			public Adapter caseData(Data object) {
				return createDataAdapter();
			}
			@Override
			public Adapter caseChoice(Choice object) {
				return createChoiceAdapter();
			}
			@Override
			public Adapter caseChoiceOption(ChoiceOption object) {
				return createChoiceOptionAdapter();
			}
			@Override
			public Adapter caseFunction(Function object) {
				return createFunctionAdapter();
			}
			@Override
			public Adapter caseFunctionDispatch(FunctionDispatch object) {
				return createFunctionDispatchAdapter();
			}
			@Override
			public Adapter caseCondition(Condition object) {
				return createConditionAdapter();
			}
			@Override
			public Adapter caseOperation(Operation object) {
				return createOperationAdapter();
			}
			@Override
			public Adapter caseSegment(Segment object) {
				return createSegmentAdapter();
			}
			@Override
			public Adapter caseShortcutDeclaration(ShortcutDeclaration object) {
				return createShortcutDeclarationAdapter();
			}
			@Override
			public Adapter caseReferences(References object) {
				return createReferencesAdapter();
			}
			@Override
			public Adapter caseRosettaRuleReference(RosettaRuleReference object) {
				return createRosettaRuleReferenceAdapter();
			}
			@Override
			public Adapter caseRosettaRootElement(RosettaRootElement object) {
				return createRosettaRootElementAdapter();
			}
			@Override
			public Adapter caseRosettaNamed(RosettaNamed object) {
				return createRosettaNamedAdapter();
			}
			@Override
			public Adapter caseRosettaDefinable(RosettaDefinable object) {
				return createRosettaDefinableAdapter();
			}
			@Override
			public Adapter caseRosettaSymbol(RosettaSymbol object) {
				return createRosettaSymbolAdapter();
			}
			@Override
			public Adapter caseRosettaFeature(RosettaFeature object) {
				return createRosettaFeatureAdapter();
			}
			@Override
			public Adapter caseRosettaTyped(RosettaTyped object) {
				return createRosettaTypedAdapter();
			}
			@Override
			public Adapter caseRosettaTypedFeature(RosettaTypedFeature object) {
				return createRosettaTypedFeatureAdapter();
			}
			@Override
			public Adapter caseRosettaType(RosettaType object) {
				return createRosettaTypeAdapter();
			}
			@Override
			public Adapter caseRosettaCallableWithArgs(RosettaCallableWithArgs object) {
				return createRosettaCallableWithArgsAdapter();
			}
			@Override
			public Adapter defaultCase(EObject object) {
				return createEObjectAdapter();
			}
		};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	@Override
	public Adapter createAdapter(Notifier target) {
		return modelSwitch.doSwitch((EObject)target);
	}


	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.simple.RootElement <em>Root Element</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.simple.RootElement
	 * @generated
	 */
	public Adapter createRootElementAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.simple.Annotation <em>Annotation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.simple.Annotation
	 * @generated
	 */
	public Adapter createAnnotationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.simple.Annotated <em>Annotated</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.simple.Annotated
	 * @generated
	 */
	public Adapter createAnnotatedAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.simple.AnnotationQualifier <em>Annotation Qualifier</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.simple.AnnotationQualifier
	 * @generated
	 */
	public Adapter createAnnotationQualifierAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.simple.AnnotationRef <em>Annotation Ref</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.simple.AnnotationRef
	 * @generated
	 */
	public Adapter createAnnotationRefAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.simple.AssignPathRoot <em>Assign Path Root</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.simple.AssignPathRoot
	 * @generated
	 */
	public Adapter createAssignPathRootAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.simple.Attribute <em>Attribute</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.simple.Attribute
	 * @generated
	 */
	public Adapter createAttributeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.simple.Data <em>Data</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.simple.Data
	 * @generated
	 */
	public Adapter createDataAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.simple.Choice <em>Choice</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.simple.Choice
	 * @generated
	 */
	public Adapter createChoiceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.simple.ChoiceOption <em>Choice Option</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.simple.ChoiceOption
	 * @generated
	 */
	public Adapter createChoiceOptionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.simple.Function <em>Function</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.simple.Function
	 * @generated
	 */
	public Adapter createFunctionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.simple.FunctionDispatch <em>Function Dispatch</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.simple.FunctionDispatch
	 * @generated
	 */
	public Adapter createFunctionDispatchAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.simple.Condition <em>Condition</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.simple.Condition
	 * @generated
	 */
	public Adapter createConditionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.simple.Operation <em>Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.simple.Operation
	 * @generated
	 */
	public Adapter createOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.simple.Segment <em>Segment</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.simple.Segment
	 * @generated
	 */
	public Adapter createSegmentAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.simple.ShortcutDeclaration <em>Shortcut Declaration</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.simple.ShortcutDeclaration
	 * @generated
	 */
	public Adapter createShortcutDeclarationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.simple.References <em>References</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.simple.References
	 * @generated
	 */
	public Adapter createReferencesAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.simple.RosettaRuleReference <em>Rosetta Rule Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.simple.RosettaRuleReference
	 * @generated
	 */
	public Adapter createRosettaRuleReferenceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaRootElement <em>Root Element</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaRootElement
	 * @generated
	 */
	public Adapter createRosettaRootElementAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaNamed <em>Named</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaNamed
	 * @generated
	 */
	public Adapter createRosettaNamedAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaDefinable <em>Definable</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaDefinable
	 * @generated
	 */
	public Adapter createRosettaDefinableAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaSymbol <em>Symbol</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaSymbol
	 * @generated
	 */
	public Adapter createRosettaSymbolAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaFeature <em>Feature</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaFeature
	 * @generated
	 */
	public Adapter createRosettaFeatureAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaTyped <em>Typed</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaTyped
	 * @generated
	 */
	public Adapter createRosettaTypedAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaTypedFeature <em>Typed Feature</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaTypedFeature
	 * @generated
	 */
	public Adapter createRosettaTypedFeatureAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaType
	 * @generated
	 */
	public Adapter createRosettaTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaCallableWithArgs <em>Callable With Args</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaCallableWithArgs
	 * @generated
	 */
	public Adapter createRosettaCallableWithArgsAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} //SimpleAdapterFactory
