/**
 * Copyright (c) REGnosys 2017 (www.regnosys.com)
 */
package com.regnosys.rosetta.rosetta.util;

import com.regnosys.rosetta.rosetta.*;

import com.regnosys.rosetta.rosetta.simple.References;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see com.regnosys.rosetta.rosetta.RosettaPackage
 * @generated
 */
public class RosettaAdapterFactory extends AdapterFactoryImpl {
	/**
	 * The cached model package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static RosettaPackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RosettaAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = RosettaPackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc -->
	 * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
	 * <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject)object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch that delegates to the <code>createXXX</code> methods.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RosettaSwitch<Adapter> modelSwitch =
		new RosettaSwitch<Adapter>() {
			@Override
			public Adapter caseRosettaModel(RosettaModel object) {
				return createRosettaModelAdapter();
			}
			@Override
			public Adapter caseImport(Import object) {
				return createImportAdapter();
			}
			@Override
			public Adapter caseRosettaDefinable(RosettaDefinable object) {
				return createRosettaDefinableAdapter();
			}
			@Override
			public Adapter caseRosettaNamed(RosettaNamed object) {
				return createRosettaNamedAdapter();
			}
			@Override
			public Adapter caseRosettaTyped(RosettaTyped object) {
				return createRosettaTypedAdapter();
			}
			@Override
			public Adapter caseRosettaFeature(RosettaFeature object) {
				return createRosettaFeatureAdapter();
			}
			@Override
			public Adapter caseRosettaTypedFeature(RosettaTypedFeature object) {
				return createRosettaTypedFeatureAdapter();
			}
			@Override
			public Adapter caseRosettaSymbol(RosettaSymbol object) {
				return createRosettaSymbolAdapter();
			}
			@Override
			public Adapter caseRosettaCallableWithArgs(RosettaCallableWithArgs object) {
				return createRosettaCallableWithArgsAdapter();
			}
			@Override
			public Adapter caseRosettaRootElement(RosettaRootElement object) {
				return createRosettaRootElementAdapter();
			}
			@Override
			public Adapter caseRosettaFeatureOwner(RosettaFeatureOwner object) {
				return createRosettaFeatureOwnerAdapter();
			}
			@Override
			public Adapter caseRosettaType(RosettaType object) {
				return createRosettaTypeAdapter();
			}
			@Override
			public Adapter caseParametrizedRosettaType(ParametrizedRosettaType object) {
				return createParametrizedRosettaTypeAdapter();
			}
			@Override
			public Adapter caseTypeCall(TypeCall object) {
				return createTypeCallAdapter();
			}
			@Override
			public Adapter caseTypeCallArgument(TypeCallArgument object) {
				return createTypeCallArgumentAdapter();
			}
			@Override
			public Adapter caseRosettaBuiltinType(RosettaBuiltinType object) {
				return createRosettaBuiltinTypeAdapter();
			}
			@Override
			public Adapter caseRosettaBasicType(RosettaBasicType object) {
				return createRosettaBasicTypeAdapter();
			}
			@Override
			public Adapter caseTypeParameter(TypeParameter object) {
				return createTypeParameterAdapter();
			}
			@Override
			public Adapter caseRosettaSynonymSource(RosettaSynonymSource object) {
				return createRosettaSynonymSourceAdapter();
			}
			@Override
			public Adapter caseRosettaRecordType(RosettaRecordType object) {
				return createRosettaRecordTypeAdapter();
			}
			@Override
			public Adapter caseRosettaRecordFeature(RosettaRecordFeature object) {
				return createRosettaRecordFeatureAdapter();
			}
			@Override
			public Adapter caseRosettaExternalFunction(RosettaExternalFunction object) {
				return createRosettaExternalFunctionAdapter();
			}
			@Override
			public Adapter caseRosettaParameter(RosettaParameter object) {
				return createRosettaParameterAdapter();
			}
			@Override
			public Adapter caseRosettaTypeAlias(RosettaTypeAlias object) {
				return createRosettaTypeAliasAdapter();
			}
			@Override
			public Adapter caseRosettaMetaType(RosettaMetaType object) {
				return createRosettaMetaTypeAdapter();
			}
			@Override
			public Adapter caseRosettaEnumeration(RosettaEnumeration object) {
				return createRosettaEnumerationAdapter();
			}
			@Override
			public Adapter caseRosettaEnumValue(RosettaEnumValue object) {
				return createRosettaEnumValueAdapter();
			}
			@Override
			public Adapter caseRosettaEnumValueReference(RosettaEnumValueReference object) {
				return createRosettaEnumValueReferenceAdapter();
			}
			@Override
			public Adapter caseRosettaCardinality(RosettaCardinality object) {
				return createRosettaCardinalityAdapter();
			}
			@Override
			public Adapter caseRosettaSynonymBase(RosettaSynonymBase object) {
				return createRosettaSynonymBaseAdapter();
			}
			@Override
			public Adapter caseRosettaSynonymValueBase(RosettaSynonymValueBase object) {
				return createRosettaSynonymValueBaseAdapter();
			}
			@Override
			public Adapter caseRosettaClassSynonym(RosettaClassSynonym object) {
				return createRosettaClassSynonymAdapter();
			}
			@Override
			public Adapter caseRosettaSynonym(RosettaSynonym object) {
				return createRosettaSynonymAdapter();
			}
			@Override
			public Adapter caseRosettaSynonymBody(RosettaSynonymBody object) {
				return createRosettaSynonymBodyAdapter();
			}
			@Override
			public Adapter caseRosettaMergeSynonymValue(RosettaMergeSynonymValue object) {
				return createRosettaMergeSynonymValueAdapter();
			}
			@Override
			public Adapter caseRosettaEnumSynonym(RosettaEnumSynonym object) {
				return createRosettaEnumSynonymAdapter();
			}
			@Override
			public Adapter caseRosettaDocReference(RosettaDocReference object) {
				return createRosettaDocReferenceAdapter();
			}
			@Override
			public Adapter caseRegulatoryDocumentReference(RegulatoryDocumentReference object) {
				return createRegulatoryDocumentReferenceAdapter();
			}
			@Override
			public Adapter caseRosettaSegmentRef(RosettaSegmentRef object) {
				return createRosettaSegmentRefAdapter();
			}
			@Override
			public Adapter caseDocumentRationale(DocumentRationale object) {
				return createDocumentRationaleAdapter();
			}
			@Override
			public Adapter caseRosettaBody(RosettaBody object) {
				return createRosettaBodyAdapter();
			}
			@Override
			public Adapter caseRosettaCorpus(RosettaCorpus object) {
				return createRosettaCorpusAdapter();
			}
			@Override
			public Adapter caseRosettaSegment(RosettaSegment object) {
				return createRosettaSegmentAdapter();
			}
			@Override
			public Adapter caseRosettaMapTest(RosettaMapTest object) {
				return createRosettaMapTestAdapter();
			}
			@Override
			public Adapter caseRosettaMapTestExpression(RosettaMapTestExpression object) {
				return createRosettaMapTestExpressionAdapter();
			}
			@Override
			public Adapter caseRosettaMapPathValue(RosettaMapPathValue object) {
				return createRosettaMapPathValueAdapter();
			}
			@Override
			public Adapter caseRosettaMapTestExistsExpression(RosettaMapTestExistsExpression object) {
				return createRosettaMapTestExistsExpressionAdapter();
			}
			@Override
			public Adapter caseRosettaMapTestAbsentExpression(RosettaMapTestAbsentExpression object) {
				return createRosettaMapTestAbsentExpressionAdapter();
			}
			@Override
			public Adapter caseRosettaMapTestEqualityOperation(RosettaMapTestEqualityOperation object) {
				return createRosettaMapTestEqualityOperationAdapter();
			}
			@Override
			public Adapter caseRosettaMapTestFunc(RosettaMapTestFunc object) {
				return createRosettaMapTestFuncAdapter();
			}
			@Override
			public Adapter caseRosettaAttributeReferenceSegment(RosettaAttributeReferenceSegment object) {
				return createRosettaAttributeReferenceSegmentAdapter();
			}
			@Override
			public Adapter caseRosettaDataReference(RosettaDataReference object) {
				return createRosettaDataReferenceAdapter();
			}
			@Override
			public Adapter caseRosettaAttributeReference(RosettaAttributeReference object) {
				return createRosettaAttributeReferenceAdapter();
			}
			@Override
			public Adapter caseRosettaMapping(RosettaMapping object) {
				return createRosettaMappingAdapter();
			}
			@Override
			public Adapter caseRosettaMappingInstance(RosettaMappingInstance object) {
				return createRosettaMappingInstanceAdapter();
			}
			@Override
			public Adapter caseRosettaMappingPathTests(RosettaMappingPathTests object) {
				return createRosettaMappingPathTestsAdapter();
			}
			@Override
			public Adapter caseRosettaMapPath(RosettaMapPath object) {
				return createRosettaMapPathAdapter();
			}
			@Override
			public Adapter caseRosettaMapRosettaPath(RosettaMapRosettaPath object) {
				return createRosettaMapRosettaPathAdapter();
			}
			@Override
			public Adapter caseRosettaQualifiableConfiguration(RosettaQualifiableConfiguration object) {
				return createRosettaQualifiableConfigurationAdapter();
			}
			@Override
			public Adapter caseExternalAnnotationSource(ExternalAnnotationSource object) {
				return createExternalAnnotationSourceAdapter();
			}
			@Override
			public Adapter caseRosettaExternalRef(RosettaExternalRef object) {
				return createRosettaExternalRefAdapter();
			}
			@Override
			public Adapter caseRosettaExternalClass(RosettaExternalClass object) {
				return createRosettaExternalClassAdapter();
			}
			@Override
			public Adapter caseRosettaExternalEnum(RosettaExternalEnum object) {
				return createRosettaExternalEnumAdapter();
			}
			@Override
			public Adapter caseRosettaExternalRegularAttribute(RosettaExternalRegularAttribute object) {
				return createRosettaExternalRegularAttributeAdapter();
			}
			@Override
			public Adapter caseRosettaExternalEnumValue(RosettaExternalEnumValue object) {
				return createRosettaExternalEnumValueAdapter();
			}
			@Override
			public Adapter caseRosettaExternalClassSynonym(RosettaExternalClassSynonym object) {
				return createRosettaExternalClassSynonymAdapter();
			}
			@Override
			public Adapter caseRosettaExternalSynonym(RosettaExternalSynonym object) {
				return createRosettaExternalSynonymAdapter();
			}
			@Override
			public Adapter caseRosettaExternalSynonymSource(RosettaExternalSynonymSource object) {
				return createRosettaExternalSynonymSourceAdapter();
			}
			@Override
			public Adapter caseRosettaExternalRuleSource(RosettaExternalRuleSource object) {
				return createRosettaExternalRuleSourceAdapter();
			}
			@Override
			public Adapter caseRosettaReport(RosettaReport object) {
				return createRosettaReportAdapter();
			}
			@Override
			public Adapter caseRosettaRule(RosettaRule object) {
				return createRosettaRuleAdapter();
			}
			@Override
			public Adapter caseReferences(References object) {
				return createReferencesAdapter();
			}
			@Override
			public Adapter defaultCase(EObject object) {
				return createEObjectAdapter();
			}
		};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	@Override
	public Adapter createAdapter(Notifier target) {
		return modelSwitch.doSwitch((EObject)target);
	}


	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaModel <em>Model</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaModel
	 * @generated
	 */
	public Adapter createRosettaModelAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.Import <em>Import</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.Import
	 * @generated
	 */
	public Adapter createImportAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaDefinable <em>Definable</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaDefinable
	 * @generated
	 */
	public Adapter createRosettaDefinableAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaNamed <em>Named</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaNamed
	 * @generated
	 */
	public Adapter createRosettaNamedAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaTyped <em>Typed</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaTyped
	 * @generated
	 */
	public Adapter createRosettaTypedAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaFeature <em>Feature</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaFeature
	 * @generated
	 */
	public Adapter createRosettaFeatureAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaTypedFeature <em>Typed Feature</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaTypedFeature
	 * @generated
	 */
	public Adapter createRosettaTypedFeatureAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaSymbol <em>Symbol</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaSymbol
	 * @generated
	 */
	public Adapter createRosettaSymbolAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaCallableWithArgs <em>Callable With Args</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaCallableWithArgs
	 * @generated
	 */
	public Adapter createRosettaCallableWithArgsAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaRootElement <em>Root Element</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaRootElement
	 * @generated
	 */
	public Adapter createRosettaRootElementAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaFeatureOwner <em>Feature Owner</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaFeatureOwner
	 * @generated
	 */
	public Adapter createRosettaFeatureOwnerAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaType
	 * @generated
	 */
	public Adapter createRosettaTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.ParametrizedRosettaType <em>Parametrized Rosetta Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.ParametrizedRosettaType
	 * @generated
	 */
	public Adapter createParametrizedRosettaTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.TypeCall <em>Type Call</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.TypeCall
	 * @generated
	 */
	public Adapter createTypeCallAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.TypeCallArgument <em>Type Call Argument</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.TypeCallArgument
	 * @generated
	 */
	public Adapter createTypeCallArgumentAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaBuiltinType <em>Builtin Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaBuiltinType
	 * @generated
	 */
	public Adapter createRosettaBuiltinTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaBasicType <em>Basic Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaBasicType
	 * @generated
	 */
	public Adapter createRosettaBasicTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.TypeParameter <em>Type Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.TypeParameter
	 * @generated
	 */
	public Adapter createTypeParameterAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaSynonymSource <em>Synonym Source</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaSynonymSource
	 * @generated
	 */
	public Adapter createRosettaSynonymSourceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaRecordType <em>Record Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaRecordType
	 * @generated
	 */
	public Adapter createRosettaRecordTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaRecordFeature <em>Record Feature</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaRecordFeature
	 * @generated
	 */
	public Adapter createRosettaRecordFeatureAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaExternalFunction <em>External Function</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaExternalFunction
	 * @generated
	 */
	public Adapter createRosettaExternalFunctionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaParameter <em>Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaParameter
	 * @generated
	 */
	public Adapter createRosettaParameterAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaTypeAlias <em>Type Alias</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaTypeAlias
	 * @generated
	 */
	public Adapter createRosettaTypeAliasAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaMetaType <em>Meta Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaMetaType
	 * @generated
	 */
	public Adapter createRosettaMetaTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaEnumeration <em>Enumeration</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaEnumeration
	 * @generated
	 */
	public Adapter createRosettaEnumerationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaEnumValue <em>Enum Value</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaEnumValue
	 * @generated
	 */
	public Adapter createRosettaEnumValueAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaEnumValueReference <em>Enum Value Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaEnumValueReference
	 * @generated
	 */
	public Adapter createRosettaEnumValueReferenceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaCardinality <em>Cardinality</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaCardinality
	 * @generated
	 */
	public Adapter createRosettaCardinalityAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaSynonymBase <em>Synonym Base</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaSynonymBase
	 * @generated
	 */
	public Adapter createRosettaSynonymBaseAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaSynonymValueBase <em>Synonym Value Base</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaSynonymValueBase
	 * @generated
	 */
	public Adapter createRosettaSynonymValueBaseAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaClassSynonym <em>Class Synonym</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaClassSynonym
	 * @generated
	 */
	public Adapter createRosettaClassSynonymAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaSynonym <em>Synonym</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaSynonym
	 * @generated
	 */
	public Adapter createRosettaSynonymAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaSynonymBody <em>Synonym Body</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaSynonymBody
	 * @generated
	 */
	public Adapter createRosettaSynonymBodyAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaMergeSynonymValue <em>Merge Synonym Value</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaMergeSynonymValue
	 * @generated
	 */
	public Adapter createRosettaMergeSynonymValueAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaEnumSynonym <em>Enum Synonym</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaEnumSynonym
	 * @generated
	 */
	public Adapter createRosettaEnumSynonymAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaDocReference <em>Doc Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaDocReference
	 * @generated
	 */
	public Adapter createRosettaDocReferenceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RegulatoryDocumentReference <em>Regulatory Document Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RegulatoryDocumentReference
	 * @generated
	 */
	public Adapter createRegulatoryDocumentReferenceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaSegmentRef <em>Segment Ref</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaSegmentRef
	 * @generated
	 */
	public Adapter createRosettaSegmentRefAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.DocumentRationale <em>Document Rationale</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.DocumentRationale
	 * @generated
	 */
	public Adapter createDocumentRationaleAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaBody <em>Body</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaBody
	 * @generated
	 */
	public Adapter createRosettaBodyAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaCorpus <em>Corpus</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaCorpus
	 * @generated
	 */
	public Adapter createRosettaCorpusAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaSegment <em>Segment</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaSegment
	 * @generated
	 */
	public Adapter createRosettaSegmentAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaMapTest <em>Map Test</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaMapTest
	 * @generated
	 */
	public Adapter createRosettaMapTestAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaMapTestExpression <em>Map Test Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaMapTestExpression
	 * @generated
	 */
	public Adapter createRosettaMapTestExpressionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaMapPathValue <em>Map Path Value</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaMapPathValue
	 * @generated
	 */
	public Adapter createRosettaMapPathValueAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaMapTestExistsExpression <em>Map Test Exists Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaMapTestExistsExpression
	 * @generated
	 */
	public Adapter createRosettaMapTestExistsExpressionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaMapTestAbsentExpression <em>Map Test Absent Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaMapTestAbsentExpression
	 * @generated
	 */
	public Adapter createRosettaMapTestAbsentExpressionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaMapTestEqualityOperation <em>Map Test Equality Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaMapTestEqualityOperation
	 * @generated
	 */
	public Adapter createRosettaMapTestEqualityOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaMapTestFunc <em>Map Test Func</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaMapTestFunc
	 * @generated
	 */
	public Adapter createRosettaMapTestFuncAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaAttributeReferenceSegment <em>Attribute Reference Segment</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaAttributeReferenceSegment
	 * @generated
	 */
	public Adapter createRosettaAttributeReferenceSegmentAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaDataReference <em>Data Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaDataReference
	 * @generated
	 */
	public Adapter createRosettaDataReferenceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaAttributeReference <em>Attribute Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaAttributeReference
	 * @generated
	 */
	public Adapter createRosettaAttributeReferenceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaMapping <em>Mapping</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaMapping
	 * @generated
	 */
	public Adapter createRosettaMappingAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaMappingInstance <em>Mapping Instance</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaMappingInstance
	 * @generated
	 */
	public Adapter createRosettaMappingInstanceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaMappingPathTests <em>Mapping Path Tests</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaMappingPathTests
	 * @generated
	 */
	public Adapter createRosettaMappingPathTestsAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaMapPath <em>Map Path</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaMapPath
	 * @generated
	 */
	public Adapter createRosettaMapPathAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaMapRosettaPath <em>Map Rosetta Path</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaMapRosettaPath
	 * @generated
	 */
	public Adapter createRosettaMapRosettaPathAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaQualifiableConfiguration <em>Qualifiable Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaQualifiableConfiguration
	 * @generated
	 */
	public Adapter createRosettaQualifiableConfigurationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.ExternalAnnotationSource <em>External Annotation Source</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.ExternalAnnotationSource
	 * @generated
	 */
	public Adapter createExternalAnnotationSourceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaExternalRef <em>External Ref</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaExternalRef
	 * @generated
	 */
	public Adapter createRosettaExternalRefAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaExternalClass <em>External Class</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaExternalClass
	 * @generated
	 */
	public Adapter createRosettaExternalClassAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaExternalEnum <em>External Enum</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaExternalEnum
	 * @generated
	 */
	public Adapter createRosettaExternalEnumAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaExternalRegularAttribute <em>External Regular Attribute</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaExternalRegularAttribute
	 * @generated
	 */
	public Adapter createRosettaExternalRegularAttributeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaExternalEnumValue <em>External Enum Value</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaExternalEnumValue
	 * @generated
	 */
	public Adapter createRosettaExternalEnumValueAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaExternalClassSynonym <em>External Class Synonym</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaExternalClassSynonym
	 * @generated
	 */
	public Adapter createRosettaExternalClassSynonymAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaExternalSynonym <em>External Synonym</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaExternalSynonym
	 * @generated
	 */
	public Adapter createRosettaExternalSynonymAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaExternalSynonymSource <em>External Synonym Source</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaExternalSynonymSource
	 * @generated
	 */
	public Adapter createRosettaExternalSynonymSourceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaExternalRuleSource <em>External Rule Source</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaExternalRuleSource
	 * @generated
	 */
	public Adapter createRosettaExternalRuleSourceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaReport <em>Report</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaReport
	 * @generated
	 */
	public Adapter createRosettaReportAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaRule <em>Rule</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaRule
	 * @generated
	 */
	public Adapter createRosettaRuleAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.simple.References <em>References</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.simple.References
	 * @generated
	 */
	public Adapter createReferencesAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} //RosettaAdapterFactory
