/**
 * Copyright (c) REGnosys 2017 (www.regnosys.com)
 */
package com.regnosys.rosetta.rosetta.util;

import com.regnosys.rosetta.rosetta.*;

import com.regnosys.rosetta.rosetta.simple.References;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.util.Switch;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see com.regnosys.rosetta.rosetta.RosettaPackage
 * @generated
 */
public class RosettaSwitch<T> extends Switch<T> {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static RosettaPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RosettaSwitch() {
		if (modelPackage == null) {
			modelPackage = RosettaPackage.eINSTANCE;
		}
	}

	/**
	 * Checks whether this is a switch for the given package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param ePackage the package in question.
	 * @return whether this is a switch for the given package.
	 * @generated
	 */
	@Override
	protected boolean isSwitchFor(EPackage ePackage) {
		return ePackage == modelPackage;
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	@Override
	protected T doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case RosettaPackage.ROSETTA_MODEL: {
				RosettaModel rosettaModel = (RosettaModel)theEObject;
				T result = caseRosettaModel(rosettaModel);
				if (result == null) result = caseRosettaDefinable(rosettaModel);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.IMPORT: {
				Import import_ = (Import)theEObject;
				T result = caseImport(import_);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_DEFINABLE: {
				RosettaDefinable rosettaDefinable = (RosettaDefinable)theEObject;
				T result = caseRosettaDefinable(rosettaDefinable);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_NAMED: {
				RosettaNamed rosettaNamed = (RosettaNamed)theEObject;
				T result = caseRosettaNamed(rosettaNamed);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_TYPED: {
				RosettaTyped rosettaTyped = (RosettaTyped)theEObject;
				T result = caseRosettaTyped(rosettaTyped);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_FEATURE: {
				RosettaFeature rosettaFeature = (RosettaFeature)theEObject;
				T result = caseRosettaFeature(rosettaFeature);
				if (result == null) result = caseRosettaNamed(rosettaFeature);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_TYPED_FEATURE: {
				RosettaTypedFeature rosettaTypedFeature = (RosettaTypedFeature)theEObject;
				T result = caseRosettaTypedFeature(rosettaTypedFeature);
				if (result == null) result = caseRosettaFeature(rosettaTypedFeature);
				if (result == null) result = caseRosettaTyped(rosettaTypedFeature);
				if (result == null) result = caseRosettaNamed(rosettaTypedFeature);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_SYMBOL: {
				RosettaSymbol rosettaSymbol = (RosettaSymbol)theEObject;
				T result = caseRosettaSymbol(rosettaSymbol);
				if (result == null) result = caseRosettaNamed(rosettaSymbol);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_CALLABLE_WITH_ARGS: {
				RosettaCallableWithArgs rosettaCallableWithArgs = (RosettaCallableWithArgs)theEObject;
				T result = caseRosettaCallableWithArgs(rosettaCallableWithArgs);
				if (result == null) result = caseRosettaSymbol(rosettaCallableWithArgs);
				if (result == null) result = caseRosettaNamed(rosettaCallableWithArgs);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_ROOT_ELEMENT: {
				RosettaRootElement rosettaRootElement = (RosettaRootElement)theEObject;
				T result = caseRosettaRootElement(rosettaRootElement);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_FEATURE_OWNER: {
				RosettaFeatureOwner rosettaFeatureOwner = (RosettaFeatureOwner)theEObject;
				T result = caseRosettaFeatureOwner(rosettaFeatureOwner);
				if (result == null) result = caseRosettaDefinable(rosettaFeatureOwner);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_TYPE: {
				RosettaType rosettaType = (RosettaType)theEObject;
				T result = caseRosettaType(rosettaType);
				if (result == null) result = caseRosettaRootElement(rosettaType);
				if (result == null) result = caseRosettaNamed(rosettaType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.PARAMETRIZED_ROSETTA_TYPE: {
				ParametrizedRosettaType parametrizedRosettaType = (ParametrizedRosettaType)theEObject;
				T result = caseParametrizedRosettaType(parametrizedRosettaType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.TYPE_CALL: {
				TypeCall typeCall = (TypeCall)theEObject;
				T result = caseTypeCall(typeCall);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.TYPE_CALL_ARGUMENT: {
				TypeCallArgument typeCallArgument = (TypeCallArgument)theEObject;
				T result = caseTypeCallArgument(typeCallArgument);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_BUILTIN_TYPE: {
				RosettaBuiltinType rosettaBuiltinType = (RosettaBuiltinType)theEObject;
				T result = caseRosettaBuiltinType(rosettaBuiltinType);
				if (result == null) result = caseRosettaType(rosettaBuiltinType);
				if (result == null) result = caseRosettaDefinable(rosettaBuiltinType);
				if (result == null) result = caseRosettaRootElement(rosettaBuiltinType);
				if (result == null) result = caseRosettaNamed(rosettaBuiltinType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_BASIC_TYPE: {
				RosettaBasicType rosettaBasicType = (RosettaBasicType)theEObject;
				T result = caseRosettaBasicType(rosettaBasicType);
				if (result == null) result = caseRosettaBuiltinType(rosettaBasicType);
				if (result == null) result = caseParametrizedRosettaType(rosettaBasicType);
				if (result == null) result = caseRosettaType(rosettaBasicType);
				if (result == null) result = caseRosettaDefinable(rosettaBasicType);
				if (result == null) result = caseRosettaRootElement(rosettaBasicType);
				if (result == null) result = caseRosettaNamed(rosettaBasicType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.TYPE_PARAMETER: {
				TypeParameter typeParameter = (TypeParameter)theEObject;
				T result = caseTypeParameter(typeParameter);
				if (result == null) result = caseRosettaSymbol(typeParameter);
				if (result == null) result = caseRosettaTyped(typeParameter);
				if (result == null) result = caseRosettaDefinable(typeParameter);
				if (result == null) result = caseRosettaNamed(typeParameter);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_SYNONYM_SOURCE: {
				RosettaSynonymSource rosettaSynonymSource = (RosettaSynonymSource)theEObject;
				T result = caseRosettaSynonymSource(rosettaSynonymSource);
				if (result == null) result = caseRosettaRootElement(rosettaSynonymSource);
				if (result == null) result = caseRosettaNamed(rosettaSynonymSource);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_RECORD_TYPE: {
				RosettaRecordType rosettaRecordType = (RosettaRecordType)theEObject;
				T result = caseRosettaRecordType(rosettaRecordType);
				if (result == null) result = caseRosettaBuiltinType(rosettaRecordType);
				if (result == null) result = caseRosettaType(rosettaRecordType);
				if (result == null) result = caseRosettaDefinable(rosettaRecordType);
				if (result == null) result = caseRosettaRootElement(rosettaRecordType);
				if (result == null) result = caseRosettaNamed(rosettaRecordType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_RECORD_FEATURE: {
				RosettaRecordFeature rosettaRecordFeature = (RosettaRecordFeature)theEObject;
				T result = caseRosettaRecordFeature(rosettaRecordFeature);
				if (result == null) result = caseRosettaTypedFeature(rosettaRecordFeature);
				if (result == null) result = caseRosettaFeature(rosettaRecordFeature);
				if (result == null) result = caseRosettaTyped(rosettaRecordFeature);
				if (result == null) result = caseRosettaNamed(rosettaRecordFeature);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_EXTERNAL_FUNCTION: {
				RosettaExternalFunction rosettaExternalFunction = (RosettaExternalFunction)theEObject;
				T result = caseRosettaExternalFunction(rosettaExternalFunction);
				if (result == null) result = caseRosettaRootElement(rosettaExternalFunction);
				if (result == null) result = caseRosettaTyped(rosettaExternalFunction);
				if (result == null) result = caseRosettaCallableWithArgs(rosettaExternalFunction);
				if (result == null) result = caseRosettaDefinable(rosettaExternalFunction);
				if (result == null) result = caseRosettaSymbol(rosettaExternalFunction);
				if (result == null) result = caseRosettaNamed(rosettaExternalFunction);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_PARAMETER: {
				RosettaParameter rosettaParameter = (RosettaParameter)theEObject;
				T result = caseRosettaParameter(rosettaParameter);
				if (result == null) result = caseRosettaTyped(rosettaParameter);
				if (result == null) result = caseRosettaNamed(rosettaParameter);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_TYPE_ALIAS: {
				RosettaTypeAlias rosettaTypeAlias = (RosettaTypeAlias)theEObject;
				T result = caseRosettaTypeAlias(rosettaTypeAlias);
				if (result == null) result = caseRosettaType(rosettaTypeAlias);
				if (result == null) result = caseRosettaTyped(rosettaTypeAlias);
				if (result == null) result = caseRosettaDefinable(rosettaTypeAlias);
				if (result == null) result = caseParametrizedRosettaType(rosettaTypeAlias);
				if (result == null) result = caseRosettaRootElement(rosettaTypeAlias);
				if (result == null) result = caseRosettaNamed(rosettaTypeAlias);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_META_TYPE: {
				RosettaMetaType rosettaMetaType = (RosettaMetaType)theEObject;
				T result = caseRosettaMetaType(rosettaMetaType);
				if (result == null) result = caseRosettaTypedFeature(rosettaMetaType);
				if (result == null) result = caseRosettaType(rosettaMetaType);
				if (result == null) result = caseRosettaRootElement(rosettaMetaType);
				if (result == null) result = caseRosettaFeature(rosettaMetaType);
				if (result == null) result = caseRosettaTyped(rosettaMetaType);
				if (result == null) result = caseRosettaNamed(rosettaMetaType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_ENUMERATION: {
				RosettaEnumeration rosettaEnumeration = (RosettaEnumeration)theEObject;
				T result = caseRosettaEnumeration(rosettaEnumeration);
				if (result == null) result = caseRosettaType(rosettaEnumeration);
				if (result == null) result = caseRosettaDefinable(rosettaEnumeration);
				if (result == null) result = caseReferences(rosettaEnumeration);
				if (result == null) result = caseRosettaSymbol(rosettaEnumeration);
				if (result == null) result = caseRosettaRootElement(rosettaEnumeration);
				if (result == null) result = caseRosettaNamed(rosettaEnumeration);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_ENUM_VALUE: {
				RosettaEnumValue rosettaEnumValue = (RosettaEnumValue)theEObject;
				T result = caseRosettaEnumValue(rosettaEnumValue);
				if (result == null) result = caseRosettaDefinable(rosettaEnumValue);
				if (result == null) result = caseRosettaFeature(rosettaEnumValue);
				if (result == null) result = caseReferences(rosettaEnumValue);
				if (result == null) result = caseRosettaNamed(rosettaEnumValue);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_ENUM_VALUE_REFERENCE: {
				RosettaEnumValueReference rosettaEnumValueReference = (RosettaEnumValueReference)theEObject;
				T result = caseRosettaEnumValueReference(rosettaEnumValueReference);
				if (result == null) result = caseRosettaMapTestExpression(rosettaEnumValueReference);
				if (result == null) result = caseRosettaMapTest(rosettaEnumValueReference);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_CARDINALITY: {
				RosettaCardinality rosettaCardinality = (RosettaCardinality)theEObject;
				T result = caseRosettaCardinality(rosettaCardinality);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_SYNONYM_BASE: {
				RosettaSynonymBase rosettaSynonymBase = (RosettaSynonymBase)theEObject;
				T result = caseRosettaSynonymBase(rosettaSynonymBase);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_SYNONYM_VALUE_BASE: {
				RosettaSynonymValueBase rosettaSynonymValueBase = (RosettaSynonymValueBase)theEObject;
				T result = caseRosettaSynonymValueBase(rosettaSynonymValueBase);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_CLASS_SYNONYM: {
				RosettaClassSynonym rosettaClassSynonym = (RosettaClassSynonym)theEObject;
				T result = caseRosettaClassSynonym(rosettaClassSynonym);
				if (result == null) result = caseRosettaSynonymBase(rosettaClassSynonym);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_SYNONYM: {
				RosettaSynonym rosettaSynonym = (RosettaSynonym)theEObject;
				T result = caseRosettaSynonym(rosettaSynonym);
				if (result == null) result = caseRosettaSynonymBase(rosettaSynonym);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_SYNONYM_BODY: {
				RosettaSynonymBody rosettaSynonymBody = (RosettaSynonymBody)theEObject;
				T result = caseRosettaSynonymBody(rosettaSynonymBody);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_MERGE_SYNONYM_VALUE: {
				RosettaMergeSynonymValue rosettaMergeSynonymValue = (RosettaMergeSynonymValue)theEObject;
				T result = caseRosettaMergeSynonymValue(rosettaMergeSynonymValue);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_ENUM_SYNONYM: {
				RosettaEnumSynonym rosettaEnumSynonym = (RosettaEnumSynonym)theEObject;
				T result = caseRosettaEnumSynonym(rosettaEnumSynonym);
				if (result == null) result = caseRosettaSynonymBase(rosettaEnumSynonym);
				if (result == null) result = caseRosettaDefinable(rosettaEnumSynonym);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_DOC_REFERENCE: {
				RosettaDocReference rosettaDocReference = (RosettaDocReference)theEObject;
				T result = caseRosettaDocReference(rosettaDocReference);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.REGULATORY_DOCUMENT_REFERENCE: {
				RegulatoryDocumentReference regulatoryDocumentReference = (RegulatoryDocumentReference)theEObject;
				T result = caseRegulatoryDocumentReference(regulatoryDocumentReference);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_SEGMENT_REF: {
				RosettaSegmentRef rosettaSegmentRef = (RosettaSegmentRef)theEObject;
				T result = caseRosettaSegmentRef(rosettaSegmentRef);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.DOCUMENT_RATIONALE: {
				DocumentRationale documentRationale = (DocumentRationale)theEObject;
				T result = caseDocumentRationale(documentRationale);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_BODY: {
				RosettaBody rosettaBody = (RosettaBody)theEObject;
				T result = caseRosettaBody(rosettaBody);
				if (result == null) result = caseRosettaRootElement(rosettaBody);
				if (result == null) result = caseRosettaNamed(rosettaBody);
				if (result == null) result = caseRosettaDefinable(rosettaBody);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_CORPUS: {
				RosettaCorpus rosettaCorpus = (RosettaCorpus)theEObject;
				T result = caseRosettaCorpus(rosettaCorpus);
				if (result == null) result = caseRosettaRootElement(rosettaCorpus);
				if (result == null) result = caseRosettaNamed(rosettaCorpus);
				if (result == null) result = caseRosettaDefinable(rosettaCorpus);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_SEGMENT: {
				RosettaSegment rosettaSegment = (RosettaSegment)theEObject;
				T result = caseRosettaSegment(rosettaSegment);
				if (result == null) result = caseRosettaRootElement(rosettaSegment);
				if (result == null) result = caseRosettaNamed(rosettaSegment);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_MAP_TEST: {
				RosettaMapTest rosettaMapTest = (RosettaMapTest)theEObject;
				T result = caseRosettaMapTest(rosettaMapTest);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_MAP_TEST_EXPRESSION: {
				RosettaMapTestExpression rosettaMapTestExpression = (RosettaMapTestExpression)theEObject;
				T result = caseRosettaMapTestExpression(rosettaMapTestExpression);
				if (result == null) result = caseRosettaMapTest(rosettaMapTestExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_MAP_PATH_VALUE: {
				RosettaMapPathValue rosettaMapPathValue = (RosettaMapPathValue)theEObject;
				T result = caseRosettaMapPathValue(rosettaMapPathValue);
				if (result == null) result = caseRosettaMapTestExpression(rosettaMapPathValue);
				if (result == null) result = caseRosettaMapTest(rosettaMapPathValue);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_MAP_TEST_EXISTS_EXPRESSION: {
				RosettaMapTestExistsExpression rosettaMapTestExistsExpression = (RosettaMapTestExistsExpression)theEObject;
				T result = caseRosettaMapTestExistsExpression(rosettaMapTestExistsExpression);
				if (result == null) result = caseRosettaMapTestExpression(rosettaMapTestExistsExpression);
				if (result == null) result = caseRosettaMapTest(rosettaMapTestExistsExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_MAP_TEST_ABSENT_EXPRESSION: {
				RosettaMapTestAbsentExpression rosettaMapTestAbsentExpression = (RosettaMapTestAbsentExpression)theEObject;
				T result = caseRosettaMapTestAbsentExpression(rosettaMapTestAbsentExpression);
				if (result == null) result = caseRosettaMapTestExpression(rosettaMapTestAbsentExpression);
				if (result == null) result = caseRosettaMapTest(rosettaMapTestAbsentExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_MAP_TEST_EQUALITY_OPERATION: {
				RosettaMapTestEqualityOperation rosettaMapTestEqualityOperation = (RosettaMapTestEqualityOperation)theEObject;
				T result = caseRosettaMapTestEqualityOperation(rosettaMapTestEqualityOperation);
				if (result == null) result = caseRosettaMapTestExpression(rosettaMapTestEqualityOperation);
				if (result == null) result = caseRosettaMapTest(rosettaMapTestEqualityOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_MAP_TEST_FUNC: {
				RosettaMapTestFunc rosettaMapTestFunc = (RosettaMapTestFunc)theEObject;
				T result = caseRosettaMapTestFunc(rosettaMapTestFunc);
				if (result == null) result = caseRosettaMapTestExpression(rosettaMapTestFunc);
				if (result == null) result = caseRosettaMapTest(rosettaMapTestFunc);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_ATTRIBUTE_REFERENCE_SEGMENT: {
				RosettaAttributeReferenceSegment rosettaAttributeReferenceSegment = (RosettaAttributeReferenceSegment)theEObject;
				T result = caseRosettaAttributeReferenceSegment(rosettaAttributeReferenceSegment);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_DATA_REFERENCE: {
				RosettaDataReference rosettaDataReference = (RosettaDataReference)theEObject;
				T result = caseRosettaDataReference(rosettaDataReference);
				if (result == null) result = caseRosettaAttributeReferenceSegment(rosettaDataReference);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_ATTRIBUTE_REFERENCE: {
				RosettaAttributeReference rosettaAttributeReference = (RosettaAttributeReference)theEObject;
				T result = caseRosettaAttributeReference(rosettaAttributeReference);
				if (result == null) result = caseRosettaAttributeReferenceSegment(rosettaAttributeReference);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_MAPPING: {
				RosettaMapping rosettaMapping = (RosettaMapping)theEObject;
				T result = caseRosettaMapping(rosettaMapping);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_MAPPING_INSTANCE: {
				RosettaMappingInstance rosettaMappingInstance = (RosettaMappingInstance)theEObject;
				T result = caseRosettaMappingInstance(rosettaMappingInstance);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_MAPPING_PATH_TESTS: {
				RosettaMappingPathTests rosettaMappingPathTests = (RosettaMappingPathTests)theEObject;
				T result = caseRosettaMappingPathTests(rosettaMappingPathTests);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_MAP_PATH: {
				RosettaMapPath rosettaMapPath = (RosettaMapPath)theEObject;
				T result = caseRosettaMapPath(rosettaMapPath);
				if (result == null) result = caseRosettaMapTest(rosettaMapPath);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_MAP_ROSETTA_PATH: {
				RosettaMapRosettaPath rosettaMapRosettaPath = (RosettaMapRosettaPath)theEObject;
				T result = caseRosettaMapRosettaPath(rosettaMapRosettaPath);
				if (result == null) result = caseRosettaMapTest(rosettaMapRosettaPath);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_QUALIFIABLE_CONFIGURATION: {
				RosettaQualifiableConfiguration rosettaQualifiableConfiguration = (RosettaQualifiableConfiguration)theEObject;
				T result = caseRosettaQualifiableConfiguration(rosettaQualifiableConfiguration);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.EXTERNAL_ANNOTATION_SOURCE: {
				ExternalAnnotationSource externalAnnotationSource = (ExternalAnnotationSource)theEObject;
				T result = caseExternalAnnotationSource(externalAnnotationSource);
				if (result == null) result = caseRosettaRootElement(externalAnnotationSource);
				if (result == null) result = caseRosettaNamed(externalAnnotationSource);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_EXTERNAL_REF: {
				RosettaExternalRef rosettaExternalRef = (RosettaExternalRef)theEObject;
				T result = caseRosettaExternalRef(rosettaExternalRef);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_EXTERNAL_CLASS: {
				RosettaExternalClass rosettaExternalClass = (RosettaExternalClass)theEObject;
				T result = caseRosettaExternalClass(rosettaExternalClass);
				if (result == null) result = caseRosettaExternalRef(rosettaExternalClass);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_EXTERNAL_ENUM: {
				RosettaExternalEnum rosettaExternalEnum = (RosettaExternalEnum)theEObject;
				T result = caseRosettaExternalEnum(rosettaExternalEnum);
				if (result == null) result = caseRosettaExternalRef(rosettaExternalEnum);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE: {
				RosettaExternalRegularAttribute rosettaExternalRegularAttribute = (RosettaExternalRegularAttribute)theEObject;
				T result = caseRosettaExternalRegularAttribute(rosettaExternalRegularAttribute);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_EXTERNAL_ENUM_VALUE: {
				RosettaExternalEnumValue rosettaExternalEnumValue = (RosettaExternalEnumValue)theEObject;
				T result = caseRosettaExternalEnumValue(rosettaExternalEnumValue);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_EXTERNAL_CLASS_SYNONYM: {
				RosettaExternalClassSynonym rosettaExternalClassSynonym = (RosettaExternalClassSynonym)theEObject;
				T result = caseRosettaExternalClassSynonym(rosettaExternalClassSynonym);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_EXTERNAL_SYNONYM: {
				RosettaExternalSynonym rosettaExternalSynonym = (RosettaExternalSynonym)theEObject;
				T result = caseRosettaExternalSynonym(rosettaExternalSynonym);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_EXTERNAL_SYNONYM_SOURCE: {
				RosettaExternalSynonymSource rosettaExternalSynonymSource = (RosettaExternalSynonymSource)theEObject;
				T result = caseRosettaExternalSynonymSource(rosettaExternalSynonymSource);
				if (result == null) result = caseExternalAnnotationSource(rosettaExternalSynonymSource);
				if (result == null) result = caseRosettaSynonymSource(rosettaExternalSynonymSource);
				if (result == null) result = caseRosettaRootElement(rosettaExternalSynonymSource);
				if (result == null) result = caseRosettaNamed(rosettaExternalSynonymSource);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_EXTERNAL_RULE_SOURCE: {
				RosettaExternalRuleSource rosettaExternalRuleSource = (RosettaExternalRuleSource)theEObject;
				T result = caseRosettaExternalRuleSource(rosettaExternalRuleSource);
				if (result == null) result = caseExternalAnnotationSource(rosettaExternalRuleSource);
				if (result == null) result = caseRosettaRootElement(rosettaExternalRuleSource);
				if (result == null) result = caseRosettaNamed(rosettaExternalRuleSource);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_REPORT: {
				RosettaReport rosettaReport = (RosettaReport)theEObject;
				T result = caseRosettaReport(rosettaReport);
				if (result == null) result = caseRosettaRootElement(rosettaReport);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RosettaPackage.ROSETTA_RULE: {
				RosettaRule rosettaRule = (RosettaRule)theEObject;
				T result = caseRosettaRule(rosettaRule);
				if (result == null) result = caseRosettaRootElement(rosettaRule);
				if (result == null) result = caseRosettaCallableWithArgs(rosettaRule);
				if (result == null) result = caseRosettaDefinable(rosettaRule);
				if (result == null) result = caseReferences(rosettaRule);
				if (result == null) result = caseRosettaSymbol(rosettaRule);
				if (result == null) result = caseRosettaNamed(rosettaRule);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Model</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Model</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaModel(RosettaModel object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Import</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Import</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseImport(Import object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Definable</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Definable</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaDefinable(RosettaDefinable object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Named</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Named</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaNamed(RosettaNamed object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Typed</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Typed</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaTyped(RosettaTyped object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Feature</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Feature</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaFeature(RosettaFeature object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Typed Feature</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Typed Feature</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaTypedFeature(RosettaTypedFeature object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Symbol</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Symbol</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaSymbol(RosettaSymbol object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Callable With Args</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Callable With Args</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaCallableWithArgs(RosettaCallableWithArgs object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Root Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Root Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaRootElement(RosettaRootElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Feature Owner</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Feature Owner</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaFeatureOwner(RosettaFeatureOwner object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaType(RosettaType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Parametrized Rosetta Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Parametrized Rosetta Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseParametrizedRosettaType(ParametrizedRosettaType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Type Call</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Type Call</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTypeCall(TypeCall object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Type Call Argument</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Type Call Argument</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTypeCallArgument(TypeCallArgument object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Builtin Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Builtin Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaBuiltinType(RosettaBuiltinType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Basic Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Basic Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaBasicType(RosettaBasicType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Type Parameter</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Type Parameter</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTypeParameter(TypeParameter object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Synonym Source</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Synonym Source</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaSynonymSource(RosettaSynonymSource object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Record Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Record Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaRecordType(RosettaRecordType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Record Feature</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Record Feature</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaRecordFeature(RosettaRecordFeature object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>External Function</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>External Function</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaExternalFunction(RosettaExternalFunction object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Parameter</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Parameter</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaParameter(RosettaParameter object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Type Alias</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Type Alias</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaTypeAlias(RosettaTypeAlias object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Meta Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Meta Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaMetaType(RosettaMetaType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Enumeration</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Enumeration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaEnumeration(RosettaEnumeration object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Enum Value</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Enum Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaEnumValue(RosettaEnumValue object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Enum Value Reference</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Enum Value Reference</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaEnumValueReference(RosettaEnumValueReference object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Cardinality</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Cardinality</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaCardinality(RosettaCardinality object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Synonym Base</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Synonym Base</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaSynonymBase(RosettaSynonymBase object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Synonym Value Base</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Synonym Value Base</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaSynonymValueBase(RosettaSynonymValueBase object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Class Synonym</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Class Synonym</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaClassSynonym(RosettaClassSynonym object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Synonym</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Synonym</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaSynonym(RosettaSynonym object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Synonym Body</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Synonym Body</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaSynonymBody(RosettaSynonymBody object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Merge Synonym Value</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Merge Synonym Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaMergeSynonymValue(RosettaMergeSynonymValue object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Enum Synonym</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Enum Synonym</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaEnumSynonym(RosettaEnumSynonym object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Doc Reference</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Doc Reference</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaDocReference(RosettaDocReference object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Regulatory Document Reference</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Regulatory Document Reference</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRegulatoryDocumentReference(RegulatoryDocumentReference object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Segment Ref</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Segment Ref</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaSegmentRef(RosettaSegmentRef object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Document Rationale</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Document Rationale</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDocumentRationale(DocumentRationale object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Body</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Body</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaBody(RosettaBody object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Corpus</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Corpus</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaCorpus(RosettaCorpus object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Segment</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Segment</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaSegment(RosettaSegment object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Map Test</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Map Test</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaMapTest(RosettaMapTest object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Map Test Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Map Test Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaMapTestExpression(RosettaMapTestExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Map Path Value</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Map Path Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaMapPathValue(RosettaMapPathValue object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Map Test Exists Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Map Test Exists Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaMapTestExistsExpression(RosettaMapTestExistsExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Map Test Absent Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Map Test Absent Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaMapTestAbsentExpression(RosettaMapTestAbsentExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Map Test Equality Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Map Test Equality Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaMapTestEqualityOperation(RosettaMapTestEqualityOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Map Test Func</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Map Test Func</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaMapTestFunc(RosettaMapTestFunc object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Attribute Reference Segment</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Attribute Reference Segment</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaAttributeReferenceSegment(RosettaAttributeReferenceSegment object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Data Reference</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Data Reference</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaDataReference(RosettaDataReference object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Attribute Reference</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Attribute Reference</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaAttributeReference(RosettaAttributeReference object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Mapping</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Mapping</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaMapping(RosettaMapping object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Mapping Instance</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Mapping Instance</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaMappingInstance(RosettaMappingInstance object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Mapping Path Tests</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Mapping Path Tests</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaMappingPathTests(RosettaMappingPathTests object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Map Path</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Map Path</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaMapPath(RosettaMapPath object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Map Rosetta Path</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Map Rosetta Path</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaMapRosettaPath(RosettaMapRosettaPath object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Qualifiable Configuration</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Qualifiable Configuration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaQualifiableConfiguration(RosettaQualifiableConfiguration object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>External Annotation Source</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>External Annotation Source</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseExternalAnnotationSource(ExternalAnnotationSource object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>External Ref</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>External Ref</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaExternalRef(RosettaExternalRef object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>External Class</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>External Class</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaExternalClass(RosettaExternalClass object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>External Enum</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>External Enum</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaExternalEnum(RosettaExternalEnum object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>External Regular Attribute</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>External Regular Attribute</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaExternalRegularAttribute(RosettaExternalRegularAttribute object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>External Enum Value</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>External Enum Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaExternalEnumValue(RosettaExternalEnumValue object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>External Class Synonym</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>External Class Synonym</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaExternalClassSynonym(RosettaExternalClassSynonym object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>External Synonym</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>External Synonym</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaExternalSynonym(RosettaExternalSynonym object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>External Synonym Source</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>External Synonym Source</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaExternalSynonymSource(RosettaExternalSynonymSource object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>External Rule Source</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>External Rule Source</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaExternalRuleSource(RosettaExternalRuleSource object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Report</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Report</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaReport(RosettaReport object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Rule</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Rule</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaRule(RosettaRule object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>References</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>References</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseReferences(References object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	@Override
	public T defaultCase(EObject object) {
		return null;
	}

} //RosettaSwitch
