/**
 * generated by Xtext 2.10.0
 */
package com.regnosys.rosetta.scoping;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.regnosys.rosetta.RosettaExtensions;
import com.regnosys.rosetta.generator.util.RosettaFunctionExtensions;
import com.regnosys.rosetta.rosetta.ParametrizedRosettaType;
import com.regnosys.rosetta.rosetta.RosettaAttributeReference;
import com.regnosys.rosetta.rosetta.RosettaEnumValueReference;
import com.regnosys.rosetta.rosetta.RosettaEnumeration;
import com.regnosys.rosetta.rosetta.RosettaExternalClass;
import com.regnosys.rosetta.rosetta.RosettaExternalEnum;
import com.regnosys.rosetta.rosetta.RosettaExternalEnumValue;
import com.regnosys.rosetta.rosetta.RosettaExternalRegularAttribute;
import com.regnosys.rosetta.rosetta.RosettaFeature;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.regnosys.rosetta.rosetta.RosettaNamed;
import com.regnosys.rosetta.rosetta.RosettaPackage;
import com.regnosys.rosetta.rosetta.RosettaSymbol;
import com.regnosys.rosetta.rosetta.RosettaType;
import com.regnosys.rosetta.rosetta.RosettaTypeAlias;
import com.regnosys.rosetta.rosetta.TypeCall;
import com.regnosys.rosetta.rosetta.expression.ChoiceOperation;
import com.regnosys.rosetta.rosetta.expression.ConstructorKeyValuePair;
import com.regnosys.rosetta.rosetta.expression.ExpressionPackage;
import com.regnosys.rosetta.rosetta.expression.InlineFunction;
import com.regnosys.rosetta.rosetta.expression.RosettaConstructorExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaDeepFeatureCall;
import com.regnosys.rosetta.rosetta.expression.RosettaFeatureCall;
import com.regnosys.rosetta.rosetta.expression.RosettaSymbolReference;
import com.regnosys.rosetta.rosetta.simple.Annotated;
import com.regnosys.rosetta.rosetta.simple.Annotation;
import com.regnosys.rosetta.rosetta.simple.AnnotationRef;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Condition;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.rosetta.simple.Function;
import com.regnosys.rosetta.rosetta.simple.FunctionDispatch;
import com.regnosys.rosetta.rosetta.simple.Operation;
import com.regnosys.rosetta.rosetta.simple.Segment;
import com.regnosys.rosetta.rosetta.simple.ShortcutDeclaration;
import com.regnosys.rosetta.rosetta.simple.SimplePackage;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.RosettaTypeProvider;
import com.regnosys.rosetta.utils.DeepFeatureCallUtil;
import com.regnosys.rosetta.utils.RosettaConfigExtension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.impl.AliasedEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.FilteringScope;
import org.eclipse.xtext.scoping.impl.ImportNormalizer;
import org.eclipse.xtext.scoping.impl.ImportedNamespaceAwareLocalScopeProvider;
import org.eclipse.xtext.scoping.impl.SimpleScope;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * This class contains custom scoping description.
 * 
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#scoping
 * on how and when to use it.
 */
@SuppressWarnings("all")
public class RosettaScopeProvider extends ImportedNamespaceAwareLocalScopeProvider {
  public static final String LIB_NAMESPACE = "com.rosetta.model";

  private static Logger LOGGER = LoggerFactory.getLogger(RosettaScopeProvider.class);

  @Inject
  private RosettaTypeProvider typeProvider;

  @Inject
  @Extension
  private RosettaExtensions _rosettaExtensions;

  @Inject
  @Extension
  private RosettaConfigExtension configs;

  @Inject
  @Extension
  private RosettaFunctionExtensions _rosettaFunctionExtensions;

  @Inject
  @Extension
  private DeepFeatureCallUtil _deepFeatureCallUtil;

  @Override
  public IScope getScope(final EObject context, final EReference reference) {
    try {
      boolean _matched = false;
      if (Objects.equal(reference, RosettaPackage.Literals.TYPE_CALL_ARGUMENT__PARAMETER)) {
        _matched=true;
        if ((context instanceof TypeCall)) {
          final RosettaType type = ((TypeCall)context).getType();
          if ((type instanceof ParametrizedRosettaType)) {
            return Scopes.scopeFor(((ParametrizedRosettaType)type).getParameters());
          }
          return IScope.NULLSCOPE;
        }
      }
      if (!_matched) {
        if (Objects.equal(reference, ExpressionPackage.Literals.ROSETTA_FEATURE_CALL__FEATURE)) {
          _matched=true;
          if ((context instanceof RosettaFeatureCall)) {
            return this.createExtendedFeatureScope(((RosettaFeatureCall)context).getReceiver(), this.typeProvider.getRType(((RosettaFeatureCall)context).getReceiver()));
          }
          return IScope.NULLSCOPE;
        }
      }
      if (!_matched) {
        if (Objects.equal(reference, ExpressionPackage.Literals.ROSETTA_DEEP_FEATURE_CALL__FEATURE)) {
          _matched=true;
          if ((context instanceof RosettaDeepFeatureCall)) {
            return this.createDeepFeatureScope(this.typeProvider.getRType(((RosettaDeepFeatureCall)context).getReceiver()));
          }
          return IScope.NULLSCOPE;
        }
      }
      if (!_matched) {
        if (Objects.equal(reference, ExpressionPackage.Literals.CHOICE_OPERATION__ATTRIBUTES)) {
          _matched=true;
          if ((context instanceof ChoiceOperation)) {
            return this.createExtendedFeatureScope(((ChoiceOperation)context).getArgument(), this.typeProvider.getRType(((ChoiceOperation)context).getArgument()));
          }
          return IScope.NULLSCOPE;
        }
      }
      if (!_matched) {
        if (Objects.equal(reference, RosettaPackage.Literals.ROSETTA_ATTRIBUTE_REFERENCE__ATTRIBUTE)) {
          _matched=true;
          if ((context instanceof RosettaAttributeReference)) {
            return this.createExtendedFeatureScope(((RosettaAttributeReference)context).getReceiver(), this.typeProvider.getRTypeOfAttributeReference(((RosettaAttributeReference)context).getReceiver()));
          }
          return IScope.NULLSCOPE;
        }
      }
      if (!_matched) {
        if (Objects.equal(reference, ExpressionPackage.Literals.CONSTRUCTOR_KEY_VALUE_PAIR__KEY)) {
          _matched=true;
          if ((context instanceof ConstructorKeyValuePair)) {
            EObject _eContainer = ((ConstructorKeyValuePair)context).eContainer();
            final RosettaConstructorExpression constructor = ((RosettaConstructorExpression) _eContainer);
            return Scopes.scopeFor(this._rosettaExtensions.allFeatures(this.typeProvider.getRType(constructor), context));
          }
          return IScope.NULLSCOPE;
        }
      }
      if (!_matched) {
        if (Objects.equal(reference, SimplePackage.Literals.OPERATION__ASSIGN_ROOT)) {
          _matched=true;
          if ((context instanceof Operation)) {
            final ArrayList<EObject> outAndAliases = CollectionLiterals.<EObject>newArrayList();
            final Attribute out = this._rosettaFunctionExtensions.getOutput(((Operation)context).getFunction());
            if ((out != null)) {
              outAndAliases.add(out);
            }
            outAndAliases.addAll(((Operation)context).getFunction().getShortcuts());
            return Scopes.scopeFor(outAndAliases);
          }
          return IScope.NULLSCOPE;
        }
      }
      if (!_matched) {
        if (Objects.equal(reference, SimplePackage.Literals.SEGMENT__ATTRIBUTE)) {
          _matched=true;
          boolean _matched_1 = false;
          if (context instanceof Operation) {
            _matched_1=true;
            final RType receiverType = this.typeProvider.getRTypeOfSymbol(((Operation)context).getAssignRoot());
            return Scopes.scopeFor(this._rosettaExtensions.allFeatures(receiverType, context));
          }
          if (!_matched_1) {
            if (context instanceof Segment) {
              _matched_1=true;
              final Segment prev = ((Segment)context).getPrev();
              if ((prev != null)) {
                boolean _isResolved = this._rosettaExtensions.isResolved(prev.getAttribute());
                if (_isResolved) {
                  final RType receiverType = this.typeProvider.getRTypeOfSymbol(prev.getAttribute());
                  return Scopes.scopeFor(this._rosettaExtensions.allFeatures(receiverType, context));
                }
              }
              EObject _eContainer_1 = ((Segment)context).eContainer();
              if ((_eContainer_1 instanceof Operation)) {
                return this.getScope(((Segment)context).eContainer(), reference);
              }
              return this.defaultScope(context, reference);
            }
          }
          return this.defaultScope(context, reference);
        }
      }
      if (!_matched) {
        if (Objects.equal(reference, ExpressionPackage.Literals.ROSETTA_SYMBOL_REFERENCE__SYMBOL)) {
          _matched=true;
          if ((context instanceof Operation)) {
            final Function function = ((Operation)context).getFunction();
            final ArrayList<Attribute> inputsAndOutputs = CollectionLiterals.<Attribute>newArrayList();
            boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(function.getInputs());
            boolean _not = (!_isNullOrEmpty);
            if (_not) {
              inputsAndOutputs.addAll(function.getInputs());
            }
            Attribute _output = function.getOutput();
            boolean _tripleNotEquals = (_output != null);
            if (_tripleNotEquals) {
              inputsAndOutputs.add(function.getOutput());
            }
            return Scopes.scopeFor(inputsAndOutputs);
          } else {
            final Iterable<? extends RosettaFeature> implicitFeatures = this.typeProvider.findFeaturesOfImplicitVariable(context);
            final InlineFunction inline = EcoreUtil2.<InlineFunction>getContainerOfType(context, InlineFunction.class);
            if ((inline != null)) {
              final IScope ps = this.getSymbolParentScope(context, reference, IScope.NULLSCOPE);
              return ReversedSimpleScope.scopeFor(implicitFeatures, ps);
            }
            final Function container = EcoreUtil2.<Function>getContainerOfType(context, Function.class);
            if ((container != null)) {
              final Predicate<IEObjectDescription> _function = (IEObjectDescription descr) -> {
                EClass _eClass = descr.getEClass();
                return (_eClass != SimplePackage.Literals.DATA);
              };
              final IScope ps_1 = this.filteredScope(this.getSymbolParentScope(context, reference, IScope.NULLSCOPE), _function);
              return ReversedSimpleScope.scopeFor(implicitFeatures, ps_1);
            }
            final IScope ps_2 = this.getSymbolParentScope(context, reference, this.defaultScope(context, reference));
            return ReversedSimpleScope.scopeFor(implicitFeatures, ps_2);
          }
        }
      }
      if (!_matched) {
        if (Objects.equal(reference, RosettaPackage.Literals.ROSETTA_ENUM_VALUE_REFERENCE__VALUE)) {
          _matched=true;
          if ((context instanceof RosettaEnumValueReference)) {
            return Scopes.scopeFor(this._rosettaExtensions.getAllEnumValues(((RosettaEnumValueReference)context).getEnumeration()));
          }
          return IScope.NULLSCOPE;
        }
      }
      if (!_matched) {
        if (Objects.equal(reference, RosettaPackage.Literals.ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE__ATTRIBUTE_REF)) {
          _matched=true;
          if ((context instanceof RosettaExternalRegularAttribute)) {
            EObject _eContainer_1 = ((RosettaExternalRegularAttribute)context).eContainer();
            final RosettaType classRef = ((RosettaExternalClass) _eContainer_1).getTypeRef();
            if ((classRef instanceof Data)) {
              return Scopes.scopeFor(this._rosettaExtensions.getAllAttributes(((Data)classRef)));
            }
          }
          return IScope.NULLSCOPE;
        }
      }
      if (!_matched) {
        if (Objects.equal(reference, RosettaPackage.Literals.ROSETTA_EXTERNAL_ENUM_VALUE__ENUM_REF)) {
          _matched=true;
          if ((context instanceof RosettaExternalEnumValue)) {
            EObject _eContainer_2 = ((RosettaExternalEnumValue)context).eContainer();
            final RosettaType enumRef = ((RosettaExternalEnum) _eContainer_2).getTypeRef();
            if ((enumRef instanceof RosettaEnumeration)) {
              return Scopes.scopeFor(this._rosettaExtensions.getAllEnumValues(((RosettaEnumeration)enumRef)));
            }
          }
          return IScope.NULLSCOPE;
        }
      }
      if (!_matched) {
        if (Objects.equal(reference, SimplePackage.Literals.ANNOTATION_REF__ATTRIBUTE)) {
          _matched=true;
          if ((context instanceof AnnotationRef)) {
            final Annotation annoRef = ((AnnotationRef)context).getAnnotation();
            return Scopes.scopeFor(annoRef.getAttributes());
          }
          return IScope.NULLSCOPE;
        }
      }
      if (!_matched) {
        if (Objects.equal(reference, SimplePackage.Literals.FUNCTION_DISPATCH__ATTRIBUTE)) {
          _matched=true;
          if ((context instanceof FunctionDispatch)) {
            return Scopes.scopeFor(this._rosettaFunctionExtensions.getInputs(((Function)context)));
          }
          return IScope.NULLSCOPE;
        }
      }
      if (!_matched) {
        if (Objects.equal(reference, RosettaPackage.Literals.ROSETTA_EXTERNAL_RULE_SOURCE__SUPER_SOURCES)) {
          _matched=true;
          final Predicate<IEObjectDescription> _function_1 = (IEObjectDescription it) -> {
            EClass _eClass = it.getEClass();
            return Objects.equal(_eClass, RosettaPackage.Literals.ROSETTA_EXTERNAL_RULE_SOURCE);
          };
          return this.filteredScope(this.defaultScope(context, reference), _function_1);
        }
      }
      return this.defaultScope(context, reference);
    } catch (final Throwable _t) {
      if (_t instanceof Exception) {
        final Exception e = (Exception)_t;
        String _message = e.getMessage();
        String _plus = ("Error scoping rosetta - \"" + _message);
        String _plus_1 = (_plus + "\" see debug logging for full trace");
        RosettaScopeProvider.LOGGER.error(_plus_1);
        RosettaScopeProvider.LOGGER.debug("Full trace of error ", e);
        return IScope.NULLSCOPE;
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
  }

  @Override
  protected List<ImportNormalizer> getImplicitImports(final boolean ignoreCase) {
    ImportNormalizer _createImportedNamespaceResolver = this.createImportedNamespaceResolver((RosettaScopeProvider.LIB_NAMESPACE + ".*"), ignoreCase);
    return Collections.<ImportNormalizer>unmodifiableList(CollectionLiterals.<ImportNormalizer>newArrayList(_createImportedNamespaceResolver));
  }

  @Override
  protected List<ImportNormalizer> internalGetImportedNamespaceResolvers(final EObject context, final boolean ignoreCase) {
    List<ImportNormalizer> _xifexpression = null;
    if ((context instanceof RosettaModel)) {
      final List<ImportNormalizer> imports = super.internalGetImportedNamespaceResolvers(context, ignoreCase);
      imports.add(
        this.doCreateImportNormalizer(this.getQualifiedNameConverter().toQualifiedName(((RosettaModel)context).getName()), true, ignoreCase));
      return imports;
    } else {
      _xifexpression = CollectionLiterals.<ImportNormalizer>emptyList();
    }
    return _xifexpression;
  }

  private IScope defaultScope(final EObject object, final EReference reference) {
    final Predicate<IEObjectDescription> _function = (IEObjectDescription it) -> {
      EClass _eClass = it.getEClass();
      return (_eClass != SimplePackage.Literals.FUNCTION_DISPATCH);
    };
    return this.filteredScope(super.getScope(object, reference), _function);
  }

  private IScope getSymbolParentScope(final EObject object, final EReference reference, final IScope outer) {
    IScope _xblockexpression = null;
    {
      EObject _eContainer = object.eContainer();
      boolean _tripleEquals = (_eContainer == null);
      if (_tripleEquals) {
        return this.defaultScope(object, reference);
      }
      final IScope parentScope = this.getSymbolParentScope(object.eContainer(), reference, outer);
      IScope _switchResult = null;
      boolean _matched = false;
      if (object instanceof InlineFunction) {
        _matched=true;
        return Scopes.scopeFor(((InlineFunction)object).getParameters(), parentScope);
      }
      if (!_matched) {
        if (object instanceof Function) {
          _matched=true;
          final ArrayList<EObject> features = CollectionLiterals.<EObject>newArrayList();
          features.addAll(this._rosettaFunctionExtensions.getInputs(((Function)object)));
          final Attribute out = this._rosettaFunctionExtensions.getOutput(((Function)object));
          if ((out != null)) {
            features.add(this._rosettaFunctionExtensions.getOutput(((Function)object)));
          }
          features.addAll(((Function)object).getShortcuts());
          return Scopes.scopeFor(features, parentScope);
        }
      }
      if (!_matched) {
        if (object instanceof ShortcutDeclaration) {
          _matched=true;
          final Predicate<IEObjectDescription> _function = (IEObjectDescription descr) -> {
            String _string = descr.getQualifiedName().toString();
            String _name = ((ShortcutDeclaration)object).getName();
            return (!Objects.equal(_string, _name));
          };
          _switchResult = this.filteredScope(parentScope, _function);
        }
      }
      if (!_matched) {
        if (object instanceof RosettaTypeAlias) {
          _matched=true;
          _switchResult = Scopes.scopeFor(((RosettaTypeAlias)object).getParameters(), parentScope);
        }
      }
      if (!_matched) {
        if (object instanceof Condition) {
          _matched=true;
          final Predicate<IEObjectDescription> _function = (IEObjectDescription descr) -> {
            return (((Condition)object).isPostCondition() || (descr.getEObjectOrProxy().eContainingFeature() != SimplePackage.Literals.FUNCTION__OUTPUT));
          };
          _switchResult = this.filteredScope(parentScope, _function);
        }
      }
      if (!_matched) {
        if (object instanceof RosettaModel) {
          _matched=true;
          final Predicate<IEObjectDescription> _function = (IEObjectDescription descr) -> {
            return Collections.<EClass>unmodifiableSet(CollectionLiterals.<EClass>newHashSet(SimplePackage.Literals.DATA, RosettaPackage.Literals.ROSETTA_ENUMERATION, SimplePackage.Literals.FUNCTION, RosettaPackage.Literals.ROSETTA_EXTERNAL_FUNCTION, RosettaPackage.Literals.ROSETTA_RULE)).contains(descr.getEClass());
          };
          _switchResult = this.filteredScope(this.defaultScope(object, reference), _function);
        }
      }
      if (!_matched) {
        _switchResult = parentScope;
      }
      _xblockexpression = _switchResult;
    }
    return _xblockexpression;
  }

  private IScope filteredScope(final IScope scope, final Predicate<IEObjectDescription> filter) {
    return new FilteringScope(scope, filter);
  }

  private IScope createExtendedFeatureScope(final EObject receiver, final RType receiverType) {
    final List<IEObjectDescription> allPosibilities = CollectionLiterals.<IEObjectDescription>newArrayList();
    final Function1<RosettaFeature, EObjectDescription> _function = (RosettaFeature it) -> {
      QualifiedName _create = QualifiedName.create(it.getName());
      return new EObjectDescription(_create, it, null);
    };
    Iterables.<IEObjectDescription>addAll(allPosibilities, 
      IterableExtensions.map(this._rosettaExtensions.allFeatures(receiverType, receiver), _function));
    RosettaNamed _xifexpression = null;
    if ((receiver instanceof RosettaFeatureCall)) {
      _xifexpression = ((RosettaFeatureCall)receiver).getFeature();
    } else {
      RosettaSymbol _xifexpression_1 = null;
      if ((receiver instanceof RosettaSymbolReference)) {
        _xifexpression_1 = ((RosettaSymbolReference)receiver).getSymbol();
      }
      _xifexpression = _xifexpression_1;
    }
    final RosettaNamed feature = _xifexpression;
    if ((feature instanceof Attribute)) {
      final Function1<AnnotationRef, String> _function_1 = (AnnotationRef it) -> {
        Attribute _attribute = it.getAttribute();
        String _name = null;
        if (_attribute!=null) {
          _name=_attribute.getName();
        }
        return _name;
      };
      final List<String> metas = IterableExtensions.<String>toList(IterableExtensions.<String>filterNull(IterableExtensions.<AnnotationRef, String>map(this._rosettaExtensions.metaAnnotations(((Annotated)feature)), _function_1)));
      if (((metas != null) && (!metas.isEmpty()))) {
        final Function1<IEObjectDescription, Boolean> _function_2 = (IEObjectDescription it) -> {
          return Boolean.valueOf(metas.contains(it.getName().getLastSegment().toString()));
        };
        final Function1<IEObjectDescription, AliasedEObjectDescription> _function_3 = (IEObjectDescription it) -> {
          QualifiedName _create = QualifiedName.create(it.getName().getLastSegment());
          return new AliasedEObjectDescription(_create, it);
        };
        Iterables.<IEObjectDescription>addAll(allPosibilities, 
          IterableExtensions.<IEObjectDescription, AliasedEObjectDescription>map(IterableExtensions.<IEObjectDescription>filter(this.configs.findMetaTypes(feature), _function_2), _function_3));
      }
    }
    return new SimpleScope(allPosibilities);
  }

  private IScope createDeepFeatureScope(final RType receiverType) {
    if ((receiverType instanceof RDataType)) {
      return Scopes.scopeFor(this._deepFeatureCallUtil.findDeepFeatures(((RDataType)receiverType)));
    }
    return IScope.NULLSCOPE;
  }
}
