package com.regnosys.rosetta.typing;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.regnosys.rosetta.interpreter.RosettaInterpreter;
import com.regnosys.rosetta.interpreter.RosettaValue;
import com.regnosys.rosetta.rosetta.RosettaCardinality;
import com.regnosys.rosetta.rosetta.RosettaEnumValue;
import com.regnosys.rosetta.rosetta.RosettaEnumeration;
import com.regnosys.rosetta.rosetta.RosettaFeature;
import com.regnosys.rosetta.rosetta.RosettaPackage;
import com.regnosys.rosetta.rosetta.RosettaRecordType;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.rosetta.simple.SimplePackage;
import com.regnosys.rosetta.types.RAliasType;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.REnumType;
import com.regnosys.rosetta.types.RListType;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.RTypeFunction;
import com.regnosys.rosetta.types.TypeFactory;
import com.regnosys.rosetta.types.TypeValidationUtil;
import com.regnosys.rosetta.types.builtin.RBasicType;
import com.regnosys.rosetta.types.builtin.RBuiltinTypeService;
import com.regnosys.rosetta.types.builtin.RNumberType;
import com.regnosys.rosetta.types.builtin.RRecordType;
import com.regnosys.rosetta.types.builtin.RStringType;
import com.regnosys.rosetta.utils.ExpressionHelper;
import com.regnosys.rosetta.utils.ImplicitVariableUtil;
import com.regnosys.rosetta.utils.RosettaSimpleSystemSolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xsemantics.runtime.ErrorInformation;
import org.eclipse.xsemantics.runtime.RuleApplicationTrace;
import org.eclipse.xsemantics.runtime.RuleFailedException;
import org.eclipse.xsemantics.runtime.XsemanticsRuntimeSystem;
import org.eclipse.xtext.util.PolymorphicDispatcher;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class RosettaTypingAuxiliary extends XsemanticsRuntimeSystem {
  public static final String ANCESTORS = "com.regnosys.rosetta.typing.Ancestors";

  public static final String ANCESTORENUMS = "com.regnosys.rosetta.typing.AncestorEnums";

  public static final String OVERLAP = "com.regnosys.rosetta.typing.Overlap";

  public static final String JOIN = "com.regnosys.rosetta.typing.Join";

  public static final String UNION = "com.regnosys.rosetta.typing.Union";

  public static final String LISTJOIN = "com.regnosys.rosetta.typing.ListJoin";

  public static final String ALLATTRIBUTES = "com.regnosys.rosetta.typing.AllAttributes";

  public static final String ALLENUMVALUES = "com.regnosys.rosetta.typing.AllEnumValues";

  public static final String MAYBEEMPTY = "com.regnosys.rosetta.typing.MayBeEmpty";

  public static final String KEEPTYPEALIASIFPOSSIBLE = "com.regnosys.rosetta.typing.KeepTypeAliasIfPossible";

  public static final String ALLFEATURES = "com.regnosys.rosetta.typing.AllFeatures";

  @Extension
  @Inject
  private TypeFactory typeFactory;

  @Extension
  @Inject
  private TypeValidationUtil util;

  @Extension
  @Inject
  private ExpressionHelper exprHelper;

  @Extension
  @Inject
  private ImplicitVariableUtil implicitVarUtil;

  @Extension
  @Inject
  private RBuiltinTypeService builtinTypes;

  @Inject
  private RosettaInterpreter interpreter;

  @Inject
  private RosettaSimpleSystemSolver systemSolver;

  private PolymorphicDispatcher<List<Data>> ancestorsDispatcher;

  private PolymorphicDispatcher<List<RosettaEnumeration>> ancestorEnumsDispatcher;

  private PolymorphicDispatcher<Boolean> overlapDispatcher;

  private PolymorphicDispatcher<RType> joinDispatcher;

  private PolymorphicDispatcher<RosettaCardinality> unionDispatcher;

  private PolymorphicDispatcher<RListType> listJoinDispatcher;

  private PolymorphicDispatcher<Iterable<Attribute>> allAttributesDispatcher;

  private PolymorphicDispatcher<Iterable<RosettaEnumValue>> allEnumValuesDispatcher;

  private PolymorphicDispatcher<Boolean> mayBeEmptyDispatcher;

  private PolymorphicDispatcher<RType> keepTypeAliasIfPossibleDispatcher;

  private PolymorphicDispatcher<Iterable<? extends RosettaFeature>> allFeaturesDispatcher;

  public RosettaTypingAuxiliary() {
    init();
  }

  public void init() {
    ancestorsDispatcher = buildPolymorphicDispatcher(
    	"ancestorsImpl", 2);
    ancestorEnumsDispatcher = buildPolymorphicDispatcher(
    	"ancestorEnumsImpl", 2);
    overlapDispatcher = buildPolymorphicDispatcher(
    	"overlapImpl", 3);
    joinDispatcher = buildPolymorphicDispatcher(
    	"joinImpl", 3);
    unionDispatcher = buildPolymorphicDispatcher(
    	"unionImpl", 3);
    listJoinDispatcher = buildPolymorphicDispatcher(
    	"listJoinImpl", 3);
    allAttributesDispatcher = buildPolymorphicDispatcher(
    	"allAttributesImpl", 2);
    allEnumValuesDispatcher = buildPolymorphicDispatcher(
    	"allEnumValuesImpl", 2);
    mayBeEmptyDispatcher = buildPolymorphicDispatcher(
    	"mayBeEmptyImpl", 2);
    keepTypeAliasIfPossibleDispatcher = buildPolymorphicDispatcher(
    	"keepTypeAliasIfPossibleImpl", 4);
    allFeaturesDispatcher = buildPolymorphicDispatcher(
    	"allFeaturesImpl", 3);
  }

  public TypeFactory getTypeFactory() {
    return this.typeFactory;
  }

  public void setTypeFactory(final TypeFactory typeFactory) {
    this.typeFactory = typeFactory;
  }

  public TypeValidationUtil getUtil() {
    return this.util;
  }

  public void setUtil(final TypeValidationUtil util) {
    this.util = util;
  }

  public ExpressionHelper getExprHelper() {
    return this.exprHelper;
  }

  public void setExprHelper(final ExpressionHelper exprHelper) {
    this.exprHelper = exprHelper;
  }

  public ImplicitVariableUtil getImplicitVarUtil() {
    return this.implicitVarUtil;
  }

  public void setImplicitVarUtil(final ImplicitVariableUtil implicitVarUtil) {
    this.implicitVarUtil = implicitVarUtil;
  }

  public RBuiltinTypeService getBuiltinTypes() {
    return this.builtinTypes;
  }

  public void setBuiltinTypes(final RBuiltinTypeService builtinTypes) {
    this.builtinTypes = builtinTypes;
  }

  public RosettaInterpreter getInterpreter() {
    return this.interpreter;
  }

  public void setInterpreter(final RosettaInterpreter interpreter) {
    this.interpreter = interpreter;
  }

  public RosettaSimpleSystemSolver getSystemSolver() {
    return this.systemSolver;
  }

  public void setSystemSolver(final RosettaSimpleSystemSolver systemSolver) {
    this.systemSolver = systemSolver;
  }

  public List<Data> ancestors(final Data t) throws RuleFailedException {
    return ancestors(null, t);
  }

  public List<Data> ancestors(final RuleApplicationTrace _trace_, final Data t) throws RuleFailedException {
    try {
    	return ancestorsInternal(_trace_, t);
    } catch (Exception _e_ancestors) {
    	throw extractRuleFailedException(_e_ancestors);
    }
  }

  public List<RosettaEnumeration> ancestorEnums(final RosettaEnumeration t) throws RuleFailedException {
    return ancestorEnums(null, t);
  }

  public List<RosettaEnumeration> ancestorEnums(final RuleApplicationTrace _trace_, final RosettaEnumeration t) throws RuleFailedException {
    try {
    	return ancestorEnumsInternal(_trace_, t);
    } catch (Exception _e_ancestorEnums) {
    	throw extractRuleFailedException(_e_ancestorEnums);
    }
  }

  public Boolean overlap(final RosettaCardinality c1, final RosettaCardinality c2) throws RuleFailedException {
    return overlap(null, c1, c2);
  }

  public Boolean overlap(final RuleApplicationTrace _trace_, final RosettaCardinality c1, final RosettaCardinality c2) throws RuleFailedException {
    try {
    	return overlapInternal(_trace_, c1, c2);
    } catch (Exception _e_overlap) {
    	throw extractRuleFailedException(_e_overlap);
    }
  }

  public RType join(final RType t1, final RType t2) throws RuleFailedException {
    return join(null, t1, t2);
  }

  public RType join(final RuleApplicationTrace _trace_, final RType t1, final RType t2) throws RuleFailedException {
    try {
    	return joinInternal(_trace_, t1, t2);
    } catch (Exception _e_join) {
    	throw extractRuleFailedException(_e_join);
    }
  }

  public RosettaCardinality union(final RosettaCardinality c1, final RosettaCardinality c2) throws RuleFailedException {
    return union(null, c1, c2);
  }

  public RosettaCardinality union(final RuleApplicationTrace _trace_, final RosettaCardinality c1, final RosettaCardinality c2) throws RuleFailedException {
    try {
    	return unionInternal(_trace_, c1, c2);
    } catch (Exception _e_union) {
    	throw extractRuleFailedException(_e_union);
    }
  }

  public RListType listJoin(final RListType t1, final RListType t2) throws RuleFailedException {
    return listJoin(null, t1, t2);
  }

  public RListType listJoin(final RuleApplicationTrace _trace_, final RListType t1, final RListType t2) throws RuleFailedException {
    try {
    	return listJoinInternal(_trace_, t1, t2);
    } catch (Exception _e_listJoin) {
    	throw extractRuleFailedException(_e_listJoin);
    }
  }

  public Iterable<Attribute> allAttributes(final Data d) throws RuleFailedException {
    return allAttributes(null, d);
  }

  public Iterable<Attribute> allAttributes(final RuleApplicationTrace _trace_, final Data d) throws RuleFailedException {
    try {
    	return allAttributesInternal(_trace_, d);
    } catch (Exception _e_allAttributes) {
    	throw extractRuleFailedException(_e_allAttributes);
    }
  }

  public Iterable<RosettaEnumValue> allEnumValues(final RosettaEnumeration d) throws RuleFailedException {
    return allEnumValues(null, d);
  }

  public Iterable<RosettaEnumValue> allEnumValues(final RuleApplicationTrace _trace_, final RosettaEnumeration d) throws RuleFailedException {
    try {
    	return allEnumValuesInternal(_trace_, d);
    } catch (Exception _e_allEnumValues) {
    	throw extractRuleFailedException(_e_allEnumValues);
    }
  }

  public Boolean mayBeEmpty(final Data d) throws RuleFailedException {
    return mayBeEmpty(null, d);
  }

  public Boolean mayBeEmpty(final RuleApplicationTrace _trace_, final Data d) throws RuleFailedException {
    try {
    	return mayBeEmptyInternal(_trace_, d);
    } catch (Exception _e_mayBeEmpty) {
    	throw extractRuleFailedException(_e_mayBeEmpty);
    }
  }

  public RType keepTypeAliasIfPossible(final RType t1, final RType t2, final BiFunction<RType, RType, RType> combineUnderlyingTypes) throws RuleFailedException {
    return keepTypeAliasIfPossible(null, t1, t2, combineUnderlyingTypes);
  }

  public RType keepTypeAliasIfPossible(final RuleApplicationTrace _trace_, final RType t1, final RType t2, final BiFunction<RType, RType, RType> combineUnderlyingTypes) throws RuleFailedException {
    try {
    	return keepTypeAliasIfPossibleInternal(_trace_, t1, t2, combineUnderlyingTypes);
    } catch (Exception _e_keepTypeAliasIfPossible) {
    	throw extractRuleFailedException(_e_keepTypeAliasIfPossible);
    }
  }

  public Iterable<? extends RosettaFeature> allFeatures(final RType t, final ResourceSet resourceSet) throws RuleFailedException {
    return allFeatures(null, t, resourceSet);
  }

  public Iterable<? extends RosettaFeature> allFeatures(final RuleApplicationTrace _trace_, final RType t, final ResourceSet resourceSet) throws RuleFailedException {
    try {
    	return allFeaturesInternal(_trace_, t, resourceSet);
    } catch (Exception _e_allFeatures) {
    	throw extractRuleFailedException(_e_allFeatures);
    }
  }

  protected List<Data> ancestorsInternal(final RuleApplicationTrace _trace_, final Data t) {
    try {
    	checkParamsNotNull(t);
    	return ancestorsDispatcher.invoke(_trace_, t);
    } catch (Exception _e_ancestors) {
    	sneakyThrowRuleFailedException(_e_ancestors);
    	return null;
    }
  }

  protected void ancestorsThrowException(final String _error, final String _issue, final Exception _ex, final Data t, final ErrorInformation[] _errorInformations) throws RuleFailedException {
    throwRuleFailedException(_error, _issue, _ex, _errorInformations);
  }

  protected List<RosettaEnumeration> ancestorEnumsInternal(final RuleApplicationTrace _trace_, final RosettaEnumeration t) {
    try {
    	checkParamsNotNull(t);
    	return ancestorEnumsDispatcher.invoke(_trace_, t);
    } catch (Exception _e_ancestorEnums) {
    	sneakyThrowRuleFailedException(_e_ancestorEnums);
    	return null;
    }
  }

  protected void ancestorEnumsThrowException(final String _error, final String _issue, final Exception _ex, final RosettaEnumeration t, final ErrorInformation[] _errorInformations) throws RuleFailedException {
    throwRuleFailedException(_error, _issue, _ex, _errorInformations);
  }

  protected Boolean overlapInternal(final RuleApplicationTrace _trace_, final RosettaCardinality c1, final RosettaCardinality c2) {
    try {
    	checkParamsNotNull(c1, c2);
    	return overlapDispatcher.invoke(_trace_, c1, c2);
    } catch (Exception _e_overlap) {
    	sneakyThrowRuleFailedException(_e_overlap);
    	return false;
    }
  }

  protected void overlapThrowException(final String _error, final String _issue, final Exception _ex, final RosettaCardinality c1, final RosettaCardinality c2, final ErrorInformation[] _errorInformations) throws RuleFailedException {
    throwRuleFailedException(_error, _issue, _ex, _errorInformations);
  }

  protected RType joinInternal(final RuleApplicationTrace _trace_, final RType t1, final RType t2) {
    try {
    	checkParamsNotNull(t1, t2);
    	return joinDispatcher.invoke(_trace_, t1, t2);
    } catch (Exception _e_join) {
    	sneakyThrowRuleFailedException(_e_join);
    	return null;
    }
  }

  protected void joinThrowException(final String _error, final String _issue, final Exception _ex, final RType t1, final RType t2, final ErrorInformation[] _errorInformations) throws RuleFailedException {
    throwRuleFailedException(_error, _issue, _ex, _errorInformations);
  }

  protected RosettaCardinality unionInternal(final RuleApplicationTrace _trace_, final RosettaCardinality c1, final RosettaCardinality c2) {
    try {
    	checkParamsNotNull(c1, c2);
    	return unionDispatcher.invoke(_trace_, c1, c2);
    } catch (Exception _e_union) {
    	sneakyThrowRuleFailedException(_e_union);
    	return null;
    }
  }

  protected void unionThrowException(final String _error, final String _issue, final Exception _ex, final RosettaCardinality c1, final RosettaCardinality c2, final ErrorInformation[] _errorInformations) throws RuleFailedException {
    throwRuleFailedException(_error, _issue, _ex, _errorInformations);
  }

  protected RListType listJoinInternal(final RuleApplicationTrace _trace_, final RListType t1, final RListType t2) {
    try {
    	checkParamsNotNull(t1, t2);
    	return listJoinDispatcher.invoke(_trace_, t1, t2);
    } catch (Exception _e_listJoin) {
    	sneakyThrowRuleFailedException(_e_listJoin);
    	return null;
    }
  }

  protected void listJoinThrowException(final String _error, final String _issue, final Exception _ex, final RListType t1, final RListType t2, final ErrorInformation[] _errorInformations) throws RuleFailedException {
    throwRuleFailedException(_error, _issue, _ex, _errorInformations);
  }

  protected Iterable<Attribute> allAttributesInternal(final RuleApplicationTrace _trace_, final Data d) {
    try {
    	checkParamsNotNull(d);
    	return allAttributesDispatcher.invoke(_trace_, d);
    } catch (Exception _e_allAttributes) {
    	sneakyThrowRuleFailedException(_e_allAttributes);
    	return null;
    }
  }

  protected void allAttributesThrowException(final String _error, final String _issue, final Exception _ex, final Data d, final ErrorInformation[] _errorInformations) throws RuleFailedException {
    throwRuleFailedException(_error, _issue, _ex, _errorInformations);
  }

  protected Iterable<RosettaEnumValue> allEnumValuesInternal(final RuleApplicationTrace _trace_, final RosettaEnumeration d) {
    try {
    	checkParamsNotNull(d);
    	return allEnumValuesDispatcher.invoke(_trace_, d);
    } catch (Exception _e_allEnumValues) {
    	sneakyThrowRuleFailedException(_e_allEnumValues);
    	return null;
    }
  }

  protected void allEnumValuesThrowException(final String _error, final String _issue, final Exception _ex, final RosettaEnumeration d, final ErrorInformation[] _errorInformations) throws RuleFailedException {
    throwRuleFailedException(_error, _issue, _ex, _errorInformations);
  }

  protected Boolean mayBeEmptyInternal(final RuleApplicationTrace _trace_, final Data d) {
    try {
    	checkParamsNotNull(d);
    	return mayBeEmptyDispatcher.invoke(_trace_, d);
    } catch (Exception _e_mayBeEmpty) {
    	sneakyThrowRuleFailedException(_e_mayBeEmpty);
    	return false;
    }
  }

  protected void mayBeEmptyThrowException(final String _error, final String _issue, final Exception _ex, final Data d, final ErrorInformation[] _errorInformations) throws RuleFailedException {
    throwRuleFailedException(_error, _issue, _ex, _errorInformations);
  }

  protected RType keepTypeAliasIfPossibleInternal(final RuleApplicationTrace _trace_, final RType t1, final RType t2, final BiFunction<RType, RType, RType> combineUnderlyingTypes) {
    try {
    	checkParamsNotNull(t1, t2, combineUnderlyingTypes);
    	return keepTypeAliasIfPossibleDispatcher.invoke(_trace_, t1, t2, combineUnderlyingTypes);
    } catch (Exception _e_keepTypeAliasIfPossible) {
    	sneakyThrowRuleFailedException(_e_keepTypeAliasIfPossible);
    	return null;
    }
  }

  protected void keepTypeAliasIfPossibleThrowException(final String _error, final String _issue, final Exception _ex, final RType t1, final RType t2, final BiFunction<RType, RType, RType> combineUnderlyingTypes, final ErrorInformation[] _errorInformations) throws RuleFailedException {
    throwRuleFailedException(_error, _issue, _ex, _errorInformations);
  }

  protected Iterable<? extends RosettaFeature> allFeaturesInternal(final RuleApplicationTrace _trace_, final RType t, final ResourceSet resourceSet) {
    try {
    	checkParamsNotNull(t, resourceSet);
    	return allFeaturesDispatcher.invoke(_trace_, t, resourceSet);
    } catch (Exception _e_allFeatures) {
    	sneakyThrowRuleFailedException(_e_allFeatures);
    	return null;
    }
  }

  protected void allFeaturesThrowException(final String _error, final String _issue, final Exception _ex, final RType t, final ResourceSet resourceSet, final ErrorInformation[] _errorInformations) throws RuleFailedException {
    throwRuleFailedException(_error, _issue, _ex, _errorInformations);
  }

  protected List<Data> ancestorsImpl(final RuleApplicationTrace _trace_, final Data t) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final List<Data> _result_ = applyAuxFunAncestors(_subtrace_, t);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("ancestors") + "(" + stringRep(t)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunAncestors) {
    	ancestorsThrowException(auxFunName("ancestors") + "(" + stringRep(t)+ ")",
    		ANCESTORS,
    		e_applyAuxFunAncestors, t, new ErrorInformation[] {new ErrorInformation(t)});
    	return null;
    }
  }

  protected List<Data> applyAuxFunAncestors(final RuleApplicationTrace _trace_, final Data t) throws RuleFailedException {
    return this.<Data>getAll(t, 
      SimplePackage.eINSTANCE.getData_SuperType(), 
      SimplePackage.eINSTANCE.getData_SuperType(), 
      Data.class);
  }

  protected List<RosettaEnumeration> ancestorEnumsImpl(final RuleApplicationTrace _trace_, final RosettaEnumeration t) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final List<RosettaEnumeration> _result_ = applyAuxFunAncestorEnums(_subtrace_, t);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("ancestorEnums") + "(" + stringRep(t)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunAncestorEnums) {
    	ancestorEnumsThrowException(auxFunName("ancestorEnums") + "(" + stringRep(t)+ ")",
    		ANCESTORENUMS,
    		e_applyAuxFunAncestorEnums, t, new ErrorInformation[] {new ErrorInformation(t)});
    	return null;
    }
  }

  protected List<RosettaEnumeration> applyAuxFunAncestorEnums(final RuleApplicationTrace _trace_, final RosettaEnumeration t) throws RuleFailedException {
    return this.<RosettaEnumeration>getAll(t, 
      RosettaPackage.eINSTANCE.getRosettaEnumeration_SuperType(), 
      RosettaPackage.eINSTANCE.getRosettaEnumeration_SuperType(), 
      RosettaEnumeration.class);
  }

  protected Boolean overlapImpl(final RuleApplicationTrace _trace_, final RosettaCardinality c1, final RosettaCardinality c2) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Boolean _result_ = applyAuxFunOverlap(_subtrace_, c1, c2);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("overlap") + "(" + stringRep(c1) + ", " + stringRep(c2)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunOverlap) {
    	overlapThrowException(auxFunName("overlap") + "(" + stringRep(c1) + ", " + stringRep(c2)+ ")",
    		OVERLAP,
    		e_applyAuxFunOverlap, c1, c2, new ErrorInformation[] {new ErrorInformation(c1), new ErrorInformation(c2)});
    	return false;
    }
  }

  protected Boolean applyAuxFunOverlap(final RuleApplicationTrace _trace_, final RosettaCardinality c1, final RosettaCardinality c2) throws RuleFailedException {
    /* (c1.unbounded || c1.sup >= c2.inf) && (c2.unbounded || c2.sup >= c1.inf) or return false */
    {
      RuleFailedException previousFailure = null;
      try {
        /* (c1.unbounded || c1.sup >= c2.inf) && (c2.unbounded || c2.sup >= c1.inf) */
        if (!((c1.isUnbounded() || (c1.getSup() >= c2.getInf())) && (c2.isUnbounded() || (c2.getSup() >= c1.getInf())))) {
          sneakyThrowRuleFailedException("(c1.unbounded || c1.sup >= c2.inf) && (c2.unbounded || c2.sup >= c1.inf)");
        }
      } catch (Exception e) {
        previousFailure = extractRuleFailedException(e);
        return Boolean.valueOf(false);
      }
    }
    return true;
  }

  protected RType joinImpl(final RuleApplicationTrace _trace_, final RDataType t1, final RDataType t2) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final RType _result_ = applyAuxFunJoin(_subtrace_, t1, t2);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("join") + "(" + stringRep(t1) + ", " + stringRep(t2)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunJoin) {
    	joinThrowException(auxFunName("join") + "(" + stringRep(t1) + ", " + stringRep(t2)+ ")",
    		JOIN,
    		e_applyAuxFunJoin, t1, t2, new ErrorInformation[] {});
    	return null;
    }
  }

  protected RType applyAuxFunJoin(final RuleApplicationTrace _trace_, final RDataType t1, final RDataType t2) throws RuleFailedException {
    final List<Data> st1 = this.ancestorsInternal(_trace_, t1.getData());
    st1.add(0, t1.getData());
    final List<Data> st2 = this.ancestorsInternal(_trace_, t2.getData());
    st2.add(0, t2.getData());
    final Function1<Data, Boolean> _function = (Data it) -> {
      return Boolean.valueOf(st1.contains(it));
    };
    final Data result = IterableExtensions.<Data>findFirst(st2, _function);
    if ((result == null)) {
      return this.builtinTypes.ANY;
    }
    return new RDataType(result);
  }

  protected RType joinImpl(final RuleApplicationTrace _trace_, final REnumType t1, final REnumType t2) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final RType _result_ = applyAuxFunJoin(_subtrace_, t1, t2);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("join") + "(" + stringRep(t1) + ", " + stringRep(t2)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunJoin) {
    	joinThrowException(auxFunName("join") + "(" + stringRep(t1) + ", " + stringRep(t2)+ ")",
    		JOIN,
    		e_applyAuxFunJoin, t1, t2, new ErrorInformation[] {});
    	return null;
    }
  }

  protected RType applyAuxFunJoin(final RuleApplicationTrace _trace_, final REnumType t1, final REnumType t2) throws RuleFailedException {
    final List<RosettaEnumeration> st1 = this.ancestorEnumsInternal(_trace_, t1.getEnumeration());
    st1.add(0, t1.getEnumeration());
    final List<RosettaEnumeration> st2 = this.ancestorEnumsInternal(_trace_, t2.getEnumeration());
    st2.add(0, t2.getEnumeration());
    final Function1<RosettaEnumeration, Boolean> _function = (RosettaEnumeration it) -> {
      return Boolean.valueOf(st1.contains(it));
    };
    final RosettaEnumeration result = IterableExtensions.<RosettaEnumeration>findFirst(st2, _function);
    if ((result == null)) {
      return this.builtinTypes.ANY;
    }
    return new REnumType(result);
  }

  protected RType joinImpl(final RuleApplicationTrace _trace_, final RNumberType t1, final RNumberType t2) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final RType _result_ = applyAuxFunJoin(_subtrace_, t1, t2);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("join") + "(" + stringRep(t1) + ", " + stringRep(t2)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunJoin) {
    	joinThrowException(auxFunName("join") + "(" + stringRep(t1) + ", " + stringRep(t2)+ ")",
    		JOIN,
    		e_applyAuxFunJoin, t1, t2, new ErrorInformation[] {});
    	return null;
    }
  }

  protected RType applyAuxFunJoin(final RuleApplicationTrace _trace_, final RNumberType t1, final RNumberType t2) throws RuleFailedException {
    return t1.join(t2);
  }

  protected RType joinImpl(final RuleApplicationTrace _trace_, final RStringType t1, final RStringType t2) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final RType _result_ = applyAuxFunJoin(_subtrace_, t1, t2);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("join") + "(" + stringRep(t1) + ", " + stringRep(t2)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunJoin) {
    	joinThrowException(auxFunName("join") + "(" + stringRep(t1) + ", " + stringRep(t2)+ ")",
    		JOIN,
    		e_applyAuxFunJoin, t1, t2, new ErrorInformation[] {});
    	return null;
    }
  }

  protected RType applyAuxFunJoin(final RuleApplicationTrace _trace_, final RStringType t1, final RStringType t2) throws RuleFailedException {
    return t1.join(t2);
  }

  protected RType joinImpl(final RuleApplicationTrace _trace_, final RBasicType t1, final RBasicType t2) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final RType _result_ = applyAuxFunJoin(_subtrace_, t1, t2);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("join") + "(" + stringRep(t1) + ", " + stringRep(t2)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunJoin) {
    	joinThrowException(auxFunName("join") + "(" + stringRep(t1) + ", " + stringRep(t2)+ ")",
    		JOIN,
    		e_applyAuxFunJoin, t1, t2, new ErrorInformation[] {});
    	return null;
    }
  }

  protected RType applyAuxFunJoin(final RuleApplicationTrace _trace_, final RBasicType t1, final RBasicType t2) throws RuleFailedException {
    boolean _equals = Objects.equal(t1, t2);
    if (_equals) {
      return t1;
    } else {
      boolean _equals_1 = Objects.equal(t1, this.builtinTypes.NOTHING);
      if (_equals_1) {
        return t2;
      } else {
        boolean _equals_2 = Objects.equal(t2, this.builtinTypes.NOTHING);
        if (_equals_2) {
          return t1;
        }
      }
    }
    return this.builtinTypes.ANY;
  }

  protected RType joinImpl(final RuleApplicationTrace _trace_, final RBasicType t1, final RType t2) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final RType _result_ = applyAuxFunJoin(_subtrace_, t1, t2);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("join") + "(" + stringRep(t1) + ", " + stringRep(t2)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunJoin) {
    	joinThrowException(auxFunName("join") + "(" + stringRep(t1) + ", " + stringRep(t2)+ ")",
    		JOIN,
    		e_applyAuxFunJoin, t1, t2, new ErrorInformation[] {});
    	return null;
    }
  }

  protected RType applyAuxFunJoin(final RuleApplicationTrace _trace_, final RBasicType t1, final RType t2) throws RuleFailedException {
    boolean _equals = Objects.equal(t1, t2);
    if (_equals) {
      return t1;
    } else {
      boolean _equals_1 = Objects.equal(t1, this.builtinTypes.NOTHING);
      if (_equals_1) {
        return t2;
      }
    }
    return this.builtinTypes.ANY;
  }

  protected RType joinImpl(final RuleApplicationTrace _trace_, final RType t1, final RBasicType t2) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final RType _result_ = applyAuxFunJoin(_subtrace_, t1, t2);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("join") + "(" + stringRep(t1) + ", " + stringRep(t2)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunJoin) {
    	joinThrowException(auxFunName("join") + "(" + stringRep(t1) + ", " + stringRep(t2)+ ")",
    		JOIN,
    		e_applyAuxFunJoin, t1, t2, new ErrorInformation[] {});
    	return null;
    }
  }

  protected RType applyAuxFunJoin(final RuleApplicationTrace _trace_, final RType t1, final RBasicType t2) throws RuleFailedException {
    boolean _equals = Objects.equal(t1, t2);
    if (_equals) {
      return t1;
    } else {
      boolean _equals_1 = Objects.equal(t2, this.builtinTypes.NOTHING);
      if (_equals_1) {
        return t1;
      }
    }
    return this.builtinTypes.ANY;
  }

  protected RType joinImpl(final RuleApplicationTrace _trace_, final RAliasType t1, final RAliasType t2) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final RType _result_ = applyAuxFunJoin(_subtrace_, t1, t2);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("join") + "(" + stringRep(t1) + ", " + stringRep(t2)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunJoin) {
    	joinThrowException(auxFunName("join") + "(" + stringRep(t1) + ", " + stringRep(t2)+ ")",
    		JOIN,
    		e_applyAuxFunJoin, t1, t2, new ErrorInformation[] {});
    	return null;
    }
  }

  protected RType applyAuxFunJoin(final RuleApplicationTrace _trace_, final RAliasType t1, final RAliasType t2) throws RuleFailedException {
    boolean _equals = Objects.equal(t1, t2);
    if (_equals) {
      return t1;
    } else {
      RTypeFunction _typeFunction = t1.getTypeFunction();
      RTypeFunction _typeFunction_1 = t2.getTypeFunction();
      boolean _equals_1 = Objects.equal(_typeFunction, _typeFunction_1);
      if (_equals_1) {
        final RTypeFunction typeFunc = t1.getTypeFunction();
        final RType underlyingJoin = this.joinInternal(_trace_, t1.getRefersTo(), t2.getRefersTo());
        final Optional<LinkedHashMap<String, RosettaValue>> aliasParams = typeFunc.reverse(underlyingJoin);
        final Function<LinkedHashMap<String, RosettaValue>, RType> _function = (LinkedHashMap<String, RosettaValue> it) -> {
          return new RAliasType(typeFunc, it, underlyingJoin);
        };
        return aliasParams.<RType>map(_function).orElse(underlyingJoin);
      } else {
        final ArrayList<RAliasType> superAliases = CollectionLiterals.<RAliasType>newArrayList();
        RType curr = t1;
        while ((curr instanceof RAliasType)) {
          boolean _add = superAliases.add(((RAliasType)curr));
          /* superAliases.add(curr) */
          if (!_add) {
            sneakyThrowRuleFailedException("superAliases.add(curr)");
          }
          curr = ((RAliasType)curr).getRefersTo();
        }
        curr = t2;
        while ((curr instanceof RAliasType)) {
          final RTypeFunction tf = ((RAliasType)curr).getTypeFunction();
          final Function1<RAliasType, Boolean> _function_1 = (RAliasType it) -> {
            RTypeFunction _typeFunction_2 = it.getTypeFunction();
            return Boolean.valueOf(Objects.equal(tf, _typeFunction_2));
          };
          final RAliasType match = IterableExtensions.<RAliasType>findFirst(superAliases, _function_1);
          if ((match != null)) {
            return this.joinInternal(_trace_, match, curr);
          }
          curr = ((RAliasType)curr).getRefersTo();
        }
        return this.joinInternal(_trace_, t1.getRefersTo(), t2.getRefersTo());
      }
    }
  }

  protected RType joinImpl(final RuleApplicationTrace _trace_, final RAliasType t1, final RType t2) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final RType _result_ = applyAuxFunJoin(_subtrace_, t1, t2);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("join") + "(" + stringRep(t1) + ", " + stringRep(t2)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunJoin) {
    	joinThrowException(auxFunName("join") + "(" + stringRep(t1) + ", " + stringRep(t2)+ ")",
    		JOIN,
    		e_applyAuxFunJoin, t1, t2, new ErrorInformation[] {});
    	return null;
    }
  }

  protected RType applyAuxFunJoin(final RuleApplicationTrace _trace_, final RAliasType t1, final RType t2) throws RuleFailedException {
    return this.joinInternal(_trace_, t1.getRefersTo(), t2);
  }

  protected RType joinImpl(final RuleApplicationTrace _trace_, final RType t1, final RAliasType t2) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final RType _result_ = applyAuxFunJoin(_subtrace_, t1, t2);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("join") + "(" + stringRep(t1) + ", " + stringRep(t2)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunJoin) {
    	joinThrowException(auxFunName("join") + "(" + stringRep(t1) + ", " + stringRep(t2)+ ")",
    		JOIN,
    		e_applyAuxFunJoin, t1, t2, new ErrorInformation[] {});
    	return null;
    }
  }

  protected RType applyAuxFunJoin(final RuleApplicationTrace _trace_, final RType t1, final RAliasType t2) throws RuleFailedException {
    return this.joinInternal(_trace_, t1, t2.getRefersTo());
  }

  protected RType joinImpl(final RuleApplicationTrace _trace_, final RAliasType t1, final RBasicType t2) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final RType _result_ = applyAuxFunJoin(_subtrace_, t1, t2);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("join") + "(" + stringRep(t1) + ", " + stringRep(t2)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunJoin) {
    	joinThrowException(auxFunName("join") + "(" + stringRep(t1) + ", " + stringRep(t2)+ ")",
    		JOIN,
    		e_applyAuxFunJoin, t1, t2, new ErrorInformation[] {});
    	return null;
    }
  }

  protected RType applyAuxFunJoin(final RuleApplicationTrace _trace_, final RAliasType t1, final RBasicType t2) throws RuleFailedException {
    boolean _equals = Objects.equal(t2, this.builtinTypes.NOTHING);
    if (_equals) {
      return t1;
    }
    return this.joinInternal(_trace_, t1.getRefersTo(), t2);
  }

  protected RType joinImpl(final RuleApplicationTrace _trace_, final RBasicType t1, final RAliasType t2) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final RType _result_ = applyAuxFunJoin(_subtrace_, t1, t2);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("join") + "(" + stringRep(t1) + ", " + stringRep(t2)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunJoin) {
    	joinThrowException(auxFunName("join") + "(" + stringRep(t1) + ", " + stringRep(t2)+ ")",
    		JOIN,
    		e_applyAuxFunJoin, t1, t2, new ErrorInformation[] {});
    	return null;
    }
  }

  protected RType applyAuxFunJoin(final RuleApplicationTrace _trace_, final RBasicType t1, final RAliasType t2) throws RuleFailedException {
    boolean _equals = Objects.equal(t1, this.builtinTypes.NOTHING);
    if (_equals) {
      return t2;
    }
    return this.joinInternal(_trace_, t1, t2.getRefersTo());
  }

  protected RType joinImpl(final RuleApplicationTrace _trace_, final RType t1, final RType t2) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final RType _result_ = applyAuxFunJoin(_subtrace_, t1, t2);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("join") + "(" + stringRep(t1) + ", " + stringRep(t2)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunJoin) {
    	joinThrowException(auxFunName("join") + "(" + stringRep(t1) + ", " + stringRep(t2)+ ")",
    		JOIN,
    		e_applyAuxFunJoin, t1, t2, new ErrorInformation[] {});
    	return null;
    }
  }

  protected RType applyAuxFunJoin(final RuleApplicationTrace _trace_, final RType t1, final RType t2) throws RuleFailedException {
    boolean _equals = Objects.equal(t1, t2);
    if (_equals) {
      return t1;
    }
    return this.builtinTypes.ANY;
  }

  protected RosettaCardinality unionImpl(final RuleApplicationTrace _trace_, final RosettaCardinality c1, final RosettaCardinality c2) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final RosettaCardinality _result_ = applyAuxFunUnion(_subtrace_, c1, c2);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("union") + "(" + stringRep(c1) + ", " + stringRep(c2)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunUnion) {
    	unionThrowException(auxFunName("union") + "(" + stringRep(c1) + ", " + stringRep(c2)+ ")",
    		UNION,
    		e_applyAuxFunUnion, c1, c2, new ErrorInformation[] {new ErrorInformation(c1), new ErrorInformation(c2)});
    	return null;
    }
  }

  protected RosettaCardinality applyAuxFunUnion(final RuleApplicationTrace _trace_, final RosettaCardinality c1, final RosettaCardinality c2) throws RuleFailedException {
    if ((c1.isUnbounded() || c2.isUnbounded())) {
      return this.typeFactory.createConstraint(Math.min(c1.getInf(), c2.getInf()));
    } else {
      return this.typeFactory.createConstraint(Math.min(c1.getInf(), c2.getInf()), Math.max(c1.getSup(), c2.getSup()));
    }
  }

  protected RListType listJoinImpl(final RuleApplicationTrace _trace_, final RListType t1, final RListType t2) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final RListType _result_ = applyAuxFunListJoin(_subtrace_, t1, t2);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("listJoin") + "(" + stringRep(t1) + ", " + stringRep(t2)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunListJoin) {
    	listJoinThrowException(auxFunName("listJoin") + "(" + stringRep(t1) + ", " + stringRep(t2)+ ")",
    		LISTJOIN,
    		e_applyAuxFunListJoin, t1, t2, new ErrorInformation[] {});
    	return null;
    }
  }

  protected RListType applyAuxFunListJoin(final RuleApplicationTrace _trace_, final RListType t1, final RListType t2) throws RuleFailedException {
    final RType sup = this.joinInternal(_trace_, t1.getItemType(), t2.getItemType());
    return this.typeFactory.createListType(sup, this.unionInternal(_trace_, t1.getConstraint(), t2.getConstraint()));
  }

  protected Iterable<Attribute> allAttributesImpl(final RuleApplicationTrace _trace_, final Data d) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Iterable<Attribute> _result_ = applyAuxFunAllAttributes(_subtrace_, d);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("allAttributes") + "(" + stringRep(d)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunAllAttributes) {
    	allAttributesThrowException(auxFunName("allAttributes") + "(" + stringRep(d)+ ")",
    		ALLATTRIBUTES,
    		e_applyAuxFunAllAttributes, d, new ErrorInformation[] {new ErrorInformation(d)});
    	return null;
    }
  }

  protected Iterable<Attribute> applyAuxFunAllAttributes(final RuleApplicationTrace _trace_, final Data d) throws RuleFailedException {
    Data _superType = d.getSuperType();
    boolean _tripleEquals = (_superType == null);
    if (_tripleEquals) {
      return d.getAttributes();
    } else {
      Iterable<Attribute> _allAttributes = this.allAttributesInternal(_trace_, d.getSuperType());
      EList<Attribute> _attributes = d.getAttributes();
      return Iterables.<Attribute>concat(_allAttributes, _attributes);
    }
  }

  protected Iterable<RosettaEnumValue> allEnumValuesImpl(final RuleApplicationTrace _trace_, final RosettaEnumeration e) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Iterable<RosettaEnumValue> _result_ = applyAuxFunAllEnumValues(_subtrace_, e);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("allEnumValues") + "(" + stringRep(e)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunAllEnumValues) {
    	allEnumValuesThrowException(auxFunName("allEnumValues") + "(" + stringRep(e)+ ")",
    		ALLENUMVALUES,
    		e_applyAuxFunAllEnumValues, e, new ErrorInformation[] {new ErrorInformation(e)});
    	return null;
    }
  }

  protected Iterable<RosettaEnumValue> applyAuxFunAllEnumValues(final RuleApplicationTrace _trace_, final RosettaEnumeration e) throws RuleFailedException {
    RosettaEnumeration _superType = e.getSuperType();
    boolean _tripleEquals = (_superType == null);
    if (_tripleEquals) {
      return e.getEnumValues();
    } else {
      Iterable<RosettaEnumValue> _allEnumValues = this.allEnumValuesInternal(_trace_, e.getSuperType());
      EList<RosettaEnumValue> _enumValues = e.getEnumValues();
      return Iterables.<RosettaEnumValue>concat(_allEnumValues, _enumValues);
    }
  }

  protected Boolean mayBeEmptyImpl(final RuleApplicationTrace _trace_, final Data d) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Boolean _result_ = applyAuxFunMayBeEmpty(_subtrace_, d);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("mayBeEmpty") + "(" + stringRep(d)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunMayBeEmpty) {
    	mayBeEmptyThrowException(auxFunName("mayBeEmpty") + "(" + stringRep(d)+ ")",
    		MAYBEEMPTY,
    		e_applyAuxFunMayBeEmpty, d, new ErrorInformation[] {new ErrorInformation(d)});
    	return false;
    }
  }

  protected Boolean applyAuxFunMayBeEmpty(final RuleApplicationTrace _trace_, final Data d) throws RuleFailedException {
    final Function1<Attribute, Boolean> _function = (Attribute it) -> {
      int _inf = it.getCard().getInf();
      return Boolean.valueOf((_inf == 0));
    };
    boolean _forall = IterableExtensions.<Attribute>forall(this.allAttributesInternal(_trace_, d), _function);
    /* d.allAttributes.forall[ card.inf === 0 ] */
    if (!_forall) {
      sneakyThrowRuleFailedException("d.allAttributes.forall[ card.inf === 0 ]");
    }
    return true;
  }

  protected RType keepTypeAliasIfPossibleImpl(final RuleApplicationTrace _trace_, final RAliasType t1, final RAliasType t2, final BiFunction<RType, RType, RType> combineUnderlyingTypes) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final RType _result_ = applyAuxFunKeepTypeAliasIfPossible(_subtrace_, t1, t2, combineUnderlyingTypes);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("keepTypeAliasIfPossible") + "(" + stringRep(t1) + ", " + stringRep(t2) + ", " + stringRep(combineUnderlyingTypes)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunKeepTypeAliasIfPossible) {
    	keepTypeAliasIfPossibleThrowException(auxFunName("keepTypeAliasIfPossible") + "(" + stringRep(t1) + ", " + stringRep(t2) + ", " + stringRep(combineUnderlyingTypes)+ ")",
    		KEEPTYPEALIASIFPOSSIBLE,
    		e_applyAuxFunKeepTypeAliasIfPossible, t1, t2, combineUnderlyingTypes, new ErrorInformation[] {});
    	return null;
    }
  }

  protected RType applyAuxFunKeepTypeAliasIfPossible(final RuleApplicationTrace _trace_, final RAliasType t1, final RAliasType t2, final BiFunction<RType, RType, RType> combineUnderlyingTypes) throws RuleFailedException {
    RTypeFunction _typeFunction = t1.getTypeFunction();
    RTypeFunction _typeFunction_1 = t2.getTypeFunction();
    boolean _equals = Objects.equal(_typeFunction, _typeFunction_1);
    if (_equals) {
      final RTypeFunction typeFunc = t1.getTypeFunction();
      final RType underlier = this.keepTypeAliasIfPossibleInternal(_trace_, t1.getRefersTo(), t2.getRefersTo(), combineUnderlyingTypes);
      final Function<LinkedHashMap<String, RosettaValue>, RType> _function = (LinkedHashMap<String, RosettaValue> args) -> {
        return new RAliasType(typeFunc, args, underlier);
      };
      return typeFunc.reverse(underlier).<RType>map(_function).orElse(underlier);
    } else {
      final ArrayList<RAliasType> superAliases = CollectionLiterals.<RAliasType>newArrayList();
      RType curr = t1;
      while ((curr instanceof RAliasType)) {
        boolean _add = superAliases.add(((RAliasType)curr));
        /* superAliases.add(curr) */
        if (!_add) {
          sneakyThrowRuleFailedException("superAliases.add(curr)");
        }
        curr = ((RAliasType)curr).getRefersTo();
      }
      curr = t2;
      while ((curr instanceof RAliasType)) {
        final RTypeFunction tf = ((RAliasType)curr).getTypeFunction();
        final Function1<RAliasType, Boolean> _function_1 = (RAliasType it) -> {
          RTypeFunction _typeFunction_2 = it.getTypeFunction();
          return Boolean.valueOf(Objects.equal(tf, _typeFunction_2));
        };
        final RAliasType match = IterableExtensions.<RAliasType>findFirst(superAliases, _function_1);
        if ((match != null)) {
          return this.keepTypeAliasIfPossibleInternal(_trace_, match, curr, combineUnderlyingTypes);
        }
        curr = ((RAliasType)curr).getRefersTo();
      }
      return this.keepTypeAliasIfPossibleInternal(_trace_, t1.getRefersTo(), t2.getRefersTo(), combineUnderlyingTypes);
    }
  }

  protected RType keepTypeAliasIfPossibleImpl(final RuleApplicationTrace _trace_, final RAliasType t1, final RType t2, final BiFunction<RType, RType, RType> combineUnderlyingTypes) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final RType _result_ = applyAuxFunKeepTypeAliasIfPossible(_subtrace_, t1, t2, combineUnderlyingTypes);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("keepTypeAliasIfPossible") + "(" + stringRep(t1) + ", " + stringRep(t2) + ", " + stringRep(combineUnderlyingTypes)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunKeepTypeAliasIfPossible) {
    	keepTypeAliasIfPossibleThrowException(auxFunName("keepTypeAliasIfPossible") + "(" + stringRep(t1) + ", " + stringRep(t2) + ", " + stringRep(combineUnderlyingTypes)+ ")",
    		KEEPTYPEALIASIFPOSSIBLE,
    		e_applyAuxFunKeepTypeAliasIfPossible, t1, t2, combineUnderlyingTypes, new ErrorInformation[] {});
    	return null;
    }
  }

  protected RType applyAuxFunKeepTypeAliasIfPossible(final RuleApplicationTrace _trace_, final RAliasType t1, final RType t2, final BiFunction<RType, RType, RType> combineUnderlyingTypes) throws RuleFailedException {
    return this.keepTypeAliasIfPossibleInternal(_trace_, t1.getRefersTo(), t2, combineUnderlyingTypes);
  }

  protected RType keepTypeAliasIfPossibleImpl(final RuleApplicationTrace _trace_, final RType t1, final RAliasType t2, final BiFunction<RType, RType, RType> combineUnderlyingTypes) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final RType _result_ = applyAuxFunKeepTypeAliasIfPossible(_subtrace_, t1, t2, combineUnderlyingTypes);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("keepTypeAliasIfPossible") + "(" + stringRep(t1) + ", " + stringRep(t2) + ", " + stringRep(combineUnderlyingTypes)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunKeepTypeAliasIfPossible) {
    	keepTypeAliasIfPossibleThrowException(auxFunName("keepTypeAliasIfPossible") + "(" + stringRep(t1) + ", " + stringRep(t2) + ", " + stringRep(combineUnderlyingTypes)+ ")",
    		KEEPTYPEALIASIFPOSSIBLE,
    		e_applyAuxFunKeepTypeAliasIfPossible, t1, t2, combineUnderlyingTypes, new ErrorInformation[] {});
    	return null;
    }
  }

  protected RType applyAuxFunKeepTypeAliasIfPossible(final RuleApplicationTrace _trace_, final RType t1, final RAliasType t2, final BiFunction<RType, RType, RType> combineUnderlyingTypes) throws RuleFailedException {
    return this.keepTypeAliasIfPossibleInternal(_trace_, t1, t2.getRefersTo(), combineUnderlyingTypes);
  }

  protected RType keepTypeAliasIfPossibleImpl(final RuleApplicationTrace _trace_, final RType t1, final RType t2, final BiFunction<RType, RType, RType> combineUnderlyingTypes) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final RType _result_ = applyAuxFunKeepTypeAliasIfPossible(_subtrace_, t1, t2, combineUnderlyingTypes);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("keepTypeAliasIfPossible") + "(" + stringRep(t1) + ", " + stringRep(t2) + ", " + stringRep(combineUnderlyingTypes)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunKeepTypeAliasIfPossible) {
    	keepTypeAliasIfPossibleThrowException(auxFunName("keepTypeAliasIfPossible") + "(" + stringRep(t1) + ", " + stringRep(t2) + ", " + stringRep(combineUnderlyingTypes)+ ")",
    		KEEPTYPEALIASIFPOSSIBLE,
    		e_applyAuxFunKeepTypeAliasIfPossible, t1, t2, combineUnderlyingTypes, new ErrorInformation[] {});
    	return null;
    }
  }

  protected RType applyAuxFunKeepTypeAliasIfPossible(final RuleApplicationTrace _trace_, final RType t1, final RType t2, final BiFunction<RType, RType, RType> combineUnderlyingTypes) throws RuleFailedException {
    return combineUnderlyingTypes.apply(t1, t2);
  }

  protected Iterable<? extends RosettaFeature> allFeaturesImpl(final RuleApplicationTrace _trace_, final RType t, final ResourceSet resourceSet) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Iterable<? extends RosettaFeature> _result_ = applyAuxFunAllFeatures(_subtrace_, t, resourceSet);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("allFeatures") + "(" + stringRep(t) + ", " + stringRep(resourceSet)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunAllFeatures) {
    	allFeaturesThrowException(auxFunName("allFeatures") + "(" + stringRep(t) + ", " + stringRep(resourceSet)+ ")",
    		ALLFEATURES,
    		e_applyAuxFunAllFeatures, t, resourceSet, new ErrorInformation[] {});
    	return null;
    }
  }

  protected Iterable<? extends RosettaFeature> applyAuxFunAllFeatures(final RuleApplicationTrace _trace_, final RType t, final ResourceSet resourceSet) throws RuleFailedException {
    Iterable<? extends RosettaFeature> _switchResult = null;
    boolean _matched = false;
    if (t instanceof RDataType) {
      _matched=true;
      _switchResult = this.allAttributesInternal(_trace_, ((RDataType)t).getData());
    }
    if (!_matched) {
      if (t instanceof REnumType) {
        _matched=true;
        _switchResult = this.allEnumValuesInternal(_trace_, ((REnumType)t).getEnumeration());
      }
    }
    if (!_matched) {
      if (t instanceof RRecordType) {
        _matched=true;
        List<? extends RosettaFeature> _xifexpression = null;
        if ((resourceSet != null)) {
          _xifexpression = this.builtinTypes.<RosettaRecordType>toRosettaType(t, RosettaRecordType.class, resourceSet).getFeatures();
        } else {
          _xifexpression = Collections.<RosettaFeature>unmodifiableList(CollectionLiterals.<RosettaFeature>newArrayList());
        }
        _switchResult = _xifexpression;
      }
    }
    if (!_matched) {
      _switchResult = Collections.<RosettaFeature>unmodifiableList(CollectionLiterals.<RosettaFeature>newArrayList());
    }
    return _switchResult;
  }
}
