package com.regnosys.rosetta.typing;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.regnosys.rosetta.interpreter.RosettaInterpreter;
import com.regnosys.rosetta.interpreter.RosettaInterpreterContext;
import com.regnosys.rosetta.rosetta.RosettaCardinality;
import com.regnosys.rosetta.rosetta.RosettaExternalFunction;
import com.regnosys.rosetta.rosetta.RosettaParameter;
import com.regnosys.rosetta.rosetta.RosettaRule;
import com.regnosys.rosetta.rosetta.RosettaSymbol;
import com.regnosys.rosetta.rosetta.TypeCall;
import com.regnosys.rosetta.rosetta.expression.ArithmeticOperation;
import com.regnosys.rosetta.rosetta.expression.CardinalityModifier;
import com.regnosys.rosetta.rosetta.expression.ChoiceOperation;
import com.regnosys.rosetta.rosetta.expression.ComparisonOperation;
import com.regnosys.rosetta.rosetta.expression.EqualityOperation;
import com.regnosys.rosetta.rosetta.expression.ExpressionPackage;
import com.regnosys.rosetta.rosetta.expression.ListLiteral;
import com.regnosys.rosetta.rosetta.expression.LogicalOperation;
import com.regnosys.rosetta.rosetta.expression.ModifiableBinaryOperation;
import com.regnosys.rosetta.rosetta.expression.OneOfOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaAbsentExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaBinaryOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaConditionalExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaExistsExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaOnlyExistsExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaSymbolReference;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.rosetta.simple.Function;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.RListType;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.TypeFactory;
import com.regnosys.rosetta.types.TypeValidationUtil;
import com.regnosys.rosetta.types.builtin.RBuiltinTypeService;
import com.regnosys.rosetta.utils.ExpressionHelper;
import com.regnosys.rosetta.utils.ImplicitVariableUtil;
import com.regnosys.rosetta.utils.RosettaSimpleSystemSolver;
import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xsemantics.runtime.ErrorInformation;
import org.eclipse.xsemantics.runtime.Result;
import org.eclipse.xsemantics.runtime.RuleApplicationTrace;
import org.eclipse.xsemantics.runtime.RuleFailedException;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.util.PolymorphicDispatcher;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.Functions.Function2;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class RosettaTypingChecking extends RosettaTyping {
  public static final String LISTSUBTYPECHECK = "com.regnosys.rosetta.typing.ListSubtypeCheck";

  public static final String LOOSELISTSUBTYPECHECK = "com.regnosys.rosetta.typing.LooseListSubtypeCheck";

  public static final String SUBTYPECHECK = "com.regnosys.rosetta.typing.SubtypeCheck";

  public static final String COMPARABLELISTTYPECHECK = "com.regnosys.rosetta.typing.ComparableListTypeCheck";

  public static final String COMPARABLETYPECHECK = "com.regnosys.rosetta.typing.ComparableTypeCheck";

  public static final String ONLYRIGHTISSINGULARCHECK = "com.regnosys.rosetta.typing.OnlyRightIsSingularCheck";

  public static final String LOOSEONLYRIGHTISSINGULARCHECK = "com.regnosys.rosetta.typing.LooseOnlyRightIsSingularCheck";

  public static final String CONSTRAINTCHECK = "com.regnosys.rosetta.typing.ConstraintCheck";

  public static final String LOOSECONSTRAINTCHECK = "com.regnosys.rosetta.typing.LooseConstraintCheck";

  public static final String NOTCONSTRAINTCHECK = "com.regnosys.rosetta.typing.NotConstraintCheck";

  public static final String ISLOOSERCONSTRAINTCHECK = "com.regnosys.rosetta.typing.IsLooserConstraintCheck";

  @Extension
  @Inject
  private TypeFactory typeFactory;

  @Extension
  @Inject
  private TypeValidationUtil util;

  @Extension
  @Inject
  private ExpressionHelper exprHelper;

  @Extension
  @Inject
  private ImplicitVariableUtil implicitVarUtil;

  @Extension
  @Inject
  private RBuiltinTypeService builtinTypes;

  @Inject
  private RosettaInterpreter interpreter;

  @Inject
  private RosettaSimpleSystemSolver systemSolver;

  private PolymorphicDispatcher<Boolean> listSubtypeCheckDispatcher;

  private PolymorphicDispatcher<Boolean> looseListSubtypeCheckDispatcher;

  private PolymorphicDispatcher<Boolean> subtypeCheckDispatcher;

  private PolymorphicDispatcher<Boolean> comparableListTypeCheckDispatcher;

  private PolymorphicDispatcher<Boolean> comparableTypeCheckDispatcher;

  private PolymorphicDispatcher<Boolean> onlyRightIsSingularCheckDispatcher;

  private PolymorphicDispatcher<Boolean> looseOnlyRightIsSingularCheckDispatcher;

  private PolymorphicDispatcher<Boolean> constraintCheckDispatcher;

  private PolymorphicDispatcher<Boolean> looseConstraintCheckDispatcher;

  private PolymorphicDispatcher<Boolean> notConstraintCheckDispatcher;

  private PolymorphicDispatcher<Boolean> isLooserConstraintCheckDispatcher;

  public RosettaTypingChecking() {
    init();
  }

  @Override
  public void init() {
    super.init();
    listSubtypeCheckDispatcher = buildPolymorphicDispatcher(
    	"listSubtypeCheckImpl", 3);
    looseListSubtypeCheckDispatcher = buildPolymorphicDispatcher(
    	"looseListSubtypeCheckImpl", 3);
    subtypeCheckDispatcher = buildPolymorphicDispatcher(
    	"subtypeCheckImpl", 3);
    comparableListTypeCheckDispatcher = buildPolymorphicDispatcher(
    	"comparableListTypeCheckImpl", 2);
    comparableTypeCheckDispatcher = buildPolymorphicDispatcher(
    	"comparableTypeCheckImpl", 2);
    onlyRightIsSingularCheckDispatcher = buildPolymorphicDispatcher(
    	"onlyRightIsSingularCheckImpl", 2);
    looseOnlyRightIsSingularCheckDispatcher = buildPolymorphicDispatcher(
    	"looseOnlyRightIsSingularCheckImpl", 2);
    constraintCheckDispatcher = buildPolymorphicDispatcher(
    	"constraintCheckImpl", 3);
    looseConstraintCheckDispatcher = buildPolymorphicDispatcher(
    	"looseConstraintCheckImpl", 3);
    notConstraintCheckDispatcher = buildPolymorphicDispatcher(
    	"notConstraintCheckImpl", 3);
    isLooserConstraintCheckDispatcher = buildPolymorphicDispatcher(
    	"isLooserConstraintCheckImpl", 3);
  }

  public TypeFactory getTypeFactory() {
    return this.typeFactory;
  }

  public void setTypeFactory(final TypeFactory typeFactory) {
    this.typeFactory = typeFactory;
  }

  public TypeValidationUtil getUtil() {
    return this.util;
  }

  public void setUtil(final TypeValidationUtil util) {
    this.util = util;
  }

  public ExpressionHelper getExprHelper() {
    return this.exprHelper;
  }

  public void setExprHelper(final ExpressionHelper exprHelper) {
    this.exprHelper = exprHelper;
  }

  public ImplicitVariableUtil getImplicitVarUtil() {
    return this.implicitVarUtil;
  }

  public void setImplicitVarUtil(final ImplicitVariableUtil implicitVarUtil) {
    this.implicitVarUtil = implicitVarUtil;
  }

  public RBuiltinTypeService getBuiltinTypes() {
    return this.builtinTypes;
  }

  public void setBuiltinTypes(final RBuiltinTypeService builtinTypes) {
    this.builtinTypes = builtinTypes;
  }

  public RosettaInterpreter getInterpreter() {
    return this.interpreter;
  }

  public void setInterpreter(final RosettaInterpreter interpreter) {
    this.interpreter = interpreter;
  }

  public RosettaSimpleSystemSolver getSystemSolver() {
    return this.systemSolver;
  }

  public void setSystemSolver(final RosettaSimpleSystemSolver systemSolver) {
    this.systemSolver = systemSolver;
  }

  public Boolean listSubtypeCheck(final RosettaExpression sourceObject, final RListType expected) throws RuleFailedException {
    return listSubtypeCheck(null, sourceObject, expected);
  }

  public Boolean listSubtypeCheck(final RuleApplicationTrace _trace_, final RosettaExpression sourceObject, final RListType expected) throws RuleFailedException {
    try {
    	return listSubtypeCheckInternal(_trace_, sourceObject, expected);
    } catch (Exception _e_listSubtypeCheck) {
    	throw extractRuleFailedException(_e_listSubtypeCheck);
    }
  }

  public Boolean looseListSubtypeCheck(final RosettaExpression sourceObject, final RListType expected) throws RuleFailedException {
    return looseListSubtypeCheck(null, sourceObject, expected);
  }

  public Boolean looseListSubtypeCheck(final RuleApplicationTrace _trace_, final RosettaExpression sourceObject, final RListType expected) throws RuleFailedException {
    try {
    	return looseListSubtypeCheckInternal(_trace_, sourceObject, expected);
    } catch (Exception _e_looseListSubtypeCheck) {
    	throw extractRuleFailedException(_e_looseListSubtypeCheck);
    }
  }

  public Boolean subtypeCheck(final RosettaExpression sourceObject, final RType expected) throws RuleFailedException {
    return subtypeCheck(null, sourceObject, expected);
  }

  public Boolean subtypeCheck(final RuleApplicationTrace _trace_, final RosettaExpression sourceObject, final RType expected) throws RuleFailedException {
    try {
    	return subtypeCheckInternal(_trace_, sourceObject, expected);
    } catch (Exception _e_subtypeCheck) {
    	throw extractRuleFailedException(_e_subtypeCheck);
    }
  }

  public Boolean comparableListTypeCheck(final RosettaBinaryOperation sourceObject) throws RuleFailedException {
    return comparableListTypeCheck(null, sourceObject);
  }

  public Boolean comparableListTypeCheck(final RuleApplicationTrace _trace_, final RosettaBinaryOperation sourceObject) throws RuleFailedException {
    try {
    	return comparableListTypeCheckInternal(_trace_, sourceObject);
    } catch (Exception _e_comparableListTypeCheck) {
    	throw extractRuleFailedException(_e_comparableListTypeCheck);
    }
  }

  public Boolean comparableTypeCheck(final RosettaBinaryOperation sourceObject) throws RuleFailedException {
    return comparableTypeCheck(null, sourceObject);
  }

  public Boolean comparableTypeCheck(final RuleApplicationTrace _trace_, final RosettaBinaryOperation sourceObject) throws RuleFailedException {
    try {
    	return comparableTypeCheckInternal(_trace_, sourceObject);
    } catch (Exception _e_comparableTypeCheck) {
    	throw extractRuleFailedException(_e_comparableTypeCheck);
    }
  }

  public Boolean onlyRightIsSingularCheck(final ModifiableBinaryOperation sourceObject) throws RuleFailedException {
    return onlyRightIsSingularCheck(null, sourceObject);
  }

  public Boolean onlyRightIsSingularCheck(final RuleApplicationTrace _trace_, final ModifiableBinaryOperation sourceObject) throws RuleFailedException {
    try {
    	return onlyRightIsSingularCheckInternal(_trace_, sourceObject);
    } catch (Exception _e_onlyRightIsSingularCheck) {
    	throw extractRuleFailedException(_e_onlyRightIsSingularCheck);
    }
  }

  public Boolean looseOnlyRightIsSingularCheck(final ModifiableBinaryOperation sourceObject) throws RuleFailedException {
    return looseOnlyRightIsSingularCheck(null, sourceObject);
  }

  public Boolean looseOnlyRightIsSingularCheck(final RuleApplicationTrace _trace_, final ModifiableBinaryOperation sourceObject) throws RuleFailedException {
    try {
    	return looseOnlyRightIsSingularCheckInternal(_trace_, sourceObject);
    } catch (Exception _e_looseOnlyRightIsSingularCheck) {
    	throw extractRuleFailedException(_e_looseOnlyRightIsSingularCheck);
    }
  }

  public Boolean constraintCheck(final RosettaExpression sourceObject, final RosettaCardinality expected) throws RuleFailedException {
    return constraintCheck(null, sourceObject, expected);
  }

  public Boolean constraintCheck(final RuleApplicationTrace _trace_, final RosettaExpression sourceObject, final RosettaCardinality expected) throws RuleFailedException {
    try {
    	return constraintCheckInternal(_trace_, sourceObject, expected);
    } catch (Exception _e_constraintCheck) {
    	throw extractRuleFailedException(_e_constraintCheck);
    }
  }

  public Boolean looseConstraintCheck(final RosettaExpression sourceObject, final RosettaCardinality expected) throws RuleFailedException {
    return looseConstraintCheck(null, sourceObject, expected);
  }

  public Boolean looseConstraintCheck(final RuleApplicationTrace _trace_, final RosettaExpression sourceObject, final RosettaCardinality expected) throws RuleFailedException {
    try {
    	return looseConstraintCheckInternal(_trace_, sourceObject, expected);
    } catch (Exception _e_looseConstraintCheck) {
    	throw extractRuleFailedException(_e_looseConstraintCheck);
    }
  }

  public Boolean notConstraintCheck(final RosettaExpression sourceObject, final RosettaCardinality notExpected) throws RuleFailedException {
    return notConstraintCheck(null, sourceObject, notExpected);
  }

  public Boolean notConstraintCheck(final RuleApplicationTrace _trace_, final RosettaExpression sourceObject, final RosettaCardinality notExpected) throws RuleFailedException {
    try {
    	return notConstraintCheckInternal(_trace_, sourceObject, notExpected);
    } catch (Exception _e_notConstraintCheck) {
    	throw extractRuleFailedException(_e_notConstraintCheck);
    }
  }

  public Boolean isLooserConstraintCheck(final RosettaExpression sourceObject, final RosettaCardinality expected) throws RuleFailedException {
    return isLooserConstraintCheck(null, sourceObject, expected);
  }

  public Boolean isLooserConstraintCheck(final RuleApplicationTrace _trace_, final RosettaExpression sourceObject, final RosettaCardinality expected) throws RuleFailedException {
    try {
    	return isLooserConstraintCheckInternal(_trace_, sourceObject, expected);
    } catch (Exception _e_isLooserConstraintCheck) {
    	throw extractRuleFailedException(_e_isLooserConstraintCheck);
    }
  }

  public Result<Boolean> checkLeftArithmetic(final ArithmeticOperation op) {
    return checkLeftArithmetic(null, op);
  }

  public Result<Boolean> checkLeftArithmetic(final RuleApplicationTrace _trace_, final ArithmeticOperation op) {
    try {
    	return checkLeftArithmeticInternal(_trace_, op);
    } catch (Exception _e_CheckLeftArithmetic) {
    	return resultForFailure(_e_CheckLeftArithmetic);
    }
  }

  protected Result<Boolean> checkLeftArithmeticInternal(final RuleApplicationTrace _trace_, final ArithmeticOperation op) throws RuleFailedException {
    String _operator = op.getOperator();
    boolean _equals = Objects.equal(_operator, "+");
    if (_equals) {
      /* { looseListSubtypeCheck(op.left, singleDate) } or { looseListSubtypeCheck(op.left, singleUnconstrainedString) } or { looseListSubtypeCheck(op.left, singleUnconstrainedNumber) } */
      {
        RuleFailedException previousFailure = null;
        try {
          /* looseListSubtypeCheck(op.left, singleDate) */
          if (!this.looseListSubtypeCheckInternal(_trace_, op.getLeft(), this.typeFactory.singleDate)) {
            sneakyThrowRuleFailedException("looseListSubtypeCheck(op.left, singleDate)");
          }
        } catch (Exception e) {
          previousFailure = extractRuleFailedException(e);
          /* { looseListSubtypeCheck(op.left, singleUnconstrainedString) } or { looseListSubtypeCheck(op.left, singleUnconstrainedNumber) } */
          {
            try {
              /* looseListSubtypeCheck(op.left, singleUnconstrainedString) */
              if (!this.looseListSubtypeCheckInternal(_trace_, op.getLeft(), this.typeFactory.singleUnconstrainedString)) {
                sneakyThrowRuleFailedException("looseListSubtypeCheck(op.left, singleUnconstrainedString)");
              }
            } catch (Exception e_1) {
              previousFailure = extractRuleFailedException(e_1);
              /* looseListSubtypeCheck(op.left, singleUnconstrainedNumber) */
              if (!this.looseListSubtypeCheckInternal(_trace_, op.getLeft(), this.typeFactory.singleUnconstrainedNumber)) {
                sneakyThrowRuleFailedException("looseListSubtypeCheck(op.left, singleUnconstrainedNumber)");
              }
            }
          }
        }
      }
    } else {
      String _operator_1 = op.getOperator();
      boolean _equals_1 = Objects.equal(_operator_1, "-");
      if (_equals_1) {
        /* { looseListSubtypeCheck(op.left, singleDate) } or { looseListSubtypeCheck(op.left, singleUnconstrainedNumber) } */
        {
          RuleFailedException previousFailure = null;
          try {
            /* looseListSubtypeCheck(op.left, singleDate) */
            if (!this.looseListSubtypeCheckInternal(_trace_, op.getLeft(), this.typeFactory.singleDate)) {
              sneakyThrowRuleFailedException("looseListSubtypeCheck(op.left, singleDate)");
            }
          } catch (Exception e_2) {
            previousFailure = extractRuleFailedException(e_2);
            /* looseListSubtypeCheck(op.left, singleUnconstrainedNumber) */
            if (!this.looseListSubtypeCheckInternal(_trace_, op.getLeft(), this.typeFactory.singleUnconstrainedNumber)) {
              sneakyThrowRuleFailedException("looseListSubtypeCheck(op.left, singleUnconstrainedNumber)");
            }
          }
        }
      } else {
        /* looseListSubtypeCheck(op.left, singleUnconstrainedNumber) */
        if (!this.looseListSubtypeCheckInternal(_trace_, op.getLeft(), this.typeFactory.singleUnconstrainedNumber)) {
          sneakyThrowRuleFailedException("looseListSubtypeCheck(op.left, singleUnconstrainedNumber)");
        }
      }
    }
    return new Result<Boolean>(true);
  }

  public Result<Boolean> checkRightArithmetic(final ArithmeticOperation op) {
    return checkRightArithmetic(null, op);
  }

  public Result<Boolean> checkRightArithmetic(final RuleApplicationTrace _trace_, final ArithmeticOperation op) {
    try {
    	return checkRightArithmeticInternal(_trace_, op);
    } catch (Exception _e_CheckRightArithmetic) {
    	return resultForFailure(_e_CheckRightArithmetic);
    }
  }

  protected Result<Boolean> checkRightArithmeticInternal(final RuleApplicationTrace _trace_, final ArithmeticOperation op) throws RuleFailedException {
    String _operator = op.getOperator();
    boolean _equals = Objects.equal(_operator, "+");
    if (_equals) {
      /* { looseListSubtypeCheck(op.right, singleTime) } or { looseListSubtypeCheck(op.right, singleUnconstrainedString) } or { looseListSubtypeCheck(op.right, singleUnconstrainedNumber) } */
      {
        RuleFailedException previousFailure = null;
        try {
          /* looseListSubtypeCheck(op.right, singleTime) */
          if (!this.looseListSubtypeCheckInternal(_trace_, op.getRight(), this.typeFactory.singleTime)) {
            sneakyThrowRuleFailedException("looseListSubtypeCheck(op.right, singleTime)");
          }
        } catch (Exception e) {
          previousFailure = extractRuleFailedException(e);
          /* { looseListSubtypeCheck(op.right, singleUnconstrainedString) } or { looseListSubtypeCheck(op.right, singleUnconstrainedNumber) } */
          {
            try {
              /* looseListSubtypeCheck(op.right, singleUnconstrainedString) */
              if (!this.looseListSubtypeCheckInternal(_trace_, op.getRight(), this.typeFactory.singleUnconstrainedString)) {
                sneakyThrowRuleFailedException("looseListSubtypeCheck(op.right, singleUnconstrainedString)");
              }
            } catch (Exception e_1) {
              previousFailure = extractRuleFailedException(e_1);
              /* looseListSubtypeCheck(op.right, singleUnconstrainedNumber) */
              if (!this.looseListSubtypeCheckInternal(_trace_, op.getRight(), this.typeFactory.singleUnconstrainedNumber)) {
                sneakyThrowRuleFailedException("looseListSubtypeCheck(op.right, singleUnconstrainedNumber)");
              }
            }
          }
        }
      }
    } else {
      String _operator_1 = op.getOperator();
      boolean _equals_1 = Objects.equal(_operator_1, "-");
      if (_equals_1) {
        /* { looseListSubtypeCheck(op.right, singleDate) } or { looseListSubtypeCheck(op.right, singleUnconstrainedNumber) } */
        {
          RuleFailedException previousFailure = null;
          try {
            /* looseListSubtypeCheck(op.right, singleDate) */
            if (!this.looseListSubtypeCheckInternal(_trace_, op.getRight(), this.typeFactory.singleDate)) {
              sneakyThrowRuleFailedException("looseListSubtypeCheck(op.right, singleDate)");
            }
          } catch (Exception e_2) {
            previousFailure = extractRuleFailedException(e_2);
            /* looseListSubtypeCheck(op.right, singleUnconstrainedNumber) */
            if (!this.looseListSubtypeCheckInternal(_trace_, op.getRight(), this.typeFactory.singleUnconstrainedNumber)) {
              sneakyThrowRuleFailedException("looseListSubtypeCheck(op.right, singleUnconstrainedNumber)");
            }
          }
        }
      } else {
        /* looseListSubtypeCheck(op.right, singleUnconstrainedNumber) */
        if (!this.looseListSubtypeCheckInternal(_trace_, op.getRight(), this.typeFactory.singleUnconstrainedNumber)) {
          sneakyThrowRuleFailedException("looseListSubtypeCheck(op.right, singleUnconstrainedNumber)");
        }
      }
    }
    return new Result<Boolean>(true);
  }

  public Result<Boolean> checkAddition(final ArithmeticOperation op) {
    return checkAddition(null, op);
  }

  public Result<Boolean> checkAddition(final RuleApplicationTrace _trace_, final ArithmeticOperation op) {
    try {
    	return checkAdditionInternal(_trace_, op);
    } catch (Exception _e_CheckAddition) {
    	return resultForFailure(_e_CheckAddition);
    }
  }

  protected Result<Boolean> checkAdditionInternal(final RuleApplicationTrace _trace_, final ArithmeticOperation op) throws RuleFailedException {
    RListType tl = null;
    RListType tr = null;
    /* empty |- op.left : tl or tl = null */
    {
      RuleFailedException previousFailure = null;
      try {
        /* empty |- op.left : tl */
        RosettaExpression _left = op.getLeft();
        Result<RListType> result = inferTypeInternal(emptyEnvironment(), _trace_, _left);
        checkAssignableTo(result.getFirst(), RListType.class);
        tl = (RListType) result.getFirst();
        
      } catch (Exception e) {
        previousFailure = extractRuleFailedException(e);
        tl = null;
      }
    }
    /* empty |- op.right : tr or tr = null */
    {
      RuleFailedException previousFailure = null;
      try {
        /* empty |- op.right : tr */
        RosettaExpression _right = op.getRight();
        Result<RListType> result_1 = inferTypeInternal(emptyEnvironment(), _trace_, _right);
        checkAssignableTo(result_1.getFirst(), RListType.class);
        tr = (RListType) result_1.getFirst();
        
      } catch (Exception e_1) {
        previousFailure = extractRuleFailedException(e_1);
        tr = null;
      }
    }
    if (((tl != null) && (tr != null))) {
      String _operator = op.getOperator();
      boolean _equals = Objects.equal(_operator, "+");
      if (_equals) {
        /* { empty |- tl.itemType <: DATE empty |- tr.itemType <: TIME } or { empty |- tl.itemType <: UNCONSTRAINED_STRING empty |- tr.itemType <: UNCONSTRAINED_STRING } or { empty |- tl.itemType <: UNCONSTRAINED_NUMBER empty |- tr.itemType <: UNCONSTRAINED_NUMBER } or fail error "Expected arguments to be either both a `string` or both a `number`, but got `" + relevantItemTypeDescription(tl, tr) + "` and `" + relevantItemTypeDescription(tr, tl) + "` instead." source op */
        {
          RuleFailedException previousFailure = null;
          try {
            /* empty |- tl.itemType <: DATE */
            RType _itemType = tl.getItemType();
            subtypeInternal(emptyEnvironment(), _trace_, _itemType, this.builtinTypes.DATE);
            /* empty |- tr.itemType <: TIME */
            RType _itemType_1 = tr.getItemType();
            subtypeInternal(emptyEnvironment(), _trace_, _itemType_1, this.builtinTypes.TIME);
          } catch (Exception e_2) {
            previousFailure = extractRuleFailedException(e_2);
            /* { empty |- tl.itemType <: UNCONSTRAINED_STRING empty |- tr.itemType <: UNCONSTRAINED_STRING } or { empty |- tl.itemType <: UNCONSTRAINED_NUMBER empty |- tr.itemType <: UNCONSTRAINED_NUMBER } or fail error "Expected arguments to be either both a `string` or both a `number`, but got `" + relevantItemTypeDescription(tl, tr) + "` and `" + relevantItemTypeDescription(tr, tl) + "` instead." source op */
            {
              try {
                /* empty |- tl.itemType <: UNCONSTRAINED_STRING */
                RType _itemType_2 = tl.getItemType();
                subtypeInternal(emptyEnvironment(), _trace_, _itemType_2, this.builtinTypes.UNCONSTRAINED_STRING);
                /* empty |- tr.itemType <: UNCONSTRAINED_STRING */
                RType _itemType_3 = tr.getItemType();
                subtypeInternal(emptyEnvironment(), _trace_, _itemType_3, this.builtinTypes.UNCONSTRAINED_STRING);
              } catch (Exception e_3) {
                previousFailure = extractRuleFailedException(e_3);
                /* { empty |- tl.itemType <: UNCONSTRAINED_NUMBER empty |- tr.itemType <: UNCONSTRAINED_NUMBER } or fail error "Expected arguments to be either both a `string` or both a `number`, but got `" + relevantItemTypeDescription(tl, tr) + "` and `" + relevantItemTypeDescription(tr, tl) + "` instead." source op */
                {
                  try {
                    /* empty |- tl.itemType <: UNCONSTRAINED_NUMBER */
                    RType _itemType_4 = tl.getItemType();
                    subtypeInternal(emptyEnvironment(), _trace_, _itemType_4, this.builtinTypes.UNCONSTRAINED_NUMBER);
                    /* empty |- tr.itemType <: UNCONSTRAINED_NUMBER */
                    RType _itemType_5 = tr.getItemType();
                    subtypeInternal(emptyEnvironment(), _trace_, _itemType_5, this.builtinTypes.UNCONSTRAINED_NUMBER);
                  } catch (Exception e_4) {
                    previousFailure = extractRuleFailedException(e_4);
                    /* fail error "Expected arguments to be either both a `string` or both a `number`, but got `" + relevantItemTypeDescription(tl, tr) + "` and `" + relevantItemTypeDescription(tr, tl) + "` instead." source op */
                    CharSequence _relevantItemTypeDescription = this.util.relevantItemTypeDescription(tl, tr);
                    String _plus = ("Expected arguments to be either both a `string` or both a `number`, but got `" + _relevantItemTypeDescription);
                    String _plus_1 = (_plus + "` and `");
                    CharSequence _relevantItemTypeDescription_1 = this.util.relevantItemTypeDescription(tr, tl);
                    String _plus_2 = (_plus_1 + _relevantItemTypeDescription_1);
                    String _plus_3 = (_plus_2 + "` instead.");
                    String error = _plus_3;
                    EObject source = op;
                    throwForExplicitFail(error, new ErrorInformation(source, null));
                  }
                }
              }
            }
          }
        }
      } else {
        String _operator_1 = op.getOperator();
        boolean _equals_1 = Objects.equal(_operator_1, "-");
        if (_equals_1) {
          /* { empty |- tl.itemType <: DATE empty |- tr.itemType <: DATE } or { empty |- tl.itemType <: UNCONSTRAINED_NUMBER empty |- tr.itemType <: UNCONSTRAINED_NUMBER } or fail error "Expected arguments to be either both a `date` or both a `number`, but got `" + tl.itemType.toString() + "` and `" + tr.itemType.toString() + "` instead." source op */
          {
            RuleFailedException previousFailure = null;
            try {
              /* empty |- tl.itemType <: DATE */
              RType _itemType_6 = tl.getItemType();
              subtypeInternal(emptyEnvironment(), _trace_, _itemType_6, this.builtinTypes.DATE);
              /* empty |- tr.itemType <: DATE */
              RType _itemType_7 = tr.getItemType();
              subtypeInternal(emptyEnvironment(), _trace_, _itemType_7, this.builtinTypes.DATE);
            } catch (Exception e_5) {
              previousFailure = extractRuleFailedException(e_5);
              /* { empty |- tl.itemType <: UNCONSTRAINED_NUMBER empty |- tr.itemType <: UNCONSTRAINED_NUMBER } or fail error "Expected arguments to be either both a `date` or both a `number`, but got `" + tl.itemType.toString() + "` and `" + tr.itemType.toString() + "` instead." source op */
              {
                try {
                  /* empty |- tl.itemType <: UNCONSTRAINED_NUMBER */
                  RType _itemType_8 = tl.getItemType();
                  subtypeInternal(emptyEnvironment(), _trace_, _itemType_8, this.builtinTypes.UNCONSTRAINED_NUMBER);
                  /* empty |- tr.itemType <: UNCONSTRAINED_NUMBER */
                  RType _itemType_9 = tr.getItemType();
                  subtypeInternal(emptyEnvironment(), _trace_, _itemType_9, this.builtinTypes.UNCONSTRAINED_NUMBER);
                } catch (Exception e_6) {
                  previousFailure = extractRuleFailedException(e_6);
                  /* fail error "Expected arguments to be either both a `date` or both a `number`, but got `" + tl.itemType.toString() + "` and `" + tr.itemType.toString() + "` instead." source op */
                  String _string = tl.getItemType().toString();
                  String _plus_4 = ("Expected arguments to be either both a `date` or both a `number`, but got `" + _string);
                  String _plus_5 = (_plus_4 + "` and `");
                  String _string_1 = tr.getItemType().toString();
                  String _plus_6 = (_plus_5 + _string_1);
                  String _plus_7 = (_plus_6 + "` instead.");
                  String error_1 = _plus_7;
                  EObject source_1 = op;
                  throwForExplicitFail(error_1, new ErrorInformation(source_1, null));
                }
              }
            }
          }
        }
      }
    }
    return new Result<Boolean>(true);
  }

  public Result<Boolean> checkEqualityOperation(final EqualityOperation op) {
    return checkEqualityOperation(null, op);
  }

  public Result<Boolean> checkEqualityOperation(final RuleApplicationTrace _trace_, final EqualityOperation op) {
    try {
    	return checkEqualityOperationInternal(_trace_, op);
    } catch (Exception _e_CheckEqualityOperation) {
    	return resultForFailure(_e_CheckEqualityOperation);
    }
  }

  protected Result<Boolean> checkEqualityOperationInternal(final RuleApplicationTrace _trace_, final EqualityOperation op) throws RuleFailedException {
    CardinalityModifier _cardMod = op.getCardMod();
    boolean _tripleEquals = (_cardMod == CardinalityModifier.NONE);
    if (_tripleEquals) {
      /* comparableListTypeCheck(op) */
      if (!this.comparableListTypeCheckInternal(_trace_, op)) {
        sneakyThrowRuleFailedException("comparableListTypeCheck(op)");
      }
    } else {
      Boolean _looseOnlyRightIsSingularCheck = this.looseOnlyRightIsSingularCheckInternal(_trace_, op);
      /* looseOnlyRightIsSingularCheck(op) */
      if (!_looseOnlyRightIsSingularCheck) {
        sneakyThrowRuleFailedException("looseOnlyRightIsSingularCheck(op)");
      }
      /* comparableTypeCheck(op) */
      if (!this.comparableTypeCheckInternal(_trace_, op)) {
        sneakyThrowRuleFailedException("comparableTypeCheck(op)");
      }
    }
    return new Result<Boolean>(true);
  }

  public Result<Boolean> checkLeftLogical(final LogicalOperation op) {
    return checkLeftLogical(null, op);
  }

  public Result<Boolean> checkLeftLogical(final RuleApplicationTrace _trace_, final LogicalOperation op) {
    try {
    	return checkLeftLogicalInternal(_trace_, op);
    } catch (Exception _e_CheckLeftLogical) {
    	return resultForFailure(_e_CheckLeftLogical);
    }
  }

  protected Result<Boolean> checkLeftLogicalInternal(final RuleApplicationTrace _trace_, final LogicalOperation op) throws RuleFailedException {
    /* looseListSubtypeCheck(op.left, singleBoolean) */
    if (!this.looseListSubtypeCheckInternal(_trace_, op.getLeft(), this.typeFactory.singleBoolean)) {
      sneakyThrowRuleFailedException("looseListSubtypeCheck(op.left, singleBoolean)");
    }
    return new Result<Boolean>(true);
  }

  public Result<Boolean> checkRightLogical(final LogicalOperation op) {
    return checkRightLogical(null, op);
  }

  public Result<Boolean> checkRightLogical(final RuleApplicationTrace _trace_, final LogicalOperation op) {
    try {
    	return checkRightLogicalInternal(_trace_, op);
    } catch (Exception _e_CheckRightLogical) {
    	return resultForFailure(_e_CheckRightLogical);
    }
  }

  protected Result<Boolean> checkRightLogicalInternal(final RuleApplicationTrace _trace_, final LogicalOperation op) throws RuleFailedException {
    /* looseListSubtypeCheck(op.right, singleBoolean) */
    if (!this.looseListSubtypeCheckInternal(_trace_, op.getRight(), this.typeFactory.singleBoolean)) {
      sneakyThrowRuleFailedException("looseListSubtypeCheck(op.right, singleBoolean)");
    }
    return new Result<Boolean>(true);
  }

  public Result<Boolean> checkLeftComparison(final ComparisonOperation op) {
    return checkLeftComparison(null, op);
  }

  public Result<Boolean> checkLeftComparison(final RuleApplicationTrace _trace_, final ComparisonOperation op) {
    try {
    	return checkLeftComparisonInternal(_trace_, op);
    } catch (Exception _e_CheckLeftComparison) {
    	return resultForFailure(_e_CheckLeftComparison);
    }
  }

  protected Result<Boolean> checkLeftComparisonInternal(final RuleApplicationTrace _trace_, final ComparisonOperation op) throws RuleFailedException {
    CardinalityModifier _cardMod = op.getCardMod();
    boolean _tripleEquals = (_cardMod == CardinalityModifier.NONE);
    if (_tripleEquals) {
      /* { looseListSubtypeCheck(op.left, singleZonedDateTime) } or { looseListSubtypeCheck(op.left, singleDate) } or { looseListSubtypeCheck(op.left, singleUnconstrainedNumber) } */
      {
        RuleFailedException previousFailure = null;
        try {
          /* looseListSubtypeCheck(op.left, singleZonedDateTime) */
          if (!this.looseListSubtypeCheckInternal(_trace_, op.getLeft(), this.typeFactory.singleZonedDateTime)) {
            sneakyThrowRuleFailedException("looseListSubtypeCheck(op.left, singleZonedDateTime)");
          }
        } catch (Exception e) {
          previousFailure = extractRuleFailedException(e);
          /* { looseListSubtypeCheck(op.left, singleDate) } or { looseListSubtypeCheck(op.left, singleUnconstrainedNumber) } */
          {
            try {
              /* looseListSubtypeCheck(op.left, singleDate) */
              if (!this.looseListSubtypeCheckInternal(_trace_, op.getLeft(), this.typeFactory.singleDate)) {
                sneakyThrowRuleFailedException("looseListSubtypeCheck(op.left, singleDate)");
              }
            } catch (Exception e_1) {
              previousFailure = extractRuleFailedException(e_1);
              /* looseListSubtypeCheck(op.left, singleUnconstrainedNumber) */
              if (!this.looseListSubtypeCheckInternal(_trace_, op.getLeft(), this.typeFactory.singleUnconstrainedNumber)) {
                sneakyThrowRuleFailedException("looseListSubtypeCheck(op.left, singleUnconstrainedNumber)");
              }
            }
          }
        }
      }
    } else {
      /* { subtypeCheck(op.left, ZONED_DATE_TIME) } or { subtypeCheck(op.left, DATE) } or { subtypeCheck(op.left, UNCONSTRAINED_NUMBER) } */
      {
        RuleFailedException previousFailure = null;
        try {
          /* subtypeCheck(op.left, ZONED_DATE_TIME) */
          if (!this.subtypeCheckInternal(_trace_, op.getLeft(), this.builtinTypes.ZONED_DATE_TIME)) {
            sneakyThrowRuleFailedException("subtypeCheck(op.left, ZONED_DATE_TIME)");
          }
        } catch (Exception e_2) {
          previousFailure = extractRuleFailedException(e_2);
          /* { subtypeCheck(op.left, DATE) } or { subtypeCheck(op.left, UNCONSTRAINED_NUMBER) } */
          {
            try {
              /* subtypeCheck(op.left, DATE) */
              if (!this.subtypeCheckInternal(_trace_, op.getLeft(), this.builtinTypes.DATE)) {
                sneakyThrowRuleFailedException("subtypeCheck(op.left, DATE)");
              }
            } catch (Exception e_3) {
              previousFailure = extractRuleFailedException(e_3);
              /* subtypeCheck(op.left, UNCONSTRAINED_NUMBER) */
              if (!this.subtypeCheckInternal(_trace_, op.getLeft(), this.builtinTypes.UNCONSTRAINED_NUMBER)) {
                sneakyThrowRuleFailedException("subtypeCheck(op.left, UNCONSTRAINED_NUMBER)");
              }
            }
          }
        }
      }
    }
    return new Result<Boolean>(true);
  }

  public Result<Boolean> checkRightComparison(final ComparisonOperation op) {
    return checkRightComparison(null, op);
  }

  public Result<Boolean> checkRightComparison(final RuleApplicationTrace _trace_, final ComparisonOperation op) {
    try {
    	return checkRightComparisonInternal(_trace_, op);
    } catch (Exception _e_CheckRightComparison) {
    	return resultForFailure(_e_CheckRightComparison);
    }
  }

  protected Result<Boolean> checkRightComparisonInternal(final RuleApplicationTrace _trace_, final ComparisonOperation op) throws RuleFailedException {
    CardinalityModifier _cardMod = op.getCardMod();
    boolean _tripleEquals = (_cardMod == CardinalityModifier.NONE);
    if (_tripleEquals) {
      /* { looseListSubtypeCheck(op.left, singleZonedDateTime) } or { looseListSubtypeCheck(op.right, singleDate) } or { looseListSubtypeCheck(op.right, singleUnconstrainedNumber) } */
      {
        RuleFailedException previousFailure = null;
        try {
          /* looseListSubtypeCheck(op.left, singleZonedDateTime) */
          if (!this.looseListSubtypeCheckInternal(_trace_, op.getLeft(), this.typeFactory.singleZonedDateTime)) {
            sneakyThrowRuleFailedException("looseListSubtypeCheck(op.left, singleZonedDateTime)");
          }
        } catch (Exception e) {
          previousFailure = extractRuleFailedException(e);
          /* { looseListSubtypeCheck(op.right, singleDate) } or { looseListSubtypeCheck(op.right, singleUnconstrainedNumber) } */
          {
            try {
              /* looseListSubtypeCheck(op.right, singleDate) */
              if (!this.looseListSubtypeCheckInternal(_trace_, op.getRight(), this.typeFactory.singleDate)) {
                sneakyThrowRuleFailedException("looseListSubtypeCheck(op.right, singleDate)");
              }
            } catch (Exception e_1) {
              previousFailure = extractRuleFailedException(e_1);
              /* looseListSubtypeCheck(op.right, singleUnconstrainedNumber) */
              if (!this.looseListSubtypeCheckInternal(_trace_, op.getRight(), this.typeFactory.singleUnconstrainedNumber)) {
                sneakyThrowRuleFailedException("looseListSubtypeCheck(op.right, singleUnconstrainedNumber)");
              }
            }
          }
        }
      }
    } else {
      /* { subtypeCheck(op.left, ZONED_DATE_TIME) } or { subtypeCheck(op.right, DATE) } or { subtypeCheck(op.right, UNCONSTRAINED_NUMBER) } */
      {
        RuleFailedException previousFailure = null;
        try {
          /* subtypeCheck(op.left, ZONED_DATE_TIME) */
          if (!this.subtypeCheckInternal(_trace_, op.getLeft(), this.builtinTypes.ZONED_DATE_TIME)) {
            sneakyThrowRuleFailedException("subtypeCheck(op.left, ZONED_DATE_TIME)");
          }
        } catch (Exception e_2) {
          previousFailure = extractRuleFailedException(e_2);
          /* { subtypeCheck(op.right, DATE) } or { subtypeCheck(op.right, UNCONSTRAINED_NUMBER) } */
          {
            try {
              /* subtypeCheck(op.right, DATE) */
              if (!this.subtypeCheckInternal(_trace_, op.getRight(), this.builtinTypes.DATE)) {
                sneakyThrowRuleFailedException("subtypeCheck(op.right, DATE)");
              }
            } catch (Exception e_3) {
              previousFailure = extractRuleFailedException(e_3);
              /* subtypeCheck(op.right, UNCONSTRAINED_NUMBER) */
              if (!this.subtypeCheckInternal(_trace_, op.getRight(), this.builtinTypes.UNCONSTRAINED_NUMBER)) {
                sneakyThrowRuleFailedException("subtypeCheck(op.right, UNCONSTRAINED_NUMBER)");
              }
            }
          }
        }
      }
    }
    return new Result<Boolean>(true);
  }

  public Result<Boolean> checkComparison(final ComparisonOperation op) {
    return checkComparison(null, op);
  }

  public Result<Boolean> checkComparison(final RuleApplicationTrace _trace_, final ComparisonOperation op) {
    try {
    	return checkComparisonInternal(_trace_, op);
    } catch (Exception _e_CheckComparison) {
    	return resultForFailure(_e_CheckComparison);
    }
  }

  protected Result<Boolean> checkComparisonInternal(final RuleApplicationTrace _trace_, final ComparisonOperation op) throws RuleFailedException {
    RListType tl = null;
    RListType tr = null;
    /* empty |- op.left : tl or tl = null */
    {
      RuleFailedException previousFailure = null;
      try {
        /* empty |- op.left : tl */
        RosettaExpression _left = op.getLeft();
        Result<RListType> result = inferTypeInternal(emptyEnvironment(), _trace_, _left);
        checkAssignableTo(result.getFirst(), RListType.class);
        tl = (RListType) result.getFirst();
        
      } catch (Exception e) {
        previousFailure = extractRuleFailedException(e);
        tl = null;
      }
    }
    /* empty |- op.right : tr or tr = null */
    {
      RuleFailedException previousFailure = null;
      try {
        /* empty |- op.right : tr */
        RosettaExpression _right = op.getRight();
        Result<RListType> result_1 = inferTypeInternal(emptyEnvironment(), _trace_, _right);
        checkAssignableTo(result_1.getFirst(), RListType.class);
        tr = (RListType) result_1.getFirst();
        
      } catch (Exception e_1) {
        previousFailure = extractRuleFailedException(e_1);
        tr = null;
      }
    }
    if (((tl != null) && (tr != null))) {
      /* { empty |- tl.itemType <: ZONED_DATE_TIME empty |- tr.itemType <: ZONED_DATE_TIME } or { empty |- tl.itemType <: DATE empty |- tr.itemType <: DATE } or { empty |- tl.itemType <: UNCONSTRAINED_NUMBER empty |- tr.itemType <: UNCONSTRAINED_NUMBER } or fail error "Expected arguments to be either both a `date`, both a `number` or both a `zonedDateTime`, but got `" + tl.itemType.toString() + "` and `" + tr.itemType.toString() + "` instead." source op */
      {
        RuleFailedException previousFailure = null;
        try {
          /* empty |- tl.itemType <: ZONED_DATE_TIME */
          RType _itemType = tl.getItemType();
          subtypeInternal(emptyEnvironment(), _trace_, _itemType, this.builtinTypes.ZONED_DATE_TIME);
          /* empty |- tr.itemType <: ZONED_DATE_TIME */
          RType _itemType_1 = tr.getItemType();
          subtypeInternal(emptyEnvironment(), _trace_, _itemType_1, this.builtinTypes.ZONED_DATE_TIME);
        } catch (Exception e_2) {
          previousFailure = extractRuleFailedException(e_2);
          /* { empty |- tl.itemType <: DATE empty |- tr.itemType <: DATE } or { empty |- tl.itemType <: UNCONSTRAINED_NUMBER empty |- tr.itemType <: UNCONSTRAINED_NUMBER } or fail error "Expected arguments to be either both a `date`, both a `number` or both a `zonedDateTime`, but got `" + tl.itemType.toString() + "` and `" + tr.itemType.toString() + "` instead." source op */
          {
            try {
              /* empty |- tl.itemType <: DATE */
              RType _itemType_2 = tl.getItemType();
              subtypeInternal(emptyEnvironment(), _trace_, _itemType_2, this.builtinTypes.DATE);
              /* empty |- tr.itemType <: DATE */
              RType _itemType_3 = tr.getItemType();
              subtypeInternal(emptyEnvironment(), _trace_, _itemType_3, this.builtinTypes.DATE);
            } catch (Exception e_3) {
              previousFailure = extractRuleFailedException(e_3);
              /* { empty |- tl.itemType <: UNCONSTRAINED_NUMBER empty |- tr.itemType <: UNCONSTRAINED_NUMBER } or fail error "Expected arguments to be either both a `date`, both a `number` or both a `zonedDateTime`, but got `" + tl.itemType.toString() + "` and `" + tr.itemType.toString() + "` instead." source op */
              {
                try {
                  /* empty |- tl.itemType <: UNCONSTRAINED_NUMBER */
                  RType _itemType_4 = tl.getItemType();
                  subtypeInternal(emptyEnvironment(), _trace_, _itemType_4, this.builtinTypes.UNCONSTRAINED_NUMBER);
                  /* empty |- tr.itemType <: UNCONSTRAINED_NUMBER */
                  RType _itemType_5 = tr.getItemType();
                  subtypeInternal(emptyEnvironment(), _trace_, _itemType_5, this.builtinTypes.UNCONSTRAINED_NUMBER);
                } catch (Exception e_4) {
                  previousFailure = extractRuleFailedException(e_4);
                  /* fail error "Expected arguments to be either both a `date`, both a `number` or both a `zonedDateTime`, but got `" + tl.itemType.toString() + "` and `" + tr.itemType.toString() + "` instead." source op */
                  String _string = tl.getItemType().toString();
                  String _plus = ("Expected arguments to be either both a `date`, both a `number` or both a `zonedDateTime`, but got `" + _string);
                  String _plus_1 = (_plus + "` and `");
                  String _string_1 = tr.getItemType().toString();
                  String _plus_2 = (_plus_1 + _string_1);
                  String _plus_3 = (_plus_2 + "` instead.");
                  String error = _plus_3;
                  EObject source = op;
                  throwForExplicitFail(error, new ErrorInformation(source, null));
                }
              }
            }
          }
        }
      }
    }
    CardinalityModifier _cardMod = op.getCardMod();
    boolean _tripleNotEquals = (_cardMod != CardinalityModifier.NONE);
    if (_tripleNotEquals) {
      /* looseOnlyRightIsSingularCheck(op) */
      if (!this.looseOnlyRightIsSingularCheckInternal(_trace_, op)) {
        sneakyThrowRuleFailedException("looseOnlyRightIsSingularCheck(op)");
      }
    }
    return new Result<Boolean>(true);
  }

  public Result<Boolean> checkIfConditionalExpression(final RosettaConditionalExpression e) {
    return checkIfConditionalExpression(null, e);
  }

  public Result<Boolean> checkIfConditionalExpression(final RuleApplicationTrace _trace_, final RosettaConditionalExpression e) {
    try {
    	return checkIfConditionalExpressionInternal(_trace_, e);
    } catch (Exception _e_CheckIfConditionalExpression) {
    	return resultForFailure(_e_CheckIfConditionalExpression);
    }
  }

  protected Result<Boolean> checkIfConditionalExpressionInternal(final RuleApplicationTrace _trace_, final RosettaConditionalExpression e) throws RuleFailedException {
    /* looseListSubtypeCheck(e.^if, singleBoolean) */
    if (!this.looseListSubtypeCheckInternal(_trace_, e.getIf(), this.typeFactory.singleBoolean)) {
      sneakyThrowRuleFailedException("looseListSubtypeCheck(e.^if, singleBoolean)");
    }
    return new Result<Boolean>(true);
  }

  public Result<Boolean> checkBodyConditionalExpression(final RosettaConditionalExpression e) {
    return checkBodyConditionalExpression(null, e);
  }

  public Result<Boolean> checkBodyConditionalExpression(final RuleApplicationTrace _trace_, final RosettaConditionalExpression e) {
    try {
    	return checkBodyConditionalExpressionInternal(_trace_, e);
    } catch (Exception _e_CheckBodyConditionalExpression) {
    	return resultForFailure(_e_CheckBodyConditionalExpression);
    }
  }

  protected Result<Boolean> checkBodyConditionalExpressionInternal(final RuleApplicationTrace _trace_, final RosettaConditionalExpression e) throws RuleFailedException {
    RListType tthen = null;
    RListType telse = null;
    /* empty |- e.ifthen : tthen or tthen = null */
    {
      RuleFailedException previousFailure = null;
      try {
        /* empty |- e.ifthen : tthen */
        RosettaExpression _ifthen = e.getIfthen();
        Result<RListType> result = inferTypeInternal(emptyEnvironment(), _trace_, _ifthen);
        checkAssignableTo(result.getFirst(), RListType.class);
        tthen = (RListType) result.getFirst();
        
      } catch (Exception e_1) {
        previousFailure = extractRuleFailedException(e_1);
        tthen = null;
      }
    }
    /* empty |- e.elsethen : telse or telse = null */
    {
      RuleFailedException previousFailure = null;
      try {
        /* empty |- e.elsethen : telse */
        RosettaExpression _elsethen = e.getElsethen();
        Result<RListType> result_1 = inferTypeInternal(emptyEnvironment(), _trace_, _elsethen);
        checkAssignableTo(result_1.getFirst(), RListType.class);
        telse = (RListType) result_1.getFirst();
        
      } catch (Exception e_2) {
        previousFailure = extractRuleFailedException(e_2);
        telse = null;
      }
    }
    if (((tthen != null) && (telse != null))) {
      final RListType joined = this.listJoinInternal(_trace_, tthen, telse);
      /* empty |- ANY <: joined.itemType */
      RType _itemType = joined.getItemType();
      boolean _ruleinvocation = subtypeSucceeded(emptyEnvironment(), _trace_, this.builtinTypes.ANY, _itemType);
      if (_ruleinvocation) {
        /* fail error "Types `" + tthen.itemType.name + "` and `" + telse.itemType.name + "` do not have a common supertype." */
        String _name = tthen.getItemType().getName();
        String _plus = ("Types `" + _name);
        String _plus_1 = (_plus + "` and `");
        String _name_1 = telse.getItemType().getName();
        String _plus_2 = (_plus_1 + _name_1);
        String _plus_3 = (_plus_2 + "` do not have a common supertype.");
        String error = _plus_3;
        throwForExplicitFail(error, new ErrorInformation(null, null));
      }
    }
    return new Result<Boolean>(true);
  }

  public Result<Boolean> checkListLiteral(final ListLiteral e) {
    return checkListLiteral(null, e);
  }

  public Result<Boolean> checkListLiteral(final RuleApplicationTrace _trace_, final ListLiteral e) {
    try {
    	return checkListLiteralInternal(_trace_, e);
    } catch (Exception _e_CheckListLiteral) {
    	return resultForFailure(_e_CheckListLiteral);
    }
  }

  protected Result<Boolean> checkListLiteralInternal(final RuleApplicationTrace _trace_, final ListLiteral e) throws RuleFailedException {
    final ArrayList<RListType> telems = CollectionLiterals.<RListType>newArrayList();
    final Function1<RosettaExpression, Boolean> _function = (RosettaExpression it) -> {
      boolean _xblockexpression = false;
      {
        RListType telem = null;
        /* empty |- it : telem or telem = null */
        {
          RuleFailedException previousFailure = null;
          try {
            /* empty |- it : telem */
            Result<RListType> result = inferTypeInternal(emptyEnvironment(), _trace_, it);
            checkAssignableTo(result.getFirst(), RListType.class);
            telem = (RListType) result.getFirst();
            
          } catch (Exception e_1) {
            previousFailure = extractRuleFailedException(e_1);
            telem = null;
          }
        }
        if ((telem != null)) {
          /* telems.add(telem) */
          if (!telems.add(telem)) {
            sneakyThrowRuleFailedException("telems.add(telem)");
          }
        }
        _xblockexpression = (telem != null);
      }
      return Boolean.valueOf(_xblockexpression);
    };
    boolean _forall = IterableExtensions.<RosettaExpression>forall(e.getElements(), _function);
    if (_forall) {
      /* telems.fold(emptyNothing, [ RListType acc, RListType telem | if (acc === null) { null } else { val sup = join(telem.itemType, acc.itemType); if ({empty |- ANY <: sup}) { null } else { createListType(sup, telem.constraint + acc.constraint) } } ]) !== null or fail error "Elements do not have a common supertype: " + telems.join(', ')["`" + it.itemType.name + "`"] + "." */
      {
        RuleFailedException previousFailure = null;
        try {
          final Function2<RListType, RListType, RListType> _function_1 = new Function2<RListType, RListType, RListType>() {
            @Override
            public RListType apply(final RListType acc, final RListType telem) {
              RListType _xifexpression = null;
              if ((acc == null)) {
                _xifexpression = null;
              } else {
                RListType _xblockexpression = null;
                {
                  final RType sup = RosettaTypingChecking.this.joinInternal(_trace_, telem.getItemType(), acc.getItemType());
                  RListType _xifexpression_1 = null;
                  /* empty |- ANY <: sup */
                  boolean _ruleinvocation = subtypeSucceeded(emptyEnvironment(), _trace_, RosettaTypingChecking.this.builtinTypes.ANY, sup);
                  if (_ruleinvocation) {
                    _xifexpression_1 = null;
                  } else {
                    RosettaCardinality _constraint = telem.getConstraint();
                    RosettaCardinality _constraint_1 = acc.getConstraint();
                    RosettaCardinality _plus = _constraint.operator_plus(_constraint_1);
                    _xifexpression_1 = RosettaTypingChecking.this.typeFactory.createListType(sup, _plus);
                  }
                  _xblockexpression = (_xifexpression_1);
                }
                _xifexpression = _xblockexpression;
              }
              return _xifexpression;
            }
          };
          RListType _fold = IterableExtensions.<RListType, RListType>fold(telems, this.typeFactory.emptyNothing, _function_1);
          boolean _tripleNotEquals = (_fold != null);
          /* telems.fold(emptyNothing, [ RListType acc, RListType telem | if (acc === null) { null } else { val sup = join(telem.itemType, acc.itemType); if ({empty |- ANY <: sup}) { null } else { createListType(sup, telem.constraint + acc.constraint) } } ]) !== null */
          if (!_tripleNotEquals) {
            sneakyThrowRuleFailedException("telems.fold(emptyNothing, [ RListType acc, RListType telem | if (acc === null) { null } else { val sup = join(telem.itemType, acc.itemType); if ({empty |- ANY <: sup}) { null } else { createListType(sup, telem.constraint + acc.constraint) } } ]) !== null");
          }
        } catch (Exception e_1) {
          previousFailure = extractRuleFailedException(e_1);
          /* fail error "Elements do not have a common supertype: " + telems.join(', ')["`" + it.itemType.name + "`"] + "." */
          final Function1<RListType, CharSequence> _function_2 = new Function1<RListType, CharSequence>() {
            @Override
            public CharSequence apply(final RListType it) {
              String _name = it.getItemType().getName();
              String _plus = ("`" + _name);
              return (_plus + "`");
            }
          };
          String _join = IterableExtensions.<RListType>join(telems, ", ", _function_2);
          String _plus = ("Elements do not have a common supertype: " + _join);
          String _plus_1 = (_plus + ".");
          String error = _plus_1;
          throwForExplicitFail(error, new ErrorInformation(null, null));
        }
      }
    }
    return new Result<Boolean>(true);
  }

  public Result<Boolean> checkRosettaSymbolReference(final RosettaSymbolReference e) {
    return checkRosettaSymbolReference(null, e);
  }

  public Result<Boolean> checkRosettaSymbolReference(final RuleApplicationTrace _trace_, final RosettaSymbolReference e) {
    try {
    	return checkRosettaSymbolReferenceInternal(_trace_, e);
    } catch (Exception _e_CheckRosettaSymbolReference) {
    	return resultForFailure(_e_CheckRosettaSymbolReference);
    }
  }

  protected Result<Boolean> checkRosettaSymbolReferenceInternal(final RuleApplicationTrace _trace_, final RosettaSymbolReference e) throws RuleFailedException {
    final RosettaSymbol f = e.getSymbol();
    boolean _matched = false;
    if (f instanceof RosettaExternalFunction) {
      _matched=true;
      /* f.parameters.size() == e.args.size() or fail error "Expected " + f.parameters.size() + " argument" + (if (f.parameters.size() === 1) "" else "s") + ", but got " + e.args.size() + " instead." */
      {
        RuleFailedException previousFailure = null;
        try {
          int _size = ((RosettaExternalFunction)f).getParameters().size();
          int _size_1 = e.getArgs().size();
          boolean _equals = (_size == _size_1);
          /* f.parameters.size() == e.args.size() */
          if (!_equals) {
            sneakyThrowRuleFailedException("f.parameters.size() == e.args.size()");
          }
        } catch (Exception e_1) {
          previousFailure = extractRuleFailedException(e_1);
          /* fail error "Expected " + f.parameters.size() + " argument" + (if (f.parameters.size() === 1) "" else "s") + ", but got " + e.args.size() + " instead." */
          int _size_2 = ((RosettaExternalFunction)f).getParameters().size();
          String _plus = ("Expected " + Integer.valueOf(_size_2));
          String _plus_1 = (_plus + " argument");
          String _xifexpression = null;
          int _size_3 = ((RosettaExternalFunction)f).getParameters().size();
          boolean _tripleEquals = (_size_3 == 1);
          if (_tripleEquals) {
            _xifexpression = "";
          } else {
            _xifexpression = "s";
          }
          String _plus_2 = (_plus_1 + _xifexpression);
          String _plus_3 = (_plus_2 + ", but got ");
          int _size_4 = e.getArgs().size();
          String _plus_4 = (_plus_3 + Integer.valueOf(_size_4));
          String _plus_5 = (_plus_4 + " instead.");
          String error = _plus_5;
          throwForExplicitFail(error, new ErrorInformation(null, null));
        }
      }
      int _size_5 = e.getArgs().size();
      final Function1<Integer, Boolean> _function = (Integer idx) -> {
        Boolean _xblockexpression = null;
        {
          final RosettaParameter param = ((RosettaExternalFunction)f).getParameters().get((idx).intValue());
          RListType _xifexpression_1 = null;
          boolean _isIsArray = param.isIsArray();
          if (_isIsArray) {
            TypeCall _typeCall = param.getTypeCall();
            RosettaInterpreterContext _rosettaInterpreterContext = new RosettaInterpreterContext();
            _xifexpression_1 = this.typeFactory.createListType(this.typeCallToRTypeInternal(_trace_, _typeCall, _rosettaInterpreterContext), 0);
          } else {
            TypeCall _typeCall_1 = param.getTypeCall();
            RosettaInterpreterContext _rosettaInterpreterContext_1 = new RosettaInterpreterContext();
            _xifexpression_1 = this.typeFactory.createListType(this.typeCallToRTypeInternal(_trace_, _typeCall_1, _rosettaInterpreterContext_1), 1, 1);
          }
          final RListType paramType = _xifexpression_1;
          _xblockexpression = this.looseListSubtypeCheckInternal(_trace_, e.getArgs().get((idx).intValue()), paramType);
        }
        return _xblockexpression;
      };
      /* (0..<e.args.size).forall[idx | val param = f.parameters.get(idx) val paramType = if (param.isArray) createListType(typeCallToRType(param.typeCall, new RosettaInterpreterContext), 0) else createListType(typeCallToRType(param.typeCall, new RosettaInterpreterContext), 1, 1) looseListSubtypeCheck(e.args.get(idx), paramType) ] */
      if (!IterableExtensions.<Integer>forall(new ExclusiveRange(0, _size_5, true), _function)) {
        sneakyThrowRuleFailedException("(0..<e.args.size).forall[idx | val param = f.parameters.get(idx) val paramType = if (param.isArray) createListType(typeCallToRType(param.typeCall, new RosettaInterpreterContext), 0) else createListType(typeCallToRType(param.typeCall, new RosettaInterpreterContext), 1, 1) looseListSubtypeCheck(e.args.get(idx), paramType) ]");
      }
    }
    if (!_matched) {
      if (f instanceof Function) {
        _matched=true;
        /* f.inputs.size() == e.args.size() or fail error "Expected " + f.inputs.size() + " argument" + (if (f.inputs.size() === 1) "" else "s") + ", but got " + e.args.size() + " instead." */
        {
          RuleFailedException previousFailure = null;
          try {
            int _size = ((Function)f).getInputs().size();
            int _size_1 = e.getArgs().size();
            boolean _equals = (_size == _size_1);
            /* f.inputs.size() == e.args.size() */
            if (!_equals) {
              sneakyThrowRuleFailedException("f.inputs.size() == e.args.size()");
            }
          } catch (Exception e_1) {
            previousFailure = extractRuleFailedException(e_1);
            /* fail error "Expected " + f.inputs.size() + " argument" + (if (f.inputs.size() === 1) "" else "s") + ", but got " + e.args.size() + " instead." */
            int _size_2 = ((Function)f).getInputs().size();
            String _plus = ("Expected " + Integer.valueOf(_size_2));
            String _plus_1 = (_plus + " argument");
            String _xifexpression = null;
            int _size_3 = ((Function)f).getInputs().size();
            boolean _tripleEquals = (_size_3 == 1);
            if (_tripleEquals) {
              _xifexpression = "";
            } else {
              _xifexpression = "s";
            }
            String _plus_2 = (_plus_1 + _xifexpression);
            String _plus_3 = (_plus_2 + ", but got ");
            int _size_4 = e.getArgs().size();
            String _plus_4 = (_plus_3 + Integer.valueOf(_size_4));
            String _plus_5 = (_plus_4 + " instead.");
            String error = _plus_5;
            throwForExplicitFail(error, new ErrorInformation(null, null));
          }
        }
        int _size_5 = e.getArgs().size();
        final Function1<Integer, Boolean> _function = (Integer idx) -> {
          return this.looseListSubtypeCheckInternal(_trace_, e.getArgs().get((idx).intValue()), this.attributeListTypeInternal(_trace_, ((Function)f).getInputs().get((idx).intValue())));
        };
        /* (0..<e.args.size).forall[idx | looseListSubtypeCheck(e.args.get(idx), f.inputs.get(idx).attributeListType) ] */
        if (!IterableExtensions.<Integer>forall(new ExclusiveRange(0, _size_5, true), _function)) {
          sneakyThrowRuleFailedException("(0..<e.args.size).forall[idx | looseListSubtypeCheck(e.args.get(idx), f.inputs.get(idx).attributeListType) ]");
        }
      }
    }
    if (!_matched) {
      if (f instanceof RosettaRule) {
        _matched=true;
        /* 1 == e.args.size() or fail error "Expected 1 argument, but got " + e.args.size() + " instead." */
        {
          RuleFailedException previousFailure = null;
          try {
            int _size = e.getArgs().size();
            boolean _equals = (1 == _size);
            /* 1 == e.args.size() */
            if (!_equals) {
              sneakyThrowRuleFailedException("1 == e.args.size()");
            }
          } catch (Exception e_1) {
            previousFailure = extractRuleFailedException(e_1);
            /* fail error "Expected 1 argument, but got " + e.args.size() + " instead." */
            int _size_1 = e.getArgs().size();
            String _plus = ("Expected 1 argument, but got " + Integer.valueOf(_size_1));
            String _plus_1 = (_plus + " instead.");
            String error = _plus_1;
            throwForExplicitFail(error, new ErrorInformation(null, null));
          }
        }
        TypeCall _input = ((RosettaRule)f).getInput();
        RType _typeCallToRType = null;
        if (_input!=null) {
          RosettaInterpreterContext _rosettaInterpreterContext = new RosettaInterpreterContext();
          _typeCallToRType=this.typeCallToRTypeInternal(_trace_, _input, _rosettaInterpreterContext);
        }
        RListType _createListType = null;
        if (_typeCallToRType!=null) {
          _createListType=this.typeFactory.createListType(_typeCallToRType, this.typeFactory.single);
        }
        final RListType paramType = _createListType;
        if ((paramType != null)) {
          /* looseListSubtypeCheck(e.args.head, paramType) */
          if (!this.looseListSubtypeCheckInternal(_trace_, IterableExtensions.<RosettaExpression>head(e.getArgs()), paramType)) {
            sneakyThrowRuleFailedException("looseListSubtypeCheck(e.args.head, paramType)");
          }
        }
      }
    }
    return new Result<Boolean>(true);
  }

  public Result<Boolean> checkExistsExpression(final RosettaExistsExpression e) {
    return checkExistsExpression(null, e);
  }

  public Result<Boolean> checkExistsExpression(final RuleApplicationTrace _trace_, final RosettaExistsExpression e) {
    try {
    	return checkExistsExpressionInternal(_trace_, e);
    } catch (Exception _e_CheckExistsExpression) {
    	return resultForFailure(_e_CheckExistsExpression);
    }
  }

  protected Result<Boolean> checkExistsExpressionInternal(final RuleApplicationTrace _trace_, final RosettaExistsExpression e) throws RuleFailedException {
    /* isLooserConstraintCheck(e.argument, createConstraint(0, 1)) */
    if (!this.isLooserConstraintCheckInternal(_trace_, e.getArgument(), this.typeFactory.createConstraint(0, 1))) {
      sneakyThrowRuleFailedException("isLooserConstraintCheck(e.argument, createConstraint(0, 1))");
    }
    return new Result<Boolean>(true);
  }

  public Result<Boolean> checkAbsentExpression(final RosettaAbsentExpression e) {
    return checkAbsentExpression(null, e);
  }

  public Result<Boolean> checkAbsentExpression(final RuleApplicationTrace _trace_, final RosettaAbsentExpression e) {
    try {
    	return checkAbsentExpressionInternal(_trace_, e);
    } catch (Exception _e_CheckAbsentExpression) {
    	return resultForFailure(_e_CheckAbsentExpression);
    }
  }

  protected Result<Boolean> checkAbsentExpressionInternal(final RuleApplicationTrace _trace_, final RosettaAbsentExpression e) throws RuleFailedException {
    /* isLooserConstraintCheck(e.argument, createConstraint(0, 1)) */
    if (!this.isLooserConstraintCheckInternal(_trace_, e.getArgument(), this.typeFactory.createConstraint(0, 1))) {
      sneakyThrowRuleFailedException("isLooserConstraintCheck(e.argument, createConstraint(0, 1))");
    }
    return new Result<Boolean>(true);
  }

  public Result<Boolean> checkOnlyExistsExpression(final RosettaOnlyExistsExpression e) {
    return checkOnlyExistsExpression(null, e);
  }

  public Result<Boolean> checkOnlyExistsExpression(final RuleApplicationTrace _trace_, final RosettaOnlyExistsExpression e) {
    try {
    	return checkOnlyExistsExpressionInternal(_trace_, e);
    } catch (Exception _e_CheckOnlyExistsExpression) {
    	return resultForFailure(_e_CheckOnlyExistsExpression);
    }
  }

  protected Result<Boolean> checkOnlyExistsExpressionInternal(final RuleApplicationTrace _trace_, final RosettaOnlyExistsExpression e) throws RuleFailedException {
    final RosettaExpression first = IterableExtensions.<RosettaExpression>head(e.getArgs());
    final RosettaExpression parent = this.exprHelper.getParentExpression(first);
    for (int i = 1; (i < e.getArgs().size()); i++) {
      final RosettaExpression other = e.getArgs().get(i);
      for (int j = 0; (j < i); j++) {
        boolean _equals = EcoreUtil2.equals(e.getArgs().get(j), other);
        if (_equals) {
          /* fail error "Duplicate attribute." source other */
          String error = "Duplicate attribute.";
          EObject source = other;
          throwForExplicitFail(error, new ErrorInformation(source, null));
        }
      }
      final RosettaExpression otherParent = this.exprHelper.getParentExpression(other);
      if (((Boolean.valueOf((parent == null)) != Boolean.valueOf((otherParent == null))) || (((parent != null) && (otherParent != null)) && (!EcoreUtil2.equals(parent, otherParent))))) {
        if ((otherParent != null)) {
          /* fail error "All parent paths must be equal." source otherParent */
          String error = "All parent paths must be equal.";
          EObject source = otherParent;
          throwForExplicitFail(error, new ErrorInformation(source, null));
        } else {
          /* fail error "All parent paths must be equal." source other */
          String error_1 = "All parent paths must be equal.";
          EObject source_1 = other;
          throwForExplicitFail(error_1, new ErrorInformation(source_1, null));
        }
      }
    }
    if (((parent == null) && (!this.implicitVarUtil.implicitVariableExistsInContext(e)))) {
      /* fail error "Object must have a parent object." source e.args.head */
      String error = "Object must have a parent object.";
      RosettaExpression _head = IterableExtensions.<RosettaExpression>head(e.getArgs());
      EObject source = _head;
      throwForExplicitFail(error, new ErrorInformation(source, null));
    }
    RListType parentType = null;
    if ((parent != null)) {
      Boolean _looseConstraintCheck = this.looseConstraintCheckInternal(_trace_, parent, this.typeFactory.single);
      /* looseConstraintCheck(parent, single) */
      if (!_looseConstraintCheck) {
        sneakyThrowRuleFailedException("looseConstraintCheck(parent, single)");
      }
      /* empty |- parent : parentType */
      Result<RListType> result = inferTypeInternal(emptyEnvironment(), _trace_, parent);
      checkAssignableTo(result.getFirst(), RListType.class);
      parentType = (RListType) result.getFirst();
      
    } else {
      parentType = this.typeOfImplicitVariableInternal(_trace_, e).orElse(null);
      if ((parentType != null)) {
        /* single.isSubconstraintOf(parentType.constraint) or fail error notConstraintMessage(single, parentType) source e */
        {
          RuleFailedException previousFailure = null;
          try {
            boolean _isSubconstraintOf = this.typeFactory.single.isSubconstraintOf(parentType.getConstraint());
            /* single.isSubconstraintOf(parentType.constraint) */
            if (!_isSubconstraintOf) {
              sneakyThrowRuleFailedException("single.isSubconstraintOf(parentType.constraint)");
            }
          } catch (Exception e_1) {
            previousFailure = extractRuleFailedException(e_1);
            /* fail error notConstraintMessage(single, parentType) source e */
            String _notConstraintMessage = this.util.notConstraintMessage(this.typeFactory.single, parentType);
            String error_1 = _notConstraintMessage;
            EObject source_1 = e;
            throwForExplicitFail(error_1, new ErrorInformation(source_1, null));
          }
        }
      }
    }
    if ((parentType != null)) {
      RType _itemType = parentType.getItemType();
      final Data parentData = ((RDataType) _itemType).getData();
      if ((parentData != null)) {
        /* mayBeEmpty(parentData) or fail error "The `only exists` operator is not applicable to instances of `" + parentData.name + "`." source parent */
        {
          RuleFailedException previousFailure = null;
          try {
            Boolean _mayBeEmpty = this.mayBeEmptyInternal(_trace_, parentData);
            /* mayBeEmpty(parentData) */
            if (!_mayBeEmpty) {
              sneakyThrowRuleFailedException("mayBeEmpty(parentData)");
            }
          } catch (Exception e_2) {
            previousFailure = extractRuleFailedException(e_2);
            /* fail error "The `only exists` operator is not applicable to instances of `" + parentData.name + "`." source parent */
            String _name = parentData.getName();
            String _plus = ("The `only exists` operator is not applicable to instances of `" + _name);
            String _plus_1 = (_plus + "`.");
            String error_2 = _plus_1;
            EObject source_2 = parent;
            throwForExplicitFail(error_2, new ErrorInformation(source_2, null));
          }
        }
      }
    }
    return new Result<Boolean>(true);
  }

  public Result<Boolean> checkOneOfOperation(final OneOfOperation e) {
    return checkOneOfOperation(null, e);
  }

  public Result<Boolean> checkOneOfOperation(final RuleApplicationTrace _trace_, final OneOfOperation e) {
    try {
    	return checkOneOfOperationInternal(_trace_, e);
    } catch (Exception _e_CheckOneOfOperation) {
    	return resultForFailure(_e_CheckOneOfOperation);
    }
  }

  protected Result<Boolean> checkOneOfOperationInternal(final RuleApplicationTrace _trace_, final OneOfOperation e) throws RuleFailedException {
    Boolean _looseConstraintCheck = this.looseConstraintCheckInternal(_trace_, e.getArgument(), this.typeFactory.single);
    /* looseConstraintCheck(e.argument, single) */
    if (!_looseConstraintCheck) {
      sneakyThrowRuleFailedException("looseConstraintCheck(e.argument, single)");
    }
    /* empty |- e.argument : var RListType pt */
    RosettaExpression _argument = e.getArgument();
    RListType pt = null;
    Result<RListType> result = inferTypeInternal(emptyEnvironment(), _trace_, _argument);
    checkAssignableTo(result.getFirst(), RListType.class);
    pt = (RListType) result.getFirst();
    
    if ((pt != null)) {
      final RType itemType = pt.getItemType();
      if ((!(itemType instanceof RDataType))) {
        /* fail error "The `" + e.operator + "` operator is not applicable to instances of `" + itemType + "`." source e.argument */
        String _operator = e.getOperator();
        String _plus = ("The `" + _operator);
        String _plus_1 = (_plus + "` operator is not applicable to instances of `");
        String _plus_2 = (_plus_1 + itemType);
        String _plus_3 = (_plus_2 + "`.");
        String error = _plus_3;
        RosettaExpression _argument_1 = e.getArgument();
        EObject source = _argument_1;
        throwForExplicitFail(error, new ErrorInformation(source, null));
      }
    }
    return new Result<Boolean>(true);
  }

  public Result<Boolean> checkChoiceOperation(final ChoiceOperation e) {
    return checkChoiceOperation(null, e);
  }

  public Result<Boolean> checkChoiceOperation(final RuleApplicationTrace _trace_, final ChoiceOperation e) {
    try {
    	return checkChoiceOperationInternal(_trace_, e);
    } catch (Exception _e_CheckChoiceOperation) {
    	return resultForFailure(_e_CheckChoiceOperation);
    }
  }

  protected Result<Boolean> checkChoiceOperationInternal(final RuleApplicationTrace _trace_, final ChoiceOperation e) throws RuleFailedException {
    Boolean _looseConstraintCheck = this.looseConstraintCheckInternal(_trace_, e.getArgument(), this.typeFactory.single);
    /* looseConstraintCheck(e.argument, single) */
    if (!_looseConstraintCheck) {
      sneakyThrowRuleFailedException("looseConstraintCheck(e.argument, single)");
    }
    /* empty |- e.argument : var RListType pt */
    RosettaExpression _argument = e.getArgument();
    RListType pt = null;
    Result<RListType> result = inferTypeInternal(emptyEnvironment(), _trace_, _argument);
    checkAssignableTo(result.getFirst(), RListType.class);
    pt = (RListType) result.getFirst();
    
    if ((pt != null)) {
      final RType itemType = pt.getItemType();
      if ((!(itemType instanceof RDataType))) {
        /* fail error "The `" + e.operator + "` operator is not applicable to instances of `" + itemType + "`." source e.argument */
        String _operator = e.getOperator();
        String _plus = ("The `" + _operator);
        String _plus_1 = (_plus + "` operator is not applicable to instances of `");
        String _plus_2 = (_plus_1 + itemType);
        String _plus_3 = (_plus_2 + "`.");
        String error = _plus_3;
        RosettaExpression _argument_1 = e.getArgument();
        EObject source = _argument_1;
        throwForExplicitFail(error, new ErrorInformation(source, null));
      }
    }
    int _size = e.getAttributes().size();
    boolean _lessThan = (_size < 2);
    if (_lessThan) {
      /* fail error "At least two attributes must be passed to a choice rule." feature CHOICE_OPERATION__ATTRIBUTES */
      String error_1 = "At least two attributes must be passed to a choice rule.";
      EStructuralFeature feature = ExpressionPackage.Literals.CHOICE_OPERATION__ATTRIBUTES;
      throwForExplicitFail(error_1, new ErrorInformation(null, feature));
    }
    return new Result<Boolean>(true);
  }

  protected Boolean listSubtypeCheckInternal(final RuleApplicationTrace _trace_, final RosettaExpression sourceObject, final RListType expected) {
    try {
    	checkParamsNotNull(sourceObject, expected);
    	return listSubtypeCheckDispatcher.invoke(_trace_, sourceObject, expected);
    } catch (Exception _e_listSubtypeCheck) {
    	sneakyThrowRuleFailedException(_e_listSubtypeCheck);
    	return false;
    }
  }

  protected void listSubtypeCheckThrowException(final String _error, final String _issue, final Exception _ex, final RosettaExpression sourceObject, final RListType expected, final ErrorInformation[] _errorInformations) throws RuleFailedException {
    throwRuleFailedException(_error, _issue, _ex, _errorInformations);
  }

  protected Boolean looseListSubtypeCheckInternal(final RuleApplicationTrace _trace_, final RosettaExpression sourceObject, final RListType expected) {
    try {
    	checkParamsNotNull(sourceObject, expected);
    	return looseListSubtypeCheckDispatcher.invoke(_trace_, sourceObject, expected);
    } catch (Exception _e_looseListSubtypeCheck) {
    	sneakyThrowRuleFailedException(_e_looseListSubtypeCheck);
    	return false;
    }
  }

  protected void looseListSubtypeCheckThrowException(final String _error, final String _issue, final Exception _ex, final RosettaExpression sourceObject, final RListType expected, final ErrorInformation[] _errorInformations) throws RuleFailedException {
    throwRuleFailedException(_error, _issue, _ex, _errorInformations);
  }

  protected Boolean subtypeCheckInternal(final RuleApplicationTrace _trace_, final RosettaExpression sourceObject, final RType expected) {
    try {
    	checkParamsNotNull(sourceObject, expected);
    	return subtypeCheckDispatcher.invoke(_trace_, sourceObject, expected);
    } catch (Exception _e_subtypeCheck) {
    	sneakyThrowRuleFailedException(_e_subtypeCheck);
    	return false;
    }
  }

  protected void subtypeCheckThrowException(final String _error, final String _issue, final Exception _ex, final RosettaExpression sourceObject, final RType expected, final ErrorInformation[] _errorInformations) throws RuleFailedException {
    throwRuleFailedException(_error, _issue, _ex, _errorInformations);
  }

  protected Boolean comparableListTypeCheckInternal(final RuleApplicationTrace _trace_, final RosettaBinaryOperation sourceObject) {
    try {
    	checkParamsNotNull(sourceObject);
    	return comparableListTypeCheckDispatcher.invoke(_trace_, sourceObject);
    } catch (Exception _e_comparableListTypeCheck) {
    	sneakyThrowRuleFailedException(_e_comparableListTypeCheck);
    	return false;
    }
  }

  protected void comparableListTypeCheckThrowException(final String _error, final String _issue, final Exception _ex, final RosettaBinaryOperation sourceObject, final ErrorInformation[] _errorInformations) throws RuleFailedException {
    throwRuleFailedException(_error, _issue, _ex, _errorInformations);
  }

  protected Boolean comparableTypeCheckInternal(final RuleApplicationTrace _trace_, final RosettaBinaryOperation sourceObject) {
    try {
    	checkParamsNotNull(sourceObject);
    	return comparableTypeCheckDispatcher.invoke(_trace_, sourceObject);
    } catch (Exception _e_comparableTypeCheck) {
    	sneakyThrowRuleFailedException(_e_comparableTypeCheck);
    	return false;
    }
  }

  protected void comparableTypeCheckThrowException(final String _error, final String _issue, final Exception _ex, final RosettaBinaryOperation sourceObject, final ErrorInformation[] _errorInformations) throws RuleFailedException {
    throwRuleFailedException(_error, _issue, _ex, _errorInformations);
  }

  protected Boolean onlyRightIsSingularCheckInternal(final RuleApplicationTrace _trace_, final ModifiableBinaryOperation sourceObject) {
    try {
    	checkParamsNotNull(sourceObject);
    	return onlyRightIsSingularCheckDispatcher.invoke(_trace_, sourceObject);
    } catch (Exception _e_onlyRightIsSingularCheck) {
    	sneakyThrowRuleFailedException(_e_onlyRightIsSingularCheck);
    	return false;
    }
  }

  protected void onlyRightIsSingularCheckThrowException(final String _error, final String _issue, final Exception _ex, final ModifiableBinaryOperation sourceObject, final ErrorInformation[] _errorInformations) throws RuleFailedException {
    throwRuleFailedException(_error, _issue, _ex, _errorInformations);
  }

  protected Boolean looseOnlyRightIsSingularCheckInternal(final RuleApplicationTrace _trace_, final ModifiableBinaryOperation sourceObject) {
    try {
    	checkParamsNotNull(sourceObject);
    	return looseOnlyRightIsSingularCheckDispatcher.invoke(_trace_, sourceObject);
    } catch (Exception _e_looseOnlyRightIsSingularCheck) {
    	sneakyThrowRuleFailedException(_e_looseOnlyRightIsSingularCheck);
    	return false;
    }
  }

  protected void looseOnlyRightIsSingularCheckThrowException(final String _error, final String _issue, final Exception _ex, final ModifiableBinaryOperation sourceObject, final ErrorInformation[] _errorInformations) throws RuleFailedException {
    throwRuleFailedException(_error, _issue, _ex, _errorInformations);
  }

  protected Boolean constraintCheckInternal(final RuleApplicationTrace _trace_, final RosettaExpression sourceObject, final RosettaCardinality expected) {
    try {
    	checkParamsNotNull(sourceObject, expected);
    	return constraintCheckDispatcher.invoke(_trace_, sourceObject, expected);
    } catch (Exception _e_constraintCheck) {
    	sneakyThrowRuleFailedException(_e_constraintCheck);
    	return false;
    }
  }

  protected void constraintCheckThrowException(final String _error, final String _issue, final Exception _ex, final RosettaExpression sourceObject, final RosettaCardinality expected, final ErrorInformation[] _errorInformations) throws RuleFailedException {
    throwRuleFailedException(_error, _issue, _ex, _errorInformations);
  }

  protected Boolean looseConstraintCheckInternal(final RuleApplicationTrace _trace_, final RosettaExpression sourceObject, final RosettaCardinality expected) {
    try {
    	checkParamsNotNull(sourceObject, expected);
    	return looseConstraintCheckDispatcher.invoke(_trace_, sourceObject, expected);
    } catch (Exception _e_looseConstraintCheck) {
    	sneakyThrowRuleFailedException(_e_looseConstraintCheck);
    	return false;
    }
  }

  protected void looseConstraintCheckThrowException(final String _error, final String _issue, final Exception _ex, final RosettaExpression sourceObject, final RosettaCardinality expected, final ErrorInformation[] _errorInformations) throws RuleFailedException {
    throwRuleFailedException(_error, _issue, _ex, _errorInformations);
  }

  protected Boolean notConstraintCheckInternal(final RuleApplicationTrace _trace_, final RosettaExpression sourceObject, final RosettaCardinality notExpected) {
    try {
    	checkParamsNotNull(sourceObject, notExpected);
    	return notConstraintCheckDispatcher.invoke(_trace_, sourceObject, notExpected);
    } catch (Exception _e_notConstraintCheck) {
    	sneakyThrowRuleFailedException(_e_notConstraintCheck);
    	return false;
    }
  }

  protected void notConstraintCheckThrowException(final String _error, final String _issue, final Exception _ex, final RosettaExpression sourceObject, final RosettaCardinality notExpected, final ErrorInformation[] _errorInformations) throws RuleFailedException {
    throwRuleFailedException(_error, _issue, _ex, _errorInformations);
  }

  protected Boolean isLooserConstraintCheckInternal(final RuleApplicationTrace _trace_, final RosettaExpression sourceObject, final RosettaCardinality expected) {
    try {
    	checkParamsNotNull(sourceObject, expected);
    	return isLooserConstraintCheckDispatcher.invoke(_trace_, sourceObject, expected);
    } catch (Exception _e_isLooserConstraintCheck) {
    	sneakyThrowRuleFailedException(_e_isLooserConstraintCheck);
    	return false;
    }
  }

  protected void isLooserConstraintCheckThrowException(final String _error, final String _issue, final Exception _ex, final RosettaExpression sourceObject, final RosettaCardinality expected, final ErrorInformation[] _errorInformations) throws RuleFailedException {
    throwRuleFailedException(_error, _issue, _ex, _errorInformations);
  }

  protected Boolean listSubtypeCheckImpl(final RuleApplicationTrace _trace_, final RosettaExpression sourceObject, final RListType expected) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Boolean _result_ = applyAuxFunListSubtypeCheck(_subtrace_, sourceObject, expected);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("listSubtypeCheck") + "(" + stringRep(sourceObject) + ", " + stringRep(expected)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunListSubtypeCheck) {
    	listSubtypeCheckThrowException(auxFunName("listSubtypeCheck") + "(" + stringRep(sourceObject) + ", " + stringRep(expected)+ ")",
    		LISTSUBTYPECHECK,
    		e_applyAuxFunListSubtypeCheck, sourceObject, expected, new ErrorInformation[] {new ErrorInformation(sourceObject)});
    	return false;
    }
  }

  protected Boolean applyAuxFunListSubtypeCheck(final RuleApplicationTrace _trace_, final RosettaExpression sourceObject, final RListType expected) throws RuleFailedException {
    RListType actual = null;
    /* empty |- sourceObject : actual or actual = null */
    {
      RuleFailedException previousFailure = null;
      try {
        /* empty |- sourceObject : actual */
        Result<RListType> result = inferTypeInternal(emptyEnvironment(), _trace_, sourceObject);
        checkAssignableTo(result.getFirst(), RListType.class);
        actual = (RListType) result.getFirst();
        
      } catch (Exception e) {
        previousFailure = extractRuleFailedException(e);
        actual = null;
      }
    }
    boolean _and = false;
    if (!((expected != null) && (actual != null))) {
      _and = false;
    } else {
      /* empty |- actual <| expected */
      boolean _ruleinvocation = listSubtypeSucceeded(emptyEnvironment(), _trace_, actual, expected);
      boolean _not = (!_ruleinvocation);
      _and = _not;
    }
    if (_and) {
      /* fail error notAListSubtypeMessage(expected, actual) source sourceObject */
      String _notAListSubtypeMessage = this.util.notAListSubtypeMessage(expected, actual);
      String error = _notAListSubtypeMessage;
      EObject source = sourceObject;
      throwForExplicitFail(error, new ErrorInformation(source, null));
    }
    return true;
  }

  protected Boolean looseListSubtypeCheckImpl(final RuleApplicationTrace _trace_, final RosettaExpression sourceObject, final RListType expected) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Boolean _result_ = applyAuxFunLooseListSubtypeCheck(_subtrace_, sourceObject, expected);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("looseListSubtypeCheck") + "(" + stringRep(sourceObject) + ", " + stringRep(expected)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunLooseListSubtypeCheck) {
    	looseListSubtypeCheckThrowException(auxFunName("looseListSubtypeCheck") + "(" + stringRep(sourceObject) + ", " + stringRep(expected)+ ")",
    		LOOSELISTSUBTYPECHECK,
    		e_applyAuxFunLooseListSubtypeCheck, sourceObject, expected, new ErrorInformation[] {new ErrorInformation(sourceObject)});
    	return false;
    }
  }

  protected Boolean applyAuxFunLooseListSubtypeCheck(final RuleApplicationTrace _trace_, final RosettaExpression sourceObject, final RListType expected) throws RuleFailedException {
    RListType actual = null;
    /* empty |- sourceObject : actual or actual = null */
    {
      RuleFailedException previousFailure = null;
      try {
        /* empty |- sourceObject : actual */
        Result<RListType> result = inferTypeInternal(emptyEnvironment(), _trace_, sourceObject);
        checkAssignableTo(result.getFirst(), RListType.class);
        actual = (RListType) result.getFirst();
        
      } catch (Exception e) {
        previousFailure = extractRuleFailedException(e);
        actual = null;
      }
    }
    boolean _and = false;
    if (!((expected != null) && (actual != null))) {
      _and = false;
    } else {
      boolean _and_1 = false;
      /* empty |- actual.itemType <: expected.itemType */
      RType _itemType = actual.getItemType();
      RType _itemType_1 = expected.getItemType();
      boolean _ruleinvocation = subtypeSucceeded(emptyEnvironment(), _trace_, _itemType, _itemType_1);
      if (!_ruleinvocation) {
        _and_1 = false;
      } else {
        Boolean _overlap = this.overlapInternal(_trace_, expected.getConstraint(), actual.getConstraint());
        _and_1 = (_overlap).booleanValue();
      }
      boolean _not = (!_and_1);
      _and = _not;
    }
    if (_and) {
      /* fail error notAListSubtypeMessage(expected, actual) source sourceObject */
      String _notAListSubtypeMessage = this.util.notAListSubtypeMessage(expected, actual);
      String error = _notAListSubtypeMessage;
      EObject source = sourceObject;
      throwForExplicitFail(error, new ErrorInformation(source, null));
    }
    return true;
  }

  protected Boolean subtypeCheckImpl(final RuleApplicationTrace _trace_, final RosettaExpression sourceObject, final RType expected) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Boolean _result_ = applyAuxFunSubtypeCheck(_subtrace_, sourceObject, expected);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("subtypeCheck") + "(" + stringRep(sourceObject) + ", " + stringRep(expected)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunSubtypeCheck) {
    	subtypeCheckThrowException(auxFunName("subtypeCheck") + "(" + stringRep(sourceObject) + ", " + stringRep(expected)+ ")",
    		SUBTYPECHECK,
    		e_applyAuxFunSubtypeCheck, sourceObject, expected, new ErrorInformation[] {new ErrorInformation(sourceObject)});
    	return false;
    }
  }

  protected Boolean applyAuxFunSubtypeCheck(final RuleApplicationTrace _trace_, final RosettaExpression sourceObject, final RType expected) throws RuleFailedException {
    RListType actual = null;
    /* empty |- sourceObject : actual or actual = null */
    {
      RuleFailedException previousFailure = null;
      try {
        /* empty |- sourceObject : actual */
        Result<RListType> result = inferTypeInternal(emptyEnvironment(), _trace_, sourceObject);
        checkAssignableTo(result.getFirst(), RListType.class);
        actual = (RListType) result.getFirst();
        
      } catch (Exception e) {
        previousFailure = extractRuleFailedException(e);
        actual = null;
      }
    }
    boolean _and = false;
    if (!((expected != null) && (actual != null))) {
      _and = false;
    } else {
      /* empty |- actual.itemType <: expected */
      RType _itemType = actual.getItemType();
      boolean _ruleinvocation = subtypeSucceeded(emptyEnvironment(), _trace_, _itemType, expected);
      boolean _not = (!_ruleinvocation);
      _and = _not;
    }
    if (_and) {
      /* fail error notASubtypeMessage(expected, actual.itemType) source sourceObject */
      String _notASubtypeMessage = this.util.notASubtypeMessage(expected, actual.getItemType());
      String error = _notASubtypeMessage;
      EObject source = sourceObject;
      throwForExplicitFail(error, new ErrorInformation(source, null));
    }
    return true;
  }

  protected Boolean comparableListTypeCheckImpl(final RuleApplicationTrace _trace_, final RosettaBinaryOperation sourceObject) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Boolean _result_ = applyAuxFunComparableListTypeCheck(_subtrace_, sourceObject);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("comparableListTypeCheck") + "(" + stringRep(sourceObject)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunComparableListTypeCheck) {
    	comparableListTypeCheckThrowException(auxFunName("comparableListTypeCheck") + "(" + stringRep(sourceObject)+ ")",
    		COMPARABLELISTTYPECHECK,
    		e_applyAuxFunComparableListTypeCheck, sourceObject, new ErrorInformation[] {new ErrorInformation(sourceObject)});
    	return false;
    }
  }

  protected Boolean applyAuxFunComparableListTypeCheck(final RuleApplicationTrace _trace_, final RosettaBinaryOperation sourceObject) throws RuleFailedException {
    RListType tl = null;
    RListType tr = null;
    /* empty |- sourceObject.left : tl or tl = null */
    {
      RuleFailedException previousFailure = null;
      try {
        /* empty |- sourceObject.left : tl */
        RosettaExpression _left = sourceObject.getLeft();
        Result<RListType> result = inferTypeInternal(emptyEnvironment(), _trace_, _left);
        checkAssignableTo(result.getFirst(), RListType.class);
        tl = (RListType) result.getFirst();
        
      } catch (Exception e) {
        previousFailure = extractRuleFailedException(e);
        tl = null;
      }
    }
    /* empty |- sourceObject.right : tr or tr = null */
    {
      RuleFailedException previousFailure = null;
      try {
        /* empty |- sourceObject.right : tr */
        RosettaExpression _right = sourceObject.getRight();
        Result<RListType> result_1 = inferTypeInternal(emptyEnvironment(), _trace_, _right);
        checkAssignableTo(result_1.getFirst(), RListType.class);
        tr = (RListType) result_1.getFirst();
        
      } catch (Exception e_1) {
        previousFailure = extractRuleFailedException(e_1);
        tr = null;
      }
    }
    if (((tl != null) && (tr != null))) {
      /* tl.listComparable(tr) or fail error notListComparableMessage(tl, tr) source sourceObject */
      {
        RuleFailedException previousFailure = null;
        try {
          Boolean _listComparable = this.listComparableInternal(_trace_, tl, tr);
          /* tl.listComparable(tr) */
          if (!_listComparable) {
            sneakyThrowRuleFailedException("tl.listComparable(tr)");
          }
        } catch (Exception e_2) {
          previousFailure = extractRuleFailedException(e_2);
          /* fail error notListComparableMessage(tl, tr) source sourceObject */
          String _notListComparableMessage = this.util.notListComparableMessage(tl, tr);
          String error = _notListComparableMessage;
          EObject source = sourceObject;
          throwForExplicitFail(error, new ErrorInformation(source, null));
        }
      }
    }
    return true;
  }

  protected Boolean comparableTypeCheckImpl(final RuleApplicationTrace _trace_, final RosettaBinaryOperation sourceObject) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Boolean _result_ = applyAuxFunComparableTypeCheck(_subtrace_, sourceObject);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("comparableTypeCheck") + "(" + stringRep(sourceObject)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunComparableTypeCheck) {
    	comparableTypeCheckThrowException(auxFunName("comparableTypeCheck") + "(" + stringRep(sourceObject)+ ")",
    		COMPARABLETYPECHECK,
    		e_applyAuxFunComparableTypeCheck, sourceObject, new ErrorInformation[] {new ErrorInformation(sourceObject)});
    	return false;
    }
  }

  protected Boolean applyAuxFunComparableTypeCheck(final RuleApplicationTrace _trace_, final RosettaBinaryOperation sourceObject) throws RuleFailedException {
    RListType tl = null;
    RListType tr = null;
    /* empty |- sourceObject.left : tl or tl = null */
    {
      RuleFailedException previousFailure = null;
      try {
        /* empty |- sourceObject.left : tl */
        RosettaExpression _left = sourceObject.getLeft();
        Result<RListType> result = inferTypeInternal(emptyEnvironment(), _trace_, _left);
        checkAssignableTo(result.getFirst(), RListType.class);
        tl = (RListType) result.getFirst();
        
      } catch (Exception e) {
        previousFailure = extractRuleFailedException(e);
        tl = null;
      }
    }
    /* empty |- sourceObject.right : tr or tr = null */
    {
      RuleFailedException previousFailure = null;
      try {
        /* empty |- sourceObject.right : tr */
        RosettaExpression _right = sourceObject.getRight();
        Result<RListType> result_1 = inferTypeInternal(emptyEnvironment(), _trace_, _right);
        checkAssignableTo(result_1.getFirst(), RListType.class);
        tr = (RListType) result_1.getFirst();
        
      } catch (Exception e_1) {
        previousFailure = extractRuleFailedException(e_1);
        tr = null;
      }
    }
    if (((tl != null) && (tr != null))) {
      /* tl.itemType.comparable(tr.itemType) or fail error notComparableMessage(tl.itemType, tr.itemType) source sourceObject */
      {
        RuleFailedException previousFailure = null;
        try {
          Boolean _comparable = this.comparableInternal(_trace_, tl.getItemType(), tr.getItemType());
          /* tl.itemType.comparable(tr.itemType) */
          if (!_comparable) {
            sneakyThrowRuleFailedException("tl.itemType.comparable(tr.itemType)");
          }
        } catch (Exception e_2) {
          previousFailure = extractRuleFailedException(e_2);
          /* fail error notComparableMessage(tl.itemType, tr.itemType) source sourceObject */
          String _notComparableMessage = this.util.notComparableMessage(tl.getItemType(), tr.getItemType());
          String error = _notComparableMessage;
          EObject source = sourceObject;
          throwForExplicitFail(error, new ErrorInformation(source, null));
        }
      }
    }
    return true;
  }

  protected Boolean onlyRightIsSingularCheckImpl(final RuleApplicationTrace _trace_, final ModifiableBinaryOperation sourceObject) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Boolean _result_ = applyAuxFunOnlyRightIsSingularCheck(_subtrace_, sourceObject);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("onlyRightIsSingularCheck") + "(" + stringRep(sourceObject)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunOnlyRightIsSingularCheck) {
    	onlyRightIsSingularCheckThrowException(auxFunName("onlyRightIsSingularCheck") + "(" + stringRep(sourceObject)+ ")",
    		ONLYRIGHTISSINGULARCHECK,
    		e_applyAuxFunOnlyRightIsSingularCheck, sourceObject, new ErrorInformation[] {new ErrorInformation(sourceObject)});
    	return false;
    }
  }

  protected Boolean applyAuxFunOnlyRightIsSingularCheck(final RuleApplicationTrace _trace_, final ModifiableBinaryOperation sourceObject) throws RuleFailedException {
    RListType tl = null;
    RListType tr = null;
    /* empty |- sourceObject.left : tl or tl = null */
    {
      RuleFailedException previousFailure = null;
      try {
        /* empty |- sourceObject.left : tl */
        RosettaExpression _left = sourceObject.getLeft();
        Result<RListType> result = inferTypeInternal(emptyEnvironment(), _trace_, _left);
        checkAssignableTo(result.getFirst(), RListType.class);
        tl = (RListType) result.getFirst();
        
      } catch (Exception e) {
        previousFailure = extractRuleFailedException(e);
        tl = null;
      }
    }
    /* empty |- sourceObject.right : tr or tr = null */
    {
      RuleFailedException previousFailure = null;
      try {
        /* empty |- sourceObject.right : tr */
        RosettaExpression _right = sourceObject.getRight();
        Result<RListType> result_1 = inferTypeInternal(emptyEnvironment(), _trace_, _right);
        checkAssignableTo(result_1.getFirst(), RListType.class);
        tr = (RListType) result_1.getFirst();
        
      } catch (Exception e_1) {
        previousFailure = extractRuleFailedException(e_1);
        tr = null;
      }
    }
    if (((tl != null) && (tr != null))) {
      /* !tl.constraint.constraintEquals(single) && tr.constraint.constraintEquals(single) or { if (tl.constraint.constraintEquals(single)) { if (tr.constraint.constraintEquals(single)) { fail error bothAreSingularMessage(sourceObject) source sourceObject feature ExpressionPackage.Literals.MODIFIABLE_BINARY_OPERATION__CARD_MOD } else { fail error notRightIsSingularButLeftIsMessage(tr) source sourceObject.right } } else { fail error notConstraintMessage(single, tr) source sourceObject.right } } */
      {
        RuleFailedException previousFailure = null;
        try {
          /* !tl.constraint.constraintEquals(single) && tr.constraint.constraintEquals(single) */
          if (!((!tl.getConstraint().constraintEquals(this.typeFactory.single)) && tr.getConstraint().constraintEquals(this.typeFactory.single))) {
            sneakyThrowRuleFailedException("!tl.constraint.constraintEquals(single) && tr.constraint.constraintEquals(single)");
          }
        } catch (Exception e_2) {
          previousFailure = extractRuleFailedException(e_2);
          boolean _constraintEquals = tl.getConstraint().constraintEquals(this.typeFactory.single);
          if (_constraintEquals) {
            boolean _constraintEquals_1 = tr.getConstraint().constraintEquals(this.typeFactory.single);
            if (_constraintEquals_1) {
              /* fail error bothAreSingularMessage(sourceObject) source sourceObject feature ExpressionPackage.Literals.MODIFIABLE_BINARY_OPERATION__CARD_MOD */
              String _bothAreSingularMessage = this.util.bothAreSingularMessage(sourceObject);
              String error = _bothAreSingularMessage;
              EObject source = sourceObject;
              EStructuralFeature feature = ExpressionPackage.Literals.MODIFIABLE_BINARY_OPERATION__CARD_MOD;
              throwForExplicitFail(error, new ErrorInformation(source, feature));
            } else {
              /* fail error notRightIsSingularButLeftIsMessage(tr) source sourceObject.right */
              String _notRightIsSingularButLeftIsMessage = this.util.notRightIsSingularButLeftIsMessage(tr);
              String error_1 = _notRightIsSingularButLeftIsMessage;
              RosettaExpression _right_1 = sourceObject.getRight();
              EObject source_1 = _right_1;
              throwForExplicitFail(error_1, new ErrorInformation(source_1, null));
            }
          } else {
            /* fail error notConstraintMessage(single, tr) source sourceObject.right */
            String _notConstraintMessage = this.util.notConstraintMessage(this.typeFactory.single, tr);
            String error_2 = _notConstraintMessage;
            RosettaExpression _right_2 = sourceObject.getRight();
            EObject source_2 = _right_2;
            throwForExplicitFail(error_2, new ErrorInformation(source_2, null));
          }
        }
      }
    }
    return true;
  }

  protected Boolean looseOnlyRightIsSingularCheckImpl(final RuleApplicationTrace _trace_, final ModifiableBinaryOperation sourceObject) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Boolean _result_ = applyAuxFunLooseOnlyRightIsSingularCheck(_subtrace_, sourceObject);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("looseOnlyRightIsSingularCheck") + "(" + stringRep(sourceObject)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunLooseOnlyRightIsSingularCheck) {
    	looseOnlyRightIsSingularCheckThrowException(auxFunName("looseOnlyRightIsSingularCheck") + "(" + stringRep(sourceObject)+ ")",
    		LOOSEONLYRIGHTISSINGULARCHECK,
    		e_applyAuxFunLooseOnlyRightIsSingularCheck, sourceObject, new ErrorInformation[] {new ErrorInformation(sourceObject)});
    	return false;
    }
  }

  protected Boolean applyAuxFunLooseOnlyRightIsSingularCheck(final RuleApplicationTrace _trace_, final ModifiableBinaryOperation sourceObject) throws RuleFailedException {
    RListType tl = null;
    RListType tr = null;
    /* empty |- sourceObject.left : tl or tl = null */
    {
      RuleFailedException previousFailure = null;
      try {
        /* empty |- sourceObject.left : tl */
        RosettaExpression _left = sourceObject.getLeft();
        Result<RListType> result = inferTypeInternal(emptyEnvironment(), _trace_, _left);
        checkAssignableTo(result.getFirst(), RListType.class);
        tl = (RListType) result.getFirst();
        
      } catch (Exception e) {
        previousFailure = extractRuleFailedException(e);
        tl = null;
      }
    }
    /* empty |- sourceObject.right : tr or tr = null */
    {
      RuleFailedException previousFailure = null;
      try {
        /* empty |- sourceObject.right : tr */
        RosettaExpression _right = sourceObject.getRight();
        Result<RListType> result_1 = inferTypeInternal(emptyEnvironment(), _trace_, _right);
        checkAssignableTo(result_1.getFirst(), RListType.class);
        tr = (RListType) result_1.getFirst();
        
      } catch (Exception e_1) {
        previousFailure = extractRuleFailedException(e_1);
        tr = null;
      }
    }
    if (((tl != null) && (tr != null))) {
      /* !tl.constraint.constraintEquals(single) && single.isSubconstraintOf(tr.constraint) or { if (tl.constraint.constraintEquals(single)) { if (tr.constraint.constraintEquals(single)) { fail error bothAreSingularMessage(sourceObject) source sourceObject feature ExpressionPackage.Literals.MODIFIABLE_BINARY_OPERATION__CARD_MOD } else { fail error notRightIsSingularButLeftIsMessage(tr) source sourceObject.right } } else { fail error notConstraintMessage(single, tr) source sourceObject.right } } */
      {
        RuleFailedException previousFailure = null;
        try {
          /* !tl.constraint.constraintEquals(single) && single.isSubconstraintOf(tr.constraint) */
          if (!((!tl.getConstraint().constraintEquals(this.typeFactory.single)) && this.typeFactory.single.isSubconstraintOf(tr.getConstraint()))) {
            sneakyThrowRuleFailedException("!tl.constraint.constraintEquals(single) && single.isSubconstraintOf(tr.constraint)");
          }
        } catch (Exception e_2) {
          previousFailure = extractRuleFailedException(e_2);
          boolean _constraintEquals = tl.getConstraint().constraintEquals(this.typeFactory.single);
          if (_constraintEquals) {
            boolean _constraintEquals_1 = tr.getConstraint().constraintEquals(this.typeFactory.single);
            if (_constraintEquals_1) {
              /* fail error bothAreSingularMessage(sourceObject) source sourceObject feature ExpressionPackage.Literals.MODIFIABLE_BINARY_OPERATION__CARD_MOD */
              String _bothAreSingularMessage = this.util.bothAreSingularMessage(sourceObject);
              String error = _bothAreSingularMessage;
              EObject source = sourceObject;
              EStructuralFeature feature = ExpressionPackage.Literals.MODIFIABLE_BINARY_OPERATION__CARD_MOD;
              throwForExplicitFail(error, new ErrorInformation(source, feature));
            } else {
              /* fail error notRightIsSingularButLeftIsMessage(tr) source sourceObject.right */
              String _notRightIsSingularButLeftIsMessage = this.util.notRightIsSingularButLeftIsMessage(tr);
              String error_1 = _notRightIsSingularButLeftIsMessage;
              RosettaExpression _right_1 = sourceObject.getRight();
              EObject source_1 = _right_1;
              throwForExplicitFail(error_1, new ErrorInformation(source_1, null));
            }
          } else {
            /* fail error notConstraintMessage(single, tr) source sourceObject.right */
            String _notConstraintMessage = this.util.notConstraintMessage(this.typeFactory.single, tr);
            String error_2 = _notConstraintMessage;
            RosettaExpression _right_2 = sourceObject.getRight();
            EObject source_2 = _right_2;
            throwForExplicitFail(error_2, new ErrorInformation(source_2, null));
          }
        }
      }
    }
    return true;
  }

  protected Boolean constraintCheckImpl(final RuleApplicationTrace _trace_, final RosettaExpression sourceObject, final RosettaCardinality expected) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Boolean _result_ = applyAuxFunConstraintCheck(_subtrace_, sourceObject, expected);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("constraintCheck") + "(" + stringRep(sourceObject) + ", " + stringRep(expected)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunConstraintCheck) {
    	constraintCheckThrowException(auxFunName("constraintCheck") + "(" + stringRep(sourceObject) + ", " + stringRep(expected)+ ")",
    		CONSTRAINTCHECK,
    		e_applyAuxFunConstraintCheck, sourceObject, expected, new ErrorInformation[] {new ErrorInformation(sourceObject), new ErrorInformation(expected)});
    	return false;
    }
  }

  protected Boolean applyAuxFunConstraintCheck(final RuleApplicationTrace _trace_, final RosettaExpression sourceObject, final RosettaCardinality expected) throws RuleFailedException {
    RListType actual = null;
    /* empty |- sourceObject : actual or actual = null */
    {
      RuleFailedException previousFailure = null;
      try {
        /* empty |- sourceObject : actual */
        Result<RListType> result = inferTypeInternal(emptyEnvironment(), _trace_, sourceObject);
        checkAssignableTo(result.getFirst(), RListType.class);
        actual = (RListType) result.getFirst();
        
      } catch (Exception e) {
        previousFailure = extractRuleFailedException(e);
        actual = null;
      }
    }
    if (((expected != null) && (actual != null))) {
      /* expected.constraintEquals(actual.constraint) or fail error notConstraintMessage(expected, actual) source sourceObject */
      {
        RuleFailedException previousFailure = null;
        try {
          boolean _constraintEquals = expected.constraintEquals(actual.getConstraint());
          /* expected.constraintEquals(actual.constraint) */
          if (!_constraintEquals) {
            sneakyThrowRuleFailedException("expected.constraintEquals(actual.constraint)");
          }
        } catch (Exception e_1) {
          previousFailure = extractRuleFailedException(e_1);
          /* fail error notConstraintMessage(expected, actual) source sourceObject */
          String _notConstraintMessage = this.util.notConstraintMessage(expected, actual);
          String error = _notConstraintMessage;
          EObject source = sourceObject;
          throwForExplicitFail(error, new ErrorInformation(source, null));
        }
      }
    }
    return true;
  }

  protected Boolean looseConstraintCheckImpl(final RuleApplicationTrace _trace_, final RosettaExpression sourceObject, final RosettaCardinality expected) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Boolean _result_ = applyAuxFunLooseConstraintCheck(_subtrace_, sourceObject, expected);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("looseConstraintCheck") + "(" + stringRep(sourceObject) + ", " + stringRep(expected)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunLooseConstraintCheck) {
    	looseConstraintCheckThrowException(auxFunName("looseConstraintCheck") + "(" + stringRep(sourceObject) + ", " + stringRep(expected)+ ")",
    		LOOSECONSTRAINTCHECK,
    		e_applyAuxFunLooseConstraintCheck, sourceObject, expected, new ErrorInformation[] {new ErrorInformation(sourceObject), new ErrorInformation(expected)});
    	return false;
    }
  }

  protected Boolean applyAuxFunLooseConstraintCheck(final RuleApplicationTrace _trace_, final RosettaExpression sourceObject, final RosettaCardinality expected) throws RuleFailedException {
    RListType actual = null;
    /* empty |- sourceObject : actual or actual = null */
    {
      RuleFailedException previousFailure = null;
      try {
        /* empty |- sourceObject : actual */
        Result<RListType> result = inferTypeInternal(emptyEnvironment(), _trace_, sourceObject);
        checkAssignableTo(result.getFirst(), RListType.class);
        actual = (RListType) result.getFirst();
        
      } catch (Exception e) {
        previousFailure = extractRuleFailedException(e);
        actual = null;
      }
    }
    if (((expected != null) && (actual != null))) {
      /* expected.isSubconstraintOf(actual.constraint) or fail error notConstraintMessage(expected, actual) source sourceObject */
      {
        RuleFailedException previousFailure = null;
        try {
          boolean _isSubconstraintOf = expected.isSubconstraintOf(actual.getConstraint());
          /* expected.isSubconstraintOf(actual.constraint) */
          if (!_isSubconstraintOf) {
            sneakyThrowRuleFailedException("expected.isSubconstraintOf(actual.constraint)");
          }
        } catch (Exception e_1) {
          previousFailure = extractRuleFailedException(e_1);
          /* fail error notConstraintMessage(expected, actual) source sourceObject */
          String _notConstraintMessage = this.util.notConstraintMessage(expected, actual);
          String error = _notConstraintMessage;
          EObject source = sourceObject;
          throwForExplicitFail(error, new ErrorInformation(source, null));
        }
      }
    }
    return true;
  }

  protected Boolean notConstraintCheckImpl(final RuleApplicationTrace _trace_, final RosettaExpression sourceObject, final RosettaCardinality notExpected) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Boolean _result_ = applyAuxFunNotConstraintCheck(_subtrace_, sourceObject, notExpected);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("notConstraintCheck") + "(" + stringRep(sourceObject) + ", " + stringRep(notExpected)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunNotConstraintCheck) {
    	notConstraintCheckThrowException(auxFunName("notConstraintCheck") + "(" + stringRep(sourceObject) + ", " + stringRep(notExpected)+ ")",
    		NOTCONSTRAINTCHECK,
    		e_applyAuxFunNotConstraintCheck, sourceObject, notExpected, new ErrorInformation[] {new ErrorInformation(sourceObject), new ErrorInformation(notExpected)});
    	return false;
    }
  }

  protected Boolean applyAuxFunNotConstraintCheck(final RuleApplicationTrace _trace_, final RosettaExpression sourceObject, final RosettaCardinality notExpected) throws RuleFailedException {
    RListType actual = null;
    /* empty |- sourceObject : actual or actual = null */
    {
      RuleFailedException previousFailure = null;
      try {
        /* empty |- sourceObject : actual */
        Result<RListType> result = inferTypeInternal(emptyEnvironment(), _trace_, sourceObject);
        checkAssignableTo(result.getFirst(), RListType.class);
        actual = (RListType) result.getFirst();
        
      } catch (Exception e) {
        previousFailure = extractRuleFailedException(e);
        actual = null;
      }
    }
    if (((notExpected != null) && (actual != null))) {
      /* !notExpected.constraintEquals(actual.constraint) or fail error wrongConstraintMessage(notExpected, actual) source sourceObject */
      {
        RuleFailedException previousFailure = null;
        try {
          boolean _constraintEquals = notExpected.constraintEquals(actual.getConstraint());
          boolean _not = (!_constraintEquals);
          /* !notExpected.constraintEquals(actual.constraint) */
          if (!_not) {
            sneakyThrowRuleFailedException("!notExpected.constraintEquals(actual.constraint)");
          }
        } catch (Exception e_1) {
          previousFailure = extractRuleFailedException(e_1);
          /* fail error wrongConstraintMessage(notExpected, actual) source sourceObject */
          String _wrongConstraintMessage = this.util.wrongConstraintMessage(notExpected, actual);
          String error = _wrongConstraintMessage;
          EObject source = sourceObject;
          throwForExplicitFail(error, new ErrorInformation(source, null));
        }
      }
    }
    return true;
  }

  protected Boolean isLooserConstraintCheckImpl(final RuleApplicationTrace _trace_, final RosettaExpression sourceObject, final RosettaCardinality expected) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Boolean _result_ = applyAuxFunIsLooserConstraintCheck(_subtrace_, sourceObject, expected);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("isLooserConstraintCheck") + "(" + stringRep(sourceObject) + ", " + stringRep(expected)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunIsLooserConstraintCheck) {
    	isLooserConstraintCheckThrowException(auxFunName("isLooserConstraintCheck") + "(" + stringRep(sourceObject) + ", " + stringRep(expected)+ ")",
    		ISLOOSERCONSTRAINTCHECK,
    		e_applyAuxFunIsLooserConstraintCheck, sourceObject, expected, new ErrorInformation[] {new ErrorInformation(sourceObject), new ErrorInformation(expected)});
    	return false;
    }
  }

  protected Boolean applyAuxFunIsLooserConstraintCheck(final RuleApplicationTrace _trace_, final RosettaExpression sourceObject, final RosettaCardinality expected) throws RuleFailedException {
    RListType actual = null;
    /* empty |- sourceObject : actual or actual = null */
    {
      RuleFailedException previousFailure = null;
      try {
        /* empty |- sourceObject : actual */
        Result<RListType> result = inferTypeInternal(emptyEnvironment(), _trace_, sourceObject);
        checkAssignableTo(result.getFirst(), RListType.class);
        actual = (RListType) result.getFirst();
        
      } catch (Exception e) {
        previousFailure = extractRuleFailedException(e);
        actual = null;
      }
    }
    if (((expected != null) && (actual != null))) {
      /* expected.isSubconstraintOf(actual.constraint) or fail error notLooserConstraintMessage(expected, actual) source sourceObject */
      {
        RuleFailedException previousFailure = null;
        try {
          boolean _isSubconstraintOf = expected.isSubconstraintOf(actual.getConstraint());
          /* expected.isSubconstraintOf(actual.constraint) */
          if (!_isSubconstraintOf) {
            sneakyThrowRuleFailedException("expected.isSubconstraintOf(actual.constraint)");
          }
        } catch (Exception e_1) {
          previousFailure = extractRuleFailedException(e_1);
          /* fail error notLooserConstraintMessage(expected, actual) source sourceObject */
          String _notLooserConstraintMessage = this.util.notLooserConstraintMessage(expected, actual);
          String error = _notLooserConstraintMessage;
          EObject source = sourceObject;
          throwForExplicitFail(error, new ErrorInformation(source, null));
        }
      }
    }
    return true;
  }
}
