package com.regnosys.rosetta.utils;

import com.google.common.base.Objects;
import com.regnosys.rosetta.RosettaExtensions;
import com.regnosys.rosetta.rosetta.RosettaPackage;
import com.regnosys.rosetta.rosetta.RosettaQualifiableConfiguration;
import com.regnosys.rosetta.rosetta.RosettaQualifiableType;
import com.regnosys.rosetta.rosetta.RosettaType;
import com.regnosys.rosetta.rosetta.simple.Data;
import javax.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescriptionsProvider;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class RosettaConfigExtension {
  @Inject
  private IResourceDescriptionsProvider index;

  @Inject
  @Extension
  private RosettaExtensions _rosettaExtensions;

  public boolean isRootEventOrProduct(final RosettaType type) {
    return ((type.getName() != null) && (Objects.equal(type, this.findEventRootName(type)) || Objects.equal(type, this.findProductRootName(type))));
  }

  public Data findProductRootName(final EObject ctx) {
    return this.findRosettaQualifiableConfiguration(ctx, RosettaQualifiableType.PRODUCT);
  }

  public Data findEventRootName(final EObject ctx) {
    return this.findRosettaQualifiableConfiguration(ctx, RosettaQualifiableType.EVENT);
  }

  public Iterable<IEObjectDescription> findMetaTypes(final EObject ctx) {
    final Function1<IEObjectDescription, Boolean> _function = (IEObjectDescription it) -> {
      return Boolean.valueOf(this._rosettaExtensions.isProjectLocal(ctx.eResource().getURI(), it.getEObjectURI()));
    };
    return IterableExtensions.<IEObjectDescription>filter(this.index.getResourceDescriptions(ctx.eResource().getResourceSet()).getExportedObjectsByType(RosettaPackage.Literals.ROSETTA_META_TYPE), _function);
  }

  /**
   * Can return <code>null</code> if any found
   * @param ctx Context to resolve proxies
   * @param type type for look up EVENT or PRODUCT
   * 
   * @returns a class name which is configured as root for the passed <code>RosettaQualifiableType</code>
   */
  private Data findRosettaQualifiableConfiguration(final EObject ctx, final RosettaQualifiableType type) {
    final Function1<IEObjectDescription, Boolean> _function = (IEObjectDescription it) -> {
      return Boolean.valueOf(this._rosettaExtensions.isProjectLocal(ctx.eResource().getURI(), it.getEObjectURI()));
    };
    final Function1<IEObjectDescription, Data> _function_1 = (IEObjectDescription it) -> {
      Data _xblockexpression = null;
      {
        EObject _xifexpression = null;
        boolean _eIsProxy = it.getEObjectOrProxy().eIsProxy();
        if (_eIsProxy) {
          _xifexpression = EcoreUtil.resolve(it.getEObjectOrProxy(), ctx);
        } else {
          _xifexpression = it.getEObjectOrProxy();
        }
        final EObject eObj = _xifexpression;
        Data _xifexpression_1 = null;
        if ((this._rosettaExtensions.isResolved(eObj) && (type == ((RosettaQualifiableConfiguration) eObj).getQType()))) {
          _xifexpression_1 = ((RosettaQualifiableConfiguration) eObj).getRosettaClass();
        }
        _xblockexpression = _xifexpression_1;
      }
      return _xblockexpression;
    };
    return IterableExtensions.<Data>head(IterableExtensions.<Data>filterNull(IterableExtensions.<IEObjectDescription, Data>map(IterableExtensions.<IEObjectDescription>filter(this.index.getResourceDescriptions(ctx.eResource().getResourceSet()).getExportedObjectsByType(
      RosettaPackage.Literals.ROSETTA_QUALIFIABLE_CONFIGURATION), _function), _function_1)));
  }
}
