package com.regnosys.rosetta.formatting2;

import com.google.common.base.Objects;
import com.regnosys.rosetta.rosetta.expression.ArithmeticOperation;
import com.regnosys.rosetta.rosetta.expression.ChoiceOperation;
import com.regnosys.rosetta.rosetta.expression.ClosureParameter;
import com.regnosys.rosetta.rosetta.expression.ComparisonOperation;
import com.regnosys.rosetta.rosetta.expression.ConstructorKeyValuePair;
import com.regnosys.rosetta.rosetta.expression.ExpressionPackage;
import com.regnosys.rosetta.rosetta.expression.InlineFunction;
import com.regnosys.rosetta.rosetta.expression.ListLiteral;
import com.regnosys.rosetta.rosetta.expression.ModifiableBinaryOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaAbsentExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaBinaryOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaConditionalExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaConstructorExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaDeepFeatureCall;
import com.regnosys.rosetta.rosetta.expression.RosettaExistsExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaFeatureCall;
import com.regnosys.rosetta.rosetta.expression.RosettaFunctionalOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaImplicitVariable;
import com.regnosys.rosetta.rosetta.expression.RosettaLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaOnlyExistsExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaSymbolReference;
import com.regnosys.rosetta.rosetta.expression.RosettaUnaryOperation;
import com.regnosys.rosetta.rosetta.expression.ThenOperation;
import com.regnosys.rosetta.services.RosettaGrammarAccess;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.formatting2.FormatterRequest;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatter;
import org.eclipse.xtext.formatting2.regionaccess.IEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@SuppressWarnings("all")
public class RosettaExpressionFormatter extends AbstractRosettaFormatter2 {
  @Inject
  @Extension
  private RosettaGrammarAccess _rosettaGrammarAccess;

  @Inject
  @Extension
  private FormattingUtil _formattingUtil;

  private boolean isSimple(final RosettaExpression expr) {
    boolean _switchResult = false;
    boolean _matched = false;
    if (expr instanceof RosettaLiteral) {
      _matched=true;
      _switchResult = true;
    }
    if (!_matched) {
      if (expr instanceof RosettaImplicitVariable) {
        _matched=true;
        _switchResult = true;
      }
    }
    if (!_matched) {
      if (expr instanceof RosettaSymbolReference) {
        _matched=true;
        boolean _isExplicitArguments = ((RosettaSymbolReference)expr).isExplicitArguments();
        _switchResult = (!_isExplicitArguments);
      }
    }
    if (!_matched) {
      if (expr instanceof RosettaFeatureCall) {
        _matched=true;
        _switchResult = true;
      }
    }
    if (!_matched) {
      if (expr instanceof ArithmeticOperation) {
        _matched=true;
        _switchResult = true;
      }
    }
    if (!_matched) {
      if (expr instanceof ComparisonOperation) {
        _matched=true;
        _switchResult = true;
      }
    }
    if (!_matched) {
      _switchResult = false;
    }
    return _switchResult;
  }

  private boolean shouldBeOnSingleLine(final RosettaExpression expr) {
    boolean _xblockexpression = false;
    {
      boolean _isSimple = this.isSimple(expr);
      if (_isSimple) {
        return true;
      }
      boolean _switchResult = false;
      boolean _matched = false;
      if (expr instanceof RosettaBinaryOperation) {
        _matched=true;
        _switchResult = (this.isSimple(((RosettaBinaryOperation)expr).getLeft()) || this.isSimple(((RosettaBinaryOperation)expr).getRight()));
      }
      if (!_matched) {
        if (expr instanceof RosettaFunctionalOperation) {
          _matched=true;
          _switchResult = ((((RosettaFunctionalOperation)expr).getFunction() == null) && this.isSimple(((RosettaFunctionalOperation)expr).getArgument()));
        }
      }
      if (!_matched) {
        if (expr instanceof RosettaUnaryOperation) {
          _matched=true;
          _switchResult = this.isSimple(((RosettaUnaryOperation)expr).getArgument());
        }
      }
      if (!_matched) {
        if (expr instanceof ListLiteral) {
          _matched=true;
          final Function1<RosettaExpression, Boolean> _function = (RosettaExpression it) -> {
            return Boolean.valueOf(this.isSimple(it));
          };
          _switchResult = IterableExtensions.<RosettaExpression>forall(((ListLiteral)expr).getElements(), _function);
        }
      }
      if (!_matched) {
        _switchResult = false;
      }
      _xblockexpression = _switchResult;
    }
    return _xblockexpression;
  }

  private boolean isEmpty(final RosettaExpression expr) {
    return ((expr == null) || expr.isGenerated());
  }

  @Override
  public void initialize(final FormatterRequest request) {
    super.initialize(request);
  }

  @Override
  public void format(final Object obj, final IFormattableDocument document) {
    boolean _matched = false;
    if (obj instanceof RosettaExpression) {
      _matched=true;
      this.formatExpression(((RosettaExpression)obj), document);
    }
    if (!_matched) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append(RosettaExpressionFormatter.class);
      _builder.append(" does not support formatting ");
      _builder.append(obj);
      _builder.append(".");
      throw new UnsupportedOperationException(_builder.toString());
    }
  }

  public void formatExpression(final RosettaExpression expr, final IFormattableDocument document) {
    this.formatExpression(expr, document, FormattingMode.NORMAL);
  }

  public void formatExpression(final RosettaExpression expr, @Extension final IFormattableDocument document, final FormattingMode mode) {
    boolean _isGenerated = expr.isGenerated();
    boolean _not = (!_isGenerated);
    if (_not) {
      final ISemanticRegion leftParenthesis = this.textRegionExtensions.regionFor(expr).keyword(this._rosettaGrammarAccess.getRosettaCalcPrimaryAccess().getLeftParenthesisKeyword_7_0());
      final ISemanticRegion rightParenthesis = this.textRegionExtensions.regionFor(expr).keyword(this._rosettaGrammarAccess.getRosettaCalcPrimaryAccess().getRightParenthesisKeyword_7_2());
      if (((leftParenthesis != null) && (rightParenthesis != null))) {
        final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
          it.noSpace();
        };
        document.append(leftParenthesis, _function);
        final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
          it.noSpace();
        };
        document.prepend(rightParenthesis, _function_1);
        boolean _isMultiline = this.textRegionExtensions.isMultiline(expr);
        boolean _not_1 = (!_isMultiline);
        if (_not_1) {
          this.unsafeFormatExpression(expr, document, FormattingMode.SINGLE_LINE);
        } else {
          this.unsafeFormatExpression(expr, document, mode.stopChain());
        }
      } else {
        this.unsafeFormatExpression(expr, document, mode);
      }
    }
  }

  private void _unsafeFormatExpression(final RosettaConstructorExpression expr, @Extension final IFormattableDocument document, final FormattingMode mode) {
    @Extension
    final RosettaGrammarAccess.RosettaCalcConstructorExpressionElements constructorGrammarAccess = this._rosettaGrammarAccess.getRosettaCalcConstructorExpressionAccess();
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
      it.indent();
    };
    document.<ISemanticRegion, ISemanticRegion>interior(
      document.append(document.prepend(this.textRegionExtensions.regionFor(expr).keyword(constructorGrammarAccess.getLeftCurlyBracketKeyword_2()), _function), _function_1), 
      document.prepend(this.textRegionExtensions.regionFor(expr).keyword(constructorGrammarAccess.getRightCurlyBracketKeyword_4()), _function_2), _function_3);
    final Consumer<ISemanticRegion> _function_4 = (ISemanticRegion it) -> {
      final Procedure1<IHiddenRegionFormatter> _function_5 = (IHiddenRegionFormatter it_1) -> {
        it_1.noSpace();
      };
      document.prepend(it, _function_5);
      final Procedure1<IHiddenRegionFormatter> _function_6 = (IHiddenRegionFormatter it_1) -> {
        it_1.newLine();
      };
      document.append(it, _function_6);
    };
    this.textRegionExtensions.regionFor(expr).keywords(",").forEach(_function_4);
    final Consumer<ConstructorKeyValuePair> _function_5 = (ConstructorKeyValuePair it) -> {
      this._formattingUtil.indentInner(it, document);
      final Procedure1<IHiddenRegionFormatter> _function_6 = (IHiddenRegionFormatter it_1) -> {
        it_1.noSpace();
      };
      final Procedure1<IHiddenRegionFormatter> _function_7 = (IHiddenRegionFormatter it_1) -> {
        it_1.oneSpace();
      };
      document.append(document.prepend(this.textRegionExtensions.regionFor(it).keyword(":"), _function_6), _function_7);
      this.formatExpression(it.getValue(), document, mode);
    };
    expr.getValues().forEach(_function_5);
  }

  private void _unsafeFormatExpression(final ListLiteral expr, @Extension final IFormattableDocument document, final FormattingMode mode) {
    final Consumer<ISemanticRegion> _function = (ISemanticRegion it) -> {
      final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it_1) -> {
        it_1.noSpace();
      };
      document.prepend(it, _function_1);
    };
    this.textRegionExtensions.regionFor(expr).keywords(",").forEach(_function);
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.indent();
    };
    document.<ISemanticRegion, ISemanticRegion>interior(
      this.textRegionExtensions.regionFor(expr).keyword("["), 
      this.textRegionExtensions.regionFor(expr).keyword("]"), _function_1);
    final Consumer<IFormattableDocument> _function_2 = (IFormattableDocument doc) -> {
      final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
        it.noSpace();
      };
      doc.append(this.textRegionExtensions.regionFor(expr).keyword("["), _function_3);
      final Procedure1<IHiddenRegionFormatter> _function_4 = (IHiddenRegionFormatter it) -> {
        it.noSpace();
      };
      doc.prepend(this.textRegionExtensions.regionFor(expr).keyword("]"), _function_4);
      final Consumer<ISemanticRegion> _function_5 = (ISemanticRegion it) -> {
        final Procedure1<IHiddenRegionFormatter> _function_6 = (IHiddenRegionFormatter it_1) -> {
          it_1.oneSpace();
        };
        doc.append(it, _function_6);
      };
      this.textRegionExtensions.regionFor(expr).keywords(",").forEach(_function_5);
      final Consumer<RosettaExpression> _function_6 = (RosettaExpression it) -> {
        this.formatExpression(it, doc, mode);
      };
      expr.getElements().forEach(_function_6);
    };
    final Consumer<IFormattableDocument> _function_3 = (IFormattableDocument doc) -> {
      final Procedure1<IHiddenRegionFormatter> _function_4 = (IHiddenRegionFormatter it) -> {
        it.newLine();
      };
      doc.append(this.textRegionExtensions.regionFor(expr).keyword("["), _function_4);
      final Procedure1<IHiddenRegionFormatter> _function_5 = (IHiddenRegionFormatter it) -> {
        it.newLine();
      };
      doc.<RosettaExpression>append(IterableExtensions.<RosettaExpression>last(expr.getElements()), _function_5);
      final Consumer<ISemanticRegion> _function_6 = (ISemanticRegion it) -> {
        final Procedure1<IHiddenRegionFormatter> _function_7 = (IHiddenRegionFormatter it_1) -> {
          it_1.newLine();
        };
        doc.append(it, _function_7);
      };
      this.textRegionExtensions.regionFor(expr).keywords(",").forEach(_function_6);
      final Consumer<RosettaExpression> _function_7 = (RosettaExpression it) -> {
        this.formatExpression(it, doc, mode.stopChain());
      };
      expr.getElements().forEach(_function_7);
    };
    this._formattingUtil.formatInlineOrMultiline(document, expr, mode.singleLineIf(this.shouldBeOnSingleLine(expr)), _function_2, _function_3);
  }

  private void _unsafeFormatExpression(final RosettaConditionalExpression expr, @Extension final IFormattableDocument document, final FormattingMode mode) {
    @Extension
    final RosettaGrammarAccess.RosettaCalcConditionalExpressionElements conditionalGrammarAccess = this._rosettaGrammarAccess.getRosettaCalcConditionalExpressionAccess();
    final Consumer<ISemanticRegion> _function = (ISemanticRegion it) -> {
      final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it_1) -> {
        it_1.oneSpace();
      };
      document.append(it, _function_1);
    };
    this.textRegionExtensions.regionFor(expr).keywords(conditionalGrammarAccess.getIfKeyword_1(), conditionalGrammarAccess.getThenKeyword_3(), conditionalGrammarAccess.getFullElseKeyword_5_0_0()).forEach(_function);
    RosettaExpression _if = expr.getIf();
    RosettaExpression _ifthen = expr.getIfthen();
    RosettaExpression _elsethen = expr.getElsethen();
    final List<RosettaExpression> subExprs = Collections.<RosettaExpression>unmodifiableList(CollectionLiterals.<RosettaExpression>newArrayList(_if, _ifthen, _elsethen));
    RosettaExpression _if_1 = expr.getIf();
    RosettaExpression _ifthen_1 = expr.getIfthen();
    final Consumer<RosettaExpression> _function_1 = (RosettaExpression it) -> {
      if ((!(it instanceof RosettaUnaryOperation))) {
        final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it_1) -> {
          it_1.indent();
        };
        document.<RosettaExpression>surround(it, _function_2);
      }
    };
    Collections.<RosettaExpression>unmodifiableList(CollectionLiterals.<RosettaExpression>newArrayList(_if_1, _ifthen_1)).forEach(_function_1);
    final Consumer<IFormattableDocument> _function_2 = (IFormattableDocument doc) -> {
      final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
        it.oneSpace();
      };
      doc.prepend(this.textRegionExtensions.regionFor(expr).keyword(conditionalGrammarAccess.getThenKeyword_3()), _function_3);
      final Procedure1<IHiddenRegionFormatter> _function_4 = (IHiddenRegionFormatter it) -> {
        it.oneSpace();
      };
      doc.prepend(this.textRegionExtensions.regionFor(expr).keyword(conditionalGrammarAccess.getFullElseKeyword_5_0_0()), _function_4);
      final Consumer<RosettaExpression> _function_5 = (RosettaExpression it) -> {
        this.formatExpression(it, doc, mode);
      };
      subExprs.forEach(_function_5);
    };
    final Consumer<IFormattableDocument> _function_3 = (IFormattableDocument doc) -> {
      final Procedure1<IHiddenRegionFormatter> _function_4 = (IHiddenRegionFormatter it) -> {
        it.newLine();
      };
      doc.prepend(this.textRegionExtensions.regionFor(expr).keyword(conditionalGrammarAccess.getThenKeyword_3()), _function_4);
      final Procedure1<IHiddenRegionFormatter> _function_5 = (IHiddenRegionFormatter it) -> {
        it.newLine();
      };
      doc.prepend(this.textRegionExtensions.regionFor(expr).keyword(conditionalGrammarAccess.getFullElseKeyword_5_0_0()), _function_5);
      EStructuralFeature _eContainingFeature = expr.eContainingFeature();
      boolean _equals = Objects.equal(_eContainingFeature, ExpressionPackage.Literals.ROSETTA_BINARY_OPERATION__RIGHT);
      if (_equals) {
        this._formattingUtil.indentInner(expr, doc);
      }
      this.formatExpression(expr.getIf(), doc, mode.stopChain());
      this.formatExpression(expr.getIfthen(), doc, mode.stopChain());
      RosettaExpression _elsethen_1 = expr.getElsethen();
      this.formatExpression(expr.getElsethen(), doc, mode.chainIf((_elsethen_1 instanceof RosettaConditionalExpression)));
    };
    this._formattingUtil.formatInlineOrMultiline(document, expr, mode.singleLineIf(this.shouldBeOnSingleLine(expr)), (this._formattingUtil.<Integer>getPreference(document, RosettaFormatterPreferenceKeys.conditionalMaxLineWidth)).intValue(), _function_2, _function_3);
  }

  private void _unsafeFormatExpression(final RosettaFeatureCall expr, @Extension final IFormattableDocument document, final FormattingMode mode) {
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    document.surround(this.textRegionExtensions.regionFor(expr).keyword("->"), _function);
    this.formatExpression(expr.getReceiver(), document, mode.stopChain());
  }

  private void _unsafeFormatExpression(final RosettaDeepFeatureCall expr, @Extension final IFormattableDocument document, final FormattingMode mode) {
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    document.surround(this.textRegionExtensions.regionFor(expr).keyword("->>"), _function);
    this.formatExpression(expr.getReceiver(), document, mode.stopChain());
  }

  private void _unsafeFormatExpression(final RosettaLiteral expr, @Extension final IFormattableDocument document, final FormattingMode mode) {
  }

  private void _unsafeFormatExpression(final RosettaOnlyExistsExpression expr, @Extension final IFormattableDocument document, final FormattingMode mode) {
    @Extension
    final RosettaGrammarAccess.RosettaCalcOnlyExistsElements onlyExistsGrammarAccess = this._rosettaGrammarAccess.getRosettaCalcOnlyExistsAccess();
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.noSpace();
    };
    document.append(this.textRegionExtensions.regionFor(expr).keyword("("), _function);
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.noSpace();
    };
    document.prepend(this.textRegionExtensions.regionFor(expr).keyword(")"), _function_1);
    final Consumer<ISemanticRegion> _function_2 = (ISemanticRegion it) -> {
      final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it_1) -> {
        it_1.noSpace();
      };
      document.prepend(it, _function_3);
      final Procedure1<IHiddenRegionFormatter> _function_4 = (IHiddenRegionFormatter it_1) -> {
        it_1.oneSpace();
      };
      document.append(it, _function_4);
    };
    this.textRegionExtensions.regionFor(expr).keywords(",").forEach(_function_2);
    final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    document.prepend(this.textRegionExtensions.regionFor(expr).keyword(onlyExistsGrammarAccess.getOnlyKeyword_2()), _function_3);
    final Procedure1<IHiddenRegionFormatter> _function_4 = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    document.prepend(this.textRegionExtensions.regionFor(expr).keyword(onlyExistsGrammarAccess.getExistsKeyword_3()), _function_4);
    final Consumer<RosettaExpression> _function_5 = (RosettaExpression it) -> {
      this.formatExpression(it, document, mode.stopChain());
    };
    expr.getArgs().forEach(_function_5);
  }

  private void _unsafeFormatExpression(final RosettaImplicitVariable expr, @Extension final IFormattableDocument document, final FormattingMode mode) {
  }

  private void _unsafeFormatExpression(final RosettaSymbolReference expr, @Extension final IFormattableDocument document, final FormattingMode mode) {
    boolean _isExplicitArguments = expr.isExplicitArguments();
    if (_isExplicitArguments) {
      final Consumer<ISemanticRegion> _function = (ISemanticRegion it) -> {
        final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it_1) -> {
          it_1.noSpace();
        };
        document.prepend(it, _function_1);
      };
      this.textRegionExtensions.regionFor(expr).keywords(",").forEach(_function);
      final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
        it.noSpace();
      };
      document.prepend(this.textRegionExtensions.regionFor(expr).keyword("("), _function_1);
      final Consumer<IFormattableDocument> _function_2 = (IFormattableDocument doc) -> {
        final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
          it.noSpace();
        };
        doc.append(this.textRegionExtensions.regionFor(expr).keyword("("), _function_3);
        final Procedure1<IHiddenRegionFormatter> _function_4 = (IHiddenRegionFormatter it) -> {
          it.noSpace();
        };
        doc.prepend(this.textRegionExtensions.regionFor(expr).keyword(")"), _function_4);
        final Consumer<ISemanticRegion> _function_5 = (ISemanticRegion it) -> {
          final Procedure1<IHiddenRegionFormatter> _function_6 = (IHiddenRegionFormatter it_1) -> {
            it_1.oneSpace();
          };
          doc.append(it, _function_6);
        };
        this.textRegionExtensions.regionFor(expr).keywords(",").forEach(_function_5);
        final Consumer<RosettaExpression> _function_6 = (RosettaExpression it) -> {
          this.formatExpression(it, doc, mode);
        };
        expr.getArgs().forEach(_function_6);
      };
      final Consumer<IFormattableDocument> _function_3 = (IFormattableDocument doc) -> {
        this._formattingUtil.indentInner(expr, doc);
        final Procedure1<IHiddenRegionFormatter> _function_4 = (IHiddenRegionFormatter it) -> {
          it.newLine();
        };
        final Procedure1<IHiddenRegionFormatter> _function_5 = (IHiddenRegionFormatter it) -> {
          it.newLine();
        };
        final Procedure1<IHiddenRegionFormatter> _function_6 = (IHiddenRegionFormatter it) -> {
          it.indent();
        };
        doc.<ISemanticRegion, ISemanticRegion>interior(
          doc.append(this.textRegionExtensions.regionFor(expr).keyword("("), _function_4), 
          doc.prepend(this.textRegionExtensions.regionFor(expr).keyword(")"), _function_5), _function_6);
        final Consumer<ISemanticRegion> _function_7 = (ISemanticRegion it) -> {
          final Procedure1<IHiddenRegionFormatter> _function_8 = (IHiddenRegionFormatter it_1) -> {
            it_1.newLine();
          };
          doc.append(it, _function_8);
        };
        this.textRegionExtensions.regionFor(expr).keywords(",").forEach(_function_7);
        final Consumer<RosettaExpression> _function_8 = (RosettaExpression it) -> {
          this.formatExpression(it, doc, mode.stopChain());
        };
        expr.getArgs().forEach(_function_8);
      };
      this._formattingUtil.formatInlineOrMultiline(document, expr, mode.singleLineIf(this.shouldBeOnSingleLine(expr)), _function_2, _function_3);
    }
  }

  private void _unsafeFormatExpression(final ModifiableBinaryOperation expr, @Extension final IFormattableDocument document, final FormattingMode mode) {
    this.formatBinaryOperation(expr, document, mode);
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    document.append(this.textRegionExtensions.regionFor(expr).feature(ExpressionPackage.Literals.MODIFIABLE_BINARY_OPERATION__CARD_MOD), _function);
  }

  private void _unsafeFormatExpression(final RosettaBinaryOperation expr, @Extension final IFormattableDocument document, final FormattingMode mode) {
    this.formatBinaryOperation(expr, document, mode);
  }

  private void formatBinaryOperation(final RosettaBinaryOperation expr, @Extension final IFormattableDocument document, final FormattingMode mode) {
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    document.append(this.textRegionExtensions.regionFor(expr).feature(ExpressionPackage.Literals.ROSETTA_OPERATION__OPERATOR), _function);
    final Consumer<IFormattableDocument> _function_1 = (IFormattableDocument doc) -> {
      boolean _isEmpty = this.isEmpty(expr.getLeft());
      boolean _not = (!_isEmpty);
      if (_not) {
        final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
          it.oneSpace();
        };
        doc.set(this.textRegionExtensions.nextHiddenRegion(expr.getLeft()), _function_2);
        this.formatExpression(expr.getLeft(), doc, mode);
      }
      this.formatExpression(expr.getRight(), doc, mode);
    };
    final Consumer<IFormattableDocument> _function_2 = (IFormattableDocument doc) -> {
      boolean _isEmpty = this.isEmpty(expr.getLeft());
      boolean _not = (!_isEmpty);
      if (_not) {
        final IHiddenRegion afterArgument = this.textRegionExtensions.nextHiddenRegion(expr.getLeft());
        this._formattingUtil.indentInner(expr, afterArgument, doc);
        final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
          it.newLine();
        };
        doc.set(afterArgument, _function_3);
        boolean _xifexpression = false;
        RosettaExpression _left = expr.getLeft();
        if ((_left instanceof RosettaBinaryOperation)) {
          String _operator = expr.getOperator();
          RosettaExpression _left_1 = expr.getLeft();
          String _operator_1 = ((RosettaBinaryOperation) _left_1).getOperator();
          _xifexpression = Objects.equal(_operator, _operator_1);
        } else {
          _xifexpression = false;
        }
        final boolean leftIsSameOperation = _xifexpression;
        if (((expr.getLeft() instanceof RosettaBinaryOperation) && (!leftIsSameOperation))) {
          this._formattingUtil.indentInner(expr.getLeft(), doc);
        }
        this.formatExpression(expr.getLeft(), doc, mode.chainIf(leftIsSameOperation));
      }
      this.formatExpression(expr.getRight(), doc, mode.stopChain());
    };
    this._formattingUtil.formatInlineOrMultiline(document, expr, mode.singleLineIf(this.shouldBeOnSingleLine(expr)), _function_1, _function_2);
  }

  private void _unsafeFormatExpression(final RosettaFunctionalOperation expr, @Extension final IFormattableDocument document, final FormattingMode mode) {
    final Procedure1<IFormattableDocument> _function = (IFormattableDocument doc) -> {
      InlineFunction _function_1 = expr.getFunction();
      boolean _tripleNotEquals = (_function_1 != null);
      if (_tripleNotEquals) {
        this.formatInlineFunction(expr.getFunction(), doc, mode.stopChain());
      }
    };
    this.formatUnaryOperation(expr, document, mode, _function);
  }

  private void formatInlineFunction(final InlineFunction f, @Extension final IFormattableDocument document, final FormattingMode mode) {
    EObject _eContainer = f.eContainer();
    final RosettaFunctionalOperation op = ((RosettaFunctionalOperation) _eContainer);
    final ISemanticRegion left = this.textRegionExtensions.regionFor(f).keyword("[");
    if ((left != null)) {
      final ISemanticRegion right = this.textRegionExtensions.regionFor(f).keyword("]");
      final Consumer<ClosureParameter> _function = (ClosureParameter it) -> {
        final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it_1) -> {
          it_1.oneSpace();
        };
        document.<ClosureParameter>prepend(it, _function_1);
      };
      f.getParameters().forEach(_function);
      final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
        it.oneSpace();
      };
      document.prepend(left, _function_1);
      final Consumer<ISemanticRegion> _function_2 = (ISemanticRegion it) -> {
        final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it_1) -> {
          it_1.noSpace();
        };
        document.prepend(it, _function_3);
      };
      this.textRegionExtensions.regionFor(f).keywords(",").forEach(_function_2);
      final Consumer<IFormattableDocument> _function_3 = (IFormattableDocument doc) -> {
        final Procedure1<IHiddenRegionFormatter> _function_4 = (IHiddenRegionFormatter it) -> {
          it.oneSpace();
        };
        doc.append(left, _function_4);
        final Procedure1<IHiddenRegionFormatter> _function_5 = (IHiddenRegionFormatter it) -> {
          it.oneSpace();
        };
        doc.prepend(right, _function_5);
        this.formatExpression(f.getBody(), doc, mode);
        EObject _eContainer_1 = op.eContainer();
        if ((_eContainer_1 instanceof RosettaOperation)) {
          final Procedure1<IHiddenRegionFormatter> _function_6 = (IHiddenRegionFormatter it) -> {
            it.highPriority();
            it.newLine();
          };
          doc.<InlineFunction>append(f, _function_6);
        }
      };
      final Consumer<IFormattableDocument> _function_4 = (IFormattableDocument doc) -> {
        final Procedure1<IHiddenRegionFormatter> _function_5 = (IHiddenRegionFormatter it) -> {
          it.newLine();
        };
        final Procedure1<IHiddenRegionFormatter> _function_6 = (IHiddenRegionFormatter it) -> {
          it.newLine();
        };
        final Procedure1<IHiddenRegionFormatter> _function_7 = (IHiddenRegionFormatter it) -> {
          it.indent();
        };
        doc.<ISemanticRegion, ISemanticRegion>interior(
          doc.append(left, _function_5), 
          doc.prepend(right, _function_6), _function_7);
        this.formatExpression(f.getBody(), doc, mode.stopChain());
      };
      this._formattingUtil.formatInlineOrMultiline(document, f, mode, _function_3, _function_4);
    } else {
      final IEObjectRegion astRegion = this.textRegionExtensions.regionForEObject(f);
      final ITextSegment formattableRegion = astRegion.merge(astRegion.getPreviousHiddenRegion()).merge(astRegion.getNextHiddenRegion());
      boolean _not = (!((op instanceof ThenOperation) && (f.getBody() instanceof RosettaUnaryOperation)));
      if (_not) {
        final Procedure1<IHiddenRegionFormatter> _function_5 = (IHiddenRegionFormatter it) -> {
          it.indent();
        };
        document.<RosettaExpression>surround(
          f.getBody(), _function_5);
      }
      final Consumer<IFormattableDocument> _function_6 = (IFormattableDocument doc) -> {
        final Procedure1<IHiddenRegionFormatter> _function_7 = (IHiddenRegionFormatter it) -> {
          it.oneSpace();
        };
        this.formatExpression(doc.<RosettaExpression>prepend(f.getBody(), _function_7), doc, mode);
        EObject _eContainer_1 = f.eContainer().eContainer();
        if ((_eContainer_1 instanceof RosettaOperation)) {
          final Procedure1<IHiddenRegionFormatter> _function_8 = (IHiddenRegionFormatter it) -> {
            it.highPriority();
            it.newLine();
          };
          doc.<InlineFunction>append(f, _function_8);
        }
      };
      final Consumer<IFormattableDocument> _function_7 = (IFormattableDocument doc) -> {
        final Procedure1<IHiddenRegionFormatter> _function_8 = (IHiddenRegionFormatter it) -> {
          it.newLine();
        };
        this.formatExpression(doc.<RosettaExpression>prepend(f.getBody(), _function_8), doc, mode);
      };
      this._formattingUtil.formatInlineOrMultiline(document, astRegion, formattableRegion, mode.singleLineIf((op instanceof ThenOperation)), _function_6, _function_7);
    }
  }

  private void _unsafeFormatExpression(final RosettaExistsExpression expr, @Extension final IFormattableDocument document, final FormattingMode mode) {
    final Procedure1<IFormattableDocument> _function = (IFormattableDocument it) -> {
    };
    this.formatUnaryOperation(expr, document, mode, _function);
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    document.append(this.textRegionExtensions.regionFor(expr).feature(ExpressionPackage.Literals.ROSETTA_EXISTS_EXPRESSION__MODIFIER), _function_1);
  }

  private void _unsafeFormatExpression(final ChoiceOperation expr, @Extension final IFormattableDocument document, final FormattingMode mode) {
    final Procedure1<IFormattableDocument> _function = (IFormattableDocument it) -> {
    };
    this.formatUnaryOperation(expr, document, mode, _function);
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    document.surround(this.textRegionExtensions.regionFor(expr).feature(ExpressionPackage.Literals.ROSETTA_OPERATION__OPERATOR), _function_1);
    final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
      it.noSpace();
    };
    final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    document.append(document.prepend(this.textRegionExtensions.allRegionsFor(expr).keyword(","), _function_2), _function_3);
  }

  private void _unsafeFormatExpression(final RosettaAbsentExpression expr, @Extension final IFormattableDocument document, final FormattingMode mode) {
    final Procedure1<IFormattableDocument> _function = (IFormattableDocument it) -> {
    };
    this.formatUnaryOperation(expr, document, mode, _function);
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    document.append(this.textRegionExtensions.regionFor(expr).keyword("is"), _function_1);
  }

  private void _unsafeFormatExpression(final RosettaUnaryOperation expr, @Extension final IFormattableDocument document, final FormattingMode mode) {
    final Procedure1<IFormattableDocument> _function = (IFormattableDocument it) -> {
    };
    this.formatUnaryOperation(expr, document, mode, _function);
  }

  private void formatUnaryOperation(final RosettaUnaryOperation expr, @Extension final IFormattableDocument document, final FormattingMode mode, final Procedure1<? super IFormattableDocument> internalFormatter) {
    final Consumer<IFormattableDocument> _function = (IFormattableDocument doc) -> {
      boolean _isEmpty = this.isEmpty(expr.getArgument());
      boolean _not = (!_isEmpty);
      if (_not) {
        final IHiddenRegion afterArgument = this.textRegionExtensions.nextHiddenRegion(expr.getArgument());
        final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
          it.oneSpace();
        };
        doc.set(afterArgument, _function_1);
        this.formatExpression(expr.getArgument(), doc, mode);
      }
      internalFormatter.apply(doc);
    };
    final Consumer<IFormattableDocument> _function_1 = (IFormattableDocument doc) -> {
      boolean _isEmpty = this.isEmpty(expr.getArgument());
      boolean _not = (!_isEmpty);
      if (_not) {
        final IHiddenRegion afterArgument = this.textRegionExtensions.nextHiddenRegion(expr.getArgument());
        RosettaExpression initialArgument = expr.getArgument();
        while ((initialArgument instanceof RosettaUnaryOperation)) {
          initialArgument = ((RosettaUnaryOperation)initialArgument).getArgument();
        }
        boolean _isEmpty_1 = this.isEmpty(initialArgument);
        boolean _not_1 = (!_isEmpty_1);
        if (_not_1) {
          this._formattingUtil.indentInner(expr, afterArgument, doc);
        }
        final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
          it.newLine();
        };
        doc.set(afterArgument, _function_2);
        RosettaExpression _argument = expr.getArgument();
        this.formatExpression(expr.getArgument(), doc, mode.chainIf((_argument instanceof RosettaUnaryOperation)));
      }
      internalFormatter.apply(doc);
    };
    this._formattingUtil.formatInlineOrMultiline(document, expr, mode.singleLineIf(this.shouldBeOnSingleLine(expr)), _function, _function_1);
  }

  private void unsafeFormatExpression(final RosettaExpression expr, final IFormattableDocument document, final FormattingMode mode) {
    if (expr instanceof ChoiceOperation) {
      _unsafeFormatExpression((ChoiceOperation)expr, document, mode);
      return;
    } else if (expr instanceof ModifiableBinaryOperation) {
      _unsafeFormatExpression((ModifiableBinaryOperation)expr, document, mode);
      return;
    } else if (expr instanceof RosettaAbsentExpression) {
      _unsafeFormatExpression((RosettaAbsentExpression)expr, document, mode);
      return;
    } else if (expr instanceof RosettaExistsExpression) {
      _unsafeFormatExpression((RosettaExistsExpression)expr, document, mode);
      return;
    } else if (expr instanceof RosettaFunctionalOperation) {
      _unsafeFormatExpression((RosettaFunctionalOperation)expr, document, mode);
      return;
    } else if (expr instanceof RosettaBinaryOperation) {
      _unsafeFormatExpression((RosettaBinaryOperation)expr, document, mode);
      return;
    } else if (expr instanceof RosettaImplicitVariable) {
      _unsafeFormatExpression((RosettaImplicitVariable)expr, document, mode);
      return;
    } else if (expr instanceof RosettaLiteral) {
      _unsafeFormatExpression((RosettaLiteral)expr, document, mode);
      return;
    } else if (expr instanceof RosettaSymbolReference) {
      _unsafeFormatExpression((RosettaSymbolReference)expr, document, mode);
      return;
    } else if (expr instanceof RosettaUnaryOperation) {
      _unsafeFormatExpression((RosettaUnaryOperation)expr, document, mode);
      return;
    } else if (expr instanceof ListLiteral) {
      _unsafeFormatExpression((ListLiteral)expr, document, mode);
      return;
    } else if (expr instanceof RosettaConditionalExpression) {
      _unsafeFormatExpression((RosettaConditionalExpression)expr, document, mode);
      return;
    } else if (expr instanceof RosettaConstructorExpression) {
      _unsafeFormatExpression((RosettaConstructorExpression)expr, document, mode);
      return;
    } else if (expr instanceof RosettaDeepFeatureCall) {
      _unsafeFormatExpression((RosettaDeepFeatureCall)expr, document, mode);
      return;
    } else if (expr instanceof RosettaFeatureCall) {
      _unsafeFormatExpression((RosettaFeatureCall)expr, document, mode);
      return;
    } else if (expr instanceof RosettaOnlyExistsExpression) {
      _unsafeFormatExpression((RosettaOnlyExistsExpression)expr, document, mode);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(expr, document, mode).toString());
    }
  }
}
